"""Blackpearl API tools package.

This package provides tools for interacting with the Blackpearl API.
"""

from automagik.tools.blackpearl.provider import BlackpearlProvider
from automagik.tools.blackpearl.tool import (
    get_clientes,
    get_cliente,
    create_cliente,
    update_cliente,
    delete_cliente,
    get_contatos,
    get_contato,
    create_contato,
    update_contato,
    delete_contato,
    get_vendedores,
    get_vendedor,
    create_vendedor,
    update_vendedor,
    get_produtos,
    get_produto,
    get_familias_de_produtos,
    get_familia_de_produto,
    get_marcas,
    get_marca,
    get_imagens_de_produto,
    get_pedidos,
    get_pedido,
    create_pedido,
    update_pedido,
    get_regras_frete,
    get_regra_frete,
    create_regra_frete,
    update_regra_frete,
    get_regras_negocio,
    get_regra_negocio,
    create_regra_negocio,
    update_regra_negocio,
    verificar_cnpj,
    finalizar_cadastro,
)

__all__ = [
    'BlackpearlProvider',
    'get_clientes',
    'get_cliente',
    'create_cliente',
    'update_cliente',
    'delete_cliente',
    'get_contatos',
    'get_contato',
    'create_contato',
    'update_contato',
    'delete_contato',
    'get_vendedores',
    'get_vendedor',
    'create_vendedor',
    'update_vendedor',
    'get_produtos',
    'get_produto',
    'get_familias_de_produtos',
    'get_familia_de_produto',
    'get_marcas',
    'get_marca',
    'get_imagens_de_produto',
    'get_pedidos',
    'get_pedido',
    'create_pedido',
    'update_pedido',
    'get_regras_frete',
    'get_regra_frete',
    'create_regra_frete',
    'update_regra_frete',
    'get_regras_negocio',
    'get_regra_negocio',
    'create_regra_negocio',
    'update_regra_negocio',
    'verificar_cnpj',
    'finalizar_cadastro',
] 