# ndpretty
> Your little helper to display numpy ndarrays in a pretty table in Jupyter notebooks.


Jupyter notebooks are a great way to develop. `ndpretty` makes it even better for people who use numpy by providing nice formatting of `ndarray`s.

## Install

`pip install ndpretty`

## How to use

```python
import ndpretty
import numpy as np
```

Display an ndarray using `ndarray_html()`:

```python
ndpretty.ndarray_html(np.random.rand(3, 4))
```

<img src="data:image/png;base64,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
" width="300px"/>

If you want all `np.ndarray`s and `torch.Tensor`s to be automatically formatted like this, load the default configuration:

```python
ndpretty.default()
```

After this line has been exectued, all cell outputs that are `np.ndarray` or `torch.Tensor` are automatically formatted by ndpretty.

```python
a = np.random.rand(10, 5)
a
```

    10×5 float64 ndarray

<img src="data:image/png;base64,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
" width="300px"/>

It works with all numpy dtypes, multi-dimensional arrays and PyTorch tensors.

Find more usage examples [here](https://deutschmn.github.io/ndpretty/ndpretty.html#Example-usages).

## Why?

Look at the [alternatives](https://deutschmn.github.io/ndpretty/alternatives.html).

## Author

Patrick Deutschmann ([patrick@deutschmann.xyz](mailto:patrick@deutschmann.xyz))
