# coding: utf-8

"""
Earnix Elevate Data API

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

The version of the OpenAPI document: 0.0.1
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""


from typing import List

from pydantic.v1 import Field, StrictInt, StrictStr, validate_arguments
from typing_extensions import Annotated

from earnix_elevate.clients.data.api_client import ApiClient
from earnix_elevate.clients.data.api_response import ApiResponse
from earnix_elevate.clients.data.exceptions import ApiTypeError
from earnix_elevate.clients.data.models.conversation_id_response import (
    ConversationIdResponse,
)
from earnix_elevate.clients.data.models.conversation_message_response import (
    ConversationMessageResponse,
)
from earnix_elevate.clients.data.models.conversation_response import (
    ConversationResponse,
)
from earnix_elevate.clients.data.models.user_message_request import UserMessageRequest


class AiAssistantServiceApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_arguments
    def get_active_conversation_id(
        self,
        dataset_node_id: Annotated[
            StrictInt,
            Field(
                ...,
                description="Unique identifier of the node within the transformation graph",
            ),
        ],
        **kwargs,
    ) -> ConversationIdResponse:
        """Retrieves the conversation ID for the current active conversation for the given dataset node (recipe).

        :param dataset_node_id: Unique identifier of the node within the transformation graph (required)
        :type dataset_node_id: int
        :return: Returns the result object.
        :rtype: ConversationIdResponse
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            message = "Error! Please call the get_active_conversation_id_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            raise ValueError(message)
        return self.get_active_conversation_id_with_http_info(dataset_node_id, **kwargs)

    @validate_arguments
    def get_active_conversation_id_with_http_info(
        self,
        dataset_node_id: Annotated[
            StrictInt,
            Field(
                ...,
                description="Unique identifier of the node within the transformation graph",
            ),
        ],
        **kwargs,
    ) -> ApiResponse:
        """Retrieves the conversation ID for the current active conversation for the given dataset node (recipe).

        :param dataset_node_id: Unique identifier of the node within the transformation graph (required)
        :type dataset_node_id: int
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
        :rtype: tuple(ConversationIdResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ["dataset_node_id"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_active_conversation_id" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["dataset_node_id"] is not None:
            _path_params["dataset-node-id"] = _params["dataset_node_id"]

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "application/problem+json"]
        )

        # authentication setting
        _auth_settings = ["BearerAuth"]

        _response_types_map = {
            "200": "ConversationIdResponse",
        }

        return self.api_client.call_api(
            "/v1/ai-assistant/recipe/{dataset-node-id}/conversations/active",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def get_conversation_messages(
        self,
        dataset_node_id: Annotated[
            StrictInt,
            Field(
                ...,
                description="Unique identifier of the node within the transformation graph",
            ),
        ],
        conversation_id: Annotated[
            StrictStr,
            Field(
                ...,
                description="Unique identifier of the conversation in the AI assistant service",
            ),
        ],
        **kwargs,
    ) -> List[ConversationMessageResponse]:
        """Retrieves all messages for the current active conversation for the given dataset node. This is useful for clients who want to continue chat in a new browser session for example.

        :param dataset_node_id: Unique identifier of the node within the transformation graph (required)
        :type dataset_node_id: int
        :param conversation_id: Unique identifier of the conversation in the AI assistant service (required)
        :type conversation_id: str
        :return: Returns the result object.
        :rtype: List[ConversationMessageResponse]
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            message = "Error! Please call the get_conversation_messages_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            raise ValueError(message)
        return self.get_conversation_messages_with_http_info(
            dataset_node_id, conversation_id, **kwargs
        )

    @validate_arguments
    def get_conversation_messages_with_http_info(
        self,
        dataset_node_id: Annotated[
            StrictInt,
            Field(
                ...,
                description="Unique identifier of the node within the transformation graph",
            ),
        ],
        conversation_id: Annotated[
            StrictStr,
            Field(
                ...,
                description="Unique identifier of the conversation in the AI assistant service",
            ),
        ],
        **kwargs,
    ) -> ApiResponse:
        """Retrieves all messages for the current active conversation for the given dataset node. This is useful for clients who want to continue chat in a new browser session for example.

        :param dataset_node_id: Unique identifier of the node within the transformation graph (required)
        :type dataset_node_id: int
        :param conversation_id: Unique identifier of the conversation in the AI assistant service (required)
        :type conversation_id: str
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
        :rtype: tuple(List[ConversationMessageResponse], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ["dataset_node_id", "conversation_id"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_conversation_messages" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["dataset_node_id"] is not None:
            _path_params["dataset-node-id"] = _params["dataset_node_id"]

        if _params["conversation_id"] is not None:
            _path_params["conversation-id"] = _params["conversation_id"]

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "application/problem+json"]
        )

        # authentication setting
        _auth_settings = ["BearerAuth"]

        _response_types_map = {
            "200": "List[ConversationMessageResponse]",
        }

        return self.api_client.call_api(
            "/v1/ai-assistant/recipe/{dataset-node-id}/conversations/{conversation-id}/messages",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def list_conversations(
        self,
        dataset_node_id: Annotated[
            StrictInt,
            Field(
                ...,
                description="Unique identifier of the node within the transformation graph",
            ),
        ],
        **kwargs,
    ) -> List[ConversationResponse]:
        """Retrieves all conversations for the given dataset node (recipe). This is useful for clients who want to list all conversations and allow the user to select one to continue.

        :param dataset_node_id: Unique identifier of the node within the transformation graph (required)
        :type dataset_node_id: int
        :return: Returns the result object.
        :rtype: List[ConversationResponse]
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            message = "Error! Please call the list_conversations_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            raise ValueError(message)
        return self.list_conversations_with_http_info(dataset_node_id, **kwargs)

    @validate_arguments
    def list_conversations_with_http_info(
        self,
        dataset_node_id: Annotated[
            StrictInt,
            Field(
                ...,
                description="Unique identifier of the node within the transformation graph",
            ),
        ],
        **kwargs,
    ) -> ApiResponse:
        """Retrieves all conversations for the given dataset node (recipe). This is useful for clients who want to list all conversations and allow the user to select one to continue.

        :param dataset_node_id: Unique identifier of the node within the transformation graph (required)
        :type dataset_node_id: int
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
        :rtype: tuple(List[ConversationResponse], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ["dataset_node_id"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_conversations" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["dataset_node_id"] is not None:
            _path_params["dataset-node-id"] = _params["dataset_node_id"]

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "application/problem+json"]
        )

        # authentication setting
        _auth_settings = ["BearerAuth"]

        _response_types_map = {
            "200": "List[ConversationResponse]",
        }

        return self.api_client.call_api(
            "/v1/ai-assistant/recipe/{dataset-node-id}/conversations",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def start_new_conversation(
        self,
        dataset_node_id: Annotated[
            StrictInt,
            Field(
                ...,
                description="Unique identifier of the node within the transformation graph",
            ),
        ],
        **kwargs,
    ) -> ConversationIdResponse:
        """Atomically archives any existing active conversation and starts a new one that is empty. This is called when the user wants to start from scratch.

        :param dataset_node_id: Unique identifier of the node within the transformation graph (required)
        :type dataset_node_id: int
        :return: Returns the result object.
        :rtype: ConversationIdResponse
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            message = "Error! Please call the start_new_conversation_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            raise ValueError(message)
        return self.start_new_conversation_with_http_info(dataset_node_id, **kwargs)

    @validate_arguments
    def start_new_conversation_with_http_info(
        self,
        dataset_node_id: Annotated[
            StrictInt,
            Field(
                ...,
                description="Unique identifier of the node within the transformation graph",
            ),
        ],
        **kwargs,
    ) -> ApiResponse:
        """Atomically archives any existing active conversation and starts a new one that is empty. This is called when the user wants to start from scratch.

        :param dataset_node_id: Unique identifier of the node within the transformation graph (required)
        :type dataset_node_id: int
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
        :rtype: tuple(ConversationIdResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ["dataset_node_id"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method start_new_conversation" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["dataset_node_id"] is not None:
            _path_params["dataset-node-id"] = _params["dataset_node_id"]

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "application/problem+json"]
        )

        # authentication setting
        _auth_settings = ["BearerAuth"]

        _response_types_map = {
            "200": "ConversationIdResponse",
        }

        return self.api_client.call_api(
            "/v1/ai-assistant/recipe/{dataset-node-id}/conversations",
            "POST",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def submit_message_to_conversation(
        self,
        dataset_node_id: Annotated[
            StrictInt,
            Field(
                ...,
                description="Unique identifier of the node within the transformation graph",
            ),
        ],
        conversation_id: Annotated[
            StrictStr,
            Field(
                ...,
                description="Unique identifier of the conversation in the AI assistant service",
            ),
        ],
        user_message_request: Annotated[
            UserMessageRequest,
            Field(
                ...,
                description="Request body containing the user message to be added to the conversation",
            ),
        ],
        **kwargs,
    ) -> None:
        """Submits a new message to the current active conversation for the given dataset node. This is used to send user messages to the chat.

        :param dataset_node_id: Unique identifier of the node within the transformation graph (required)
        :type dataset_node_id: int
        :param conversation_id: Unique identifier of the conversation in the AI assistant service (required)
        :type conversation_id: str
        :param user_message_request: Request body containing the user message to be added to the conversation (required)
        :type user_message_request: UserMessageRequest
        :return: Returns the result object.
        :rtype: None
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            message = "Error! Please call the submit_message_to_conversation_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            raise ValueError(message)
        return self.submit_message_to_conversation_with_http_info(
            dataset_node_id, conversation_id, user_message_request, **kwargs
        )

    @validate_arguments
    def submit_message_to_conversation_with_http_info(
        self,
        dataset_node_id: Annotated[
            StrictInt,
            Field(
                ...,
                description="Unique identifier of the node within the transformation graph",
            ),
        ],
        conversation_id: Annotated[
            StrictStr,
            Field(
                ...,
                description="Unique identifier of the conversation in the AI assistant service",
            ),
        ],
        user_message_request: Annotated[
            UserMessageRequest,
            Field(
                ...,
                description="Request body containing the user message to be added to the conversation",
            ),
        ],
        **kwargs,
    ) -> ApiResponse:
        """Submits a new message to the current active conversation for the given dataset node. This is used to send user messages to the chat.

        :param dataset_node_id: Unique identifier of the node within the transformation graph (required)
        :type dataset_node_id: int
        :param conversation_id: Unique identifier of the conversation in the AI assistant service (required)
        :type conversation_id: str
        :param user_message_request: Request body containing the user message to be added to the conversation (required)
        :type user_message_request: UserMessageRequest
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
        :rtype: None
        """

        _params = locals()

        _all_params = ["dataset_node_id", "conversation_id", "user_message_request"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method submit_message_to_conversation" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["dataset_node_id"] is not None:
            _path_params["dataset-node-id"] = _params["dataset_node_id"]

        if _params["conversation_id"] is not None:
            _path_params["conversation-id"] = _params["conversation_id"]

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params["user_message_request"] is not None:
            _body_params = _params["user_message_request"]

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/problem+json"]
        )

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            "_content_type",
            self.api_client.select_header_content_type(["application/json"]),
        )
        if _content_types_list:
            _header_params["Content-Type"] = _content_types_list

        # authentication setting
        _auth_settings = ["BearerAuth"]

        _response_types_map = {}

        return self.api_client.call_api(
            "/v1/ai-assistant/recipe/{dataset-node-id}/conversations/{conversation-id}/messages",
            "POST",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )
