# coding: utf-8

"""
Earnix Elevate Data API

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

The version of the OpenAPI document: 0.0.1
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""

from __future__ import annotations

import json
import pprint
from typing import Optional

from pydantic.v1 import Field, StrictInt, StrictStr, conlist, constr, validator

from earnix_elevate.clients.data.models.add_dataset_node_request import (
    AddDatasetNodeRequest,
)


class AddDatasetRecipeNodeRequest(AddDatasetNodeRequest):
    """
    `AddDatasetRecipeNodeRequest`
    """

    source_dataset_node_ids: Optional[conlist(StrictInt)] = Field(
        default=None,
        alias="sourceDatasetNodeIds",
        description="List of node IDs that serve as data sources for this recipe node in the transformation graph",
    )
    name: Optional[constr(strict=True, max_length=100, min_length=3)] = Field(
        default=None,
        description="Name of the entity for identification and display purposes",
    )
    description: Optional[constr(strict=True, max_length=500)] = Field(
        default=None,
        description="Optional detailed description providing additional context about the entity",
    )
    tags: Optional[conlist(StrictStr, unique_items=True)] = Field(
        default=None,
        description="List of unique tags for categorizing and organizing the entity",
    )
    recipe_type: Optional[StrictStr] = Field(
        default=None,
        alias="recipeType",
        description="Recipe type (TRANSFORMATION for data processing, STRUCTURE for schema modifications)",
    )
    __properties = [
        "nodeType",
        "datasetId",
        "name",
        "description",
        "tags",
        "recipeType",
    ]

    @validator("recipe_type")
    def recipe_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in (
            "TRANSFORMATION",
            "STRUCTURE",
        ):
            raise ValueError(
                "must be one of enum values ('TRANSFORMATION', 'STRUCTURE')"
            )
        return value

    class Config:
        """Pydantic configuration"""

        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> AddDatasetRecipeNodeRequest:
        """Create an instance of AddDatasetRecipeNodeRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        # set to None if description (nullable) is None
        # and __fields_set__ contains the field
        if self.description is None and "description" in self.__fields_set__:
            _dict["description"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> AddDatasetRecipeNodeRequest:
        """Create an instance of AddDatasetRecipeNodeRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return AddDatasetRecipeNodeRequest.parse_obj(obj)

        _obj = AddDatasetRecipeNodeRequest.parse_obj(
            {
                "node_type": obj.get("nodeType"),
                "dataset_id": obj.get("datasetId"),
                "name": obj.get("name"),
                "description": obj.get("description"),
                "tags": obj.get("tags"),
                "recipe_type": obj.get("recipeType"),
            }
        )
        return _obj
