# coding: utf-8

"""
Earnix Elevate Data API

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

The version of the OpenAPI document: 0.0.1
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""

from __future__ import annotations

import json
import pprint
from typing import Optional

from pydantic.v1 import BaseModel, Field, StrictStr, conlist

from earnix_elevate.clients.data.models.export_part_result_pair_response import (
    ExportPartResultPairResponse,
)


class ExportS3PartJobStatusResponse(BaseModel):
    """
    `ExportS3PartJobStatusResponse`

    Export S3 part job status response
    """

    status: Optional[StrictStr] = Field(
        default=None,
        description="Current status of the multi-part export job (e.g., PENDING, IN_PROGRESS, COMPLETED, FAILED)",
    )
    error: Optional[StrictStr] = Field(
        default=None,
        description="Error message if the export job failed, null if successful",
    )
    result: Optional[conlist(ExportPartResultPairResponse)] = Field(
        default=None,
        description="List of upload results for each part of the multi-part export, containing ETags and part numbers",
    )
    __properties = ["status", "error", "result"]

    class Config:
        """Pydantic configuration"""

        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ExportS3PartJobStatusResponse:
        """Create an instance of ExportS3PartJobStatusResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in result (list)
        _items = []
        if self.result:
            for _item in self.result:
                if _item:
                    _items.append(_item.to_dict())
            _dict["result"] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ExportS3PartJobStatusResponse:
        """Create an instance of ExportS3PartJobStatusResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ExportS3PartJobStatusResponse.parse_obj(obj)

        _obj = ExportS3PartJobStatusResponse.parse_obj(
            {
                "status": obj.get("status"),
                "error": obj.get("error"),
                "result": [
                    ExportPartResultPairResponse.from_dict(_item)
                    for _item in obj.get("result")
                ]
                if obj.get("result") is not None
                else None,
            }
        )
        return _obj
