# coding: utf-8

"""
Earnix Elevate Data API

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

The version of the OpenAPI document: 0.0.1
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""

from __future__ import annotations

import json
import pprint
from typing import Optional

from pydantic.v1 import BaseModel, Field, StrictStr


class ExportS3StatusResponse(BaseModel):
    """
    `ExportS3StatusResponse`

    Export S3 job status properties
    """

    status: Optional[StrictStr] = Field(
        default=None,
        description="Current status of the S3 export job (e.g., PENDING, IN_PROGRESS, COMPLETED, FAILED)",
    )
    error_code: Optional[StrictStr] = Field(
        default=None,
        alias="errorCode",
        description="Specific error code if the export job failed, null if successful",
    )
    error_cause: Optional[StrictStr] = Field(
        default=None,
        alias="errorCause",
        description="Root cause description if the export job failed, null if successful",
    )
    __properties = ["status", "errorCode", "errorCause"]

    class Config:
        """Pydantic configuration"""

        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ExportS3StatusResponse:
        """Create an instance of ExportS3StatusResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ExportS3StatusResponse:
        """Create an instance of ExportS3StatusResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ExportS3StatusResponse.parse_obj(obj)

        _obj = ExportS3StatusResponse.parse_obj(
            {
                "status": obj.get("status"),
                "error_code": obj.get("errorCode"),
                "error_cause": obj.get("errorCause"),
            }
        )
        return _obj
