# coding: utf-8

"""
Earnix Elevate Import Export API

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

The version of the OpenAPI document: 0.0.1
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""


from typing import Optional

from pydantic.v1 import Field, validate_arguments
from typing_extensions import Annotated

from earnix_elevate.clients.imx.api_client import ApiClient
from earnix_elevate.clients.imx.api_response import ApiResponse
from earnix_elevate.clients.imx.exceptions import ApiTypeError
from earnix_elevate.clients.imx.models.create_export_request import CreateExportRequest
from earnix_elevate.clients.imx.models.create_export_response import (
    CreateExportResponse,
)
from earnix_elevate.clients.imx.models.exports_response import ExportsResponse
from earnix_elevate.clients.imx.models.list_query import ListQuery


class ExportServiceApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_arguments
    def export(
        self,
        create_export_request: Annotated[
            CreateExportRequest,
            Field(
                ...,
                description="Request body containing the properties for export operations",
            ),
        ],
        **kwargs,
    ) -> CreateExportResponse:
        """Initiates a multi-part export of a specific data version to the destination defined in the data target. This operation enables efficient transfer of large data by splitting the export into multiple parts. It returns a job ID that can be used to track the export’s progress and retrieve the results.

        :param create_export_request: Request body containing the properties for export operations (required)
        :type create_export_request: CreateExportRequest
        :return: Returns the result object.
        :rtype: CreateExportResponse
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            message = "Error! Please call the export_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            raise ValueError(message)
        return self.export_with_http_info(create_export_request, **kwargs)

    @validate_arguments
    def export_with_http_info(
        self,
        create_export_request: Annotated[
            CreateExportRequest,
            Field(
                ...,
                description="Request body containing the properties for export operations",
            ),
        ],
        **kwargs,
    ) -> ApiResponse:
        """Initiates a multi-part export of a specific data version to the destination defined in the data target. This operation enables efficient transfer of large data by splitting the export into multiple parts. It returns a job ID that can be used to track the export’s progress and retrieve the results.

        :param create_export_request: Request body containing the properties for export operations (required)
        :type create_export_request: CreateExportRequest
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
        :rtype: tuple(CreateExportResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ["create_export_request"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s' to method export" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params["create_export_request"] is not None:
            _body_params = _params["create_export_request"]

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "application/problem+json"]
        )

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            "_content_type",
            self.api_client.select_header_content_type(["application/json"]),
        )
        if _content_types_list:
            _header_params["Content-Type"] = _content_types_list

        # authentication setting
        _auth_settings = ["BearerAuth"]

        _response_types_map = {
            "200": "CreateExportResponse",
        }

        return self.api_client.call_api(
            "/v1/exports",
            "POST",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def list_exports(
        self,
        list_query: Annotated[
            Optional[ListQuery], Field(description="List query parameters")
        ] = None,
        **kwargs,
    ) -> ExportsResponse:
        """Retrieves a list of all Exports. Exports represent data export operations that transfer data from the platform to external systems defined by DataTargets.

        :param list_query: List query parameters
        :type list_query: ListQuery
        :return: Returns the result object.
        :rtype: ExportsResponse
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            message = "Error! Please call the list_exports_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"
            raise ValueError(message)
        return self.list_exports_with_http_info(list_query, **kwargs)

    @validate_arguments
    def list_exports_with_http_info(
        self,
        list_query: Annotated[
            Optional[ListQuery], Field(description="List query parameters")
        ] = None,
        **kwargs,
    ) -> ApiResponse:
        """Retrieves a list of all Exports. Exports represent data export operations that transfer data from the platform to external systems defined by DataTargets.

        :param list_query: List query parameters
        :type list_query: ListQuery
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
        :rtype: tuple(ExportsResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ["list_query"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_exports" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get("list_query") is not None:
            _query_params.append(("listQuery", _params["list_query"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "application/problem+json"]
        )

        # authentication setting
        _auth_settings = ["BearerAuth"]

        _response_types_map = {
            "200": "ExportsResponse",
        }

        return self.api_client.call_api(
            "/v1/exports",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )
