# coding: utf-8

"""
Earnix Elevate Import Export API

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

The version of the OpenAPI document: 0.0.1
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""

from __future__ import annotations

import json
import pprint
from typing import Optional

from pydantic.v1 import BaseModel, Field, conlist

from earnix_elevate.clients.imx.models.bucket_file_details_response import (
    BucketFileDetailsResponse,
)
from earnix_elevate.clients.imx.models.bucket_folder_details_response import (
    BucketFolderDetailsResponse,
)
from earnix_elevate.clients.imx.models.bucket_object_metadata_response import (
    BucketObjectMetadataResponse,
)


class BrowseBucketDataSourceResponse(BaseModel):
    """
    `BrowseBucketDataSourceResponse`

    Response containing the contents of a bucket DataSource, including folders, files, and metadata about the browsing operation.
    """

    folders: Optional[conlist(BucketFolderDetailsResponse, max_items=1000)] = Field(
        default=None, description="List of folders found at the specified path"
    )
    files: Optional[conlist(BucketFileDetailsResponse, max_items=1000)] = Field(
        default=None, description="List of files found at the specified path"
    )
    metadata: Optional[BucketObjectMetadataResponse] = None
    __properties = ["folders", "files", "metadata"]

    class Config:
        """Pydantic configuration"""

        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> BrowseBucketDataSourceResponse:
        """Create an instance of BrowseBucketDataSourceResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in folders (list)
        _items = []
        if self.folders:
            for _item in self.folders:
                if _item:
                    _items.append(_item.to_dict())
            _dict["folders"] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in files (list)
        _items = []
        if self.files:
            for _item in self.files:
                if _item:
                    _items.append(_item.to_dict())
            _dict["files"] = _items
        # override the default output from pydantic by calling `to_dict()` of metadata
        if self.metadata:
            _dict["metadata"] = self.metadata.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> BrowseBucketDataSourceResponse:
        """Create an instance of BrowseBucketDataSourceResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return BrowseBucketDataSourceResponse.parse_obj(obj)

        _obj = BrowseBucketDataSourceResponse.parse_obj(
            {
                "folders": [
                    BucketFolderDetailsResponse.from_dict(_item)
                    for _item in obj.get("folders")
                ]
                if obj.get("folders") is not None
                else None,
                "files": [
                    BucketFileDetailsResponse.from_dict(_item)
                    for _item in obj.get("files")
                ]
                if obj.get("files") is not None
                else None,
                "metadata": BucketObjectMetadataResponse.from_dict(obj.get("metadata"))
                if obj.get("metadata") is not None
                else None,
            }
        )
        return _obj
