# coding: utf-8

"""
Earnix Elevate Import Export API

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

The version of the OpenAPI document: 0.0.1
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""

from __future__ import annotations

import json
import pprint
from typing import Optional

from pydantic.v1 import BaseModel, Field, StrictStr, constr


class BucketFileDetailsResponse(BaseModel):
    """
    `BucketFileDetailsResponse`

    Details about a file found in a bucket DataSource, including its location and name information.
    """

    bucket: Optional[constr(strict=True, max_length=1000, min_length=1)] = Field(
        default=None, description="The name of the bucket containing the file"
    )
    relative_path: Optional[StrictStr] = Field(
        default=None,
        alias="relativePath",
        description="The relative path to the file within the bucket",
    )
    file_name: Optional[constr(strict=True, max_length=1000, min_length=1)] = Field(
        default=None, alias="fileName", description="The name of the file"
    )
    __properties = ["bucket", "relativePath", "fileName"]

    class Config:
        """Pydantic configuration"""

        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> BucketFileDetailsResponse:
        """Create an instance of BucketFileDetailsResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> BucketFileDetailsResponse:
        """Create an instance of BucketFileDetailsResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return BucketFileDetailsResponse.parse_obj(obj)

        _obj = BucketFileDetailsResponse.parse_obj(
            {
                "bucket": obj.get("bucket"),
                "relative_path": obj.get("relativePath"),
                "file_name": obj.get("fileName"),
            }
        )
        return _obj
