# coding: utf-8

"""
Earnix Elevate Import Export API

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

The version of the OpenAPI document: 0.0.1
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""

from __future__ import annotations

import json
import pprint
from typing import Optional

from pydantic.v1 import BaseModel, Field, StrictBool, constr


class BucketObjectMetadataResponse(BaseModel):
    """
    `BucketObjectMetadataResponse`

    Metadata about the bucket browsing operation, including protocol type and limit status.
    """

    protocol: Optional[constr(strict=True, max_length=50, min_length=1)] = Field(
        default=None,
        description="The protocol used to access the bucket (e.g., s3, gcs)",
    )
    reached_limit: Optional[StrictBool] = Field(
        default=None,
        alias="reachedLimit",
        description="Indicates whether there are more files beyond the specified limit",
    )
    __properties = ["protocol", "reachedLimit"]

    class Config:
        """Pydantic configuration"""

        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> BucketObjectMetadataResponse:
        """Create an instance of BucketObjectMetadataResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> BucketObjectMetadataResponse:
        """Create an instance of BucketObjectMetadataResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return BucketObjectMetadataResponse.parse_obj(obj)

        _obj = BucketObjectMetadataResponse.parse_obj(
            {"protocol": obj.get("protocol"), "reached_limit": obj.get("reachedLimit")}
        )
        return _obj
