# coding: utf-8

"""
Earnix Elevate Import Export API

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

The version of the OpenAPI document: 0.0.1
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""

from __future__ import annotations

import json
import pprint
import re
from typing import Optional

from pydantic.v1 import Field, constr, validator

from earnix_elevate.clients.imx.models.o_auth_response import OAuthResponse


class ClientCredentialsAuthResponse(OAuthResponse):
    """
    `ClientCredentialsAuthResponse`

    OAuth authentication response using OAuth2 client credentials flow, containing token endpoint and client information.
    """

    token_url: Optional[constr(strict=True, max_length=500, min_length=3)] = Field(
        default=None, alias="tokenUrl", description="The OAuth2 token endpoint URL"
    )
    client_id: Optional[constr(strict=True, max_length=500, min_length=3)] = Field(
        default=None, alias="clientId", description="The OAuth2 client ID"
    )
    client_secret: Optional[constr(strict=True, max_length=500, min_length=3)] = Field(
        default=None, alias="clientSecret", description="The OAuth2 client secret"
    )
    scope: Optional[constr(strict=True, max_length=500, min_length=3)] = Field(
        default=None, description="The OAuth2 scope for the token request"
    )
    host: Optional[constr(strict=True, max_length=500, min_length=3)] = Field(
        default=None, description="The host/account identifier"
    )
    __properties = ["authType", "tokenUrl", "clientId", "clientSecret", "scope", "host"]

    @validator("token_url")
    def token_url_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^https:\/\/.+$", value):
            raise ValueError(r"must validate the regular expression /^https:\/\/.+$/")
        return value

    class Config:
        """Pydantic configuration"""

        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ClientCredentialsAuthResponse:
        """Create an instance of ClientCredentialsAuthResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ClientCredentialsAuthResponse:
        """Create an instance of ClientCredentialsAuthResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ClientCredentialsAuthResponse.parse_obj(obj)

        _obj = ClientCredentialsAuthResponse.parse_obj(
            {
                "auth_type": obj.get("authType"),
                "token_url": obj.get("tokenUrl"),
                "client_id": obj.get("clientId"),
                "client_secret": obj.get("clientSecret"),
                "scope": obj.get("scope"),
                "host": obj.get("host"),
            }
        )
        return _obj
