# coding: utf-8

"""
Earnix Elevate Import Export API

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

The version of the OpenAPI document: 0.0.1
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""

from __future__ import annotations

import json
import pprint

from pydantic.v1 import BaseModel, Field, StrictInt, conlist

from earnix_elevate.clients.imx.models.data_source_response import DataSourceResponse


class DataSourcesResponse(BaseModel):
    """
    `DataSourcesResponse`

    Collection of DataSource objects
    """

    offset: StrictInt = Field(
        default=..., description="Number of records skipped before current result set"
    )
    limit: StrictInt = Field(
        default=..., description="Number of records in current result set"
    )
    total: StrictInt = Field(
        default=..., description="Total number of records available in the database"
    )
    items: conlist(DataSourceResponse) = Field(
        default=..., description="list of DataSources in current result set"
    )
    __properties = ["offset", "limit", "total", "items"]

    class Config:
        """Pydantic configuration"""

        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> DataSourcesResponse:
        """Create an instance of DataSourcesResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in items (list)
        _items = []
        if self.items:
            for _item in self.items:
                if _item:
                    _items.append(_item.to_dict())
            _dict["items"] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> DataSourcesResponse:
        """Create an instance of DataSourcesResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return DataSourcesResponse.parse_obj(obj)

        _obj = DataSourcesResponse.parse_obj(
            {
                "offset": obj.get("offset"),
                "limit": obj.get("limit"),
                "total": obj.get("total"),
                "items": [
                    DataSourceResponse.from_dict(_item) for _item in obj.get("items")
                ]
                if obj.get("items") is not None
                else None,
            }
        )
        return _obj
