# coding: utf-8

"""
Earnix Elevate Import Export API

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

The version of the OpenAPI document: 0.0.1
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""

from __future__ import annotations

import json
import pprint
from typing import Optional

from pydantic.v1 import Field, StrictStr, constr

from earnix_elevate.clients.imx.models.delta_sharing_auth_request import (
    DeltaSharingAuthRequest,
)


class DeltaSharingJsonProfileAuthRequest(DeltaSharingAuthRequest):
    """
    `DeltaSharingJsonProfileAuthRequest`

    Delta Sharing connection authentication request using Deltasharing-profile for authentication.
    """

    delta_sharing_profile_name: Optional[StrictStr] = Field(
        default=None,
        alias="deltaSharingProfileName",
        description="The name of Delta Sharing profile configuration.",
    )
    delta_sharing_profile_content: constr(
        strict=True, max_length=4096, min_length=20
    ) = Field(
        default=...,
        alias="deltaSharingProfileContent",
        description="The Delta Sharing profile configuration in JSON format, containing connection and authentication details for accessing shared data.",
    )
    __properties = ["authType", "deltaSharingProfileName", "deltaSharingProfileContent"]

    class Config:
        """Pydantic configuration"""

        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> DeltaSharingJsonProfileAuthRequest:
        """Create an instance of DeltaSharingJsonProfileAuthRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> DeltaSharingJsonProfileAuthRequest:
        """Create an instance of DeltaSharingJsonProfileAuthRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return DeltaSharingJsonProfileAuthRequest.parse_obj(obj)

        _obj = DeltaSharingJsonProfileAuthRequest.parse_obj(
            {
                "auth_type": obj.get("authType"),
                "delta_sharing_profile_name": obj.get("deltaSharingProfileName"),
                "delta_sharing_profile_content": obj.get("deltaSharingProfileContent"),
            }
        )
        return _obj
