# coding: utf-8

"""
Earnix Elevate Import Export API

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

The version of the OpenAPI document: 0.0.1
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""

from __future__ import annotations

import json
import pprint
import re
from typing import Optional

from pydantic.v1 import Field, constr, validator

from earnix_elevate.clients.imx.models.s3_auth_response import S3AuthResponse


class S3SecretKeyAuthResponse(S3AuthResponse):
    """
    `S3SecretKeyAuthResponse`

    S3 authentication response using secret key authentication, containing access key and endpoint information.
    """

    access_key_id: Optional[constr(strict=True, max_length=128, min_length=16)] = Field(
        default=None,
        alias="accessKeyId",
        description="The access key ID for authentication",
    )
    secret_access_key: Optional[constr(strict=True, max_length=1024, min_length=16)] = (
        Field(
            default=None,
            alias="secretAccessKey",
            description="The secret access key for authentication",
        )
    )
    endpoint: Optional[constr(strict=True, max_length=500)] = Field(
        default=None, description="The HTTPS endpoint URL for the S3-compatible service"
    )
    __properties = ["authType", "accessKeyId", "secretAccessKey", "endpoint"]

    @validator("access_key_id")
    def access_key_id_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"\w+", value):
            raise ValueError(r"must validate the regular expression /\w+/")
        return value

    @validator("endpoint")
    def endpoint_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^https:\/\/.+$", value):
            raise ValueError(r"must validate the regular expression /^https:\/\/.+$/")
        return value

    class Config:
        """Pydantic configuration"""

        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> S3SecretKeyAuthResponse:
        """Create an instance of S3SecretKeyAuthResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> S3SecretKeyAuthResponse:
        """Create an instance of S3SecretKeyAuthResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return S3SecretKeyAuthResponse.parse_obj(obj)

        _obj = S3SecretKeyAuthResponse.parse_obj(
            {
                "auth_type": obj.get("authType"),
                "access_key_id": obj.get("accessKeyId"),
                "secret_access_key": obj.get("secretAccessKey"),
                "endpoint": obj.get("endpoint"),
            }
        )
        return _obj
