# coding: utf-8

"""
Earnix Elevate Relay API

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

The version of the OpenAPI document: 0.0.1
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""

from __future__ import annotations

import json
import pprint
from datetime import datetime
from typing import Any, Dict, Optional

from pydantic.v1 import BaseModel, Field, StrictStr, conint


class ProblemDetail(BaseModel):
    """
    `ProblemDetail`

    Definition of [RFC7807](https://tools.ietf.org/html/rfc7807) problem detail
    """

    type: Optional[StrictStr] = Field(
        default=None, description="A URI reference that identifies the problem type"
    )
    title: StrictStr = Field(
        default=..., description="A short, human-readable summary of the problem type"
    )
    status: conint(strict=True, le=599, ge=100) = Field(
        default=...,
        description="The HTTP status code generated by the origin server for this occurrence of the problem",
    )
    detail: StrictStr = Field(
        default=...,
        description="A human-readable explanation specific to this occurrence of the problem",
    )
    instance: Optional[StrictStr] = Field(
        default=None,
        description="A URI reference that identifies the specific occurrence of the problem. It may or may not yield further information if dereferenced",
    )
    code: StrictStr = Field(default=..., description="Unique error code")
    timestamp: datetime = Field(
        default=..., description="The time the problem was generated"
    )
    extra_details: Optional[Dict[str, Any]] = Field(
        default=None,
        alias="extraDetails",
        description="Additional details about the problem that may be useful for debugging",
    )
    trace_id: Optional[StrictStr] = Field(
        default=None,
        alias="traceId",
        description="Unique identifier of the request that caused the problem",
    )
    __properties = [
        "type",
        "title",
        "status",
        "detail",
        "instance",
        "code",
        "timestamp",
        "extraDetails",
        "traceId",
    ]

    class Config:
        """Pydantic configuration"""

        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ProblemDetail:
        """Create an instance of ProblemDetail from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ProblemDetail:
        """Create an instance of ProblemDetail from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ProblemDetail.parse_obj(obj)

        _obj = ProblemDetail.parse_obj(
            {
                "type": obj.get("type"),
                "title": obj.get("title"),
                "status": obj.get("status"),
                "detail": obj.get("detail"),
                "instance": obj.get("instance"),
                "code": obj.get("code"),
                "timestamp": obj.get("timestamp"),
                "extra_details": obj.get("extraDetails"),
                "trace_id": obj.get("traceId"),
            }
        )
        return _obj
