# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['AuthBackendClientArgs', 'AuthBackendClient']

@pulumi.input_type
class AuthBackendClientArgs:
    def __init__(__self__, *,
                 access_key: Optional[pulumi.Input[_builtins.str]] = None,
                 allowed_sts_header_values: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 backend: Optional[pulumi.Input[_builtins.str]] = None,
                 disable_automated_rotation: Optional[pulumi.Input[_builtins.bool]] = None,
                 ec2_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 iam_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 iam_server_id_header_value: Optional[pulumi.Input[_builtins.str]] = None,
                 identity_token_audience: Optional[pulumi.Input[_builtins.str]] = None,
                 identity_token_ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 max_retries: Optional[pulumi.Input[_builtins.int]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 rotation_period: Optional[pulumi.Input[_builtins.int]] = None,
                 rotation_schedule: Optional[pulumi.Input[_builtins.str]] = None,
                 rotation_window: Optional[pulumi.Input[_builtins.int]] = None,
                 secret_key: Optional[pulumi.Input[_builtins.str]] = None,
                 sts_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 sts_region: Optional[pulumi.Input[_builtins.str]] = None,
                 use_sts_region_from_client: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a AuthBackendClient resource.
        :param pulumi.Input[_builtins.str] access_key: The AWS access key that Vault should use for the
               auth backend. Mutually exclusive with `identity_token_audience`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_sts_header_values: List of additional headers that are allowed to be in STS request headers.
               The headers are automatically canonicalized (e.g., `content-type` becomes `Content-Type`). Duplicate values are automatically
               removed. This can be useful when you need to allow specific headers in STS requests for IAM-based authentication.
        :param pulumi.Input[_builtins.str] backend: The path the AWS auth backend being configured was
               mounted at.  Defaults to `aws`.
        :param pulumi.Input[_builtins.bool] disable_automated_rotation: Cancels all upcoming rotations of the root credential until unset. Requires Vault Enterprise 1.19+.
        :param pulumi.Input[_builtins.str] ec2_endpoint: Override the URL Vault uses when making EC2 API
               calls.
        :param pulumi.Input[_builtins.str] iam_endpoint: Override the URL Vault uses when making IAM API
               calls.
        :param pulumi.Input[_builtins.str] iam_server_id_header_value: The value to require in the
               `X-Vault-AWS-IAM-Server-ID` header as part of `GetCallerIdentity` requests
               that are used in the IAM auth method.
        :param pulumi.Input[_builtins.str] identity_token_audience: The audience claim value. Mutually exclusive with `access_key`. 
               Requires Vault 1.17+. *Available only for Vault Enterprise*
        :param pulumi.Input[_builtins.int] identity_token_ttl: The TTL of generated identity tokens in seconds. Requires Vault 1.17+.
               *Available only for Vault Enterprise*
        :param pulumi.Input[_builtins.int] max_retries: Number of max retries the client should use for recoverable errors. 
               The default `-1` falls back to the AWS SDK's default behavior.
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.str] role_arn: Role ARN to assume for plugin identity token federation. Requires Vault 1.17+.
               *Available only for Vault Enterprise*
        :param pulumi.Input[_builtins.int] rotation_period: The amount of time in seconds Vault should wait before rotating the root credential.
               A zero value tells Vault not to rotate the root credential. The minimum rotation period is 10 seconds. Requires Vault Enterprise 1.19+.
        :param pulumi.Input[_builtins.str] rotation_schedule: The schedule, in [cron-style time format](https://en.wikipedia.org/wiki/Cron),
               defining the schedule on which Vault should rotate the root token. Requires Vault Enterprise 1.19+.
        :param pulumi.Input[_builtins.int] rotation_window: The maximum amount of time in seconds allowed to complete
               a rotation when a scheduled token rotation occurs. The default rotation window is
               unbound and the minimum allowable window is `3600`. Requires Vault Enterprise 1.19+.
        :param pulumi.Input[_builtins.str] secret_key: The AWS secret key that Vault should use for the
               auth backend.
        :param pulumi.Input[_builtins.str] sts_endpoint: Override the URL Vault uses when making STS API
               calls.
        :param pulumi.Input[_builtins.str] sts_region: Override the default region when making STS API 
               calls. The `sts_endpoint` argument must be set when using `sts_region`.
        :param pulumi.Input[_builtins.bool] use_sts_region_from_client: Available in Vault v1.15+. If set, 
               overrides both `sts_endpoint` and `sts_region` to instead use the region
               specified in the client request headers for IAM-based authentication.
               This can be useful when you have client requests coming from different
               regions and want flexibility in which regional STS API is used.
        """
        if access_key is not None:
            pulumi.set(__self__, "access_key", access_key)
        if allowed_sts_header_values is not None:
            pulumi.set(__self__, "allowed_sts_header_values", allowed_sts_header_values)
        if backend is not None:
            pulumi.set(__self__, "backend", backend)
        if disable_automated_rotation is not None:
            pulumi.set(__self__, "disable_automated_rotation", disable_automated_rotation)
        if ec2_endpoint is not None:
            pulumi.set(__self__, "ec2_endpoint", ec2_endpoint)
        if iam_endpoint is not None:
            pulumi.set(__self__, "iam_endpoint", iam_endpoint)
        if iam_server_id_header_value is not None:
            pulumi.set(__self__, "iam_server_id_header_value", iam_server_id_header_value)
        if identity_token_audience is not None:
            pulumi.set(__self__, "identity_token_audience", identity_token_audience)
        if identity_token_ttl is not None:
            pulumi.set(__self__, "identity_token_ttl", identity_token_ttl)
        if max_retries is not None:
            pulumi.set(__self__, "max_retries", max_retries)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)
        if rotation_period is not None:
            pulumi.set(__self__, "rotation_period", rotation_period)
        if rotation_schedule is not None:
            pulumi.set(__self__, "rotation_schedule", rotation_schedule)
        if rotation_window is not None:
            pulumi.set(__self__, "rotation_window", rotation_window)
        if secret_key is not None:
            pulumi.set(__self__, "secret_key", secret_key)
        if sts_endpoint is not None:
            pulumi.set(__self__, "sts_endpoint", sts_endpoint)
        if sts_region is not None:
            pulumi.set(__self__, "sts_region", sts_region)
        if use_sts_region_from_client is not None:
            pulumi.set(__self__, "use_sts_region_from_client", use_sts_region_from_client)

    @_builtins.property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The AWS access key that Vault should use for the
        auth backend. Mutually exclusive with `identity_token_audience`.
        """
        return pulumi.get(self, "access_key")

    @access_key.setter
    def access_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "access_key", value)

    @_builtins.property
    @pulumi.getter(name="allowedStsHeaderValues")
    def allowed_sts_header_values(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of additional headers that are allowed to be in STS request headers.
        The headers are automatically canonicalized (e.g., `content-type` becomes `Content-Type`). Duplicate values are automatically
        removed. This can be useful when you need to allow specific headers in STS requests for IAM-based authentication.
        """
        return pulumi.get(self, "allowed_sts_header_values")

    @allowed_sts_header_values.setter
    def allowed_sts_header_values(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "allowed_sts_header_values", value)

    @_builtins.property
    @pulumi.getter
    def backend(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The path the AWS auth backend being configured was
        mounted at.  Defaults to `aws`.
        """
        return pulumi.get(self, "backend")

    @backend.setter
    def backend(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backend", value)

    @_builtins.property
    @pulumi.getter(name="disableAutomatedRotation")
    def disable_automated_rotation(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Cancels all upcoming rotations of the root credential until unset. Requires Vault Enterprise 1.19+.
        """
        return pulumi.get(self, "disable_automated_rotation")

    @disable_automated_rotation.setter
    def disable_automated_rotation(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disable_automated_rotation", value)

    @_builtins.property
    @pulumi.getter(name="ec2Endpoint")
    def ec2_endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Override the URL Vault uses when making EC2 API
        calls.
        """
        return pulumi.get(self, "ec2_endpoint")

    @ec2_endpoint.setter
    def ec2_endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ec2_endpoint", value)

    @_builtins.property
    @pulumi.getter(name="iamEndpoint")
    def iam_endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Override the URL Vault uses when making IAM API
        calls.
        """
        return pulumi.get(self, "iam_endpoint")

    @iam_endpoint.setter
    def iam_endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "iam_endpoint", value)

    @_builtins.property
    @pulumi.getter(name="iamServerIdHeaderValue")
    def iam_server_id_header_value(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The value to require in the
        `X-Vault-AWS-IAM-Server-ID` header as part of `GetCallerIdentity` requests
        that are used in the IAM auth method.
        """
        return pulumi.get(self, "iam_server_id_header_value")

    @iam_server_id_header_value.setter
    def iam_server_id_header_value(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "iam_server_id_header_value", value)

    @_builtins.property
    @pulumi.getter(name="identityTokenAudience")
    def identity_token_audience(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The audience claim value. Mutually exclusive with `access_key`. 
        Requires Vault 1.17+. *Available only for Vault Enterprise*
        """
        return pulumi.get(self, "identity_token_audience")

    @identity_token_audience.setter
    def identity_token_audience(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "identity_token_audience", value)

    @_builtins.property
    @pulumi.getter(name="identityTokenTtl")
    def identity_token_ttl(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The TTL of generated identity tokens in seconds. Requires Vault 1.17+.
        *Available only for Vault Enterprise*
        """
        return pulumi.get(self, "identity_token_ttl")

    @identity_token_ttl.setter
    def identity_token_ttl(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "identity_token_ttl", value)

    @_builtins.property
    @pulumi.getter(name="maxRetries")
    def max_retries(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of max retries the client should use for recoverable errors. 
        The default `-1` falls back to the AWS SDK's default behavior.
        """
        return pulumi.get(self, "max_retries")

    @max_retries.setter
    def max_retries(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_retries", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Role ARN to assume for plugin identity token federation. Requires Vault 1.17+.
        *Available only for Vault Enterprise*
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "role_arn", value)

    @_builtins.property
    @pulumi.getter(name="rotationPeriod")
    def rotation_period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The amount of time in seconds Vault should wait before rotating the root credential.
        A zero value tells Vault not to rotate the root credential. The minimum rotation period is 10 seconds. Requires Vault Enterprise 1.19+.
        """
        return pulumi.get(self, "rotation_period")

    @rotation_period.setter
    def rotation_period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "rotation_period", value)

    @_builtins.property
    @pulumi.getter(name="rotationSchedule")
    def rotation_schedule(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The schedule, in [cron-style time format](https://en.wikipedia.org/wiki/Cron),
        defining the schedule on which Vault should rotate the root token. Requires Vault Enterprise 1.19+.
        """
        return pulumi.get(self, "rotation_schedule")

    @rotation_schedule.setter
    def rotation_schedule(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rotation_schedule", value)

    @_builtins.property
    @pulumi.getter(name="rotationWindow")
    def rotation_window(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum amount of time in seconds allowed to complete
        a rotation when a scheduled token rotation occurs. The default rotation window is
        unbound and the minimum allowable window is `3600`. Requires Vault Enterprise 1.19+.
        """
        return pulumi.get(self, "rotation_window")

    @rotation_window.setter
    def rotation_window(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "rotation_window", value)

    @_builtins.property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The AWS secret key that Vault should use for the
        auth backend.
        """
        return pulumi.get(self, "secret_key")

    @secret_key.setter
    def secret_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secret_key", value)

    @_builtins.property
    @pulumi.getter(name="stsEndpoint")
    def sts_endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Override the URL Vault uses when making STS API
        calls.
        """
        return pulumi.get(self, "sts_endpoint")

    @sts_endpoint.setter
    def sts_endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sts_endpoint", value)

    @_builtins.property
    @pulumi.getter(name="stsRegion")
    def sts_region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Override the default region when making STS API 
        calls. The `sts_endpoint` argument must be set when using `sts_region`.
        """
        return pulumi.get(self, "sts_region")

    @sts_region.setter
    def sts_region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sts_region", value)

    @_builtins.property
    @pulumi.getter(name="useStsRegionFromClient")
    def use_sts_region_from_client(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Available in Vault v1.15+. If set, 
        overrides both `sts_endpoint` and `sts_region` to instead use the region
        specified in the client request headers for IAM-based authentication.
        This can be useful when you have client requests coming from different
        regions and want flexibility in which regional STS API is used.
        """
        return pulumi.get(self, "use_sts_region_from_client")

    @use_sts_region_from_client.setter
    def use_sts_region_from_client(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "use_sts_region_from_client", value)


@pulumi.input_type
class _AuthBackendClientState:
    def __init__(__self__, *,
                 access_key: Optional[pulumi.Input[_builtins.str]] = None,
                 allowed_sts_header_values: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 backend: Optional[pulumi.Input[_builtins.str]] = None,
                 disable_automated_rotation: Optional[pulumi.Input[_builtins.bool]] = None,
                 ec2_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 iam_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 iam_server_id_header_value: Optional[pulumi.Input[_builtins.str]] = None,
                 identity_token_audience: Optional[pulumi.Input[_builtins.str]] = None,
                 identity_token_ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 max_retries: Optional[pulumi.Input[_builtins.int]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 rotation_period: Optional[pulumi.Input[_builtins.int]] = None,
                 rotation_schedule: Optional[pulumi.Input[_builtins.str]] = None,
                 rotation_window: Optional[pulumi.Input[_builtins.int]] = None,
                 secret_key: Optional[pulumi.Input[_builtins.str]] = None,
                 sts_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 sts_region: Optional[pulumi.Input[_builtins.str]] = None,
                 use_sts_region_from_client: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        Input properties used for looking up and filtering AuthBackendClient resources.
        :param pulumi.Input[_builtins.str] access_key: The AWS access key that Vault should use for the
               auth backend. Mutually exclusive with `identity_token_audience`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_sts_header_values: List of additional headers that are allowed to be in STS request headers.
               The headers are automatically canonicalized (e.g., `content-type` becomes `Content-Type`). Duplicate values are automatically
               removed. This can be useful when you need to allow specific headers in STS requests for IAM-based authentication.
        :param pulumi.Input[_builtins.str] backend: The path the AWS auth backend being configured was
               mounted at.  Defaults to `aws`.
        :param pulumi.Input[_builtins.bool] disable_automated_rotation: Cancels all upcoming rotations of the root credential until unset. Requires Vault Enterprise 1.19+.
        :param pulumi.Input[_builtins.str] ec2_endpoint: Override the URL Vault uses when making EC2 API
               calls.
        :param pulumi.Input[_builtins.str] iam_endpoint: Override the URL Vault uses when making IAM API
               calls.
        :param pulumi.Input[_builtins.str] iam_server_id_header_value: The value to require in the
               `X-Vault-AWS-IAM-Server-ID` header as part of `GetCallerIdentity` requests
               that are used in the IAM auth method.
        :param pulumi.Input[_builtins.str] identity_token_audience: The audience claim value. Mutually exclusive with `access_key`. 
               Requires Vault 1.17+. *Available only for Vault Enterprise*
        :param pulumi.Input[_builtins.int] identity_token_ttl: The TTL of generated identity tokens in seconds. Requires Vault 1.17+.
               *Available only for Vault Enterprise*
        :param pulumi.Input[_builtins.int] max_retries: Number of max retries the client should use for recoverable errors. 
               The default `-1` falls back to the AWS SDK's default behavior.
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.str] role_arn: Role ARN to assume for plugin identity token federation. Requires Vault 1.17+.
               *Available only for Vault Enterprise*
        :param pulumi.Input[_builtins.int] rotation_period: The amount of time in seconds Vault should wait before rotating the root credential.
               A zero value tells Vault not to rotate the root credential. The minimum rotation period is 10 seconds. Requires Vault Enterprise 1.19+.
        :param pulumi.Input[_builtins.str] rotation_schedule: The schedule, in [cron-style time format](https://en.wikipedia.org/wiki/Cron),
               defining the schedule on which Vault should rotate the root token. Requires Vault Enterprise 1.19+.
        :param pulumi.Input[_builtins.int] rotation_window: The maximum amount of time in seconds allowed to complete
               a rotation when a scheduled token rotation occurs. The default rotation window is
               unbound and the minimum allowable window is `3600`. Requires Vault Enterprise 1.19+.
        :param pulumi.Input[_builtins.str] secret_key: The AWS secret key that Vault should use for the
               auth backend.
        :param pulumi.Input[_builtins.str] sts_endpoint: Override the URL Vault uses when making STS API
               calls.
        :param pulumi.Input[_builtins.str] sts_region: Override the default region when making STS API 
               calls. The `sts_endpoint` argument must be set when using `sts_region`.
        :param pulumi.Input[_builtins.bool] use_sts_region_from_client: Available in Vault v1.15+. If set, 
               overrides both `sts_endpoint` and `sts_region` to instead use the region
               specified in the client request headers for IAM-based authentication.
               This can be useful when you have client requests coming from different
               regions and want flexibility in which regional STS API is used.
        """
        if access_key is not None:
            pulumi.set(__self__, "access_key", access_key)
        if allowed_sts_header_values is not None:
            pulumi.set(__self__, "allowed_sts_header_values", allowed_sts_header_values)
        if backend is not None:
            pulumi.set(__self__, "backend", backend)
        if disable_automated_rotation is not None:
            pulumi.set(__self__, "disable_automated_rotation", disable_automated_rotation)
        if ec2_endpoint is not None:
            pulumi.set(__self__, "ec2_endpoint", ec2_endpoint)
        if iam_endpoint is not None:
            pulumi.set(__self__, "iam_endpoint", iam_endpoint)
        if iam_server_id_header_value is not None:
            pulumi.set(__self__, "iam_server_id_header_value", iam_server_id_header_value)
        if identity_token_audience is not None:
            pulumi.set(__self__, "identity_token_audience", identity_token_audience)
        if identity_token_ttl is not None:
            pulumi.set(__self__, "identity_token_ttl", identity_token_ttl)
        if max_retries is not None:
            pulumi.set(__self__, "max_retries", max_retries)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)
        if rotation_period is not None:
            pulumi.set(__self__, "rotation_period", rotation_period)
        if rotation_schedule is not None:
            pulumi.set(__self__, "rotation_schedule", rotation_schedule)
        if rotation_window is not None:
            pulumi.set(__self__, "rotation_window", rotation_window)
        if secret_key is not None:
            pulumi.set(__self__, "secret_key", secret_key)
        if sts_endpoint is not None:
            pulumi.set(__self__, "sts_endpoint", sts_endpoint)
        if sts_region is not None:
            pulumi.set(__self__, "sts_region", sts_region)
        if use_sts_region_from_client is not None:
            pulumi.set(__self__, "use_sts_region_from_client", use_sts_region_from_client)

    @_builtins.property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The AWS access key that Vault should use for the
        auth backend. Mutually exclusive with `identity_token_audience`.
        """
        return pulumi.get(self, "access_key")

    @access_key.setter
    def access_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "access_key", value)

    @_builtins.property
    @pulumi.getter(name="allowedStsHeaderValues")
    def allowed_sts_header_values(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of additional headers that are allowed to be in STS request headers.
        The headers are automatically canonicalized (e.g., `content-type` becomes `Content-Type`). Duplicate values are automatically
        removed. This can be useful when you need to allow specific headers in STS requests for IAM-based authentication.
        """
        return pulumi.get(self, "allowed_sts_header_values")

    @allowed_sts_header_values.setter
    def allowed_sts_header_values(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "allowed_sts_header_values", value)

    @_builtins.property
    @pulumi.getter
    def backend(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The path the AWS auth backend being configured was
        mounted at.  Defaults to `aws`.
        """
        return pulumi.get(self, "backend")

    @backend.setter
    def backend(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backend", value)

    @_builtins.property
    @pulumi.getter(name="disableAutomatedRotation")
    def disable_automated_rotation(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Cancels all upcoming rotations of the root credential until unset. Requires Vault Enterprise 1.19+.
        """
        return pulumi.get(self, "disable_automated_rotation")

    @disable_automated_rotation.setter
    def disable_automated_rotation(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disable_automated_rotation", value)

    @_builtins.property
    @pulumi.getter(name="ec2Endpoint")
    def ec2_endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Override the URL Vault uses when making EC2 API
        calls.
        """
        return pulumi.get(self, "ec2_endpoint")

    @ec2_endpoint.setter
    def ec2_endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ec2_endpoint", value)

    @_builtins.property
    @pulumi.getter(name="iamEndpoint")
    def iam_endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Override the URL Vault uses when making IAM API
        calls.
        """
        return pulumi.get(self, "iam_endpoint")

    @iam_endpoint.setter
    def iam_endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "iam_endpoint", value)

    @_builtins.property
    @pulumi.getter(name="iamServerIdHeaderValue")
    def iam_server_id_header_value(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The value to require in the
        `X-Vault-AWS-IAM-Server-ID` header as part of `GetCallerIdentity` requests
        that are used in the IAM auth method.
        """
        return pulumi.get(self, "iam_server_id_header_value")

    @iam_server_id_header_value.setter
    def iam_server_id_header_value(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "iam_server_id_header_value", value)

    @_builtins.property
    @pulumi.getter(name="identityTokenAudience")
    def identity_token_audience(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The audience claim value. Mutually exclusive with `access_key`. 
        Requires Vault 1.17+. *Available only for Vault Enterprise*
        """
        return pulumi.get(self, "identity_token_audience")

    @identity_token_audience.setter
    def identity_token_audience(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "identity_token_audience", value)

    @_builtins.property
    @pulumi.getter(name="identityTokenTtl")
    def identity_token_ttl(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The TTL of generated identity tokens in seconds. Requires Vault 1.17+.
        *Available only for Vault Enterprise*
        """
        return pulumi.get(self, "identity_token_ttl")

    @identity_token_ttl.setter
    def identity_token_ttl(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "identity_token_ttl", value)

    @_builtins.property
    @pulumi.getter(name="maxRetries")
    def max_retries(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of max retries the client should use for recoverable errors. 
        The default `-1` falls back to the AWS SDK's default behavior.
        """
        return pulumi.get(self, "max_retries")

    @max_retries.setter
    def max_retries(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_retries", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Role ARN to assume for plugin identity token federation. Requires Vault 1.17+.
        *Available only for Vault Enterprise*
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "role_arn", value)

    @_builtins.property
    @pulumi.getter(name="rotationPeriod")
    def rotation_period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The amount of time in seconds Vault should wait before rotating the root credential.
        A zero value tells Vault not to rotate the root credential. The minimum rotation period is 10 seconds. Requires Vault Enterprise 1.19+.
        """
        return pulumi.get(self, "rotation_period")

    @rotation_period.setter
    def rotation_period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "rotation_period", value)

    @_builtins.property
    @pulumi.getter(name="rotationSchedule")
    def rotation_schedule(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The schedule, in [cron-style time format](https://en.wikipedia.org/wiki/Cron),
        defining the schedule on which Vault should rotate the root token. Requires Vault Enterprise 1.19+.
        """
        return pulumi.get(self, "rotation_schedule")

    @rotation_schedule.setter
    def rotation_schedule(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rotation_schedule", value)

    @_builtins.property
    @pulumi.getter(name="rotationWindow")
    def rotation_window(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum amount of time in seconds allowed to complete
        a rotation when a scheduled token rotation occurs. The default rotation window is
        unbound and the minimum allowable window is `3600`. Requires Vault Enterprise 1.19+.
        """
        return pulumi.get(self, "rotation_window")

    @rotation_window.setter
    def rotation_window(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "rotation_window", value)

    @_builtins.property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The AWS secret key that Vault should use for the
        auth backend.
        """
        return pulumi.get(self, "secret_key")

    @secret_key.setter
    def secret_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secret_key", value)

    @_builtins.property
    @pulumi.getter(name="stsEndpoint")
    def sts_endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Override the URL Vault uses when making STS API
        calls.
        """
        return pulumi.get(self, "sts_endpoint")

    @sts_endpoint.setter
    def sts_endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sts_endpoint", value)

    @_builtins.property
    @pulumi.getter(name="stsRegion")
    def sts_region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Override the default region when making STS API 
        calls. The `sts_endpoint` argument must be set when using `sts_region`.
        """
        return pulumi.get(self, "sts_region")

    @sts_region.setter
    def sts_region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sts_region", value)

    @_builtins.property
    @pulumi.getter(name="useStsRegionFromClient")
    def use_sts_region_from_client(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Available in Vault v1.15+. If set, 
        overrides both `sts_endpoint` and `sts_region` to instead use the region
        specified in the client request headers for IAM-based authentication.
        This can be useful when you have client requests coming from different
        regions and want flexibility in which regional STS API is used.
        """
        return pulumi.get(self, "use_sts_region_from_client")

    @use_sts_region_from_client.setter
    def use_sts_region_from_client(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "use_sts_region_from_client", value)


@pulumi.type_token("vault:aws/authBackendClient:AuthBackendClient")
class AuthBackendClient(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_key: Optional[pulumi.Input[_builtins.str]] = None,
                 allowed_sts_header_values: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 backend: Optional[pulumi.Input[_builtins.str]] = None,
                 disable_automated_rotation: Optional[pulumi.Input[_builtins.bool]] = None,
                 ec2_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 iam_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 iam_server_id_header_value: Optional[pulumi.Input[_builtins.str]] = None,
                 identity_token_audience: Optional[pulumi.Input[_builtins.str]] = None,
                 identity_token_ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 max_retries: Optional[pulumi.Input[_builtins.int]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 rotation_period: Optional[pulumi.Input[_builtins.int]] = None,
                 rotation_schedule: Optional[pulumi.Input[_builtins.str]] = None,
                 rotation_window: Optional[pulumi.Input[_builtins.int]] = None,
                 secret_key: Optional[pulumi.Input[_builtins.str]] = None,
                 sts_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 sts_region: Optional[pulumi.Input[_builtins.str]] = None,
                 use_sts_region_from_client: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        ## Example Usage

        You can setup the AWS auth engine with Workload Identity Federation (WIF) for a secret-less configuration:
        ```python
        import pulumi
        import pulumi_vault as vault

        example = vault.AuthBackend("example", type="aws")
        example_auth_backend_client = vault.aws.AuthBackendClient("example",
            identity_token_audience="<TOKEN_AUDIENCE>",
            identity_token_ttl="<TOKEN_TTL>",
            role_arn="<AWS_ROLE_ARN>",
            rotation_schedule="0 * * * SAT",
            rotation_window=3600)
        ```

        ```python
        import pulumi
        import pulumi_vault as vault

        example = vault.AuthBackend("example", type="aws")
        example_auth_backend_client = vault.aws.AuthBackendClient("example",
            backend=example.path,
            access_key="INSERT_AWS_ACCESS_KEY",
            secret_key="INSERT_AWS_SECRET_KEY",
            rotation_schedule="0 * * * SAT",
            rotation_window=3600,
            allowed_sts_header_values=[
                "X-Custom-Header",
                "X-Another-Header",
            ])
        ```

        ## Import

        AWS auth backend clients can be imported using `auth/`, the `backend` path, and `/config/client` e.g.

        ```sh
        $ pulumi import vault:aws/authBackendClient:AuthBackendClient example auth/aws/config/client
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] access_key: The AWS access key that Vault should use for the
               auth backend. Mutually exclusive with `identity_token_audience`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_sts_header_values: List of additional headers that are allowed to be in STS request headers.
               The headers are automatically canonicalized (e.g., `content-type` becomes `Content-Type`). Duplicate values are automatically
               removed. This can be useful when you need to allow specific headers in STS requests for IAM-based authentication.
        :param pulumi.Input[_builtins.str] backend: The path the AWS auth backend being configured was
               mounted at.  Defaults to `aws`.
        :param pulumi.Input[_builtins.bool] disable_automated_rotation: Cancels all upcoming rotations of the root credential until unset. Requires Vault Enterprise 1.19+.
        :param pulumi.Input[_builtins.str] ec2_endpoint: Override the URL Vault uses when making EC2 API
               calls.
        :param pulumi.Input[_builtins.str] iam_endpoint: Override the URL Vault uses when making IAM API
               calls.
        :param pulumi.Input[_builtins.str] iam_server_id_header_value: The value to require in the
               `X-Vault-AWS-IAM-Server-ID` header as part of `GetCallerIdentity` requests
               that are used in the IAM auth method.
        :param pulumi.Input[_builtins.str] identity_token_audience: The audience claim value. Mutually exclusive with `access_key`. 
               Requires Vault 1.17+. *Available only for Vault Enterprise*
        :param pulumi.Input[_builtins.int] identity_token_ttl: The TTL of generated identity tokens in seconds. Requires Vault 1.17+.
               *Available only for Vault Enterprise*
        :param pulumi.Input[_builtins.int] max_retries: Number of max retries the client should use for recoverable errors. 
               The default `-1` falls back to the AWS SDK's default behavior.
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.str] role_arn: Role ARN to assume for plugin identity token federation. Requires Vault 1.17+.
               *Available only for Vault Enterprise*
        :param pulumi.Input[_builtins.int] rotation_period: The amount of time in seconds Vault should wait before rotating the root credential.
               A zero value tells Vault not to rotate the root credential. The minimum rotation period is 10 seconds. Requires Vault Enterprise 1.19+.
        :param pulumi.Input[_builtins.str] rotation_schedule: The schedule, in [cron-style time format](https://en.wikipedia.org/wiki/Cron),
               defining the schedule on which Vault should rotate the root token. Requires Vault Enterprise 1.19+.
        :param pulumi.Input[_builtins.int] rotation_window: The maximum amount of time in seconds allowed to complete
               a rotation when a scheduled token rotation occurs. The default rotation window is
               unbound and the minimum allowable window is `3600`. Requires Vault Enterprise 1.19+.
        :param pulumi.Input[_builtins.str] secret_key: The AWS secret key that Vault should use for the
               auth backend.
        :param pulumi.Input[_builtins.str] sts_endpoint: Override the URL Vault uses when making STS API
               calls.
        :param pulumi.Input[_builtins.str] sts_region: Override the default region when making STS API 
               calls. The `sts_endpoint` argument must be set when using `sts_region`.
        :param pulumi.Input[_builtins.bool] use_sts_region_from_client: Available in Vault v1.15+. If set, 
               overrides both `sts_endpoint` and `sts_region` to instead use the region
               specified in the client request headers for IAM-based authentication.
               This can be useful when you have client requests coming from different
               regions and want flexibility in which regional STS API is used.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[AuthBackendClientArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        You can setup the AWS auth engine with Workload Identity Federation (WIF) for a secret-less configuration:
        ```python
        import pulumi
        import pulumi_vault as vault

        example = vault.AuthBackend("example", type="aws")
        example_auth_backend_client = vault.aws.AuthBackendClient("example",
            identity_token_audience="<TOKEN_AUDIENCE>",
            identity_token_ttl="<TOKEN_TTL>",
            role_arn="<AWS_ROLE_ARN>",
            rotation_schedule="0 * * * SAT",
            rotation_window=3600)
        ```

        ```python
        import pulumi
        import pulumi_vault as vault

        example = vault.AuthBackend("example", type="aws")
        example_auth_backend_client = vault.aws.AuthBackendClient("example",
            backend=example.path,
            access_key="INSERT_AWS_ACCESS_KEY",
            secret_key="INSERT_AWS_SECRET_KEY",
            rotation_schedule="0 * * * SAT",
            rotation_window=3600,
            allowed_sts_header_values=[
                "X-Custom-Header",
                "X-Another-Header",
            ])
        ```

        ## Import

        AWS auth backend clients can be imported using `auth/`, the `backend` path, and `/config/client` e.g.

        ```sh
        $ pulumi import vault:aws/authBackendClient:AuthBackendClient example auth/aws/config/client
        ```

        :param str resource_name: The name of the resource.
        :param AuthBackendClientArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AuthBackendClientArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_key: Optional[pulumi.Input[_builtins.str]] = None,
                 allowed_sts_header_values: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 backend: Optional[pulumi.Input[_builtins.str]] = None,
                 disable_automated_rotation: Optional[pulumi.Input[_builtins.bool]] = None,
                 ec2_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 iam_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 iam_server_id_header_value: Optional[pulumi.Input[_builtins.str]] = None,
                 identity_token_audience: Optional[pulumi.Input[_builtins.str]] = None,
                 identity_token_ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 max_retries: Optional[pulumi.Input[_builtins.int]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 rotation_period: Optional[pulumi.Input[_builtins.int]] = None,
                 rotation_schedule: Optional[pulumi.Input[_builtins.str]] = None,
                 rotation_window: Optional[pulumi.Input[_builtins.int]] = None,
                 secret_key: Optional[pulumi.Input[_builtins.str]] = None,
                 sts_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 sts_region: Optional[pulumi.Input[_builtins.str]] = None,
                 use_sts_region_from_client: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AuthBackendClientArgs.__new__(AuthBackendClientArgs)

            __props__.__dict__["access_key"] = None if access_key is None else pulumi.Output.secret(access_key)
            __props__.__dict__["allowed_sts_header_values"] = allowed_sts_header_values
            __props__.__dict__["backend"] = backend
            __props__.__dict__["disable_automated_rotation"] = disable_automated_rotation
            __props__.__dict__["ec2_endpoint"] = ec2_endpoint
            __props__.__dict__["iam_endpoint"] = iam_endpoint
            __props__.__dict__["iam_server_id_header_value"] = iam_server_id_header_value
            __props__.__dict__["identity_token_audience"] = identity_token_audience
            __props__.__dict__["identity_token_ttl"] = identity_token_ttl
            __props__.__dict__["max_retries"] = max_retries
            __props__.__dict__["namespace"] = namespace
            __props__.__dict__["role_arn"] = role_arn
            __props__.__dict__["rotation_period"] = rotation_period
            __props__.__dict__["rotation_schedule"] = rotation_schedule
            __props__.__dict__["rotation_window"] = rotation_window
            __props__.__dict__["secret_key"] = None if secret_key is None else pulumi.Output.secret(secret_key)
            __props__.__dict__["sts_endpoint"] = sts_endpoint
            __props__.__dict__["sts_region"] = sts_region
            __props__.__dict__["use_sts_region_from_client"] = use_sts_region_from_client
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["accessKey", "secretKey"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(AuthBackendClient, __self__).__init__(
            'vault:aws/authBackendClient:AuthBackendClient',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_key: Optional[pulumi.Input[_builtins.str]] = None,
            allowed_sts_header_values: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            backend: Optional[pulumi.Input[_builtins.str]] = None,
            disable_automated_rotation: Optional[pulumi.Input[_builtins.bool]] = None,
            ec2_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
            iam_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
            iam_server_id_header_value: Optional[pulumi.Input[_builtins.str]] = None,
            identity_token_audience: Optional[pulumi.Input[_builtins.str]] = None,
            identity_token_ttl: Optional[pulumi.Input[_builtins.int]] = None,
            max_retries: Optional[pulumi.Input[_builtins.int]] = None,
            namespace: Optional[pulumi.Input[_builtins.str]] = None,
            role_arn: Optional[pulumi.Input[_builtins.str]] = None,
            rotation_period: Optional[pulumi.Input[_builtins.int]] = None,
            rotation_schedule: Optional[pulumi.Input[_builtins.str]] = None,
            rotation_window: Optional[pulumi.Input[_builtins.int]] = None,
            secret_key: Optional[pulumi.Input[_builtins.str]] = None,
            sts_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
            sts_region: Optional[pulumi.Input[_builtins.str]] = None,
            use_sts_region_from_client: Optional[pulumi.Input[_builtins.bool]] = None) -> 'AuthBackendClient':
        """
        Get an existing AuthBackendClient resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] access_key: The AWS access key that Vault should use for the
               auth backend. Mutually exclusive with `identity_token_audience`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_sts_header_values: List of additional headers that are allowed to be in STS request headers.
               The headers are automatically canonicalized (e.g., `content-type` becomes `Content-Type`). Duplicate values are automatically
               removed. This can be useful when you need to allow specific headers in STS requests for IAM-based authentication.
        :param pulumi.Input[_builtins.str] backend: The path the AWS auth backend being configured was
               mounted at.  Defaults to `aws`.
        :param pulumi.Input[_builtins.bool] disable_automated_rotation: Cancels all upcoming rotations of the root credential until unset. Requires Vault Enterprise 1.19+.
        :param pulumi.Input[_builtins.str] ec2_endpoint: Override the URL Vault uses when making EC2 API
               calls.
        :param pulumi.Input[_builtins.str] iam_endpoint: Override the URL Vault uses when making IAM API
               calls.
        :param pulumi.Input[_builtins.str] iam_server_id_header_value: The value to require in the
               `X-Vault-AWS-IAM-Server-ID` header as part of `GetCallerIdentity` requests
               that are used in the IAM auth method.
        :param pulumi.Input[_builtins.str] identity_token_audience: The audience claim value. Mutually exclusive with `access_key`. 
               Requires Vault 1.17+. *Available only for Vault Enterprise*
        :param pulumi.Input[_builtins.int] identity_token_ttl: The TTL of generated identity tokens in seconds. Requires Vault 1.17+.
               *Available only for Vault Enterprise*
        :param pulumi.Input[_builtins.int] max_retries: Number of max retries the client should use for recoverable errors. 
               The default `-1` falls back to the AWS SDK's default behavior.
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.str] role_arn: Role ARN to assume for plugin identity token federation. Requires Vault 1.17+.
               *Available only for Vault Enterprise*
        :param pulumi.Input[_builtins.int] rotation_period: The amount of time in seconds Vault should wait before rotating the root credential.
               A zero value tells Vault not to rotate the root credential. The minimum rotation period is 10 seconds. Requires Vault Enterprise 1.19+.
        :param pulumi.Input[_builtins.str] rotation_schedule: The schedule, in [cron-style time format](https://en.wikipedia.org/wiki/Cron),
               defining the schedule on which Vault should rotate the root token. Requires Vault Enterprise 1.19+.
        :param pulumi.Input[_builtins.int] rotation_window: The maximum amount of time in seconds allowed to complete
               a rotation when a scheduled token rotation occurs. The default rotation window is
               unbound and the minimum allowable window is `3600`. Requires Vault Enterprise 1.19+.
        :param pulumi.Input[_builtins.str] secret_key: The AWS secret key that Vault should use for the
               auth backend.
        :param pulumi.Input[_builtins.str] sts_endpoint: Override the URL Vault uses when making STS API
               calls.
        :param pulumi.Input[_builtins.str] sts_region: Override the default region when making STS API 
               calls. The `sts_endpoint` argument must be set when using `sts_region`.
        :param pulumi.Input[_builtins.bool] use_sts_region_from_client: Available in Vault v1.15+. If set, 
               overrides both `sts_endpoint` and `sts_region` to instead use the region
               specified in the client request headers for IAM-based authentication.
               This can be useful when you have client requests coming from different
               regions and want flexibility in which regional STS API is used.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AuthBackendClientState.__new__(_AuthBackendClientState)

        __props__.__dict__["access_key"] = access_key
        __props__.__dict__["allowed_sts_header_values"] = allowed_sts_header_values
        __props__.__dict__["backend"] = backend
        __props__.__dict__["disable_automated_rotation"] = disable_automated_rotation
        __props__.__dict__["ec2_endpoint"] = ec2_endpoint
        __props__.__dict__["iam_endpoint"] = iam_endpoint
        __props__.__dict__["iam_server_id_header_value"] = iam_server_id_header_value
        __props__.__dict__["identity_token_audience"] = identity_token_audience
        __props__.__dict__["identity_token_ttl"] = identity_token_ttl
        __props__.__dict__["max_retries"] = max_retries
        __props__.__dict__["namespace"] = namespace
        __props__.__dict__["role_arn"] = role_arn
        __props__.__dict__["rotation_period"] = rotation_period
        __props__.__dict__["rotation_schedule"] = rotation_schedule
        __props__.__dict__["rotation_window"] = rotation_window
        __props__.__dict__["secret_key"] = secret_key
        __props__.__dict__["sts_endpoint"] = sts_endpoint
        __props__.__dict__["sts_region"] = sts_region
        __props__.__dict__["use_sts_region_from_client"] = use_sts_region_from_client
        return AuthBackendClient(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The AWS access key that Vault should use for the
        auth backend. Mutually exclusive with `identity_token_audience`.
        """
        return pulumi.get(self, "access_key")

    @_builtins.property
    @pulumi.getter(name="allowedStsHeaderValues")
    def allowed_sts_header_values(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of additional headers that are allowed to be in STS request headers.
        The headers are automatically canonicalized (e.g., `content-type` becomes `Content-Type`). Duplicate values are automatically
        removed. This can be useful when you need to allow specific headers in STS requests for IAM-based authentication.
        """
        return pulumi.get(self, "allowed_sts_header_values")

    @_builtins.property
    @pulumi.getter
    def backend(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The path the AWS auth backend being configured was
        mounted at.  Defaults to `aws`.
        """
        return pulumi.get(self, "backend")

    @_builtins.property
    @pulumi.getter(name="disableAutomatedRotation")
    def disable_automated_rotation(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Cancels all upcoming rotations of the root credential until unset. Requires Vault Enterprise 1.19+.
        """
        return pulumi.get(self, "disable_automated_rotation")

    @_builtins.property
    @pulumi.getter(name="ec2Endpoint")
    def ec2_endpoint(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Override the URL Vault uses when making EC2 API
        calls.
        """
        return pulumi.get(self, "ec2_endpoint")

    @_builtins.property
    @pulumi.getter(name="iamEndpoint")
    def iam_endpoint(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Override the URL Vault uses when making IAM API
        calls.
        """
        return pulumi.get(self, "iam_endpoint")

    @_builtins.property
    @pulumi.getter(name="iamServerIdHeaderValue")
    def iam_server_id_header_value(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The value to require in the
        `X-Vault-AWS-IAM-Server-ID` header as part of `GetCallerIdentity` requests
        that are used in the IAM auth method.
        """
        return pulumi.get(self, "iam_server_id_header_value")

    @_builtins.property
    @pulumi.getter(name="identityTokenAudience")
    def identity_token_audience(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The audience claim value. Mutually exclusive with `access_key`. 
        Requires Vault 1.17+. *Available only for Vault Enterprise*
        """
        return pulumi.get(self, "identity_token_audience")

    @_builtins.property
    @pulumi.getter(name="identityTokenTtl")
    def identity_token_ttl(self) -> pulumi.Output[_builtins.int]:
        """
        The TTL of generated identity tokens in seconds. Requires Vault 1.17+.
        *Available only for Vault Enterprise*
        """
        return pulumi.get(self, "identity_token_ttl")

    @_builtins.property
    @pulumi.getter(name="maxRetries")
    def max_retries(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Number of max retries the client should use for recoverable errors. 
        The default `-1` falls back to the AWS SDK's default behavior.
        """
        return pulumi.get(self, "max_retries")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Role ARN to assume for plugin identity token federation. Requires Vault 1.17+.
        *Available only for Vault Enterprise*
        """
        return pulumi.get(self, "role_arn")

    @_builtins.property
    @pulumi.getter(name="rotationPeriod")
    def rotation_period(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The amount of time in seconds Vault should wait before rotating the root credential.
        A zero value tells Vault not to rotate the root credential. The minimum rotation period is 10 seconds. Requires Vault Enterprise 1.19+.
        """
        return pulumi.get(self, "rotation_period")

    @_builtins.property
    @pulumi.getter(name="rotationSchedule")
    def rotation_schedule(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The schedule, in [cron-style time format](https://en.wikipedia.org/wiki/Cron),
        defining the schedule on which Vault should rotate the root token. Requires Vault Enterprise 1.19+.
        """
        return pulumi.get(self, "rotation_schedule")

    @_builtins.property
    @pulumi.getter(name="rotationWindow")
    def rotation_window(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The maximum amount of time in seconds allowed to complete
        a rotation when a scheduled token rotation occurs. The default rotation window is
        unbound and the minimum allowable window is `3600`. Requires Vault Enterprise 1.19+.
        """
        return pulumi.get(self, "rotation_window")

    @_builtins.property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The AWS secret key that Vault should use for the
        auth backend.
        """
        return pulumi.get(self, "secret_key")

    @_builtins.property
    @pulumi.getter(name="stsEndpoint")
    def sts_endpoint(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Override the URL Vault uses when making STS API
        calls.
        """
        return pulumi.get(self, "sts_endpoint")

    @_builtins.property
    @pulumi.getter(name="stsRegion")
    def sts_region(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Override the default region when making STS API 
        calls. The `sts_endpoint` argument must be set when using `sts_region`.
        """
        return pulumi.get(self, "sts_region")

    @_builtins.property
    @pulumi.getter(name="useStsRegionFromClient")
    def use_sts_region_from_client(self) -> pulumi.Output[_builtins.bool]:
        """
        Available in Vault v1.15+. If set, 
        overrides both `sts_endpoint` and `sts_region` to instead use the region
        specified in the client request headers for IAM-based authentication.
        This can be useful when you have client requests coming from different
        regions and want flexibility in which regional STS API is used.
        """
        return pulumi.get(self, "use_sts_region_from_client")

