# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['AuthBackendRoleTagArgs', 'AuthBackendRoleTag']

@pulumi.input_type
class AuthBackendRoleTagArgs:
    def __init__(__self__, *,
                 role: pulumi.Input[_builtins.str],
                 allow_instance_migration: Optional[pulumi.Input[_builtins.bool]] = None,
                 backend: Optional[pulumi.Input[_builtins.str]] = None,
                 disallow_reauthentication: Optional[pulumi.Input[_builtins.bool]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 max_ttl: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 policies: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a AuthBackendRoleTag resource.
        :param pulumi.Input[_builtins.str] role: The name of the AWS auth backend role to read
               role tags from, with no leading or trailing `/`s.
        :param pulumi.Input[_builtins.bool] allow_instance_migration: If set, allows migration of the underlying instances where the client resides. Use with caution.
        :param pulumi.Input[_builtins.str] backend: The path to the AWS auth backend to
               read role tags from, with no leading or trailing `/`s. Defaults to "aws".
        :param pulumi.Input[_builtins.bool] disallow_reauthentication: If set, only allows a single token to be granted per instance ID.
        :param pulumi.Input[_builtins.str] instance_id: Instance ID for which this tag is intended for. If set, the created tag can only be used by the instance with the given ID.
        :param pulumi.Input[_builtins.str] max_ttl: The maximum TTL of the tokens issued using this role.
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] policies: The policies to be associated with the tag. Must be a subset of the policies associated with the role.
        """
        pulumi.set(__self__, "role", role)
        if allow_instance_migration is not None:
            pulumi.set(__self__, "allow_instance_migration", allow_instance_migration)
        if backend is not None:
            pulumi.set(__self__, "backend", backend)
        if disallow_reauthentication is not None:
            pulumi.set(__self__, "disallow_reauthentication", disallow_reauthentication)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if max_ttl is not None:
            pulumi.set(__self__, "max_ttl", max_ttl)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if policies is not None:
            pulumi.set(__self__, "policies", policies)

    @_builtins.property
    @pulumi.getter
    def role(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the AWS auth backend role to read
        role tags from, with no leading or trailing `/`s.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "role", value)

    @_builtins.property
    @pulumi.getter(name="allowInstanceMigration")
    def allow_instance_migration(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If set, allows migration of the underlying instances where the client resides. Use with caution.
        """
        return pulumi.get(self, "allow_instance_migration")

    @allow_instance_migration.setter
    def allow_instance_migration(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "allow_instance_migration", value)

    @_builtins.property
    @pulumi.getter
    def backend(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The path to the AWS auth backend to
        read role tags from, with no leading or trailing `/`s. Defaults to "aws".
        """
        return pulumi.get(self, "backend")

    @backend.setter
    def backend(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backend", value)

    @_builtins.property
    @pulumi.getter(name="disallowReauthentication")
    def disallow_reauthentication(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If set, only allows a single token to be granted per instance ID.
        """
        return pulumi.get(self, "disallow_reauthentication")

    @disallow_reauthentication.setter
    def disallow_reauthentication(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disallow_reauthentication", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Instance ID for which this tag is intended for. If set, the created tag can only be used by the instance with the given ID.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter(name="maxTtl")
    def max_ttl(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The maximum TTL of the tokens issued using this role.
        """
        return pulumi.get(self, "max_ttl")

    @max_ttl.setter
    def max_ttl(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "max_ttl", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter
    def policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The policies to be associated with the tag. Must be a subset of the policies associated with the role.
        """
        return pulumi.get(self, "policies")

    @policies.setter
    def policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "policies", value)


@pulumi.input_type
class _AuthBackendRoleTagState:
    def __init__(__self__, *,
                 allow_instance_migration: Optional[pulumi.Input[_builtins.bool]] = None,
                 backend: Optional[pulumi.Input[_builtins.str]] = None,
                 disallow_reauthentication: Optional[pulumi.Input[_builtins.bool]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 max_ttl: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 policies: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 role: Optional[pulumi.Input[_builtins.str]] = None,
                 tag_key: Optional[pulumi.Input[_builtins.str]] = None,
                 tag_value: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering AuthBackendRoleTag resources.
        :param pulumi.Input[_builtins.bool] allow_instance_migration: If set, allows migration of the underlying instances where the client resides. Use with caution.
        :param pulumi.Input[_builtins.str] backend: The path to the AWS auth backend to
               read role tags from, with no leading or trailing `/`s. Defaults to "aws".
        :param pulumi.Input[_builtins.bool] disallow_reauthentication: If set, only allows a single token to be granted per instance ID.
        :param pulumi.Input[_builtins.str] instance_id: Instance ID for which this tag is intended for. If set, the created tag can only be used by the instance with the given ID.
        :param pulumi.Input[_builtins.str] max_ttl: The maximum TTL of the tokens issued using this role.
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] policies: The policies to be associated with the tag. Must be a subset of the policies associated with the role.
        :param pulumi.Input[_builtins.str] role: The name of the AWS auth backend role to read
               role tags from, with no leading or trailing `/`s.
        :param pulumi.Input[_builtins.str] tag_key: The key of the role tag.
        :param pulumi.Input[_builtins.str] tag_value: The value to set the role key.
        """
        if allow_instance_migration is not None:
            pulumi.set(__self__, "allow_instance_migration", allow_instance_migration)
        if backend is not None:
            pulumi.set(__self__, "backend", backend)
        if disallow_reauthentication is not None:
            pulumi.set(__self__, "disallow_reauthentication", disallow_reauthentication)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if max_ttl is not None:
            pulumi.set(__self__, "max_ttl", max_ttl)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if policies is not None:
            pulumi.set(__self__, "policies", policies)
        if role is not None:
            pulumi.set(__self__, "role", role)
        if tag_key is not None:
            pulumi.set(__self__, "tag_key", tag_key)
        if tag_value is not None:
            pulumi.set(__self__, "tag_value", tag_value)

    @_builtins.property
    @pulumi.getter(name="allowInstanceMigration")
    def allow_instance_migration(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If set, allows migration of the underlying instances where the client resides. Use with caution.
        """
        return pulumi.get(self, "allow_instance_migration")

    @allow_instance_migration.setter
    def allow_instance_migration(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "allow_instance_migration", value)

    @_builtins.property
    @pulumi.getter
    def backend(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The path to the AWS auth backend to
        read role tags from, with no leading or trailing `/`s. Defaults to "aws".
        """
        return pulumi.get(self, "backend")

    @backend.setter
    def backend(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backend", value)

    @_builtins.property
    @pulumi.getter(name="disallowReauthentication")
    def disallow_reauthentication(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If set, only allows a single token to be granted per instance ID.
        """
        return pulumi.get(self, "disallow_reauthentication")

    @disallow_reauthentication.setter
    def disallow_reauthentication(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disallow_reauthentication", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Instance ID for which this tag is intended for. If set, the created tag can only be used by the instance with the given ID.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter(name="maxTtl")
    def max_ttl(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The maximum TTL of the tokens issued using this role.
        """
        return pulumi.get(self, "max_ttl")

    @max_ttl.setter
    def max_ttl(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "max_ttl", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter
    def policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The policies to be associated with the tag. Must be a subset of the policies associated with the role.
        """
        return pulumi.get(self, "policies")

    @policies.setter
    def policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "policies", value)

    @_builtins.property
    @pulumi.getter
    def role(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the AWS auth backend role to read
        role tags from, with no leading or trailing `/`s.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "role", value)

    @_builtins.property
    @pulumi.getter(name="tagKey")
    def tag_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The key of the role tag.
        """
        return pulumi.get(self, "tag_key")

    @tag_key.setter
    def tag_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tag_key", value)

    @_builtins.property
    @pulumi.getter(name="tagValue")
    def tag_value(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The value to set the role key.
        """
        return pulumi.get(self, "tag_value")

    @tag_value.setter
    def tag_value(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tag_value", value)


@pulumi.type_token("vault:aws/authBackendRoleTag:AuthBackendRoleTag")
class AuthBackendRoleTag(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allow_instance_migration: Optional[pulumi.Input[_builtins.bool]] = None,
                 backend: Optional[pulumi.Input[_builtins.str]] = None,
                 disallow_reauthentication: Optional[pulumi.Input[_builtins.bool]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 max_ttl: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 policies: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 role: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Reads role tag information from an AWS auth backend in Vault.

        ## Example Usage

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] allow_instance_migration: If set, allows migration of the underlying instances where the client resides. Use with caution.
        :param pulumi.Input[_builtins.str] backend: The path to the AWS auth backend to
               read role tags from, with no leading or trailing `/`s. Defaults to "aws".
        :param pulumi.Input[_builtins.bool] disallow_reauthentication: If set, only allows a single token to be granted per instance ID.
        :param pulumi.Input[_builtins.str] instance_id: Instance ID for which this tag is intended for. If set, the created tag can only be used by the instance with the given ID.
        :param pulumi.Input[_builtins.str] max_ttl: The maximum TTL of the tokens issued using this role.
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] policies: The policies to be associated with the tag. Must be a subset of the policies associated with the role.
        :param pulumi.Input[_builtins.str] role: The name of the AWS auth backend role to read
               role tags from, with no leading or trailing `/`s.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AuthBackendRoleTagArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Reads role tag information from an AWS auth backend in Vault.

        ## Example Usage

        :param str resource_name: The name of the resource.
        :param AuthBackendRoleTagArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AuthBackendRoleTagArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allow_instance_migration: Optional[pulumi.Input[_builtins.bool]] = None,
                 backend: Optional[pulumi.Input[_builtins.str]] = None,
                 disallow_reauthentication: Optional[pulumi.Input[_builtins.bool]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 max_ttl: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 policies: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 role: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AuthBackendRoleTagArgs.__new__(AuthBackendRoleTagArgs)

            __props__.__dict__["allow_instance_migration"] = allow_instance_migration
            __props__.__dict__["backend"] = backend
            __props__.__dict__["disallow_reauthentication"] = disallow_reauthentication
            __props__.__dict__["instance_id"] = instance_id
            __props__.__dict__["max_ttl"] = max_ttl
            __props__.__dict__["namespace"] = namespace
            __props__.__dict__["policies"] = policies
            if role is None and not opts.urn:
                raise TypeError("Missing required property 'role'")
            __props__.__dict__["role"] = role
            __props__.__dict__["tag_key"] = None
            __props__.__dict__["tag_value"] = None
        super(AuthBackendRoleTag, __self__).__init__(
            'vault:aws/authBackendRoleTag:AuthBackendRoleTag',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            allow_instance_migration: Optional[pulumi.Input[_builtins.bool]] = None,
            backend: Optional[pulumi.Input[_builtins.str]] = None,
            disallow_reauthentication: Optional[pulumi.Input[_builtins.bool]] = None,
            instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            max_ttl: Optional[pulumi.Input[_builtins.str]] = None,
            namespace: Optional[pulumi.Input[_builtins.str]] = None,
            policies: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            role: Optional[pulumi.Input[_builtins.str]] = None,
            tag_key: Optional[pulumi.Input[_builtins.str]] = None,
            tag_value: Optional[pulumi.Input[_builtins.str]] = None) -> 'AuthBackendRoleTag':
        """
        Get an existing AuthBackendRoleTag resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] allow_instance_migration: If set, allows migration of the underlying instances where the client resides. Use with caution.
        :param pulumi.Input[_builtins.str] backend: The path to the AWS auth backend to
               read role tags from, with no leading or trailing `/`s. Defaults to "aws".
        :param pulumi.Input[_builtins.bool] disallow_reauthentication: If set, only allows a single token to be granted per instance ID.
        :param pulumi.Input[_builtins.str] instance_id: Instance ID for which this tag is intended for. If set, the created tag can only be used by the instance with the given ID.
        :param pulumi.Input[_builtins.str] max_ttl: The maximum TTL of the tokens issued using this role.
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] policies: The policies to be associated with the tag. Must be a subset of the policies associated with the role.
        :param pulumi.Input[_builtins.str] role: The name of the AWS auth backend role to read
               role tags from, with no leading or trailing `/`s.
        :param pulumi.Input[_builtins.str] tag_key: The key of the role tag.
        :param pulumi.Input[_builtins.str] tag_value: The value to set the role key.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AuthBackendRoleTagState.__new__(_AuthBackendRoleTagState)

        __props__.__dict__["allow_instance_migration"] = allow_instance_migration
        __props__.__dict__["backend"] = backend
        __props__.__dict__["disallow_reauthentication"] = disallow_reauthentication
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["max_ttl"] = max_ttl
        __props__.__dict__["namespace"] = namespace
        __props__.__dict__["policies"] = policies
        __props__.__dict__["role"] = role
        __props__.__dict__["tag_key"] = tag_key
        __props__.__dict__["tag_value"] = tag_value
        return AuthBackendRoleTag(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="allowInstanceMigration")
    def allow_instance_migration(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        If set, allows migration of the underlying instances where the client resides. Use with caution.
        """
        return pulumi.get(self, "allow_instance_migration")

    @_builtins.property
    @pulumi.getter
    def backend(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The path to the AWS auth backend to
        read role tags from, with no leading or trailing `/`s. Defaults to "aws".
        """
        return pulumi.get(self, "backend")

    @_builtins.property
    @pulumi.getter(name="disallowReauthentication")
    def disallow_reauthentication(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        If set, only allows a single token to be granted per instance ID.
        """
        return pulumi.get(self, "disallow_reauthentication")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Instance ID for which this tag is intended for. If set, the created tag can only be used by the instance with the given ID.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter(name="maxTtl")
    def max_ttl(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The maximum TTL of the tokens issued using this role.
        """
        return pulumi.get(self, "max_ttl")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter
    def policies(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        The policies to be associated with the tag. Must be a subset of the policies associated with the role.
        """
        return pulumi.get(self, "policies")

    @_builtins.property
    @pulumi.getter
    def role(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the AWS auth backend role to read
        role tags from, with no leading or trailing `/`s.
        """
        return pulumi.get(self, "role")

    @_builtins.property
    @pulumi.getter(name="tagKey")
    def tag_key(self) -> pulumi.Output[_builtins.str]:
        """
        The key of the role tag.
        """
        return pulumi.get(self, "tag_key")

    @_builtins.property
    @pulumi.getter(name="tagValue")
    def tag_value(self) -> pulumi.Output[_builtins.str]:
        """
        The value to set the role key.
        """
        return pulumi.get(self, "tag_value")

