# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'UiCustomMessageLink',
    'AuthLogin',
    'AuthLoginAws',
    'AuthLoginAzure',
    'AuthLoginCert',
    'AuthLoginGcp',
    'AuthLoginJwt',
    'AuthLoginKerberos',
    'AuthLoginOci',
    'AuthLoginOidc',
    'AuthLoginRadius',
    'AuthLoginTokenFile',
    'AuthLoginUserpass',
    'ClientAuth',
    'Headers',
]

@pulumi.output_type
class UiCustomMessageLink(dict):
    def __init__(__self__, *,
                 href: _builtins.str,
                 title: _builtins.str):
        """
        :param _builtins.str href: The URL of the hyperlink
        :param _builtins.str title: The title of the hyperlink
        """
        pulumi.set(__self__, "href", href)
        pulumi.set(__self__, "title", title)

    @_builtins.property
    @pulumi.getter
    def href(self) -> _builtins.str:
        """
        The URL of the hyperlink
        """
        return pulumi.get(self, "href")

    @_builtins.property
    @pulumi.getter
    def title(self) -> _builtins.str:
        """
        The title of the hyperlink
        """
        return pulumi.get(self, "title")


@pulumi.output_type
class AuthLogin(dict):
    def __init__(__self__, *,
                 path: _builtins.str,
                 method: Optional[_builtins.str] = None,
                 namespace: Optional[_builtins.str] = None,
                 parameters: Optional[Mapping[str, _builtins.str]] = None,
                 use_root_namespace: Optional[_builtins.bool] = None):
        """
        :param _builtins.str namespace: The authentication engine's namespace. Conflicts with use_root_namespace
        :param _builtins.bool use_root_namespace: Authenticate to the root Vault namespace. Conflicts with namespace
        """
        pulumi.set(__self__, "path", path)
        if method is not None:
            pulumi.set(__self__, "method", method)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if use_root_namespace is not None:
            pulumi.set(__self__, "use_root_namespace", use_root_namespace)

    @_builtins.property
    @pulumi.getter
    def path(self) -> _builtins.str:
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter
    def method(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "method")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[_builtins.str]:
        """
        The authentication engine's namespace. Conflicts with use_root_namespace
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> Optional[Mapping[str, _builtins.str]]:
        return pulumi.get(self, "parameters")

    @_builtins.property
    @pulumi.getter(name="useRootNamespace")
    def use_root_namespace(self) -> Optional[_builtins.bool]:
        """
        Authenticate to the root Vault namespace. Conflicts with namespace
        """
        return pulumi.get(self, "use_root_namespace")


@pulumi.output_type
class AuthLoginAws(dict):
    def __init__(__self__, *,
                 role: _builtins.str,
                 aws_access_key_id: Optional[_builtins.str] = None,
                 aws_iam_endpoint: Optional[_builtins.str] = None,
                 aws_profile: Optional[_builtins.str] = None,
                 aws_region: Optional[_builtins.str] = None,
                 aws_role_arn: Optional[_builtins.str] = None,
                 aws_role_session_name: Optional[_builtins.str] = None,
                 aws_secret_access_key: Optional[_builtins.str] = None,
                 aws_session_token: Optional[_builtins.str] = None,
                 aws_shared_credentials_file: Optional[_builtins.str] = None,
                 aws_sts_endpoint: Optional[_builtins.str] = None,
                 aws_web_identity_token_file: Optional[_builtins.str] = None,
                 header_value: Optional[_builtins.str] = None,
                 mount: Optional[_builtins.str] = None,
                 namespace: Optional[_builtins.str] = None,
                 use_root_namespace: Optional[_builtins.bool] = None):
        """
        :param _builtins.str role: The Vault role to use when logging into Vault.
        :param _builtins.str aws_access_key_id: The AWS access key ID.
        :param _builtins.str aws_iam_endpoint: The IAM endpoint URL.
        :param _builtins.str aws_profile: The name of the AWS profile.
        :param _builtins.str aws_region: The AWS region.
        :param _builtins.str aws_role_arn: The ARN of the AWS Role to assume.Used during STS AssumeRole
        :param _builtins.str aws_role_session_name: Specifies the name to attach to the AWS role session. Used during STS AssumeRole
        :param _builtins.str aws_secret_access_key: The AWS secret access key.
        :param _builtins.str aws_session_token: The AWS session token.
        :param _builtins.str aws_shared_credentials_file: Path to the AWS shared credentials file.
        :param _builtins.str aws_sts_endpoint: The STS endpoint URL.
        :param _builtins.str aws_web_identity_token_file: Path to the file containing an OAuth 2.0 access token or OpenID Connect ID token.
        :param _builtins.str header_value: The Vault header value to include in the STS signing request.
        :param _builtins.str mount: The path where the authentication engine is mounted.
        :param _builtins.str namespace: The authentication engine's namespace. Conflicts with use_root_namespace
        :param _builtins.bool use_root_namespace: Authenticate to the root Vault namespace. Conflicts with namespace
        """
        pulumi.set(__self__, "role", role)
        if aws_access_key_id is not None:
            pulumi.set(__self__, "aws_access_key_id", aws_access_key_id)
        if aws_iam_endpoint is not None:
            pulumi.set(__self__, "aws_iam_endpoint", aws_iam_endpoint)
        if aws_profile is not None:
            pulumi.set(__self__, "aws_profile", aws_profile)
        if aws_region is not None:
            pulumi.set(__self__, "aws_region", aws_region)
        if aws_role_arn is not None:
            pulumi.set(__self__, "aws_role_arn", aws_role_arn)
        if aws_role_session_name is not None:
            pulumi.set(__self__, "aws_role_session_name", aws_role_session_name)
        if aws_secret_access_key is not None:
            pulumi.set(__self__, "aws_secret_access_key", aws_secret_access_key)
        if aws_session_token is not None:
            pulumi.set(__self__, "aws_session_token", aws_session_token)
        if aws_shared_credentials_file is not None:
            pulumi.set(__self__, "aws_shared_credentials_file", aws_shared_credentials_file)
        if aws_sts_endpoint is not None:
            pulumi.set(__self__, "aws_sts_endpoint", aws_sts_endpoint)
        if aws_web_identity_token_file is not None:
            pulumi.set(__self__, "aws_web_identity_token_file", aws_web_identity_token_file)
        if header_value is not None:
            pulumi.set(__self__, "header_value", header_value)
        if mount is not None:
            pulumi.set(__self__, "mount", mount)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if use_root_namespace is not None:
            pulumi.set(__self__, "use_root_namespace", use_root_namespace)

    @_builtins.property
    @pulumi.getter
    def role(self) -> _builtins.str:
        """
        The Vault role to use when logging into Vault.
        """
        return pulumi.get(self, "role")

    @_builtins.property
    @pulumi.getter(name="awsAccessKeyId")
    def aws_access_key_id(self) -> Optional[_builtins.str]:
        """
        The AWS access key ID.
        """
        return pulumi.get(self, "aws_access_key_id")

    @_builtins.property
    @pulumi.getter(name="awsIamEndpoint")
    def aws_iam_endpoint(self) -> Optional[_builtins.str]:
        """
        The IAM endpoint URL.
        """
        return pulumi.get(self, "aws_iam_endpoint")

    @_builtins.property
    @pulumi.getter(name="awsProfile")
    def aws_profile(self) -> Optional[_builtins.str]:
        """
        The name of the AWS profile.
        """
        return pulumi.get(self, "aws_profile")

    @_builtins.property
    @pulumi.getter(name="awsRegion")
    def aws_region(self) -> Optional[_builtins.str]:
        """
        The AWS region.
        """
        return pulumi.get(self, "aws_region")

    @_builtins.property
    @pulumi.getter(name="awsRoleArn")
    def aws_role_arn(self) -> Optional[_builtins.str]:
        """
        The ARN of the AWS Role to assume.Used during STS AssumeRole
        """
        return pulumi.get(self, "aws_role_arn")

    @_builtins.property
    @pulumi.getter(name="awsRoleSessionName")
    def aws_role_session_name(self) -> Optional[_builtins.str]:
        """
        Specifies the name to attach to the AWS role session. Used during STS AssumeRole
        """
        return pulumi.get(self, "aws_role_session_name")

    @_builtins.property
    @pulumi.getter(name="awsSecretAccessKey")
    def aws_secret_access_key(self) -> Optional[_builtins.str]:
        """
        The AWS secret access key.
        """
        return pulumi.get(self, "aws_secret_access_key")

    @_builtins.property
    @pulumi.getter(name="awsSessionToken")
    def aws_session_token(self) -> Optional[_builtins.str]:
        """
        The AWS session token.
        """
        return pulumi.get(self, "aws_session_token")

    @_builtins.property
    @pulumi.getter(name="awsSharedCredentialsFile")
    def aws_shared_credentials_file(self) -> Optional[_builtins.str]:
        """
        Path to the AWS shared credentials file.
        """
        return pulumi.get(self, "aws_shared_credentials_file")

    @_builtins.property
    @pulumi.getter(name="awsStsEndpoint")
    def aws_sts_endpoint(self) -> Optional[_builtins.str]:
        """
        The STS endpoint URL.
        """
        return pulumi.get(self, "aws_sts_endpoint")

    @_builtins.property
    @pulumi.getter(name="awsWebIdentityTokenFile")
    def aws_web_identity_token_file(self) -> Optional[_builtins.str]:
        """
        Path to the file containing an OAuth 2.0 access token or OpenID Connect ID token.
        """
        return pulumi.get(self, "aws_web_identity_token_file")

    @_builtins.property
    @pulumi.getter(name="headerValue")
    def header_value(self) -> Optional[_builtins.str]:
        """
        The Vault header value to include in the STS signing request.
        """
        return pulumi.get(self, "header_value")

    @_builtins.property
    @pulumi.getter
    def mount(self) -> Optional[_builtins.str]:
        """
        The path where the authentication engine is mounted.
        """
        return pulumi.get(self, "mount")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[_builtins.str]:
        """
        The authentication engine's namespace. Conflicts with use_root_namespace
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter(name="useRootNamespace")
    def use_root_namespace(self) -> Optional[_builtins.bool]:
        """
        Authenticate to the root Vault namespace. Conflicts with namespace
        """
        return pulumi.get(self, "use_root_namespace")


@pulumi.output_type
class AuthLoginAzure(dict):
    def __init__(__self__, *,
                 resource_group_name: _builtins.str,
                 role: _builtins.str,
                 subscription_id: _builtins.str,
                 client_id: Optional[_builtins.str] = None,
                 jwt: Optional[_builtins.str] = None,
                 mount: Optional[_builtins.str] = None,
                 namespace: Optional[_builtins.str] = None,
                 scope: Optional[_builtins.str] = None,
                 tenant_id: Optional[_builtins.str] = None,
                 use_root_namespace: Optional[_builtins.bool] = None,
                 vm_name: Optional[_builtins.str] = None,
                 vmss_name: Optional[_builtins.str] = None):
        """
        :param _builtins.str resource_group_name: The resource group for the machine that generated the MSI token. This information can be obtained through instance metadata.
        :param _builtins.str role: Name of the login role.
        :param _builtins.str subscription_id: The subscription ID for the machine that generated the MSI token. This information can be obtained through instance metadata.
        :param _builtins.str client_id: The identity's client ID.
        :param _builtins.str jwt: A signed JSON Web Token. If not specified on will be created automatically
        :param _builtins.str mount: The path where the authentication engine is mounted.
        :param _builtins.str namespace: The authentication engine's namespace. Conflicts with use_root_namespace
        :param _builtins.str scope: The scopes to include in the token request.
        :param _builtins.str tenant_id: Provides the tenant ID to use in a multi-tenant authentication scenario.
        :param _builtins.bool use_root_namespace: Authenticate to the root Vault namespace. Conflicts with namespace
        :param _builtins.str vm_name: The virtual machine name for the machine that generated the MSI token. This information can be obtained through instance metadata.
        :param _builtins.str vmss_name: The virtual machine scale set name for the machine that generated the MSI token. This information can be obtained through instance metadata.
        """
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "role", role)
        pulumi.set(__self__, "subscription_id", subscription_id)
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if jwt is not None:
            pulumi.set(__self__, "jwt", jwt)
        if mount is not None:
            pulumi.set(__self__, "mount", mount)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if use_root_namespace is not None:
            pulumi.set(__self__, "use_root_namespace", use_root_namespace)
        if vm_name is not None:
            pulumi.set(__self__, "vm_name", vm_name)
        if vmss_name is not None:
            pulumi.set(__self__, "vmss_name", vmss_name)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> _builtins.str:
        """
        The resource group for the machine that generated the MSI token. This information can be obtained through instance metadata.
        """
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter
    def role(self) -> _builtins.str:
        """
        Name of the login role.
        """
        return pulumi.get(self, "role")

    @_builtins.property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> _builtins.str:
        """
        The subscription ID for the machine that generated the MSI token. This information can be obtained through instance metadata.
        """
        return pulumi.get(self, "subscription_id")

    @_builtins.property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[_builtins.str]:
        """
        The identity's client ID.
        """
        return pulumi.get(self, "client_id")

    @_builtins.property
    @pulumi.getter
    def jwt(self) -> Optional[_builtins.str]:
        """
        A signed JSON Web Token. If not specified on will be created automatically
        """
        return pulumi.get(self, "jwt")

    @_builtins.property
    @pulumi.getter
    def mount(self) -> Optional[_builtins.str]:
        """
        The path where the authentication engine is mounted.
        """
        return pulumi.get(self, "mount")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[_builtins.str]:
        """
        The authentication engine's namespace. Conflicts with use_root_namespace
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter
    def scope(self) -> Optional[_builtins.str]:
        """
        The scopes to include in the token request.
        """
        return pulumi.get(self, "scope")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[_builtins.str]:
        """
        Provides the tenant ID to use in a multi-tenant authentication scenario.
        """
        return pulumi.get(self, "tenant_id")

    @_builtins.property
    @pulumi.getter(name="useRootNamespace")
    def use_root_namespace(self) -> Optional[_builtins.bool]:
        """
        Authenticate to the root Vault namespace. Conflicts with namespace
        """
        return pulumi.get(self, "use_root_namespace")

    @_builtins.property
    @pulumi.getter(name="vmName")
    def vm_name(self) -> Optional[_builtins.str]:
        """
        The virtual machine name for the machine that generated the MSI token. This information can be obtained through instance metadata.
        """
        return pulumi.get(self, "vm_name")

    @_builtins.property
    @pulumi.getter(name="vmssName")
    def vmss_name(self) -> Optional[_builtins.str]:
        """
        The virtual machine scale set name for the machine that generated the MSI token. This information can be obtained through instance metadata.
        """
        return pulumi.get(self, "vmss_name")


@pulumi.output_type
class AuthLoginCert(dict):
    def __init__(__self__, *,
                 cert_file: _builtins.str,
                 key_file: _builtins.str,
                 mount: Optional[_builtins.str] = None,
                 name: Optional[_builtins.str] = None,
                 namespace: Optional[_builtins.str] = None,
                 use_root_namespace: Optional[_builtins.bool] = None):
        """
        :param _builtins.str cert_file: Path to a file containing the client certificate.
        :param _builtins.str key_file: Path to a file containing the private key that the certificate was issued for.
        :param _builtins.str mount: The path where the authentication engine is mounted.
        :param _builtins.str name: Name of the certificate's role
        :param _builtins.str namespace: The authentication engine's namespace. Conflicts with use_root_namespace
        :param _builtins.bool use_root_namespace: Authenticate to the root Vault namespace. Conflicts with namespace
        """
        pulumi.set(__self__, "cert_file", cert_file)
        pulumi.set(__self__, "key_file", key_file)
        if mount is not None:
            pulumi.set(__self__, "mount", mount)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if use_root_namespace is not None:
            pulumi.set(__self__, "use_root_namespace", use_root_namespace)

    @_builtins.property
    @pulumi.getter(name="certFile")
    def cert_file(self) -> _builtins.str:
        """
        Path to a file containing the client certificate.
        """
        return pulumi.get(self, "cert_file")

    @_builtins.property
    @pulumi.getter(name="keyFile")
    def key_file(self) -> _builtins.str:
        """
        Path to a file containing the private key that the certificate was issued for.
        """
        return pulumi.get(self, "key_file")

    @_builtins.property
    @pulumi.getter
    def mount(self) -> Optional[_builtins.str]:
        """
        The path where the authentication engine is mounted.
        """
        return pulumi.get(self, "mount")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        Name of the certificate's role
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[_builtins.str]:
        """
        The authentication engine's namespace. Conflicts with use_root_namespace
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter(name="useRootNamespace")
    def use_root_namespace(self) -> Optional[_builtins.bool]:
        """
        Authenticate to the root Vault namespace. Conflicts with namespace
        """
        return pulumi.get(self, "use_root_namespace")


@pulumi.output_type
class AuthLoginGcp(dict):
    def __init__(__self__, *,
                 role: _builtins.str,
                 credentials: Optional[_builtins.str] = None,
                 jwt: Optional[_builtins.str] = None,
                 mount: Optional[_builtins.str] = None,
                 namespace: Optional[_builtins.str] = None,
                 service_account: Optional[_builtins.str] = None,
                 use_root_namespace: Optional[_builtins.bool] = None):
        """
        :param _builtins.str role: Name of the login role.
        :param _builtins.str credentials: Path to the Google Cloud credentials file.
        :param _builtins.str jwt: A signed JSON Web Token.
        :param _builtins.str mount: The path where the authentication engine is mounted.
        :param _builtins.str namespace: The authentication engine's namespace. Conflicts with use_root_namespace
        :param _builtins.str service_account: IAM service account.
        :param _builtins.bool use_root_namespace: Authenticate to the root Vault namespace. Conflicts with namespace
        """
        pulumi.set(__self__, "role", role)
        if credentials is not None:
            pulumi.set(__self__, "credentials", credentials)
        if jwt is not None:
            pulumi.set(__self__, "jwt", jwt)
        if mount is not None:
            pulumi.set(__self__, "mount", mount)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if service_account is not None:
            pulumi.set(__self__, "service_account", service_account)
        if use_root_namespace is not None:
            pulumi.set(__self__, "use_root_namespace", use_root_namespace)

    @_builtins.property
    @pulumi.getter
    def role(self) -> _builtins.str:
        """
        Name of the login role.
        """
        return pulumi.get(self, "role")

    @_builtins.property
    @pulumi.getter
    def credentials(self) -> Optional[_builtins.str]:
        """
        Path to the Google Cloud credentials file.
        """
        return pulumi.get(self, "credentials")

    @_builtins.property
    @pulumi.getter
    def jwt(self) -> Optional[_builtins.str]:
        """
        A signed JSON Web Token.
        """
        return pulumi.get(self, "jwt")

    @_builtins.property
    @pulumi.getter
    def mount(self) -> Optional[_builtins.str]:
        """
        The path where the authentication engine is mounted.
        """
        return pulumi.get(self, "mount")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[_builtins.str]:
        """
        The authentication engine's namespace. Conflicts with use_root_namespace
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> Optional[_builtins.str]:
        """
        IAM service account.
        """
        return pulumi.get(self, "service_account")

    @_builtins.property
    @pulumi.getter(name="useRootNamespace")
    def use_root_namespace(self) -> Optional[_builtins.bool]:
        """
        Authenticate to the root Vault namespace. Conflicts with namespace
        """
        return pulumi.get(self, "use_root_namespace")


@pulumi.output_type
class AuthLoginJwt(dict):
    def __init__(__self__, *,
                 role: _builtins.str,
                 jwt: Optional[_builtins.str] = None,
                 mount: Optional[_builtins.str] = None,
                 namespace: Optional[_builtins.str] = None,
                 use_root_namespace: Optional[_builtins.bool] = None):
        """
        :param _builtins.str role: Name of the login role.
        :param _builtins.str jwt: A signed JSON Web Token.
        :param _builtins.str mount: The path where the authentication engine is mounted.
        :param _builtins.str namespace: The authentication engine's namespace. Conflicts with use_root_namespace
        :param _builtins.bool use_root_namespace: Authenticate to the root Vault namespace. Conflicts with namespace
        """
        pulumi.set(__self__, "role", role)
        if jwt is not None:
            pulumi.set(__self__, "jwt", jwt)
        if mount is not None:
            pulumi.set(__self__, "mount", mount)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if use_root_namespace is not None:
            pulumi.set(__self__, "use_root_namespace", use_root_namespace)

    @_builtins.property
    @pulumi.getter
    def role(self) -> _builtins.str:
        """
        Name of the login role.
        """
        return pulumi.get(self, "role")

    @_builtins.property
    @pulumi.getter
    def jwt(self) -> Optional[_builtins.str]:
        """
        A signed JSON Web Token.
        """
        return pulumi.get(self, "jwt")

    @_builtins.property
    @pulumi.getter
    def mount(self) -> Optional[_builtins.str]:
        """
        The path where the authentication engine is mounted.
        """
        return pulumi.get(self, "mount")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[_builtins.str]:
        """
        The authentication engine's namespace. Conflicts with use_root_namespace
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter(name="useRootNamespace")
    def use_root_namespace(self) -> Optional[_builtins.bool]:
        """
        Authenticate to the root Vault namespace. Conflicts with namespace
        """
        return pulumi.get(self, "use_root_namespace")


@pulumi.output_type
class AuthLoginKerberos(dict):
    def __init__(__self__, *,
                 disable_fast_negotiation: Optional[_builtins.bool] = None,
                 keytab_path: Optional[_builtins.str] = None,
                 krb5conf_path: Optional[_builtins.str] = None,
                 mount: Optional[_builtins.str] = None,
                 namespace: Optional[_builtins.str] = None,
                 realm: Optional[_builtins.str] = None,
                 remove_instance_name: Optional[_builtins.bool] = None,
                 service: Optional[_builtins.str] = None,
                 token: Optional[_builtins.str] = None,
                 use_root_namespace: Optional[_builtins.bool] = None,
                 username: Optional[_builtins.str] = None):
        """
        :param _builtins.bool disable_fast_negotiation: Disable the Kerberos FAST negotiation.
        :param _builtins.str keytab_path: The Kerberos keytab file containing the entry of the login entity.
        :param _builtins.str krb5conf_path: A valid Kerberos configuration file e.g. /etc/krb5.conf.
        :param _builtins.str mount: The path where the authentication engine is mounted.
        :param _builtins.str namespace: The authentication engine's namespace. Conflicts with use_root_namespace
        :param _builtins.str realm: The Kerberos server's authoritative authentication domain
        :param _builtins.bool remove_instance_name: Strip the host from the username found in the keytab.
        :param _builtins.str service: The service principle name.
        :param _builtins.str token: Simple and Protected GSSAPI Negotiation Mechanism (SPNEGO) token
        :param _builtins.bool use_root_namespace: Authenticate to the root Vault namespace. Conflicts with namespace
        :param _builtins.str username: The username to login into Kerberos with.
        """
        if disable_fast_negotiation is not None:
            pulumi.set(__self__, "disable_fast_negotiation", disable_fast_negotiation)
        if keytab_path is not None:
            pulumi.set(__self__, "keytab_path", keytab_path)
        if krb5conf_path is not None:
            pulumi.set(__self__, "krb5conf_path", krb5conf_path)
        if mount is not None:
            pulumi.set(__self__, "mount", mount)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if realm is not None:
            pulumi.set(__self__, "realm", realm)
        if remove_instance_name is not None:
            pulumi.set(__self__, "remove_instance_name", remove_instance_name)
        if service is not None:
            pulumi.set(__self__, "service", service)
        if token is not None:
            pulumi.set(__self__, "token", token)
        if use_root_namespace is not None:
            pulumi.set(__self__, "use_root_namespace", use_root_namespace)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @_builtins.property
    @pulumi.getter(name="disableFastNegotiation")
    def disable_fast_negotiation(self) -> Optional[_builtins.bool]:
        """
        Disable the Kerberos FAST negotiation.
        """
        return pulumi.get(self, "disable_fast_negotiation")

    @_builtins.property
    @pulumi.getter(name="keytabPath")
    def keytab_path(self) -> Optional[_builtins.str]:
        """
        The Kerberos keytab file containing the entry of the login entity.
        """
        return pulumi.get(self, "keytab_path")

    @_builtins.property
    @pulumi.getter(name="krb5confPath")
    def krb5conf_path(self) -> Optional[_builtins.str]:
        """
        A valid Kerberos configuration file e.g. /etc/krb5.conf.
        """
        return pulumi.get(self, "krb5conf_path")

    @_builtins.property
    @pulumi.getter
    def mount(self) -> Optional[_builtins.str]:
        """
        The path where the authentication engine is mounted.
        """
        return pulumi.get(self, "mount")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[_builtins.str]:
        """
        The authentication engine's namespace. Conflicts with use_root_namespace
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter
    def realm(self) -> Optional[_builtins.str]:
        """
        The Kerberos server's authoritative authentication domain
        """
        return pulumi.get(self, "realm")

    @_builtins.property
    @pulumi.getter(name="removeInstanceName")
    def remove_instance_name(self) -> Optional[_builtins.bool]:
        """
        Strip the host from the username found in the keytab.
        """
        return pulumi.get(self, "remove_instance_name")

    @_builtins.property
    @pulumi.getter
    def service(self) -> Optional[_builtins.str]:
        """
        The service principle name.
        """
        return pulumi.get(self, "service")

    @_builtins.property
    @pulumi.getter
    def token(self) -> Optional[_builtins.str]:
        """
        Simple and Protected GSSAPI Negotiation Mechanism (SPNEGO) token
        """
        return pulumi.get(self, "token")

    @_builtins.property
    @pulumi.getter(name="useRootNamespace")
    def use_root_namespace(self) -> Optional[_builtins.bool]:
        """
        Authenticate to the root Vault namespace. Conflicts with namespace
        """
        return pulumi.get(self, "use_root_namespace")

    @_builtins.property
    @pulumi.getter
    def username(self) -> Optional[_builtins.str]:
        """
        The username to login into Kerberos with.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class AuthLoginOci(dict):
    def __init__(__self__, *,
                 auth_type: _builtins.str,
                 role: _builtins.str,
                 mount: Optional[_builtins.str] = None,
                 namespace: Optional[_builtins.str] = None,
                 use_root_namespace: Optional[_builtins.bool] = None):
        """
        :param _builtins.str auth_type: Authentication type to use when getting OCI credentials.
        :param _builtins.str role: Name of the login role.
        :param _builtins.str mount: The path where the authentication engine is mounted.
        :param _builtins.str namespace: The authentication engine's namespace. Conflicts with use_root_namespace
        :param _builtins.bool use_root_namespace: Authenticate to the root Vault namespace. Conflicts with namespace
        """
        pulumi.set(__self__, "auth_type", auth_type)
        pulumi.set(__self__, "role", role)
        if mount is not None:
            pulumi.set(__self__, "mount", mount)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if use_root_namespace is not None:
            pulumi.set(__self__, "use_root_namespace", use_root_namespace)

    @_builtins.property
    @pulumi.getter(name="authType")
    def auth_type(self) -> _builtins.str:
        """
        Authentication type to use when getting OCI credentials.
        """
        return pulumi.get(self, "auth_type")

    @_builtins.property
    @pulumi.getter
    def role(self) -> _builtins.str:
        """
        Name of the login role.
        """
        return pulumi.get(self, "role")

    @_builtins.property
    @pulumi.getter
    def mount(self) -> Optional[_builtins.str]:
        """
        The path where the authentication engine is mounted.
        """
        return pulumi.get(self, "mount")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[_builtins.str]:
        """
        The authentication engine's namespace. Conflicts with use_root_namespace
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter(name="useRootNamespace")
    def use_root_namespace(self) -> Optional[_builtins.bool]:
        """
        Authenticate to the root Vault namespace. Conflicts with namespace
        """
        return pulumi.get(self, "use_root_namespace")


@pulumi.output_type
class AuthLoginOidc(dict):
    def __init__(__self__, *,
                 role: _builtins.str,
                 callback_address: Optional[_builtins.str] = None,
                 callback_listener_address: Optional[_builtins.str] = None,
                 mount: Optional[_builtins.str] = None,
                 namespace: Optional[_builtins.str] = None,
                 use_root_namespace: Optional[_builtins.bool] = None):
        """
        :param _builtins.str role: Name of the login role.
        :param _builtins.str callback_address: The callback address. Must be a valid URI without the path.
        :param _builtins.str callback_listener_address: The callback listener's address. Must be a valid URI without the path.
        :param _builtins.str mount: The path where the authentication engine is mounted.
        :param _builtins.str namespace: The authentication engine's namespace. Conflicts with use_root_namespace
        :param _builtins.bool use_root_namespace: Authenticate to the root Vault namespace. Conflicts with namespace
        """
        pulumi.set(__self__, "role", role)
        if callback_address is not None:
            pulumi.set(__self__, "callback_address", callback_address)
        if callback_listener_address is not None:
            pulumi.set(__self__, "callback_listener_address", callback_listener_address)
        if mount is not None:
            pulumi.set(__self__, "mount", mount)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if use_root_namespace is not None:
            pulumi.set(__self__, "use_root_namespace", use_root_namespace)

    @_builtins.property
    @pulumi.getter
    def role(self) -> _builtins.str:
        """
        Name of the login role.
        """
        return pulumi.get(self, "role")

    @_builtins.property
    @pulumi.getter(name="callbackAddress")
    def callback_address(self) -> Optional[_builtins.str]:
        """
        The callback address. Must be a valid URI without the path.
        """
        return pulumi.get(self, "callback_address")

    @_builtins.property
    @pulumi.getter(name="callbackListenerAddress")
    def callback_listener_address(self) -> Optional[_builtins.str]:
        """
        The callback listener's address. Must be a valid URI without the path.
        """
        return pulumi.get(self, "callback_listener_address")

    @_builtins.property
    @pulumi.getter
    def mount(self) -> Optional[_builtins.str]:
        """
        The path where the authentication engine is mounted.
        """
        return pulumi.get(self, "mount")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[_builtins.str]:
        """
        The authentication engine's namespace. Conflicts with use_root_namespace
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter(name="useRootNamespace")
    def use_root_namespace(self) -> Optional[_builtins.bool]:
        """
        Authenticate to the root Vault namespace. Conflicts with namespace
        """
        return pulumi.get(self, "use_root_namespace")


@pulumi.output_type
class AuthLoginRadius(dict):
    def __init__(__self__, *,
                 mount: Optional[_builtins.str] = None,
                 namespace: Optional[_builtins.str] = None,
                 password: Optional[_builtins.str] = None,
                 use_root_namespace: Optional[_builtins.bool] = None,
                 username: Optional[_builtins.str] = None):
        """
        :param _builtins.str mount: The path where the authentication engine is mounted.
        :param _builtins.str namespace: The authentication engine's namespace. Conflicts with use_root_namespace
        :param _builtins.str password: The Radius password for username.
        :param _builtins.bool use_root_namespace: Authenticate to the root Vault namespace. Conflicts with namespace
        :param _builtins.str username: The Radius username.
        """
        if mount is not None:
            pulumi.set(__self__, "mount", mount)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if use_root_namespace is not None:
            pulumi.set(__self__, "use_root_namespace", use_root_namespace)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @_builtins.property
    @pulumi.getter
    def mount(self) -> Optional[_builtins.str]:
        """
        The path where the authentication engine is mounted.
        """
        return pulumi.get(self, "mount")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[_builtins.str]:
        """
        The authentication engine's namespace. Conflicts with use_root_namespace
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[_builtins.str]:
        """
        The Radius password for username.
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter(name="useRootNamespace")
    def use_root_namespace(self) -> Optional[_builtins.bool]:
        """
        Authenticate to the root Vault namespace. Conflicts with namespace
        """
        return pulumi.get(self, "use_root_namespace")

    @_builtins.property
    @pulumi.getter
    def username(self) -> Optional[_builtins.str]:
        """
        The Radius username.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class AuthLoginTokenFile(dict):
    def __init__(__self__, *,
                 filename: Optional[_builtins.str] = None,
                 namespace: Optional[_builtins.str] = None,
                 use_root_namespace: Optional[_builtins.bool] = None):
        """
        :param _builtins.str filename: The name of a file containing a single line that is a valid Vault token
        :param _builtins.str namespace: The authentication engine's namespace. Conflicts with use_root_namespace
        :param _builtins.bool use_root_namespace: Authenticate to the root Vault namespace. Conflicts with namespace
        """
        if filename is not None:
            pulumi.set(__self__, "filename", filename)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if use_root_namespace is not None:
            pulumi.set(__self__, "use_root_namespace", use_root_namespace)

    @_builtins.property
    @pulumi.getter
    def filename(self) -> Optional[_builtins.str]:
        """
        The name of a file containing a single line that is a valid Vault token
        """
        return pulumi.get(self, "filename")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[_builtins.str]:
        """
        The authentication engine's namespace. Conflicts with use_root_namespace
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter(name="useRootNamespace")
    def use_root_namespace(self) -> Optional[_builtins.bool]:
        """
        Authenticate to the root Vault namespace. Conflicts with namespace
        """
        return pulumi.get(self, "use_root_namespace")


@pulumi.output_type
class AuthLoginUserpass(dict):
    def __init__(__self__, *,
                 mount: Optional[_builtins.str] = None,
                 namespace: Optional[_builtins.str] = None,
                 password: Optional[_builtins.str] = None,
                 password_file: Optional[_builtins.str] = None,
                 use_root_namespace: Optional[_builtins.bool] = None,
                 username: Optional[_builtins.str] = None):
        """
        :param _builtins.str mount: The path where the authentication engine is mounted.
        :param _builtins.str namespace: The authentication engine's namespace. Conflicts with use_root_namespace
        :param _builtins.str password: Login with password
        :param _builtins.str password_file: Login with password from a file
        :param _builtins.bool use_root_namespace: Authenticate to the root Vault namespace. Conflicts with namespace
        :param _builtins.str username: Login with username
        """
        if mount is not None:
            pulumi.set(__self__, "mount", mount)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if password_file is not None:
            pulumi.set(__self__, "password_file", password_file)
        if use_root_namespace is not None:
            pulumi.set(__self__, "use_root_namespace", use_root_namespace)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @_builtins.property
    @pulumi.getter
    def mount(self) -> Optional[_builtins.str]:
        """
        The path where the authentication engine is mounted.
        """
        return pulumi.get(self, "mount")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[_builtins.str]:
        """
        The authentication engine's namespace. Conflicts with use_root_namespace
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[_builtins.str]:
        """
        Login with password
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter(name="passwordFile")
    def password_file(self) -> Optional[_builtins.str]:
        """
        Login with password from a file
        """
        return pulumi.get(self, "password_file")

    @_builtins.property
    @pulumi.getter(name="useRootNamespace")
    def use_root_namespace(self) -> Optional[_builtins.bool]:
        """
        Authenticate to the root Vault namespace. Conflicts with namespace
        """
        return pulumi.get(self, "use_root_namespace")

    @_builtins.property
    @pulumi.getter
    def username(self) -> Optional[_builtins.str]:
        """
        Login with username
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class ClientAuth(dict):
    def __init__(__self__, *,
                 cert_file: _builtins.str,
                 key_file: _builtins.str):
        """
        :param _builtins.str cert_file: Path to a file containing the client certificate.
        :param _builtins.str key_file: Path to a file containing the private key that the certificate was issued for.
        """
        pulumi.set(__self__, "cert_file", cert_file)
        pulumi.set(__self__, "key_file", key_file)

    @_builtins.property
    @pulumi.getter(name="certFile")
    def cert_file(self) -> _builtins.str:
        """
        Path to a file containing the client certificate.
        """
        return pulumi.get(self, "cert_file")

    @_builtins.property
    @pulumi.getter(name="keyFile")
    def key_file(self) -> _builtins.str:
        """
        Path to a file containing the private key that the certificate was issued for.
        """
        return pulumi.get(self, "key_file")


@pulumi.output_type
class Headers(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str name: The header name
        :param _builtins.str value: The header value
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The header name
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        The header value
        """
        return pulumi.get(self, "value")


