# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'SecretBackendConnectionCassandra',
    'SecretBackendConnectionCouchbase',
    'SecretBackendConnectionElasticsearch',
    'SecretBackendConnectionHana',
    'SecretBackendConnectionInfluxdb',
    'SecretBackendConnectionMongodb',
    'SecretBackendConnectionMongodbatlas',
    'SecretBackendConnectionMssql',
    'SecretBackendConnectionMysql',
    'SecretBackendConnectionMysqlAurora',
    'SecretBackendConnectionMysqlLegacy',
    'SecretBackendConnectionMysqlRds',
    'SecretBackendConnectionOracle',
    'SecretBackendConnectionPostgresql',
    'SecretBackendConnectionRedis',
    'SecretBackendConnectionRedisElasticache',
    'SecretBackendConnectionRedshift',
    'SecretBackendConnectionSnowflake',
    'SecretsMountCassandra',
    'SecretsMountCouchbase',
    'SecretsMountElasticsearch',
    'SecretsMountHana',
    'SecretsMountInfluxdb',
    'SecretsMountMongodb',
    'SecretsMountMongodbatla',
    'SecretsMountMssql',
    'SecretsMountMysql',
    'SecretsMountMysqlAurora',
    'SecretsMountMysqlLegacy',
    'SecretsMountMysqlRd',
    'SecretsMountOracle',
    'SecretsMountPostgresql',
    'SecretsMountRedi',
    'SecretsMountRedisElasticach',
    'SecretsMountRedshift',
    'SecretsMountSnowflake',
]

@pulumi.output_type
class SecretBackendConnectionCassandra(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectTimeout":
            suggest = "connect_timeout"
        elif key == "insecureTls":
            suggest = "insecure_tls"
        elif key == "pemBundle":
            suggest = "pem_bundle"
        elif key == "pemJson":
            suggest = "pem_json"
        elif key == "protocolVersion":
            suggest = "protocol_version"
        elif key == "skipVerification":
            suggest = "skip_verification"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecretBackendConnectionCassandra. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecretBackendConnectionCassandra.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecretBackendConnectionCassandra.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 connect_timeout: Optional[_builtins.int] = None,
                 hosts: Optional[Sequence[_builtins.str]] = None,
                 insecure_tls: Optional[_builtins.bool] = None,
                 password: Optional[_builtins.str] = None,
                 pem_bundle: Optional[_builtins.str] = None,
                 pem_json: Optional[_builtins.str] = None,
                 port: Optional[_builtins.int] = None,
                 protocol_version: Optional[_builtins.int] = None,
                 skip_verification: Optional[_builtins.bool] = None,
                 tls: Optional[_builtins.bool] = None,
                 username: Optional[_builtins.str] = None):
        """
        :param _builtins.int connect_timeout: The number of seconds to use as a connection timeout.
        :param Sequence[_builtins.str] hosts: Cassandra hosts to connect to.
        :param _builtins.bool insecure_tls: Whether to skip verification of the server certificate when using TLS.
        :param _builtins.str password: The password to use when authenticating with Cassandra.
        :param _builtins.str pem_bundle: Concatenated PEM blocks containing a certificate and private key; a certificate, private key, and issuing CA certificate; or just a CA certificate.
        :param _builtins.str pem_json: Specifies JSON containing a certificate and private key; a certificate, private key, and issuing CA certificate; or just a CA certificate.
        :param _builtins.int port: The transport port to use to connect to Cassandra.
        :param _builtins.int protocol_version: The CQL protocol version to use.
        :param _builtins.bool skip_verification: Skip permissions checks when a connection to Cassandra is first created. These checks ensure that Vault is able to create roles, but can be resource intensive in clusters with many roles.
        :param _builtins.bool tls: Whether to use TLS when connecting to Cassandra.
        :param _builtins.str username: The username to use when authenticating with Cassandra.
        """
        if connect_timeout is not None:
            pulumi.set(__self__, "connect_timeout", connect_timeout)
        if hosts is not None:
            pulumi.set(__self__, "hosts", hosts)
        if insecure_tls is not None:
            pulumi.set(__self__, "insecure_tls", insecure_tls)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if pem_bundle is not None:
            pulumi.set(__self__, "pem_bundle", pem_bundle)
        if pem_json is not None:
            pulumi.set(__self__, "pem_json", pem_json)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if protocol_version is not None:
            pulumi.set(__self__, "protocol_version", protocol_version)
        if skip_verification is not None:
            pulumi.set(__self__, "skip_verification", skip_verification)
        if tls is not None:
            pulumi.set(__self__, "tls", tls)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @_builtins.property
    @pulumi.getter(name="connectTimeout")
    def connect_timeout(self) -> Optional[_builtins.int]:
        """
        The number of seconds to use as a connection timeout.
        """
        return pulumi.get(self, "connect_timeout")

    @_builtins.property
    @pulumi.getter
    def hosts(self) -> Optional[Sequence[_builtins.str]]:
        """
        Cassandra hosts to connect to.
        """
        return pulumi.get(self, "hosts")

    @_builtins.property
    @pulumi.getter(name="insecureTls")
    def insecure_tls(self) -> Optional[_builtins.bool]:
        """
        Whether to skip verification of the server certificate when using TLS.
        """
        return pulumi.get(self, "insecure_tls")

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[_builtins.str]:
        """
        The password to use when authenticating with Cassandra.
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter(name="pemBundle")
    def pem_bundle(self) -> Optional[_builtins.str]:
        """
        Concatenated PEM blocks containing a certificate and private key; a certificate, private key, and issuing CA certificate; or just a CA certificate.
        """
        return pulumi.get(self, "pem_bundle")

    @_builtins.property
    @pulumi.getter(name="pemJson")
    def pem_json(self) -> Optional[_builtins.str]:
        """
        Specifies JSON containing a certificate and private key; a certificate, private key, and issuing CA certificate; or just a CA certificate.
        """
        return pulumi.get(self, "pem_json")

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[_builtins.int]:
        """
        The transport port to use to connect to Cassandra.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="protocolVersion")
    def protocol_version(self) -> Optional[_builtins.int]:
        """
        The CQL protocol version to use.
        """
        return pulumi.get(self, "protocol_version")

    @_builtins.property
    @pulumi.getter(name="skipVerification")
    def skip_verification(self) -> Optional[_builtins.bool]:
        """
        Skip permissions checks when a connection to Cassandra is first created. These checks ensure that Vault is able to create roles, but can be resource intensive in clusters with many roles.
        """
        return pulumi.get(self, "skip_verification")

    @_builtins.property
    @pulumi.getter
    def tls(self) -> Optional[_builtins.bool]:
        """
        Whether to use TLS when connecting to Cassandra.
        """
        return pulumi.get(self, "tls")

    @_builtins.property
    @pulumi.getter
    def username(self) -> Optional[_builtins.str]:
        """
        The username to use when authenticating with Cassandra.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class SecretBackendConnectionCouchbase(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "base64Pem":
            suggest = "base64_pem"
        elif key == "bucketName":
            suggest = "bucket_name"
        elif key == "insecureTls":
            suggest = "insecure_tls"
        elif key == "usernameTemplate":
            suggest = "username_template"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecretBackendConnectionCouchbase. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecretBackendConnectionCouchbase.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecretBackendConnectionCouchbase.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 hosts: Sequence[_builtins.str],
                 password: _builtins.str,
                 username: _builtins.str,
                 base64_pem: Optional[_builtins.str] = None,
                 bucket_name: Optional[_builtins.str] = None,
                 insecure_tls: Optional[_builtins.bool] = None,
                 tls: Optional[_builtins.bool] = None,
                 username_template: Optional[_builtins.str] = None):
        """
        :param Sequence[_builtins.str] hosts: A set of Couchbase URIs to connect to. Must use `couchbases://` scheme if `tls` is `true`.
        :param _builtins.str password: Specifies the password corresponding to the given username.
        :param _builtins.str username: Specifies the username for Vault to use.
        :param _builtins.str base64_pem: Required if `tls` is `true`. Specifies the certificate authority of the Couchbase server, as a PEM certificate that has been base64 encoded.
        :param _builtins.str bucket_name: Required for Couchbase versions prior to 6.5.0. This is only used to verify vault's connection to the server.
        :param _builtins.bool insecure_tls: Specifies whether to skip verification of the server certificate when using TLS.
        :param _builtins.bool tls: Specifies whether to use TLS when connecting to Couchbase.
        :param _builtins.str username_template: Template describing how dynamic usernames are generated.
        """
        pulumi.set(__self__, "hosts", hosts)
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "username", username)
        if base64_pem is not None:
            pulumi.set(__self__, "base64_pem", base64_pem)
        if bucket_name is not None:
            pulumi.set(__self__, "bucket_name", bucket_name)
        if insecure_tls is not None:
            pulumi.set(__self__, "insecure_tls", insecure_tls)
        if tls is not None:
            pulumi.set(__self__, "tls", tls)
        if username_template is not None:
            pulumi.set(__self__, "username_template", username_template)

    @_builtins.property
    @pulumi.getter
    def hosts(self) -> Sequence[_builtins.str]:
        """
        A set of Couchbase URIs to connect to. Must use `couchbases://` scheme if `tls` is `true`.
        """
        return pulumi.get(self, "hosts")

    @_builtins.property
    @pulumi.getter
    def password(self) -> _builtins.str:
        """
        Specifies the password corresponding to the given username.
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter
    def username(self) -> _builtins.str:
        """
        Specifies the username for Vault to use.
        """
        return pulumi.get(self, "username")

    @_builtins.property
    @pulumi.getter(name="base64Pem")
    def base64_pem(self) -> Optional[_builtins.str]:
        """
        Required if `tls` is `true`. Specifies the certificate authority of the Couchbase server, as a PEM certificate that has been base64 encoded.
        """
        return pulumi.get(self, "base64_pem")

    @_builtins.property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> Optional[_builtins.str]:
        """
        Required for Couchbase versions prior to 6.5.0. This is only used to verify vault's connection to the server.
        """
        return pulumi.get(self, "bucket_name")

    @_builtins.property
    @pulumi.getter(name="insecureTls")
    def insecure_tls(self) -> Optional[_builtins.bool]:
        """
        Specifies whether to skip verification of the server certificate when using TLS.
        """
        return pulumi.get(self, "insecure_tls")

    @_builtins.property
    @pulumi.getter
    def tls(self) -> Optional[_builtins.bool]:
        """
        Specifies whether to use TLS when connecting to Couchbase.
        """
        return pulumi.get(self, "tls")

    @_builtins.property
    @pulumi.getter(name="usernameTemplate")
    def username_template(self) -> Optional[_builtins.str]:
        """
        Template describing how dynamic usernames are generated.
        """
        return pulumi.get(self, "username_template")


@pulumi.output_type
class SecretBackendConnectionElasticsearch(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "caCert":
            suggest = "ca_cert"
        elif key == "caPath":
            suggest = "ca_path"
        elif key == "clientCert":
            suggest = "client_cert"
        elif key == "clientKey":
            suggest = "client_key"
        elif key == "tlsServerName":
            suggest = "tls_server_name"
        elif key == "usernameTemplate":
            suggest = "username_template"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecretBackendConnectionElasticsearch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecretBackendConnectionElasticsearch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecretBackendConnectionElasticsearch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 password: _builtins.str,
                 url: _builtins.str,
                 username: _builtins.str,
                 ca_cert: Optional[_builtins.str] = None,
                 ca_path: Optional[_builtins.str] = None,
                 client_cert: Optional[_builtins.str] = None,
                 client_key: Optional[_builtins.str] = None,
                 insecure: Optional[_builtins.bool] = None,
                 tls_server_name: Optional[_builtins.str] = None,
                 username_template: Optional[_builtins.str] = None):
        """
        :param _builtins.str password: The password to be used in the connection URL
        :param _builtins.str url: The URL for Elasticsearch's API
        :param _builtins.str username: The username to be used in the connection URL
        :param _builtins.str ca_cert: The path to a PEM-encoded CA cert file to use to verify the Elasticsearch server's identity
        :param _builtins.str ca_path: The path to a directory of PEM-encoded CA cert files to use to verify the Elasticsearch server's identity
        :param _builtins.str client_cert: The path to the certificate for the Elasticsearch client to present for communication
        :param _builtins.str client_key: The path to the key for the Elasticsearch client to use for communication
        :param _builtins.bool insecure: Whether to disable certificate verification
        :param _builtins.str tls_server_name: This, if set, is used to set the SNI host when connecting via TLS
        :param _builtins.str username_template: Template describing how dynamic usernames are generated.
        """
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "url", url)
        pulumi.set(__self__, "username", username)
        if ca_cert is not None:
            pulumi.set(__self__, "ca_cert", ca_cert)
        if ca_path is not None:
            pulumi.set(__self__, "ca_path", ca_path)
        if client_cert is not None:
            pulumi.set(__self__, "client_cert", client_cert)
        if client_key is not None:
            pulumi.set(__self__, "client_key", client_key)
        if insecure is not None:
            pulumi.set(__self__, "insecure", insecure)
        if tls_server_name is not None:
            pulumi.set(__self__, "tls_server_name", tls_server_name)
        if username_template is not None:
            pulumi.set(__self__, "username_template", username_template)

    @_builtins.property
    @pulumi.getter
    def password(self) -> _builtins.str:
        """
        The password to be used in the connection URL
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter
    def url(self) -> _builtins.str:
        """
        The URL for Elasticsearch's API
        """
        return pulumi.get(self, "url")

    @_builtins.property
    @pulumi.getter
    def username(self) -> _builtins.str:
        """
        The username to be used in the connection URL
        """
        return pulumi.get(self, "username")

    @_builtins.property
    @pulumi.getter(name="caCert")
    def ca_cert(self) -> Optional[_builtins.str]:
        """
        The path to a PEM-encoded CA cert file to use to verify the Elasticsearch server's identity
        """
        return pulumi.get(self, "ca_cert")

    @_builtins.property
    @pulumi.getter(name="caPath")
    def ca_path(self) -> Optional[_builtins.str]:
        """
        The path to a directory of PEM-encoded CA cert files to use to verify the Elasticsearch server's identity
        """
        return pulumi.get(self, "ca_path")

    @_builtins.property
    @pulumi.getter(name="clientCert")
    def client_cert(self) -> Optional[_builtins.str]:
        """
        The path to the certificate for the Elasticsearch client to present for communication
        """
        return pulumi.get(self, "client_cert")

    @_builtins.property
    @pulumi.getter(name="clientKey")
    def client_key(self) -> Optional[_builtins.str]:
        """
        The path to the key for the Elasticsearch client to use for communication
        """
        return pulumi.get(self, "client_key")

    @_builtins.property
    @pulumi.getter
    def insecure(self) -> Optional[_builtins.bool]:
        """
        Whether to disable certificate verification
        """
        return pulumi.get(self, "insecure")

    @_builtins.property
    @pulumi.getter(name="tlsServerName")
    def tls_server_name(self) -> Optional[_builtins.str]:
        """
        This, if set, is used to set the SNI host when connecting via TLS
        """
        return pulumi.get(self, "tls_server_name")

    @_builtins.property
    @pulumi.getter(name="usernameTemplate")
    def username_template(self) -> Optional[_builtins.str]:
        """
        Template describing how dynamic usernames are generated.
        """
        return pulumi.get(self, "username_template")


@pulumi.output_type
class SecretBackendConnectionHana(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectionUrl":
            suggest = "connection_url"
        elif key == "disableEscaping":
            suggest = "disable_escaping"
        elif key == "maxConnectionLifetime":
            suggest = "max_connection_lifetime"
        elif key == "maxIdleConnections":
            suggest = "max_idle_connections"
        elif key == "maxOpenConnections":
            suggest = "max_open_connections"
        elif key == "passwordWo":
            suggest = "password_wo"
        elif key == "passwordWoVersion":
            suggest = "password_wo_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecretBackendConnectionHana. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecretBackendConnectionHana.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecretBackendConnectionHana.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 connection_url: Optional[_builtins.str] = None,
                 disable_escaping: Optional[_builtins.bool] = None,
                 max_connection_lifetime: Optional[_builtins.int] = None,
                 max_idle_connections: Optional[_builtins.int] = None,
                 max_open_connections: Optional[_builtins.int] = None,
                 password: Optional[_builtins.str] = None,
                 password_wo: Optional[_builtins.str] = None,
                 password_wo_version: Optional[_builtins.int] = None,
                 username: Optional[_builtins.str] = None):
        """
        :param _builtins.str connection_url: Connection string to use to connect to the database.
        :param _builtins.bool disable_escaping: Disable special character escaping in username and password
        :param _builtins.int max_connection_lifetime: Maximum number of seconds a connection may be reused.
        :param _builtins.int max_idle_connections: Maximum number of idle connections to the database.
        :param _builtins.int max_open_connections: Maximum number of open connections to the database.
        :param _builtins.str password: The root credential password used in the connection URL
        :param _builtins.str password_wo: **NOTE:** This field is write-only and its value will not be updated in state as part of read operations.
               Write-only field for the root credential password used in the connection URL
        :param _builtins.int password_wo_version: Version counter for root credential password write-only field
        :param _builtins.str username: The root credential username used in the connection URL
        """
        if connection_url is not None:
            pulumi.set(__self__, "connection_url", connection_url)
        if disable_escaping is not None:
            pulumi.set(__self__, "disable_escaping", disable_escaping)
        if max_connection_lifetime is not None:
            pulumi.set(__self__, "max_connection_lifetime", max_connection_lifetime)
        if max_idle_connections is not None:
            pulumi.set(__self__, "max_idle_connections", max_idle_connections)
        if max_open_connections is not None:
            pulumi.set(__self__, "max_open_connections", max_open_connections)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if password_wo is not None:
            pulumi.set(__self__, "password_wo", password_wo)
        if password_wo_version is not None:
            pulumi.set(__self__, "password_wo_version", password_wo_version)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @_builtins.property
    @pulumi.getter(name="connectionUrl")
    def connection_url(self) -> Optional[_builtins.str]:
        """
        Connection string to use to connect to the database.
        """
        return pulumi.get(self, "connection_url")

    @_builtins.property
    @pulumi.getter(name="disableEscaping")
    def disable_escaping(self) -> Optional[_builtins.bool]:
        """
        Disable special character escaping in username and password
        """
        return pulumi.get(self, "disable_escaping")

    @_builtins.property
    @pulumi.getter(name="maxConnectionLifetime")
    def max_connection_lifetime(self) -> Optional[_builtins.int]:
        """
        Maximum number of seconds a connection may be reused.
        """
        return pulumi.get(self, "max_connection_lifetime")

    @_builtins.property
    @pulumi.getter(name="maxIdleConnections")
    def max_idle_connections(self) -> Optional[_builtins.int]:
        """
        Maximum number of idle connections to the database.
        """
        return pulumi.get(self, "max_idle_connections")

    @_builtins.property
    @pulumi.getter(name="maxOpenConnections")
    def max_open_connections(self) -> Optional[_builtins.int]:
        """
        Maximum number of open connections to the database.
        """
        return pulumi.get(self, "max_open_connections")

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[_builtins.str]:
        """
        The root credential password used in the connection URL
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter(name="passwordWo")
    def password_wo(self) -> Optional[_builtins.str]:
        """
        **NOTE:** This field is write-only and its value will not be updated in state as part of read operations.
        Write-only field for the root credential password used in the connection URL
        """
        return pulumi.get(self, "password_wo")

    @_builtins.property
    @pulumi.getter(name="passwordWoVersion")
    def password_wo_version(self) -> Optional[_builtins.int]:
        """
        Version counter for root credential password write-only field
        """
        return pulumi.get(self, "password_wo_version")

    @_builtins.property
    @pulumi.getter
    def username(self) -> Optional[_builtins.str]:
        """
        The root credential username used in the connection URL
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class SecretBackendConnectionInfluxdb(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectTimeout":
            suggest = "connect_timeout"
        elif key == "insecureTls":
            suggest = "insecure_tls"
        elif key == "pemBundle":
            suggest = "pem_bundle"
        elif key == "pemJson":
            suggest = "pem_json"
        elif key == "usernameTemplate":
            suggest = "username_template"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecretBackendConnectionInfluxdb. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecretBackendConnectionInfluxdb.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecretBackendConnectionInfluxdb.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 host: _builtins.str,
                 password: _builtins.str,
                 username: _builtins.str,
                 connect_timeout: Optional[_builtins.int] = None,
                 insecure_tls: Optional[_builtins.bool] = None,
                 pem_bundle: Optional[_builtins.str] = None,
                 pem_json: Optional[_builtins.str] = None,
                 port: Optional[_builtins.int] = None,
                 tls: Optional[_builtins.bool] = None,
                 username_template: Optional[_builtins.str] = None):
        """
        :param _builtins.str host: Influxdb host to connect to.
        :param _builtins.str password: Specifies the password corresponding to the given username.
        :param _builtins.str username: Specifies the username to use for superuser access.
        :param _builtins.int connect_timeout: The number of seconds to use as a connection timeout.
        :param _builtins.bool insecure_tls: Whether to skip verification of the server certificate when using TLS.
        :param _builtins.str pem_bundle: Concatenated PEM blocks containing a certificate and private key; a certificate, private key, and issuing CA certificate; or just a CA certificate.
        :param _builtins.str pem_json: Specifies JSON containing a certificate and private key; a certificate, private key, and issuing CA certificate; or just a CA certificate.
        :param _builtins.int port: The transport port to use to connect to Influxdb.
        :param _builtins.bool tls: Whether to use TLS when connecting to Influxdb.
        :param _builtins.str username_template: Template describing how dynamic usernames are generated.
        """
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "username", username)
        if connect_timeout is not None:
            pulumi.set(__self__, "connect_timeout", connect_timeout)
        if insecure_tls is not None:
            pulumi.set(__self__, "insecure_tls", insecure_tls)
        if pem_bundle is not None:
            pulumi.set(__self__, "pem_bundle", pem_bundle)
        if pem_json is not None:
            pulumi.set(__self__, "pem_json", pem_json)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if tls is not None:
            pulumi.set(__self__, "tls", tls)
        if username_template is not None:
            pulumi.set(__self__, "username_template", username_template)

    @_builtins.property
    @pulumi.getter
    def host(self) -> _builtins.str:
        """
        Influxdb host to connect to.
        """
        return pulumi.get(self, "host")

    @_builtins.property
    @pulumi.getter
    def password(self) -> _builtins.str:
        """
        Specifies the password corresponding to the given username.
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter
    def username(self) -> _builtins.str:
        """
        Specifies the username to use for superuser access.
        """
        return pulumi.get(self, "username")

    @_builtins.property
    @pulumi.getter(name="connectTimeout")
    def connect_timeout(self) -> Optional[_builtins.int]:
        """
        The number of seconds to use as a connection timeout.
        """
        return pulumi.get(self, "connect_timeout")

    @_builtins.property
    @pulumi.getter(name="insecureTls")
    def insecure_tls(self) -> Optional[_builtins.bool]:
        """
        Whether to skip verification of the server certificate when using TLS.
        """
        return pulumi.get(self, "insecure_tls")

    @_builtins.property
    @pulumi.getter(name="pemBundle")
    def pem_bundle(self) -> Optional[_builtins.str]:
        """
        Concatenated PEM blocks containing a certificate and private key; a certificate, private key, and issuing CA certificate; or just a CA certificate.
        """
        return pulumi.get(self, "pem_bundle")

    @_builtins.property
    @pulumi.getter(name="pemJson")
    def pem_json(self) -> Optional[_builtins.str]:
        """
        Specifies JSON containing a certificate and private key; a certificate, private key, and issuing CA certificate; or just a CA certificate.
        """
        return pulumi.get(self, "pem_json")

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[_builtins.int]:
        """
        The transport port to use to connect to Influxdb.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter
    def tls(self) -> Optional[_builtins.bool]:
        """
        Whether to use TLS when connecting to Influxdb.
        """
        return pulumi.get(self, "tls")

    @_builtins.property
    @pulumi.getter(name="usernameTemplate")
    def username_template(self) -> Optional[_builtins.str]:
        """
        Template describing how dynamic usernames are generated.
        """
        return pulumi.get(self, "username_template")


@pulumi.output_type
class SecretBackendConnectionMongodb(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectionUrl":
            suggest = "connection_url"
        elif key == "maxConnectionLifetime":
            suggest = "max_connection_lifetime"
        elif key == "maxIdleConnections":
            suggest = "max_idle_connections"
        elif key == "maxOpenConnections":
            suggest = "max_open_connections"
        elif key == "passwordWo":
            suggest = "password_wo"
        elif key == "passwordWoVersion":
            suggest = "password_wo_version"
        elif key == "usernameTemplate":
            suggest = "username_template"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecretBackendConnectionMongodb. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecretBackendConnectionMongodb.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecretBackendConnectionMongodb.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 connection_url: Optional[_builtins.str] = None,
                 max_connection_lifetime: Optional[_builtins.int] = None,
                 max_idle_connections: Optional[_builtins.int] = None,
                 max_open_connections: Optional[_builtins.int] = None,
                 password: Optional[_builtins.str] = None,
                 password_wo: Optional[_builtins.str] = None,
                 password_wo_version: Optional[_builtins.int] = None,
                 username: Optional[_builtins.str] = None,
                 username_template: Optional[_builtins.str] = None):
        """
        :param _builtins.str connection_url: Connection string to use to connect to the database.
        :param _builtins.int max_connection_lifetime: Maximum number of seconds a connection may be reused.
        :param _builtins.int max_idle_connections: Maximum number of idle connections to the database.
        :param _builtins.int max_open_connections: Maximum number of open connections to the database.
        :param _builtins.str password: The root credential password used in the connection URL
        :param _builtins.str password_wo: **NOTE:** This field is write-only and its value will not be updated in state as part of read operations.
               Write-only field for the root credential password used in the connection URL
        :param _builtins.int password_wo_version: Version counter for root credential password write-only field
        :param _builtins.str username: The root credential username used in the connection URL
        :param _builtins.str username_template: Username generation template.
        """
        if connection_url is not None:
            pulumi.set(__self__, "connection_url", connection_url)
        if max_connection_lifetime is not None:
            pulumi.set(__self__, "max_connection_lifetime", max_connection_lifetime)
        if max_idle_connections is not None:
            pulumi.set(__self__, "max_idle_connections", max_idle_connections)
        if max_open_connections is not None:
            pulumi.set(__self__, "max_open_connections", max_open_connections)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if password_wo is not None:
            pulumi.set(__self__, "password_wo", password_wo)
        if password_wo_version is not None:
            pulumi.set(__self__, "password_wo_version", password_wo_version)
        if username is not None:
            pulumi.set(__self__, "username", username)
        if username_template is not None:
            pulumi.set(__self__, "username_template", username_template)

    @_builtins.property
    @pulumi.getter(name="connectionUrl")
    def connection_url(self) -> Optional[_builtins.str]:
        """
        Connection string to use to connect to the database.
        """
        return pulumi.get(self, "connection_url")

    @_builtins.property
    @pulumi.getter(name="maxConnectionLifetime")
    def max_connection_lifetime(self) -> Optional[_builtins.int]:
        """
        Maximum number of seconds a connection may be reused.
        """
        return pulumi.get(self, "max_connection_lifetime")

    @_builtins.property
    @pulumi.getter(name="maxIdleConnections")
    def max_idle_connections(self) -> Optional[_builtins.int]:
        """
        Maximum number of idle connections to the database.
        """
        return pulumi.get(self, "max_idle_connections")

    @_builtins.property
    @pulumi.getter(name="maxOpenConnections")
    def max_open_connections(self) -> Optional[_builtins.int]:
        """
        Maximum number of open connections to the database.
        """
        return pulumi.get(self, "max_open_connections")

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[_builtins.str]:
        """
        The root credential password used in the connection URL
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter(name="passwordWo")
    def password_wo(self) -> Optional[_builtins.str]:
        """
        **NOTE:** This field is write-only and its value will not be updated in state as part of read operations.
        Write-only field for the root credential password used in the connection URL
        """
        return pulumi.get(self, "password_wo")

    @_builtins.property
    @pulumi.getter(name="passwordWoVersion")
    def password_wo_version(self) -> Optional[_builtins.int]:
        """
        Version counter for root credential password write-only field
        """
        return pulumi.get(self, "password_wo_version")

    @_builtins.property
    @pulumi.getter
    def username(self) -> Optional[_builtins.str]:
        """
        The root credential username used in the connection URL
        """
        return pulumi.get(self, "username")

    @_builtins.property
    @pulumi.getter(name="usernameTemplate")
    def username_template(self) -> Optional[_builtins.str]:
        """
        Username generation template.
        """
        return pulumi.get(self, "username_template")


@pulumi.output_type
class SecretBackendConnectionMongodbatlas(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "privateKey":
            suggest = "private_key"
        elif key == "projectId":
            suggest = "project_id"
        elif key == "publicKey":
            suggest = "public_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecretBackendConnectionMongodbatlas. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecretBackendConnectionMongodbatlas.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecretBackendConnectionMongodbatlas.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 private_key: _builtins.str,
                 project_id: _builtins.str,
                 public_key: _builtins.str):
        """
        :param _builtins.str private_key: The Private Programmatic API Key used to connect with MongoDB Atlas API.
        :param _builtins.str project_id: The Project ID the Database User should be created within.
        :param _builtins.str public_key: The Public Programmatic API Key used to authenticate with the MongoDB Atlas API.
        """
        pulumi.set(__self__, "private_key", private_key)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "public_key", public_key)

    @_builtins.property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> _builtins.str:
        """
        The Private Programmatic API Key used to connect with MongoDB Atlas API.
        """
        return pulumi.get(self, "private_key")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> _builtins.str:
        """
        The Project ID the Database User should be created within.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> _builtins.str:
        """
        The Public Programmatic API Key used to authenticate with the MongoDB Atlas API.
        """
        return pulumi.get(self, "public_key")


@pulumi.output_type
class SecretBackendConnectionMssql(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectionUrl":
            suggest = "connection_url"
        elif key == "containedDb":
            suggest = "contained_db"
        elif key == "disableEscaping":
            suggest = "disable_escaping"
        elif key == "maxConnectionLifetime":
            suggest = "max_connection_lifetime"
        elif key == "maxIdleConnections":
            suggest = "max_idle_connections"
        elif key == "maxOpenConnections":
            suggest = "max_open_connections"
        elif key == "passwordWo":
            suggest = "password_wo"
        elif key == "passwordWoVersion":
            suggest = "password_wo_version"
        elif key == "usernameTemplate":
            suggest = "username_template"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecretBackendConnectionMssql. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecretBackendConnectionMssql.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecretBackendConnectionMssql.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 connection_url: Optional[_builtins.str] = None,
                 contained_db: Optional[_builtins.bool] = None,
                 disable_escaping: Optional[_builtins.bool] = None,
                 max_connection_lifetime: Optional[_builtins.int] = None,
                 max_idle_connections: Optional[_builtins.int] = None,
                 max_open_connections: Optional[_builtins.int] = None,
                 password: Optional[_builtins.str] = None,
                 password_wo: Optional[_builtins.str] = None,
                 password_wo_version: Optional[_builtins.int] = None,
                 username: Optional[_builtins.str] = None,
                 username_template: Optional[_builtins.str] = None):
        """
        :param _builtins.str connection_url: Connection string to use to connect to the database.
        :param _builtins.bool contained_db: Set to true when the target is a Contained Database, e.g. AzureSQL.
        :param _builtins.bool disable_escaping: Disable special character escaping in username and password
        :param _builtins.int max_connection_lifetime: Maximum number of seconds a connection may be reused.
        :param _builtins.int max_idle_connections: Maximum number of idle connections to the database.
        :param _builtins.int max_open_connections: Maximum number of open connections to the database.
        :param _builtins.str password: The root credential password used in the connection URL
        :param _builtins.str password_wo: **NOTE:** This field is write-only and its value will not be updated in state as part of read operations.
               Write-only field for the root credential password used in the connection URL
        :param _builtins.int password_wo_version: Version counter for root credential password write-only field
        :param _builtins.str username: The root credential username used in the connection URL
        :param _builtins.str username_template: Username generation template.
        """
        if connection_url is not None:
            pulumi.set(__self__, "connection_url", connection_url)
        if contained_db is not None:
            pulumi.set(__self__, "contained_db", contained_db)
        if disable_escaping is not None:
            pulumi.set(__self__, "disable_escaping", disable_escaping)
        if max_connection_lifetime is not None:
            pulumi.set(__self__, "max_connection_lifetime", max_connection_lifetime)
        if max_idle_connections is not None:
            pulumi.set(__self__, "max_idle_connections", max_idle_connections)
        if max_open_connections is not None:
            pulumi.set(__self__, "max_open_connections", max_open_connections)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if password_wo is not None:
            pulumi.set(__self__, "password_wo", password_wo)
        if password_wo_version is not None:
            pulumi.set(__self__, "password_wo_version", password_wo_version)
        if username is not None:
            pulumi.set(__self__, "username", username)
        if username_template is not None:
            pulumi.set(__self__, "username_template", username_template)

    @_builtins.property
    @pulumi.getter(name="connectionUrl")
    def connection_url(self) -> Optional[_builtins.str]:
        """
        Connection string to use to connect to the database.
        """
        return pulumi.get(self, "connection_url")

    @_builtins.property
    @pulumi.getter(name="containedDb")
    def contained_db(self) -> Optional[_builtins.bool]:
        """
        Set to true when the target is a Contained Database, e.g. AzureSQL.
        """
        return pulumi.get(self, "contained_db")

    @_builtins.property
    @pulumi.getter(name="disableEscaping")
    def disable_escaping(self) -> Optional[_builtins.bool]:
        """
        Disable special character escaping in username and password
        """
        return pulumi.get(self, "disable_escaping")

    @_builtins.property
    @pulumi.getter(name="maxConnectionLifetime")
    def max_connection_lifetime(self) -> Optional[_builtins.int]:
        """
        Maximum number of seconds a connection may be reused.
        """
        return pulumi.get(self, "max_connection_lifetime")

    @_builtins.property
    @pulumi.getter(name="maxIdleConnections")
    def max_idle_connections(self) -> Optional[_builtins.int]:
        """
        Maximum number of idle connections to the database.
        """
        return pulumi.get(self, "max_idle_connections")

    @_builtins.property
    @pulumi.getter(name="maxOpenConnections")
    def max_open_connections(self) -> Optional[_builtins.int]:
        """
        Maximum number of open connections to the database.
        """
        return pulumi.get(self, "max_open_connections")

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[_builtins.str]:
        """
        The root credential password used in the connection URL
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter(name="passwordWo")
    def password_wo(self) -> Optional[_builtins.str]:
        """
        **NOTE:** This field is write-only and its value will not be updated in state as part of read operations.
        Write-only field for the root credential password used in the connection URL
        """
        return pulumi.get(self, "password_wo")

    @_builtins.property
    @pulumi.getter(name="passwordWoVersion")
    def password_wo_version(self) -> Optional[_builtins.int]:
        """
        Version counter for root credential password write-only field
        """
        return pulumi.get(self, "password_wo_version")

    @_builtins.property
    @pulumi.getter
    def username(self) -> Optional[_builtins.str]:
        """
        The root credential username used in the connection URL
        """
        return pulumi.get(self, "username")

    @_builtins.property
    @pulumi.getter(name="usernameTemplate")
    def username_template(self) -> Optional[_builtins.str]:
        """
        Username generation template.
        """
        return pulumi.get(self, "username_template")


@pulumi.output_type
class SecretBackendConnectionMysql(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authType":
            suggest = "auth_type"
        elif key == "connectionUrl":
            suggest = "connection_url"
        elif key == "maxConnectionLifetime":
            suggest = "max_connection_lifetime"
        elif key == "maxIdleConnections":
            suggest = "max_idle_connections"
        elif key == "maxOpenConnections":
            suggest = "max_open_connections"
        elif key == "passwordWo":
            suggest = "password_wo"
        elif key == "passwordWoVersion":
            suggest = "password_wo_version"
        elif key == "serviceAccountJson":
            suggest = "service_account_json"
        elif key == "tlsCa":
            suggest = "tls_ca"
        elif key == "tlsCertificateKey":
            suggest = "tls_certificate_key"
        elif key == "usernameTemplate":
            suggest = "username_template"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecretBackendConnectionMysql. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecretBackendConnectionMysql.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecretBackendConnectionMysql.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 auth_type: Optional[_builtins.str] = None,
                 connection_url: Optional[_builtins.str] = None,
                 max_connection_lifetime: Optional[_builtins.int] = None,
                 max_idle_connections: Optional[_builtins.int] = None,
                 max_open_connections: Optional[_builtins.int] = None,
                 password: Optional[_builtins.str] = None,
                 password_wo: Optional[_builtins.str] = None,
                 password_wo_version: Optional[_builtins.int] = None,
                 service_account_json: Optional[_builtins.str] = None,
                 tls_ca: Optional[_builtins.str] = None,
                 tls_certificate_key: Optional[_builtins.str] = None,
                 username: Optional[_builtins.str] = None,
                 username_template: Optional[_builtins.str] = None):
        """
        :param _builtins.str auth_type: Specify alternative authorization type. (Only 'gcp_iam' is valid currently)
        :param _builtins.str connection_url: Connection string to use to connect to the database.
        :param _builtins.int max_connection_lifetime: Maximum number of seconds a connection may be reused.
        :param _builtins.int max_idle_connections: Maximum number of idle connections to the database.
        :param _builtins.int max_open_connections: Maximum number of open connections to the database.
        :param _builtins.str password: The root credential password used in the connection URL
        :param _builtins.str password_wo: **NOTE:** This field is write-only and its value will not be updated in state as part of read operations.
               Write-only field for the root credential password used in the connection URL
        :param _builtins.int password_wo_version: Version counter for root credential password write-only field
        :param _builtins.str service_account_json: A JSON encoded credential for use with IAM authorization
        :param _builtins.str tls_ca: x509 CA file for validating the certificate presented by the MySQL server. Must be PEM encoded.
        :param _builtins.str tls_certificate_key: x509 certificate for connecting to the database. This must be a PEM encoded version of the private key and the certificate combined.
        :param _builtins.str username: The root credential username used in the connection URL
        :param _builtins.str username_template: Username generation template.
        """
        if auth_type is not None:
            pulumi.set(__self__, "auth_type", auth_type)
        if connection_url is not None:
            pulumi.set(__self__, "connection_url", connection_url)
        if max_connection_lifetime is not None:
            pulumi.set(__self__, "max_connection_lifetime", max_connection_lifetime)
        if max_idle_connections is not None:
            pulumi.set(__self__, "max_idle_connections", max_idle_connections)
        if max_open_connections is not None:
            pulumi.set(__self__, "max_open_connections", max_open_connections)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if password_wo is not None:
            pulumi.set(__self__, "password_wo", password_wo)
        if password_wo_version is not None:
            pulumi.set(__self__, "password_wo_version", password_wo_version)
        if service_account_json is not None:
            pulumi.set(__self__, "service_account_json", service_account_json)
        if tls_ca is not None:
            pulumi.set(__self__, "tls_ca", tls_ca)
        if tls_certificate_key is not None:
            pulumi.set(__self__, "tls_certificate_key", tls_certificate_key)
        if username is not None:
            pulumi.set(__self__, "username", username)
        if username_template is not None:
            pulumi.set(__self__, "username_template", username_template)

    @_builtins.property
    @pulumi.getter(name="authType")
    def auth_type(self) -> Optional[_builtins.str]:
        """
        Specify alternative authorization type. (Only 'gcp_iam' is valid currently)
        """
        return pulumi.get(self, "auth_type")

    @_builtins.property
    @pulumi.getter(name="connectionUrl")
    def connection_url(self) -> Optional[_builtins.str]:
        """
        Connection string to use to connect to the database.
        """
        return pulumi.get(self, "connection_url")

    @_builtins.property
    @pulumi.getter(name="maxConnectionLifetime")
    def max_connection_lifetime(self) -> Optional[_builtins.int]:
        """
        Maximum number of seconds a connection may be reused.
        """
        return pulumi.get(self, "max_connection_lifetime")

    @_builtins.property
    @pulumi.getter(name="maxIdleConnections")
    def max_idle_connections(self) -> Optional[_builtins.int]:
        """
        Maximum number of idle connections to the database.
        """
        return pulumi.get(self, "max_idle_connections")

    @_builtins.property
    @pulumi.getter(name="maxOpenConnections")
    def max_open_connections(self) -> Optional[_builtins.int]:
        """
        Maximum number of open connections to the database.
        """
        return pulumi.get(self, "max_open_connections")

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[_builtins.str]:
        """
        The root credential password used in the connection URL
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter(name="passwordWo")
    def password_wo(self) -> Optional[_builtins.str]:
        """
        **NOTE:** This field is write-only and its value will not be updated in state as part of read operations.
        Write-only field for the root credential password used in the connection URL
        """
        return pulumi.get(self, "password_wo")

    @_builtins.property
    @pulumi.getter(name="passwordWoVersion")
    def password_wo_version(self) -> Optional[_builtins.int]:
        """
        Version counter for root credential password write-only field
        """
        return pulumi.get(self, "password_wo_version")

    @_builtins.property
    @pulumi.getter(name="serviceAccountJson")
    def service_account_json(self) -> Optional[_builtins.str]:
        """
        A JSON encoded credential for use with IAM authorization
        """
        return pulumi.get(self, "service_account_json")

    @_builtins.property
    @pulumi.getter(name="tlsCa")
    def tls_ca(self) -> Optional[_builtins.str]:
        """
        x509 CA file for validating the certificate presented by the MySQL server. Must be PEM encoded.
        """
        return pulumi.get(self, "tls_ca")

    @_builtins.property
    @pulumi.getter(name="tlsCertificateKey")
    def tls_certificate_key(self) -> Optional[_builtins.str]:
        """
        x509 certificate for connecting to the database. This must be a PEM encoded version of the private key and the certificate combined.
        """
        return pulumi.get(self, "tls_certificate_key")

    @_builtins.property
    @pulumi.getter
    def username(self) -> Optional[_builtins.str]:
        """
        The root credential username used in the connection URL
        """
        return pulumi.get(self, "username")

    @_builtins.property
    @pulumi.getter(name="usernameTemplate")
    def username_template(self) -> Optional[_builtins.str]:
        """
        Username generation template.
        """
        return pulumi.get(self, "username_template")


@pulumi.output_type
class SecretBackendConnectionMysqlAurora(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authType":
            suggest = "auth_type"
        elif key == "connectionUrl":
            suggest = "connection_url"
        elif key == "maxConnectionLifetime":
            suggest = "max_connection_lifetime"
        elif key == "maxIdleConnections":
            suggest = "max_idle_connections"
        elif key == "maxOpenConnections":
            suggest = "max_open_connections"
        elif key == "passwordWo":
            suggest = "password_wo"
        elif key == "passwordWoVersion":
            suggest = "password_wo_version"
        elif key == "serviceAccountJson":
            suggest = "service_account_json"
        elif key == "tlsCa":
            suggest = "tls_ca"
        elif key == "tlsCertificateKey":
            suggest = "tls_certificate_key"
        elif key == "usernameTemplate":
            suggest = "username_template"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecretBackendConnectionMysqlAurora. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecretBackendConnectionMysqlAurora.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecretBackendConnectionMysqlAurora.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 auth_type: Optional[_builtins.str] = None,
                 connection_url: Optional[_builtins.str] = None,
                 max_connection_lifetime: Optional[_builtins.int] = None,
                 max_idle_connections: Optional[_builtins.int] = None,
                 max_open_connections: Optional[_builtins.int] = None,
                 password: Optional[_builtins.str] = None,
                 password_wo: Optional[_builtins.str] = None,
                 password_wo_version: Optional[_builtins.int] = None,
                 service_account_json: Optional[_builtins.str] = None,
                 tls_ca: Optional[_builtins.str] = None,
                 tls_certificate_key: Optional[_builtins.str] = None,
                 username: Optional[_builtins.str] = None,
                 username_template: Optional[_builtins.str] = None):
        """
        :param _builtins.str auth_type: Specify alternative authorization type. (Only 'gcp_iam' is valid currently)
        :param _builtins.str connection_url: Connection string to use to connect to the database.
        :param _builtins.int max_connection_lifetime: Maximum number of seconds a connection may be reused.
        :param _builtins.int max_idle_connections: Maximum number of idle connections to the database.
        :param _builtins.int max_open_connections: Maximum number of open connections to the database.
        :param _builtins.str password: The root credential password used in the connection URL
        :param _builtins.str password_wo: **NOTE:** This field is write-only and its value will not be updated in state as part of read operations.
               Write-only field for the root credential password used in the connection URL
        :param _builtins.int password_wo_version: Version counter for root credential password write-only field
        :param _builtins.str service_account_json: A JSON encoded credential for use with IAM authorization
        :param _builtins.str tls_ca: x509 CA file for validating the certificate presented by the MySQL server. Must be PEM encoded.
        :param _builtins.str tls_certificate_key: x509 certificate for connecting to the database. This must be a PEM encoded version of the private key and the certificate combined.
        :param _builtins.str username: The root credential username used in the connection URL
        :param _builtins.str username_template: Username generation template.
        """
        if auth_type is not None:
            pulumi.set(__self__, "auth_type", auth_type)
        if connection_url is not None:
            pulumi.set(__self__, "connection_url", connection_url)
        if max_connection_lifetime is not None:
            pulumi.set(__self__, "max_connection_lifetime", max_connection_lifetime)
        if max_idle_connections is not None:
            pulumi.set(__self__, "max_idle_connections", max_idle_connections)
        if max_open_connections is not None:
            pulumi.set(__self__, "max_open_connections", max_open_connections)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if password_wo is not None:
            pulumi.set(__self__, "password_wo", password_wo)
        if password_wo_version is not None:
            pulumi.set(__self__, "password_wo_version", password_wo_version)
        if service_account_json is not None:
            pulumi.set(__self__, "service_account_json", service_account_json)
        if tls_ca is not None:
            pulumi.set(__self__, "tls_ca", tls_ca)
        if tls_certificate_key is not None:
            pulumi.set(__self__, "tls_certificate_key", tls_certificate_key)
        if username is not None:
            pulumi.set(__self__, "username", username)
        if username_template is not None:
            pulumi.set(__self__, "username_template", username_template)

    @_builtins.property
    @pulumi.getter(name="authType")
    def auth_type(self) -> Optional[_builtins.str]:
        """
        Specify alternative authorization type. (Only 'gcp_iam' is valid currently)
        """
        return pulumi.get(self, "auth_type")

    @_builtins.property
    @pulumi.getter(name="connectionUrl")
    def connection_url(self) -> Optional[_builtins.str]:
        """
        Connection string to use to connect to the database.
        """
        return pulumi.get(self, "connection_url")

    @_builtins.property
    @pulumi.getter(name="maxConnectionLifetime")
    def max_connection_lifetime(self) -> Optional[_builtins.int]:
        """
        Maximum number of seconds a connection may be reused.
        """
        return pulumi.get(self, "max_connection_lifetime")

    @_builtins.property
    @pulumi.getter(name="maxIdleConnections")
    def max_idle_connections(self) -> Optional[_builtins.int]:
        """
        Maximum number of idle connections to the database.
        """
        return pulumi.get(self, "max_idle_connections")

    @_builtins.property
    @pulumi.getter(name="maxOpenConnections")
    def max_open_connections(self) -> Optional[_builtins.int]:
        """
        Maximum number of open connections to the database.
        """
        return pulumi.get(self, "max_open_connections")

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[_builtins.str]:
        """
        The root credential password used in the connection URL
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter(name="passwordWo")
    def password_wo(self) -> Optional[_builtins.str]:
        """
        **NOTE:** This field is write-only and its value will not be updated in state as part of read operations.
        Write-only field for the root credential password used in the connection URL
        """
        return pulumi.get(self, "password_wo")

    @_builtins.property
    @pulumi.getter(name="passwordWoVersion")
    def password_wo_version(self) -> Optional[_builtins.int]:
        """
        Version counter for root credential password write-only field
        """
        return pulumi.get(self, "password_wo_version")

    @_builtins.property
    @pulumi.getter(name="serviceAccountJson")
    def service_account_json(self) -> Optional[_builtins.str]:
        """
        A JSON encoded credential for use with IAM authorization
        """
        return pulumi.get(self, "service_account_json")

    @_builtins.property
    @pulumi.getter(name="tlsCa")
    def tls_ca(self) -> Optional[_builtins.str]:
        """
        x509 CA file for validating the certificate presented by the MySQL server. Must be PEM encoded.
        """
        return pulumi.get(self, "tls_ca")

    @_builtins.property
    @pulumi.getter(name="tlsCertificateKey")
    def tls_certificate_key(self) -> Optional[_builtins.str]:
        """
        x509 certificate for connecting to the database. This must be a PEM encoded version of the private key and the certificate combined.
        """
        return pulumi.get(self, "tls_certificate_key")

    @_builtins.property
    @pulumi.getter
    def username(self) -> Optional[_builtins.str]:
        """
        The root credential username used in the connection URL
        """
        return pulumi.get(self, "username")

    @_builtins.property
    @pulumi.getter(name="usernameTemplate")
    def username_template(self) -> Optional[_builtins.str]:
        """
        Username generation template.
        """
        return pulumi.get(self, "username_template")


@pulumi.output_type
class SecretBackendConnectionMysqlLegacy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authType":
            suggest = "auth_type"
        elif key == "connectionUrl":
            suggest = "connection_url"
        elif key == "maxConnectionLifetime":
            suggest = "max_connection_lifetime"
        elif key == "maxIdleConnections":
            suggest = "max_idle_connections"
        elif key == "maxOpenConnections":
            suggest = "max_open_connections"
        elif key == "passwordWo":
            suggest = "password_wo"
        elif key == "passwordWoVersion":
            suggest = "password_wo_version"
        elif key == "serviceAccountJson":
            suggest = "service_account_json"
        elif key == "tlsCa":
            suggest = "tls_ca"
        elif key == "tlsCertificateKey":
            suggest = "tls_certificate_key"
        elif key == "usernameTemplate":
            suggest = "username_template"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecretBackendConnectionMysqlLegacy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecretBackendConnectionMysqlLegacy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecretBackendConnectionMysqlLegacy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 auth_type: Optional[_builtins.str] = None,
                 connection_url: Optional[_builtins.str] = None,
                 max_connection_lifetime: Optional[_builtins.int] = None,
                 max_idle_connections: Optional[_builtins.int] = None,
                 max_open_connections: Optional[_builtins.int] = None,
                 password: Optional[_builtins.str] = None,
                 password_wo: Optional[_builtins.str] = None,
                 password_wo_version: Optional[_builtins.int] = None,
                 service_account_json: Optional[_builtins.str] = None,
                 tls_ca: Optional[_builtins.str] = None,
                 tls_certificate_key: Optional[_builtins.str] = None,
                 username: Optional[_builtins.str] = None,
                 username_template: Optional[_builtins.str] = None):
        """
        :param _builtins.str auth_type: Specify alternative authorization type. (Only 'gcp_iam' is valid currently)
        :param _builtins.str connection_url: Connection string to use to connect to the database.
        :param _builtins.int max_connection_lifetime: Maximum number of seconds a connection may be reused.
        :param _builtins.int max_idle_connections: Maximum number of idle connections to the database.
        :param _builtins.int max_open_connections: Maximum number of open connections to the database.
        :param _builtins.str password: The root credential password used in the connection URL
        :param _builtins.str password_wo: **NOTE:** This field is write-only and its value will not be updated in state as part of read operations.
               Write-only field for the root credential password used in the connection URL
        :param _builtins.int password_wo_version: Version counter for root credential password write-only field
        :param _builtins.str service_account_json: A JSON encoded credential for use with IAM authorization
        :param _builtins.str tls_ca: x509 CA file for validating the certificate presented by the MySQL server. Must be PEM encoded.
        :param _builtins.str tls_certificate_key: x509 certificate for connecting to the database. This must be a PEM encoded version of the private key and the certificate combined.
        :param _builtins.str username: The root credential username used in the connection URL
        :param _builtins.str username_template: Username generation template.
        """
        if auth_type is not None:
            pulumi.set(__self__, "auth_type", auth_type)
        if connection_url is not None:
            pulumi.set(__self__, "connection_url", connection_url)
        if max_connection_lifetime is not None:
            pulumi.set(__self__, "max_connection_lifetime", max_connection_lifetime)
        if max_idle_connections is not None:
            pulumi.set(__self__, "max_idle_connections", max_idle_connections)
        if max_open_connections is not None:
            pulumi.set(__self__, "max_open_connections", max_open_connections)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if password_wo is not None:
            pulumi.set(__self__, "password_wo", password_wo)
        if password_wo_version is not None:
            pulumi.set(__self__, "password_wo_version", password_wo_version)
        if service_account_json is not None:
            pulumi.set(__self__, "service_account_json", service_account_json)
        if tls_ca is not None:
            pulumi.set(__self__, "tls_ca", tls_ca)
        if tls_certificate_key is not None:
            pulumi.set(__self__, "tls_certificate_key", tls_certificate_key)
        if username is not None:
            pulumi.set(__self__, "username", username)
        if username_template is not None:
            pulumi.set(__self__, "username_template", username_template)

    @_builtins.property
    @pulumi.getter(name="authType")
    def auth_type(self) -> Optional[_builtins.str]:
        """
        Specify alternative authorization type. (Only 'gcp_iam' is valid currently)
        """
        return pulumi.get(self, "auth_type")

    @_builtins.property
    @pulumi.getter(name="connectionUrl")
    def connection_url(self) -> Optional[_builtins.str]:
        """
        Connection string to use to connect to the database.
        """
        return pulumi.get(self, "connection_url")

    @_builtins.property
    @pulumi.getter(name="maxConnectionLifetime")
    def max_connection_lifetime(self) -> Optional[_builtins.int]:
        """
        Maximum number of seconds a connection may be reused.
        """
        return pulumi.get(self, "max_connection_lifetime")

    @_builtins.property
    @pulumi.getter(name="maxIdleConnections")
    def max_idle_connections(self) -> Optional[_builtins.int]:
        """
        Maximum number of idle connections to the database.
        """
        return pulumi.get(self, "max_idle_connections")

    @_builtins.property
    @pulumi.getter(name="maxOpenConnections")
    def max_open_connections(self) -> Optional[_builtins.int]:
        """
        Maximum number of open connections to the database.
        """
        return pulumi.get(self, "max_open_connections")

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[_builtins.str]:
        """
        The root credential password used in the connection URL
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter(name="passwordWo")
    def password_wo(self) -> Optional[_builtins.str]:
        """
        **NOTE:** This field is write-only and its value will not be updated in state as part of read operations.
        Write-only field for the root credential password used in the connection URL
        """
        return pulumi.get(self, "password_wo")

    @_builtins.property
    @pulumi.getter(name="passwordWoVersion")
    def password_wo_version(self) -> Optional[_builtins.int]:
        """
        Version counter for root credential password write-only field
        """
        return pulumi.get(self, "password_wo_version")

    @_builtins.property
    @pulumi.getter(name="serviceAccountJson")
    def service_account_json(self) -> Optional[_builtins.str]:
        """
        A JSON encoded credential for use with IAM authorization
        """
        return pulumi.get(self, "service_account_json")

    @_builtins.property
    @pulumi.getter(name="tlsCa")
    def tls_ca(self) -> Optional[_builtins.str]:
        """
        x509 CA file for validating the certificate presented by the MySQL server. Must be PEM encoded.
        """
        return pulumi.get(self, "tls_ca")

    @_builtins.property
    @pulumi.getter(name="tlsCertificateKey")
    def tls_certificate_key(self) -> Optional[_builtins.str]:
        """
        x509 certificate for connecting to the database. This must be a PEM encoded version of the private key and the certificate combined.
        """
        return pulumi.get(self, "tls_certificate_key")

    @_builtins.property
    @pulumi.getter
    def username(self) -> Optional[_builtins.str]:
        """
        The root credential username used in the connection URL
        """
        return pulumi.get(self, "username")

    @_builtins.property
    @pulumi.getter(name="usernameTemplate")
    def username_template(self) -> Optional[_builtins.str]:
        """
        Username generation template.
        """
        return pulumi.get(self, "username_template")


@pulumi.output_type
class SecretBackendConnectionMysqlRds(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authType":
            suggest = "auth_type"
        elif key == "connectionUrl":
            suggest = "connection_url"
        elif key == "maxConnectionLifetime":
            suggest = "max_connection_lifetime"
        elif key == "maxIdleConnections":
            suggest = "max_idle_connections"
        elif key == "maxOpenConnections":
            suggest = "max_open_connections"
        elif key == "passwordWo":
            suggest = "password_wo"
        elif key == "passwordWoVersion":
            suggest = "password_wo_version"
        elif key == "serviceAccountJson":
            suggest = "service_account_json"
        elif key == "tlsCa":
            suggest = "tls_ca"
        elif key == "tlsCertificateKey":
            suggest = "tls_certificate_key"
        elif key == "usernameTemplate":
            suggest = "username_template"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecretBackendConnectionMysqlRds. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecretBackendConnectionMysqlRds.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecretBackendConnectionMysqlRds.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 auth_type: Optional[_builtins.str] = None,
                 connection_url: Optional[_builtins.str] = None,
                 max_connection_lifetime: Optional[_builtins.int] = None,
                 max_idle_connections: Optional[_builtins.int] = None,
                 max_open_connections: Optional[_builtins.int] = None,
                 password: Optional[_builtins.str] = None,
                 password_wo: Optional[_builtins.str] = None,
                 password_wo_version: Optional[_builtins.int] = None,
                 service_account_json: Optional[_builtins.str] = None,
                 tls_ca: Optional[_builtins.str] = None,
                 tls_certificate_key: Optional[_builtins.str] = None,
                 username: Optional[_builtins.str] = None,
                 username_template: Optional[_builtins.str] = None):
        """
        :param _builtins.str auth_type: Specify alternative authorization type. (Only 'gcp_iam' is valid currently)
        :param _builtins.str connection_url: Connection string to use to connect to the database.
        :param _builtins.int max_connection_lifetime: Maximum number of seconds a connection may be reused.
        :param _builtins.int max_idle_connections: Maximum number of idle connections to the database.
        :param _builtins.int max_open_connections: Maximum number of open connections to the database.
        :param _builtins.str password: The root credential password used in the connection URL
        :param _builtins.str password_wo: **NOTE:** This field is write-only and its value will not be updated in state as part of read operations.
               Write-only field for the root credential password used in the connection URL
        :param _builtins.int password_wo_version: Version counter for root credential password write-only field
        :param _builtins.str service_account_json: A JSON encoded credential for use with IAM authorization
        :param _builtins.str tls_ca: x509 CA file for validating the certificate presented by the MySQL server. Must be PEM encoded.
        :param _builtins.str tls_certificate_key: x509 certificate for connecting to the database. This must be a PEM encoded version of the private key and the certificate combined.
        :param _builtins.str username: The root credential username used in the connection URL
        :param _builtins.str username_template: Username generation template.
        """
        if auth_type is not None:
            pulumi.set(__self__, "auth_type", auth_type)
        if connection_url is not None:
            pulumi.set(__self__, "connection_url", connection_url)
        if max_connection_lifetime is not None:
            pulumi.set(__self__, "max_connection_lifetime", max_connection_lifetime)
        if max_idle_connections is not None:
            pulumi.set(__self__, "max_idle_connections", max_idle_connections)
        if max_open_connections is not None:
            pulumi.set(__self__, "max_open_connections", max_open_connections)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if password_wo is not None:
            pulumi.set(__self__, "password_wo", password_wo)
        if password_wo_version is not None:
            pulumi.set(__self__, "password_wo_version", password_wo_version)
        if service_account_json is not None:
            pulumi.set(__self__, "service_account_json", service_account_json)
        if tls_ca is not None:
            pulumi.set(__self__, "tls_ca", tls_ca)
        if tls_certificate_key is not None:
            pulumi.set(__self__, "tls_certificate_key", tls_certificate_key)
        if username is not None:
            pulumi.set(__self__, "username", username)
        if username_template is not None:
            pulumi.set(__self__, "username_template", username_template)

    @_builtins.property
    @pulumi.getter(name="authType")
    def auth_type(self) -> Optional[_builtins.str]:
        """
        Specify alternative authorization type. (Only 'gcp_iam' is valid currently)
        """
        return pulumi.get(self, "auth_type")

    @_builtins.property
    @pulumi.getter(name="connectionUrl")
    def connection_url(self) -> Optional[_builtins.str]:
        """
        Connection string to use to connect to the database.
        """
        return pulumi.get(self, "connection_url")

    @_builtins.property
    @pulumi.getter(name="maxConnectionLifetime")
    def max_connection_lifetime(self) -> Optional[_builtins.int]:
        """
        Maximum number of seconds a connection may be reused.
        """
        return pulumi.get(self, "max_connection_lifetime")

    @_builtins.property
    @pulumi.getter(name="maxIdleConnections")
    def max_idle_connections(self) -> Optional[_builtins.int]:
        """
        Maximum number of idle connections to the database.
        """
        return pulumi.get(self, "max_idle_connections")

    @_builtins.property
    @pulumi.getter(name="maxOpenConnections")
    def max_open_connections(self) -> Optional[_builtins.int]:
        """
        Maximum number of open connections to the database.
        """
        return pulumi.get(self, "max_open_connections")

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[_builtins.str]:
        """
        The root credential password used in the connection URL
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter(name="passwordWo")
    def password_wo(self) -> Optional[_builtins.str]:
        """
        **NOTE:** This field is write-only and its value will not be updated in state as part of read operations.
        Write-only field for the root credential password used in the connection URL
        """
        return pulumi.get(self, "password_wo")

    @_builtins.property
    @pulumi.getter(name="passwordWoVersion")
    def password_wo_version(self) -> Optional[_builtins.int]:
        """
        Version counter for root credential password write-only field
        """
        return pulumi.get(self, "password_wo_version")

    @_builtins.property
    @pulumi.getter(name="serviceAccountJson")
    def service_account_json(self) -> Optional[_builtins.str]:
        """
        A JSON encoded credential for use with IAM authorization
        """
        return pulumi.get(self, "service_account_json")

    @_builtins.property
    @pulumi.getter(name="tlsCa")
    def tls_ca(self) -> Optional[_builtins.str]:
        """
        x509 CA file for validating the certificate presented by the MySQL server. Must be PEM encoded.
        """
        return pulumi.get(self, "tls_ca")

    @_builtins.property
    @pulumi.getter(name="tlsCertificateKey")
    def tls_certificate_key(self) -> Optional[_builtins.str]:
        """
        x509 certificate for connecting to the database. This must be a PEM encoded version of the private key and the certificate combined.
        """
        return pulumi.get(self, "tls_certificate_key")

    @_builtins.property
    @pulumi.getter
    def username(self) -> Optional[_builtins.str]:
        """
        The root credential username used in the connection URL
        """
        return pulumi.get(self, "username")

    @_builtins.property
    @pulumi.getter(name="usernameTemplate")
    def username_template(self) -> Optional[_builtins.str]:
        """
        Username generation template.
        """
        return pulumi.get(self, "username_template")


@pulumi.output_type
class SecretBackendConnectionOracle(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectionUrl":
            suggest = "connection_url"
        elif key == "disconnectSessions":
            suggest = "disconnect_sessions"
        elif key == "maxConnectionLifetime":
            suggest = "max_connection_lifetime"
        elif key == "maxIdleConnections":
            suggest = "max_idle_connections"
        elif key == "maxOpenConnections":
            suggest = "max_open_connections"
        elif key == "passwordWo":
            suggest = "password_wo"
        elif key == "passwordWoVersion":
            suggest = "password_wo_version"
        elif key == "splitStatements":
            suggest = "split_statements"
        elif key == "usernameTemplate":
            suggest = "username_template"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecretBackendConnectionOracle. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecretBackendConnectionOracle.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecretBackendConnectionOracle.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 connection_url: Optional[_builtins.str] = None,
                 disconnect_sessions: Optional[_builtins.bool] = None,
                 max_connection_lifetime: Optional[_builtins.int] = None,
                 max_idle_connections: Optional[_builtins.int] = None,
                 max_open_connections: Optional[_builtins.int] = None,
                 password: Optional[_builtins.str] = None,
                 password_wo: Optional[_builtins.str] = None,
                 password_wo_version: Optional[_builtins.int] = None,
                 split_statements: Optional[_builtins.bool] = None,
                 username: Optional[_builtins.str] = None,
                 username_template: Optional[_builtins.str] = None):
        """
        :param _builtins.str connection_url: Connection string to use to connect to the database.
        :param _builtins.bool disconnect_sessions: Set to true to disconnect any open sessions prior to running the revocation statements.
        :param _builtins.int max_connection_lifetime: Maximum number of seconds a connection may be reused.
        :param _builtins.int max_idle_connections: Maximum number of idle connections to the database.
        :param _builtins.int max_open_connections: Maximum number of open connections to the database.
        :param _builtins.str password: The root credential password used in the connection URL
        :param _builtins.str password_wo: **NOTE:** This field is write-only and its value will not be updated in state as part of read operations.
               Write-only field for the root credential password used in the connection URL
        :param _builtins.int password_wo_version: Version counter for root credential password write-only field
        :param _builtins.bool split_statements: Set to true in order to split statements after semi-colons.
        :param _builtins.str username: The root credential username used in the connection URL
        :param _builtins.str username_template: Username generation template.
        """
        if connection_url is not None:
            pulumi.set(__self__, "connection_url", connection_url)
        if disconnect_sessions is not None:
            pulumi.set(__self__, "disconnect_sessions", disconnect_sessions)
        if max_connection_lifetime is not None:
            pulumi.set(__self__, "max_connection_lifetime", max_connection_lifetime)
        if max_idle_connections is not None:
            pulumi.set(__self__, "max_idle_connections", max_idle_connections)
        if max_open_connections is not None:
            pulumi.set(__self__, "max_open_connections", max_open_connections)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if password_wo is not None:
            pulumi.set(__self__, "password_wo", password_wo)
        if password_wo_version is not None:
            pulumi.set(__self__, "password_wo_version", password_wo_version)
        if split_statements is not None:
            pulumi.set(__self__, "split_statements", split_statements)
        if username is not None:
            pulumi.set(__self__, "username", username)
        if username_template is not None:
            pulumi.set(__self__, "username_template", username_template)

    @_builtins.property
    @pulumi.getter(name="connectionUrl")
    def connection_url(self) -> Optional[_builtins.str]:
        """
        Connection string to use to connect to the database.
        """
        return pulumi.get(self, "connection_url")

    @_builtins.property
    @pulumi.getter(name="disconnectSessions")
    def disconnect_sessions(self) -> Optional[_builtins.bool]:
        """
        Set to true to disconnect any open sessions prior to running the revocation statements.
        """
        return pulumi.get(self, "disconnect_sessions")

    @_builtins.property
    @pulumi.getter(name="maxConnectionLifetime")
    def max_connection_lifetime(self) -> Optional[_builtins.int]:
        """
        Maximum number of seconds a connection may be reused.
        """
        return pulumi.get(self, "max_connection_lifetime")

    @_builtins.property
    @pulumi.getter(name="maxIdleConnections")
    def max_idle_connections(self) -> Optional[_builtins.int]:
        """
        Maximum number of idle connections to the database.
        """
        return pulumi.get(self, "max_idle_connections")

    @_builtins.property
    @pulumi.getter(name="maxOpenConnections")
    def max_open_connections(self) -> Optional[_builtins.int]:
        """
        Maximum number of open connections to the database.
        """
        return pulumi.get(self, "max_open_connections")

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[_builtins.str]:
        """
        The root credential password used in the connection URL
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter(name="passwordWo")
    def password_wo(self) -> Optional[_builtins.str]:
        """
        **NOTE:** This field is write-only and its value will not be updated in state as part of read operations.
        Write-only field for the root credential password used in the connection URL
        """
        return pulumi.get(self, "password_wo")

    @_builtins.property
    @pulumi.getter(name="passwordWoVersion")
    def password_wo_version(self) -> Optional[_builtins.int]:
        """
        Version counter for root credential password write-only field
        """
        return pulumi.get(self, "password_wo_version")

    @_builtins.property
    @pulumi.getter(name="splitStatements")
    def split_statements(self) -> Optional[_builtins.bool]:
        """
        Set to true in order to split statements after semi-colons.
        """
        return pulumi.get(self, "split_statements")

    @_builtins.property
    @pulumi.getter
    def username(self) -> Optional[_builtins.str]:
        """
        The root credential username used in the connection URL
        """
        return pulumi.get(self, "username")

    @_builtins.property
    @pulumi.getter(name="usernameTemplate")
    def username_template(self) -> Optional[_builtins.str]:
        """
        Username generation template.
        """
        return pulumi.get(self, "username_template")


@pulumi.output_type
class SecretBackendConnectionPostgresql(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authType":
            suggest = "auth_type"
        elif key == "connectionUrl":
            suggest = "connection_url"
        elif key == "disableEscaping":
            suggest = "disable_escaping"
        elif key == "maxConnectionLifetime":
            suggest = "max_connection_lifetime"
        elif key == "maxIdleConnections":
            suggest = "max_idle_connections"
        elif key == "maxOpenConnections":
            suggest = "max_open_connections"
        elif key == "passwordAuthentication":
            suggest = "password_authentication"
        elif key == "passwordWo":
            suggest = "password_wo"
        elif key == "passwordWoVersion":
            suggest = "password_wo_version"
        elif key == "privateKey":
            suggest = "private_key"
        elif key == "selfManaged":
            suggest = "self_managed"
        elif key == "serviceAccountJson":
            suggest = "service_account_json"
        elif key == "tlsCa":
            suggest = "tls_ca"
        elif key == "tlsCertificate":
            suggest = "tls_certificate"
        elif key == "usernameTemplate":
            suggest = "username_template"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecretBackendConnectionPostgresql. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecretBackendConnectionPostgresql.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecretBackendConnectionPostgresql.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 auth_type: Optional[_builtins.str] = None,
                 connection_url: Optional[_builtins.str] = None,
                 disable_escaping: Optional[_builtins.bool] = None,
                 max_connection_lifetime: Optional[_builtins.int] = None,
                 max_idle_connections: Optional[_builtins.int] = None,
                 max_open_connections: Optional[_builtins.int] = None,
                 password: Optional[_builtins.str] = None,
                 password_authentication: Optional[_builtins.str] = None,
                 password_wo: Optional[_builtins.str] = None,
                 password_wo_version: Optional[_builtins.int] = None,
                 private_key: Optional[_builtins.str] = None,
                 self_managed: Optional[_builtins.bool] = None,
                 service_account_json: Optional[_builtins.str] = None,
                 tls_ca: Optional[_builtins.str] = None,
                 tls_certificate: Optional[_builtins.str] = None,
                 username: Optional[_builtins.str] = None,
                 username_template: Optional[_builtins.str] = None):
        """
        :param _builtins.str auth_type: Specify alternative authorization type. (Only 'gcp_iam' is valid currently)
        :param _builtins.str connection_url: Connection string to use to connect to the database.
        :param _builtins.bool disable_escaping: Disable special character escaping in username and password
        :param _builtins.int max_connection_lifetime: Maximum number of seconds a connection may be reused.
        :param _builtins.int max_idle_connections: Maximum number of idle connections to the database.
        :param _builtins.int max_open_connections: Maximum number of open connections to the database.
        :param _builtins.str password: The root credential password used in the connection URL
        :param _builtins.str password_authentication: When set to `scram-sha-256`, passwords will be hashed by Vault before being sent to PostgreSQL.
        :param _builtins.str password_wo: **NOTE:** This field is write-only and its value will not be updated in state as part of read operations.
               Write-only field for the root credential password used in the connection URL
        :param _builtins.int password_wo_version: Version counter for root credential password write-only field
        :param _builtins.str private_key: The secret key used for the x509 client certificate. Must be PEM encoded.
        :param _builtins.bool self_managed: If set, allows onboarding static roles with a rootless connection configuration.
        :param _builtins.str service_account_json: A JSON encoded credential for use with IAM authorization
        :param _builtins.str tls_ca: The x509 CA file for validating the certificate presented by the PostgreSQL server. Must be PEM encoded.
        :param _builtins.str tls_certificate: The x509 client certificate for connecting to the database. Must be PEM encoded.
        :param _builtins.str username: The root credential username used in the connection URL
        :param _builtins.str username_template: Username generation template.
        """
        if auth_type is not None:
            pulumi.set(__self__, "auth_type", auth_type)
        if connection_url is not None:
            pulumi.set(__self__, "connection_url", connection_url)
        if disable_escaping is not None:
            pulumi.set(__self__, "disable_escaping", disable_escaping)
        if max_connection_lifetime is not None:
            pulumi.set(__self__, "max_connection_lifetime", max_connection_lifetime)
        if max_idle_connections is not None:
            pulumi.set(__self__, "max_idle_connections", max_idle_connections)
        if max_open_connections is not None:
            pulumi.set(__self__, "max_open_connections", max_open_connections)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if password_authentication is not None:
            pulumi.set(__self__, "password_authentication", password_authentication)
        if password_wo is not None:
            pulumi.set(__self__, "password_wo", password_wo)
        if password_wo_version is not None:
            pulumi.set(__self__, "password_wo_version", password_wo_version)
        if private_key is not None:
            pulumi.set(__self__, "private_key", private_key)
        if self_managed is not None:
            pulumi.set(__self__, "self_managed", self_managed)
        if service_account_json is not None:
            pulumi.set(__self__, "service_account_json", service_account_json)
        if tls_ca is not None:
            pulumi.set(__self__, "tls_ca", tls_ca)
        if tls_certificate is not None:
            pulumi.set(__self__, "tls_certificate", tls_certificate)
        if username is not None:
            pulumi.set(__self__, "username", username)
        if username_template is not None:
            pulumi.set(__self__, "username_template", username_template)

    @_builtins.property
    @pulumi.getter(name="authType")
    def auth_type(self) -> Optional[_builtins.str]:
        """
        Specify alternative authorization type. (Only 'gcp_iam' is valid currently)
        """
        return pulumi.get(self, "auth_type")

    @_builtins.property
    @pulumi.getter(name="connectionUrl")
    def connection_url(self) -> Optional[_builtins.str]:
        """
        Connection string to use to connect to the database.
        """
        return pulumi.get(self, "connection_url")

    @_builtins.property
    @pulumi.getter(name="disableEscaping")
    def disable_escaping(self) -> Optional[_builtins.bool]:
        """
        Disable special character escaping in username and password
        """
        return pulumi.get(self, "disable_escaping")

    @_builtins.property
    @pulumi.getter(name="maxConnectionLifetime")
    def max_connection_lifetime(self) -> Optional[_builtins.int]:
        """
        Maximum number of seconds a connection may be reused.
        """
        return pulumi.get(self, "max_connection_lifetime")

    @_builtins.property
    @pulumi.getter(name="maxIdleConnections")
    def max_idle_connections(self) -> Optional[_builtins.int]:
        """
        Maximum number of idle connections to the database.
        """
        return pulumi.get(self, "max_idle_connections")

    @_builtins.property
    @pulumi.getter(name="maxOpenConnections")
    def max_open_connections(self) -> Optional[_builtins.int]:
        """
        Maximum number of open connections to the database.
        """
        return pulumi.get(self, "max_open_connections")

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[_builtins.str]:
        """
        The root credential password used in the connection URL
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter(name="passwordAuthentication")
    def password_authentication(self) -> Optional[_builtins.str]:
        """
        When set to `scram-sha-256`, passwords will be hashed by Vault before being sent to PostgreSQL.
        """
        return pulumi.get(self, "password_authentication")

    @_builtins.property
    @pulumi.getter(name="passwordWo")
    def password_wo(self) -> Optional[_builtins.str]:
        """
        **NOTE:** This field is write-only and its value will not be updated in state as part of read operations.
        Write-only field for the root credential password used in the connection URL
        """
        return pulumi.get(self, "password_wo")

    @_builtins.property
    @pulumi.getter(name="passwordWoVersion")
    def password_wo_version(self) -> Optional[_builtins.int]:
        """
        Version counter for root credential password write-only field
        """
        return pulumi.get(self, "password_wo_version")

    @_builtins.property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> Optional[_builtins.str]:
        """
        The secret key used for the x509 client certificate. Must be PEM encoded.
        """
        return pulumi.get(self, "private_key")

    @_builtins.property
    @pulumi.getter(name="selfManaged")
    def self_managed(self) -> Optional[_builtins.bool]:
        """
        If set, allows onboarding static roles with a rootless connection configuration.
        """
        return pulumi.get(self, "self_managed")

    @_builtins.property
    @pulumi.getter(name="serviceAccountJson")
    def service_account_json(self) -> Optional[_builtins.str]:
        """
        A JSON encoded credential for use with IAM authorization
        """
        return pulumi.get(self, "service_account_json")

    @_builtins.property
    @pulumi.getter(name="tlsCa")
    def tls_ca(self) -> Optional[_builtins.str]:
        """
        The x509 CA file for validating the certificate presented by the PostgreSQL server. Must be PEM encoded.
        """
        return pulumi.get(self, "tls_ca")

    @_builtins.property
    @pulumi.getter(name="tlsCertificate")
    def tls_certificate(self) -> Optional[_builtins.str]:
        """
        The x509 client certificate for connecting to the database. Must be PEM encoded.
        """
        return pulumi.get(self, "tls_certificate")

    @_builtins.property
    @pulumi.getter
    def username(self) -> Optional[_builtins.str]:
        """
        The root credential username used in the connection URL
        """
        return pulumi.get(self, "username")

    @_builtins.property
    @pulumi.getter(name="usernameTemplate")
    def username_template(self) -> Optional[_builtins.str]:
        """
        Username generation template.
        """
        return pulumi.get(self, "username_template")


@pulumi.output_type
class SecretBackendConnectionRedis(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "caCert":
            suggest = "ca_cert"
        elif key == "insecureTls":
            suggest = "insecure_tls"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecretBackendConnectionRedis. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecretBackendConnectionRedis.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecretBackendConnectionRedis.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 host: _builtins.str,
                 password: _builtins.str,
                 username: _builtins.str,
                 ca_cert: Optional[_builtins.str] = None,
                 insecure_tls: Optional[_builtins.bool] = None,
                 port: Optional[_builtins.int] = None,
                 tls: Optional[_builtins.bool] = None):
        """
        :param _builtins.str host: Specifies the host to connect to
        :param _builtins.str password: Specifies the password corresponding to the given username.
        :param _builtins.str username: Specifies the username for Vault to use.
        :param _builtins.str ca_cert: The contents of a PEM-encoded CA cert file to use to verify the Redis server's identity.
        :param _builtins.bool insecure_tls: Specifies whether to skip verification of the server certificate when using TLS.
        :param _builtins.int port: The transport port to use to connect to Redis.
        :param _builtins.bool tls: Specifies whether to use TLS when connecting to Redis.
        """
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "username", username)
        if ca_cert is not None:
            pulumi.set(__self__, "ca_cert", ca_cert)
        if insecure_tls is not None:
            pulumi.set(__self__, "insecure_tls", insecure_tls)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if tls is not None:
            pulumi.set(__self__, "tls", tls)

    @_builtins.property
    @pulumi.getter
    def host(self) -> _builtins.str:
        """
        Specifies the host to connect to
        """
        return pulumi.get(self, "host")

    @_builtins.property
    @pulumi.getter
    def password(self) -> _builtins.str:
        """
        Specifies the password corresponding to the given username.
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter
    def username(self) -> _builtins.str:
        """
        Specifies the username for Vault to use.
        """
        return pulumi.get(self, "username")

    @_builtins.property
    @pulumi.getter(name="caCert")
    def ca_cert(self) -> Optional[_builtins.str]:
        """
        The contents of a PEM-encoded CA cert file to use to verify the Redis server's identity.
        """
        return pulumi.get(self, "ca_cert")

    @_builtins.property
    @pulumi.getter(name="insecureTls")
    def insecure_tls(self) -> Optional[_builtins.bool]:
        """
        Specifies whether to skip verification of the server certificate when using TLS.
        """
        return pulumi.get(self, "insecure_tls")

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[_builtins.int]:
        """
        The transport port to use to connect to Redis.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter
    def tls(self) -> Optional[_builtins.bool]:
        """
        Specifies whether to use TLS when connecting to Redis.
        """
        return pulumi.get(self, "tls")


@pulumi.output_type
class SecretBackendConnectionRedisElasticache(dict):
    def __init__(__self__, *,
                 url: _builtins.str,
                 password: Optional[_builtins.str] = None,
                 region: Optional[_builtins.str] = None,
                 username: Optional[_builtins.str] = None):
        """
        :param _builtins.str url: The configuration endpoint for the ElastiCache cluster to connect to.
        :param _builtins.str password: The AWS secret key id to use to talk to ElastiCache. If omitted the credentials chain provider is used instead.
        :param _builtins.str region: The AWS region where the ElastiCache cluster is hosted. If omitted the plugin tries to infer the region from the environment.
        :param _builtins.str username: The AWS access key id to use to talk to ElastiCache. If omitted the credentials chain provider is used instead.
        """
        pulumi.set(__self__, "url", url)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @_builtins.property
    @pulumi.getter
    def url(self) -> _builtins.str:
        """
        The configuration endpoint for the ElastiCache cluster to connect to.
        """
        return pulumi.get(self, "url")

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[_builtins.str]:
        """
        The AWS secret key id to use to talk to ElastiCache. If omitted the credentials chain provider is used instead.
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[_builtins.str]:
        """
        The AWS region where the ElastiCache cluster is hosted. If omitted the plugin tries to infer the region from the environment.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def username(self) -> Optional[_builtins.str]:
        """
        The AWS access key id to use to talk to ElastiCache. If omitted the credentials chain provider is used instead.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class SecretBackendConnectionRedshift(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectionUrl":
            suggest = "connection_url"
        elif key == "disableEscaping":
            suggest = "disable_escaping"
        elif key == "maxConnectionLifetime":
            suggest = "max_connection_lifetime"
        elif key == "maxIdleConnections":
            suggest = "max_idle_connections"
        elif key == "maxOpenConnections":
            suggest = "max_open_connections"
        elif key == "passwordWo":
            suggest = "password_wo"
        elif key == "passwordWoVersion":
            suggest = "password_wo_version"
        elif key == "usernameTemplate":
            suggest = "username_template"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecretBackendConnectionRedshift. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecretBackendConnectionRedshift.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecretBackendConnectionRedshift.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 connection_url: Optional[_builtins.str] = None,
                 disable_escaping: Optional[_builtins.bool] = None,
                 max_connection_lifetime: Optional[_builtins.int] = None,
                 max_idle_connections: Optional[_builtins.int] = None,
                 max_open_connections: Optional[_builtins.int] = None,
                 password: Optional[_builtins.str] = None,
                 password_wo: Optional[_builtins.str] = None,
                 password_wo_version: Optional[_builtins.int] = None,
                 username: Optional[_builtins.str] = None,
                 username_template: Optional[_builtins.str] = None):
        """
        :param _builtins.str connection_url: Connection string to use to connect to the database.
        :param _builtins.bool disable_escaping: Disable special character escaping in username and password
        :param _builtins.int max_connection_lifetime: Maximum number of seconds a connection may be reused.
        :param _builtins.int max_idle_connections: Maximum number of idle connections to the database.
        :param _builtins.int max_open_connections: Maximum number of open connections to the database.
        :param _builtins.str password: The root credential password used in the connection URL
        :param _builtins.str password_wo: **NOTE:** This field is write-only and its value will not be updated in state as part of read operations.
               Write-only field for the root credential password used in the connection URL
        :param _builtins.int password_wo_version: Version counter for root credential password write-only field
        :param _builtins.str username: The root credential username used in the connection URL
        :param _builtins.str username_template: Username generation template.
        """
        if connection_url is not None:
            pulumi.set(__self__, "connection_url", connection_url)
        if disable_escaping is not None:
            pulumi.set(__self__, "disable_escaping", disable_escaping)
        if max_connection_lifetime is not None:
            pulumi.set(__self__, "max_connection_lifetime", max_connection_lifetime)
        if max_idle_connections is not None:
            pulumi.set(__self__, "max_idle_connections", max_idle_connections)
        if max_open_connections is not None:
            pulumi.set(__self__, "max_open_connections", max_open_connections)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if password_wo is not None:
            pulumi.set(__self__, "password_wo", password_wo)
        if password_wo_version is not None:
            pulumi.set(__self__, "password_wo_version", password_wo_version)
        if username is not None:
            pulumi.set(__self__, "username", username)
        if username_template is not None:
            pulumi.set(__self__, "username_template", username_template)

    @_builtins.property
    @pulumi.getter(name="connectionUrl")
    def connection_url(self) -> Optional[_builtins.str]:
        """
        Connection string to use to connect to the database.
        """
        return pulumi.get(self, "connection_url")

    @_builtins.property
    @pulumi.getter(name="disableEscaping")
    def disable_escaping(self) -> Optional[_builtins.bool]:
        """
        Disable special character escaping in username and password
        """
        return pulumi.get(self, "disable_escaping")

    @_builtins.property
    @pulumi.getter(name="maxConnectionLifetime")
    def max_connection_lifetime(self) -> Optional[_builtins.int]:
        """
        Maximum number of seconds a connection may be reused.
        """
        return pulumi.get(self, "max_connection_lifetime")

    @_builtins.property
    @pulumi.getter(name="maxIdleConnections")
    def max_idle_connections(self) -> Optional[_builtins.int]:
        """
        Maximum number of idle connections to the database.
        """
        return pulumi.get(self, "max_idle_connections")

    @_builtins.property
    @pulumi.getter(name="maxOpenConnections")
    def max_open_connections(self) -> Optional[_builtins.int]:
        """
        Maximum number of open connections to the database.
        """
        return pulumi.get(self, "max_open_connections")

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[_builtins.str]:
        """
        The root credential password used in the connection URL
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter(name="passwordWo")
    def password_wo(self) -> Optional[_builtins.str]:
        """
        **NOTE:** This field is write-only and its value will not be updated in state as part of read operations.
        Write-only field for the root credential password used in the connection URL
        """
        return pulumi.get(self, "password_wo")

    @_builtins.property
    @pulumi.getter(name="passwordWoVersion")
    def password_wo_version(self) -> Optional[_builtins.int]:
        """
        Version counter for root credential password write-only field
        """
        return pulumi.get(self, "password_wo_version")

    @_builtins.property
    @pulumi.getter
    def username(self) -> Optional[_builtins.str]:
        """
        The root credential username used in the connection URL
        """
        return pulumi.get(self, "username")

    @_builtins.property
    @pulumi.getter(name="usernameTemplate")
    def username_template(self) -> Optional[_builtins.str]:
        """
        Username generation template.
        """
        return pulumi.get(self, "username_template")


@pulumi.output_type
class SecretBackendConnectionSnowflake(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectionUrl":
            suggest = "connection_url"
        elif key == "maxConnectionLifetime":
            suggest = "max_connection_lifetime"
        elif key == "maxIdleConnections":
            suggest = "max_idle_connections"
        elif key == "maxOpenConnections":
            suggest = "max_open_connections"
        elif key == "passwordWo":
            suggest = "password_wo"
        elif key == "passwordWoVersion":
            suggest = "password_wo_version"
        elif key == "privateKeyWo":
            suggest = "private_key_wo"
        elif key == "privateKeyWoVersion":
            suggest = "private_key_wo_version"
        elif key == "usernameTemplate":
            suggest = "username_template"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecretBackendConnectionSnowflake. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecretBackendConnectionSnowflake.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecretBackendConnectionSnowflake.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 connection_url: Optional[_builtins.str] = None,
                 max_connection_lifetime: Optional[_builtins.int] = None,
                 max_idle_connections: Optional[_builtins.int] = None,
                 max_open_connections: Optional[_builtins.int] = None,
                 password: Optional[_builtins.str] = None,
                 password_wo: Optional[_builtins.str] = None,
                 password_wo_version: Optional[_builtins.int] = None,
                 private_key_wo: Optional[_builtins.str] = None,
                 private_key_wo_version: Optional[_builtins.int] = None,
                 username: Optional[_builtins.str] = None,
                 username_template: Optional[_builtins.str] = None):
        """
        :param _builtins.str connection_url: Connection string to use to connect to the database.
        :param _builtins.int max_connection_lifetime: Maximum number of seconds a connection may be reused.
        :param _builtins.int max_idle_connections: Maximum number of idle connections to the database.
        :param _builtins.int max_open_connections: Maximum number of open connections to the database.
        :param _builtins.str password: The root credential password used in the connection URL
        :param _builtins.str password_wo: **NOTE:** This field is write-only and its value will not be updated in state as part of read operations.
               Write-only field for the root credential password used in the connection URL
        :param _builtins.int password_wo_version: Version counter for root credential password write-only field
        :param _builtins.str private_key_wo: **NOTE:** This field is write-only and its value will not be updated in state as part of read operations.
               The private key configured for the admin user in Snowflake.
        :param _builtins.int private_key_wo_version: Version counter for the private key key-pair credentials write-only field
        :param _builtins.str username: The root credential username used in the connection URL
        :param _builtins.str username_template: Username generation template.
        """
        if connection_url is not None:
            pulumi.set(__self__, "connection_url", connection_url)
        if max_connection_lifetime is not None:
            pulumi.set(__self__, "max_connection_lifetime", max_connection_lifetime)
        if max_idle_connections is not None:
            pulumi.set(__self__, "max_idle_connections", max_idle_connections)
        if max_open_connections is not None:
            pulumi.set(__self__, "max_open_connections", max_open_connections)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if password_wo is not None:
            pulumi.set(__self__, "password_wo", password_wo)
        if password_wo_version is not None:
            pulumi.set(__self__, "password_wo_version", password_wo_version)
        if private_key_wo is not None:
            pulumi.set(__self__, "private_key_wo", private_key_wo)
        if private_key_wo_version is not None:
            pulumi.set(__self__, "private_key_wo_version", private_key_wo_version)
        if username is not None:
            pulumi.set(__self__, "username", username)
        if username_template is not None:
            pulumi.set(__self__, "username_template", username_template)

    @_builtins.property
    @pulumi.getter(name="connectionUrl")
    def connection_url(self) -> Optional[_builtins.str]:
        """
        Connection string to use to connect to the database.
        """
        return pulumi.get(self, "connection_url")

    @_builtins.property
    @pulumi.getter(name="maxConnectionLifetime")
    def max_connection_lifetime(self) -> Optional[_builtins.int]:
        """
        Maximum number of seconds a connection may be reused.
        """
        return pulumi.get(self, "max_connection_lifetime")

    @_builtins.property
    @pulumi.getter(name="maxIdleConnections")
    def max_idle_connections(self) -> Optional[_builtins.int]:
        """
        Maximum number of idle connections to the database.
        """
        return pulumi.get(self, "max_idle_connections")

    @_builtins.property
    @pulumi.getter(name="maxOpenConnections")
    def max_open_connections(self) -> Optional[_builtins.int]:
        """
        Maximum number of open connections to the database.
        """
        return pulumi.get(self, "max_open_connections")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Snowflake is ending support for single-factor password authentication by November 2025. Refer to the documentation for more information on migrating to key-pair authentication.""")
    def password(self) -> Optional[_builtins.str]:
        """
        The root credential password used in the connection URL
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter(name="passwordWo")
    def password_wo(self) -> Optional[_builtins.str]:
        """
        **NOTE:** This field is write-only and its value will not be updated in state as part of read operations.
        Write-only field for the root credential password used in the connection URL
        """
        return pulumi.get(self, "password_wo")

    @_builtins.property
    @pulumi.getter(name="passwordWoVersion")
    def password_wo_version(self) -> Optional[_builtins.int]:
        """
        Version counter for root credential password write-only field
        """
        return pulumi.get(self, "password_wo_version")

    @_builtins.property
    @pulumi.getter(name="privateKeyWo")
    def private_key_wo(self) -> Optional[_builtins.str]:
        """
        **NOTE:** This field is write-only and its value will not be updated in state as part of read operations.
        The private key configured for the admin user in Snowflake.
        """
        return pulumi.get(self, "private_key_wo")

    @_builtins.property
    @pulumi.getter(name="privateKeyWoVersion")
    def private_key_wo_version(self) -> Optional[_builtins.int]:
        """
        Version counter for the private key key-pair credentials write-only field
        """
        return pulumi.get(self, "private_key_wo_version")

    @_builtins.property
    @pulumi.getter
    def username(self) -> Optional[_builtins.str]:
        """
        The root credential username used in the connection URL
        """
        return pulumi.get(self, "username")

    @_builtins.property
    @pulumi.getter(name="usernameTemplate")
    def username_template(self) -> Optional[_builtins.str]:
        """
        Username generation template.
        """
        return pulumi.get(self, "username_template")


@pulumi.output_type
class SecretsMountCassandra(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedRoles":
            suggest = "allowed_roles"
        elif key == "connectTimeout":
            suggest = "connect_timeout"
        elif key == "disableAutomatedRotation":
            suggest = "disable_automated_rotation"
        elif key == "insecureTls":
            suggest = "insecure_tls"
        elif key == "pemBundle":
            suggest = "pem_bundle"
        elif key == "pemJson":
            suggest = "pem_json"
        elif key == "pluginName":
            suggest = "plugin_name"
        elif key == "protocolVersion":
            suggest = "protocol_version"
        elif key == "rootRotationStatements":
            suggest = "root_rotation_statements"
        elif key == "rotationPeriod":
            suggest = "rotation_period"
        elif key == "rotationSchedule":
            suggest = "rotation_schedule"
        elif key == "rotationWindow":
            suggest = "rotation_window"
        elif key == "skipVerification":
            suggest = "skip_verification"
        elif key == "verifyConnection":
            suggest = "verify_connection"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecretsMountCassandra. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecretsMountCassandra.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecretsMountCassandra.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 allowed_roles: Optional[Sequence[_builtins.str]] = None,
                 connect_timeout: Optional[_builtins.int] = None,
                 data: Optional[Mapping[str, _builtins.str]] = None,
                 disable_automated_rotation: Optional[_builtins.bool] = None,
                 hosts: Optional[Sequence[_builtins.str]] = None,
                 insecure_tls: Optional[_builtins.bool] = None,
                 password: Optional[_builtins.str] = None,
                 pem_bundle: Optional[_builtins.str] = None,
                 pem_json: Optional[_builtins.str] = None,
                 plugin_name: Optional[_builtins.str] = None,
                 port: Optional[_builtins.int] = None,
                 protocol_version: Optional[_builtins.int] = None,
                 root_rotation_statements: Optional[Sequence[_builtins.str]] = None,
                 rotation_period: Optional[_builtins.int] = None,
                 rotation_schedule: Optional[_builtins.str] = None,
                 rotation_window: Optional[_builtins.int] = None,
                 skip_verification: Optional[_builtins.bool] = None,
                 tls: Optional[_builtins.bool] = None,
                 username: Optional[_builtins.str] = None,
                 verify_connection: Optional[_builtins.bool] = None):
        """
        :param _builtins.str name: Name of the database connection.
        :param Sequence[_builtins.str] allowed_roles: A list of roles that are allowed to use this
               connection.
        :param _builtins.int connect_timeout: The number of seconds to use as a connection timeout.
        :param Mapping[str, _builtins.str] data: A map of sensitive data to pass to the endpoint. Useful for templated connection strings.
        :param _builtins.bool disable_automated_rotation: Cancels all upcoming rotations of the root credential until unset. Requires Vault Enterprise 1.19+.
               
               Supported list of database secrets engines that can be configured:
        :param Sequence[_builtins.str] hosts: Cassandra hosts to connect to.
        :param _builtins.bool insecure_tls: Whether to skip verification of the server certificate when using TLS.
        :param _builtins.str password: The password to use when authenticating with Cassandra.
        :param _builtins.str pem_bundle: Concatenated PEM blocks containing a certificate and private key; a certificate, private key, and issuing CA certificate; or just a CA certificate.
        :param _builtins.str pem_json: Specifies JSON containing a certificate and private key; a certificate, private key, and issuing CA certificate; or just a CA certificate.
        :param _builtins.str plugin_name: Specifies the name of the plugin to use.
        :param _builtins.int port: The transport port to use to connect to Cassandra.
        :param _builtins.int protocol_version: The CQL protocol version to use.
        :param Sequence[_builtins.str] root_rotation_statements: A list of database statements to be executed to rotate the root user's credentials.
        :param _builtins.int rotation_period: The amount of time in seconds Vault should wait before rotating the root credential.
               A zero value tells Vault not to rotate the root credential. The minimum rotation period is 10 seconds. Requires Vault Enterprise 1.19+.
        :param _builtins.str rotation_schedule: The schedule, in [cron-style time format](https://en.wikipedia.org/wiki/Cron),
               defining the schedule on which Vault should rotate the root token. Requires Vault Enterprise 1.19+.
        :param _builtins.int rotation_window: The maximum amount of time in seconds allowed to complete
               a rotation when a scheduled token rotation occurs. The default rotation window is
               unbound and the minimum allowable window is `3600`. Requires Vault Enterprise 1.19+.
        :param _builtins.bool skip_verification: Skip permissions checks when a connection to Cassandra is first created. These checks ensure that Vault is able to create roles, but can be resource intensive in clusters with many roles.
        :param _builtins.bool tls: Whether to use TLS when connecting to Cassandra.
        :param _builtins.str username: The username to use when authenticating with Cassandra.
        :param _builtins.bool verify_connection: Whether the connection should be verified on
               initial configuration or not.
        """
        pulumi.set(__self__, "name", name)
        if allowed_roles is not None:
            pulumi.set(__self__, "allowed_roles", allowed_roles)
        if connect_timeout is not None:
            pulumi.set(__self__, "connect_timeout", connect_timeout)
        if data is not None:
            pulumi.set(__self__, "data", data)
        if disable_automated_rotation is not None:
            pulumi.set(__self__, "disable_automated_rotation", disable_automated_rotation)
        if hosts is not None:
            pulumi.set(__self__, "hosts", hosts)
        if insecure_tls is not None:
            pulumi.set(__self__, "insecure_tls", insecure_tls)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if pem_bundle is not None:
            pulumi.set(__self__, "pem_bundle", pem_bundle)
        if pem_json is not None:
            pulumi.set(__self__, "pem_json", pem_json)
        if plugin_name is not None:
            pulumi.set(__self__, "plugin_name", plugin_name)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if protocol_version is not None:
            pulumi.set(__self__, "protocol_version", protocol_version)
        if root_rotation_statements is not None:
            pulumi.set(__self__, "root_rotation_statements", root_rotation_statements)
        if rotation_period is not None:
            pulumi.set(__self__, "rotation_period", rotation_period)
        if rotation_schedule is not None:
            pulumi.set(__self__, "rotation_schedule", rotation_schedule)
        if rotation_window is not None:
            pulumi.set(__self__, "rotation_window", rotation_window)
        if skip_verification is not None:
            pulumi.set(__self__, "skip_verification", skip_verification)
        if tls is not None:
            pulumi.set(__self__, "tls", tls)
        if username is not None:
            pulumi.set(__self__, "username", username)
        if verify_connection is not None:
            pulumi.set(__self__, "verify_connection", verify_connection)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the database connection.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="allowedRoles")
    def allowed_roles(self) -> Optional[Sequence[_builtins.str]]:
        """
        A list of roles that are allowed to use this
        connection.
        """
        return pulumi.get(self, "allowed_roles")

    @_builtins.property
    @pulumi.getter(name="connectTimeout")
    def connect_timeout(self) -> Optional[_builtins.int]:
        """
        The number of seconds to use as a connection timeout.
        """
        return pulumi.get(self, "connect_timeout")

    @_builtins.property
    @pulumi.getter
    def data(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        A map of sensitive data to pass to the endpoint. Useful for templated connection strings.
        """
        return pulumi.get(self, "data")

    @_builtins.property
    @pulumi.getter(name="disableAutomatedRotation")
    def disable_automated_rotation(self) -> Optional[_builtins.bool]:
        """
        Cancels all upcoming rotations of the root credential until unset. Requires Vault Enterprise 1.19+.

        Supported list of database secrets engines that can be configured:
        """
        return pulumi.get(self, "disable_automated_rotation")

    @_builtins.property
    @pulumi.getter
    def hosts(self) -> Optional[Sequence[_builtins.str]]:
        """
        Cassandra hosts to connect to.
        """
        return pulumi.get(self, "hosts")

    @_builtins.property
    @pulumi.getter(name="insecureTls")
    def insecure_tls(self) -> Optional[_builtins.bool]:
        """
        Whether to skip verification of the server certificate when using TLS.
        """
        return pulumi.get(self, "insecure_tls")

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[_builtins.str]:
        """
        The password to use when authenticating with Cassandra.
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter(name="pemBundle")
    def pem_bundle(self) -> Optional[_builtins.str]:
        """
        Concatenated PEM blocks containing a certificate and private key; a certificate, private key, and issuing CA certificate; or just a CA certificate.
        """
        return pulumi.get(self, "pem_bundle")

    @_builtins.property
    @pulumi.getter(name="pemJson")
    def pem_json(self) -> Optional[_builtins.str]:
        """
        Specifies JSON containing a certificate and private key; a certificate, private key, and issuing CA certificate; or just a CA certificate.
        """
        return pulumi.get(self, "pem_json")

    @_builtins.property
    @pulumi.getter(name="pluginName")
    def plugin_name(self) -> Optional[_builtins.str]:
        """
        Specifies the name of the plugin to use.
        """
        return pulumi.get(self, "plugin_name")

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[_builtins.int]:
        """
        The transport port to use to connect to Cassandra.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="protocolVersion")
    def protocol_version(self) -> Optional[_builtins.int]:
        """
        The CQL protocol version to use.
        """
        return pulumi.get(self, "protocol_version")

    @_builtins.property
    @pulumi.getter(name="rootRotationStatements")
    def root_rotation_statements(self) -> Optional[Sequence[_builtins.str]]:
        """
        A list of database statements to be executed to rotate the root user's credentials.
        """
        return pulumi.get(self, "root_rotation_statements")

    @_builtins.property
    @pulumi.getter(name="rotationPeriod")
    def rotation_period(self) -> Optional[_builtins.int]:
        """
        The amount of time in seconds Vault should wait before rotating the root credential.
        A zero value tells Vault not to rotate the root credential. The minimum rotation period is 10 seconds. Requires Vault Enterprise 1.19+.
        """
        return pulumi.get(self, "rotation_period")

    @_builtins.property
    @pulumi.getter(name="rotationSchedule")
    def rotation_schedule(self) -> Optional[_builtins.str]:
        """
        The schedule, in [cron-style time format](https://en.wikipedia.org/wiki/Cron),
        defining the schedule on which Vault should rotate the root token. Requires Vault Enterprise 1.19+.
        """
        return pulumi.get(self, "rotation_schedule")

    @_builtins.property
    @pulumi.getter(name="rotationWindow")
    def rotation_window(self) -> Optional[_builtins.int]:
        """
        The maximum amount of time in seconds allowed to complete
        a rotation when a scheduled token rotation occurs. The default rotation window is
        unbound and the minimum allowable window is `3600`. Requires Vault Enterprise 1.19+.
        """
        return pulumi.get(self, "rotation_window")

    @_builtins.property
    @pulumi.getter(name="skipVerification")
    def skip_verification(self) -> Optional[_builtins.bool]:
        """
        Skip permissions checks when a connection to Cassandra is first created. These checks ensure that Vault is able to create roles, but can be resource intensive in clusters with many roles.
        """
        return pulumi.get(self, "skip_verification")

    @_builtins.property
    @pulumi.getter
    def tls(self) -> Optional[_builtins.bool]:
        """
        Whether to use TLS when connecting to Cassandra.
        """
        return pulumi.get(self, "tls")

    @_builtins.property
    @pulumi.getter
    def username(self) -> Optional[_builtins.str]:
        """
        The username to use when authenticating with Cassandra.
        """
        return pulumi.get(self, "username")

    @_builtins.property
    @pulumi.getter(name="verifyConnection")
    def verify_connection(self) -> Optional[_builtins.bool]:
        """
        Whether the connection should be verified on
        initial configuration or not.
        """
        return pulumi.get(self, "verify_connection")


@pulumi.output_type
class SecretsMountCouchbase(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedRoles":
            suggest = "allowed_roles"
        elif key == "base64Pem":
            suggest = "base64_pem"
        elif key == "bucketName":
            suggest = "bucket_name"
        elif key == "disableAutomatedRotation":
            suggest = "disable_automated_rotation"
        elif key == "insecureTls":
            suggest = "insecure_tls"
        elif key == "pluginName":
            suggest = "plugin_name"
        elif key == "rootRotationStatements":
            suggest = "root_rotation_statements"
        elif key == "rotationPeriod":
            suggest = "rotation_period"
        elif key == "rotationSchedule":
            suggest = "rotation_schedule"
        elif key == "rotationWindow":
            suggest = "rotation_window"
        elif key == "usernameTemplate":
            suggest = "username_template"
        elif key == "verifyConnection":
            suggest = "verify_connection"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecretsMountCouchbase. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecretsMountCouchbase.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecretsMountCouchbase.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 hosts: Sequence[_builtins.str],
                 name: _builtins.str,
                 password: _builtins.str,
                 username: _builtins.str,
                 allowed_roles: Optional[Sequence[_builtins.str]] = None,
                 base64_pem: Optional[_builtins.str] = None,
                 bucket_name: Optional[_builtins.str] = None,
                 data: Optional[Mapping[str, _builtins.str]] = None,
                 disable_automated_rotation: Optional[_builtins.bool] = None,
                 insecure_tls: Optional[_builtins.bool] = None,
                 plugin_name: Optional[_builtins.str] = None,
                 root_rotation_statements: Optional[Sequence[_builtins.str]] = None,
                 rotation_period: Optional[_builtins.int] = None,
                 rotation_schedule: Optional[_builtins.str] = None,
                 rotation_window: Optional[_builtins.int] = None,
                 tls: Optional[_builtins.bool] = None,
                 username_template: Optional[_builtins.str] = None,
                 verify_connection: Optional[_builtins.bool] = None):
        """
        :param Sequence[_builtins.str] hosts: A set of Couchbase URIs to connect to. Must use `couchbases://` scheme if `tls` is `true`.
        :param _builtins.str name: Name of the database connection.
        :param _builtins.str password: Specifies the password corresponding to the given username.
        :param _builtins.str username: Specifies the username for Vault to use.
        :param Sequence[_builtins.str] allowed_roles: A list of roles that are allowed to use this
               connection.
        :param _builtins.str base64_pem: Required if `tls` is `true`. Specifies the certificate authority of the Couchbase server, as a PEM certificate that has been base64 encoded.
        :param _builtins.str bucket_name: Required for Couchbase versions prior to 6.5.0. This is only used to verify vault's connection to the server.
        :param Mapping[str, _builtins.str] data: A map of sensitive data to pass to the endpoint. Useful for templated connection strings.
        :param _builtins.bool disable_automated_rotation: Cancels all upcoming rotations of the root credential until unset. Requires Vault Enterprise 1.19+.
               
               Supported list of database secrets engines that can be configured:
        :param _builtins.bool insecure_tls: Specifies whether to skip verification of the server certificate when using TLS.
        :param _builtins.str plugin_name: Specifies the name of the plugin to use.
        :param Sequence[_builtins.str] root_rotation_statements: A list of database statements to be executed to rotate the root user's credentials.
        :param _builtins.int rotation_period: The amount of time in seconds Vault should wait before rotating the root credential.
               A zero value tells Vault not to rotate the root credential. The minimum rotation period is 10 seconds. Requires Vault Enterprise 1.19+.
        :param _builtins.str rotation_schedule: The schedule, in [cron-style time format](https://en.wikipedia.org/wiki/Cron),
               defining the schedule on which Vault should rotate the root token. Requires Vault Enterprise 1.19+.
        :param _builtins.int rotation_window: The maximum amount of time in seconds allowed to complete
               a rotation when a scheduled token rotation occurs. The default rotation window is
               unbound and the minimum allowable window is `3600`. Requires Vault Enterprise 1.19+.
        :param _builtins.bool tls: Specifies whether to use TLS when connecting to Couchbase.
        :param _builtins.str username_template: Template describing how dynamic usernames are generated.
        :param _builtins.bool verify_connection: Whether the connection should be verified on
               initial configuration or not.
        """
        pulumi.set(__self__, "hosts", hosts)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "username", username)
        if allowed_roles is not None:
            pulumi.set(__self__, "allowed_roles", allowed_roles)
        if base64_pem is not None:
            pulumi.set(__self__, "base64_pem", base64_pem)
        if bucket_name is not None:
            pulumi.set(__self__, "bucket_name", bucket_name)
        if data is not None:
            pulumi.set(__self__, "data", data)
        if disable_automated_rotation is not None:
            pulumi.set(__self__, "disable_automated_rotation", disable_automated_rotation)
        if insecure_tls is not None:
            pulumi.set(__self__, "insecure_tls", insecure_tls)
        if plugin_name is not None:
            pulumi.set(__self__, "plugin_name", plugin_name)
        if root_rotation_statements is not None:
            pulumi.set(__self__, "root_rotation_statements", root_rotation_statements)
        if rotation_period is not None:
            pulumi.set(__self__, "rotation_period", rotation_period)
        if rotation_schedule is not None:
            pulumi.set(__self__, "rotation_schedule", rotation_schedule)
        if rotation_window is not None:
            pulumi.set(__self__, "rotation_window", rotation_window)
        if tls is not None:
            pulumi.set(__self__, "tls", tls)
        if username_template is not None:
            pulumi.set(__self__, "username_template", username_template)
        if verify_connection is not None:
            pulumi.set(__self__, "verify_connection", verify_connection)

    @_builtins.property
    @pulumi.getter
    def hosts(self) -> Sequence[_builtins.str]:
        """
        A set of Couchbase URIs to connect to. Must use `couchbases://` scheme if `tls` is `true`.
        """
        return pulumi.get(self, "hosts")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the database connection.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def password(self) -> _builtins.str:
        """
        Specifies the password corresponding to the given username.
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter
    def username(self) -> _builtins.str:
        """
        Specifies the username for Vault to use.
        """
        return pulumi.get(self, "username")

    @_builtins.property
    @pulumi.getter(name="allowedRoles")
    def allowed_roles(self) -> Optional[Sequence[_builtins.str]]:
        """
        A list of roles that are allowed to use this
        connection.
        """
        return pulumi.get(self, "allowed_roles")

    @_builtins.property
    @pulumi.getter(name="base64Pem")
    def base64_pem(self) -> Optional[_builtins.str]:
        """
        Required if `tls` is `true`. Specifies the certificate authority of the Couchbase server, as a PEM certificate that has been base64 encoded.
        """
        return pulumi.get(self, "base64_pem")

    @_builtins.property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> Optional[_builtins.str]:
        """
        Required for Couchbase versions prior to 6.5.0. This is only used to verify vault's connection to the server.
        """
        return pulumi.get(self, "bucket_name")

    @_builtins.property
    @pulumi.getter
    def data(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        A map of sensitive data to pass to the endpoint. Useful for templated connection strings.
        """
        return pulumi.get(self, "data")

    @_builtins.property
    @pulumi.getter(name="disableAutomatedRotation")
    def disable_automated_rotation(self) -> Optional[_builtins.bool]:
        """
        Cancels all upcoming rotations of the root credential until unset. Requires Vault Enterprise 1.19+.

        Supported list of database secrets engines that can be configured:
        """
        return pulumi.get(self, "disable_automated_rotation")

    @_builtins.property
    @pulumi.getter(name="insecureTls")
    def insecure_tls(self) -> Optional[_builtins.bool]:
        """
        Specifies whether to skip verification of the server certificate when using TLS.
        """
        return pulumi.get(self, "insecure_tls")

    @_builtins.property
    @pulumi.getter(name="pluginName")
    def plugin_name(self) -> Optional[_builtins.str]:
        """
        Specifies the name of the plugin to use.
        """
        return pulumi.get(self, "plugin_name")

    @_builtins.property
    @pulumi.getter(name="rootRotationStatements")
    def root_rotation_statements(self) -> Optional[Sequence[_builtins.str]]:
        """
        A list of database statements to be executed to rotate the root user's credentials.
        """
        return pulumi.get(self, "root_rotation_statements")

    @_builtins.property
    @pulumi.getter(name="rotationPeriod")
    def rotation_period(self) -> Optional[_builtins.int]:
        """
        The amount of time in seconds Vault should wait before rotating the root credential.
        A zero value tells Vault not to rotate the root credential. The minimum rotation period is 10 seconds. Requires Vault Enterprise 1.19+.
        """
        return pulumi.get(self, "rotation_period")

    @_builtins.property
    @pulumi.getter(name="rotationSchedule")
    def rotation_schedule(self) -> Optional[_builtins.str]:
        """
        The schedule, in [cron-style time format](https://en.wikipedia.org/wiki/Cron),
        defining the schedule on which Vault should rotate the root token. Requires Vault Enterprise 1.19+.
        """
        return pulumi.get(self, "rotation_schedule")

    @_builtins.property
    @pulumi.getter(name="rotationWindow")
    def rotation_window(self) -> Optional[_builtins.int]:
        """
        The maximum amount of time in seconds allowed to complete
        a rotation when a scheduled token rotation occurs. The default rotation window is
        unbound and the minimum allowable window is `3600`. Requires Vault Enterprise 1.19+.
        """
        return pulumi.get(self, "rotation_window")

    @_builtins.property
    @pulumi.getter
    def tls(self) -> Optional[_builtins.bool]:
        """
        Specifies whether to use TLS when connecting to Couchbase.
        """
        return pulumi.get(self, "tls")

    @_builtins.property
    @pulumi.getter(name="usernameTemplate")
    def username_template(self) -> Optional[_builtins.str]:
        """
        Template describing how dynamic usernames are generated.
        """
        return pulumi.get(self, "username_template")

    @_builtins.property
    @pulumi.getter(name="verifyConnection")
    def verify_connection(self) -> Optional[_builtins.bool]:
        """
        Whether the connection should be verified on
        initial configuration or not.
        """
        return pulumi.get(self, "verify_connection")


@pulumi.output_type
class SecretsMountElasticsearch(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedRoles":
            suggest = "allowed_roles"
        elif key == "caCert":
            suggest = "ca_cert"
        elif key == "caPath":
            suggest = "ca_path"
        elif key == "clientCert":
            suggest = "client_cert"
        elif key == "clientKey":
            suggest = "client_key"
        elif key == "disableAutomatedRotation":
            suggest = "disable_automated_rotation"
        elif key == "pluginName":
            suggest = "plugin_name"
        elif key == "rootRotationStatements":
            suggest = "root_rotation_statements"
        elif key == "rotationPeriod":
            suggest = "rotation_period"
        elif key == "rotationSchedule":
            suggest = "rotation_schedule"
        elif key == "rotationWindow":
            suggest = "rotation_window"
        elif key == "tlsServerName":
            suggest = "tls_server_name"
        elif key == "usernameTemplate":
            suggest = "username_template"
        elif key == "verifyConnection":
            suggest = "verify_connection"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecretsMountElasticsearch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecretsMountElasticsearch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecretsMountElasticsearch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 password: _builtins.str,
                 url: _builtins.str,
                 username: _builtins.str,
                 allowed_roles: Optional[Sequence[_builtins.str]] = None,
                 ca_cert: Optional[_builtins.str] = None,
                 ca_path: Optional[_builtins.str] = None,
                 client_cert: Optional[_builtins.str] = None,
                 client_key: Optional[_builtins.str] = None,
                 data: Optional[Mapping[str, _builtins.str]] = None,
                 disable_automated_rotation: Optional[_builtins.bool] = None,
                 insecure: Optional[_builtins.bool] = None,
                 plugin_name: Optional[_builtins.str] = None,
                 root_rotation_statements: Optional[Sequence[_builtins.str]] = None,
                 rotation_period: Optional[_builtins.int] = None,
                 rotation_schedule: Optional[_builtins.str] = None,
                 rotation_window: Optional[_builtins.int] = None,
                 tls_server_name: Optional[_builtins.str] = None,
                 username_template: Optional[_builtins.str] = None,
                 verify_connection: Optional[_builtins.bool] = None):
        """
        :param _builtins.str name: Name of the database connection.
        :param _builtins.str password: The password to be used in the connection URL
        :param _builtins.str url: The URL for Elasticsearch's API
        :param _builtins.str username: The username to be used in the connection URL
        :param Sequence[_builtins.str] allowed_roles: A list of roles that are allowed to use this
               connection.
        :param _builtins.str ca_cert: The path to a PEM-encoded CA cert file to use to verify the Elasticsearch server's identity
        :param _builtins.str ca_path: The path to a directory of PEM-encoded CA cert files to use to verify the Elasticsearch server's identity
        :param _builtins.str client_cert: The path to the certificate for the Elasticsearch client to present for communication
        :param _builtins.str client_key: The path to the key for the Elasticsearch client to use for communication
        :param Mapping[str, _builtins.str] data: A map of sensitive data to pass to the endpoint. Useful for templated connection strings.
        :param _builtins.bool disable_automated_rotation: Cancels all upcoming rotations of the root credential until unset. Requires Vault Enterprise 1.19+.
               
               Supported list of database secrets engines that can be configured:
        :param _builtins.bool insecure: Whether to disable certificate verification
        :param _builtins.str plugin_name: Specifies the name of the plugin to use.
        :param Sequence[_builtins.str] root_rotation_statements: A list of database statements to be executed to rotate the root user's credentials.
        :param _builtins.int rotation_period: The amount of time in seconds Vault should wait before rotating the root credential.
               A zero value tells Vault not to rotate the root credential. The minimum rotation period is 10 seconds. Requires Vault Enterprise 1.19+.
        :param _builtins.str rotation_schedule: The schedule, in [cron-style time format](https://en.wikipedia.org/wiki/Cron),
               defining the schedule on which Vault should rotate the root token. Requires Vault Enterprise 1.19+.
        :param _builtins.int rotation_window: The maximum amount of time in seconds allowed to complete
               a rotation when a scheduled token rotation occurs. The default rotation window is
               unbound and the minimum allowable window is `3600`. Requires Vault Enterprise 1.19+.
        :param _builtins.str tls_server_name: This, if set, is used to set the SNI host when connecting via TLS
        :param _builtins.str username_template: Template describing how dynamic usernames are generated.
        :param _builtins.bool verify_connection: Whether the connection should be verified on
               initial configuration or not.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "url", url)
        pulumi.set(__self__, "username", username)
        if allowed_roles is not None:
            pulumi.set(__self__, "allowed_roles", allowed_roles)
        if ca_cert is not None:
            pulumi.set(__self__, "ca_cert", ca_cert)
        if ca_path is not None:
            pulumi.set(__self__, "ca_path", ca_path)
        if client_cert is not None:
            pulumi.set(__self__, "client_cert", client_cert)
        if client_key is not None:
            pulumi.set(__self__, "client_key", client_key)
        if data is not None:
            pulumi.set(__self__, "data", data)
        if disable_automated_rotation is not None:
            pulumi.set(__self__, "disable_automated_rotation", disable_automated_rotation)
        if insecure is not None:
            pulumi.set(__self__, "insecure", insecure)
        if plugin_name is not None:
            pulumi.set(__self__, "plugin_name", plugin_name)
        if root_rotation_statements is not None:
            pulumi.set(__self__, "root_rotation_statements", root_rotation_statements)
        if rotation_period is not None:
            pulumi.set(__self__, "rotation_period", rotation_period)
        if rotation_schedule is not None:
            pulumi.set(__self__, "rotation_schedule", rotation_schedule)
        if rotation_window is not None:
            pulumi.set(__self__, "rotation_window", rotation_window)
        if tls_server_name is not None:
            pulumi.set(__self__, "tls_server_name", tls_server_name)
        if username_template is not None:
            pulumi.set(__self__, "username_template", username_template)
        if verify_connection is not None:
            pulumi.set(__self__, "verify_connection", verify_connection)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the database connection.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def password(self) -> _builtins.str:
        """
        The password to be used in the connection URL
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter
    def url(self) -> _builtins.str:
        """
        The URL for Elasticsearch's API
        """
        return pulumi.get(self, "url")

    @_builtins.property
    @pulumi.getter
    def username(self) -> _builtins.str:
        """
        The username to be used in the connection URL
        """
        return pulumi.get(self, "username")

    @_builtins.property
    @pulumi.getter(name="allowedRoles")
    def allowed_roles(self) -> Optional[Sequence[_builtins.str]]:
        """
        A list of roles that are allowed to use this
        connection.
        """
        return pulumi.get(self, "allowed_roles")

    @_builtins.property
    @pulumi.getter(name="caCert")
    def ca_cert(self) -> Optional[_builtins.str]:
        """
        The path to a PEM-encoded CA cert file to use to verify the Elasticsearch server's identity
        """
        return pulumi.get(self, "ca_cert")

    @_builtins.property
    @pulumi.getter(name="caPath")
    def ca_path(self) -> Optional[_builtins.str]:
        """
        The path to a directory of PEM-encoded CA cert files to use to verify the Elasticsearch server's identity
        """
        return pulumi.get(self, "ca_path")

    @_builtins.property
    @pulumi.getter(name="clientCert")
    def client_cert(self) -> Optional[_builtins.str]:
        """
        The path to the certificate for the Elasticsearch client to present for communication
        """
        return pulumi.get(self, "client_cert")

    @_builtins.property
    @pulumi.getter(name="clientKey")
    def client_key(self) -> Optional[_builtins.str]:
        """
        The path to the key for the Elasticsearch client to use for communication
        """
        return pulumi.get(self, "client_key")

    @_builtins.property
    @pulumi.getter
    def data(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        A map of sensitive data to pass to the endpoint. Useful for templated connection strings.
        """
        return pulumi.get(self, "data")

    @_builtins.property
    @pulumi.getter(name="disableAutomatedRotation")
    def disable_automated_rotation(self) -> Optional[_builtins.bool]:
        """
        Cancels all upcoming rotations of the root credential until unset. Requires Vault Enterprise 1.19+.

        Supported list of database secrets engines that can be configured:
        """
        return pulumi.get(self, "disable_automated_rotation")

    @_builtins.property
    @pulumi.getter
    def insecure(self) -> Optional[_builtins.bool]:
        """
        Whether to disable certificate verification
        """
        return pulumi.get(self, "insecure")

    @_builtins.property
    @pulumi.getter(name="pluginName")
    def plugin_name(self) -> Optional[_builtins.str]:
        """
        Specifies the name of the plugin to use.
        """
        return pulumi.get(self, "plugin_name")

    @_builtins.property
    @pulumi.getter(name="rootRotationStatements")
    def root_rotation_statements(self) -> Optional[Sequence[_builtins.str]]:
        """
        A list of database statements to be executed to rotate the root user's credentials.
        """
        return pulumi.get(self, "root_rotation_statements")

    @_builtins.property
    @pulumi.getter(name="rotationPeriod")
    def rotation_period(self) -> Optional[_builtins.int]:
        """
        The amount of time in seconds Vault should wait before rotating the root credential.
        A zero value tells Vault not to rotate the root credential. The minimum rotation period is 10 seconds. Requires Vault Enterprise 1.19+.
        """
        return pulumi.get(self, "rotation_period")

    @_builtins.property
    @pulumi.getter(name="rotationSchedule")
    def rotation_schedule(self) -> Optional[_builtins.str]:
        """
        The schedule, in [cron-style time format](https://en.wikipedia.org/wiki/Cron),
        defining the schedule on which Vault should rotate the root token. Requires Vault Enterprise 1.19+.
        """
        return pulumi.get(self, "rotation_schedule")

    @_builtins.property
    @pulumi.getter(name="rotationWindow")
    def rotation_window(self) -> Optional[_builtins.int]:
        """
        The maximum amount of time in seconds allowed to complete
        a rotation when a scheduled token rotation occurs. The default rotation window is
        unbound and the minimum allowable window is `3600`. Requires Vault Enterprise 1.19+.
        """
        return pulumi.get(self, "rotation_window")

    @_builtins.property
    @pulumi.getter(name="tlsServerName")
    def tls_server_name(self) -> Optional[_builtins.str]:
        """
        This, if set, is used to set the SNI host when connecting via TLS
        """
        return pulumi.get(self, "tls_server_name")

    @_builtins.property
    @pulumi.getter(name="usernameTemplate")
    def username_template(self) -> Optional[_builtins.str]:
        """
        Template describing how dynamic usernames are generated.
        """
        return pulumi.get(self, "username_template")

    @_builtins.property
    @pulumi.getter(name="verifyConnection")
    def verify_connection(self) -> Optional[_builtins.bool]:
        """
        Whether the connection should be verified on
        initial configuration or not.
        """
        return pulumi.get(self, "verify_connection")


@pulumi.output_type
class SecretsMountHana(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedRoles":
            suggest = "allowed_roles"
        elif key == "connectionUrl":
            suggest = "connection_url"
        elif key == "disableAutomatedRotation":
            suggest = "disable_automated_rotation"
        elif key == "disableEscaping":
            suggest = "disable_escaping"
        elif key == "maxConnectionLifetime":
            suggest = "max_connection_lifetime"
        elif key == "maxIdleConnections":
            suggest = "max_idle_connections"
        elif key == "maxOpenConnections":
            suggest = "max_open_connections"
        elif key == "passwordWo":
            suggest = "password_wo"
        elif key == "passwordWoVersion":
            suggest = "password_wo_version"
        elif key == "pluginName":
            suggest = "plugin_name"
        elif key == "rootRotationStatements":
            suggest = "root_rotation_statements"
        elif key == "rotationPeriod":
            suggest = "rotation_period"
        elif key == "rotationSchedule":
            suggest = "rotation_schedule"
        elif key == "rotationWindow":
            suggest = "rotation_window"
        elif key == "verifyConnection":
            suggest = "verify_connection"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecretsMountHana. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecretsMountHana.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecretsMountHana.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 allowed_roles: Optional[Sequence[_builtins.str]] = None,
                 connection_url: Optional[_builtins.str] = None,
                 data: Optional[Mapping[str, _builtins.str]] = None,
                 disable_automated_rotation: Optional[_builtins.bool] = None,
                 disable_escaping: Optional[_builtins.bool] = None,
                 max_connection_lifetime: Optional[_builtins.int] = None,
                 max_idle_connections: Optional[_builtins.int] = None,
                 max_open_connections: Optional[_builtins.int] = None,
                 password: Optional[_builtins.str] = None,
                 password_wo: Optional[_builtins.str] = None,
                 password_wo_version: Optional[_builtins.int] = None,
                 plugin_name: Optional[_builtins.str] = None,
                 root_rotation_statements: Optional[Sequence[_builtins.str]] = None,
                 rotation_period: Optional[_builtins.int] = None,
                 rotation_schedule: Optional[_builtins.str] = None,
                 rotation_window: Optional[_builtins.int] = None,
                 username: Optional[_builtins.str] = None,
                 verify_connection: Optional[_builtins.bool] = None):
        """
        :param _builtins.str name: Name of the database connection.
        :param Sequence[_builtins.str] allowed_roles: A list of roles that are allowed to use this
               connection.
        :param _builtins.str connection_url: Connection string to use to connect to the database.
        :param Mapping[str, _builtins.str] data: A map of sensitive data to pass to the endpoint. Useful for templated connection strings.
        :param _builtins.bool disable_automated_rotation: Cancels all upcoming rotations of the root credential until unset. Requires Vault Enterprise 1.19+.
               
               Supported list of database secrets engines that can be configured:
        :param _builtins.bool disable_escaping: Disable special character escaping in username and password
        :param _builtins.int max_connection_lifetime: Maximum number of seconds a connection may be reused.
        :param _builtins.int max_idle_connections: Maximum number of idle connections to the database.
        :param _builtins.int max_open_connections: Maximum number of open connections to the database.
        :param _builtins.str password: The root credential password used in the connection URL
        :param _builtins.str password_wo: **NOTE:** This field is write-only and its value will not be updated in state as part of read operations.
               Write-only field for the root credential password used in the connection URL
        :param _builtins.int password_wo_version: Version counter for root credential password write-only field
        :param _builtins.str plugin_name: Specifies the name of the plugin to use.
        :param Sequence[_builtins.str] root_rotation_statements: A list of database statements to be executed to rotate the root user's credentials.
        :param _builtins.int rotation_period: The amount of time in seconds Vault should wait before rotating the root credential.
               A zero value tells Vault not to rotate the root credential. The minimum rotation period is 10 seconds. Requires Vault Enterprise 1.19+.
        :param _builtins.str rotation_schedule: The schedule, in [cron-style time format](https://en.wikipedia.org/wiki/Cron),
               defining the schedule on which Vault should rotate the root token. Requires Vault Enterprise 1.19+.
        :param _builtins.int rotation_window: The maximum amount of time in seconds allowed to complete
               a rotation when a scheduled token rotation occurs. The default rotation window is
               unbound and the minimum allowable window is `3600`. Requires Vault Enterprise 1.19+.
        :param _builtins.str username: The root credential username used in the connection URL
        :param _builtins.bool verify_connection: Whether the connection should be verified on
               initial configuration or not.
        """
        pulumi.set(__self__, "name", name)
        if allowed_roles is not None:
            pulumi.set(__self__, "allowed_roles", allowed_roles)
        if connection_url is not None:
            pulumi.set(__self__, "connection_url", connection_url)
        if data is not None:
            pulumi.set(__self__, "data", data)
        if disable_automated_rotation is not None:
            pulumi.set(__self__, "disable_automated_rotation", disable_automated_rotation)
        if disable_escaping is not None:
            pulumi.set(__self__, "disable_escaping", disable_escaping)
        if max_connection_lifetime is not None:
            pulumi.set(__self__, "max_connection_lifetime", max_connection_lifetime)
        if max_idle_connections is not None:
            pulumi.set(__self__, "max_idle_connections", max_idle_connections)
        if max_open_connections is not None:
            pulumi.set(__self__, "max_open_connections", max_open_connections)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if password_wo is not None:
            pulumi.set(__self__, "password_wo", password_wo)
        if password_wo_version is not None:
            pulumi.set(__self__, "password_wo_version", password_wo_version)
        if plugin_name is not None:
            pulumi.set(__self__, "plugin_name", plugin_name)
        if root_rotation_statements is not None:
            pulumi.set(__self__, "root_rotation_statements", root_rotation_statements)
        if rotation_period is not None:
            pulumi.set(__self__, "rotation_period", rotation_period)
        if rotation_schedule is not None:
            pulumi.set(__self__, "rotation_schedule", rotation_schedule)
        if rotation_window is not None:
            pulumi.set(__self__, "rotation_window", rotation_window)
        if username is not None:
            pulumi.set(__self__, "username", username)
        if verify_connection is not None:
            pulumi.set(__self__, "verify_connection", verify_connection)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the database connection.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="allowedRoles")
    def allowed_roles(self) -> Optional[Sequence[_builtins.str]]:
        """
        A list of roles that are allowed to use this
        connection.
        """
        return pulumi.get(self, "allowed_roles")

    @_builtins.property
    @pulumi.getter(name="connectionUrl")
    def connection_url(self) -> Optional[_builtins.str]:
        """
        Connection string to use to connect to the database.
        """
        return pulumi.get(self, "connection_url")

    @_builtins.property
    @pulumi.getter
    def data(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        A map of sensitive data to pass to the endpoint. Useful for templated connection strings.
        """
        return pulumi.get(self, "data")

    @_builtins.property
    @pulumi.getter(name="disableAutomatedRotation")
    def disable_automated_rotation(self) -> Optional[_builtins.bool]:
        """
        Cancels all upcoming rotations of the root credential until unset. Requires Vault Enterprise 1.19+.

        Supported list of database secrets engines that can be configured:
        """
        return pulumi.get(self, "disable_automated_rotation")

    @_builtins.property
    @pulumi.getter(name="disableEscaping")
    def disable_escaping(self) -> Optional[_builtins.bool]:
        """
        Disable special character escaping in username and password
        """
        return pulumi.get(self, "disable_escaping")

    @_builtins.property
    @pulumi.getter(name="maxConnectionLifetime")
    def max_connection_lifetime(self) -> Optional[_builtins.int]:
        """
        Maximum number of seconds a connection may be reused.
        """
        return pulumi.get(self, "max_connection_lifetime")

    @_builtins.property
    @pulumi.getter(name="maxIdleConnections")
    def max_idle_connections(self) -> Optional[_builtins.int]:
        """
        Maximum number of idle connections to the database.
        """
        return pulumi.get(self, "max_idle_connections")

    @_builtins.property
    @pulumi.getter(name="maxOpenConnections")
    def max_open_connections(self) -> Optional[_builtins.int]:
        """
        Maximum number of open connections to the database.
        """
        return pulumi.get(self, "max_open_connections")

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[_builtins.str]:
        """
        The root credential password used in the connection URL
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter(name="passwordWo")
    def password_wo(self) -> Optional[_builtins.str]:
        """
        **NOTE:** This field is write-only and its value will not be updated in state as part of read operations.
        Write-only field for the root credential password used in the connection URL
        """
        return pulumi.get(self, "password_wo")

    @_builtins.property
    @pulumi.getter(name="passwordWoVersion")
    def password_wo_version(self) -> Optional[_builtins.int]:
        """
        Version counter for root credential password write-only field
        """
        return pulumi.get(self, "password_wo_version")

    @_builtins.property
    @pulumi.getter(name="pluginName")
    def plugin_name(self) -> Optional[_builtins.str]:
        """
        Specifies the name of the plugin to use.
        """
        return pulumi.get(self, "plugin_name")

    @_builtins.property
    @pulumi.getter(name="rootRotationStatements")
    def root_rotation_statements(self) -> Optional[Sequence[_builtins.str]]:
        """
        A list of database statements to be executed to rotate the root user's credentials.
        """
        return pulumi.get(self, "root_rotation_statements")

    @_builtins.property
    @pulumi.getter(name="rotationPeriod")
    def rotation_period(self) -> Optional[_builtins.int]:
        """
        The amount of time in seconds Vault should wait before rotating the root credential.
        A zero value tells Vault not to rotate the root credential. The minimum rotation period is 10 seconds. Requires Vault Enterprise 1.19+.
        """
        return pulumi.get(self, "rotation_period")

    @_builtins.property
    @pulumi.getter(name="rotationSchedule")
    def rotation_schedule(self) -> Optional[_builtins.str]:
        """
        The schedule, in [cron-style time format](https://en.wikipedia.org/wiki/Cron),
        defining the schedule on which Vault should rotate the root token. Requires Vault Enterprise 1.19+.
        """
        return pulumi.get(self, "rotation_schedule")

    @_builtins.property
    @pulumi.getter(name="rotationWindow")
    def rotation_window(self) -> Optional[_builtins.int]:
        """
        The maximum amount of time in seconds allowed to complete
        a rotation when a scheduled token rotation occurs. The default rotation window is
        unbound and the minimum allowable window is `3600`. Requires Vault Enterprise 1.19+.
        """
        return pulumi.get(self, "rotation_window")

    @_builtins.property
    @pulumi.getter
    def username(self) -> Optional[_builtins.str]:
        """
        The root credential username used in the connection URL
        """
        return pulumi.get(self, "username")

    @_builtins.property
    @pulumi.getter(name="verifyConnection")
    def verify_connection(self) -> Optional[_builtins.bool]:
        """
        Whether the connection should be verified on
        initial configuration or not.
        """
        return pulumi.get(self, "verify_connection")


@pulumi.output_type
class SecretsMountInfluxdb(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedRoles":
            suggest = "allowed_roles"
        elif key == "connectTimeout":
            suggest = "connect_timeout"
        elif key == "disableAutomatedRotation":
            suggest = "disable_automated_rotation"
        elif key == "insecureTls":
            suggest = "insecure_tls"
        elif key == "pemBundle":
            suggest = "pem_bundle"
        elif key == "pemJson":
            suggest = "pem_json"
        elif key == "pluginName":
            suggest = "plugin_name"
        elif key == "rootRotationStatements":
            suggest = "root_rotation_statements"
        elif key == "rotationPeriod":
            suggest = "rotation_period"
        elif key == "rotationSchedule":
            suggest = "rotation_schedule"
        elif key == "rotationWindow":
            suggest = "rotation_window"
        elif key == "usernameTemplate":
            suggest = "username_template"
        elif key == "verifyConnection":
            suggest = "verify_connection"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecretsMountInfluxdb. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecretsMountInfluxdb.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecretsMountInfluxdb.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 host: _builtins.str,
                 name: _builtins.str,
                 password: _builtins.str,
                 username: _builtins.str,
                 allowed_roles: Optional[Sequence[_builtins.str]] = None,
                 connect_timeout: Optional[_builtins.int] = None,
                 data: Optional[Mapping[str, _builtins.str]] = None,
                 disable_automated_rotation: Optional[_builtins.bool] = None,
                 insecure_tls: Optional[_builtins.bool] = None,
                 pem_bundle: Optional[_builtins.str] = None,
                 pem_json: Optional[_builtins.str] = None,
                 plugin_name: Optional[_builtins.str] = None,
                 port: Optional[_builtins.int] = None,
                 root_rotation_statements: Optional[Sequence[_builtins.str]] = None,
                 rotation_period: Optional[_builtins.int] = None,
                 rotation_schedule: Optional[_builtins.str] = None,
                 rotation_window: Optional[_builtins.int] = None,
                 tls: Optional[_builtins.bool] = None,
                 username_template: Optional[_builtins.str] = None,
                 verify_connection: Optional[_builtins.bool] = None):
        """
        :param _builtins.str host: Influxdb host to connect to.
        :param _builtins.str name: Name of the database connection.
        :param _builtins.str password: Specifies the password corresponding to the given username.
        :param _builtins.str username: Specifies the username to use for superuser access.
        :param Sequence[_builtins.str] allowed_roles: A list of roles that are allowed to use this
               connection.
        :param _builtins.int connect_timeout: The number of seconds to use as a connection timeout.
        :param Mapping[str, _builtins.str] data: A map of sensitive data to pass to the endpoint. Useful for templated connection strings.
        :param _builtins.bool disable_automated_rotation: Cancels all upcoming rotations of the root credential until unset. Requires Vault Enterprise 1.19+.
               
               Supported list of database secrets engines that can be configured:
        :param _builtins.bool insecure_tls: Whether to skip verification of the server certificate when using TLS.
        :param _builtins.str pem_bundle: Concatenated PEM blocks containing a certificate and private key; a certificate, private key, and issuing CA certificate; or just a CA certificate.
        :param _builtins.str pem_json: Specifies JSON containing a certificate and private key; a certificate, private key, and issuing CA certificate; or just a CA certificate.
        :param _builtins.str plugin_name: Specifies the name of the plugin to use.
        :param _builtins.int port: The transport port to use to connect to Influxdb.
        :param Sequence[_builtins.str] root_rotation_statements: A list of database statements to be executed to rotate the root user's credentials.
        :param _builtins.int rotation_period: The amount of time in seconds Vault should wait before rotating the root credential.
               A zero value tells Vault not to rotate the root credential. The minimum rotation period is 10 seconds. Requires Vault Enterprise 1.19+.
        :param _builtins.str rotation_schedule: The schedule, in [cron-style time format](https://en.wikipedia.org/wiki/Cron),
               defining the schedule on which Vault should rotate the root token. Requires Vault Enterprise 1.19+.
        :param _builtins.int rotation_window: The maximum amount of time in seconds allowed to complete
               a rotation when a scheduled token rotation occurs. The default rotation window is
               unbound and the minimum allowable window is `3600`. Requires Vault Enterprise 1.19+.
        :param _builtins.bool tls: Whether to use TLS when connecting to Influxdb.
        :param _builtins.str username_template: Template describing how dynamic usernames are generated.
        :param _builtins.bool verify_connection: Whether the connection should be verified on
               initial configuration or not.
        """
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "username", username)
        if allowed_roles is not None:
            pulumi.set(__self__, "allowed_roles", allowed_roles)
        if connect_timeout is not None:
            pulumi.set(__self__, "connect_timeout", connect_timeout)
        if data is not None:
            pulumi.set(__self__, "data", data)
        if disable_automated_rotation is not None:
            pulumi.set(__self__, "disable_automated_rotation", disable_automated_rotation)
        if insecure_tls is not None:
            pulumi.set(__self__, "insecure_tls", insecure_tls)
        if pem_bundle is not None:
            pulumi.set(__self__, "pem_bundle", pem_bundle)
        if pem_json is not None:
            pulumi.set(__self__, "pem_json", pem_json)
        if plugin_name is not None:
            pulumi.set(__self__, "plugin_name", plugin_name)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if root_rotation_statements is not None:
            pulumi.set(__self__, "root_rotation_statements", root_rotation_statements)
        if rotation_period is not None:
            pulumi.set(__self__, "rotation_period", rotation_period)
        if rotation_schedule is not None:
            pulumi.set(__self__, "rotation_schedule", rotation_schedule)
        if rotation_window is not None:
            pulumi.set(__self__, "rotation_window", rotation_window)
        if tls is not None:
            pulumi.set(__self__, "tls", tls)
        if username_template is not None:
            pulumi.set(__self__, "username_template", username_template)
        if verify_connection is not None:
            pulumi.set(__self__, "verify_connection", verify_connection)

    @_builtins.property
    @pulumi.getter
    def host(self) -> _builtins.str:
        """
        Influxdb host to connect to.
        """
        return pulumi.get(self, "host")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the database connection.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def password(self) -> _builtins.str:
        """
        Specifies the password corresponding to the given username.
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter
    def username(self) -> _builtins.str:
        """
        Specifies the username to use for superuser access.
        """
        return pulumi.get(self, "username")

    @_builtins.property
    @pulumi.getter(name="allowedRoles")
    def allowed_roles(self) -> Optional[Sequence[_builtins.str]]:
        """
        A list of roles that are allowed to use this
        connection.
        """
        return pulumi.get(self, "allowed_roles")

    @_builtins.property
    @pulumi.getter(name="connectTimeout")
    def connect_timeout(self) -> Optional[_builtins.int]:
        """
        The number of seconds to use as a connection timeout.
        """
        return pulumi.get(self, "connect_timeout")

    @_builtins.property
    @pulumi.getter
    def data(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        A map of sensitive data to pass to the endpoint. Useful for templated connection strings.
        """
        return pulumi.get(self, "data")

    @_builtins.property
    @pulumi.getter(name="disableAutomatedRotation")
    def disable_automated_rotation(self) -> Optional[_builtins.bool]:
        """
        Cancels all upcoming rotations of the root credential until unset. Requires Vault Enterprise 1.19+.

        Supported list of database secrets engines that can be configured:
        """
        return pulumi.get(self, "disable_automated_rotation")

    @_builtins.property
    @pulumi.getter(name="insecureTls")
    def insecure_tls(self) -> Optional[_builtins.bool]:
        """
        Whether to skip verification of the server certificate when using TLS.
        """
        return pulumi.get(self, "insecure_tls")

    @_builtins.property
    @pulumi.getter(name="pemBundle")
    def pem_bundle(self) -> Optional[_builtins.str]:
        """
        Concatenated PEM blocks containing a certificate and private key; a certificate, private key, and issuing CA certificate; or just a CA certificate.
        """
        return pulumi.get(self, "pem_bundle")

    @_builtins.property
    @pulumi.getter(name="pemJson")
    def pem_json(self) -> Optional[_builtins.str]:
        """
        Specifies JSON containing a certificate and private key; a certificate, private key, and issuing CA certificate; or just a CA certificate.
        """
        return pulumi.get(self, "pem_json")

    @_builtins.property
    @pulumi.getter(name="pluginName")
    def plugin_name(self) -> Optional[_builtins.str]:
        """
        Specifies the name of the plugin to use.
        """
        return pulumi.get(self, "plugin_name")

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[_builtins.int]:
        """
        The transport port to use to connect to Influxdb.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="rootRotationStatements")
    def root_rotation_statements(self) -> Optional[Sequence[_builtins.str]]:
        """
        A list of database statements to be executed to rotate the root user's credentials.
        """
        return pulumi.get(self, "root_rotation_statements")

    @_builtins.property
    @pulumi.getter(name="rotationPeriod")
    def rotation_period(self) -> Optional[_builtins.int]:
        """
        The amount of time in seconds Vault should wait before rotating the root credential.
        A zero value tells Vault not to rotate the root credential. The minimum rotation period is 10 seconds. Requires Vault Enterprise 1.19+.
        """
        return pulumi.get(self, "rotation_period")

    @_builtins.property
    @pulumi.getter(name="rotationSchedule")
    def rotation_schedule(self) -> Optional[_builtins.str]:
        """
        The schedule, in [cron-style time format](https://en.wikipedia.org/wiki/Cron),
        defining the schedule on which Vault should rotate the root token. Requires Vault Enterprise 1.19+.
        """
        return pulumi.get(self, "rotation_schedule")

    @_builtins.property
    @pulumi.getter(name="rotationWindow")
    def rotation_window(self) -> Optional[_builtins.int]:
        """
        The maximum amount of time in seconds allowed to complete
        a rotation when a scheduled token rotation occurs. The default rotation window is
        unbound and the minimum allowable window is `3600`. Requires Vault Enterprise 1.19+.
        """
        return pulumi.get(self, "rotation_window")

    @_builtins.property
    @pulumi.getter
    def tls(self) -> Optional[_builtins.bool]:
        """
        Whether to use TLS when connecting to Influxdb.
        """
        return pulumi.get(self, "tls")

    @_builtins.property
    @pulumi.getter(name="usernameTemplate")
    def username_template(self) -> Optional[_builtins.str]:
        """
        Template describing how dynamic usernames are generated.
        """
        return pulumi.get(self, "username_template")

    @_builtins.property
    @pulumi.getter(name="verifyConnection")
    def verify_connection(self) -> Optional[_builtins.bool]:
        """
        Whether the connection should be verified on
        initial configuration or not.
        """
        return pulumi.get(self, "verify_connection")


@pulumi.output_type
class SecretsMountMongodb(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedRoles":
            suggest = "allowed_roles"
        elif key == "connectionUrl":
            suggest = "connection_url"
        elif key == "disableAutomatedRotation":
            suggest = "disable_automated_rotation"
        elif key == "maxConnectionLifetime":
            suggest = "max_connection_lifetime"
        elif key == "maxIdleConnections":
            suggest = "max_idle_connections"
        elif key == "maxOpenConnections":
            suggest = "max_open_connections"
        elif key == "passwordWo":
            suggest = "password_wo"
        elif key == "passwordWoVersion":
            suggest = "password_wo_version"
        elif key == "pluginName":
            suggest = "plugin_name"
        elif key == "rootRotationStatements":
            suggest = "root_rotation_statements"
        elif key == "rotationPeriod":
            suggest = "rotation_period"
        elif key == "rotationSchedule":
            suggest = "rotation_schedule"
        elif key == "rotationWindow":
            suggest = "rotation_window"
        elif key == "usernameTemplate":
            suggest = "username_template"
        elif key == "verifyConnection":
            suggest = "verify_connection"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecretsMountMongodb. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecretsMountMongodb.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecretsMountMongodb.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 allowed_roles: Optional[Sequence[_builtins.str]] = None,
                 connection_url: Optional[_builtins.str] = None,
                 data: Optional[Mapping[str, _builtins.str]] = None,
                 disable_automated_rotation: Optional[_builtins.bool] = None,
                 max_connection_lifetime: Optional[_builtins.int] = None,
                 max_idle_connections: Optional[_builtins.int] = None,
                 max_open_connections: Optional[_builtins.int] = None,
                 password: Optional[_builtins.str] = None,
                 password_wo: Optional[_builtins.str] = None,
                 password_wo_version: Optional[_builtins.int] = None,
                 plugin_name: Optional[_builtins.str] = None,
                 root_rotation_statements: Optional[Sequence[_builtins.str]] = None,
                 rotation_period: Optional[_builtins.int] = None,
                 rotation_schedule: Optional[_builtins.str] = None,
                 rotation_window: Optional[_builtins.int] = None,
                 username: Optional[_builtins.str] = None,
                 username_template: Optional[_builtins.str] = None,
                 verify_connection: Optional[_builtins.bool] = None):
        """
        :param _builtins.str name: Name of the database connection.
        :param Sequence[_builtins.str] allowed_roles: A list of roles that are allowed to use this
               connection.
        :param _builtins.str connection_url: Connection string to use to connect to the database.
        :param Mapping[str, _builtins.str] data: A map of sensitive data to pass to the endpoint. Useful for templated connection strings.
        :param _builtins.bool disable_automated_rotation: Cancels all upcoming rotations of the root credential until unset. Requires Vault Enterprise 1.19+.
               
               Supported list of database secrets engines that can be configured:
        :param _builtins.int max_connection_lifetime: Maximum number of seconds a connection may be reused.
        :param _builtins.int max_idle_connections: Maximum number of idle connections to the database.
        :param _builtins.int max_open_connections: Maximum number of open connections to the database.
        :param _builtins.str password: The root credential password used in the connection URL
        :param _builtins.str password_wo: **NOTE:** This field is write-only and its value will not be updated in state as part of read operations.
               Write-only field for the root credential password used in the connection URL
        :param _builtins.int password_wo_version: Version counter for root credential password write-only field
        :param _builtins.str plugin_name: Specifies the name of the plugin to use.
        :param Sequence[_builtins.str] root_rotation_statements: A list of database statements to be executed to rotate the root user's credentials.
        :param _builtins.int rotation_period: The amount of time in seconds Vault should wait before rotating the root credential.
               A zero value tells Vault not to rotate the root credential. The minimum rotation period is 10 seconds. Requires Vault Enterprise 1.19+.
        :param _builtins.str rotation_schedule: The schedule, in [cron-style time format](https://en.wikipedia.org/wiki/Cron),
               defining the schedule on which Vault should rotate the root token. Requires Vault Enterprise 1.19+.
        :param _builtins.int rotation_window: The maximum amount of time in seconds allowed to complete
               a rotation when a scheduled token rotation occurs. The default rotation window is
               unbound and the minimum allowable window is `3600`. Requires Vault Enterprise 1.19+.
        :param _builtins.str username: The root credential username used in the connection URL
        :param _builtins.str username_template: Username generation template.
        :param _builtins.bool verify_connection: Whether the connection should be verified on
               initial configuration or not.
        """
        pulumi.set(__self__, "name", name)
        if allowed_roles is not None:
            pulumi.set(__self__, "allowed_roles", allowed_roles)
        if connection_url is not None:
            pulumi.set(__self__, "connection_url", connection_url)
        if data is not None:
            pulumi.set(__self__, "data", data)
        if disable_automated_rotation is not None:
            pulumi.set(__self__, "disable_automated_rotation", disable_automated_rotation)
        if max_connection_lifetime is not None:
            pulumi.set(__self__, "max_connection_lifetime", max_connection_lifetime)
        if max_idle_connections is not None:
            pulumi.set(__self__, "max_idle_connections", max_idle_connections)
        if max_open_connections is not None:
            pulumi.set(__self__, "max_open_connections", max_open_connections)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if password_wo is not None:
            pulumi.set(__self__, "password_wo", password_wo)
        if password_wo_version is not None:
            pulumi.set(__self__, "password_wo_version", password_wo_version)
        if plugin_name is not None:
            pulumi.set(__self__, "plugin_name", plugin_name)
        if root_rotation_statements is not None:
            pulumi.set(__self__, "root_rotation_statements", root_rotation_statements)
        if rotation_period is not None:
            pulumi.set(__self__, "rotation_period", rotation_period)
        if rotation_schedule is not None:
            pulumi.set(__self__, "rotation_schedule", rotation_schedule)
        if rotation_window is not None:
            pulumi.set(__self__, "rotation_window", rotation_window)
        if username is not None:
            pulumi.set(__self__, "username", username)
        if username_template is not None:
            pulumi.set(__self__, "username_template", username_template)
        if verify_connection is not None:
            pulumi.set(__self__, "verify_connection", verify_connection)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the database connection.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="allowedRoles")
    def allowed_roles(self) -> Optional[Sequence[_builtins.str]]:
        """
        A list of roles that are allowed to use this
        connection.
        """
        return pulumi.get(self, "allowed_roles")

    @_builtins.property
    @pulumi.getter(name="connectionUrl")
    def connection_url(self) -> Optional[_builtins.str]:
        """
        Connection string to use to connect to the database.
        """
        return pulumi.get(self, "connection_url")

    @_builtins.property
    @pulumi.getter
    def data(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        A map of sensitive data to pass to the endpoint. Useful for templated connection strings.
        """
        return pulumi.get(self, "data")

    @_builtins.property
    @pulumi.getter(name="disableAutomatedRotation")
    def disable_automated_rotation(self) -> Optional[_builtins.bool]:
        """
        Cancels all upcoming rotations of the root credential until unset. Requires Vault Enterprise 1.19+.

        Supported list of database secrets engines that can be configured:
        """
        return pulumi.get(self, "disable_automated_rotation")

    @_builtins.property
    @pulumi.getter(name="maxConnectionLifetime")
    def max_connection_lifetime(self) -> Optional[_builtins.int]:
        """
        Maximum number of seconds a connection may be reused.
        """
        return pulumi.get(self, "max_connection_lifetime")

    @_builtins.property
    @pulumi.getter(name="maxIdleConnections")
    def max_idle_connections(self) -> Optional[_builtins.int]:
        """
        Maximum number of idle connections to the database.
        """
        return pulumi.get(self, "max_idle_connections")

    @_builtins.property
    @pulumi.getter(name="maxOpenConnections")
    def max_open_connections(self) -> Optional[_builtins.int]:
        """
        Maximum number of open connections to the database.
        """
        return pulumi.get(self, "max_open_connections")

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[_builtins.str]:
        """
        The root credential password used in the connection URL
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter(name="passwordWo")
    def password_wo(self) -> Optional[_builtins.str]:
        """
        **NOTE:** This field is write-only and its value will not be updated in state as part of read operations.
        Write-only field for the root credential password used in the connection URL
        """
        return pulumi.get(self, "password_wo")

    @_builtins.property
    @pulumi.getter(name="passwordWoVersion")
    def password_wo_version(self) -> Optional[_builtins.int]:
        """
        Version counter for root credential password write-only field
        """
        return pulumi.get(self, "password_wo_version")

    @_builtins.property
    @pulumi.getter(name="pluginName")
    def plugin_name(self) -> Optional[_builtins.str]:
        """
        Specifies the name of the plugin to use.
        """
        return pulumi.get(self, "plugin_name")

    @_builtins.property
    @pulumi.getter(name="rootRotationStatements")
    def root_rotation_statements(self) -> Optional[Sequence[_builtins.str]]:
        """
        A list of database statements to be executed to rotate the root user's credentials.
        """
        return pulumi.get(self, "root_rotation_statements")

    @_builtins.property
    @pulumi.getter(name="rotationPeriod")
    def rotation_period(self) -> Optional[_builtins.int]:
        """
        The amount of time in seconds Vault should wait before rotating the root credential.
        A zero value tells Vault not to rotate the root credential. The minimum rotation period is 10 seconds. Requires Vault Enterprise 1.19+.
        """
        return pulumi.get(self, "rotation_period")

    @_builtins.property
    @pulumi.getter(name="rotationSchedule")
    def rotation_schedule(self) -> Optional[_builtins.str]:
        """
        The schedule, in [cron-style time format](https://en.wikipedia.org/wiki/Cron),
        defining the schedule on which Vault should rotate the root token. Requires Vault Enterprise 1.19+.
        """
        return pulumi.get(self, "rotation_schedule")

    @_builtins.property
    @pulumi.getter(name="rotationWindow")
    def rotation_window(self) -> Optional[_builtins.int]:
        """
        The maximum amount of time in seconds allowed to complete
        a rotation when a scheduled token rotation occurs. The default rotation window is
        unbound and the minimum allowable window is `3600`. Requires Vault Enterprise 1.19+.
        """
        return pulumi.get(self, "rotation_window")

    @_builtins.property
    @pulumi.getter
    def username(self) -> Optional[_builtins.str]:
        """
        The root credential username used in the connection URL
        """
        return pulumi.get(self, "username")

    @_builtins.property
    @pulumi.getter(name="usernameTemplate")
    def username_template(self) -> Optional[_builtins.str]:
        """
        Username generation template.
        """
        return pulumi.get(self, "username_template")

    @_builtins.property
    @pulumi.getter(name="verifyConnection")
    def verify_connection(self) -> Optional[_builtins.bool]:
        """
        Whether the connection should be verified on
        initial configuration or not.
        """
        return pulumi.get(self, "verify_connection")


@pulumi.output_type
class SecretsMountMongodbatla(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "privateKey":
            suggest = "private_key"
        elif key == "projectId":
            suggest = "project_id"
        elif key == "publicKey":
            suggest = "public_key"
        elif key == "allowedRoles":
            suggest = "allowed_roles"
        elif key == "disableAutomatedRotation":
            suggest = "disable_automated_rotation"
        elif key == "pluginName":
            suggest = "plugin_name"
        elif key == "rootRotationStatements":
            suggest = "root_rotation_statements"
        elif key == "rotationPeriod":
            suggest = "rotation_period"
        elif key == "rotationSchedule":
            suggest = "rotation_schedule"
        elif key == "rotationWindow":
            suggest = "rotation_window"
        elif key == "verifyConnection":
            suggest = "verify_connection"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecretsMountMongodbatla. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecretsMountMongodbatla.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecretsMountMongodbatla.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 private_key: _builtins.str,
                 project_id: _builtins.str,
                 public_key: _builtins.str,
                 allowed_roles: Optional[Sequence[_builtins.str]] = None,
                 data: Optional[Mapping[str, _builtins.str]] = None,
                 disable_automated_rotation: Optional[_builtins.bool] = None,
                 plugin_name: Optional[_builtins.str] = None,
                 root_rotation_statements: Optional[Sequence[_builtins.str]] = None,
                 rotation_period: Optional[_builtins.int] = None,
                 rotation_schedule: Optional[_builtins.str] = None,
                 rotation_window: Optional[_builtins.int] = None,
                 verify_connection: Optional[_builtins.bool] = None):
        """
        :param _builtins.str name: Name of the database connection.
        :param _builtins.str private_key: The Private Programmatic API Key used to connect with MongoDB Atlas API.
        :param _builtins.str project_id: The Project ID the Database User should be created within.
        :param _builtins.str public_key: The Public Programmatic API Key used to authenticate with the MongoDB Atlas API.
        :param Sequence[_builtins.str] allowed_roles: A list of roles that are allowed to use this
               connection.
        :param Mapping[str, _builtins.str] data: A map of sensitive data to pass to the endpoint. Useful for templated connection strings.
        :param _builtins.bool disable_automated_rotation: Cancels all upcoming rotations of the root credential until unset. Requires Vault Enterprise 1.19+.
               
               Supported list of database secrets engines that can be configured:
        :param _builtins.str plugin_name: Specifies the name of the plugin to use.
        :param Sequence[_builtins.str] root_rotation_statements: A list of database statements to be executed to rotate the root user's credentials.
        :param _builtins.int rotation_period: The amount of time in seconds Vault should wait before rotating the root credential.
               A zero value tells Vault not to rotate the root credential. The minimum rotation period is 10 seconds. Requires Vault Enterprise 1.19+.
        :param _builtins.str rotation_schedule: The schedule, in [cron-style time format](https://en.wikipedia.org/wiki/Cron),
               defining the schedule on which Vault should rotate the root token. Requires Vault Enterprise 1.19+.
        :param _builtins.int rotation_window: The maximum amount of time in seconds allowed to complete
               a rotation when a scheduled token rotation occurs. The default rotation window is
               unbound and the minimum allowable window is `3600`. Requires Vault Enterprise 1.19+.
        :param _builtins.bool verify_connection: Whether the connection should be verified on
               initial configuration or not.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "private_key", private_key)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "public_key", public_key)
        if allowed_roles is not None:
            pulumi.set(__self__, "allowed_roles", allowed_roles)
        if data is not None:
            pulumi.set(__self__, "data", data)
        if disable_automated_rotation is not None:
            pulumi.set(__self__, "disable_automated_rotation", disable_automated_rotation)
        if plugin_name is not None:
            pulumi.set(__self__, "plugin_name", plugin_name)
        if root_rotation_statements is not None:
            pulumi.set(__self__, "root_rotation_statements", root_rotation_statements)
        if rotation_period is not None:
            pulumi.set(__self__, "rotation_period", rotation_period)
        if rotation_schedule is not None:
            pulumi.set(__self__, "rotation_schedule", rotation_schedule)
        if rotation_window is not None:
            pulumi.set(__self__, "rotation_window", rotation_window)
        if verify_connection is not None:
            pulumi.set(__self__, "verify_connection", verify_connection)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the database connection.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> _builtins.str:
        """
        The Private Programmatic API Key used to connect with MongoDB Atlas API.
        """
        return pulumi.get(self, "private_key")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> _builtins.str:
        """
        The Project ID the Database User should be created within.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> _builtins.str:
        """
        The Public Programmatic API Key used to authenticate with the MongoDB Atlas API.
        """
        return pulumi.get(self, "public_key")

    @_builtins.property
    @pulumi.getter(name="allowedRoles")
    def allowed_roles(self) -> Optional[Sequence[_builtins.str]]:
        """
        A list of roles that are allowed to use this
        connection.
        """
        return pulumi.get(self, "allowed_roles")

    @_builtins.property
    @pulumi.getter
    def data(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        A map of sensitive data to pass to the endpoint. Useful for templated connection strings.
        """
        return pulumi.get(self, "data")

    @_builtins.property
    @pulumi.getter(name="disableAutomatedRotation")
    def disable_automated_rotation(self) -> Optional[_builtins.bool]:
        """
        Cancels all upcoming rotations of the root credential until unset. Requires Vault Enterprise 1.19+.

        Supported list of database secrets engines that can be configured:
        """
        return pulumi.get(self, "disable_automated_rotation")

    @_builtins.property
    @pulumi.getter(name="pluginName")
    def plugin_name(self) -> Optional[_builtins.str]:
        """
        Specifies the name of the plugin to use.
        """
        return pulumi.get(self, "plugin_name")

    @_builtins.property
    @pulumi.getter(name="rootRotationStatements")
    def root_rotation_statements(self) -> Optional[Sequence[_builtins.str]]:
        """
        A list of database statements to be executed to rotate the root user's credentials.
        """
        return pulumi.get(self, "root_rotation_statements")

    @_builtins.property
    @pulumi.getter(name="rotationPeriod")
    def rotation_period(self) -> Optional[_builtins.int]:
        """
        The amount of time in seconds Vault should wait before rotating the root credential.
        A zero value tells Vault not to rotate the root credential. The minimum rotation period is 10 seconds. Requires Vault Enterprise 1.19+.
        """
        return pulumi.get(self, "rotation_period")

    @_builtins.property
    @pulumi.getter(name="rotationSchedule")
    def rotation_schedule(self) -> Optional[_builtins.str]:
        """
        The schedule, in [cron-style time format](https://en.wikipedia.org/wiki/Cron),
        defining the schedule on which Vault should rotate the root token. Requires Vault Enterprise 1.19+.
        """
        return pulumi.get(self, "rotation_schedule")

    @_builtins.property
    @pulumi.getter(name="rotationWindow")
    def rotation_window(self) -> Optional[_builtins.int]:
        """
        The maximum amount of time in seconds allowed to complete
        a rotation when a scheduled token rotation occurs. The default rotation window is
        unbound and the minimum allowable window is `3600`. Requires Vault Enterprise 1.19+.
        """
        return pulumi.get(self, "rotation_window")

    @_builtins.property
    @pulumi.getter(name="verifyConnection")
    def verify_connection(self) -> Optional[_builtins.bool]:
        """
        Whether the connection should be verified on
        initial configuration or not.
        """
        return pulumi.get(self, "verify_connection")


@pulumi.output_type
class SecretsMountMssql(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedRoles":
            suggest = "allowed_roles"
        elif key == "connectionUrl":
            suggest = "connection_url"
        elif key == "containedDb":
            suggest = "contained_db"
        elif key == "disableAutomatedRotation":
            suggest = "disable_automated_rotation"
        elif key == "disableEscaping":
            suggest = "disable_escaping"
        elif key == "maxConnectionLifetime":
            suggest = "max_connection_lifetime"
        elif key == "maxIdleConnections":
            suggest = "max_idle_connections"
        elif key == "maxOpenConnections":
            suggest = "max_open_connections"
        elif key == "passwordWo":
            suggest = "password_wo"
        elif key == "passwordWoVersion":
            suggest = "password_wo_version"
        elif key == "pluginName":
            suggest = "plugin_name"
        elif key == "rootRotationStatements":
            suggest = "root_rotation_statements"
        elif key == "rotationPeriod":
            suggest = "rotation_period"
        elif key == "rotationSchedule":
            suggest = "rotation_schedule"
        elif key == "rotationWindow":
            suggest = "rotation_window"
        elif key == "usernameTemplate":
            suggest = "username_template"
        elif key == "verifyConnection":
            suggest = "verify_connection"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecretsMountMssql. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecretsMountMssql.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecretsMountMssql.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 allowed_roles: Optional[Sequence[_builtins.str]] = None,
                 connection_url: Optional[_builtins.str] = None,
                 contained_db: Optional[_builtins.bool] = None,
                 data: Optional[Mapping[str, _builtins.str]] = None,
                 disable_automated_rotation: Optional[_builtins.bool] = None,
                 disable_escaping: Optional[_builtins.bool] = None,
                 max_connection_lifetime: Optional[_builtins.int] = None,
                 max_idle_connections: Optional[_builtins.int] = None,
                 max_open_connections: Optional[_builtins.int] = None,
                 password: Optional[_builtins.str] = None,
                 password_wo: Optional[_builtins.str] = None,
                 password_wo_version: Optional[_builtins.int] = None,
                 plugin_name: Optional[_builtins.str] = None,
                 root_rotation_statements: Optional[Sequence[_builtins.str]] = None,
                 rotation_period: Optional[_builtins.int] = None,
                 rotation_schedule: Optional[_builtins.str] = None,
                 rotation_window: Optional[_builtins.int] = None,
                 username: Optional[_builtins.str] = None,
                 username_template: Optional[_builtins.str] = None,
                 verify_connection: Optional[_builtins.bool] = None):
        """
        :param _builtins.str name: Name of the database connection.
        :param Sequence[_builtins.str] allowed_roles: A list of roles that are allowed to use this
               connection.
        :param _builtins.str connection_url: Connection string to use to connect to the database.
        :param _builtins.bool contained_db: Set to true when the target is a Contained Database, e.g. AzureSQL.
        :param Mapping[str, _builtins.str] data: A map of sensitive data to pass to the endpoint. Useful for templated connection strings.
        :param _builtins.bool disable_automated_rotation: Cancels all upcoming rotations of the root credential until unset. Requires Vault Enterprise 1.19+.
               
               Supported list of database secrets engines that can be configured:
        :param _builtins.bool disable_escaping: Disable special character escaping in username and password
        :param _builtins.int max_connection_lifetime: Maximum number of seconds a connection may be reused.
        :param _builtins.int max_idle_connections: Maximum number of idle connections to the database.
        :param _builtins.int max_open_connections: Maximum number of open connections to the database.
        :param _builtins.str password: The root credential password used in the connection URL
        :param _builtins.str password_wo: **NOTE:** This field is write-only and its value will not be updated in state as part of read operations.
               Write-only field for the root credential password used in the connection URL
        :param _builtins.int password_wo_version: Version counter for root credential password write-only field
        :param _builtins.str plugin_name: Specifies the name of the plugin to use.
        :param Sequence[_builtins.str] root_rotation_statements: A list of database statements to be executed to rotate the root user's credentials.
        :param _builtins.int rotation_period: The amount of time in seconds Vault should wait before rotating the root credential.
               A zero value tells Vault not to rotate the root credential. The minimum rotation period is 10 seconds. Requires Vault Enterprise 1.19+.
        :param _builtins.str rotation_schedule: The schedule, in [cron-style time format](https://en.wikipedia.org/wiki/Cron),
               defining the schedule on which Vault should rotate the root token. Requires Vault Enterprise 1.19+.
        :param _builtins.int rotation_window: The maximum amount of time in seconds allowed to complete
               a rotation when a scheduled token rotation occurs. The default rotation window is
               unbound and the minimum allowable window is `3600`. Requires Vault Enterprise 1.19+.
        :param _builtins.str username: The root credential username used in the connection URL
        :param _builtins.str username_template: Username generation template.
        :param _builtins.bool verify_connection: Whether the connection should be verified on
               initial configuration or not.
        """
        pulumi.set(__self__, "name", name)
        if allowed_roles is not None:
            pulumi.set(__self__, "allowed_roles", allowed_roles)
        if connection_url is not None:
            pulumi.set(__self__, "connection_url", connection_url)
        if contained_db is not None:
            pulumi.set(__self__, "contained_db", contained_db)
        if data is not None:
            pulumi.set(__self__, "data", data)
        if disable_automated_rotation is not None:
            pulumi.set(__self__, "disable_automated_rotation", disable_automated_rotation)
        if disable_escaping is not None:
            pulumi.set(__self__, "disable_escaping", disable_escaping)
        if max_connection_lifetime is not None:
            pulumi.set(__self__, "max_connection_lifetime", max_connection_lifetime)
        if max_idle_connections is not None:
            pulumi.set(__self__, "max_idle_connections", max_idle_connections)
        if max_open_connections is not None:
            pulumi.set(__self__, "max_open_connections", max_open_connections)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if password_wo is not None:
            pulumi.set(__self__, "password_wo", password_wo)
        if password_wo_version is not None:
            pulumi.set(__self__, "password_wo_version", password_wo_version)
        if plugin_name is not None:
            pulumi.set(__self__, "plugin_name", plugin_name)
        if root_rotation_statements is not None:
            pulumi.set(__self__, "root_rotation_statements", root_rotation_statements)
        if rotation_period is not None:
            pulumi.set(__self__, "rotation_period", rotation_period)
        if rotation_schedule is not None:
            pulumi.set(__self__, "rotation_schedule", rotation_schedule)
        if rotation_window is not None:
            pulumi.set(__self__, "rotation_window", rotation_window)
        if username is not None:
            pulumi.set(__self__, "username", username)
        if username_template is not None:
            pulumi.set(__self__, "username_template", username_template)
        if verify_connection is not None:
            pulumi.set(__self__, "verify_connection", verify_connection)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the database connection.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="allowedRoles")
    def allowed_roles(self) -> Optional[Sequence[_builtins.str]]:
        """
        A list of roles that are allowed to use this
        connection.
        """
        return pulumi.get(self, "allowed_roles")

    @_builtins.property
    @pulumi.getter(name="connectionUrl")
    def connection_url(self) -> Optional[_builtins.str]:
        """
        Connection string to use to connect to the database.
        """
        return pulumi.get(self, "connection_url")

    @_builtins.property
    @pulumi.getter(name="containedDb")
    def contained_db(self) -> Optional[_builtins.bool]:
        """
        Set to true when the target is a Contained Database, e.g. AzureSQL.
        """
        return pulumi.get(self, "contained_db")

    @_builtins.property
    @pulumi.getter
    def data(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        A map of sensitive data to pass to the endpoint. Useful for templated connection strings.
        """
        return pulumi.get(self, "data")

    @_builtins.property
    @pulumi.getter(name="disableAutomatedRotation")
    def disable_automated_rotation(self) -> Optional[_builtins.bool]:
        """
        Cancels all upcoming rotations of the root credential until unset. Requires Vault Enterprise 1.19+.

        Supported list of database secrets engines that can be configured:
        """
        return pulumi.get(self, "disable_automated_rotation")

    @_builtins.property
    @pulumi.getter(name="disableEscaping")
    def disable_escaping(self) -> Optional[_builtins.bool]:
        """
        Disable special character escaping in username and password
        """
        return pulumi.get(self, "disable_escaping")

    @_builtins.property
    @pulumi.getter(name="maxConnectionLifetime")
    def max_connection_lifetime(self) -> Optional[_builtins.int]:
        """
        Maximum number of seconds a connection may be reused.
        """
        return pulumi.get(self, "max_connection_lifetime")

    @_builtins.property
    @pulumi.getter(name="maxIdleConnections")
    def max_idle_connections(self) -> Optional[_builtins.int]:
        """
        Maximum number of idle connections to the database.
        """
        return pulumi.get(self, "max_idle_connections")

    @_builtins.property
    @pulumi.getter(name="maxOpenConnections")
    def max_open_connections(self) -> Optional[_builtins.int]:
        """
        Maximum number of open connections to the database.
        """
        return pulumi.get(self, "max_open_connections")

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[_builtins.str]:
        """
        The root credential password used in the connection URL
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter(name="passwordWo")
    def password_wo(self) -> Optional[_builtins.str]:
        """
        **NOTE:** This field is write-only and its value will not be updated in state as part of read operations.
        Write-only field for the root credential password used in the connection URL
        """
        return pulumi.get(self, "password_wo")

    @_builtins.property
    @pulumi.getter(name="passwordWoVersion")
    def password_wo_version(self) -> Optional[_builtins.int]:
        """
        Version counter for root credential password write-only field
        """
        return pulumi.get(self, "password_wo_version")

    @_builtins.property
    @pulumi.getter(name="pluginName")
    def plugin_name(self) -> Optional[_builtins.str]:
        """
        Specifies the name of the plugin to use.
        """
        return pulumi.get(self, "plugin_name")

    @_builtins.property
    @pulumi.getter(name="rootRotationStatements")
    def root_rotation_statements(self) -> Optional[Sequence[_builtins.str]]:
        """
        A list of database statements to be executed to rotate the root user's credentials.
        """
        return pulumi.get(self, "root_rotation_statements")

    @_builtins.property
    @pulumi.getter(name="rotationPeriod")
    def rotation_period(self) -> Optional[_builtins.int]:
        """
        The amount of time in seconds Vault should wait before rotating the root credential.
        A zero value tells Vault not to rotate the root credential. The minimum rotation period is 10 seconds. Requires Vault Enterprise 1.19+.
        """
        return pulumi.get(self, "rotation_period")

    @_builtins.property
    @pulumi.getter(name="rotationSchedule")
    def rotation_schedule(self) -> Optional[_builtins.str]:
        """
        The schedule, in [cron-style time format](https://en.wikipedia.org/wiki/Cron),
        defining the schedule on which Vault should rotate the root token. Requires Vault Enterprise 1.19+.
        """
        return pulumi.get(self, "rotation_schedule")

    @_builtins.property
    @pulumi.getter(name="rotationWindow")
    def rotation_window(self) -> Optional[_builtins.int]:
        """
        The maximum amount of time in seconds allowed to complete
        a rotation when a scheduled token rotation occurs. The default rotation window is
        unbound and the minimum allowable window is `3600`. Requires Vault Enterprise 1.19+.
        """
        return pulumi.get(self, "rotation_window")

    @_builtins.property
    @pulumi.getter
    def username(self) -> Optional[_builtins.str]:
        """
        The root credential username used in the connection URL
        """
        return pulumi.get(self, "username")

    @_builtins.property
    @pulumi.getter(name="usernameTemplate")
    def username_template(self) -> Optional[_builtins.str]:
        """
        Username generation template.
        """
        return pulumi.get(self, "username_template")

    @_builtins.property
    @pulumi.getter(name="verifyConnection")
    def verify_connection(self) -> Optional[_builtins.bool]:
        """
        Whether the connection should be verified on
        initial configuration or not.
        """
        return pulumi.get(self, "verify_connection")


@pulumi.output_type
class SecretsMountMysql(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedRoles":
            suggest = "allowed_roles"
        elif key == "authType":
            suggest = "auth_type"
        elif key == "connectionUrl":
            suggest = "connection_url"
        elif key == "disableAutomatedRotation":
            suggest = "disable_automated_rotation"
        elif key == "maxConnectionLifetime":
            suggest = "max_connection_lifetime"
        elif key == "maxIdleConnections":
            suggest = "max_idle_connections"
        elif key == "maxOpenConnections":
            suggest = "max_open_connections"
        elif key == "passwordWo":
            suggest = "password_wo"
        elif key == "passwordWoVersion":
            suggest = "password_wo_version"
        elif key == "pluginName":
            suggest = "plugin_name"
        elif key == "rootRotationStatements":
            suggest = "root_rotation_statements"
        elif key == "rotationPeriod":
            suggest = "rotation_period"
        elif key == "rotationSchedule":
            suggest = "rotation_schedule"
        elif key == "rotationWindow":
            suggest = "rotation_window"
        elif key == "serviceAccountJson":
            suggest = "service_account_json"
        elif key == "tlsCa":
            suggest = "tls_ca"
        elif key == "tlsCertificateKey":
            suggest = "tls_certificate_key"
        elif key == "usernameTemplate":
            suggest = "username_template"
        elif key == "verifyConnection":
            suggest = "verify_connection"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecretsMountMysql. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecretsMountMysql.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecretsMountMysql.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 allowed_roles: Optional[Sequence[_builtins.str]] = None,
                 auth_type: Optional[_builtins.str] = None,
                 connection_url: Optional[_builtins.str] = None,
                 data: Optional[Mapping[str, _builtins.str]] = None,
                 disable_automated_rotation: Optional[_builtins.bool] = None,
                 max_connection_lifetime: Optional[_builtins.int] = None,
                 max_idle_connections: Optional[_builtins.int] = None,
                 max_open_connections: Optional[_builtins.int] = None,
                 password: Optional[_builtins.str] = None,
                 password_wo: Optional[_builtins.str] = None,
                 password_wo_version: Optional[_builtins.int] = None,
                 plugin_name: Optional[_builtins.str] = None,
                 root_rotation_statements: Optional[Sequence[_builtins.str]] = None,
                 rotation_period: Optional[_builtins.int] = None,
                 rotation_schedule: Optional[_builtins.str] = None,
                 rotation_window: Optional[_builtins.int] = None,
                 service_account_json: Optional[_builtins.str] = None,
                 tls_ca: Optional[_builtins.str] = None,
                 tls_certificate_key: Optional[_builtins.str] = None,
                 username: Optional[_builtins.str] = None,
                 username_template: Optional[_builtins.str] = None,
                 verify_connection: Optional[_builtins.bool] = None):
        """
        :param _builtins.str name: Name of the database connection.
        :param Sequence[_builtins.str] allowed_roles: A list of roles that are allowed to use this
               connection.
        :param _builtins.str auth_type: Specify alternative authorization type. (Only 'gcp_iam' is valid currently)
        :param _builtins.str connection_url: Connection string to use to connect to the database.
        :param Mapping[str, _builtins.str] data: A map of sensitive data to pass to the endpoint. Useful for templated connection strings.
        :param _builtins.bool disable_automated_rotation: Cancels all upcoming rotations of the root credential until unset. Requires Vault Enterprise 1.19+.
               
               Supported list of database secrets engines that can be configured:
        :param _builtins.int max_connection_lifetime: Maximum number of seconds a connection may be reused.
        :param _builtins.int max_idle_connections: Maximum number of idle connections to the database.
        :param _builtins.int max_open_connections: Maximum number of open connections to the database.
        :param _builtins.str password: The root credential password used in the connection URL
        :param _builtins.str password_wo: **NOTE:** This field is write-only and its value will not be updated in state as part of read operations.
               Write-only field for the root credential password used in the connection URL
        :param _builtins.int password_wo_version: Version counter for root credential password write-only field
        :param _builtins.str plugin_name: Specifies the name of the plugin to use.
        :param Sequence[_builtins.str] root_rotation_statements: A list of database statements to be executed to rotate the root user's credentials.
        :param _builtins.int rotation_period: The amount of time in seconds Vault should wait before rotating the root credential.
               A zero value tells Vault not to rotate the root credential. The minimum rotation period is 10 seconds. Requires Vault Enterprise 1.19+.
        :param _builtins.str rotation_schedule: The schedule, in [cron-style time format](https://en.wikipedia.org/wiki/Cron),
               defining the schedule on which Vault should rotate the root token. Requires Vault Enterprise 1.19+.
        :param _builtins.int rotation_window: The maximum amount of time in seconds allowed to complete
               a rotation when a scheduled token rotation occurs. The default rotation window is
               unbound and the minimum allowable window is `3600`. Requires Vault Enterprise 1.19+.
        :param _builtins.str service_account_json: A JSON encoded credential for use with IAM authorization
        :param _builtins.str tls_ca: x509 CA file for validating the certificate presented by the MySQL server. Must be PEM encoded.
        :param _builtins.str tls_certificate_key: x509 certificate for connecting to the database. This must be a PEM encoded version of the private key and the certificate combined.
        :param _builtins.str username: The root credential username used in the connection URL
        :param _builtins.str username_template: Username generation template.
        :param _builtins.bool verify_connection: Whether the connection should be verified on
               initial configuration or not.
        """
        pulumi.set(__self__, "name", name)
        if allowed_roles is not None:
            pulumi.set(__self__, "allowed_roles", allowed_roles)
        if auth_type is not None:
            pulumi.set(__self__, "auth_type", auth_type)
        if connection_url is not None:
            pulumi.set(__self__, "connection_url", connection_url)
        if data is not None:
            pulumi.set(__self__, "data", data)
        if disable_automated_rotation is not None:
            pulumi.set(__self__, "disable_automated_rotation", disable_automated_rotation)
        if max_connection_lifetime is not None:
            pulumi.set(__self__, "max_connection_lifetime", max_connection_lifetime)
        if max_idle_connections is not None:
            pulumi.set(__self__, "max_idle_connections", max_idle_connections)
        if max_open_connections is not None:
            pulumi.set(__self__, "max_open_connections", max_open_connections)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if password_wo is not None:
            pulumi.set(__self__, "password_wo", password_wo)
        if password_wo_version is not None:
            pulumi.set(__self__, "password_wo_version", password_wo_version)
        if plugin_name is not None:
            pulumi.set(__self__, "plugin_name", plugin_name)
        if root_rotation_statements is not None:
            pulumi.set(__self__, "root_rotation_statements", root_rotation_statements)
        if rotation_period is not None:
            pulumi.set(__self__, "rotation_period", rotation_period)
        if rotation_schedule is not None:
            pulumi.set(__self__, "rotation_schedule", rotation_schedule)
        if rotation_window is not None:
            pulumi.set(__self__, "rotation_window", rotation_window)
        if service_account_json is not None:
            pulumi.set(__self__, "service_account_json", service_account_json)
        if tls_ca is not None:
            pulumi.set(__self__, "tls_ca", tls_ca)
        if tls_certificate_key is not None:
            pulumi.set(__self__, "tls_certificate_key", tls_certificate_key)
        if username is not None:
            pulumi.set(__self__, "username", username)
        if username_template is not None:
            pulumi.set(__self__, "username_template", username_template)
        if verify_connection is not None:
            pulumi.set(__self__, "verify_connection", verify_connection)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the database connection.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="allowedRoles")
    def allowed_roles(self) -> Optional[Sequence[_builtins.str]]:
        """
        A list of roles that are allowed to use this
        connection.
        """
        return pulumi.get(self, "allowed_roles")

    @_builtins.property
    @pulumi.getter(name="authType")
    def auth_type(self) -> Optional[_builtins.str]:
        """
        Specify alternative authorization type. (Only 'gcp_iam' is valid currently)
        """
        return pulumi.get(self, "auth_type")

    @_builtins.property
    @pulumi.getter(name="connectionUrl")
    def connection_url(self) -> Optional[_builtins.str]:
        """
        Connection string to use to connect to the database.
        """
        return pulumi.get(self, "connection_url")

    @_builtins.property
    @pulumi.getter
    def data(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        A map of sensitive data to pass to the endpoint. Useful for templated connection strings.
        """
        return pulumi.get(self, "data")

    @_builtins.property
    @pulumi.getter(name="disableAutomatedRotation")
    def disable_automated_rotation(self) -> Optional[_builtins.bool]:
        """
        Cancels all upcoming rotations of the root credential until unset. Requires Vault Enterprise 1.19+.

        Supported list of database secrets engines that can be configured:
        """
        return pulumi.get(self, "disable_automated_rotation")

    @_builtins.property
    @pulumi.getter(name="maxConnectionLifetime")
    def max_connection_lifetime(self) -> Optional[_builtins.int]:
        """
        Maximum number of seconds a connection may be reused.
        """
        return pulumi.get(self, "max_connection_lifetime")

    @_builtins.property
    @pulumi.getter(name="maxIdleConnections")
    def max_idle_connections(self) -> Optional[_builtins.int]:
        """
        Maximum number of idle connections to the database.
        """
        return pulumi.get(self, "max_idle_connections")

    @_builtins.property
    @pulumi.getter(name="maxOpenConnections")
    def max_open_connections(self) -> Optional[_builtins.int]:
        """
        Maximum number of open connections to the database.
        """
        return pulumi.get(self, "max_open_connections")

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[_builtins.str]:
        """
        The root credential password used in the connection URL
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter(name="passwordWo")
    def password_wo(self) -> Optional[_builtins.str]:
        """
        **NOTE:** This field is write-only and its value will not be updated in state as part of read operations.
        Write-only field for the root credential password used in the connection URL
        """
        return pulumi.get(self, "password_wo")

    @_builtins.property
    @pulumi.getter(name="passwordWoVersion")
    def password_wo_version(self) -> Optional[_builtins.int]:
        """
        Version counter for root credential password write-only field
        """
        return pulumi.get(self, "password_wo_version")

    @_builtins.property
    @pulumi.getter(name="pluginName")
    def plugin_name(self) -> Optional[_builtins.str]:
        """
        Specifies the name of the plugin to use.
        """
        return pulumi.get(self, "plugin_name")

    @_builtins.property
    @pulumi.getter(name="rootRotationStatements")
    def root_rotation_statements(self) -> Optional[Sequence[_builtins.str]]:
        """
        A list of database statements to be executed to rotate the root user's credentials.
        """
        return pulumi.get(self, "root_rotation_statements")

    @_builtins.property
    @pulumi.getter(name="rotationPeriod")
    def rotation_period(self) -> Optional[_builtins.int]:
        """
        The amount of time in seconds Vault should wait before rotating the root credential.
        A zero value tells Vault not to rotate the root credential. The minimum rotation period is 10 seconds. Requires Vault Enterprise 1.19+.
        """
        return pulumi.get(self, "rotation_period")

    @_builtins.property
    @pulumi.getter(name="rotationSchedule")
    def rotation_schedule(self) -> Optional[_builtins.str]:
        """
        The schedule, in [cron-style time format](https://en.wikipedia.org/wiki/Cron),
        defining the schedule on which Vault should rotate the root token. Requires Vault Enterprise 1.19+.
        """
        return pulumi.get(self, "rotation_schedule")

    @_builtins.property
    @pulumi.getter(name="rotationWindow")
    def rotation_window(self) -> Optional[_builtins.int]:
        """
        The maximum amount of time in seconds allowed to complete
        a rotation when a scheduled token rotation occurs. The default rotation window is
        unbound and the minimum allowable window is `3600`. Requires Vault Enterprise 1.19+.
        """
        return pulumi.get(self, "rotation_window")

    @_builtins.property
    @pulumi.getter(name="serviceAccountJson")
    def service_account_json(self) -> Optional[_builtins.str]:
        """
        A JSON encoded credential for use with IAM authorization
        """
        return pulumi.get(self, "service_account_json")

    @_builtins.property
    @pulumi.getter(name="tlsCa")
    def tls_ca(self) -> Optional[_builtins.str]:
        """
        x509 CA file for validating the certificate presented by the MySQL server. Must be PEM encoded.
        """
        return pulumi.get(self, "tls_ca")

    @_builtins.property
    @pulumi.getter(name="tlsCertificateKey")
    def tls_certificate_key(self) -> Optional[_builtins.str]:
        """
        x509 certificate for connecting to the database. This must be a PEM encoded version of the private key and the certificate combined.
        """
        return pulumi.get(self, "tls_certificate_key")

    @_builtins.property
    @pulumi.getter
    def username(self) -> Optional[_builtins.str]:
        """
        The root credential username used in the connection URL
        """
        return pulumi.get(self, "username")

    @_builtins.property
    @pulumi.getter(name="usernameTemplate")
    def username_template(self) -> Optional[_builtins.str]:
        """
        Username generation template.
        """
        return pulumi.get(self, "username_template")

    @_builtins.property
    @pulumi.getter(name="verifyConnection")
    def verify_connection(self) -> Optional[_builtins.bool]:
        """
        Whether the connection should be verified on
        initial configuration or not.
        """
        return pulumi.get(self, "verify_connection")


@pulumi.output_type
class SecretsMountMysqlAurora(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedRoles":
            suggest = "allowed_roles"
        elif key == "authType":
            suggest = "auth_type"
        elif key == "connectionUrl":
            suggest = "connection_url"
        elif key == "disableAutomatedRotation":
            suggest = "disable_automated_rotation"
        elif key == "maxConnectionLifetime":
            suggest = "max_connection_lifetime"
        elif key == "maxIdleConnections":
            suggest = "max_idle_connections"
        elif key == "maxOpenConnections":
            suggest = "max_open_connections"
        elif key == "passwordWo":
            suggest = "password_wo"
        elif key == "passwordWoVersion":
            suggest = "password_wo_version"
        elif key == "pluginName":
            suggest = "plugin_name"
        elif key == "rootRotationStatements":
            suggest = "root_rotation_statements"
        elif key == "rotationPeriod":
            suggest = "rotation_period"
        elif key == "rotationSchedule":
            suggest = "rotation_schedule"
        elif key == "rotationWindow":
            suggest = "rotation_window"
        elif key == "serviceAccountJson":
            suggest = "service_account_json"
        elif key == "tlsCa":
            suggest = "tls_ca"
        elif key == "tlsCertificateKey":
            suggest = "tls_certificate_key"
        elif key == "usernameTemplate":
            suggest = "username_template"
        elif key == "verifyConnection":
            suggest = "verify_connection"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecretsMountMysqlAurora. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecretsMountMysqlAurora.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecretsMountMysqlAurora.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 allowed_roles: Optional[Sequence[_builtins.str]] = None,
                 auth_type: Optional[_builtins.str] = None,
                 connection_url: Optional[_builtins.str] = None,
                 data: Optional[Mapping[str, _builtins.str]] = None,
                 disable_automated_rotation: Optional[_builtins.bool] = None,
                 max_connection_lifetime: Optional[_builtins.int] = None,
                 max_idle_connections: Optional[_builtins.int] = None,
                 max_open_connections: Optional[_builtins.int] = None,
                 password: Optional[_builtins.str] = None,
                 password_wo: Optional[_builtins.str] = None,
                 password_wo_version: Optional[_builtins.int] = None,
                 plugin_name: Optional[_builtins.str] = None,
                 root_rotation_statements: Optional[Sequence[_builtins.str]] = None,
                 rotation_period: Optional[_builtins.int] = None,
                 rotation_schedule: Optional[_builtins.str] = None,
                 rotation_window: Optional[_builtins.int] = None,
                 service_account_json: Optional[_builtins.str] = None,
                 tls_ca: Optional[_builtins.str] = None,
                 tls_certificate_key: Optional[_builtins.str] = None,
                 username: Optional[_builtins.str] = None,
                 username_template: Optional[_builtins.str] = None,
                 verify_connection: Optional[_builtins.bool] = None):
        """
        :param _builtins.str name: Name of the database connection.
        :param Sequence[_builtins.str] allowed_roles: A list of roles that are allowed to use this
               connection.
        :param _builtins.str auth_type: Specify alternative authorization type. (Only 'gcp_iam' is valid currently)
        :param _builtins.str connection_url: Connection string to use to connect to the database.
        :param Mapping[str, _builtins.str] data: A map of sensitive data to pass to the endpoint. Useful for templated connection strings.
        :param _builtins.bool disable_automated_rotation: Cancels all upcoming rotations of the root credential until unset. Requires Vault Enterprise 1.19+.
               
               Supported list of database secrets engines that can be configured:
        :param _builtins.int max_connection_lifetime: Maximum number of seconds a connection may be reused.
        :param _builtins.int max_idle_connections: Maximum number of idle connections to the database.
        :param _builtins.int max_open_connections: Maximum number of open connections to the database.
        :param _builtins.str password: The root credential password used in the connection URL
        :param _builtins.str password_wo: **NOTE:** This field is write-only and its value will not be updated in state as part of read operations.
               Write-only field for the root credential password used in the connection URL
        :param _builtins.int password_wo_version: Version counter for root credential password write-only field
        :param _builtins.str plugin_name: Specifies the name of the plugin to use.
        :param Sequence[_builtins.str] root_rotation_statements: A list of database statements to be executed to rotate the root user's credentials.
        :param _builtins.int rotation_period: The amount of time in seconds Vault should wait before rotating the root credential.
               A zero value tells Vault not to rotate the root credential. The minimum rotation period is 10 seconds. Requires Vault Enterprise 1.19+.
        :param _builtins.str rotation_schedule: The schedule, in [cron-style time format](https://en.wikipedia.org/wiki/Cron),
               defining the schedule on which Vault should rotate the root token. Requires Vault Enterprise 1.19+.
        :param _builtins.int rotation_window: The maximum amount of time in seconds allowed to complete
               a rotation when a scheduled token rotation occurs. The default rotation window is
               unbound and the minimum allowable window is `3600`. Requires Vault Enterprise 1.19+.
        :param _builtins.str service_account_json: A JSON encoded credential for use with IAM authorization
        :param _builtins.str tls_ca: x509 CA file for validating the certificate presented by the MySQL server. Must be PEM encoded.
        :param _builtins.str tls_certificate_key: x509 certificate for connecting to the database. This must be a PEM encoded version of the private key and the certificate combined.
        :param _builtins.str username: The root credential username used in the connection URL
        :param _builtins.str username_template: Username generation template.
        :param _builtins.bool verify_connection: Whether the connection should be verified on
               initial configuration or not.
        """
        pulumi.set(__self__, "name", name)
        if allowed_roles is not None:
            pulumi.set(__self__, "allowed_roles", allowed_roles)
        if auth_type is not None:
            pulumi.set(__self__, "auth_type", auth_type)
        if connection_url is not None:
            pulumi.set(__self__, "connection_url", connection_url)
        if data is not None:
            pulumi.set(__self__, "data", data)
        if disable_automated_rotation is not None:
            pulumi.set(__self__, "disable_automated_rotation", disable_automated_rotation)
        if max_connection_lifetime is not None:
            pulumi.set(__self__, "max_connection_lifetime", max_connection_lifetime)
        if max_idle_connections is not None:
            pulumi.set(__self__, "max_idle_connections", max_idle_connections)
        if max_open_connections is not None:
            pulumi.set(__self__, "max_open_connections", max_open_connections)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if password_wo is not None:
            pulumi.set(__self__, "password_wo", password_wo)
        if password_wo_version is not None:
            pulumi.set(__self__, "password_wo_version", password_wo_version)
        if plugin_name is not None:
            pulumi.set(__self__, "plugin_name", plugin_name)
        if root_rotation_statements is not None:
            pulumi.set(__self__, "root_rotation_statements", root_rotation_statements)
        if rotation_period is not None:
            pulumi.set(__self__, "rotation_period", rotation_period)
        if rotation_schedule is not None:
            pulumi.set(__self__, "rotation_schedule", rotation_schedule)
        if rotation_window is not None:
            pulumi.set(__self__, "rotation_window", rotation_window)
        if service_account_json is not None:
            pulumi.set(__self__, "service_account_json", service_account_json)
        if tls_ca is not None:
            pulumi.set(__self__, "tls_ca", tls_ca)
        if tls_certificate_key is not None:
            pulumi.set(__self__, "tls_certificate_key", tls_certificate_key)
        if username is not None:
            pulumi.set(__self__, "username", username)
        if username_template is not None:
            pulumi.set(__self__, "username_template", username_template)
        if verify_connection is not None:
            pulumi.set(__self__, "verify_connection", verify_connection)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the database connection.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="allowedRoles")
    def allowed_roles(self) -> Optional[Sequence[_builtins.str]]:
        """
        A list of roles that are allowed to use this
        connection.
        """
        return pulumi.get(self, "allowed_roles")

    @_builtins.property
    @pulumi.getter(name="authType")
    def auth_type(self) -> Optional[_builtins.str]:
        """
        Specify alternative authorization type. (Only 'gcp_iam' is valid currently)
        """
        return pulumi.get(self, "auth_type")

    @_builtins.property
    @pulumi.getter(name="connectionUrl")
    def connection_url(self) -> Optional[_builtins.str]:
        """
        Connection string to use to connect to the database.
        """
        return pulumi.get(self, "connection_url")

    @_builtins.property
    @pulumi.getter
    def data(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        A map of sensitive data to pass to the endpoint. Useful for templated connection strings.
        """
        return pulumi.get(self, "data")

    @_builtins.property
    @pulumi.getter(name="disableAutomatedRotation")
    def disable_automated_rotation(self) -> Optional[_builtins.bool]:
        """
        Cancels all upcoming rotations of the root credential until unset. Requires Vault Enterprise 1.19+.

        Supported list of database secrets engines that can be configured:
        """
        return pulumi.get(self, "disable_automated_rotation")

    @_builtins.property
    @pulumi.getter(name="maxConnectionLifetime")
    def max_connection_lifetime(self) -> Optional[_builtins.int]:
        """
        Maximum number of seconds a connection may be reused.
        """
        return pulumi.get(self, "max_connection_lifetime")

    @_builtins.property
    @pulumi.getter(name="maxIdleConnections")
    def max_idle_connections(self) -> Optional[_builtins.int]:
        """
        Maximum number of idle connections to the database.
        """
        return pulumi.get(self, "max_idle_connections")

    @_builtins.property
    @pulumi.getter(name="maxOpenConnections")
    def max_open_connections(self) -> Optional[_builtins.int]:
        """
        Maximum number of open connections to the database.
        """
        return pulumi.get(self, "max_open_connections")

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[_builtins.str]:
        """
        The root credential password used in the connection URL
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter(name="passwordWo")
    def password_wo(self) -> Optional[_builtins.str]:
        """
        **NOTE:** This field is write-only and its value will not be updated in state as part of read operations.
        Write-only field for the root credential password used in the connection URL
        """
        return pulumi.get(self, "password_wo")

    @_builtins.property
    @pulumi.getter(name="passwordWoVersion")
    def password_wo_version(self) -> Optional[_builtins.int]:
        """
        Version counter for root credential password write-only field
        """
        return pulumi.get(self, "password_wo_version")

    @_builtins.property
    @pulumi.getter(name="pluginName")
    def plugin_name(self) -> Optional[_builtins.str]:
        """
        Specifies the name of the plugin to use.
        """
        return pulumi.get(self, "plugin_name")

    @_builtins.property
    @pulumi.getter(name="rootRotationStatements")
    def root_rotation_statements(self) -> Optional[Sequence[_builtins.str]]:
        """
        A list of database statements to be executed to rotate the root user's credentials.
        """
        return pulumi.get(self, "root_rotation_statements")

    @_builtins.property
    @pulumi.getter(name="rotationPeriod")
    def rotation_period(self) -> Optional[_builtins.int]:
        """
        The amount of time in seconds Vault should wait before rotating the root credential.
        A zero value tells Vault not to rotate the root credential. The minimum rotation period is 10 seconds. Requires Vault Enterprise 1.19+.
        """
        return pulumi.get(self, "rotation_period")

    @_builtins.property
    @pulumi.getter(name="rotationSchedule")
    def rotation_schedule(self) -> Optional[_builtins.str]:
        """
        The schedule, in [cron-style time format](https://en.wikipedia.org/wiki/Cron),
        defining the schedule on which Vault should rotate the root token. Requires Vault Enterprise 1.19+.
        """
        return pulumi.get(self, "rotation_schedule")

    @_builtins.property
    @pulumi.getter(name="rotationWindow")
    def rotation_window(self) -> Optional[_builtins.int]:
        """
        The maximum amount of time in seconds allowed to complete
        a rotation when a scheduled token rotation occurs. The default rotation window is
        unbound and the minimum allowable window is `3600`. Requires Vault Enterprise 1.19+.
        """
        return pulumi.get(self, "rotation_window")

    @_builtins.property
    @pulumi.getter(name="serviceAccountJson")
    def service_account_json(self) -> Optional[_builtins.str]:
        """
        A JSON encoded credential for use with IAM authorization
        """
        return pulumi.get(self, "service_account_json")

    @_builtins.property
    @pulumi.getter(name="tlsCa")
    def tls_ca(self) -> Optional[_builtins.str]:
        """
        x509 CA file for validating the certificate presented by the MySQL server. Must be PEM encoded.
        """
        return pulumi.get(self, "tls_ca")

    @_builtins.property
    @pulumi.getter(name="tlsCertificateKey")
    def tls_certificate_key(self) -> Optional[_builtins.str]:
        """
        x509 certificate for connecting to the database. This must be a PEM encoded version of the private key and the certificate combined.
        """
        return pulumi.get(self, "tls_certificate_key")

    @_builtins.property
    @pulumi.getter
    def username(self) -> Optional[_builtins.str]:
        """
        The root credential username used in the connection URL
        """
        return pulumi.get(self, "username")

    @_builtins.property
    @pulumi.getter(name="usernameTemplate")
    def username_template(self) -> Optional[_builtins.str]:
        """
        Username generation template.
        """
        return pulumi.get(self, "username_template")

    @_builtins.property
    @pulumi.getter(name="verifyConnection")
    def verify_connection(self) -> Optional[_builtins.bool]:
        """
        Whether the connection should be verified on
        initial configuration or not.
        """
        return pulumi.get(self, "verify_connection")


@pulumi.output_type
class SecretsMountMysqlLegacy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedRoles":
            suggest = "allowed_roles"
        elif key == "authType":
            suggest = "auth_type"
        elif key == "connectionUrl":
            suggest = "connection_url"
        elif key == "disableAutomatedRotation":
            suggest = "disable_automated_rotation"
        elif key == "maxConnectionLifetime":
            suggest = "max_connection_lifetime"
        elif key == "maxIdleConnections":
            suggest = "max_idle_connections"
        elif key == "maxOpenConnections":
            suggest = "max_open_connections"
        elif key == "passwordWo":
            suggest = "password_wo"
        elif key == "passwordWoVersion":
            suggest = "password_wo_version"
        elif key == "pluginName":
            suggest = "plugin_name"
        elif key == "rootRotationStatements":
            suggest = "root_rotation_statements"
        elif key == "rotationPeriod":
            suggest = "rotation_period"
        elif key == "rotationSchedule":
            suggest = "rotation_schedule"
        elif key == "rotationWindow":
            suggest = "rotation_window"
        elif key == "serviceAccountJson":
            suggest = "service_account_json"
        elif key == "tlsCa":
            suggest = "tls_ca"
        elif key == "tlsCertificateKey":
            suggest = "tls_certificate_key"
        elif key == "usernameTemplate":
            suggest = "username_template"
        elif key == "verifyConnection":
            suggest = "verify_connection"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecretsMountMysqlLegacy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecretsMountMysqlLegacy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecretsMountMysqlLegacy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 allowed_roles: Optional[Sequence[_builtins.str]] = None,
                 auth_type: Optional[_builtins.str] = None,
                 connection_url: Optional[_builtins.str] = None,
                 data: Optional[Mapping[str, _builtins.str]] = None,
                 disable_automated_rotation: Optional[_builtins.bool] = None,
                 max_connection_lifetime: Optional[_builtins.int] = None,
                 max_idle_connections: Optional[_builtins.int] = None,
                 max_open_connections: Optional[_builtins.int] = None,
                 password: Optional[_builtins.str] = None,
                 password_wo: Optional[_builtins.str] = None,
                 password_wo_version: Optional[_builtins.int] = None,
                 plugin_name: Optional[_builtins.str] = None,
                 root_rotation_statements: Optional[Sequence[_builtins.str]] = None,
                 rotation_period: Optional[_builtins.int] = None,
                 rotation_schedule: Optional[_builtins.str] = None,
                 rotation_window: Optional[_builtins.int] = None,
                 service_account_json: Optional[_builtins.str] = None,
                 tls_ca: Optional[_builtins.str] = None,
                 tls_certificate_key: Optional[_builtins.str] = None,
                 username: Optional[_builtins.str] = None,
                 username_template: Optional[_builtins.str] = None,
                 verify_connection: Optional[_builtins.bool] = None):
        """
        :param _builtins.str name: Name of the database connection.
        :param Sequence[_builtins.str] allowed_roles: A list of roles that are allowed to use this
               connection.
        :param _builtins.str auth_type: Specify alternative authorization type. (Only 'gcp_iam' is valid currently)
        :param _builtins.str connection_url: Connection string to use to connect to the database.
        :param Mapping[str, _builtins.str] data: A map of sensitive data to pass to the endpoint. Useful for templated connection strings.
        :param _builtins.bool disable_automated_rotation: Cancels all upcoming rotations of the root credential until unset. Requires Vault Enterprise 1.19+.
               
               Supported list of database secrets engines that can be configured:
        :param _builtins.int max_connection_lifetime: Maximum number of seconds a connection may be reused.
        :param _builtins.int max_idle_connections: Maximum number of idle connections to the database.
        :param _builtins.int max_open_connections: Maximum number of open connections to the database.
        :param _builtins.str password: The root credential password used in the connection URL
        :param _builtins.str password_wo: **NOTE:** This field is write-only and its value will not be updated in state as part of read operations.
               Write-only field for the root credential password used in the connection URL
        :param _builtins.int password_wo_version: Version counter for root credential password write-only field
        :param _builtins.str plugin_name: Specifies the name of the plugin to use.
        :param Sequence[_builtins.str] root_rotation_statements: A list of database statements to be executed to rotate the root user's credentials.
        :param _builtins.int rotation_period: The amount of time in seconds Vault should wait before rotating the root credential.
               A zero value tells Vault not to rotate the root credential. The minimum rotation period is 10 seconds. Requires Vault Enterprise 1.19+.
        :param _builtins.str rotation_schedule: The schedule, in [cron-style time format](https://en.wikipedia.org/wiki/Cron),
               defining the schedule on which Vault should rotate the root token. Requires Vault Enterprise 1.19+.
        :param _builtins.int rotation_window: The maximum amount of time in seconds allowed to complete
               a rotation when a scheduled token rotation occurs. The default rotation window is
               unbound and the minimum allowable window is `3600`. Requires Vault Enterprise 1.19+.
        :param _builtins.str service_account_json: A JSON encoded credential for use with IAM authorization
        :param _builtins.str tls_ca: x509 CA file for validating the certificate presented by the MySQL server. Must be PEM encoded.
        :param _builtins.str tls_certificate_key: x509 certificate for connecting to the database. This must be a PEM encoded version of the private key and the certificate combined.
        :param _builtins.str username: The root credential username used in the connection URL
        :param _builtins.str username_template: Username generation template.
        :param _builtins.bool verify_connection: Whether the connection should be verified on
               initial configuration or not.
        """
        pulumi.set(__self__, "name", name)
        if allowed_roles is not None:
            pulumi.set(__self__, "allowed_roles", allowed_roles)
        if auth_type is not None:
            pulumi.set(__self__, "auth_type", auth_type)
        if connection_url is not None:
            pulumi.set(__self__, "connection_url", connection_url)
        if data is not None:
            pulumi.set(__self__, "data", data)
        if disable_automated_rotation is not None:
            pulumi.set(__self__, "disable_automated_rotation", disable_automated_rotation)
        if max_connection_lifetime is not None:
            pulumi.set(__self__, "max_connection_lifetime", max_connection_lifetime)
        if max_idle_connections is not None:
            pulumi.set(__self__, "max_idle_connections", max_idle_connections)
        if max_open_connections is not None:
            pulumi.set(__self__, "max_open_connections", max_open_connections)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if password_wo is not None:
            pulumi.set(__self__, "password_wo", password_wo)
        if password_wo_version is not None:
            pulumi.set(__self__, "password_wo_version", password_wo_version)
        if plugin_name is not None:
            pulumi.set(__self__, "plugin_name", plugin_name)
        if root_rotation_statements is not None:
            pulumi.set(__self__, "root_rotation_statements", root_rotation_statements)
        if rotation_period is not None:
            pulumi.set(__self__, "rotation_period", rotation_period)
        if rotation_schedule is not None:
            pulumi.set(__self__, "rotation_schedule", rotation_schedule)
        if rotation_window is not None:
            pulumi.set(__self__, "rotation_window", rotation_window)
        if service_account_json is not None:
            pulumi.set(__self__, "service_account_json", service_account_json)
        if tls_ca is not None:
            pulumi.set(__self__, "tls_ca", tls_ca)
        if tls_certificate_key is not None:
            pulumi.set(__self__, "tls_certificate_key", tls_certificate_key)
        if username is not None:
            pulumi.set(__self__, "username", username)
        if username_template is not None:
            pulumi.set(__self__, "username_template", username_template)
        if verify_connection is not None:
            pulumi.set(__self__, "verify_connection", verify_connection)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the database connection.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="allowedRoles")
    def allowed_roles(self) -> Optional[Sequence[_builtins.str]]:
        """
        A list of roles that are allowed to use this
        connection.
        """
        return pulumi.get(self, "allowed_roles")

    @_builtins.property
    @pulumi.getter(name="authType")
    def auth_type(self) -> Optional[_builtins.str]:
        """
        Specify alternative authorization type. (Only 'gcp_iam' is valid currently)
        """
        return pulumi.get(self, "auth_type")

    @_builtins.property
    @pulumi.getter(name="connectionUrl")
    def connection_url(self) -> Optional[_builtins.str]:
        """
        Connection string to use to connect to the database.
        """
        return pulumi.get(self, "connection_url")

    @_builtins.property
    @pulumi.getter
    def data(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        A map of sensitive data to pass to the endpoint. Useful for templated connection strings.
        """
        return pulumi.get(self, "data")

    @_builtins.property
    @pulumi.getter(name="disableAutomatedRotation")
    def disable_automated_rotation(self) -> Optional[_builtins.bool]:
        """
        Cancels all upcoming rotations of the root credential until unset. Requires Vault Enterprise 1.19+.

        Supported list of database secrets engines that can be configured:
        """
        return pulumi.get(self, "disable_automated_rotation")

    @_builtins.property
    @pulumi.getter(name="maxConnectionLifetime")
    def max_connection_lifetime(self) -> Optional[_builtins.int]:
        """
        Maximum number of seconds a connection may be reused.
        """
        return pulumi.get(self, "max_connection_lifetime")

    @_builtins.property
    @pulumi.getter(name="maxIdleConnections")
    def max_idle_connections(self) -> Optional[_builtins.int]:
        """
        Maximum number of idle connections to the database.
        """
        return pulumi.get(self, "max_idle_connections")

    @_builtins.property
    @pulumi.getter(name="maxOpenConnections")
    def max_open_connections(self) -> Optional[_builtins.int]:
        """
        Maximum number of open connections to the database.
        """
        return pulumi.get(self, "max_open_connections")

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[_builtins.str]:
        """
        The root credential password used in the connection URL
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter(name="passwordWo")
    def password_wo(self) -> Optional[_builtins.str]:
        """
        **NOTE:** This field is write-only and its value will not be updated in state as part of read operations.
        Write-only field for the root credential password used in the connection URL
        """
        return pulumi.get(self, "password_wo")

    @_builtins.property
    @pulumi.getter(name="passwordWoVersion")
    def password_wo_version(self) -> Optional[_builtins.int]:
        """
        Version counter for root credential password write-only field
        """
        return pulumi.get(self, "password_wo_version")

    @_builtins.property
    @pulumi.getter(name="pluginName")
    def plugin_name(self) -> Optional[_builtins.str]:
        """
        Specifies the name of the plugin to use.
        """
        return pulumi.get(self, "plugin_name")

    @_builtins.property
    @pulumi.getter(name="rootRotationStatements")
    def root_rotation_statements(self) -> Optional[Sequence[_builtins.str]]:
        """
        A list of database statements to be executed to rotate the root user's credentials.
        """
        return pulumi.get(self, "root_rotation_statements")

    @_builtins.property
    @pulumi.getter(name="rotationPeriod")
    def rotation_period(self) -> Optional[_builtins.int]:
        """
        The amount of time in seconds Vault should wait before rotating the root credential.
        A zero value tells Vault not to rotate the root credential. The minimum rotation period is 10 seconds. Requires Vault Enterprise 1.19+.
        """
        return pulumi.get(self, "rotation_period")

    @_builtins.property
    @pulumi.getter(name="rotationSchedule")
    def rotation_schedule(self) -> Optional[_builtins.str]:
        """
        The schedule, in [cron-style time format](https://en.wikipedia.org/wiki/Cron),
        defining the schedule on which Vault should rotate the root token. Requires Vault Enterprise 1.19+.
        """
        return pulumi.get(self, "rotation_schedule")

    @_builtins.property
    @pulumi.getter(name="rotationWindow")
    def rotation_window(self) -> Optional[_builtins.int]:
        """
        The maximum amount of time in seconds allowed to complete
        a rotation when a scheduled token rotation occurs. The default rotation window is
        unbound and the minimum allowable window is `3600`. Requires Vault Enterprise 1.19+.
        """
        return pulumi.get(self, "rotation_window")

    @_builtins.property
    @pulumi.getter(name="serviceAccountJson")
    def service_account_json(self) -> Optional[_builtins.str]:
        """
        A JSON encoded credential for use with IAM authorization
        """
        return pulumi.get(self, "service_account_json")

    @_builtins.property
    @pulumi.getter(name="tlsCa")
    def tls_ca(self) -> Optional[_builtins.str]:
        """
        x509 CA file for validating the certificate presented by the MySQL server. Must be PEM encoded.
        """
        return pulumi.get(self, "tls_ca")

    @_builtins.property
    @pulumi.getter(name="tlsCertificateKey")
    def tls_certificate_key(self) -> Optional[_builtins.str]:
        """
        x509 certificate for connecting to the database. This must be a PEM encoded version of the private key and the certificate combined.
        """
        return pulumi.get(self, "tls_certificate_key")

    @_builtins.property
    @pulumi.getter
    def username(self) -> Optional[_builtins.str]:
        """
        The root credential username used in the connection URL
        """
        return pulumi.get(self, "username")

    @_builtins.property
    @pulumi.getter(name="usernameTemplate")
    def username_template(self) -> Optional[_builtins.str]:
        """
        Username generation template.
        """
        return pulumi.get(self, "username_template")

    @_builtins.property
    @pulumi.getter(name="verifyConnection")
    def verify_connection(self) -> Optional[_builtins.bool]:
        """
        Whether the connection should be verified on
        initial configuration or not.
        """
        return pulumi.get(self, "verify_connection")


@pulumi.output_type
class SecretsMountMysqlRd(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedRoles":
            suggest = "allowed_roles"
        elif key == "authType":
            suggest = "auth_type"
        elif key == "connectionUrl":
            suggest = "connection_url"
        elif key == "disableAutomatedRotation":
            suggest = "disable_automated_rotation"
        elif key == "maxConnectionLifetime":
            suggest = "max_connection_lifetime"
        elif key == "maxIdleConnections":
            suggest = "max_idle_connections"
        elif key == "maxOpenConnections":
            suggest = "max_open_connections"
        elif key == "passwordWo":
            suggest = "password_wo"
        elif key == "passwordWoVersion":
            suggest = "password_wo_version"
        elif key == "pluginName":
            suggest = "plugin_name"
        elif key == "rootRotationStatements":
            suggest = "root_rotation_statements"
        elif key == "rotationPeriod":
            suggest = "rotation_period"
        elif key == "rotationSchedule":
            suggest = "rotation_schedule"
        elif key == "rotationWindow":
            suggest = "rotation_window"
        elif key == "serviceAccountJson":
            suggest = "service_account_json"
        elif key == "tlsCa":
            suggest = "tls_ca"
        elif key == "tlsCertificateKey":
            suggest = "tls_certificate_key"
        elif key == "usernameTemplate":
            suggest = "username_template"
        elif key == "verifyConnection":
            suggest = "verify_connection"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecretsMountMysqlRd. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecretsMountMysqlRd.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecretsMountMysqlRd.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 allowed_roles: Optional[Sequence[_builtins.str]] = None,
                 auth_type: Optional[_builtins.str] = None,
                 connection_url: Optional[_builtins.str] = None,
                 data: Optional[Mapping[str, _builtins.str]] = None,
                 disable_automated_rotation: Optional[_builtins.bool] = None,
                 max_connection_lifetime: Optional[_builtins.int] = None,
                 max_idle_connections: Optional[_builtins.int] = None,
                 max_open_connections: Optional[_builtins.int] = None,
                 password: Optional[_builtins.str] = None,
                 password_wo: Optional[_builtins.str] = None,
                 password_wo_version: Optional[_builtins.int] = None,
                 plugin_name: Optional[_builtins.str] = None,
                 root_rotation_statements: Optional[Sequence[_builtins.str]] = None,
                 rotation_period: Optional[_builtins.int] = None,
                 rotation_schedule: Optional[_builtins.str] = None,
                 rotation_window: Optional[_builtins.int] = None,
                 service_account_json: Optional[_builtins.str] = None,
                 tls_ca: Optional[_builtins.str] = None,
                 tls_certificate_key: Optional[_builtins.str] = None,
                 username: Optional[_builtins.str] = None,
                 username_template: Optional[_builtins.str] = None,
                 verify_connection: Optional[_builtins.bool] = None):
        """
        :param _builtins.str name: Name of the database connection.
        :param Sequence[_builtins.str] allowed_roles: A list of roles that are allowed to use this
               connection.
        :param _builtins.str auth_type: Specify alternative authorization type. (Only 'gcp_iam' is valid currently)
        :param _builtins.str connection_url: Connection string to use to connect to the database.
        :param Mapping[str, _builtins.str] data: A map of sensitive data to pass to the endpoint. Useful for templated connection strings.
        :param _builtins.bool disable_automated_rotation: Cancels all upcoming rotations of the root credential until unset. Requires Vault Enterprise 1.19+.
               
               Supported list of database secrets engines that can be configured:
        :param _builtins.int max_connection_lifetime: Maximum number of seconds a connection may be reused.
        :param _builtins.int max_idle_connections: Maximum number of idle connections to the database.
        :param _builtins.int max_open_connections: Maximum number of open connections to the database.
        :param _builtins.str password: The root credential password used in the connection URL
        :param _builtins.str password_wo: **NOTE:** This field is write-only and its value will not be updated in state as part of read operations.
               Write-only field for the root credential password used in the connection URL
        :param _builtins.int password_wo_version: Version counter for root credential password write-only field
        :param _builtins.str plugin_name: Specifies the name of the plugin to use.
        :param Sequence[_builtins.str] root_rotation_statements: A list of database statements to be executed to rotate the root user's credentials.
        :param _builtins.int rotation_period: The amount of time in seconds Vault should wait before rotating the root credential.
               A zero value tells Vault not to rotate the root credential. The minimum rotation period is 10 seconds. Requires Vault Enterprise 1.19+.
        :param _builtins.str rotation_schedule: The schedule, in [cron-style time format](https://en.wikipedia.org/wiki/Cron),
               defining the schedule on which Vault should rotate the root token. Requires Vault Enterprise 1.19+.
        :param _builtins.int rotation_window: The maximum amount of time in seconds allowed to complete
               a rotation when a scheduled token rotation occurs. The default rotation window is
               unbound and the minimum allowable window is `3600`. Requires Vault Enterprise 1.19+.
        :param _builtins.str service_account_json: A JSON encoded credential for use with IAM authorization
        :param _builtins.str tls_ca: x509 CA file for validating the certificate presented by the MySQL server. Must be PEM encoded.
        :param _builtins.str tls_certificate_key: x509 certificate for connecting to the database. This must be a PEM encoded version of the private key and the certificate combined.
        :param _builtins.str username: The root credential username used in the connection URL
        :param _builtins.str username_template: Username generation template.
        :param _builtins.bool verify_connection: Whether the connection should be verified on
               initial configuration or not.
        """
        pulumi.set(__self__, "name", name)
        if allowed_roles is not None:
            pulumi.set(__self__, "allowed_roles", allowed_roles)
        if auth_type is not None:
            pulumi.set(__self__, "auth_type", auth_type)
        if connection_url is not None:
            pulumi.set(__self__, "connection_url", connection_url)
        if data is not None:
            pulumi.set(__self__, "data", data)
        if disable_automated_rotation is not None:
            pulumi.set(__self__, "disable_automated_rotation", disable_automated_rotation)
        if max_connection_lifetime is not None:
            pulumi.set(__self__, "max_connection_lifetime", max_connection_lifetime)
        if max_idle_connections is not None:
            pulumi.set(__self__, "max_idle_connections", max_idle_connections)
        if max_open_connections is not None:
            pulumi.set(__self__, "max_open_connections", max_open_connections)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if password_wo is not None:
            pulumi.set(__self__, "password_wo", password_wo)
        if password_wo_version is not None:
            pulumi.set(__self__, "password_wo_version", password_wo_version)
        if plugin_name is not None:
            pulumi.set(__self__, "plugin_name", plugin_name)
        if root_rotation_statements is not None:
            pulumi.set(__self__, "root_rotation_statements", root_rotation_statements)
        if rotation_period is not None:
            pulumi.set(__self__, "rotation_period", rotation_period)
        if rotation_schedule is not None:
            pulumi.set(__self__, "rotation_schedule", rotation_schedule)
        if rotation_window is not None:
            pulumi.set(__self__, "rotation_window", rotation_window)
        if service_account_json is not None:
            pulumi.set(__self__, "service_account_json", service_account_json)
        if tls_ca is not None:
            pulumi.set(__self__, "tls_ca", tls_ca)
        if tls_certificate_key is not None:
            pulumi.set(__self__, "tls_certificate_key", tls_certificate_key)
        if username is not None:
            pulumi.set(__self__, "username", username)
        if username_template is not None:
            pulumi.set(__self__, "username_template", username_template)
        if verify_connection is not None:
            pulumi.set(__self__, "verify_connection", verify_connection)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the database connection.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="allowedRoles")
    def allowed_roles(self) -> Optional[Sequence[_builtins.str]]:
        """
        A list of roles that are allowed to use this
        connection.
        """
        return pulumi.get(self, "allowed_roles")

    @_builtins.property
    @pulumi.getter(name="authType")
    def auth_type(self) -> Optional[_builtins.str]:
        """
        Specify alternative authorization type. (Only 'gcp_iam' is valid currently)
        """
        return pulumi.get(self, "auth_type")

    @_builtins.property
    @pulumi.getter(name="connectionUrl")
    def connection_url(self) -> Optional[_builtins.str]:
        """
        Connection string to use to connect to the database.
        """
        return pulumi.get(self, "connection_url")

    @_builtins.property
    @pulumi.getter
    def data(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        A map of sensitive data to pass to the endpoint. Useful for templated connection strings.
        """
        return pulumi.get(self, "data")

    @_builtins.property
    @pulumi.getter(name="disableAutomatedRotation")
    def disable_automated_rotation(self) -> Optional[_builtins.bool]:
        """
        Cancels all upcoming rotations of the root credential until unset. Requires Vault Enterprise 1.19+.

        Supported list of database secrets engines that can be configured:
        """
        return pulumi.get(self, "disable_automated_rotation")

    @_builtins.property
    @pulumi.getter(name="maxConnectionLifetime")
    def max_connection_lifetime(self) -> Optional[_builtins.int]:
        """
        Maximum number of seconds a connection may be reused.
        """
        return pulumi.get(self, "max_connection_lifetime")

    @_builtins.property
    @pulumi.getter(name="maxIdleConnections")
    def max_idle_connections(self) -> Optional[_builtins.int]:
        """
        Maximum number of idle connections to the database.
        """
        return pulumi.get(self, "max_idle_connections")

    @_builtins.property
    @pulumi.getter(name="maxOpenConnections")
    def max_open_connections(self) -> Optional[_builtins.int]:
        """
        Maximum number of open connections to the database.
        """
        return pulumi.get(self, "max_open_connections")

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[_builtins.str]:
        """
        The root credential password used in the connection URL
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter(name="passwordWo")
    def password_wo(self) -> Optional[_builtins.str]:
        """
        **NOTE:** This field is write-only and its value will not be updated in state as part of read operations.
        Write-only field for the root credential password used in the connection URL
        """
        return pulumi.get(self, "password_wo")

    @_builtins.property
    @pulumi.getter(name="passwordWoVersion")
    def password_wo_version(self) -> Optional[_builtins.int]:
        """
        Version counter for root credential password write-only field
        """
        return pulumi.get(self, "password_wo_version")

    @_builtins.property
    @pulumi.getter(name="pluginName")
    def plugin_name(self) -> Optional[_builtins.str]:
        """
        Specifies the name of the plugin to use.
        """
        return pulumi.get(self, "plugin_name")

    @_builtins.property
    @pulumi.getter(name="rootRotationStatements")
    def root_rotation_statements(self) -> Optional[Sequence[_builtins.str]]:
        """
        A list of database statements to be executed to rotate the root user's credentials.
        """
        return pulumi.get(self, "root_rotation_statements")

    @_builtins.property
    @pulumi.getter(name="rotationPeriod")
    def rotation_period(self) -> Optional[_builtins.int]:
        """
        The amount of time in seconds Vault should wait before rotating the root credential.
        A zero value tells Vault not to rotate the root credential. The minimum rotation period is 10 seconds. Requires Vault Enterprise 1.19+.
        """
        return pulumi.get(self, "rotation_period")

    @_builtins.property
    @pulumi.getter(name="rotationSchedule")
    def rotation_schedule(self) -> Optional[_builtins.str]:
        """
        The schedule, in [cron-style time format](https://en.wikipedia.org/wiki/Cron),
        defining the schedule on which Vault should rotate the root token. Requires Vault Enterprise 1.19+.
        """
        return pulumi.get(self, "rotation_schedule")

    @_builtins.property
    @pulumi.getter(name="rotationWindow")
    def rotation_window(self) -> Optional[_builtins.int]:
        """
        The maximum amount of time in seconds allowed to complete
        a rotation when a scheduled token rotation occurs. The default rotation window is
        unbound and the minimum allowable window is `3600`. Requires Vault Enterprise 1.19+.
        """
        return pulumi.get(self, "rotation_window")

    @_builtins.property
    @pulumi.getter(name="serviceAccountJson")
    def service_account_json(self) -> Optional[_builtins.str]:
        """
        A JSON encoded credential for use with IAM authorization
        """
        return pulumi.get(self, "service_account_json")

    @_builtins.property
    @pulumi.getter(name="tlsCa")
    def tls_ca(self) -> Optional[_builtins.str]:
        """
        x509 CA file for validating the certificate presented by the MySQL server. Must be PEM encoded.
        """
        return pulumi.get(self, "tls_ca")

    @_builtins.property
    @pulumi.getter(name="tlsCertificateKey")
    def tls_certificate_key(self) -> Optional[_builtins.str]:
        """
        x509 certificate for connecting to the database. This must be a PEM encoded version of the private key and the certificate combined.
        """
        return pulumi.get(self, "tls_certificate_key")

    @_builtins.property
    @pulumi.getter
    def username(self) -> Optional[_builtins.str]:
        """
        The root credential username used in the connection URL
        """
        return pulumi.get(self, "username")

    @_builtins.property
    @pulumi.getter(name="usernameTemplate")
    def username_template(self) -> Optional[_builtins.str]:
        """
        Username generation template.
        """
        return pulumi.get(self, "username_template")

    @_builtins.property
    @pulumi.getter(name="verifyConnection")
    def verify_connection(self) -> Optional[_builtins.bool]:
        """
        Whether the connection should be verified on
        initial configuration or not.
        """
        return pulumi.get(self, "verify_connection")


@pulumi.output_type
class SecretsMountOracle(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedRoles":
            suggest = "allowed_roles"
        elif key == "connectionUrl":
            suggest = "connection_url"
        elif key == "disableAutomatedRotation":
            suggest = "disable_automated_rotation"
        elif key == "disconnectSessions":
            suggest = "disconnect_sessions"
        elif key == "maxConnectionLifetime":
            suggest = "max_connection_lifetime"
        elif key == "maxIdleConnections":
            suggest = "max_idle_connections"
        elif key == "maxOpenConnections":
            suggest = "max_open_connections"
        elif key == "passwordWo":
            suggest = "password_wo"
        elif key == "passwordWoVersion":
            suggest = "password_wo_version"
        elif key == "pluginName":
            suggest = "plugin_name"
        elif key == "rootRotationStatements":
            suggest = "root_rotation_statements"
        elif key == "rotationPeriod":
            suggest = "rotation_period"
        elif key == "rotationSchedule":
            suggest = "rotation_schedule"
        elif key == "rotationWindow":
            suggest = "rotation_window"
        elif key == "splitStatements":
            suggest = "split_statements"
        elif key == "usernameTemplate":
            suggest = "username_template"
        elif key == "verifyConnection":
            suggest = "verify_connection"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecretsMountOracle. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecretsMountOracle.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecretsMountOracle.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 allowed_roles: Optional[Sequence[_builtins.str]] = None,
                 connection_url: Optional[_builtins.str] = None,
                 data: Optional[Mapping[str, _builtins.str]] = None,
                 disable_automated_rotation: Optional[_builtins.bool] = None,
                 disconnect_sessions: Optional[_builtins.bool] = None,
                 max_connection_lifetime: Optional[_builtins.int] = None,
                 max_idle_connections: Optional[_builtins.int] = None,
                 max_open_connections: Optional[_builtins.int] = None,
                 password: Optional[_builtins.str] = None,
                 password_wo: Optional[_builtins.str] = None,
                 password_wo_version: Optional[_builtins.int] = None,
                 plugin_name: Optional[_builtins.str] = None,
                 root_rotation_statements: Optional[Sequence[_builtins.str]] = None,
                 rotation_period: Optional[_builtins.int] = None,
                 rotation_schedule: Optional[_builtins.str] = None,
                 rotation_window: Optional[_builtins.int] = None,
                 split_statements: Optional[_builtins.bool] = None,
                 username: Optional[_builtins.str] = None,
                 username_template: Optional[_builtins.str] = None,
                 verify_connection: Optional[_builtins.bool] = None):
        """
        :param _builtins.str name: Name of the database connection.
        :param Sequence[_builtins.str] allowed_roles: A list of roles that are allowed to use this
               connection.
        :param _builtins.str connection_url: Connection string to use to connect to the database.
        :param Mapping[str, _builtins.str] data: A map of sensitive data to pass to the endpoint. Useful for templated connection strings.
        :param _builtins.bool disable_automated_rotation: Cancels all upcoming rotations of the root credential until unset. Requires Vault Enterprise 1.19+.
               
               Supported list of database secrets engines that can be configured:
        :param _builtins.bool disconnect_sessions: Set to true to disconnect any open sessions prior to running the revocation statements.
        :param _builtins.int max_connection_lifetime: Maximum number of seconds a connection may be reused.
        :param _builtins.int max_idle_connections: Maximum number of idle connections to the database.
        :param _builtins.int max_open_connections: Maximum number of open connections to the database.
        :param _builtins.str password: The root credential password used in the connection URL
        :param _builtins.str password_wo: **NOTE:** This field is write-only and its value will not be updated in state as part of read operations.
               Write-only field for the root credential password used in the connection URL
        :param _builtins.int password_wo_version: Version counter for root credential password write-only field
        :param _builtins.str plugin_name: Specifies the name of the plugin to use.
        :param Sequence[_builtins.str] root_rotation_statements: A list of database statements to be executed to rotate the root user's credentials.
        :param _builtins.int rotation_period: The amount of time in seconds Vault should wait before rotating the root credential.
               A zero value tells Vault not to rotate the root credential. The minimum rotation period is 10 seconds. Requires Vault Enterprise 1.19+.
        :param _builtins.str rotation_schedule: The schedule, in [cron-style time format](https://en.wikipedia.org/wiki/Cron),
               defining the schedule on which Vault should rotate the root token. Requires Vault Enterprise 1.19+.
        :param _builtins.int rotation_window: The maximum amount of time in seconds allowed to complete
               a rotation when a scheduled token rotation occurs. The default rotation window is
               unbound and the minimum allowable window is `3600`. Requires Vault Enterprise 1.19+.
        :param _builtins.bool split_statements: Set to true in order to split statements after semi-colons.
        :param _builtins.str username: The root credential username used in the connection URL
        :param _builtins.str username_template: Username generation template.
        :param _builtins.bool verify_connection: Whether the connection should be verified on
               initial configuration or not.
        """
        pulumi.set(__self__, "name", name)
        if allowed_roles is not None:
            pulumi.set(__self__, "allowed_roles", allowed_roles)
        if connection_url is not None:
            pulumi.set(__self__, "connection_url", connection_url)
        if data is not None:
            pulumi.set(__self__, "data", data)
        if disable_automated_rotation is not None:
            pulumi.set(__self__, "disable_automated_rotation", disable_automated_rotation)
        if disconnect_sessions is not None:
            pulumi.set(__self__, "disconnect_sessions", disconnect_sessions)
        if max_connection_lifetime is not None:
            pulumi.set(__self__, "max_connection_lifetime", max_connection_lifetime)
        if max_idle_connections is not None:
            pulumi.set(__self__, "max_idle_connections", max_idle_connections)
        if max_open_connections is not None:
            pulumi.set(__self__, "max_open_connections", max_open_connections)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if password_wo is not None:
            pulumi.set(__self__, "password_wo", password_wo)
        if password_wo_version is not None:
            pulumi.set(__self__, "password_wo_version", password_wo_version)
        if plugin_name is not None:
            pulumi.set(__self__, "plugin_name", plugin_name)
        if root_rotation_statements is not None:
            pulumi.set(__self__, "root_rotation_statements", root_rotation_statements)
        if rotation_period is not None:
            pulumi.set(__self__, "rotation_period", rotation_period)
        if rotation_schedule is not None:
            pulumi.set(__self__, "rotation_schedule", rotation_schedule)
        if rotation_window is not None:
            pulumi.set(__self__, "rotation_window", rotation_window)
        if split_statements is not None:
            pulumi.set(__self__, "split_statements", split_statements)
        if username is not None:
            pulumi.set(__self__, "username", username)
        if username_template is not None:
            pulumi.set(__self__, "username_template", username_template)
        if verify_connection is not None:
            pulumi.set(__self__, "verify_connection", verify_connection)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the database connection.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="allowedRoles")
    def allowed_roles(self) -> Optional[Sequence[_builtins.str]]:
        """
        A list of roles that are allowed to use this
        connection.
        """
        return pulumi.get(self, "allowed_roles")

    @_builtins.property
    @pulumi.getter(name="connectionUrl")
    def connection_url(self) -> Optional[_builtins.str]:
        """
        Connection string to use to connect to the database.
        """
        return pulumi.get(self, "connection_url")

    @_builtins.property
    @pulumi.getter
    def data(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        A map of sensitive data to pass to the endpoint. Useful for templated connection strings.
        """
        return pulumi.get(self, "data")

    @_builtins.property
    @pulumi.getter(name="disableAutomatedRotation")
    def disable_automated_rotation(self) -> Optional[_builtins.bool]:
        """
        Cancels all upcoming rotations of the root credential until unset. Requires Vault Enterprise 1.19+.

        Supported list of database secrets engines that can be configured:
        """
        return pulumi.get(self, "disable_automated_rotation")

    @_builtins.property
    @pulumi.getter(name="disconnectSessions")
    def disconnect_sessions(self) -> Optional[_builtins.bool]:
        """
        Set to true to disconnect any open sessions prior to running the revocation statements.
        """
        return pulumi.get(self, "disconnect_sessions")

    @_builtins.property
    @pulumi.getter(name="maxConnectionLifetime")
    def max_connection_lifetime(self) -> Optional[_builtins.int]:
        """
        Maximum number of seconds a connection may be reused.
        """
        return pulumi.get(self, "max_connection_lifetime")

    @_builtins.property
    @pulumi.getter(name="maxIdleConnections")
    def max_idle_connections(self) -> Optional[_builtins.int]:
        """
        Maximum number of idle connections to the database.
        """
        return pulumi.get(self, "max_idle_connections")

    @_builtins.property
    @pulumi.getter(name="maxOpenConnections")
    def max_open_connections(self) -> Optional[_builtins.int]:
        """
        Maximum number of open connections to the database.
        """
        return pulumi.get(self, "max_open_connections")

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[_builtins.str]:
        """
        The root credential password used in the connection URL
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter(name="passwordWo")
    def password_wo(self) -> Optional[_builtins.str]:
        """
        **NOTE:** This field is write-only and its value will not be updated in state as part of read operations.
        Write-only field for the root credential password used in the connection URL
        """
        return pulumi.get(self, "password_wo")

    @_builtins.property
    @pulumi.getter(name="passwordWoVersion")
    def password_wo_version(self) -> Optional[_builtins.int]:
        """
        Version counter for root credential password write-only field
        """
        return pulumi.get(self, "password_wo_version")

    @_builtins.property
    @pulumi.getter(name="pluginName")
    def plugin_name(self) -> Optional[_builtins.str]:
        """
        Specifies the name of the plugin to use.
        """
        return pulumi.get(self, "plugin_name")

    @_builtins.property
    @pulumi.getter(name="rootRotationStatements")
    def root_rotation_statements(self) -> Optional[Sequence[_builtins.str]]:
        """
        A list of database statements to be executed to rotate the root user's credentials.
        """
        return pulumi.get(self, "root_rotation_statements")

    @_builtins.property
    @pulumi.getter(name="rotationPeriod")
    def rotation_period(self) -> Optional[_builtins.int]:
        """
        The amount of time in seconds Vault should wait before rotating the root credential.
        A zero value tells Vault not to rotate the root credential. The minimum rotation period is 10 seconds. Requires Vault Enterprise 1.19+.
        """
        return pulumi.get(self, "rotation_period")

    @_builtins.property
    @pulumi.getter(name="rotationSchedule")
    def rotation_schedule(self) -> Optional[_builtins.str]:
        """
        The schedule, in [cron-style time format](https://en.wikipedia.org/wiki/Cron),
        defining the schedule on which Vault should rotate the root token. Requires Vault Enterprise 1.19+.
        """
        return pulumi.get(self, "rotation_schedule")

    @_builtins.property
    @pulumi.getter(name="rotationWindow")
    def rotation_window(self) -> Optional[_builtins.int]:
        """
        The maximum amount of time in seconds allowed to complete
        a rotation when a scheduled token rotation occurs. The default rotation window is
        unbound and the minimum allowable window is `3600`. Requires Vault Enterprise 1.19+.
        """
        return pulumi.get(self, "rotation_window")

    @_builtins.property
    @pulumi.getter(name="splitStatements")
    def split_statements(self) -> Optional[_builtins.bool]:
        """
        Set to true in order to split statements after semi-colons.
        """
        return pulumi.get(self, "split_statements")

    @_builtins.property
    @pulumi.getter
    def username(self) -> Optional[_builtins.str]:
        """
        The root credential username used in the connection URL
        """
        return pulumi.get(self, "username")

    @_builtins.property
    @pulumi.getter(name="usernameTemplate")
    def username_template(self) -> Optional[_builtins.str]:
        """
        Username generation template.
        """
        return pulumi.get(self, "username_template")

    @_builtins.property
    @pulumi.getter(name="verifyConnection")
    def verify_connection(self) -> Optional[_builtins.bool]:
        """
        Whether the connection should be verified on
        initial configuration or not.
        """
        return pulumi.get(self, "verify_connection")


@pulumi.output_type
class SecretsMountPostgresql(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedRoles":
            suggest = "allowed_roles"
        elif key == "authType":
            suggest = "auth_type"
        elif key == "connectionUrl":
            suggest = "connection_url"
        elif key == "disableAutomatedRotation":
            suggest = "disable_automated_rotation"
        elif key == "disableEscaping":
            suggest = "disable_escaping"
        elif key == "maxConnectionLifetime":
            suggest = "max_connection_lifetime"
        elif key == "maxIdleConnections":
            suggest = "max_idle_connections"
        elif key == "maxOpenConnections":
            suggest = "max_open_connections"
        elif key == "passwordAuthentication":
            suggest = "password_authentication"
        elif key == "passwordWo":
            suggest = "password_wo"
        elif key == "passwordWoVersion":
            suggest = "password_wo_version"
        elif key == "pluginName":
            suggest = "plugin_name"
        elif key == "privateKey":
            suggest = "private_key"
        elif key == "rootRotationStatements":
            suggest = "root_rotation_statements"
        elif key == "rotationPeriod":
            suggest = "rotation_period"
        elif key == "rotationSchedule":
            suggest = "rotation_schedule"
        elif key == "rotationWindow":
            suggest = "rotation_window"
        elif key == "selfManaged":
            suggest = "self_managed"
        elif key == "serviceAccountJson":
            suggest = "service_account_json"
        elif key == "tlsCa":
            suggest = "tls_ca"
        elif key == "tlsCertificate":
            suggest = "tls_certificate"
        elif key == "usernameTemplate":
            suggest = "username_template"
        elif key == "verifyConnection":
            suggest = "verify_connection"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecretsMountPostgresql. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecretsMountPostgresql.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecretsMountPostgresql.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 allowed_roles: Optional[Sequence[_builtins.str]] = None,
                 auth_type: Optional[_builtins.str] = None,
                 connection_url: Optional[_builtins.str] = None,
                 data: Optional[Mapping[str, _builtins.str]] = None,
                 disable_automated_rotation: Optional[_builtins.bool] = None,
                 disable_escaping: Optional[_builtins.bool] = None,
                 max_connection_lifetime: Optional[_builtins.int] = None,
                 max_idle_connections: Optional[_builtins.int] = None,
                 max_open_connections: Optional[_builtins.int] = None,
                 password: Optional[_builtins.str] = None,
                 password_authentication: Optional[_builtins.str] = None,
                 password_wo: Optional[_builtins.str] = None,
                 password_wo_version: Optional[_builtins.int] = None,
                 plugin_name: Optional[_builtins.str] = None,
                 private_key: Optional[_builtins.str] = None,
                 root_rotation_statements: Optional[Sequence[_builtins.str]] = None,
                 rotation_period: Optional[_builtins.int] = None,
                 rotation_schedule: Optional[_builtins.str] = None,
                 rotation_window: Optional[_builtins.int] = None,
                 self_managed: Optional[_builtins.bool] = None,
                 service_account_json: Optional[_builtins.str] = None,
                 tls_ca: Optional[_builtins.str] = None,
                 tls_certificate: Optional[_builtins.str] = None,
                 username: Optional[_builtins.str] = None,
                 username_template: Optional[_builtins.str] = None,
                 verify_connection: Optional[_builtins.bool] = None):
        """
        :param _builtins.str name: Name of the database connection.
        :param Sequence[_builtins.str] allowed_roles: A list of roles that are allowed to use this
               connection.
        :param _builtins.str auth_type: Specify alternative authorization type. (Only 'gcp_iam' is valid currently)
        :param _builtins.str connection_url: Connection string to use to connect to the database.
        :param Mapping[str, _builtins.str] data: A map of sensitive data to pass to the endpoint. Useful for templated connection strings.
        :param _builtins.bool disable_automated_rotation: Cancels all upcoming rotations of the root credential until unset. Requires Vault Enterprise 1.19+.
               
               Supported list of database secrets engines that can be configured:
        :param _builtins.bool disable_escaping: Disable special character escaping in username and password
        :param _builtins.int max_connection_lifetime: Maximum number of seconds a connection may be reused.
        :param _builtins.int max_idle_connections: Maximum number of idle connections to the database.
        :param _builtins.int max_open_connections: Maximum number of open connections to the database.
        :param _builtins.str password: The root credential password used in the connection URL
        :param _builtins.str password_authentication: When set to `scram-sha-256`, passwords will be hashed by Vault before being sent to PostgreSQL.
        :param _builtins.str password_wo: **NOTE:** This field is write-only and its value will not be updated in state as part of read operations.
               Write-only field for the root credential password used in the connection URL
        :param _builtins.int password_wo_version: Version counter for root credential password write-only field
        :param _builtins.str plugin_name: Specifies the name of the plugin to use.
        :param _builtins.str private_key: The secret key used for the x509 client certificate. Must be PEM encoded.
        :param Sequence[_builtins.str] root_rotation_statements: A list of database statements to be executed to rotate the root user's credentials.
        :param _builtins.int rotation_period: The amount of time in seconds Vault should wait before rotating the root credential.
               A zero value tells Vault not to rotate the root credential. The minimum rotation period is 10 seconds. Requires Vault Enterprise 1.19+.
        :param _builtins.str rotation_schedule: The schedule, in [cron-style time format](https://en.wikipedia.org/wiki/Cron),
               defining the schedule on which Vault should rotate the root token. Requires Vault Enterprise 1.19+.
        :param _builtins.int rotation_window: The maximum amount of time in seconds allowed to complete
               a rotation when a scheduled token rotation occurs. The default rotation window is
               unbound and the minimum allowable window is `3600`. Requires Vault Enterprise 1.19+.
        :param _builtins.bool self_managed: If set, allows onboarding static roles with a rootless connection configuration.
        :param _builtins.str service_account_json: A JSON encoded credential for use with IAM authorization
        :param _builtins.str tls_ca: The x509 CA file for validating the certificate presented by the PostgreSQL server. Must be PEM encoded.
        :param _builtins.str tls_certificate: The x509 client certificate for connecting to the database. Must be PEM encoded.
        :param _builtins.str username: The root credential username used in the connection URL
        :param _builtins.str username_template: Username generation template.
        :param _builtins.bool verify_connection: Whether the connection should be verified on
               initial configuration or not.
        """
        pulumi.set(__self__, "name", name)
        if allowed_roles is not None:
            pulumi.set(__self__, "allowed_roles", allowed_roles)
        if auth_type is not None:
            pulumi.set(__self__, "auth_type", auth_type)
        if connection_url is not None:
            pulumi.set(__self__, "connection_url", connection_url)
        if data is not None:
            pulumi.set(__self__, "data", data)
        if disable_automated_rotation is not None:
            pulumi.set(__self__, "disable_automated_rotation", disable_automated_rotation)
        if disable_escaping is not None:
            pulumi.set(__self__, "disable_escaping", disable_escaping)
        if max_connection_lifetime is not None:
            pulumi.set(__self__, "max_connection_lifetime", max_connection_lifetime)
        if max_idle_connections is not None:
            pulumi.set(__self__, "max_idle_connections", max_idle_connections)
        if max_open_connections is not None:
            pulumi.set(__self__, "max_open_connections", max_open_connections)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if password_authentication is not None:
            pulumi.set(__self__, "password_authentication", password_authentication)
        if password_wo is not None:
            pulumi.set(__self__, "password_wo", password_wo)
        if password_wo_version is not None:
            pulumi.set(__self__, "password_wo_version", password_wo_version)
        if plugin_name is not None:
            pulumi.set(__self__, "plugin_name", plugin_name)
        if private_key is not None:
            pulumi.set(__self__, "private_key", private_key)
        if root_rotation_statements is not None:
            pulumi.set(__self__, "root_rotation_statements", root_rotation_statements)
        if rotation_period is not None:
            pulumi.set(__self__, "rotation_period", rotation_period)
        if rotation_schedule is not None:
            pulumi.set(__self__, "rotation_schedule", rotation_schedule)
        if rotation_window is not None:
            pulumi.set(__self__, "rotation_window", rotation_window)
        if self_managed is not None:
            pulumi.set(__self__, "self_managed", self_managed)
        if service_account_json is not None:
            pulumi.set(__self__, "service_account_json", service_account_json)
        if tls_ca is not None:
            pulumi.set(__self__, "tls_ca", tls_ca)
        if tls_certificate is not None:
            pulumi.set(__self__, "tls_certificate", tls_certificate)
        if username is not None:
            pulumi.set(__self__, "username", username)
        if username_template is not None:
            pulumi.set(__self__, "username_template", username_template)
        if verify_connection is not None:
            pulumi.set(__self__, "verify_connection", verify_connection)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the database connection.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="allowedRoles")
    def allowed_roles(self) -> Optional[Sequence[_builtins.str]]:
        """
        A list of roles that are allowed to use this
        connection.
        """
        return pulumi.get(self, "allowed_roles")

    @_builtins.property
    @pulumi.getter(name="authType")
    def auth_type(self) -> Optional[_builtins.str]:
        """
        Specify alternative authorization type. (Only 'gcp_iam' is valid currently)
        """
        return pulumi.get(self, "auth_type")

    @_builtins.property
    @pulumi.getter(name="connectionUrl")
    def connection_url(self) -> Optional[_builtins.str]:
        """
        Connection string to use to connect to the database.
        """
        return pulumi.get(self, "connection_url")

    @_builtins.property
    @pulumi.getter
    def data(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        A map of sensitive data to pass to the endpoint. Useful for templated connection strings.
        """
        return pulumi.get(self, "data")

    @_builtins.property
    @pulumi.getter(name="disableAutomatedRotation")
    def disable_automated_rotation(self) -> Optional[_builtins.bool]:
        """
        Cancels all upcoming rotations of the root credential until unset. Requires Vault Enterprise 1.19+.

        Supported list of database secrets engines that can be configured:
        """
        return pulumi.get(self, "disable_automated_rotation")

    @_builtins.property
    @pulumi.getter(name="disableEscaping")
    def disable_escaping(self) -> Optional[_builtins.bool]:
        """
        Disable special character escaping in username and password
        """
        return pulumi.get(self, "disable_escaping")

    @_builtins.property
    @pulumi.getter(name="maxConnectionLifetime")
    def max_connection_lifetime(self) -> Optional[_builtins.int]:
        """
        Maximum number of seconds a connection may be reused.
        """
        return pulumi.get(self, "max_connection_lifetime")

    @_builtins.property
    @pulumi.getter(name="maxIdleConnections")
    def max_idle_connections(self) -> Optional[_builtins.int]:
        """
        Maximum number of idle connections to the database.
        """
        return pulumi.get(self, "max_idle_connections")

    @_builtins.property
    @pulumi.getter(name="maxOpenConnections")
    def max_open_connections(self) -> Optional[_builtins.int]:
        """
        Maximum number of open connections to the database.
        """
        return pulumi.get(self, "max_open_connections")

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[_builtins.str]:
        """
        The root credential password used in the connection URL
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter(name="passwordAuthentication")
    def password_authentication(self) -> Optional[_builtins.str]:
        """
        When set to `scram-sha-256`, passwords will be hashed by Vault before being sent to PostgreSQL.
        """
        return pulumi.get(self, "password_authentication")

    @_builtins.property
    @pulumi.getter(name="passwordWo")
    def password_wo(self) -> Optional[_builtins.str]:
        """
        **NOTE:** This field is write-only and its value will not be updated in state as part of read operations.
        Write-only field for the root credential password used in the connection URL
        """
        return pulumi.get(self, "password_wo")

    @_builtins.property
    @pulumi.getter(name="passwordWoVersion")
    def password_wo_version(self) -> Optional[_builtins.int]:
        """
        Version counter for root credential password write-only field
        """
        return pulumi.get(self, "password_wo_version")

    @_builtins.property
    @pulumi.getter(name="pluginName")
    def plugin_name(self) -> Optional[_builtins.str]:
        """
        Specifies the name of the plugin to use.
        """
        return pulumi.get(self, "plugin_name")

    @_builtins.property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> Optional[_builtins.str]:
        """
        The secret key used for the x509 client certificate. Must be PEM encoded.
        """
        return pulumi.get(self, "private_key")

    @_builtins.property
    @pulumi.getter(name="rootRotationStatements")
    def root_rotation_statements(self) -> Optional[Sequence[_builtins.str]]:
        """
        A list of database statements to be executed to rotate the root user's credentials.
        """
        return pulumi.get(self, "root_rotation_statements")

    @_builtins.property
    @pulumi.getter(name="rotationPeriod")
    def rotation_period(self) -> Optional[_builtins.int]:
        """
        The amount of time in seconds Vault should wait before rotating the root credential.
        A zero value tells Vault not to rotate the root credential. The minimum rotation period is 10 seconds. Requires Vault Enterprise 1.19+.
        """
        return pulumi.get(self, "rotation_period")

    @_builtins.property
    @pulumi.getter(name="rotationSchedule")
    def rotation_schedule(self) -> Optional[_builtins.str]:
        """
        The schedule, in [cron-style time format](https://en.wikipedia.org/wiki/Cron),
        defining the schedule on which Vault should rotate the root token. Requires Vault Enterprise 1.19+.
        """
        return pulumi.get(self, "rotation_schedule")

    @_builtins.property
    @pulumi.getter(name="rotationWindow")
    def rotation_window(self) -> Optional[_builtins.int]:
        """
        The maximum amount of time in seconds allowed to complete
        a rotation when a scheduled token rotation occurs. The default rotation window is
        unbound and the minimum allowable window is `3600`. Requires Vault Enterprise 1.19+.
        """
        return pulumi.get(self, "rotation_window")

    @_builtins.property
    @pulumi.getter(name="selfManaged")
    def self_managed(self) -> Optional[_builtins.bool]:
        """
        If set, allows onboarding static roles with a rootless connection configuration.
        """
        return pulumi.get(self, "self_managed")

    @_builtins.property
    @pulumi.getter(name="serviceAccountJson")
    def service_account_json(self) -> Optional[_builtins.str]:
        """
        A JSON encoded credential for use with IAM authorization
        """
        return pulumi.get(self, "service_account_json")

    @_builtins.property
    @pulumi.getter(name="tlsCa")
    def tls_ca(self) -> Optional[_builtins.str]:
        """
        The x509 CA file for validating the certificate presented by the PostgreSQL server. Must be PEM encoded.
        """
        return pulumi.get(self, "tls_ca")

    @_builtins.property
    @pulumi.getter(name="tlsCertificate")
    def tls_certificate(self) -> Optional[_builtins.str]:
        """
        The x509 client certificate for connecting to the database. Must be PEM encoded.
        """
        return pulumi.get(self, "tls_certificate")

    @_builtins.property
    @pulumi.getter
    def username(self) -> Optional[_builtins.str]:
        """
        The root credential username used in the connection URL
        """
        return pulumi.get(self, "username")

    @_builtins.property
    @pulumi.getter(name="usernameTemplate")
    def username_template(self) -> Optional[_builtins.str]:
        """
        Username generation template.
        """
        return pulumi.get(self, "username_template")

    @_builtins.property
    @pulumi.getter(name="verifyConnection")
    def verify_connection(self) -> Optional[_builtins.bool]:
        """
        Whether the connection should be verified on
        initial configuration or not.
        """
        return pulumi.get(self, "verify_connection")


@pulumi.output_type
class SecretsMountRedi(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedRoles":
            suggest = "allowed_roles"
        elif key == "caCert":
            suggest = "ca_cert"
        elif key == "disableAutomatedRotation":
            suggest = "disable_automated_rotation"
        elif key == "insecureTls":
            suggest = "insecure_tls"
        elif key == "pluginName":
            suggest = "plugin_name"
        elif key == "rootRotationStatements":
            suggest = "root_rotation_statements"
        elif key == "rotationPeriod":
            suggest = "rotation_period"
        elif key == "rotationSchedule":
            suggest = "rotation_schedule"
        elif key == "rotationWindow":
            suggest = "rotation_window"
        elif key == "verifyConnection":
            suggest = "verify_connection"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecretsMountRedi. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecretsMountRedi.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecretsMountRedi.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 host: _builtins.str,
                 name: _builtins.str,
                 password: _builtins.str,
                 username: _builtins.str,
                 allowed_roles: Optional[Sequence[_builtins.str]] = None,
                 ca_cert: Optional[_builtins.str] = None,
                 data: Optional[Mapping[str, _builtins.str]] = None,
                 disable_automated_rotation: Optional[_builtins.bool] = None,
                 insecure_tls: Optional[_builtins.bool] = None,
                 plugin_name: Optional[_builtins.str] = None,
                 port: Optional[_builtins.int] = None,
                 root_rotation_statements: Optional[Sequence[_builtins.str]] = None,
                 rotation_period: Optional[_builtins.int] = None,
                 rotation_schedule: Optional[_builtins.str] = None,
                 rotation_window: Optional[_builtins.int] = None,
                 tls: Optional[_builtins.bool] = None,
                 verify_connection: Optional[_builtins.bool] = None):
        """
        :param _builtins.str host: Specifies the host to connect to
        :param _builtins.str name: Name of the database connection.
        :param _builtins.str password: Specifies the password corresponding to the given username.
        :param _builtins.str username: Specifies the username for Vault to use.
        :param Sequence[_builtins.str] allowed_roles: A list of roles that are allowed to use this
               connection.
        :param _builtins.str ca_cert: The contents of a PEM-encoded CA cert file to use to verify the Redis server's identity.
        :param Mapping[str, _builtins.str] data: A map of sensitive data to pass to the endpoint. Useful for templated connection strings.
        :param _builtins.bool disable_automated_rotation: Cancels all upcoming rotations of the root credential until unset. Requires Vault Enterprise 1.19+.
               
               Supported list of database secrets engines that can be configured:
        :param _builtins.bool insecure_tls: Specifies whether to skip verification of the server certificate when using TLS.
        :param _builtins.str plugin_name: Specifies the name of the plugin to use.
        :param _builtins.int port: The transport port to use to connect to Redis.
        :param Sequence[_builtins.str] root_rotation_statements: A list of database statements to be executed to rotate the root user's credentials.
        :param _builtins.int rotation_period: The amount of time in seconds Vault should wait before rotating the root credential.
               A zero value tells Vault not to rotate the root credential. The minimum rotation period is 10 seconds. Requires Vault Enterprise 1.19+.
        :param _builtins.str rotation_schedule: The schedule, in [cron-style time format](https://en.wikipedia.org/wiki/Cron),
               defining the schedule on which Vault should rotate the root token. Requires Vault Enterprise 1.19+.
        :param _builtins.int rotation_window: The maximum amount of time in seconds allowed to complete
               a rotation when a scheduled token rotation occurs. The default rotation window is
               unbound and the minimum allowable window is `3600`. Requires Vault Enterprise 1.19+.
        :param _builtins.bool tls: Specifies whether to use TLS when connecting to Redis.
        :param _builtins.bool verify_connection: Whether the connection should be verified on
               initial configuration or not.
        """
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "username", username)
        if allowed_roles is not None:
            pulumi.set(__self__, "allowed_roles", allowed_roles)
        if ca_cert is not None:
            pulumi.set(__self__, "ca_cert", ca_cert)
        if data is not None:
            pulumi.set(__self__, "data", data)
        if disable_automated_rotation is not None:
            pulumi.set(__self__, "disable_automated_rotation", disable_automated_rotation)
        if insecure_tls is not None:
            pulumi.set(__self__, "insecure_tls", insecure_tls)
        if plugin_name is not None:
            pulumi.set(__self__, "plugin_name", plugin_name)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if root_rotation_statements is not None:
            pulumi.set(__self__, "root_rotation_statements", root_rotation_statements)
        if rotation_period is not None:
            pulumi.set(__self__, "rotation_period", rotation_period)
        if rotation_schedule is not None:
            pulumi.set(__self__, "rotation_schedule", rotation_schedule)
        if rotation_window is not None:
            pulumi.set(__self__, "rotation_window", rotation_window)
        if tls is not None:
            pulumi.set(__self__, "tls", tls)
        if verify_connection is not None:
            pulumi.set(__self__, "verify_connection", verify_connection)

    @_builtins.property
    @pulumi.getter
    def host(self) -> _builtins.str:
        """
        Specifies the host to connect to
        """
        return pulumi.get(self, "host")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the database connection.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def password(self) -> _builtins.str:
        """
        Specifies the password corresponding to the given username.
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter
    def username(self) -> _builtins.str:
        """
        Specifies the username for Vault to use.
        """
        return pulumi.get(self, "username")

    @_builtins.property
    @pulumi.getter(name="allowedRoles")
    def allowed_roles(self) -> Optional[Sequence[_builtins.str]]:
        """
        A list of roles that are allowed to use this
        connection.
        """
        return pulumi.get(self, "allowed_roles")

    @_builtins.property
    @pulumi.getter(name="caCert")
    def ca_cert(self) -> Optional[_builtins.str]:
        """
        The contents of a PEM-encoded CA cert file to use to verify the Redis server's identity.
        """
        return pulumi.get(self, "ca_cert")

    @_builtins.property
    @pulumi.getter
    def data(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        A map of sensitive data to pass to the endpoint. Useful for templated connection strings.
        """
        return pulumi.get(self, "data")

    @_builtins.property
    @pulumi.getter(name="disableAutomatedRotation")
    def disable_automated_rotation(self) -> Optional[_builtins.bool]:
        """
        Cancels all upcoming rotations of the root credential until unset. Requires Vault Enterprise 1.19+.

        Supported list of database secrets engines that can be configured:
        """
        return pulumi.get(self, "disable_automated_rotation")

    @_builtins.property
    @pulumi.getter(name="insecureTls")
    def insecure_tls(self) -> Optional[_builtins.bool]:
        """
        Specifies whether to skip verification of the server certificate when using TLS.
        """
        return pulumi.get(self, "insecure_tls")

    @_builtins.property
    @pulumi.getter(name="pluginName")
    def plugin_name(self) -> Optional[_builtins.str]:
        """
        Specifies the name of the plugin to use.
        """
        return pulumi.get(self, "plugin_name")

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[_builtins.int]:
        """
        The transport port to use to connect to Redis.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="rootRotationStatements")
    def root_rotation_statements(self) -> Optional[Sequence[_builtins.str]]:
        """
        A list of database statements to be executed to rotate the root user's credentials.
        """
        return pulumi.get(self, "root_rotation_statements")

    @_builtins.property
    @pulumi.getter(name="rotationPeriod")
    def rotation_period(self) -> Optional[_builtins.int]:
        """
        The amount of time in seconds Vault should wait before rotating the root credential.
        A zero value tells Vault not to rotate the root credential. The minimum rotation period is 10 seconds. Requires Vault Enterprise 1.19+.
        """
        return pulumi.get(self, "rotation_period")

    @_builtins.property
    @pulumi.getter(name="rotationSchedule")
    def rotation_schedule(self) -> Optional[_builtins.str]:
        """
        The schedule, in [cron-style time format](https://en.wikipedia.org/wiki/Cron),
        defining the schedule on which Vault should rotate the root token. Requires Vault Enterprise 1.19+.
        """
        return pulumi.get(self, "rotation_schedule")

    @_builtins.property
    @pulumi.getter(name="rotationWindow")
    def rotation_window(self) -> Optional[_builtins.int]:
        """
        The maximum amount of time in seconds allowed to complete
        a rotation when a scheduled token rotation occurs. The default rotation window is
        unbound and the minimum allowable window is `3600`. Requires Vault Enterprise 1.19+.
        """
        return pulumi.get(self, "rotation_window")

    @_builtins.property
    @pulumi.getter
    def tls(self) -> Optional[_builtins.bool]:
        """
        Specifies whether to use TLS when connecting to Redis.
        """
        return pulumi.get(self, "tls")

    @_builtins.property
    @pulumi.getter(name="verifyConnection")
    def verify_connection(self) -> Optional[_builtins.bool]:
        """
        Whether the connection should be verified on
        initial configuration or not.
        """
        return pulumi.get(self, "verify_connection")


@pulumi.output_type
class SecretsMountRedisElasticach(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedRoles":
            suggest = "allowed_roles"
        elif key == "disableAutomatedRotation":
            suggest = "disable_automated_rotation"
        elif key == "pluginName":
            suggest = "plugin_name"
        elif key == "rootRotationStatements":
            suggest = "root_rotation_statements"
        elif key == "rotationPeriod":
            suggest = "rotation_period"
        elif key == "rotationSchedule":
            suggest = "rotation_schedule"
        elif key == "rotationWindow":
            suggest = "rotation_window"
        elif key == "verifyConnection":
            suggest = "verify_connection"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecretsMountRedisElasticach. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecretsMountRedisElasticach.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecretsMountRedisElasticach.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 url: _builtins.str,
                 allowed_roles: Optional[Sequence[_builtins.str]] = None,
                 data: Optional[Mapping[str, _builtins.str]] = None,
                 disable_automated_rotation: Optional[_builtins.bool] = None,
                 password: Optional[_builtins.str] = None,
                 plugin_name: Optional[_builtins.str] = None,
                 region: Optional[_builtins.str] = None,
                 root_rotation_statements: Optional[Sequence[_builtins.str]] = None,
                 rotation_period: Optional[_builtins.int] = None,
                 rotation_schedule: Optional[_builtins.str] = None,
                 rotation_window: Optional[_builtins.int] = None,
                 username: Optional[_builtins.str] = None,
                 verify_connection: Optional[_builtins.bool] = None):
        """
        :param _builtins.str name: Name of the database connection.
        :param _builtins.str url: The configuration endpoint for the ElastiCache cluster to connect to.
        :param Sequence[_builtins.str] allowed_roles: A list of roles that are allowed to use this
               connection.
        :param Mapping[str, _builtins.str] data: A map of sensitive data to pass to the endpoint. Useful for templated connection strings.
        :param _builtins.bool disable_automated_rotation: Cancels all upcoming rotations of the root credential until unset. Requires Vault Enterprise 1.19+.
               
               Supported list of database secrets engines that can be configured:
        :param _builtins.str password: The AWS secret key id to use to talk to ElastiCache. If omitted the credentials chain provider is used instead.
        :param _builtins.str plugin_name: Specifies the name of the plugin to use.
        :param _builtins.str region: The AWS region where the ElastiCache cluster is hosted. If omitted the plugin tries to infer the region from the environment.
        :param Sequence[_builtins.str] root_rotation_statements: A list of database statements to be executed to rotate the root user's credentials.
        :param _builtins.int rotation_period: The amount of time in seconds Vault should wait before rotating the root credential.
               A zero value tells Vault not to rotate the root credential. The minimum rotation period is 10 seconds. Requires Vault Enterprise 1.19+.
        :param _builtins.str rotation_schedule: The schedule, in [cron-style time format](https://en.wikipedia.org/wiki/Cron),
               defining the schedule on which Vault should rotate the root token. Requires Vault Enterprise 1.19+.
        :param _builtins.int rotation_window: The maximum amount of time in seconds allowed to complete
               a rotation when a scheduled token rotation occurs. The default rotation window is
               unbound and the minimum allowable window is `3600`. Requires Vault Enterprise 1.19+.
        :param _builtins.str username: The AWS access key id to use to talk to ElastiCache. If omitted the credentials chain provider is used instead.
        :param _builtins.bool verify_connection: Whether the connection should be verified on
               initial configuration or not.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "url", url)
        if allowed_roles is not None:
            pulumi.set(__self__, "allowed_roles", allowed_roles)
        if data is not None:
            pulumi.set(__self__, "data", data)
        if disable_automated_rotation is not None:
            pulumi.set(__self__, "disable_automated_rotation", disable_automated_rotation)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if plugin_name is not None:
            pulumi.set(__self__, "plugin_name", plugin_name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if root_rotation_statements is not None:
            pulumi.set(__self__, "root_rotation_statements", root_rotation_statements)
        if rotation_period is not None:
            pulumi.set(__self__, "rotation_period", rotation_period)
        if rotation_schedule is not None:
            pulumi.set(__self__, "rotation_schedule", rotation_schedule)
        if rotation_window is not None:
            pulumi.set(__self__, "rotation_window", rotation_window)
        if username is not None:
            pulumi.set(__self__, "username", username)
        if verify_connection is not None:
            pulumi.set(__self__, "verify_connection", verify_connection)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the database connection.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def url(self) -> _builtins.str:
        """
        The configuration endpoint for the ElastiCache cluster to connect to.
        """
        return pulumi.get(self, "url")

    @_builtins.property
    @pulumi.getter(name="allowedRoles")
    def allowed_roles(self) -> Optional[Sequence[_builtins.str]]:
        """
        A list of roles that are allowed to use this
        connection.
        """
        return pulumi.get(self, "allowed_roles")

    @_builtins.property
    @pulumi.getter
    def data(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        A map of sensitive data to pass to the endpoint. Useful for templated connection strings.
        """
        return pulumi.get(self, "data")

    @_builtins.property
    @pulumi.getter(name="disableAutomatedRotation")
    def disable_automated_rotation(self) -> Optional[_builtins.bool]:
        """
        Cancels all upcoming rotations of the root credential until unset. Requires Vault Enterprise 1.19+.

        Supported list of database secrets engines that can be configured:
        """
        return pulumi.get(self, "disable_automated_rotation")

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[_builtins.str]:
        """
        The AWS secret key id to use to talk to ElastiCache. If omitted the credentials chain provider is used instead.
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter(name="pluginName")
    def plugin_name(self) -> Optional[_builtins.str]:
        """
        Specifies the name of the plugin to use.
        """
        return pulumi.get(self, "plugin_name")

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[_builtins.str]:
        """
        The AWS region where the ElastiCache cluster is hosted. If omitted the plugin tries to infer the region from the environment.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="rootRotationStatements")
    def root_rotation_statements(self) -> Optional[Sequence[_builtins.str]]:
        """
        A list of database statements to be executed to rotate the root user's credentials.
        """
        return pulumi.get(self, "root_rotation_statements")

    @_builtins.property
    @pulumi.getter(name="rotationPeriod")
    def rotation_period(self) -> Optional[_builtins.int]:
        """
        The amount of time in seconds Vault should wait before rotating the root credential.
        A zero value tells Vault not to rotate the root credential. The minimum rotation period is 10 seconds. Requires Vault Enterprise 1.19+.
        """
        return pulumi.get(self, "rotation_period")

    @_builtins.property
    @pulumi.getter(name="rotationSchedule")
    def rotation_schedule(self) -> Optional[_builtins.str]:
        """
        The schedule, in [cron-style time format](https://en.wikipedia.org/wiki/Cron),
        defining the schedule on which Vault should rotate the root token. Requires Vault Enterprise 1.19+.
        """
        return pulumi.get(self, "rotation_schedule")

    @_builtins.property
    @pulumi.getter(name="rotationWindow")
    def rotation_window(self) -> Optional[_builtins.int]:
        """
        The maximum amount of time in seconds allowed to complete
        a rotation when a scheduled token rotation occurs. The default rotation window is
        unbound and the minimum allowable window is `3600`. Requires Vault Enterprise 1.19+.
        """
        return pulumi.get(self, "rotation_window")

    @_builtins.property
    @pulumi.getter
    def username(self) -> Optional[_builtins.str]:
        """
        The AWS access key id to use to talk to ElastiCache. If omitted the credentials chain provider is used instead.
        """
        return pulumi.get(self, "username")

    @_builtins.property
    @pulumi.getter(name="verifyConnection")
    def verify_connection(self) -> Optional[_builtins.bool]:
        """
        Whether the connection should be verified on
        initial configuration or not.
        """
        return pulumi.get(self, "verify_connection")


@pulumi.output_type
class SecretsMountRedshift(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedRoles":
            suggest = "allowed_roles"
        elif key == "connectionUrl":
            suggest = "connection_url"
        elif key == "disableAutomatedRotation":
            suggest = "disable_automated_rotation"
        elif key == "disableEscaping":
            suggest = "disable_escaping"
        elif key == "maxConnectionLifetime":
            suggest = "max_connection_lifetime"
        elif key == "maxIdleConnections":
            suggest = "max_idle_connections"
        elif key == "maxOpenConnections":
            suggest = "max_open_connections"
        elif key == "passwordWo":
            suggest = "password_wo"
        elif key == "passwordWoVersion":
            suggest = "password_wo_version"
        elif key == "pluginName":
            suggest = "plugin_name"
        elif key == "rootRotationStatements":
            suggest = "root_rotation_statements"
        elif key == "rotationPeriod":
            suggest = "rotation_period"
        elif key == "rotationSchedule":
            suggest = "rotation_schedule"
        elif key == "rotationWindow":
            suggest = "rotation_window"
        elif key == "usernameTemplate":
            suggest = "username_template"
        elif key == "verifyConnection":
            suggest = "verify_connection"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecretsMountRedshift. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecretsMountRedshift.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecretsMountRedshift.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 allowed_roles: Optional[Sequence[_builtins.str]] = None,
                 connection_url: Optional[_builtins.str] = None,
                 data: Optional[Mapping[str, _builtins.str]] = None,
                 disable_automated_rotation: Optional[_builtins.bool] = None,
                 disable_escaping: Optional[_builtins.bool] = None,
                 max_connection_lifetime: Optional[_builtins.int] = None,
                 max_idle_connections: Optional[_builtins.int] = None,
                 max_open_connections: Optional[_builtins.int] = None,
                 password: Optional[_builtins.str] = None,
                 password_wo: Optional[_builtins.str] = None,
                 password_wo_version: Optional[_builtins.int] = None,
                 plugin_name: Optional[_builtins.str] = None,
                 root_rotation_statements: Optional[Sequence[_builtins.str]] = None,
                 rotation_period: Optional[_builtins.int] = None,
                 rotation_schedule: Optional[_builtins.str] = None,
                 rotation_window: Optional[_builtins.int] = None,
                 username: Optional[_builtins.str] = None,
                 username_template: Optional[_builtins.str] = None,
                 verify_connection: Optional[_builtins.bool] = None):
        """
        :param _builtins.str name: Name of the database connection.
        :param Sequence[_builtins.str] allowed_roles: A list of roles that are allowed to use this
               connection.
        :param _builtins.str connection_url: Connection string to use to connect to the database.
        :param Mapping[str, _builtins.str] data: A map of sensitive data to pass to the endpoint. Useful for templated connection strings.
        :param _builtins.bool disable_automated_rotation: Cancels all upcoming rotations of the root credential until unset. Requires Vault Enterprise 1.19+.
               
               Supported list of database secrets engines that can be configured:
        :param _builtins.bool disable_escaping: Disable special character escaping in username and password
        :param _builtins.int max_connection_lifetime: Maximum number of seconds a connection may be reused.
        :param _builtins.int max_idle_connections: Maximum number of idle connections to the database.
        :param _builtins.int max_open_connections: Maximum number of open connections to the database.
        :param _builtins.str password: The root credential password used in the connection URL
        :param _builtins.str password_wo: **NOTE:** This field is write-only and its value will not be updated in state as part of read operations.
               Write-only field for the root credential password used in the connection URL
        :param _builtins.int password_wo_version: Version counter for root credential password write-only field
        :param _builtins.str plugin_name: Specifies the name of the plugin to use.
        :param Sequence[_builtins.str] root_rotation_statements: A list of database statements to be executed to rotate the root user's credentials.
        :param _builtins.int rotation_period: The amount of time in seconds Vault should wait before rotating the root credential.
               A zero value tells Vault not to rotate the root credential. The minimum rotation period is 10 seconds. Requires Vault Enterprise 1.19+.
        :param _builtins.str rotation_schedule: The schedule, in [cron-style time format](https://en.wikipedia.org/wiki/Cron),
               defining the schedule on which Vault should rotate the root token. Requires Vault Enterprise 1.19+.
        :param _builtins.int rotation_window: The maximum amount of time in seconds allowed to complete
               a rotation when a scheduled token rotation occurs. The default rotation window is
               unbound and the minimum allowable window is `3600`. Requires Vault Enterprise 1.19+.
        :param _builtins.str username: The root credential username used in the connection URL
        :param _builtins.str username_template: Username generation template.
        :param _builtins.bool verify_connection: Whether the connection should be verified on
               initial configuration or not.
        """
        pulumi.set(__self__, "name", name)
        if allowed_roles is not None:
            pulumi.set(__self__, "allowed_roles", allowed_roles)
        if connection_url is not None:
            pulumi.set(__self__, "connection_url", connection_url)
        if data is not None:
            pulumi.set(__self__, "data", data)
        if disable_automated_rotation is not None:
            pulumi.set(__self__, "disable_automated_rotation", disable_automated_rotation)
        if disable_escaping is not None:
            pulumi.set(__self__, "disable_escaping", disable_escaping)
        if max_connection_lifetime is not None:
            pulumi.set(__self__, "max_connection_lifetime", max_connection_lifetime)
        if max_idle_connections is not None:
            pulumi.set(__self__, "max_idle_connections", max_idle_connections)
        if max_open_connections is not None:
            pulumi.set(__self__, "max_open_connections", max_open_connections)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if password_wo is not None:
            pulumi.set(__self__, "password_wo", password_wo)
        if password_wo_version is not None:
            pulumi.set(__self__, "password_wo_version", password_wo_version)
        if plugin_name is not None:
            pulumi.set(__self__, "plugin_name", plugin_name)
        if root_rotation_statements is not None:
            pulumi.set(__self__, "root_rotation_statements", root_rotation_statements)
        if rotation_period is not None:
            pulumi.set(__self__, "rotation_period", rotation_period)
        if rotation_schedule is not None:
            pulumi.set(__self__, "rotation_schedule", rotation_schedule)
        if rotation_window is not None:
            pulumi.set(__self__, "rotation_window", rotation_window)
        if username is not None:
            pulumi.set(__self__, "username", username)
        if username_template is not None:
            pulumi.set(__self__, "username_template", username_template)
        if verify_connection is not None:
            pulumi.set(__self__, "verify_connection", verify_connection)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the database connection.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="allowedRoles")
    def allowed_roles(self) -> Optional[Sequence[_builtins.str]]:
        """
        A list of roles that are allowed to use this
        connection.
        """
        return pulumi.get(self, "allowed_roles")

    @_builtins.property
    @pulumi.getter(name="connectionUrl")
    def connection_url(self) -> Optional[_builtins.str]:
        """
        Connection string to use to connect to the database.
        """
        return pulumi.get(self, "connection_url")

    @_builtins.property
    @pulumi.getter
    def data(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        A map of sensitive data to pass to the endpoint. Useful for templated connection strings.
        """
        return pulumi.get(self, "data")

    @_builtins.property
    @pulumi.getter(name="disableAutomatedRotation")
    def disable_automated_rotation(self) -> Optional[_builtins.bool]:
        """
        Cancels all upcoming rotations of the root credential until unset. Requires Vault Enterprise 1.19+.

        Supported list of database secrets engines that can be configured:
        """
        return pulumi.get(self, "disable_automated_rotation")

    @_builtins.property
    @pulumi.getter(name="disableEscaping")
    def disable_escaping(self) -> Optional[_builtins.bool]:
        """
        Disable special character escaping in username and password
        """
        return pulumi.get(self, "disable_escaping")

    @_builtins.property
    @pulumi.getter(name="maxConnectionLifetime")
    def max_connection_lifetime(self) -> Optional[_builtins.int]:
        """
        Maximum number of seconds a connection may be reused.
        """
        return pulumi.get(self, "max_connection_lifetime")

    @_builtins.property
    @pulumi.getter(name="maxIdleConnections")
    def max_idle_connections(self) -> Optional[_builtins.int]:
        """
        Maximum number of idle connections to the database.
        """
        return pulumi.get(self, "max_idle_connections")

    @_builtins.property
    @pulumi.getter(name="maxOpenConnections")
    def max_open_connections(self) -> Optional[_builtins.int]:
        """
        Maximum number of open connections to the database.
        """
        return pulumi.get(self, "max_open_connections")

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[_builtins.str]:
        """
        The root credential password used in the connection URL
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter(name="passwordWo")
    def password_wo(self) -> Optional[_builtins.str]:
        """
        **NOTE:** This field is write-only and its value will not be updated in state as part of read operations.
        Write-only field for the root credential password used in the connection URL
        """
        return pulumi.get(self, "password_wo")

    @_builtins.property
    @pulumi.getter(name="passwordWoVersion")
    def password_wo_version(self) -> Optional[_builtins.int]:
        """
        Version counter for root credential password write-only field
        """
        return pulumi.get(self, "password_wo_version")

    @_builtins.property
    @pulumi.getter(name="pluginName")
    def plugin_name(self) -> Optional[_builtins.str]:
        """
        Specifies the name of the plugin to use.
        """
        return pulumi.get(self, "plugin_name")

    @_builtins.property
    @pulumi.getter(name="rootRotationStatements")
    def root_rotation_statements(self) -> Optional[Sequence[_builtins.str]]:
        """
        A list of database statements to be executed to rotate the root user's credentials.
        """
        return pulumi.get(self, "root_rotation_statements")

    @_builtins.property
    @pulumi.getter(name="rotationPeriod")
    def rotation_period(self) -> Optional[_builtins.int]:
        """
        The amount of time in seconds Vault should wait before rotating the root credential.
        A zero value tells Vault not to rotate the root credential. The minimum rotation period is 10 seconds. Requires Vault Enterprise 1.19+.
        """
        return pulumi.get(self, "rotation_period")

    @_builtins.property
    @pulumi.getter(name="rotationSchedule")
    def rotation_schedule(self) -> Optional[_builtins.str]:
        """
        The schedule, in [cron-style time format](https://en.wikipedia.org/wiki/Cron),
        defining the schedule on which Vault should rotate the root token. Requires Vault Enterprise 1.19+.
        """
        return pulumi.get(self, "rotation_schedule")

    @_builtins.property
    @pulumi.getter(name="rotationWindow")
    def rotation_window(self) -> Optional[_builtins.int]:
        """
        The maximum amount of time in seconds allowed to complete
        a rotation when a scheduled token rotation occurs. The default rotation window is
        unbound and the minimum allowable window is `3600`. Requires Vault Enterprise 1.19+.
        """
        return pulumi.get(self, "rotation_window")

    @_builtins.property
    @pulumi.getter
    def username(self) -> Optional[_builtins.str]:
        """
        The root credential username used in the connection URL
        """
        return pulumi.get(self, "username")

    @_builtins.property
    @pulumi.getter(name="usernameTemplate")
    def username_template(self) -> Optional[_builtins.str]:
        """
        Username generation template.
        """
        return pulumi.get(self, "username_template")

    @_builtins.property
    @pulumi.getter(name="verifyConnection")
    def verify_connection(self) -> Optional[_builtins.bool]:
        """
        Whether the connection should be verified on
        initial configuration or not.
        """
        return pulumi.get(self, "verify_connection")


@pulumi.output_type
class SecretsMountSnowflake(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedRoles":
            suggest = "allowed_roles"
        elif key == "connectionUrl":
            suggest = "connection_url"
        elif key == "disableAutomatedRotation":
            suggest = "disable_automated_rotation"
        elif key == "maxConnectionLifetime":
            suggest = "max_connection_lifetime"
        elif key == "maxIdleConnections":
            suggest = "max_idle_connections"
        elif key == "maxOpenConnections":
            suggest = "max_open_connections"
        elif key == "passwordWo":
            suggest = "password_wo"
        elif key == "passwordWoVersion":
            suggest = "password_wo_version"
        elif key == "pluginName":
            suggest = "plugin_name"
        elif key == "privateKeyWo":
            suggest = "private_key_wo"
        elif key == "privateKeyWoVersion":
            suggest = "private_key_wo_version"
        elif key == "rootRotationStatements":
            suggest = "root_rotation_statements"
        elif key == "rotationPeriod":
            suggest = "rotation_period"
        elif key == "rotationSchedule":
            suggest = "rotation_schedule"
        elif key == "rotationWindow":
            suggest = "rotation_window"
        elif key == "usernameTemplate":
            suggest = "username_template"
        elif key == "verifyConnection":
            suggest = "verify_connection"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecretsMountSnowflake. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecretsMountSnowflake.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecretsMountSnowflake.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 allowed_roles: Optional[Sequence[_builtins.str]] = None,
                 connection_url: Optional[_builtins.str] = None,
                 data: Optional[Mapping[str, _builtins.str]] = None,
                 disable_automated_rotation: Optional[_builtins.bool] = None,
                 max_connection_lifetime: Optional[_builtins.int] = None,
                 max_idle_connections: Optional[_builtins.int] = None,
                 max_open_connections: Optional[_builtins.int] = None,
                 password: Optional[_builtins.str] = None,
                 password_wo: Optional[_builtins.str] = None,
                 password_wo_version: Optional[_builtins.int] = None,
                 plugin_name: Optional[_builtins.str] = None,
                 private_key_wo: Optional[_builtins.str] = None,
                 private_key_wo_version: Optional[_builtins.int] = None,
                 root_rotation_statements: Optional[Sequence[_builtins.str]] = None,
                 rotation_period: Optional[_builtins.int] = None,
                 rotation_schedule: Optional[_builtins.str] = None,
                 rotation_window: Optional[_builtins.int] = None,
                 username: Optional[_builtins.str] = None,
                 username_template: Optional[_builtins.str] = None,
                 verify_connection: Optional[_builtins.bool] = None):
        """
        :param _builtins.str name: Name of the database connection.
        :param Sequence[_builtins.str] allowed_roles: A list of roles that are allowed to use this
               connection.
        :param _builtins.str connection_url: Connection string to use to connect to the database.
        :param Mapping[str, _builtins.str] data: A map of sensitive data to pass to the endpoint. Useful for templated connection strings.
        :param _builtins.bool disable_automated_rotation: Cancels all upcoming rotations of the root credential until unset. Requires Vault Enterprise 1.19+.
               
               Supported list of database secrets engines that can be configured:
        :param _builtins.int max_connection_lifetime: Maximum number of seconds a connection may be reused.
        :param _builtins.int max_idle_connections: Maximum number of idle connections to the database.
        :param _builtins.int max_open_connections: Maximum number of open connections to the database.
        :param _builtins.str password: The root credential password used in the connection URL
        :param _builtins.str password_wo: **NOTE:** This field is write-only and its value will not be updated in state as part of read operations.
               Write-only field for the root credential password used in the connection URL
        :param _builtins.int password_wo_version: Version counter for root credential password write-only field
        :param _builtins.str plugin_name: Specifies the name of the plugin to use.
        :param _builtins.str private_key_wo: **NOTE:** This field is write-only and its value will not be updated in state as part of read operations.
               The private key configured for the admin user in Snowflake.
        :param _builtins.int private_key_wo_version: Version counter for the private key key-pair credentials write-only field
        :param Sequence[_builtins.str] root_rotation_statements: A list of database statements to be executed to rotate the root user's credentials.
        :param _builtins.int rotation_period: The amount of time in seconds Vault should wait before rotating the root credential.
               A zero value tells Vault not to rotate the root credential. The minimum rotation period is 10 seconds. Requires Vault Enterprise 1.19+.
        :param _builtins.str rotation_schedule: The schedule, in [cron-style time format](https://en.wikipedia.org/wiki/Cron),
               defining the schedule on which Vault should rotate the root token. Requires Vault Enterprise 1.19+.
        :param _builtins.int rotation_window: The maximum amount of time in seconds allowed to complete
               a rotation when a scheduled token rotation occurs. The default rotation window is
               unbound and the minimum allowable window is `3600`. Requires Vault Enterprise 1.19+.
        :param _builtins.str username: The root credential username used in the connection URL
        :param _builtins.str username_template: Username generation template.
        :param _builtins.bool verify_connection: Whether the connection should be verified on
               initial configuration or not.
        """
        pulumi.set(__self__, "name", name)
        if allowed_roles is not None:
            pulumi.set(__self__, "allowed_roles", allowed_roles)
        if connection_url is not None:
            pulumi.set(__self__, "connection_url", connection_url)
        if data is not None:
            pulumi.set(__self__, "data", data)
        if disable_automated_rotation is not None:
            pulumi.set(__self__, "disable_automated_rotation", disable_automated_rotation)
        if max_connection_lifetime is not None:
            pulumi.set(__self__, "max_connection_lifetime", max_connection_lifetime)
        if max_idle_connections is not None:
            pulumi.set(__self__, "max_idle_connections", max_idle_connections)
        if max_open_connections is not None:
            pulumi.set(__self__, "max_open_connections", max_open_connections)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if password_wo is not None:
            pulumi.set(__self__, "password_wo", password_wo)
        if password_wo_version is not None:
            pulumi.set(__self__, "password_wo_version", password_wo_version)
        if plugin_name is not None:
            pulumi.set(__self__, "plugin_name", plugin_name)
        if private_key_wo is not None:
            pulumi.set(__self__, "private_key_wo", private_key_wo)
        if private_key_wo_version is not None:
            pulumi.set(__self__, "private_key_wo_version", private_key_wo_version)
        if root_rotation_statements is not None:
            pulumi.set(__self__, "root_rotation_statements", root_rotation_statements)
        if rotation_period is not None:
            pulumi.set(__self__, "rotation_period", rotation_period)
        if rotation_schedule is not None:
            pulumi.set(__self__, "rotation_schedule", rotation_schedule)
        if rotation_window is not None:
            pulumi.set(__self__, "rotation_window", rotation_window)
        if username is not None:
            pulumi.set(__self__, "username", username)
        if username_template is not None:
            pulumi.set(__self__, "username_template", username_template)
        if verify_connection is not None:
            pulumi.set(__self__, "verify_connection", verify_connection)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the database connection.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="allowedRoles")
    def allowed_roles(self) -> Optional[Sequence[_builtins.str]]:
        """
        A list of roles that are allowed to use this
        connection.
        """
        return pulumi.get(self, "allowed_roles")

    @_builtins.property
    @pulumi.getter(name="connectionUrl")
    def connection_url(self) -> Optional[_builtins.str]:
        """
        Connection string to use to connect to the database.
        """
        return pulumi.get(self, "connection_url")

    @_builtins.property
    @pulumi.getter
    def data(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        A map of sensitive data to pass to the endpoint. Useful for templated connection strings.
        """
        return pulumi.get(self, "data")

    @_builtins.property
    @pulumi.getter(name="disableAutomatedRotation")
    def disable_automated_rotation(self) -> Optional[_builtins.bool]:
        """
        Cancels all upcoming rotations of the root credential until unset. Requires Vault Enterprise 1.19+.

        Supported list of database secrets engines that can be configured:
        """
        return pulumi.get(self, "disable_automated_rotation")

    @_builtins.property
    @pulumi.getter(name="maxConnectionLifetime")
    def max_connection_lifetime(self) -> Optional[_builtins.int]:
        """
        Maximum number of seconds a connection may be reused.
        """
        return pulumi.get(self, "max_connection_lifetime")

    @_builtins.property
    @pulumi.getter(name="maxIdleConnections")
    def max_idle_connections(self) -> Optional[_builtins.int]:
        """
        Maximum number of idle connections to the database.
        """
        return pulumi.get(self, "max_idle_connections")

    @_builtins.property
    @pulumi.getter(name="maxOpenConnections")
    def max_open_connections(self) -> Optional[_builtins.int]:
        """
        Maximum number of open connections to the database.
        """
        return pulumi.get(self, "max_open_connections")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Snowflake is ending support for single-factor password authentication by November 2025. Refer to the documentation for more information on migrating to key-pair authentication.""")
    def password(self) -> Optional[_builtins.str]:
        """
        The root credential password used in the connection URL
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter(name="passwordWo")
    def password_wo(self) -> Optional[_builtins.str]:
        """
        **NOTE:** This field is write-only and its value will not be updated in state as part of read operations.
        Write-only field for the root credential password used in the connection URL
        """
        return pulumi.get(self, "password_wo")

    @_builtins.property
    @pulumi.getter(name="passwordWoVersion")
    def password_wo_version(self) -> Optional[_builtins.int]:
        """
        Version counter for root credential password write-only field
        """
        return pulumi.get(self, "password_wo_version")

    @_builtins.property
    @pulumi.getter(name="pluginName")
    def plugin_name(self) -> Optional[_builtins.str]:
        """
        Specifies the name of the plugin to use.
        """
        return pulumi.get(self, "plugin_name")

    @_builtins.property
    @pulumi.getter(name="privateKeyWo")
    def private_key_wo(self) -> Optional[_builtins.str]:
        """
        **NOTE:** This field is write-only and its value will not be updated in state as part of read operations.
        The private key configured for the admin user in Snowflake.
        """
        return pulumi.get(self, "private_key_wo")

    @_builtins.property
    @pulumi.getter(name="privateKeyWoVersion")
    def private_key_wo_version(self) -> Optional[_builtins.int]:
        """
        Version counter for the private key key-pair credentials write-only field
        """
        return pulumi.get(self, "private_key_wo_version")

    @_builtins.property
    @pulumi.getter(name="rootRotationStatements")
    def root_rotation_statements(self) -> Optional[Sequence[_builtins.str]]:
        """
        A list of database statements to be executed to rotate the root user's credentials.
        """
        return pulumi.get(self, "root_rotation_statements")

    @_builtins.property
    @pulumi.getter(name="rotationPeriod")
    def rotation_period(self) -> Optional[_builtins.int]:
        """
        The amount of time in seconds Vault should wait before rotating the root credential.
        A zero value tells Vault not to rotate the root credential. The minimum rotation period is 10 seconds. Requires Vault Enterprise 1.19+.
        """
        return pulumi.get(self, "rotation_period")

    @_builtins.property
    @pulumi.getter(name="rotationSchedule")
    def rotation_schedule(self) -> Optional[_builtins.str]:
        """
        The schedule, in [cron-style time format](https://en.wikipedia.org/wiki/Cron),
        defining the schedule on which Vault should rotate the root token. Requires Vault Enterprise 1.19+.
        """
        return pulumi.get(self, "rotation_schedule")

    @_builtins.property
    @pulumi.getter(name="rotationWindow")
    def rotation_window(self) -> Optional[_builtins.int]:
        """
        The maximum amount of time in seconds allowed to complete
        a rotation when a scheduled token rotation occurs. The default rotation window is
        unbound and the minimum allowable window is `3600`. Requires Vault Enterprise 1.19+.
        """
        return pulumi.get(self, "rotation_window")

    @_builtins.property
    @pulumi.getter
    def username(self) -> Optional[_builtins.str]:
        """
        The root credential username used in the connection URL
        """
        return pulumi.get(self, "username")

    @_builtins.property
    @pulumi.getter(name="usernameTemplate")
    def username_template(self) -> Optional[_builtins.str]:
        """
        Username generation template.
        """
        return pulumi.get(self, "username_template")

    @_builtins.property
    @pulumi.getter(name="verifyConnection")
    def verify_connection(self) -> Optional[_builtins.bool]:
        """
        Whether the connection should be verified on
        initial configuration or not.
        """
        return pulumi.get(self, "verify_connection")


