# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SecretsMountArgs', 'SecretsMount']

@pulumi.input_type
class SecretsMountArgs:
    def __init__(__self__, *,
                 path: pulumi.Input[_builtins.str],
                 allowed_managed_keys: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 allowed_response_headers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 audit_non_hmac_request_keys: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 audit_non_hmac_response_keys: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 cassandras: Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountCassandraArgs']]]] = None,
                 couchbases: Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountCouchbaseArgs']]]] = None,
                 default_lease_ttl_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 delegated_auth_accessors: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 elasticsearches: Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountElasticsearchArgs']]]] = None,
                 external_entropy_access: Optional[pulumi.Input[_builtins.bool]] = None,
                 force_no_cache: Optional[pulumi.Input[_builtins.bool]] = None,
                 hanas: Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountHanaArgs']]]] = None,
                 identity_token_key: Optional[pulumi.Input[_builtins.str]] = None,
                 influxdbs: Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountInfluxdbArgs']]]] = None,
                 listing_visibility: Optional[pulumi.Input[_builtins.str]] = None,
                 local: Optional[pulumi.Input[_builtins.bool]] = None,
                 max_lease_ttl_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 mongodbatlas: Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountMongodbatlaArgs']]]] = None,
                 mongodbs: Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountMongodbArgs']]]] = None,
                 mssqls: Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountMssqlArgs']]]] = None,
                 mysql_auroras: Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountMysqlAuroraArgs']]]] = None,
                 mysql_legacies: Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountMysqlLegacyArgs']]]] = None,
                 mysql_rds: Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountMysqlRdArgs']]]] = None,
                 mysqls: Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountMysqlArgs']]]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 options: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 oracles: Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountOracleArgs']]]] = None,
                 passthrough_request_headers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 plugin_version: Optional[pulumi.Input[_builtins.str]] = None,
                 postgresqls: Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountPostgresqlArgs']]]] = None,
                 redis: Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountRediArgs']]]] = None,
                 redis_elasticaches: Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountRedisElasticachArgs']]]] = None,
                 redshifts: Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountRedshiftArgs']]]] = None,
                 seal_wrap: Optional[pulumi.Input[_builtins.bool]] = None,
                 snowflakes: Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountSnowflakeArgs']]]] = None):
        """
        The set of arguments for constructing a SecretsMount resource.
        :param pulumi.Input[_builtins.str] path: Where the secret backend will be mounted
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_managed_keys: Set of managed key registry entry names that the mount in question is allowed to access
               
               The following arguments are common to all database engines:
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_response_headers: List of headers to allow and pass from the request to the plugin
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] audit_non_hmac_request_keys: Specifies the list of keys that will not be HMAC'd by audit devices in the request data object.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] audit_non_hmac_response_keys: Specifies the list of keys that will not be HMAC'd by audit devices in the response data object.
        :param pulumi.Input[Sequence[pulumi.Input['SecretsMountCassandraArgs']]] cassandras: A nested block containing configuration options for Cassandra connections.  
               *See Configuration Options for more info*
        :param pulumi.Input[Sequence[pulumi.Input['SecretsMountCouchbaseArgs']]] couchbases: A nested block containing configuration options for Couchbase connections.  
               *See Configuration Options for more info*
        :param pulumi.Input[_builtins.int] default_lease_ttl_seconds: Default lease duration for tokens and secrets in seconds
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] delegated_auth_accessors: List of headers to allow and pass from the request to the plugin
        :param pulumi.Input[_builtins.str] description: Human-friendly description of the mount
        :param pulumi.Input[Sequence[pulumi.Input['SecretsMountElasticsearchArgs']]] elasticsearches: A nested block containing configuration options for Elasticsearch connections.  
               *See Configuration Options for more info*
        :param pulumi.Input[_builtins.bool] external_entropy_access: Boolean flag that can be explicitly set to true to enable the secrets engine to access Vault's external entropy source
        :param pulumi.Input[_builtins.bool] force_no_cache: If set to true, disables caching.
        :param pulumi.Input[Sequence[pulumi.Input['SecretsMountHanaArgs']]] hanas: A nested block containing configuration options for SAP HanaDB connections.  
               *See Configuration Options for more info*
        :param pulumi.Input[_builtins.str] identity_token_key: The key to use for signing plugin workload identity tokens
        :param pulumi.Input[Sequence[pulumi.Input['SecretsMountInfluxdbArgs']]] influxdbs: A nested block containing configuration options for InfluxDB connections.  
               *See Configuration Options for more info*
        :param pulumi.Input[_builtins.str] listing_visibility: Specifies whether to show this mount in the UI-specific listing endpoint
        :param pulumi.Input[_builtins.bool] local: Boolean flag that can be explicitly set to true to enforce local mount in HA environment
        :param pulumi.Input[_builtins.int] max_lease_ttl_seconds: Maximum possible lease duration for tokens and secrets in seconds
        :param pulumi.Input[Sequence[pulumi.Input['SecretsMountMongodbatlaArgs']]] mongodbatlas: A nested block containing configuration options for MongoDB Atlas connections.  
               *See Configuration Options for more info*
        :param pulumi.Input[Sequence[pulumi.Input['SecretsMountMongodbArgs']]] mongodbs: A nested block containing configuration options for MongoDB connections.  
               *See Configuration Options for more info*
        :param pulumi.Input[Sequence[pulumi.Input['SecretsMountMssqlArgs']]] mssqls: A nested block containing configuration options for MSSQL connections.  
               *See Configuration Options for more info*
        :param pulumi.Input[Sequence[pulumi.Input['SecretsMountMysqlAuroraArgs']]] mysql_auroras: A nested block containing configuration options for Aurora MySQL connections.  
               *See Configuration Options for more info*
        :param pulumi.Input[Sequence[pulumi.Input['SecretsMountMysqlLegacyArgs']]] mysql_legacies: A nested block containing configuration options for legacy MySQL connections.  
               *See Configuration Options for more info*
        :param pulumi.Input[Sequence[pulumi.Input['SecretsMountMysqlRdArgs']]] mysql_rds: A nested block containing configuration options for RDS MySQL connections.  
               *See Configuration Options for more info*
        :param pulumi.Input[Sequence[pulumi.Input['SecretsMountMysqlArgs']]] mysqls: A nested block containing configuration options for MySQL connections.  
               *See Configuration Options for more info*
        :param pulumi.Input[_builtins.str] namespace: Target namespace. (requires Enterprise)
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] options: Specifies mount type specific options that are passed to the backend
        :param pulumi.Input[Sequence[pulumi.Input['SecretsMountOracleArgs']]] oracles: A nested block containing configuration options for Oracle connections.  
               *See Configuration Options for more info*
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] passthrough_request_headers: List of headers to allow and pass from the request to the plugin
        :param pulumi.Input[_builtins.str] plugin_version: Specifies the semantic version of the plugin to use, e.g. 'v1.0.0'
        :param pulumi.Input[Sequence[pulumi.Input['SecretsMountPostgresqlArgs']]] postgresqls: A nested block containing configuration options for PostgreSQL connections.  
               *See Configuration Options for more info*
        :param pulumi.Input[Sequence[pulumi.Input['SecretsMountRediArgs']]] redis: A nested block containing configuration options for Redis connections.  
               *See Configuration Options for more info*
        :param pulumi.Input[Sequence[pulumi.Input['SecretsMountRedisElasticachArgs']]] redis_elasticaches: A nested block containing configuration options for Redis ElastiCache connections.  
               *See Configuration Options for more info*
        :param pulumi.Input[Sequence[pulumi.Input['SecretsMountRedshiftArgs']]] redshifts: A nested block containing configuration options for AWS Redshift connections.  
               *See Configuration Options for more info*
        :param pulumi.Input[_builtins.bool] seal_wrap: Boolean flag that can be explicitly set to true to enable seal wrapping for the mount, causing values stored by the mount to be wrapped by the seal's encryption capability
        :param pulumi.Input[Sequence[pulumi.Input['SecretsMountSnowflakeArgs']]] snowflakes: A nested block containing configuration options for Snowflake connections.  
               *See Configuration Options for more info*
        """
        pulumi.set(__self__, "path", path)
        if allowed_managed_keys is not None:
            pulumi.set(__self__, "allowed_managed_keys", allowed_managed_keys)
        if allowed_response_headers is not None:
            pulumi.set(__self__, "allowed_response_headers", allowed_response_headers)
        if audit_non_hmac_request_keys is not None:
            pulumi.set(__self__, "audit_non_hmac_request_keys", audit_non_hmac_request_keys)
        if audit_non_hmac_response_keys is not None:
            pulumi.set(__self__, "audit_non_hmac_response_keys", audit_non_hmac_response_keys)
        if cassandras is not None:
            pulumi.set(__self__, "cassandras", cassandras)
        if couchbases is not None:
            pulumi.set(__self__, "couchbases", couchbases)
        if default_lease_ttl_seconds is not None:
            pulumi.set(__self__, "default_lease_ttl_seconds", default_lease_ttl_seconds)
        if delegated_auth_accessors is not None:
            pulumi.set(__self__, "delegated_auth_accessors", delegated_auth_accessors)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if elasticsearches is not None:
            pulumi.set(__self__, "elasticsearches", elasticsearches)
        if external_entropy_access is not None:
            pulumi.set(__self__, "external_entropy_access", external_entropy_access)
        if force_no_cache is not None:
            pulumi.set(__self__, "force_no_cache", force_no_cache)
        if hanas is not None:
            pulumi.set(__self__, "hanas", hanas)
        if identity_token_key is not None:
            pulumi.set(__self__, "identity_token_key", identity_token_key)
        if influxdbs is not None:
            pulumi.set(__self__, "influxdbs", influxdbs)
        if listing_visibility is not None:
            pulumi.set(__self__, "listing_visibility", listing_visibility)
        if local is not None:
            pulumi.set(__self__, "local", local)
        if max_lease_ttl_seconds is not None:
            pulumi.set(__self__, "max_lease_ttl_seconds", max_lease_ttl_seconds)
        if mongodbatlas is not None:
            pulumi.set(__self__, "mongodbatlas", mongodbatlas)
        if mongodbs is not None:
            pulumi.set(__self__, "mongodbs", mongodbs)
        if mssqls is not None:
            pulumi.set(__self__, "mssqls", mssqls)
        if mysql_auroras is not None:
            pulumi.set(__self__, "mysql_auroras", mysql_auroras)
        if mysql_legacies is not None:
            pulumi.set(__self__, "mysql_legacies", mysql_legacies)
        if mysql_rds is not None:
            pulumi.set(__self__, "mysql_rds", mysql_rds)
        if mysqls is not None:
            pulumi.set(__self__, "mysqls", mysqls)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if options is not None:
            pulumi.set(__self__, "options", options)
        if oracles is not None:
            pulumi.set(__self__, "oracles", oracles)
        if passthrough_request_headers is not None:
            pulumi.set(__self__, "passthrough_request_headers", passthrough_request_headers)
        if plugin_version is not None:
            pulumi.set(__self__, "plugin_version", plugin_version)
        if postgresqls is not None:
            pulumi.set(__self__, "postgresqls", postgresqls)
        if redis is not None:
            pulumi.set(__self__, "redis", redis)
        if redis_elasticaches is not None:
            pulumi.set(__self__, "redis_elasticaches", redis_elasticaches)
        if redshifts is not None:
            pulumi.set(__self__, "redshifts", redshifts)
        if seal_wrap is not None:
            pulumi.set(__self__, "seal_wrap", seal_wrap)
        if snowflakes is not None:
            pulumi.set(__self__, "snowflakes", snowflakes)

    @_builtins.property
    @pulumi.getter
    def path(self) -> pulumi.Input[_builtins.str]:
        """
        Where the secret backend will be mounted
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "path", value)

    @_builtins.property
    @pulumi.getter(name="allowedManagedKeys")
    def allowed_managed_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Set of managed key registry entry names that the mount in question is allowed to access

        The following arguments are common to all database engines:
        """
        return pulumi.get(self, "allowed_managed_keys")

    @allowed_managed_keys.setter
    def allowed_managed_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "allowed_managed_keys", value)

    @_builtins.property
    @pulumi.getter(name="allowedResponseHeaders")
    def allowed_response_headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of headers to allow and pass from the request to the plugin
        """
        return pulumi.get(self, "allowed_response_headers")

    @allowed_response_headers.setter
    def allowed_response_headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "allowed_response_headers", value)

    @_builtins.property
    @pulumi.getter(name="auditNonHmacRequestKeys")
    def audit_non_hmac_request_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies the list of keys that will not be HMAC'd by audit devices in the request data object.
        """
        return pulumi.get(self, "audit_non_hmac_request_keys")

    @audit_non_hmac_request_keys.setter
    def audit_non_hmac_request_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "audit_non_hmac_request_keys", value)

    @_builtins.property
    @pulumi.getter(name="auditNonHmacResponseKeys")
    def audit_non_hmac_response_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies the list of keys that will not be HMAC'd by audit devices in the response data object.
        """
        return pulumi.get(self, "audit_non_hmac_response_keys")

    @audit_non_hmac_response_keys.setter
    def audit_non_hmac_response_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "audit_non_hmac_response_keys", value)

    @_builtins.property
    @pulumi.getter
    def cassandras(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountCassandraArgs']]]]:
        """
        A nested block containing configuration options for Cassandra connections.  
        *See Configuration Options for more info*
        """
        return pulumi.get(self, "cassandras")

    @cassandras.setter
    def cassandras(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountCassandraArgs']]]]):
        pulumi.set(self, "cassandras", value)

    @_builtins.property
    @pulumi.getter
    def couchbases(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountCouchbaseArgs']]]]:
        """
        A nested block containing configuration options for Couchbase connections.  
        *See Configuration Options for more info*
        """
        return pulumi.get(self, "couchbases")

    @couchbases.setter
    def couchbases(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountCouchbaseArgs']]]]):
        pulumi.set(self, "couchbases", value)

    @_builtins.property
    @pulumi.getter(name="defaultLeaseTtlSeconds")
    def default_lease_ttl_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Default lease duration for tokens and secrets in seconds
        """
        return pulumi.get(self, "default_lease_ttl_seconds")

    @default_lease_ttl_seconds.setter
    def default_lease_ttl_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "default_lease_ttl_seconds", value)

    @_builtins.property
    @pulumi.getter(name="delegatedAuthAccessors")
    def delegated_auth_accessors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of headers to allow and pass from the request to the plugin
        """
        return pulumi.get(self, "delegated_auth_accessors")

    @delegated_auth_accessors.setter
    def delegated_auth_accessors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "delegated_auth_accessors", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Human-friendly description of the mount
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def elasticsearches(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountElasticsearchArgs']]]]:
        """
        A nested block containing configuration options for Elasticsearch connections.  
        *See Configuration Options for more info*
        """
        return pulumi.get(self, "elasticsearches")

    @elasticsearches.setter
    def elasticsearches(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountElasticsearchArgs']]]]):
        pulumi.set(self, "elasticsearches", value)

    @_builtins.property
    @pulumi.getter(name="externalEntropyAccess")
    def external_entropy_access(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean flag that can be explicitly set to true to enable the secrets engine to access Vault's external entropy source
        """
        return pulumi.get(self, "external_entropy_access")

    @external_entropy_access.setter
    def external_entropy_access(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "external_entropy_access", value)

    @_builtins.property
    @pulumi.getter(name="forceNoCache")
    def force_no_cache(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If set to true, disables caching.
        """
        return pulumi.get(self, "force_no_cache")

    @force_no_cache.setter
    def force_no_cache(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "force_no_cache", value)

    @_builtins.property
    @pulumi.getter
    def hanas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountHanaArgs']]]]:
        """
        A nested block containing configuration options for SAP HanaDB connections.  
        *See Configuration Options for more info*
        """
        return pulumi.get(self, "hanas")

    @hanas.setter
    def hanas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountHanaArgs']]]]):
        pulumi.set(self, "hanas", value)

    @_builtins.property
    @pulumi.getter(name="identityTokenKey")
    def identity_token_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The key to use for signing plugin workload identity tokens
        """
        return pulumi.get(self, "identity_token_key")

    @identity_token_key.setter
    def identity_token_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "identity_token_key", value)

    @_builtins.property
    @pulumi.getter
    def influxdbs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountInfluxdbArgs']]]]:
        """
        A nested block containing configuration options for InfluxDB connections.  
        *See Configuration Options for more info*
        """
        return pulumi.get(self, "influxdbs")

    @influxdbs.setter
    def influxdbs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountInfluxdbArgs']]]]):
        pulumi.set(self, "influxdbs", value)

    @_builtins.property
    @pulumi.getter(name="listingVisibility")
    def listing_visibility(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies whether to show this mount in the UI-specific listing endpoint
        """
        return pulumi.get(self, "listing_visibility")

    @listing_visibility.setter
    def listing_visibility(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "listing_visibility", value)

    @_builtins.property
    @pulumi.getter
    def local(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean flag that can be explicitly set to true to enforce local mount in HA environment
        """
        return pulumi.get(self, "local")

    @local.setter
    def local(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "local", value)

    @_builtins.property
    @pulumi.getter(name="maxLeaseTtlSeconds")
    def max_lease_ttl_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Maximum possible lease duration for tokens and secrets in seconds
        """
        return pulumi.get(self, "max_lease_ttl_seconds")

    @max_lease_ttl_seconds.setter
    def max_lease_ttl_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_lease_ttl_seconds", value)

    @_builtins.property
    @pulumi.getter
    def mongodbatlas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountMongodbatlaArgs']]]]:
        """
        A nested block containing configuration options for MongoDB Atlas connections.  
        *See Configuration Options for more info*
        """
        return pulumi.get(self, "mongodbatlas")

    @mongodbatlas.setter
    def mongodbatlas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountMongodbatlaArgs']]]]):
        pulumi.set(self, "mongodbatlas", value)

    @_builtins.property
    @pulumi.getter
    def mongodbs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountMongodbArgs']]]]:
        """
        A nested block containing configuration options for MongoDB connections.  
        *See Configuration Options for more info*
        """
        return pulumi.get(self, "mongodbs")

    @mongodbs.setter
    def mongodbs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountMongodbArgs']]]]):
        pulumi.set(self, "mongodbs", value)

    @_builtins.property
    @pulumi.getter
    def mssqls(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountMssqlArgs']]]]:
        """
        A nested block containing configuration options for MSSQL connections.  
        *See Configuration Options for more info*
        """
        return pulumi.get(self, "mssqls")

    @mssqls.setter
    def mssqls(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountMssqlArgs']]]]):
        pulumi.set(self, "mssqls", value)

    @_builtins.property
    @pulumi.getter(name="mysqlAuroras")
    def mysql_auroras(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountMysqlAuroraArgs']]]]:
        """
        A nested block containing configuration options for Aurora MySQL connections.  
        *See Configuration Options for more info*
        """
        return pulumi.get(self, "mysql_auroras")

    @mysql_auroras.setter
    def mysql_auroras(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountMysqlAuroraArgs']]]]):
        pulumi.set(self, "mysql_auroras", value)

    @_builtins.property
    @pulumi.getter(name="mysqlLegacies")
    def mysql_legacies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountMysqlLegacyArgs']]]]:
        """
        A nested block containing configuration options for legacy MySQL connections.  
        *See Configuration Options for more info*
        """
        return pulumi.get(self, "mysql_legacies")

    @mysql_legacies.setter
    def mysql_legacies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountMysqlLegacyArgs']]]]):
        pulumi.set(self, "mysql_legacies", value)

    @_builtins.property
    @pulumi.getter(name="mysqlRds")
    def mysql_rds(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountMysqlRdArgs']]]]:
        """
        A nested block containing configuration options for RDS MySQL connections.  
        *See Configuration Options for more info*
        """
        return pulumi.get(self, "mysql_rds")

    @mysql_rds.setter
    def mysql_rds(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountMysqlRdArgs']]]]):
        pulumi.set(self, "mysql_rds", value)

    @_builtins.property
    @pulumi.getter
    def mysqls(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountMysqlArgs']]]]:
        """
        A nested block containing configuration options for MySQL connections.  
        *See Configuration Options for more info*
        """
        return pulumi.get(self, "mysqls")

    @mysqls.setter
    def mysqls(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountMysqlArgs']]]]):
        pulumi.set(self, "mysqls", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Target namespace. (requires Enterprise)
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter
    def options(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Specifies mount type specific options that are passed to the backend
        """
        return pulumi.get(self, "options")

    @options.setter
    def options(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "options", value)

    @_builtins.property
    @pulumi.getter
    def oracles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountOracleArgs']]]]:
        """
        A nested block containing configuration options for Oracle connections.  
        *See Configuration Options for more info*
        """
        return pulumi.get(self, "oracles")

    @oracles.setter
    def oracles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountOracleArgs']]]]):
        pulumi.set(self, "oracles", value)

    @_builtins.property
    @pulumi.getter(name="passthroughRequestHeaders")
    def passthrough_request_headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of headers to allow and pass from the request to the plugin
        """
        return pulumi.get(self, "passthrough_request_headers")

    @passthrough_request_headers.setter
    def passthrough_request_headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "passthrough_request_headers", value)

    @_builtins.property
    @pulumi.getter(name="pluginVersion")
    def plugin_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the semantic version of the plugin to use, e.g. 'v1.0.0'
        """
        return pulumi.get(self, "plugin_version")

    @plugin_version.setter
    def plugin_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "plugin_version", value)

    @_builtins.property
    @pulumi.getter
    def postgresqls(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountPostgresqlArgs']]]]:
        """
        A nested block containing configuration options for PostgreSQL connections.  
        *See Configuration Options for more info*
        """
        return pulumi.get(self, "postgresqls")

    @postgresqls.setter
    def postgresqls(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountPostgresqlArgs']]]]):
        pulumi.set(self, "postgresqls", value)

    @_builtins.property
    @pulumi.getter
    def redis(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountRediArgs']]]]:
        """
        A nested block containing configuration options for Redis connections.  
        *See Configuration Options for more info*
        """
        return pulumi.get(self, "redis")

    @redis.setter
    def redis(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountRediArgs']]]]):
        pulumi.set(self, "redis", value)

    @_builtins.property
    @pulumi.getter(name="redisElasticaches")
    def redis_elasticaches(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountRedisElasticachArgs']]]]:
        """
        A nested block containing configuration options for Redis ElastiCache connections.  
        *See Configuration Options for more info*
        """
        return pulumi.get(self, "redis_elasticaches")

    @redis_elasticaches.setter
    def redis_elasticaches(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountRedisElasticachArgs']]]]):
        pulumi.set(self, "redis_elasticaches", value)

    @_builtins.property
    @pulumi.getter
    def redshifts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountRedshiftArgs']]]]:
        """
        A nested block containing configuration options for AWS Redshift connections.  
        *See Configuration Options for more info*
        """
        return pulumi.get(self, "redshifts")

    @redshifts.setter
    def redshifts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountRedshiftArgs']]]]):
        pulumi.set(self, "redshifts", value)

    @_builtins.property
    @pulumi.getter(name="sealWrap")
    def seal_wrap(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean flag that can be explicitly set to true to enable seal wrapping for the mount, causing values stored by the mount to be wrapped by the seal's encryption capability
        """
        return pulumi.get(self, "seal_wrap")

    @seal_wrap.setter
    def seal_wrap(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "seal_wrap", value)

    @_builtins.property
    @pulumi.getter
    def snowflakes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountSnowflakeArgs']]]]:
        """
        A nested block containing configuration options for Snowflake connections.  
        *See Configuration Options for more info*
        """
        return pulumi.get(self, "snowflakes")

    @snowflakes.setter
    def snowflakes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountSnowflakeArgs']]]]):
        pulumi.set(self, "snowflakes", value)


@pulumi.input_type
class _SecretsMountState:
    def __init__(__self__, *,
                 accessor: Optional[pulumi.Input[_builtins.str]] = None,
                 allowed_managed_keys: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 allowed_response_headers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 audit_non_hmac_request_keys: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 audit_non_hmac_response_keys: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 cassandras: Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountCassandraArgs']]]] = None,
                 couchbases: Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountCouchbaseArgs']]]] = None,
                 default_lease_ttl_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 delegated_auth_accessors: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 elasticsearches: Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountElasticsearchArgs']]]] = None,
                 engine_count: Optional[pulumi.Input[_builtins.int]] = None,
                 external_entropy_access: Optional[pulumi.Input[_builtins.bool]] = None,
                 force_no_cache: Optional[pulumi.Input[_builtins.bool]] = None,
                 hanas: Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountHanaArgs']]]] = None,
                 identity_token_key: Optional[pulumi.Input[_builtins.str]] = None,
                 influxdbs: Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountInfluxdbArgs']]]] = None,
                 listing_visibility: Optional[pulumi.Input[_builtins.str]] = None,
                 local: Optional[pulumi.Input[_builtins.bool]] = None,
                 max_lease_ttl_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 mongodbatlas: Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountMongodbatlaArgs']]]] = None,
                 mongodbs: Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountMongodbArgs']]]] = None,
                 mssqls: Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountMssqlArgs']]]] = None,
                 mysql_auroras: Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountMysqlAuroraArgs']]]] = None,
                 mysql_legacies: Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountMysqlLegacyArgs']]]] = None,
                 mysql_rds: Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountMysqlRdArgs']]]] = None,
                 mysqls: Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountMysqlArgs']]]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 options: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 oracles: Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountOracleArgs']]]] = None,
                 passthrough_request_headers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 path: Optional[pulumi.Input[_builtins.str]] = None,
                 plugin_version: Optional[pulumi.Input[_builtins.str]] = None,
                 postgresqls: Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountPostgresqlArgs']]]] = None,
                 redis: Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountRediArgs']]]] = None,
                 redis_elasticaches: Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountRedisElasticachArgs']]]] = None,
                 redshifts: Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountRedshiftArgs']]]] = None,
                 seal_wrap: Optional[pulumi.Input[_builtins.bool]] = None,
                 snowflakes: Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountSnowflakeArgs']]]] = None):
        """
        Input properties used for looking up and filtering SecretsMount resources.
        :param pulumi.Input[_builtins.str] accessor: Accessor of the mount
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_managed_keys: Set of managed key registry entry names that the mount in question is allowed to access
               
               The following arguments are common to all database engines:
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_response_headers: List of headers to allow and pass from the request to the plugin
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] audit_non_hmac_request_keys: Specifies the list of keys that will not be HMAC'd by audit devices in the request data object.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] audit_non_hmac_response_keys: Specifies the list of keys that will not be HMAC'd by audit devices in the response data object.
        :param pulumi.Input[Sequence[pulumi.Input['SecretsMountCassandraArgs']]] cassandras: A nested block containing configuration options for Cassandra connections.  
               *See Configuration Options for more info*
        :param pulumi.Input[Sequence[pulumi.Input['SecretsMountCouchbaseArgs']]] couchbases: A nested block containing configuration options for Couchbase connections.  
               *See Configuration Options for more info*
        :param pulumi.Input[_builtins.int] default_lease_ttl_seconds: Default lease duration for tokens and secrets in seconds
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] delegated_auth_accessors: List of headers to allow and pass from the request to the plugin
        :param pulumi.Input[_builtins.str] description: Human-friendly description of the mount
        :param pulumi.Input[Sequence[pulumi.Input['SecretsMountElasticsearchArgs']]] elasticsearches: A nested block containing configuration options for Elasticsearch connections.  
               *See Configuration Options for more info*
        :param pulumi.Input[_builtins.int] engine_count: The total number of database secrets engines configured.
        :param pulumi.Input[_builtins.bool] external_entropy_access: Boolean flag that can be explicitly set to true to enable the secrets engine to access Vault's external entropy source
        :param pulumi.Input[_builtins.bool] force_no_cache: If set to true, disables caching.
        :param pulumi.Input[Sequence[pulumi.Input['SecretsMountHanaArgs']]] hanas: A nested block containing configuration options for SAP HanaDB connections.  
               *See Configuration Options for more info*
        :param pulumi.Input[_builtins.str] identity_token_key: The key to use for signing plugin workload identity tokens
        :param pulumi.Input[Sequence[pulumi.Input['SecretsMountInfluxdbArgs']]] influxdbs: A nested block containing configuration options for InfluxDB connections.  
               *See Configuration Options for more info*
        :param pulumi.Input[_builtins.str] listing_visibility: Specifies whether to show this mount in the UI-specific listing endpoint
        :param pulumi.Input[_builtins.bool] local: Boolean flag that can be explicitly set to true to enforce local mount in HA environment
        :param pulumi.Input[_builtins.int] max_lease_ttl_seconds: Maximum possible lease duration for tokens and secrets in seconds
        :param pulumi.Input[Sequence[pulumi.Input['SecretsMountMongodbatlaArgs']]] mongodbatlas: A nested block containing configuration options for MongoDB Atlas connections.  
               *See Configuration Options for more info*
        :param pulumi.Input[Sequence[pulumi.Input['SecretsMountMongodbArgs']]] mongodbs: A nested block containing configuration options for MongoDB connections.  
               *See Configuration Options for more info*
        :param pulumi.Input[Sequence[pulumi.Input['SecretsMountMssqlArgs']]] mssqls: A nested block containing configuration options for MSSQL connections.  
               *See Configuration Options for more info*
        :param pulumi.Input[Sequence[pulumi.Input['SecretsMountMysqlAuroraArgs']]] mysql_auroras: A nested block containing configuration options for Aurora MySQL connections.  
               *See Configuration Options for more info*
        :param pulumi.Input[Sequence[pulumi.Input['SecretsMountMysqlLegacyArgs']]] mysql_legacies: A nested block containing configuration options for legacy MySQL connections.  
               *See Configuration Options for more info*
        :param pulumi.Input[Sequence[pulumi.Input['SecretsMountMysqlRdArgs']]] mysql_rds: A nested block containing configuration options for RDS MySQL connections.  
               *See Configuration Options for more info*
        :param pulumi.Input[Sequence[pulumi.Input['SecretsMountMysqlArgs']]] mysqls: A nested block containing configuration options for MySQL connections.  
               *See Configuration Options for more info*
        :param pulumi.Input[_builtins.str] namespace: Target namespace. (requires Enterprise)
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] options: Specifies mount type specific options that are passed to the backend
        :param pulumi.Input[Sequence[pulumi.Input['SecretsMountOracleArgs']]] oracles: A nested block containing configuration options for Oracle connections.  
               *See Configuration Options for more info*
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] passthrough_request_headers: List of headers to allow and pass from the request to the plugin
        :param pulumi.Input[_builtins.str] path: Where the secret backend will be mounted
        :param pulumi.Input[_builtins.str] plugin_version: Specifies the semantic version of the plugin to use, e.g. 'v1.0.0'
        :param pulumi.Input[Sequence[pulumi.Input['SecretsMountPostgresqlArgs']]] postgresqls: A nested block containing configuration options for PostgreSQL connections.  
               *See Configuration Options for more info*
        :param pulumi.Input[Sequence[pulumi.Input['SecretsMountRediArgs']]] redis: A nested block containing configuration options for Redis connections.  
               *See Configuration Options for more info*
        :param pulumi.Input[Sequence[pulumi.Input['SecretsMountRedisElasticachArgs']]] redis_elasticaches: A nested block containing configuration options for Redis ElastiCache connections.  
               *See Configuration Options for more info*
        :param pulumi.Input[Sequence[pulumi.Input['SecretsMountRedshiftArgs']]] redshifts: A nested block containing configuration options for AWS Redshift connections.  
               *See Configuration Options for more info*
        :param pulumi.Input[_builtins.bool] seal_wrap: Boolean flag that can be explicitly set to true to enable seal wrapping for the mount, causing values stored by the mount to be wrapped by the seal's encryption capability
        :param pulumi.Input[Sequence[pulumi.Input['SecretsMountSnowflakeArgs']]] snowflakes: A nested block containing configuration options for Snowflake connections.  
               *See Configuration Options for more info*
        """
        if accessor is not None:
            pulumi.set(__self__, "accessor", accessor)
        if allowed_managed_keys is not None:
            pulumi.set(__self__, "allowed_managed_keys", allowed_managed_keys)
        if allowed_response_headers is not None:
            pulumi.set(__self__, "allowed_response_headers", allowed_response_headers)
        if audit_non_hmac_request_keys is not None:
            pulumi.set(__self__, "audit_non_hmac_request_keys", audit_non_hmac_request_keys)
        if audit_non_hmac_response_keys is not None:
            pulumi.set(__self__, "audit_non_hmac_response_keys", audit_non_hmac_response_keys)
        if cassandras is not None:
            pulumi.set(__self__, "cassandras", cassandras)
        if couchbases is not None:
            pulumi.set(__self__, "couchbases", couchbases)
        if default_lease_ttl_seconds is not None:
            pulumi.set(__self__, "default_lease_ttl_seconds", default_lease_ttl_seconds)
        if delegated_auth_accessors is not None:
            pulumi.set(__self__, "delegated_auth_accessors", delegated_auth_accessors)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if elasticsearches is not None:
            pulumi.set(__self__, "elasticsearches", elasticsearches)
        if engine_count is not None:
            pulumi.set(__self__, "engine_count", engine_count)
        if external_entropy_access is not None:
            pulumi.set(__self__, "external_entropy_access", external_entropy_access)
        if force_no_cache is not None:
            pulumi.set(__self__, "force_no_cache", force_no_cache)
        if hanas is not None:
            pulumi.set(__self__, "hanas", hanas)
        if identity_token_key is not None:
            pulumi.set(__self__, "identity_token_key", identity_token_key)
        if influxdbs is not None:
            pulumi.set(__self__, "influxdbs", influxdbs)
        if listing_visibility is not None:
            pulumi.set(__self__, "listing_visibility", listing_visibility)
        if local is not None:
            pulumi.set(__self__, "local", local)
        if max_lease_ttl_seconds is not None:
            pulumi.set(__self__, "max_lease_ttl_seconds", max_lease_ttl_seconds)
        if mongodbatlas is not None:
            pulumi.set(__self__, "mongodbatlas", mongodbatlas)
        if mongodbs is not None:
            pulumi.set(__self__, "mongodbs", mongodbs)
        if mssqls is not None:
            pulumi.set(__self__, "mssqls", mssqls)
        if mysql_auroras is not None:
            pulumi.set(__self__, "mysql_auroras", mysql_auroras)
        if mysql_legacies is not None:
            pulumi.set(__self__, "mysql_legacies", mysql_legacies)
        if mysql_rds is not None:
            pulumi.set(__self__, "mysql_rds", mysql_rds)
        if mysqls is not None:
            pulumi.set(__self__, "mysqls", mysqls)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if options is not None:
            pulumi.set(__self__, "options", options)
        if oracles is not None:
            pulumi.set(__self__, "oracles", oracles)
        if passthrough_request_headers is not None:
            pulumi.set(__self__, "passthrough_request_headers", passthrough_request_headers)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if plugin_version is not None:
            pulumi.set(__self__, "plugin_version", plugin_version)
        if postgresqls is not None:
            pulumi.set(__self__, "postgresqls", postgresqls)
        if redis is not None:
            pulumi.set(__self__, "redis", redis)
        if redis_elasticaches is not None:
            pulumi.set(__self__, "redis_elasticaches", redis_elasticaches)
        if redshifts is not None:
            pulumi.set(__self__, "redshifts", redshifts)
        if seal_wrap is not None:
            pulumi.set(__self__, "seal_wrap", seal_wrap)
        if snowflakes is not None:
            pulumi.set(__self__, "snowflakes", snowflakes)

    @_builtins.property
    @pulumi.getter
    def accessor(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Accessor of the mount
        """
        return pulumi.get(self, "accessor")

    @accessor.setter
    def accessor(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "accessor", value)

    @_builtins.property
    @pulumi.getter(name="allowedManagedKeys")
    def allowed_managed_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Set of managed key registry entry names that the mount in question is allowed to access

        The following arguments are common to all database engines:
        """
        return pulumi.get(self, "allowed_managed_keys")

    @allowed_managed_keys.setter
    def allowed_managed_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "allowed_managed_keys", value)

    @_builtins.property
    @pulumi.getter(name="allowedResponseHeaders")
    def allowed_response_headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of headers to allow and pass from the request to the plugin
        """
        return pulumi.get(self, "allowed_response_headers")

    @allowed_response_headers.setter
    def allowed_response_headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "allowed_response_headers", value)

    @_builtins.property
    @pulumi.getter(name="auditNonHmacRequestKeys")
    def audit_non_hmac_request_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies the list of keys that will not be HMAC'd by audit devices in the request data object.
        """
        return pulumi.get(self, "audit_non_hmac_request_keys")

    @audit_non_hmac_request_keys.setter
    def audit_non_hmac_request_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "audit_non_hmac_request_keys", value)

    @_builtins.property
    @pulumi.getter(name="auditNonHmacResponseKeys")
    def audit_non_hmac_response_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies the list of keys that will not be HMAC'd by audit devices in the response data object.
        """
        return pulumi.get(self, "audit_non_hmac_response_keys")

    @audit_non_hmac_response_keys.setter
    def audit_non_hmac_response_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "audit_non_hmac_response_keys", value)

    @_builtins.property
    @pulumi.getter
    def cassandras(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountCassandraArgs']]]]:
        """
        A nested block containing configuration options for Cassandra connections.  
        *See Configuration Options for more info*
        """
        return pulumi.get(self, "cassandras")

    @cassandras.setter
    def cassandras(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountCassandraArgs']]]]):
        pulumi.set(self, "cassandras", value)

    @_builtins.property
    @pulumi.getter
    def couchbases(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountCouchbaseArgs']]]]:
        """
        A nested block containing configuration options for Couchbase connections.  
        *See Configuration Options for more info*
        """
        return pulumi.get(self, "couchbases")

    @couchbases.setter
    def couchbases(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountCouchbaseArgs']]]]):
        pulumi.set(self, "couchbases", value)

    @_builtins.property
    @pulumi.getter(name="defaultLeaseTtlSeconds")
    def default_lease_ttl_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Default lease duration for tokens and secrets in seconds
        """
        return pulumi.get(self, "default_lease_ttl_seconds")

    @default_lease_ttl_seconds.setter
    def default_lease_ttl_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "default_lease_ttl_seconds", value)

    @_builtins.property
    @pulumi.getter(name="delegatedAuthAccessors")
    def delegated_auth_accessors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of headers to allow and pass from the request to the plugin
        """
        return pulumi.get(self, "delegated_auth_accessors")

    @delegated_auth_accessors.setter
    def delegated_auth_accessors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "delegated_auth_accessors", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Human-friendly description of the mount
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def elasticsearches(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountElasticsearchArgs']]]]:
        """
        A nested block containing configuration options for Elasticsearch connections.  
        *See Configuration Options for more info*
        """
        return pulumi.get(self, "elasticsearches")

    @elasticsearches.setter
    def elasticsearches(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountElasticsearchArgs']]]]):
        pulumi.set(self, "elasticsearches", value)

    @_builtins.property
    @pulumi.getter(name="engineCount")
    def engine_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The total number of database secrets engines configured.
        """
        return pulumi.get(self, "engine_count")

    @engine_count.setter
    def engine_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "engine_count", value)

    @_builtins.property
    @pulumi.getter(name="externalEntropyAccess")
    def external_entropy_access(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean flag that can be explicitly set to true to enable the secrets engine to access Vault's external entropy source
        """
        return pulumi.get(self, "external_entropy_access")

    @external_entropy_access.setter
    def external_entropy_access(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "external_entropy_access", value)

    @_builtins.property
    @pulumi.getter(name="forceNoCache")
    def force_no_cache(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If set to true, disables caching.
        """
        return pulumi.get(self, "force_no_cache")

    @force_no_cache.setter
    def force_no_cache(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "force_no_cache", value)

    @_builtins.property
    @pulumi.getter
    def hanas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountHanaArgs']]]]:
        """
        A nested block containing configuration options for SAP HanaDB connections.  
        *See Configuration Options for more info*
        """
        return pulumi.get(self, "hanas")

    @hanas.setter
    def hanas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountHanaArgs']]]]):
        pulumi.set(self, "hanas", value)

    @_builtins.property
    @pulumi.getter(name="identityTokenKey")
    def identity_token_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The key to use for signing plugin workload identity tokens
        """
        return pulumi.get(self, "identity_token_key")

    @identity_token_key.setter
    def identity_token_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "identity_token_key", value)

    @_builtins.property
    @pulumi.getter
    def influxdbs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountInfluxdbArgs']]]]:
        """
        A nested block containing configuration options for InfluxDB connections.  
        *See Configuration Options for more info*
        """
        return pulumi.get(self, "influxdbs")

    @influxdbs.setter
    def influxdbs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountInfluxdbArgs']]]]):
        pulumi.set(self, "influxdbs", value)

    @_builtins.property
    @pulumi.getter(name="listingVisibility")
    def listing_visibility(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies whether to show this mount in the UI-specific listing endpoint
        """
        return pulumi.get(self, "listing_visibility")

    @listing_visibility.setter
    def listing_visibility(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "listing_visibility", value)

    @_builtins.property
    @pulumi.getter
    def local(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean flag that can be explicitly set to true to enforce local mount in HA environment
        """
        return pulumi.get(self, "local")

    @local.setter
    def local(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "local", value)

    @_builtins.property
    @pulumi.getter(name="maxLeaseTtlSeconds")
    def max_lease_ttl_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Maximum possible lease duration for tokens and secrets in seconds
        """
        return pulumi.get(self, "max_lease_ttl_seconds")

    @max_lease_ttl_seconds.setter
    def max_lease_ttl_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_lease_ttl_seconds", value)

    @_builtins.property
    @pulumi.getter
    def mongodbatlas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountMongodbatlaArgs']]]]:
        """
        A nested block containing configuration options for MongoDB Atlas connections.  
        *See Configuration Options for more info*
        """
        return pulumi.get(self, "mongodbatlas")

    @mongodbatlas.setter
    def mongodbatlas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountMongodbatlaArgs']]]]):
        pulumi.set(self, "mongodbatlas", value)

    @_builtins.property
    @pulumi.getter
    def mongodbs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountMongodbArgs']]]]:
        """
        A nested block containing configuration options for MongoDB connections.  
        *See Configuration Options for more info*
        """
        return pulumi.get(self, "mongodbs")

    @mongodbs.setter
    def mongodbs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountMongodbArgs']]]]):
        pulumi.set(self, "mongodbs", value)

    @_builtins.property
    @pulumi.getter
    def mssqls(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountMssqlArgs']]]]:
        """
        A nested block containing configuration options for MSSQL connections.  
        *See Configuration Options for more info*
        """
        return pulumi.get(self, "mssqls")

    @mssqls.setter
    def mssqls(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountMssqlArgs']]]]):
        pulumi.set(self, "mssqls", value)

    @_builtins.property
    @pulumi.getter(name="mysqlAuroras")
    def mysql_auroras(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountMysqlAuroraArgs']]]]:
        """
        A nested block containing configuration options for Aurora MySQL connections.  
        *See Configuration Options for more info*
        """
        return pulumi.get(self, "mysql_auroras")

    @mysql_auroras.setter
    def mysql_auroras(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountMysqlAuroraArgs']]]]):
        pulumi.set(self, "mysql_auroras", value)

    @_builtins.property
    @pulumi.getter(name="mysqlLegacies")
    def mysql_legacies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountMysqlLegacyArgs']]]]:
        """
        A nested block containing configuration options for legacy MySQL connections.  
        *See Configuration Options for more info*
        """
        return pulumi.get(self, "mysql_legacies")

    @mysql_legacies.setter
    def mysql_legacies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountMysqlLegacyArgs']]]]):
        pulumi.set(self, "mysql_legacies", value)

    @_builtins.property
    @pulumi.getter(name="mysqlRds")
    def mysql_rds(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountMysqlRdArgs']]]]:
        """
        A nested block containing configuration options for RDS MySQL connections.  
        *See Configuration Options for more info*
        """
        return pulumi.get(self, "mysql_rds")

    @mysql_rds.setter
    def mysql_rds(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountMysqlRdArgs']]]]):
        pulumi.set(self, "mysql_rds", value)

    @_builtins.property
    @pulumi.getter
    def mysqls(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountMysqlArgs']]]]:
        """
        A nested block containing configuration options for MySQL connections.  
        *See Configuration Options for more info*
        """
        return pulumi.get(self, "mysqls")

    @mysqls.setter
    def mysqls(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountMysqlArgs']]]]):
        pulumi.set(self, "mysqls", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Target namespace. (requires Enterprise)
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter
    def options(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Specifies mount type specific options that are passed to the backend
        """
        return pulumi.get(self, "options")

    @options.setter
    def options(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "options", value)

    @_builtins.property
    @pulumi.getter
    def oracles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountOracleArgs']]]]:
        """
        A nested block containing configuration options for Oracle connections.  
        *See Configuration Options for more info*
        """
        return pulumi.get(self, "oracles")

    @oracles.setter
    def oracles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountOracleArgs']]]]):
        pulumi.set(self, "oracles", value)

    @_builtins.property
    @pulumi.getter(name="passthroughRequestHeaders")
    def passthrough_request_headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of headers to allow and pass from the request to the plugin
        """
        return pulumi.get(self, "passthrough_request_headers")

    @passthrough_request_headers.setter
    def passthrough_request_headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "passthrough_request_headers", value)

    @_builtins.property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Where the secret backend will be mounted
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "path", value)

    @_builtins.property
    @pulumi.getter(name="pluginVersion")
    def plugin_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the semantic version of the plugin to use, e.g. 'v1.0.0'
        """
        return pulumi.get(self, "plugin_version")

    @plugin_version.setter
    def plugin_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "plugin_version", value)

    @_builtins.property
    @pulumi.getter
    def postgresqls(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountPostgresqlArgs']]]]:
        """
        A nested block containing configuration options for PostgreSQL connections.  
        *See Configuration Options for more info*
        """
        return pulumi.get(self, "postgresqls")

    @postgresqls.setter
    def postgresqls(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountPostgresqlArgs']]]]):
        pulumi.set(self, "postgresqls", value)

    @_builtins.property
    @pulumi.getter
    def redis(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountRediArgs']]]]:
        """
        A nested block containing configuration options for Redis connections.  
        *See Configuration Options for more info*
        """
        return pulumi.get(self, "redis")

    @redis.setter
    def redis(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountRediArgs']]]]):
        pulumi.set(self, "redis", value)

    @_builtins.property
    @pulumi.getter(name="redisElasticaches")
    def redis_elasticaches(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountRedisElasticachArgs']]]]:
        """
        A nested block containing configuration options for Redis ElastiCache connections.  
        *See Configuration Options for more info*
        """
        return pulumi.get(self, "redis_elasticaches")

    @redis_elasticaches.setter
    def redis_elasticaches(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountRedisElasticachArgs']]]]):
        pulumi.set(self, "redis_elasticaches", value)

    @_builtins.property
    @pulumi.getter
    def redshifts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountRedshiftArgs']]]]:
        """
        A nested block containing configuration options for AWS Redshift connections.  
        *See Configuration Options for more info*
        """
        return pulumi.get(self, "redshifts")

    @redshifts.setter
    def redshifts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountRedshiftArgs']]]]):
        pulumi.set(self, "redshifts", value)

    @_builtins.property
    @pulumi.getter(name="sealWrap")
    def seal_wrap(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean flag that can be explicitly set to true to enable seal wrapping for the mount, causing values stored by the mount to be wrapped by the seal's encryption capability
        """
        return pulumi.get(self, "seal_wrap")

    @seal_wrap.setter
    def seal_wrap(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "seal_wrap", value)

    @_builtins.property
    @pulumi.getter
    def snowflakes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountSnowflakeArgs']]]]:
        """
        A nested block containing configuration options for Snowflake connections.  
        *See Configuration Options for more info*
        """
        return pulumi.get(self, "snowflakes")

    @snowflakes.setter
    def snowflakes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountSnowflakeArgs']]]]):
        pulumi.set(self, "snowflakes", value)


@pulumi.type_token("vault:database/secretsMount:SecretsMount")
class SecretsMount(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allowed_managed_keys: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 allowed_response_headers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 audit_non_hmac_request_keys: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 audit_non_hmac_response_keys: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 cassandras: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SecretsMountCassandraArgs', 'SecretsMountCassandraArgsDict']]]]] = None,
                 couchbases: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SecretsMountCouchbaseArgs', 'SecretsMountCouchbaseArgsDict']]]]] = None,
                 default_lease_ttl_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 delegated_auth_accessors: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 elasticsearches: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SecretsMountElasticsearchArgs', 'SecretsMountElasticsearchArgsDict']]]]] = None,
                 external_entropy_access: Optional[pulumi.Input[_builtins.bool]] = None,
                 force_no_cache: Optional[pulumi.Input[_builtins.bool]] = None,
                 hanas: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SecretsMountHanaArgs', 'SecretsMountHanaArgsDict']]]]] = None,
                 identity_token_key: Optional[pulumi.Input[_builtins.str]] = None,
                 influxdbs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SecretsMountInfluxdbArgs', 'SecretsMountInfluxdbArgsDict']]]]] = None,
                 listing_visibility: Optional[pulumi.Input[_builtins.str]] = None,
                 local: Optional[pulumi.Input[_builtins.bool]] = None,
                 max_lease_ttl_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 mongodbatlas: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SecretsMountMongodbatlaArgs', 'SecretsMountMongodbatlaArgsDict']]]]] = None,
                 mongodbs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SecretsMountMongodbArgs', 'SecretsMountMongodbArgsDict']]]]] = None,
                 mssqls: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SecretsMountMssqlArgs', 'SecretsMountMssqlArgsDict']]]]] = None,
                 mysql_auroras: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SecretsMountMysqlAuroraArgs', 'SecretsMountMysqlAuroraArgsDict']]]]] = None,
                 mysql_legacies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SecretsMountMysqlLegacyArgs', 'SecretsMountMysqlLegacyArgsDict']]]]] = None,
                 mysql_rds: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SecretsMountMysqlRdArgs', 'SecretsMountMysqlRdArgsDict']]]]] = None,
                 mysqls: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SecretsMountMysqlArgs', 'SecretsMountMysqlArgsDict']]]]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 options: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 oracles: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SecretsMountOracleArgs', 'SecretsMountOracleArgsDict']]]]] = None,
                 passthrough_request_headers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 path: Optional[pulumi.Input[_builtins.str]] = None,
                 plugin_version: Optional[pulumi.Input[_builtins.str]] = None,
                 postgresqls: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SecretsMountPostgresqlArgs', 'SecretsMountPostgresqlArgsDict']]]]] = None,
                 redis: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SecretsMountRediArgs', 'SecretsMountRediArgsDict']]]]] = None,
                 redis_elasticaches: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SecretsMountRedisElasticachArgs', 'SecretsMountRedisElasticachArgsDict']]]]] = None,
                 redshifts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SecretsMountRedshiftArgs', 'SecretsMountRedshiftArgsDict']]]]] = None,
                 seal_wrap: Optional[pulumi.Input[_builtins.bool]] = None,
                 snowflakes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SecretsMountSnowflakeArgs', 'SecretsMountSnowflakeArgsDict']]]]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_vault as vault

        db = vault.database.SecretsMount("db",
            path="db",
            mssqls=[{
                "name": "db1",
                "username": "sa",
                "password": "super_secret_1",
                "connection_url": "sqlserver://{{username}}:{{password}}@127.0.0.1:1433",
                "allowed_roles": ["dev1"],
                "rotation_schedule": "0 * * * SAT",
                "rotation_window": 3600,
            }],
            postgresqls=[{
                "name": "db2",
                "username": "postgres",
                "password": "super_secret_2",
                "connection_url": "postgresql://{{username}}:{{password}}@127.0.0.1:5432/postgres",
                "verify_connection": True,
                "allowed_roles": ["dev2"],
                "rotation_schedule": "0 * * * SAT",
                "rotation_window": 3600,
            }])
        dev1 = vault.database.SecretBackendRole("dev1",
            name="dev1",
            backend=db.path,
            db_name=db.mssqls[0].name,
            creation_statements=[
                "CREATE LOGIN [{{name}}] WITH PASSWORD = '{{password}}';",
                "CREATE USER [{{name}}] FOR LOGIN [{{name}}];",
                "GRANT SELECT ON SCHEMA::dbo TO [{{name}}];",
            ])
        dev2 = vault.database.SecretBackendRole("dev2",
            name="dev2",
            backend=db.path,
            db_name=db.postgresqls[0].name,
            creation_statements=[
                "CREATE ROLE \\"{{name}}\\" WITH LOGIN PASSWORD '{{password}}' VALID UNTIL '{{expiration}}';",
                "GRANT SELECT ON ALL TABLES IN SCHEMA public TO \\"{{name}}\\";",
            ])
        ```

        ## Ephemeral Attributes Reference

        The following write-only attributes are supported for all DBs that support username/password:

        * `password_wo` - (Optional) The password for the user. Can be updated.
          **Note**: This property is write-only and will not be read from the API.

        ## Import

        Database secret backend connections can be imported using the `path` e.g.

        ```sh
        $ pulumi import vault:database/secretsMount:SecretsMount db db
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_managed_keys: Set of managed key registry entry names that the mount in question is allowed to access
               
               The following arguments are common to all database engines:
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_response_headers: List of headers to allow and pass from the request to the plugin
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] audit_non_hmac_request_keys: Specifies the list of keys that will not be HMAC'd by audit devices in the request data object.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] audit_non_hmac_response_keys: Specifies the list of keys that will not be HMAC'd by audit devices in the response data object.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SecretsMountCassandraArgs', 'SecretsMountCassandraArgsDict']]]] cassandras: A nested block containing configuration options for Cassandra connections.  
               *See Configuration Options for more info*
        :param pulumi.Input[Sequence[pulumi.Input[Union['SecretsMountCouchbaseArgs', 'SecretsMountCouchbaseArgsDict']]]] couchbases: A nested block containing configuration options for Couchbase connections.  
               *See Configuration Options for more info*
        :param pulumi.Input[_builtins.int] default_lease_ttl_seconds: Default lease duration for tokens and secrets in seconds
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] delegated_auth_accessors: List of headers to allow and pass from the request to the plugin
        :param pulumi.Input[_builtins.str] description: Human-friendly description of the mount
        :param pulumi.Input[Sequence[pulumi.Input[Union['SecretsMountElasticsearchArgs', 'SecretsMountElasticsearchArgsDict']]]] elasticsearches: A nested block containing configuration options for Elasticsearch connections.  
               *See Configuration Options for more info*
        :param pulumi.Input[_builtins.bool] external_entropy_access: Boolean flag that can be explicitly set to true to enable the secrets engine to access Vault's external entropy source
        :param pulumi.Input[_builtins.bool] force_no_cache: If set to true, disables caching.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SecretsMountHanaArgs', 'SecretsMountHanaArgsDict']]]] hanas: A nested block containing configuration options for SAP HanaDB connections.  
               *See Configuration Options for more info*
        :param pulumi.Input[_builtins.str] identity_token_key: The key to use for signing plugin workload identity tokens
        :param pulumi.Input[Sequence[pulumi.Input[Union['SecretsMountInfluxdbArgs', 'SecretsMountInfluxdbArgsDict']]]] influxdbs: A nested block containing configuration options for InfluxDB connections.  
               *See Configuration Options for more info*
        :param pulumi.Input[_builtins.str] listing_visibility: Specifies whether to show this mount in the UI-specific listing endpoint
        :param pulumi.Input[_builtins.bool] local: Boolean flag that can be explicitly set to true to enforce local mount in HA environment
        :param pulumi.Input[_builtins.int] max_lease_ttl_seconds: Maximum possible lease duration for tokens and secrets in seconds
        :param pulumi.Input[Sequence[pulumi.Input[Union['SecretsMountMongodbatlaArgs', 'SecretsMountMongodbatlaArgsDict']]]] mongodbatlas: A nested block containing configuration options for MongoDB Atlas connections.  
               *See Configuration Options for more info*
        :param pulumi.Input[Sequence[pulumi.Input[Union['SecretsMountMongodbArgs', 'SecretsMountMongodbArgsDict']]]] mongodbs: A nested block containing configuration options for MongoDB connections.  
               *See Configuration Options for more info*
        :param pulumi.Input[Sequence[pulumi.Input[Union['SecretsMountMssqlArgs', 'SecretsMountMssqlArgsDict']]]] mssqls: A nested block containing configuration options for MSSQL connections.  
               *See Configuration Options for more info*
        :param pulumi.Input[Sequence[pulumi.Input[Union['SecretsMountMysqlAuroraArgs', 'SecretsMountMysqlAuroraArgsDict']]]] mysql_auroras: A nested block containing configuration options for Aurora MySQL connections.  
               *See Configuration Options for more info*
        :param pulumi.Input[Sequence[pulumi.Input[Union['SecretsMountMysqlLegacyArgs', 'SecretsMountMysqlLegacyArgsDict']]]] mysql_legacies: A nested block containing configuration options for legacy MySQL connections.  
               *See Configuration Options for more info*
        :param pulumi.Input[Sequence[pulumi.Input[Union['SecretsMountMysqlRdArgs', 'SecretsMountMysqlRdArgsDict']]]] mysql_rds: A nested block containing configuration options for RDS MySQL connections.  
               *See Configuration Options for more info*
        :param pulumi.Input[Sequence[pulumi.Input[Union['SecretsMountMysqlArgs', 'SecretsMountMysqlArgsDict']]]] mysqls: A nested block containing configuration options for MySQL connections.  
               *See Configuration Options for more info*
        :param pulumi.Input[_builtins.str] namespace: Target namespace. (requires Enterprise)
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] options: Specifies mount type specific options that are passed to the backend
        :param pulumi.Input[Sequence[pulumi.Input[Union['SecretsMountOracleArgs', 'SecretsMountOracleArgsDict']]]] oracles: A nested block containing configuration options for Oracle connections.  
               *See Configuration Options for more info*
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] passthrough_request_headers: List of headers to allow and pass from the request to the plugin
        :param pulumi.Input[_builtins.str] path: Where the secret backend will be mounted
        :param pulumi.Input[_builtins.str] plugin_version: Specifies the semantic version of the plugin to use, e.g. 'v1.0.0'
        :param pulumi.Input[Sequence[pulumi.Input[Union['SecretsMountPostgresqlArgs', 'SecretsMountPostgresqlArgsDict']]]] postgresqls: A nested block containing configuration options for PostgreSQL connections.  
               *See Configuration Options for more info*
        :param pulumi.Input[Sequence[pulumi.Input[Union['SecretsMountRediArgs', 'SecretsMountRediArgsDict']]]] redis: A nested block containing configuration options for Redis connections.  
               *See Configuration Options for more info*
        :param pulumi.Input[Sequence[pulumi.Input[Union['SecretsMountRedisElasticachArgs', 'SecretsMountRedisElasticachArgsDict']]]] redis_elasticaches: A nested block containing configuration options for Redis ElastiCache connections.  
               *See Configuration Options for more info*
        :param pulumi.Input[Sequence[pulumi.Input[Union['SecretsMountRedshiftArgs', 'SecretsMountRedshiftArgsDict']]]] redshifts: A nested block containing configuration options for AWS Redshift connections.  
               *See Configuration Options for more info*
        :param pulumi.Input[_builtins.bool] seal_wrap: Boolean flag that can be explicitly set to true to enable seal wrapping for the mount, causing values stored by the mount to be wrapped by the seal's encryption capability
        :param pulumi.Input[Sequence[pulumi.Input[Union['SecretsMountSnowflakeArgs', 'SecretsMountSnowflakeArgsDict']]]] snowflakes: A nested block containing configuration options for Snowflake connections.  
               *See Configuration Options for more info*
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SecretsMountArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_vault as vault

        db = vault.database.SecretsMount("db",
            path="db",
            mssqls=[{
                "name": "db1",
                "username": "sa",
                "password": "super_secret_1",
                "connection_url": "sqlserver://{{username}}:{{password}}@127.0.0.1:1433",
                "allowed_roles": ["dev1"],
                "rotation_schedule": "0 * * * SAT",
                "rotation_window": 3600,
            }],
            postgresqls=[{
                "name": "db2",
                "username": "postgres",
                "password": "super_secret_2",
                "connection_url": "postgresql://{{username}}:{{password}}@127.0.0.1:5432/postgres",
                "verify_connection": True,
                "allowed_roles": ["dev2"],
                "rotation_schedule": "0 * * * SAT",
                "rotation_window": 3600,
            }])
        dev1 = vault.database.SecretBackendRole("dev1",
            name="dev1",
            backend=db.path,
            db_name=db.mssqls[0].name,
            creation_statements=[
                "CREATE LOGIN [{{name}}] WITH PASSWORD = '{{password}}';",
                "CREATE USER [{{name}}] FOR LOGIN [{{name}}];",
                "GRANT SELECT ON SCHEMA::dbo TO [{{name}}];",
            ])
        dev2 = vault.database.SecretBackendRole("dev2",
            name="dev2",
            backend=db.path,
            db_name=db.postgresqls[0].name,
            creation_statements=[
                "CREATE ROLE \\"{{name}}\\" WITH LOGIN PASSWORD '{{password}}' VALID UNTIL '{{expiration}}';",
                "GRANT SELECT ON ALL TABLES IN SCHEMA public TO \\"{{name}}\\";",
            ])
        ```

        ## Ephemeral Attributes Reference

        The following write-only attributes are supported for all DBs that support username/password:

        * `password_wo` - (Optional) The password for the user. Can be updated.
          **Note**: This property is write-only and will not be read from the API.

        ## Import

        Database secret backend connections can be imported using the `path` e.g.

        ```sh
        $ pulumi import vault:database/secretsMount:SecretsMount db db
        ```

        :param str resource_name: The name of the resource.
        :param SecretsMountArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SecretsMountArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allowed_managed_keys: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 allowed_response_headers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 audit_non_hmac_request_keys: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 audit_non_hmac_response_keys: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 cassandras: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SecretsMountCassandraArgs', 'SecretsMountCassandraArgsDict']]]]] = None,
                 couchbases: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SecretsMountCouchbaseArgs', 'SecretsMountCouchbaseArgsDict']]]]] = None,
                 default_lease_ttl_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 delegated_auth_accessors: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 elasticsearches: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SecretsMountElasticsearchArgs', 'SecretsMountElasticsearchArgsDict']]]]] = None,
                 external_entropy_access: Optional[pulumi.Input[_builtins.bool]] = None,
                 force_no_cache: Optional[pulumi.Input[_builtins.bool]] = None,
                 hanas: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SecretsMountHanaArgs', 'SecretsMountHanaArgsDict']]]]] = None,
                 identity_token_key: Optional[pulumi.Input[_builtins.str]] = None,
                 influxdbs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SecretsMountInfluxdbArgs', 'SecretsMountInfluxdbArgsDict']]]]] = None,
                 listing_visibility: Optional[pulumi.Input[_builtins.str]] = None,
                 local: Optional[pulumi.Input[_builtins.bool]] = None,
                 max_lease_ttl_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 mongodbatlas: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SecretsMountMongodbatlaArgs', 'SecretsMountMongodbatlaArgsDict']]]]] = None,
                 mongodbs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SecretsMountMongodbArgs', 'SecretsMountMongodbArgsDict']]]]] = None,
                 mssqls: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SecretsMountMssqlArgs', 'SecretsMountMssqlArgsDict']]]]] = None,
                 mysql_auroras: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SecretsMountMysqlAuroraArgs', 'SecretsMountMysqlAuroraArgsDict']]]]] = None,
                 mysql_legacies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SecretsMountMysqlLegacyArgs', 'SecretsMountMysqlLegacyArgsDict']]]]] = None,
                 mysql_rds: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SecretsMountMysqlRdArgs', 'SecretsMountMysqlRdArgsDict']]]]] = None,
                 mysqls: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SecretsMountMysqlArgs', 'SecretsMountMysqlArgsDict']]]]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 options: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 oracles: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SecretsMountOracleArgs', 'SecretsMountOracleArgsDict']]]]] = None,
                 passthrough_request_headers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 path: Optional[pulumi.Input[_builtins.str]] = None,
                 plugin_version: Optional[pulumi.Input[_builtins.str]] = None,
                 postgresqls: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SecretsMountPostgresqlArgs', 'SecretsMountPostgresqlArgsDict']]]]] = None,
                 redis: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SecretsMountRediArgs', 'SecretsMountRediArgsDict']]]]] = None,
                 redis_elasticaches: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SecretsMountRedisElasticachArgs', 'SecretsMountRedisElasticachArgsDict']]]]] = None,
                 redshifts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SecretsMountRedshiftArgs', 'SecretsMountRedshiftArgsDict']]]]] = None,
                 seal_wrap: Optional[pulumi.Input[_builtins.bool]] = None,
                 snowflakes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SecretsMountSnowflakeArgs', 'SecretsMountSnowflakeArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SecretsMountArgs.__new__(SecretsMountArgs)

            __props__.__dict__["allowed_managed_keys"] = allowed_managed_keys
            __props__.__dict__["allowed_response_headers"] = allowed_response_headers
            __props__.__dict__["audit_non_hmac_request_keys"] = audit_non_hmac_request_keys
            __props__.__dict__["audit_non_hmac_response_keys"] = audit_non_hmac_response_keys
            __props__.__dict__["cassandras"] = cassandras
            __props__.__dict__["couchbases"] = couchbases
            __props__.__dict__["default_lease_ttl_seconds"] = default_lease_ttl_seconds
            __props__.__dict__["delegated_auth_accessors"] = delegated_auth_accessors
            __props__.__dict__["description"] = description
            __props__.__dict__["elasticsearches"] = elasticsearches
            __props__.__dict__["external_entropy_access"] = external_entropy_access
            __props__.__dict__["force_no_cache"] = force_no_cache
            __props__.__dict__["hanas"] = hanas
            __props__.__dict__["identity_token_key"] = identity_token_key
            __props__.__dict__["influxdbs"] = influxdbs
            __props__.__dict__["listing_visibility"] = listing_visibility
            __props__.__dict__["local"] = local
            __props__.__dict__["max_lease_ttl_seconds"] = max_lease_ttl_seconds
            __props__.__dict__["mongodbatlas"] = mongodbatlas
            __props__.__dict__["mongodbs"] = mongodbs
            __props__.__dict__["mssqls"] = mssqls
            __props__.__dict__["mysql_auroras"] = mysql_auroras
            __props__.__dict__["mysql_legacies"] = mysql_legacies
            __props__.__dict__["mysql_rds"] = mysql_rds
            __props__.__dict__["mysqls"] = mysqls
            __props__.__dict__["namespace"] = namespace
            __props__.__dict__["options"] = options
            __props__.__dict__["oracles"] = oracles
            __props__.__dict__["passthrough_request_headers"] = passthrough_request_headers
            if path is None and not opts.urn:
                raise TypeError("Missing required property 'path'")
            __props__.__dict__["path"] = path
            __props__.__dict__["plugin_version"] = plugin_version
            __props__.__dict__["postgresqls"] = postgresqls
            __props__.__dict__["redis"] = redis
            __props__.__dict__["redis_elasticaches"] = redis_elasticaches
            __props__.__dict__["redshifts"] = redshifts
            __props__.__dict__["seal_wrap"] = seal_wrap
            __props__.__dict__["snowflakes"] = snowflakes
            __props__.__dict__["accessor"] = None
            __props__.__dict__["engine_count"] = None
        super(SecretsMount, __self__).__init__(
            'vault:database/secretsMount:SecretsMount',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            accessor: Optional[pulumi.Input[_builtins.str]] = None,
            allowed_managed_keys: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            allowed_response_headers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            audit_non_hmac_request_keys: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            audit_non_hmac_response_keys: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            cassandras: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SecretsMountCassandraArgs', 'SecretsMountCassandraArgsDict']]]]] = None,
            couchbases: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SecretsMountCouchbaseArgs', 'SecretsMountCouchbaseArgsDict']]]]] = None,
            default_lease_ttl_seconds: Optional[pulumi.Input[_builtins.int]] = None,
            delegated_auth_accessors: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            elasticsearches: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SecretsMountElasticsearchArgs', 'SecretsMountElasticsearchArgsDict']]]]] = None,
            engine_count: Optional[pulumi.Input[_builtins.int]] = None,
            external_entropy_access: Optional[pulumi.Input[_builtins.bool]] = None,
            force_no_cache: Optional[pulumi.Input[_builtins.bool]] = None,
            hanas: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SecretsMountHanaArgs', 'SecretsMountHanaArgsDict']]]]] = None,
            identity_token_key: Optional[pulumi.Input[_builtins.str]] = None,
            influxdbs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SecretsMountInfluxdbArgs', 'SecretsMountInfluxdbArgsDict']]]]] = None,
            listing_visibility: Optional[pulumi.Input[_builtins.str]] = None,
            local: Optional[pulumi.Input[_builtins.bool]] = None,
            max_lease_ttl_seconds: Optional[pulumi.Input[_builtins.int]] = None,
            mongodbatlas: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SecretsMountMongodbatlaArgs', 'SecretsMountMongodbatlaArgsDict']]]]] = None,
            mongodbs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SecretsMountMongodbArgs', 'SecretsMountMongodbArgsDict']]]]] = None,
            mssqls: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SecretsMountMssqlArgs', 'SecretsMountMssqlArgsDict']]]]] = None,
            mysql_auroras: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SecretsMountMysqlAuroraArgs', 'SecretsMountMysqlAuroraArgsDict']]]]] = None,
            mysql_legacies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SecretsMountMysqlLegacyArgs', 'SecretsMountMysqlLegacyArgsDict']]]]] = None,
            mysql_rds: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SecretsMountMysqlRdArgs', 'SecretsMountMysqlRdArgsDict']]]]] = None,
            mysqls: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SecretsMountMysqlArgs', 'SecretsMountMysqlArgsDict']]]]] = None,
            namespace: Optional[pulumi.Input[_builtins.str]] = None,
            options: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            oracles: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SecretsMountOracleArgs', 'SecretsMountOracleArgsDict']]]]] = None,
            passthrough_request_headers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            path: Optional[pulumi.Input[_builtins.str]] = None,
            plugin_version: Optional[pulumi.Input[_builtins.str]] = None,
            postgresqls: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SecretsMountPostgresqlArgs', 'SecretsMountPostgresqlArgsDict']]]]] = None,
            redis: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SecretsMountRediArgs', 'SecretsMountRediArgsDict']]]]] = None,
            redis_elasticaches: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SecretsMountRedisElasticachArgs', 'SecretsMountRedisElasticachArgsDict']]]]] = None,
            redshifts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SecretsMountRedshiftArgs', 'SecretsMountRedshiftArgsDict']]]]] = None,
            seal_wrap: Optional[pulumi.Input[_builtins.bool]] = None,
            snowflakes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SecretsMountSnowflakeArgs', 'SecretsMountSnowflakeArgsDict']]]]] = None) -> 'SecretsMount':
        """
        Get an existing SecretsMount resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] accessor: Accessor of the mount
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_managed_keys: Set of managed key registry entry names that the mount in question is allowed to access
               
               The following arguments are common to all database engines:
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_response_headers: List of headers to allow and pass from the request to the plugin
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] audit_non_hmac_request_keys: Specifies the list of keys that will not be HMAC'd by audit devices in the request data object.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] audit_non_hmac_response_keys: Specifies the list of keys that will not be HMAC'd by audit devices in the response data object.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SecretsMountCassandraArgs', 'SecretsMountCassandraArgsDict']]]] cassandras: A nested block containing configuration options for Cassandra connections.  
               *See Configuration Options for more info*
        :param pulumi.Input[Sequence[pulumi.Input[Union['SecretsMountCouchbaseArgs', 'SecretsMountCouchbaseArgsDict']]]] couchbases: A nested block containing configuration options for Couchbase connections.  
               *See Configuration Options for more info*
        :param pulumi.Input[_builtins.int] default_lease_ttl_seconds: Default lease duration for tokens and secrets in seconds
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] delegated_auth_accessors: List of headers to allow and pass from the request to the plugin
        :param pulumi.Input[_builtins.str] description: Human-friendly description of the mount
        :param pulumi.Input[Sequence[pulumi.Input[Union['SecretsMountElasticsearchArgs', 'SecretsMountElasticsearchArgsDict']]]] elasticsearches: A nested block containing configuration options for Elasticsearch connections.  
               *See Configuration Options for more info*
        :param pulumi.Input[_builtins.int] engine_count: The total number of database secrets engines configured.
        :param pulumi.Input[_builtins.bool] external_entropy_access: Boolean flag that can be explicitly set to true to enable the secrets engine to access Vault's external entropy source
        :param pulumi.Input[_builtins.bool] force_no_cache: If set to true, disables caching.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SecretsMountHanaArgs', 'SecretsMountHanaArgsDict']]]] hanas: A nested block containing configuration options for SAP HanaDB connections.  
               *See Configuration Options for more info*
        :param pulumi.Input[_builtins.str] identity_token_key: The key to use for signing plugin workload identity tokens
        :param pulumi.Input[Sequence[pulumi.Input[Union['SecretsMountInfluxdbArgs', 'SecretsMountInfluxdbArgsDict']]]] influxdbs: A nested block containing configuration options for InfluxDB connections.  
               *See Configuration Options for more info*
        :param pulumi.Input[_builtins.str] listing_visibility: Specifies whether to show this mount in the UI-specific listing endpoint
        :param pulumi.Input[_builtins.bool] local: Boolean flag that can be explicitly set to true to enforce local mount in HA environment
        :param pulumi.Input[_builtins.int] max_lease_ttl_seconds: Maximum possible lease duration for tokens and secrets in seconds
        :param pulumi.Input[Sequence[pulumi.Input[Union['SecretsMountMongodbatlaArgs', 'SecretsMountMongodbatlaArgsDict']]]] mongodbatlas: A nested block containing configuration options for MongoDB Atlas connections.  
               *See Configuration Options for more info*
        :param pulumi.Input[Sequence[pulumi.Input[Union['SecretsMountMongodbArgs', 'SecretsMountMongodbArgsDict']]]] mongodbs: A nested block containing configuration options for MongoDB connections.  
               *See Configuration Options for more info*
        :param pulumi.Input[Sequence[pulumi.Input[Union['SecretsMountMssqlArgs', 'SecretsMountMssqlArgsDict']]]] mssqls: A nested block containing configuration options for MSSQL connections.  
               *See Configuration Options for more info*
        :param pulumi.Input[Sequence[pulumi.Input[Union['SecretsMountMysqlAuroraArgs', 'SecretsMountMysqlAuroraArgsDict']]]] mysql_auroras: A nested block containing configuration options for Aurora MySQL connections.  
               *See Configuration Options for more info*
        :param pulumi.Input[Sequence[pulumi.Input[Union['SecretsMountMysqlLegacyArgs', 'SecretsMountMysqlLegacyArgsDict']]]] mysql_legacies: A nested block containing configuration options for legacy MySQL connections.  
               *See Configuration Options for more info*
        :param pulumi.Input[Sequence[pulumi.Input[Union['SecretsMountMysqlRdArgs', 'SecretsMountMysqlRdArgsDict']]]] mysql_rds: A nested block containing configuration options for RDS MySQL connections.  
               *See Configuration Options for more info*
        :param pulumi.Input[Sequence[pulumi.Input[Union['SecretsMountMysqlArgs', 'SecretsMountMysqlArgsDict']]]] mysqls: A nested block containing configuration options for MySQL connections.  
               *See Configuration Options for more info*
        :param pulumi.Input[_builtins.str] namespace: Target namespace. (requires Enterprise)
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] options: Specifies mount type specific options that are passed to the backend
        :param pulumi.Input[Sequence[pulumi.Input[Union['SecretsMountOracleArgs', 'SecretsMountOracleArgsDict']]]] oracles: A nested block containing configuration options for Oracle connections.  
               *See Configuration Options for more info*
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] passthrough_request_headers: List of headers to allow and pass from the request to the plugin
        :param pulumi.Input[_builtins.str] path: Where the secret backend will be mounted
        :param pulumi.Input[_builtins.str] plugin_version: Specifies the semantic version of the plugin to use, e.g. 'v1.0.0'
        :param pulumi.Input[Sequence[pulumi.Input[Union['SecretsMountPostgresqlArgs', 'SecretsMountPostgresqlArgsDict']]]] postgresqls: A nested block containing configuration options for PostgreSQL connections.  
               *See Configuration Options for more info*
        :param pulumi.Input[Sequence[pulumi.Input[Union['SecretsMountRediArgs', 'SecretsMountRediArgsDict']]]] redis: A nested block containing configuration options for Redis connections.  
               *See Configuration Options for more info*
        :param pulumi.Input[Sequence[pulumi.Input[Union['SecretsMountRedisElasticachArgs', 'SecretsMountRedisElasticachArgsDict']]]] redis_elasticaches: A nested block containing configuration options for Redis ElastiCache connections.  
               *See Configuration Options for more info*
        :param pulumi.Input[Sequence[pulumi.Input[Union['SecretsMountRedshiftArgs', 'SecretsMountRedshiftArgsDict']]]] redshifts: A nested block containing configuration options for AWS Redshift connections.  
               *See Configuration Options for more info*
        :param pulumi.Input[_builtins.bool] seal_wrap: Boolean flag that can be explicitly set to true to enable seal wrapping for the mount, causing values stored by the mount to be wrapped by the seal's encryption capability
        :param pulumi.Input[Sequence[pulumi.Input[Union['SecretsMountSnowflakeArgs', 'SecretsMountSnowflakeArgsDict']]]] snowflakes: A nested block containing configuration options for Snowflake connections.  
               *See Configuration Options for more info*
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SecretsMountState.__new__(_SecretsMountState)

        __props__.__dict__["accessor"] = accessor
        __props__.__dict__["allowed_managed_keys"] = allowed_managed_keys
        __props__.__dict__["allowed_response_headers"] = allowed_response_headers
        __props__.__dict__["audit_non_hmac_request_keys"] = audit_non_hmac_request_keys
        __props__.__dict__["audit_non_hmac_response_keys"] = audit_non_hmac_response_keys
        __props__.__dict__["cassandras"] = cassandras
        __props__.__dict__["couchbases"] = couchbases
        __props__.__dict__["default_lease_ttl_seconds"] = default_lease_ttl_seconds
        __props__.__dict__["delegated_auth_accessors"] = delegated_auth_accessors
        __props__.__dict__["description"] = description
        __props__.__dict__["elasticsearches"] = elasticsearches
        __props__.__dict__["engine_count"] = engine_count
        __props__.__dict__["external_entropy_access"] = external_entropy_access
        __props__.__dict__["force_no_cache"] = force_no_cache
        __props__.__dict__["hanas"] = hanas
        __props__.__dict__["identity_token_key"] = identity_token_key
        __props__.__dict__["influxdbs"] = influxdbs
        __props__.__dict__["listing_visibility"] = listing_visibility
        __props__.__dict__["local"] = local
        __props__.__dict__["max_lease_ttl_seconds"] = max_lease_ttl_seconds
        __props__.__dict__["mongodbatlas"] = mongodbatlas
        __props__.__dict__["mongodbs"] = mongodbs
        __props__.__dict__["mssqls"] = mssqls
        __props__.__dict__["mysql_auroras"] = mysql_auroras
        __props__.__dict__["mysql_legacies"] = mysql_legacies
        __props__.__dict__["mysql_rds"] = mysql_rds
        __props__.__dict__["mysqls"] = mysqls
        __props__.__dict__["namespace"] = namespace
        __props__.__dict__["options"] = options
        __props__.__dict__["oracles"] = oracles
        __props__.__dict__["passthrough_request_headers"] = passthrough_request_headers
        __props__.__dict__["path"] = path
        __props__.__dict__["plugin_version"] = plugin_version
        __props__.__dict__["postgresqls"] = postgresqls
        __props__.__dict__["redis"] = redis
        __props__.__dict__["redis_elasticaches"] = redis_elasticaches
        __props__.__dict__["redshifts"] = redshifts
        __props__.__dict__["seal_wrap"] = seal_wrap
        __props__.__dict__["snowflakes"] = snowflakes
        return SecretsMount(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def accessor(self) -> pulumi.Output[_builtins.str]:
        """
        Accessor of the mount
        """
        return pulumi.get(self, "accessor")

    @_builtins.property
    @pulumi.getter(name="allowedManagedKeys")
    def allowed_managed_keys(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Set of managed key registry entry names that the mount in question is allowed to access

        The following arguments are common to all database engines:
        """
        return pulumi.get(self, "allowed_managed_keys")

    @_builtins.property
    @pulumi.getter(name="allowedResponseHeaders")
    def allowed_response_headers(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of headers to allow and pass from the request to the plugin
        """
        return pulumi.get(self, "allowed_response_headers")

    @_builtins.property
    @pulumi.getter(name="auditNonHmacRequestKeys")
    def audit_non_hmac_request_keys(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Specifies the list of keys that will not be HMAC'd by audit devices in the request data object.
        """
        return pulumi.get(self, "audit_non_hmac_request_keys")

    @_builtins.property
    @pulumi.getter(name="auditNonHmacResponseKeys")
    def audit_non_hmac_response_keys(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Specifies the list of keys that will not be HMAC'd by audit devices in the response data object.
        """
        return pulumi.get(self, "audit_non_hmac_response_keys")

    @_builtins.property
    @pulumi.getter
    def cassandras(self) -> pulumi.Output[Optional[Sequence['outputs.SecretsMountCassandra']]]:
        """
        A nested block containing configuration options for Cassandra connections.  
        *See Configuration Options for more info*
        """
        return pulumi.get(self, "cassandras")

    @_builtins.property
    @pulumi.getter
    def couchbases(self) -> pulumi.Output[Optional[Sequence['outputs.SecretsMountCouchbase']]]:
        """
        A nested block containing configuration options for Couchbase connections.  
        *See Configuration Options for more info*
        """
        return pulumi.get(self, "couchbases")

    @_builtins.property
    @pulumi.getter(name="defaultLeaseTtlSeconds")
    def default_lease_ttl_seconds(self) -> pulumi.Output[_builtins.int]:
        """
        Default lease duration for tokens and secrets in seconds
        """
        return pulumi.get(self, "default_lease_ttl_seconds")

    @_builtins.property
    @pulumi.getter(name="delegatedAuthAccessors")
    def delegated_auth_accessors(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of headers to allow and pass from the request to the plugin
        """
        return pulumi.get(self, "delegated_auth_accessors")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Human-friendly description of the mount
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def elasticsearches(self) -> pulumi.Output[Optional[Sequence['outputs.SecretsMountElasticsearch']]]:
        """
        A nested block containing configuration options for Elasticsearch connections.  
        *See Configuration Options for more info*
        """
        return pulumi.get(self, "elasticsearches")

    @_builtins.property
    @pulumi.getter(name="engineCount")
    def engine_count(self) -> pulumi.Output[_builtins.int]:
        """
        The total number of database secrets engines configured.
        """
        return pulumi.get(self, "engine_count")

    @_builtins.property
    @pulumi.getter(name="externalEntropyAccess")
    def external_entropy_access(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Boolean flag that can be explicitly set to true to enable the secrets engine to access Vault's external entropy source
        """
        return pulumi.get(self, "external_entropy_access")

    @_builtins.property
    @pulumi.getter(name="forceNoCache")
    def force_no_cache(self) -> pulumi.Output[_builtins.bool]:
        """
        If set to true, disables caching.
        """
        return pulumi.get(self, "force_no_cache")

    @_builtins.property
    @pulumi.getter
    def hanas(self) -> pulumi.Output[Optional[Sequence['outputs.SecretsMountHana']]]:
        """
        A nested block containing configuration options for SAP HanaDB connections.  
        *See Configuration Options for more info*
        """
        return pulumi.get(self, "hanas")

    @_builtins.property
    @pulumi.getter(name="identityTokenKey")
    def identity_token_key(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The key to use for signing plugin workload identity tokens
        """
        return pulumi.get(self, "identity_token_key")

    @_builtins.property
    @pulumi.getter
    def influxdbs(self) -> pulumi.Output[Optional[Sequence['outputs.SecretsMountInfluxdb']]]:
        """
        A nested block containing configuration options for InfluxDB connections.  
        *See Configuration Options for more info*
        """
        return pulumi.get(self, "influxdbs")

    @_builtins.property
    @pulumi.getter(name="listingVisibility")
    def listing_visibility(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies whether to show this mount in the UI-specific listing endpoint
        """
        return pulumi.get(self, "listing_visibility")

    @_builtins.property
    @pulumi.getter
    def local(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Boolean flag that can be explicitly set to true to enforce local mount in HA environment
        """
        return pulumi.get(self, "local")

    @_builtins.property
    @pulumi.getter(name="maxLeaseTtlSeconds")
    def max_lease_ttl_seconds(self) -> pulumi.Output[_builtins.int]:
        """
        Maximum possible lease duration for tokens and secrets in seconds
        """
        return pulumi.get(self, "max_lease_ttl_seconds")

    @_builtins.property
    @pulumi.getter
    def mongodbatlas(self) -> pulumi.Output[Optional[Sequence['outputs.SecretsMountMongodbatla']]]:
        """
        A nested block containing configuration options for MongoDB Atlas connections.  
        *See Configuration Options for more info*
        """
        return pulumi.get(self, "mongodbatlas")

    @_builtins.property
    @pulumi.getter
    def mongodbs(self) -> pulumi.Output[Optional[Sequence['outputs.SecretsMountMongodb']]]:
        """
        A nested block containing configuration options for MongoDB connections.  
        *See Configuration Options for more info*
        """
        return pulumi.get(self, "mongodbs")

    @_builtins.property
    @pulumi.getter
    def mssqls(self) -> pulumi.Output[Optional[Sequence['outputs.SecretsMountMssql']]]:
        """
        A nested block containing configuration options for MSSQL connections.  
        *See Configuration Options for more info*
        """
        return pulumi.get(self, "mssqls")

    @_builtins.property
    @pulumi.getter(name="mysqlAuroras")
    def mysql_auroras(self) -> pulumi.Output[Optional[Sequence['outputs.SecretsMountMysqlAurora']]]:
        """
        A nested block containing configuration options for Aurora MySQL connections.  
        *See Configuration Options for more info*
        """
        return pulumi.get(self, "mysql_auroras")

    @_builtins.property
    @pulumi.getter(name="mysqlLegacies")
    def mysql_legacies(self) -> pulumi.Output[Optional[Sequence['outputs.SecretsMountMysqlLegacy']]]:
        """
        A nested block containing configuration options for legacy MySQL connections.  
        *See Configuration Options for more info*
        """
        return pulumi.get(self, "mysql_legacies")

    @_builtins.property
    @pulumi.getter(name="mysqlRds")
    def mysql_rds(self) -> pulumi.Output[Optional[Sequence['outputs.SecretsMountMysqlRd']]]:
        """
        A nested block containing configuration options for RDS MySQL connections.  
        *See Configuration Options for more info*
        """
        return pulumi.get(self, "mysql_rds")

    @_builtins.property
    @pulumi.getter
    def mysqls(self) -> pulumi.Output[Optional[Sequence['outputs.SecretsMountMysql']]]:
        """
        A nested block containing configuration options for MySQL connections.  
        *See Configuration Options for more info*
        """
        return pulumi.get(self, "mysqls")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Target namespace. (requires Enterprise)
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter
    def options(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Specifies mount type specific options that are passed to the backend
        """
        return pulumi.get(self, "options")

    @_builtins.property
    @pulumi.getter
    def oracles(self) -> pulumi.Output[Optional[Sequence['outputs.SecretsMountOracle']]]:
        """
        A nested block containing configuration options for Oracle connections.  
        *See Configuration Options for more info*
        """
        return pulumi.get(self, "oracles")

    @_builtins.property
    @pulumi.getter(name="passthroughRequestHeaders")
    def passthrough_request_headers(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of headers to allow and pass from the request to the plugin
        """
        return pulumi.get(self, "passthrough_request_headers")

    @_builtins.property
    @pulumi.getter
    def path(self) -> pulumi.Output[_builtins.str]:
        """
        Where the secret backend will be mounted
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter(name="pluginVersion")
    def plugin_version(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the semantic version of the plugin to use, e.g. 'v1.0.0'
        """
        return pulumi.get(self, "plugin_version")

    @_builtins.property
    @pulumi.getter
    def postgresqls(self) -> pulumi.Output[Optional[Sequence['outputs.SecretsMountPostgresql']]]:
        """
        A nested block containing configuration options for PostgreSQL connections.  
        *See Configuration Options for more info*
        """
        return pulumi.get(self, "postgresqls")

    @_builtins.property
    @pulumi.getter
    def redis(self) -> pulumi.Output[Optional[Sequence['outputs.SecretsMountRedi']]]:
        """
        A nested block containing configuration options for Redis connections.  
        *See Configuration Options for more info*
        """
        return pulumi.get(self, "redis")

    @_builtins.property
    @pulumi.getter(name="redisElasticaches")
    def redis_elasticaches(self) -> pulumi.Output[Optional[Sequence['outputs.SecretsMountRedisElasticach']]]:
        """
        A nested block containing configuration options for Redis ElastiCache connections.  
        *See Configuration Options for more info*
        """
        return pulumi.get(self, "redis_elasticaches")

    @_builtins.property
    @pulumi.getter
    def redshifts(self) -> pulumi.Output[Optional[Sequence['outputs.SecretsMountRedshift']]]:
        """
        A nested block containing configuration options for AWS Redshift connections.  
        *See Configuration Options for more info*
        """
        return pulumi.get(self, "redshifts")

    @_builtins.property
    @pulumi.getter(name="sealWrap")
    def seal_wrap(self) -> pulumi.Output[_builtins.bool]:
        """
        Boolean flag that can be explicitly set to true to enable seal wrapping for the mount, causing values stored by the mount to be wrapped by the seal's encryption capability
        """
        return pulumi.get(self, "seal_wrap")

    @_builtins.property
    @pulumi.getter
    def snowflakes(self) -> pulumi.Output[Optional[Sequence['outputs.SecretsMountSnowflake']]]:
        """
        A nested block containing configuration options for Snowflake connections.  
        *See Configuration Options for more info*
        """
        return pulumi.get(self, "snowflakes")

