# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['AuthBackendRoleArgs', 'AuthBackendRole']

@pulumi.input_type
class AuthBackendRoleArgs:
    def __init__(__self__, *,
                 role: pulumi.Input[_builtins.str],
                 type: pulumi.Input[_builtins.str],
                 add_group_aliases: Optional[pulumi.Input[_builtins.bool]] = None,
                 allow_gce_inference: Optional[pulumi.Input[_builtins.bool]] = None,
                 backend: Optional[pulumi.Input[_builtins.str]] = None,
                 bound_instance_groups: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 bound_labels: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 bound_projects: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 bound_regions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 bound_service_accounts: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 bound_zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 max_jwt_exp: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 role_id: Optional[pulumi.Input[_builtins.str]] = None,
                 token_bound_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 token_explicit_max_ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 token_max_ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 token_no_default_policy: Optional[pulumi.Input[_builtins.bool]] = None,
                 token_num_uses: Optional[pulumi.Input[_builtins.int]] = None,
                 token_period: Optional[pulumi.Input[_builtins.int]] = None,
                 token_policies: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 token_ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 token_type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a AuthBackendRole resource.
        :param pulumi.Input[_builtins.str] role: Name of the GCP role
        :param pulumi.Input[_builtins.str] type: Type of GCP authentication role (either `gce` or `iam`)
        :param pulumi.Input[_builtins.str] backend: Path to the mounted GCP auth backend
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] bound_projects: An array of GCP project IDs. Only entities belonging to this project can authenticate under the role.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] bound_service_accounts: GCP Service Accounts allowed to issue tokens under this role. (Note: **Required** if role is `iam`)
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.str] role_id: The role_id is the stable, unique identifier for the role generated by vault.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] token_bound_cidrs: Specifies the blocks of IP addresses which are allowed to use the generated token
        :param pulumi.Input[_builtins.int] token_explicit_max_ttl: Generated Token's Explicit Maximum TTL in seconds
        :param pulumi.Input[_builtins.int] token_max_ttl: The maximum lifetime of the generated token
        :param pulumi.Input[_builtins.bool] token_no_default_policy: If true, the 'default' policy will not automatically be added to generated tokens
        :param pulumi.Input[_builtins.int] token_num_uses: The maximum number of times a token may be used, a value of zero means unlimited
        :param pulumi.Input[_builtins.int] token_period: Generated Token's Period
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] token_policies: Generated Token's Policies
        :param pulumi.Input[_builtins.int] token_ttl: The initial ttl of the token to generate in seconds
        :param pulumi.Input[_builtins.str] token_type: The type of token to generate, service or batch
        """
        pulumi.set(__self__, "role", role)
        pulumi.set(__self__, "type", type)
        if add_group_aliases is not None:
            pulumi.set(__self__, "add_group_aliases", add_group_aliases)
        if allow_gce_inference is not None:
            pulumi.set(__self__, "allow_gce_inference", allow_gce_inference)
        if backend is not None:
            pulumi.set(__self__, "backend", backend)
        if bound_instance_groups is not None:
            pulumi.set(__self__, "bound_instance_groups", bound_instance_groups)
        if bound_labels is not None:
            pulumi.set(__self__, "bound_labels", bound_labels)
        if bound_projects is not None:
            pulumi.set(__self__, "bound_projects", bound_projects)
        if bound_regions is not None:
            pulumi.set(__self__, "bound_regions", bound_regions)
        if bound_service_accounts is not None:
            pulumi.set(__self__, "bound_service_accounts", bound_service_accounts)
        if bound_zones is not None:
            pulumi.set(__self__, "bound_zones", bound_zones)
        if max_jwt_exp is not None:
            pulumi.set(__self__, "max_jwt_exp", max_jwt_exp)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if role_id is not None:
            pulumi.set(__self__, "role_id", role_id)
        if token_bound_cidrs is not None:
            pulumi.set(__self__, "token_bound_cidrs", token_bound_cidrs)
        if token_explicit_max_ttl is not None:
            pulumi.set(__self__, "token_explicit_max_ttl", token_explicit_max_ttl)
        if token_max_ttl is not None:
            pulumi.set(__self__, "token_max_ttl", token_max_ttl)
        if token_no_default_policy is not None:
            pulumi.set(__self__, "token_no_default_policy", token_no_default_policy)
        if token_num_uses is not None:
            pulumi.set(__self__, "token_num_uses", token_num_uses)
        if token_period is not None:
            pulumi.set(__self__, "token_period", token_period)
        if token_policies is not None:
            pulumi.set(__self__, "token_policies", token_policies)
        if token_ttl is not None:
            pulumi.set(__self__, "token_ttl", token_ttl)
        if token_type is not None:
            pulumi.set(__self__, "token_type", token_type)

    @_builtins.property
    @pulumi.getter
    def role(self) -> pulumi.Input[_builtins.str]:
        """
        Name of the GCP role
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "role", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        Type of GCP authentication role (either `gce` or `iam`)
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="addGroupAliases")
    def add_group_aliases(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "add_group_aliases")

    @add_group_aliases.setter
    def add_group_aliases(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "add_group_aliases", value)

    @_builtins.property
    @pulumi.getter(name="allowGceInference")
    def allow_gce_inference(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "allow_gce_inference")

    @allow_gce_inference.setter
    def allow_gce_inference(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "allow_gce_inference", value)

    @_builtins.property
    @pulumi.getter
    def backend(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Path to the mounted GCP auth backend
        """
        return pulumi.get(self, "backend")

    @backend.setter
    def backend(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backend", value)

    @_builtins.property
    @pulumi.getter(name="boundInstanceGroups")
    def bound_instance_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "bound_instance_groups")

    @bound_instance_groups.setter
    def bound_instance_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "bound_instance_groups", value)

    @_builtins.property
    @pulumi.getter(name="boundLabels")
    def bound_labels(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "bound_labels")

    @bound_labels.setter
    def bound_labels(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "bound_labels", value)

    @_builtins.property
    @pulumi.getter(name="boundProjects")
    def bound_projects(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        An array of GCP project IDs. Only entities belonging to this project can authenticate under the role.
        """
        return pulumi.get(self, "bound_projects")

    @bound_projects.setter
    def bound_projects(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "bound_projects", value)

    @_builtins.property
    @pulumi.getter(name="boundRegions")
    def bound_regions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "bound_regions")

    @bound_regions.setter
    def bound_regions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "bound_regions", value)

    @_builtins.property
    @pulumi.getter(name="boundServiceAccounts")
    def bound_service_accounts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        GCP Service Accounts allowed to issue tokens under this role. (Note: **Required** if role is `iam`)
        """
        return pulumi.get(self, "bound_service_accounts")

    @bound_service_accounts.setter
    def bound_service_accounts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "bound_service_accounts", value)

    @_builtins.property
    @pulumi.getter(name="boundZones")
    def bound_zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "bound_zones")

    @bound_zones.setter
    def bound_zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "bound_zones", value)

    @_builtins.property
    @pulumi.getter(name="maxJwtExp")
    def max_jwt_exp(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "max_jwt_exp")

    @max_jwt_exp.setter
    def max_jwt_exp(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "max_jwt_exp", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter(name="roleId")
    def role_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The role_id is the stable, unique identifier for the role generated by vault.
        """
        return pulumi.get(self, "role_id")

    @role_id.setter
    def role_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "role_id", value)

    @_builtins.property
    @pulumi.getter(name="tokenBoundCidrs")
    def token_bound_cidrs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies the blocks of IP addresses which are allowed to use the generated token
        """
        return pulumi.get(self, "token_bound_cidrs")

    @token_bound_cidrs.setter
    def token_bound_cidrs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "token_bound_cidrs", value)

    @_builtins.property
    @pulumi.getter(name="tokenExplicitMaxTtl")
    def token_explicit_max_ttl(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Generated Token's Explicit Maximum TTL in seconds
        """
        return pulumi.get(self, "token_explicit_max_ttl")

    @token_explicit_max_ttl.setter
    def token_explicit_max_ttl(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "token_explicit_max_ttl", value)

    @_builtins.property
    @pulumi.getter(name="tokenMaxTtl")
    def token_max_ttl(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum lifetime of the generated token
        """
        return pulumi.get(self, "token_max_ttl")

    @token_max_ttl.setter
    def token_max_ttl(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "token_max_ttl", value)

    @_builtins.property
    @pulumi.getter(name="tokenNoDefaultPolicy")
    def token_no_default_policy(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If true, the 'default' policy will not automatically be added to generated tokens
        """
        return pulumi.get(self, "token_no_default_policy")

    @token_no_default_policy.setter
    def token_no_default_policy(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "token_no_default_policy", value)

    @_builtins.property
    @pulumi.getter(name="tokenNumUses")
    def token_num_uses(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum number of times a token may be used, a value of zero means unlimited
        """
        return pulumi.get(self, "token_num_uses")

    @token_num_uses.setter
    def token_num_uses(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "token_num_uses", value)

    @_builtins.property
    @pulumi.getter(name="tokenPeriod")
    def token_period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Generated Token's Period
        """
        return pulumi.get(self, "token_period")

    @token_period.setter
    def token_period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "token_period", value)

    @_builtins.property
    @pulumi.getter(name="tokenPolicies")
    def token_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Generated Token's Policies
        """
        return pulumi.get(self, "token_policies")

    @token_policies.setter
    def token_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "token_policies", value)

    @_builtins.property
    @pulumi.getter(name="tokenTtl")
    def token_ttl(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The initial ttl of the token to generate in seconds
        """
        return pulumi.get(self, "token_ttl")

    @token_ttl.setter
    def token_ttl(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "token_ttl", value)

    @_builtins.property
    @pulumi.getter(name="tokenType")
    def token_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of token to generate, service or batch
        """
        return pulumi.get(self, "token_type")

    @token_type.setter
    def token_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "token_type", value)


@pulumi.input_type
class _AuthBackendRoleState:
    def __init__(__self__, *,
                 add_group_aliases: Optional[pulumi.Input[_builtins.bool]] = None,
                 allow_gce_inference: Optional[pulumi.Input[_builtins.bool]] = None,
                 backend: Optional[pulumi.Input[_builtins.str]] = None,
                 bound_instance_groups: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 bound_labels: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 bound_projects: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 bound_regions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 bound_service_accounts: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 bound_zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 max_jwt_exp: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 role: Optional[pulumi.Input[_builtins.str]] = None,
                 role_id: Optional[pulumi.Input[_builtins.str]] = None,
                 token_bound_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 token_explicit_max_ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 token_max_ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 token_no_default_policy: Optional[pulumi.Input[_builtins.bool]] = None,
                 token_num_uses: Optional[pulumi.Input[_builtins.int]] = None,
                 token_period: Optional[pulumi.Input[_builtins.int]] = None,
                 token_policies: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 token_ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 token_type: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering AuthBackendRole resources.
        :param pulumi.Input[_builtins.str] backend: Path to the mounted GCP auth backend
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] bound_projects: An array of GCP project IDs. Only entities belonging to this project can authenticate under the role.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] bound_service_accounts: GCP Service Accounts allowed to issue tokens under this role. (Note: **Required** if role is `iam`)
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.str] role: Name of the GCP role
        :param pulumi.Input[_builtins.str] role_id: The role_id is the stable, unique identifier for the role generated by vault.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] token_bound_cidrs: Specifies the blocks of IP addresses which are allowed to use the generated token
        :param pulumi.Input[_builtins.int] token_explicit_max_ttl: Generated Token's Explicit Maximum TTL in seconds
        :param pulumi.Input[_builtins.int] token_max_ttl: The maximum lifetime of the generated token
        :param pulumi.Input[_builtins.bool] token_no_default_policy: If true, the 'default' policy will not automatically be added to generated tokens
        :param pulumi.Input[_builtins.int] token_num_uses: The maximum number of times a token may be used, a value of zero means unlimited
        :param pulumi.Input[_builtins.int] token_period: Generated Token's Period
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] token_policies: Generated Token's Policies
        :param pulumi.Input[_builtins.int] token_ttl: The initial ttl of the token to generate in seconds
        :param pulumi.Input[_builtins.str] token_type: The type of token to generate, service or batch
        :param pulumi.Input[_builtins.str] type: Type of GCP authentication role (either `gce` or `iam`)
        """
        if add_group_aliases is not None:
            pulumi.set(__self__, "add_group_aliases", add_group_aliases)
        if allow_gce_inference is not None:
            pulumi.set(__self__, "allow_gce_inference", allow_gce_inference)
        if backend is not None:
            pulumi.set(__self__, "backend", backend)
        if bound_instance_groups is not None:
            pulumi.set(__self__, "bound_instance_groups", bound_instance_groups)
        if bound_labels is not None:
            pulumi.set(__self__, "bound_labels", bound_labels)
        if bound_projects is not None:
            pulumi.set(__self__, "bound_projects", bound_projects)
        if bound_regions is not None:
            pulumi.set(__self__, "bound_regions", bound_regions)
        if bound_service_accounts is not None:
            pulumi.set(__self__, "bound_service_accounts", bound_service_accounts)
        if bound_zones is not None:
            pulumi.set(__self__, "bound_zones", bound_zones)
        if max_jwt_exp is not None:
            pulumi.set(__self__, "max_jwt_exp", max_jwt_exp)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if role is not None:
            pulumi.set(__self__, "role", role)
        if role_id is not None:
            pulumi.set(__self__, "role_id", role_id)
        if token_bound_cidrs is not None:
            pulumi.set(__self__, "token_bound_cidrs", token_bound_cidrs)
        if token_explicit_max_ttl is not None:
            pulumi.set(__self__, "token_explicit_max_ttl", token_explicit_max_ttl)
        if token_max_ttl is not None:
            pulumi.set(__self__, "token_max_ttl", token_max_ttl)
        if token_no_default_policy is not None:
            pulumi.set(__self__, "token_no_default_policy", token_no_default_policy)
        if token_num_uses is not None:
            pulumi.set(__self__, "token_num_uses", token_num_uses)
        if token_period is not None:
            pulumi.set(__self__, "token_period", token_period)
        if token_policies is not None:
            pulumi.set(__self__, "token_policies", token_policies)
        if token_ttl is not None:
            pulumi.set(__self__, "token_ttl", token_ttl)
        if token_type is not None:
            pulumi.set(__self__, "token_type", token_type)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="addGroupAliases")
    def add_group_aliases(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "add_group_aliases")

    @add_group_aliases.setter
    def add_group_aliases(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "add_group_aliases", value)

    @_builtins.property
    @pulumi.getter(name="allowGceInference")
    def allow_gce_inference(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "allow_gce_inference")

    @allow_gce_inference.setter
    def allow_gce_inference(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "allow_gce_inference", value)

    @_builtins.property
    @pulumi.getter
    def backend(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Path to the mounted GCP auth backend
        """
        return pulumi.get(self, "backend")

    @backend.setter
    def backend(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backend", value)

    @_builtins.property
    @pulumi.getter(name="boundInstanceGroups")
    def bound_instance_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "bound_instance_groups")

    @bound_instance_groups.setter
    def bound_instance_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "bound_instance_groups", value)

    @_builtins.property
    @pulumi.getter(name="boundLabels")
    def bound_labels(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "bound_labels")

    @bound_labels.setter
    def bound_labels(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "bound_labels", value)

    @_builtins.property
    @pulumi.getter(name="boundProjects")
    def bound_projects(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        An array of GCP project IDs. Only entities belonging to this project can authenticate under the role.
        """
        return pulumi.get(self, "bound_projects")

    @bound_projects.setter
    def bound_projects(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "bound_projects", value)

    @_builtins.property
    @pulumi.getter(name="boundRegions")
    def bound_regions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "bound_regions")

    @bound_regions.setter
    def bound_regions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "bound_regions", value)

    @_builtins.property
    @pulumi.getter(name="boundServiceAccounts")
    def bound_service_accounts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        GCP Service Accounts allowed to issue tokens under this role. (Note: **Required** if role is `iam`)
        """
        return pulumi.get(self, "bound_service_accounts")

    @bound_service_accounts.setter
    def bound_service_accounts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "bound_service_accounts", value)

    @_builtins.property
    @pulumi.getter(name="boundZones")
    def bound_zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "bound_zones")

    @bound_zones.setter
    def bound_zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "bound_zones", value)

    @_builtins.property
    @pulumi.getter(name="maxJwtExp")
    def max_jwt_exp(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "max_jwt_exp")

    @max_jwt_exp.setter
    def max_jwt_exp(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "max_jwt_exp", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter
    def role(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the GCP role
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "role", value)

    @_builtins.property
    @pulumi.getter(name="roleId")
    def role_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The role_id is the stable, unique identifier for the role generated by vault.
        """
        return pulumi.get(self, "role_id")

    @role_id.setter
    def role_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "role_id", value)

    @_builtins.property
    @pulumi.getter(name="tokenBoundCidrs")
    def token_bound_cidrs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies the blocks of IP addresses which are allowed to use the generated token
        """
        return pulumi.get(self, "token_bound_cidrs")

    @token_bound_cidrs.setter
    def token_bound_cidrs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "token_bound_cidrs", value)

    @_builtins.property
    @pulumi.getter(name="tokenExplicitMaxTtl")
    def token_explicit_max_ttl(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Generated Token's Explicit Maximum TTL in seconds
        """
        return pulumi.get(self, "token_explicit_max_ttl")

    @token_explicit_max_ttl.setter
    def token_explicit_max_ttl(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "token_explicit_max_ttl", value)

    @_builtins.property
    @pulumi.getter(name="tokenMaxTtl")
    def token_max_ttl(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum lifetime of the generated token
        """
        return pulumi.get(self, "token_max_ttl")

    @token_max_ttl.setter
    def token_max_ttl(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "token_max_ttl", value)

    @_builtins.property
    @pulumi.getter(name="tokenNoDefaultPolicy")
    def token_no_default_policy(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If true, the 'default' policy will not automatically be added to generated tokens
        """
        return pulumi.get(self, "token_no_default_policy")

    @token_no_default_policy.setter
    def token_no_default_policy(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "token_no_default_policy", value)

    @_builtins.property
    @pulumi.getter(name="tokenNumUses")
    def token_num_uses(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum number of times a token may be used, a value of zero means unlimited
        """
        return pulumi.get(self, "token_num_uses")

    @token_num_uses.setter
    def token_num_uses(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "token_num_uses", value)

    @_builtins.property
    @pulumi.getter(name="tokenPeriod")
    def token_period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Generated Token's Period
        """
        return pulumi.get(self, "token_period")

    @token_period.setter
    def token_period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "token_period", value)

    @_builtins.property
    @pulumi.getter(name="tokenPolicies")
    def token_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Generated Token's Policies
        """
        return pulumi.get(self, "token_policies")

    @token_policies.setter
    def token_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "token_policies", value)

    @_builtins.property
    @pulumi.getter(name="tokenTtl")
    def token_ttl(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The initial ttl of the token to generate in seconds
        """
        return pulumi.get(self, "token_ttl")

    @token_ttl.setter
    def token_ttl(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "token_ttl", value)

    @_builtins.property
    @pulumi.getter(name="tokenType")
    def token_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of token to generate, service or batch
        """
        return pulumi.get(self, "token_type")

    @token_type.setter
    def token_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "token_type", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type of GCP authentication role (either `gce` or `iam`)
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.type_token("vault:gcp/authBackendRole:AuthBackendRole")
class AuthBackendRole(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 add_group_aliases: Optional[pulumi.Input[_builtins.bool]] = None,
                 allow_gce_inference: Optional[pulumi.Input[_builtins.bool]] = None,
                 backend: Optional[pulumi.Input[_builtins.str]] = None,
                 bound_instance_groups: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 bound_labels: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 bound_projects: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 bound_regions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 bound_service_accounts: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 bound_zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 max_jwt_exp: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 role: Optional[pulumi.Input[_builtins.str]] = None,
                 role_id: Optional[pulumi.Input[_builtins.str]] = None,
                 token_bound_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 token_explicit_max_ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 token_max_ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 token_no_default_policy: Optional[pulumi.Input[_builtins.bool]] = None,
                 token_num_uses: Optional[pulumi.Input[_builtins.int]] = None,
                 token_period: Optional[pulumi.Input[_builtins.int]] = None,
                 token_policies: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 token_ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 token_type: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a resource to create a role in an [GCP auth backend within Vault](https://www.vaultproject.io/docs/auth/gcp.html).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_vault as vault

        gcp = vault.AuthBackend("gcp",
            path="gcp",
            type="gcp")
        test = vault.gcp.AuthBackendRole("test",
            backend=gcp.path,
            role="test",
            type="iam",
            bound_service_accounts=["test"],
            bound_projects=["test"],
            token_ttl=300,
            token_max_ttl=600,
            token_policies=[
                "policy_a",
                "policy_b",
            ],
            add_group_aliases=True)
        ```

        ## Import

        GCP authentication roles can be imported using the `path`, e.g.

        ```sh
        $ pulumi import vault:gcp/authBackendRole:AuthBackendRole my_role auth/gcp/role/my_role
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] backend: Path to the mounted GCP auth backend
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] bound_projects: An array of GCP project IDs. Only entities belonging to this project can authenticate under the role.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] bound_service_accounts: GCP Service Accounts allowed to issue tokens under this role. (Note: **Required** if role is `iam`)
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.str] role: Name of the GCP role
        :param pulumi.Input[_builtins.str] role_id: The role_id is the stable, unique identifier for the role generated by vault.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] token_bound_cidrs: Specifies the blocks of IP addresses which are allowed to use the generated token
        :param pulumi.Input[_builtins.int] token_explicit_max_ttl: Generated Token's Explicit Maximum TTL in seconds
        :param pulumi.Input[_builtins.int] token_max_ttl: The maximum lifetime of the generated token
        :param pulumi.Input[_builtins.bool] token_no_default_policy: If true, the 'default' policy will not automatically be added to generated tokens
        :param pulumi.Input[_builtins.int] token_num_uses: The maximum number of times a token may be used, a value of zero means unlimited
        :param pulumi.Input[_builtins.int] token_period: Generated Token's Period
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] token_policies: Generated Token's Policies
        :param pulumi.Input[_builtins.int] token_ttl: The initial ttl of the token to generate in seconds
        :param pulumi.Input[_builtins.str] token_type: The type of token to generate, service or batch
        :param pulumi.Input[_builtins.str] type: Type of GCP authentication role (either `gce` or `iam`)
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AuthBackendRoleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource to create a role in an [GCP auth backend within Vault](https://www.vaultproject.io/docs/auth/gcp.html).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_vault as vault

        gcp = vault.AuthBackend("gcp",
            path="gcp",
            type="gcp")
        test = vault.gcp.AuthBackendRole("test",
            backend=gcp.path,
            role="test",
            type="iam",
            bound_service_accounts=["test"],
            bound_projects=["test"],
            token_ttl=300,
            token_max_ttl=600,
            token_policies=[
                "policy_a",
                "policy_b",
            ],
            add_group_aliases=True)
        ```

        ## Import

        GCP authentication roles can be imported using the `path`, e.g.

        ```sh
        $ pulumi import vault:gcp/authBackendRole:AuthBackendRole my_role auth/gcp/role/my_role
        ```

        :param str resource_name: The name of the resource.
        :param AuthBackendRoleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AuthBackendRoleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 add_group_aliases: Optional[pulumi.Input[_builtins.bool]] = None,
                 allow_gce_inference: Optional[pulumi.Input[_builtins.bool]] = None,
                 backend: Optional[pulumi.Input[_builtins.str]] = None,
                 bound_instance_groups: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 bound_labels: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 bound_projects: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 bound_regions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 bound_service_accounts: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 bound_zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 max_jwt_exp: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 role: Optional[pulumi.Input[_builtins.str]] = None,
                 role_id: Optional[pulumi.Input[_builtins.str]] = None,
                 token_bound_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 token_explicit_max_ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 token_max_ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 token_no_default_policy: Optional[pulumi.Input[_builtins.bool]] = None,
                 token_num_uses: Optional[pulumi.Input[_builtins.int]] = None,
                 token_period: Optional[pulumi.Input[_builtins.int]] = None,
                 token_policies: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 token_ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 token_type: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AuthBackendRoleArgs.__new__(AuthBackendRoleArgs)

            __props__.__dict__["add_group_aliases"] = add_group_aliases
            __props__.__dict__["allow_gce_inference"] = allow_gce_inference
            __props__.__dict__["backend"] = backend
            __props__.__dict__["bound_instance_groups"] = bound_instance_groups
            __props__.__dict__["bound_labels"] = bound_labels
            __props__.__dict__["bound_projects"] = bound_projects
            __props__.__dict__["bound_regions"] = bound_regions
            __props__.__dict__["bound_service_accounts"] = bound_service_accounts
            __props__.__dict__["bound_zones"] = bound_zones
            __props__.__dict__["max_jwt_exp"] = max_jwt_exp
            __props__.__dict__["namespace"] = namespace
            if role is None and not opts.urn:
                raise TypeError("Missing required property 'role'")
            __props__.__dict__["role"] = role
            __props__.__dict__["role_id"] = role_id
            __props__.__dict__["token_bound_cidrs"] = token_bound_cidrs
            __props__.__dict__["token_explicit_max_ttl"] = token_explicit_max_ttl
            __props__.__dict__["token_max_ttl"] = token_max_ttl
            __props__.__dict__["token_no_default_policy"] = token_no_default_policy
            __props__.__dict__["token_num_uses"] = token_num_uses
            __props__.__dict__["token_period"] = token_period
            __props__.__dict__["token_policies"] = token_policies
            __props__.__dict__["token_ttl"] = token_ttl
            __props__.__dict__["token_type"] = token_type
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
        super(AuthBackendRole, __self__).__init__(
            'vault:gcp/authBackendRole:AuthBackendRole',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            add_group_aliases: Optional[pulumi.Input[_builtins.bool]] = None,
            allow_gce_inference: Optional[pulumi.Input[_builtins.bool]] = None,
            backend: Optional[pulumi.Input[_builtins.str]] = None,
            bound_instance_groups: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            bound_labels: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            bound_projects: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            bound_regions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            bound_service_accounts: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            bound_zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            max_jwt_exp: Optional[pulumi.Input[_builtins.str]] = None,
            namespace: Optional[pulumi.Input[_builtins.str]] = None,
            role: Optional[pulumi.Input[_builtins.str]] = None,
            role_id: Optional[pulumi.Input[_builtins.str]] = None,
            token_bound_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            token_explicit_max_ttl: Optional[pulumi.Input[_builtins.int]] = None,
            token_max_ttl: Optional[pulumi.Input[_builtins.int]] = None,
            token_no_default_policy: Optional[pulumi.Input[_builtins.bool]] = None,
            token_num_uses: Optional[pulumi.Input[_builtins.int]] = None,
            token_period: Optional[pulumi.Input[_builtins.int]] = None,
            token_policies: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            token_ttl: Optional[pulumi.Input[_builtins.int]] = None,
            token_type: Optional[pulumi.Input[_builtins.str]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None) -> 'AuthBackendRole':
        """
        Get an existing AuthBackendRole resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] backend: Path to the mounted GCP auth backend
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] bound_projects: An array of GCP project IDs. Only entities belonging to this project can authenticate under the role.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] bound_service_accounts: GCP Service Accounts allowed to issue tokens under this role. (Note: **Required** if role is `iam`)
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.str] role: Name of the GCP role
        :param pulumi.Input[_builtins.str] role_id: The role_id is the stable, unique identifier for the role generated by vault.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] token_bound_cidrs: Specifies the blocks of IP addresses which are allowed to use the generated token
        :param pulumi.Input[_builtins.int] token_explicit_max_ttl: Generated Token's Explicit Maximum TTL in seconds
        :param pulumi.Input[_builtins.int] token_max_ttl: The maximum lifetime of the generated token
        :param pulumi.Input[_builtins.bool] token_no_default_policy: If true, the 'default' policy will not automatically be added to generated tokens
        :param pulumi.Input[_builtins.int] token_num_uses: The maximum number of times a token may be used, a value of zero means unlimited
        :param pulumi.Input[_builtins.int] token_period: Generated Token's Period
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] token_policies: Generated Token's Policies
        :param pulumi.Input[_builtins.int] token_ttl: The initial ttl of the token to generate in seconds
        :param pulumi.Input[_builtins.str] token_type: The type of token to generate, service or batch
        :param pulumi.Input[_builtins.str] type: Type of GCP authentication role (either `gce` or `iam`)
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AuthBackendRoleState.__new__(_AuthBackendRoleState)

        __props__.__dict__["add_group_aliases"] = add_group_aliases
        __props__.__dict__["allow_gce_inference"] = allow_gce_inference
        __props__.__dict__["backend"] = backend
        __props__.__dict__["bound_instance_groups"] = bound_instance_groups
        __props__.__dict__["bound_labels"] = bound_labels
        __props__.__dict__["bound_projects"] = bound_projects
        __props__.__dict__["bound_regions"] = bound_regions
        __props__.__dict__["bound_service_accounts"] = bound_service_accounts
        __props__.__dict__["bound_zones"] = bound_zones
        __props__.__dict__["max_jwt_exp"] = max_jwt_exp
        __props__.__dict__["namespace"] = namespace
        __props__.__dict__["role"] = role
        __props__.__dict__["role_id"] = role_id
        __props__.__dict__["token_bound_cidrs"] = token_bound_cidrs
        __props__.__dict__["token_explicit_max_ttl"] = token_explicit_max_ttl
        __props__.__dict__["token_max_ttl"] = token_max_ttl
        __props__.__dict__["token_no_default_policy"] = token_no_default_policy
        __props__.__dict__["token_num_uses"] = token_num_uses
        __props__.__dict__["token_period"] = token_period
        __props__.__dict__["token_policies"] = token_policies
        __props__.__dict__["token_ttl"] = token_ttl
        __props__.__dict__["token_type"] = token_type
        __props__.__dict__["type"] = type
        return AuthBackendRole(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="addGroupAliases")
    def add_group_aliases(self) -> pulumi.Output[_builtins.bool]:
        return pulumi.get(self, "add_group_aliases")

    @_builtins.property
    @pulumi.getter(name="allowGceInference")
    def allow_gce_inference(self) -> pulumi.Output[_builtins.bool]:
        return pulumi.get(self, "allow_gce_inference")

    @_builtins.property
    @pulumi.getter
    def backend(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Path to the mounted GCP auth backend
        """
        return pulumi.get(self, "backend")

    @_builtins.property
    @pulumi.getter(name="boundInstanceGroups")
    def bound_instance_groups(self) -> pulumi.Output[Sequence[_builtins.str]]:
        return pulumi.get(self, "bound_instance_groups")

    @_builtins.property
    @pulumi.getter(name="boundLabels")
    def bound_labels(self) -> pulumi.Output[Sequence[_builtins.str]]:
        return pulumi.get(self, "bound_labels")

    @_builtins.property
    @pulumi.getter(name="boundProjects")
    def bound_projects(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        An array of GCP project IDs. Only entities belonging to this project can authenticate under the role.
        """
        return pulumi.get(self, "bound_projects")

    @_builtins.property
    @pulumi.getter(name="boundRegions")
    def bound_regions(self) -> pulumi.Output[Sequence[_builtins.str]]:
        return pulumi.get(self, "bound_regions")

    @_builtins.property
    @pulumi.getter(name="boundServiceAccounts")
    def bound_service_accounts(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        GCP Service Accounts allowed to issue tokens under this role. (Note: **Required** if role is `iam`)
        """
        return pulumi.get(self, "bound_service_accounts")

    @_builtins.property
    @pulumi.getter(name="boundZones")
    def bound_zones(self) -> pulumi.Output[Sequence[_builtins.str]]:
        return pulumi.get(self, "bound_zones")

    @_builtins.property
    @pulumi.getter(name="maxJwtExp")
    def max_jwt_exp(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "max_jwt_exp")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter
    def role(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the GCP role
        """
        return pulumi.get(self, "role")

    @_builtins.property
    @pulumi.getter(name="roleId")
    def role_id(self) -> pulumi.Output[_builtins.str]:
        """
        The role_id is the stable, unique identifier for the role generated by vault.
        """
        return pulumi.get(self, "role_id")

    @_builtins.property
    @pulumi.getter(name="tokenBoundCidrs")
    def token_bound_cidrs(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Specifies the blocks of IP addresses which are allowed to use the generated token
        """
        return pulumi.get(self, "token_bound_cidrs")

    @_builtins.property
    @pulumi.getter(name="tokenExplicitMaxTtl")
    def token_explicit_max_ttl(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Generated Token's Explicit Maximum TTL in seconds
        """
        return pulumi.get(self, "token_explicit_max_ttl")

    @_builtins.property
    @pulumi.getter(name="tokenMaxTtl")
    def token_max_ttl(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The maximum lifetime of the generated token
        """
        return pulumi.get(self, "token_max_ttl")

    @_builtins.property
    @pulumi.getter(name="tokenNoDefaultPolicy")
    def token_no_default_policy(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        If true, the 'default' policy will not automatically be added to generated tokens
        """
        return pulumi.get(self, "token_no_default_policy")

    @_builtins.property
    @pulumi.getter(name="tokenNumUses")
    def token_num_uses(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The maximum number of times a token may be used, a value of zero means unlimited
        """
        return pulumi.get(self, "token_num_uses")

    @_builtins.property
    @pulumi.getter(name="tokenPeriod")
    def token_period(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Generated Token's Period
        """
        return pulumi.get(self, "token_period")

    @_builtins.property
    @pulumi.getter(name="tokenPolicies")
    def token_policies(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Generated Token's Policies
        """
        return pulumi.get(self, "token_policies")

    @_builtins.property
    @pulumi.getter(name="tokenTtl")
    def token_ttl(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The initial ttl of the token to generate in seconds
        """
        return pulumi.get(self, "token_ttl")

    @_builtins.property
    @pulumi.getter(name="tokenType")
    def token_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The type of token to generate, service or batch
        """
        return pulumi.get(self, "token_type")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        Type of GCP authentication role (either `gce` or `iam`)
        """
        return pulumi.get(self, "type")

