# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetSecretResult',
    'AwaitableGetSecretResult',
    'get_secret',
    'get_secret_output',
]

@pulumi.output_type
class GetSecretResult:
    """
    A collection of values returned by getSecret.
    """
    def __init__(__self__, data=None, data_json=None, id=None, lease_duration=None, lease_id=None, lease_renewable=None, lease_start_time=None, namespace=None, path=None, version=None, with_lease_start_time=None):
        if data and not isinstance(data, dict):
            raise TypeError("Expected argument 'data' to be a dict")
        pulumi.set(__self__, "data", data)
        if data_json and not isinstance(data_json, str):
            raise TypeError("Expected argument 'data_json' to be a str")
        pulumi.set(__self__, "data_json", data_json)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if lease_duration and not isinstance(lease_duration, int):
            raise TypeError("Expected argument 'lease_duration' to be a int")
        pulumi.set(__self__, "lease_duration", lease_duration)
        if lease_id and not isinstance(lease_id, str):
            raise TypeError("Expected argument 'lease_id' to be a str")
        pulumi.set(__self__, "lease_id", lease_id)
        if lease_renewable and not isinstance(lease_renewable, bool):
            raise TypeError("Expected argument 'lease_renewable' to be a bool")
        pulumi.set(__self__, "lease_renewable", lease_renewable)
        if lease_start_time and not isinstance(lease_start_time, str):
            raise TypeError("Expected argument 'lease_start_time' to be a str")
        pulumi.set(__self__, "lease_start_time", lease_start_time)
        if namespace and not isinstance(namespace, str):
            raise TypeError("Expected argument 'namespace' to be a str")
        pulumi.set(__self__, "namespace", namespace)
        if path and not isinstance(path, str):
            raise TypeError("Expected argument 'path' to be a str")
        pulumi.set(__self__, "path", path)
        if version and not isinstance(version, int):
            raise TypeError("Expected argument 'version' to be a int")
        pulumi.set(__self__, "version", version)
        if with_lease_start_time and not isinstance(with_lease_start_time, bool):
            raise TypeError("Expected argument 'with_lease_start_time' to be a bool")
        pulumi.set(__self__, "with_lease_start_time", with_lease_start_time)

    @_builtins.property
    @pulumi.getter
    def data(self) -> Mapping[str, _builtins.str]:
        """
        A mapping whose keys are the top-level data keys returned from
        Vault and whose values are the corresponding values. This map can only
        represent string data, so any non-string values returned from Vault are
        serialized as JSON.
        """
        return pulumi.get(self, "data")

    @_builtins.property
    @pulumi.getter(name="dataJson")
    def data_json(self) -> _builtins.str:
        """
        A string containing the full data payload retrieved from
        Vault, serialized in JSON format.
        """
        return pulumi.get(self, "data_json")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="leaseDuration")
    def lease_duration(self) -> _builtins.int:
        """
        The duration of the secret lease, in seconds relative
        to the time the data was requested. Once this time has passed any plan
        generated with this data may fail to apply.
        """
        return pulumi.get(self, "lease_duration")

    @_builtins.property
    @pulumi.getter(name="leaseId")
    def lease_id(self) -> _builtins.str:
        """
        The lease identifier assigned by Vault, if any.
        """
        return pulumi.get(self, "lease_id")

    @_builtins.property
    @pulumi.getter(name="leaseRenewable")
    def lease_renewable(self) -> _builtins.bool:
        return pulumi.get(self, "lease_renewable")

    @_builtins.property
    @pulumi.getter(name="leaseStartTime")
    def lease_start_time(self) -> _builtins.str:
        return pulumi.get(self, "lease_start_time")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter
    def path(self) -> _builtins.str:
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "version")

    @_builtins.property
    @pulumi.getter(name="withLeaseStartTime")
    def with_lease_start_time(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "with_lease_start_time")


class AwaitableGetSecretResult(GetSecretResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSecretResult(
            data=self.data,
            data_json=self.data_json,
            id=self.id,
            lease_duration=self.lease_duration,
            lease_id=self.lease_id,
            lease_renewable=self.lease_renewable,
            lease_start_time=self.lease_start_time,
            namespace=self.namespace,
            path=self.path,
            version=self.version,
            with_lease_start_time=self.with_lease_start_time)


def get_secret(namespace: Optional[_builtins.str] = None,
               path: Optional[_builtins.str] = None,
               version: Optional[_builtins.int] = None,
               with_lease_start_time: Optional[_builtins.bool] = None,
               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSecretResult:
    """
    ## Example Usage

    ### Generic secret

    ```python
    import pulumi
    import pulumi_vault as vault

    rundeck_auth = vault.generic.get_secret(path="secret/rundeck_auth")
    ```

    ### KV

    For this example, consider `example` as a path for a KV engine.

    ```python
    import pulumi
    import pulumi_vault as vault


    def not_implemented(msg):
        raise NotImplementedError(msg)

    example_creds = vault.generic.get_secret(path="example/creds")
    example_template = not_implemented("The template_file data resource is not yet supported.")
    ```

    ## Required Vault Capabilities

    Use of this resource requires the `read` capability on the given path.


    :param _builtins.str namespace: The namespace of the target resource.
           The value should not contain leading or trailing forward slashes.
           The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
           *Available only for Vault Enterprise*.
    :param _builtins.str path: The full logical path from which to request data.
           To read data from the "generic" secret backend mounted in Vault by
           default, this should be prefixed with `secret/`. Reading from other backends
           with this data source is possible; consult each backend's documentation
           to see which endpoints support the `GET` method.
    :param _builtins.int version: The version of the secret to read. This is used by the
           Vault KV secrets engine - version 2 to indicate which version of the secret
           to read.
    :param _builtins.bool with_lease_start_time: If set to true, stores `lease_start_time` in the TF state.
           Note that storing the `lease_start_time` in the TF state will cause a persistent drift
           on every `pulumi preview` and will require a `pulumi up`.
    """
    __args__ = dict()
    __args__['namespace'] = namespace
    __args__['path'] = path
    __args__['version'] = version
    __args__['withLeaseStartTime'] = with_lease_start_time
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('vault:generic/getSecret:getSecret', __args__, opts=opts, typ=GetSecretResult).value

    return AwaitableGetSecretResult(
        data=pulumi.get(__ret__, 'data'),
        data_json=pulumi.get(__ret__, 'data_json'),
        id=pulumi.get(__ret__, 'id'),
        lease_duration=pulumi.get(__ret__, 'lease_duration'),
        lease_id=pulumi.get(__ret__, 'lease_id'),
        lease_renewable=pulumi.get(__ret__, 'lease_renewable'),
        lease_start_time=pulumi.get(__ret__, 'lease_start_time'),
        namespace=pulumi.get(__ret__, 'namespace'),
        path=pulumi.get(__ret__, 'path'),
        version=pulumi.get(__ret__, 'version'),
        with_lease_start_time=pulumi.get(__ret__, 'with_lease_start_time'))
def get_secret_output(namespace: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                      path: Optional[pulumi.Input[_builtins.str]] = None,
                      version: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                      with_lease_start_time: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSecretResult]:
    """
    ## Example Usage

    ### Generic secret

    ```python
    import pulumi
    import pulumi_vault as vault

    rundeck_auth = vault.generic.get_secret(path="secret/rundeck_auth")
    ```

    ### KV

    For this example, consider `example` as a path for a KV engine.

    ```python
    import pulumi
    import pulumi_vault as vault


    def not_implemented(msg):
        raise NotImplementedError(msg)

    example_creds = vault.generic.get_secret(path="example/creds")
    example_template = not_implemented("The template_file data resource is not yet supported.")
    ```

    ## Required Vault Capabilities

    Use of this resource requires the `read` capability on the given path.


    :param _builtins.str namespace: The namespace of the target resource.
           The value should not contain leading or trailing forward slashes.
           The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
           *Available only for Vault Enterprise*.
    :param _builtins.str path: The full logical path from which to request data.
           To read data from the "generic" secret backend mounted in Vault by
           default, this should be prefixed with `secret/`. Reading from other backends
           with this data source is possible; consult each backend's documentation
           to see which endpoints support the `GET` method.
    :param _builtins.int version: The version of the secret to read. This is used by the
           Vault KV secrets engine - version 2 to indicate which version of the secret
           to read.
    :param _builtins.bool with_lease_start_time: If set to true, stores `lease_start_time` in the TF state.
           Note that storing the `lease_start_time` in the TF state will cause a persistent drift
           on every `pulumi preview` and will require a `pulumi up`.
    """
    __args__ = dict()
    __args__['namespace'] = namespace
    __args__['path'] = path
    __args__['version'] = version
    __args__['withLeaseStartTime'] = with_lease_start_time
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('vault:generic/getSecret:getSecret', __args__, opts=opts, typ=GetSecretResult)
    return __ret__.apply(lambda __response__: GetSecretResult(
        data=pulumi.get(__response__, 'data'),
        data_json=pulumi.get(__response__, 'data_json'),
        id=pulumi.get(__response__, 'id'),
        lease_duration=pulumi.get(__response__, 'lease_duration'),
        lease_id=pulumi.get(__response__, 'lease_id'),
        lease_renewable=pulumi.get(__response__, 'lease_renewable'),
        lease_start_time=pulumi.get(__response__, 'lease_start_time'),
        namespace=pulumi.get(__response__, 'namespace'),
        path=pulumi.get(__response__, 'path'),
        version=pulumi.get(__response__, 'version'),
        with_lease_start_time=pulumi.get(__response__, 'with_lease_start_time')))
