# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['SecretBackendArgs', 'SecretBackend']

@pulumi.input_type
class SecretBackendArgs:
    def __init__(__self__, *,
                 path: pulumi.Input[_builtins.str],
                 allowed_managed_keys: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 allowed_response_headers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 audit_non_hmac_request_keys: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 audit_non_hmac_response_keys: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 default_lease_ttl_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 default_tls_client_key_bits: Optional[pulumi.Input[_builtins.int]] = None,
                 default_tls_client_key_type: Optional[pulumi.Input[_builtins.str]] = None,
                 default_tls_client_ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 delegated_auth_accessors: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disable_remount: Optional[pulumi.Input[_builtins.bool]] = None,
                 external_entropy_access: Optional[pulumi.Input[_builtins.bool]] = None,
                 force_no_cache: Optional[pulumi.Input[_builtins.bool]] = None,
                 identity_token_key: Optional[pulumi.Input[_builtins.str]] = None,
                 listen_addrs: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 listing_visibility: Optional[pulumi.Input[_builtins.str]] = None,
                 local: Optional[pulumi.Input[_builtins.bool]] = None,
                 max_lease_ttl_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 options: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 passthrough_request_headers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 plugin_version: Optional[pulumi.Input[_builtins.str]] = None,
                 seal_wrap: Optional[pulumi.Input[_builtins.bool]] = None,
                 server_hostnames: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 server_ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tls_ca_key_bits: Optional[pulumi.Input[_builtins.int]] = None,
                 tls_ca_key_type: Optional[pulumi.Input[_builtins.str]] = None,
                 tls_min_version: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a SecretBackend resource.
        :param pulumi.Input[_builtins.str] path: The unique path this backend should be mounted at. Must
               not begin or end with a `/`. Defaults to `kmip`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_managed_keys: List of managed key registry entry names that the mount in question is allowed to access
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_response_headers: List of headers to allow and pass from the request to the plugin
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] audit_non_hmac_request_keys: Specifies the list of keys that will not be HMAC'd by audit devices in the request data object.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] audit_non_hmac_response_keys: Specifies the list of keys that will not be HMAC'd by audit devices in the response data object.
        :param pulumi.Input[_builtins.int] default_lease_ttl_seconds: Default lease duration for tokens and secrets in seconds
        :param pulumi.Input[_builtins.int] default_tls_client_key_bits: Client certificate key bits, valid values depend on key type.
        :param pulumi.Input[_builtins.str] default_tls_client_key_type: Client certificate key type, `rsa` or `ec`.
        :param pulumi.Input[_builtins.int] default_tls_client_ttl: Client certificate TTL in seconds
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] delegated_auth_accessors: List of headers to allow and pass from the request to the plugin
        :param pulumi.Input[_builtins.str] description: Human-friendly description of the mount for the backend
        :param pulumi.Input[_builtins.bool] disable_remount: If set, opts out of mount migration on path updates.
               See here for more info on [Mount Migration](https://www.vaultproject.io/docs/concepts/mount-migration)
        :param pulumi.Input[_builtins.bool] external_entropy_access: Enable the secrets engine to access Vault's external entropy source
        :param pulumi.Input[_builtins.bool] force_no_cache: If set to true, disables caching.
        :param pulumi.Input[_builtins.str] identity_token_key: The key to use for signing plugin workload identity tokens
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] listen_addrs: Addresses the KMIP server should listen on (`host:port`).
        :param pulumi.Input[_builtins.str] listing_visibility: Specifies whether to show this mount in the UI-specific listing endpoint
        :param pulumi.Input[_builtins.bool] local: Local mount flag that can be explicitly set to true to enforce local mount in HA environment
        :param pulumi.Input[_builtins.int] max_lease_ttl_seconds: Maximum possible lease duration for tokens and secrets in seconds
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] options: Specifies mount type specific options that are passed to the backend
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] passthrough_request_headers: List of headers to allow and pass from the request to the plugin
        :param pulumi.Input[_builtins.str] plugin_version: Specifies the semantic version of the plugin to use, e.g. 'v1.0.0'
        :param pulumi.Input[_builtins.bool] seal_wrap: Enable seal wrapping for the mount, causing values stored by the mount to be wrapped by the seal's encryption capability
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] server_hostnames: Hostnames to include in the server's TLS certificate as SAN DNS names. The first will be used as the common name (CN).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] server_ips: IPs to include in the server's TLS certificate as SAN IP addresses.
        :param pulumi.Input[_builtins.int] tls_ca_key_bits: CA key bits, valid values depend on key type.
        :param pulumi.Input[_builtins.str] tls_ca_key_type: CA key type, rsa or ec.
        :param pulumi.Input[_builtins.str] tls_min_version: Minimum TLS version to accept.
        """
        pulumi.set(__self__, "path", path)
        if allowed_managed_keys is not None:
            pulumi.set(__self__, "allowed_managed_keys", allowed_managed_keys)
        if allowed_response_headers is not None:
            pulumi.set(__self__, "allowed_response_headers", allowed_response_headers)
        if audit_non_hmac_request_keys is not None:
            pulumi.set(__self__, "audit_non_hmac_request_keys", audit_non_hmac_request_keys)
        if audit_non_hmac_response_keys is not None:
            pulumi.set(__self__, "audit_non_hmac_response_keys", audit_non_hmac_response_keys)
        if default_lease_ttl_seconds is not None:
            pulumi.set(__self__, "default_lease_ttl_seconds", default_lease_ttl_seconds)
        if default_tls_client_key_bits is not None:
            pulumi.set(__self__, "default_tls_client_key_bits", default_tls_client_key_bits)
        if default_tls_client_key_type is not None:
            pulumi.set(__self__, "default_tls_client_key_type", default_tls_client_key_type)
        if default_tls_client_ttl is not None:
            pulumi.set(__self__, "default_tls_client_ttl", default_tls_client_ttl)
        if delegated_auth_accessors is not None:
            pulumi.set(__self__, "delegated_auth_accessors", delegated_auth_accessors)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disable_remount is not None:
            pulumi.set(__self__, "disable_remount", disable_remount)
        if external_entropy_access is not None:
            pulumi.set(__self__, "external_entropy_access", external_entropy_access)
        if force_no_cache is not None:
            pulumi.set(__self__, "force_no_cache", force_no_cache)
        if identity_token_key is not None:
            pulumi.set(__self__, "identity_token_key", identity_token_key)
        if listen_addrs is not None:
            pulumi.set(__self__, "listen_addrs", listen_addrs)
        if listing_visibility is not None:
            pulumi.set(__self__, "listing_visibility", listing_visibility)
        if local is not None:
            pulumi.set(__self__, "local", local)
        if max_lease_ttl_seconds is not None:
            pulumi.set(__self__, "max_lease_ttl_seconds", max_lease_ttl_seconds)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if options is not None:
            pulumi.set(__self__, "options", options)
        if passthrough_request_headers is not None:
            pulumi.set(__self__, "passthrough_request_headers", passthrough_request_headers)
        if plugin_version is not None:
            pulumi.set(__self__, "plugin_version", plugin_version)
        if seal_wrap is not None:
            pulumi.set(__self__, "seal_wrap", seal_wrap)
        if server_hostnames is not None:
            pulumi.set(__self__, "server_hostnames", server_hostnames)
        if server_ips is not None:
            pulumi.set(__self__, "server_ips", server_ips)
        if tls_ca_key_bits is not None:
            pulumi.set(__self__, "tls_ca_key_bits", tls_ca_key_bits)
        if tls_ca_key_type is not None:
            pulumi.set(__self__, "tls_ca_key_type", tls_ca_key_type)
        if tls_min_version is not None:
            pulumi.set(__self__, "tls_min_version", tls_min_version)

    @_builtins.property
    @pulumi.getter
    def path(self) -> pulumi.Input[_builtins.str]:
        """
        The unique path this backend should be mounted at. Must
        not begin or end with a `/`. Defaults to `kmip`.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "path", value)

    @_builtins.property
    @pulumi.getter(name="allowedManagedKeys")
    def allowed_managed_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of managed key registry entry names that the mount in question is allowed to access
        """
        return pulumi.get(self, "allowed_managed_keys")

    @allowed_managed_keys.setter
    def allowed_managed_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "allowed_managed_keys", value)

    @_builtins.property
    @pulumi.getter(name="allowedResponseHeaders")
    def allowed_response_headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of headers to allow and pass from the request to the plugin
        """
        return pulumi.get(self, "allowed_response_headers")

    @allowed_response_headers.setter
    def allowed_response_headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "allowed_response_headers", value)

    @_builtins.property
    @pulumi.getter(name="auditNonHmacRequestKeys")
    def audit_non_hmac_request_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies the list of keys that will not be HMAC'd by audit devices in the request data object.
        """
        return pulumi.get(self, "audit_non_hmac_request_keys")

    @audit_non_hmac_request_keys.setter
    def audit_non_hmac_request_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "audit_non_hmac_request_keys", value)

    @_builtins.property
    @pulumi.getter(name="auditNonHmacResponseKeys")
    def audit_non_hmac_response_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies the list of keys that will not be HMAC'd by audit devices in the response data object.
        """
        return pulumi.get(self, "audit_non_hmac_response_keys")

    @audit_non_hmac_response_keys.setter
    def audit_non_hmac_response_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "audit_non_hmac_response_keys", value)

    @_builtins.property
    @pulumi.getter(name="defaultLeaseTtlSeconds")
    def default_lease_ttl_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Default lease duration for tokens and secrets in seconds
        """
        return pulumi.get(self, "default_lease_ttl_seconds")

    @default_lease_ttl_seconds.setter
    def default_lease_ttl_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "default_lease_ttl_seconds", value)

    @_builtins.property
    @pulumi.getter(name="defaultTlsClientKeyBits")
    def default_tls_client_key_bits(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Client certificate key bits, valid values depend on key type.
        """
        return pulumi.get(self, "default_tls_client_key_bits")

    @default_tls_client_key_bits.setter
    def default_tls_client_key_bits(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "default_tls_client_key_bits", value)

    @_builtins.property
    @pulumi.getter(name="defaultTlsClientKeyType")
    def default_tls_client_key_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Client certificate key type, `rsa` or `ec`.
        """
        return pulumi.get(self, "default_tls_client_key_type")

    @default_tls_client_key_type.setter
    def default_tls_client_key_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_tls_client_key_type", value)

    @_builtins.property
    @pulumi.getter(name="defaultTlsClientTtl")
    def default_tls_client_ttl(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Client certificate TTL in seconds
        """
        return pulumi.get(self, "default_tls_client_ttl")

    @default_tls_client_ttl.setter
    def default_tls_client_ttl(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "default_tls_client_ttl", value)

    @_builtins.property
    @pulumi.getter(name="delegatedAuthAccessors")
    def delegated_auth_accessors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of headers to allow and pass from the request to the plugin
        """
        return pulumi.get(self, "delegated_auth_accessors")

    @delegated_auth_accessors.setter
    def delegated_auth_accessors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "delegated_auth_accessors", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Human-friendly description of the mount for the backend
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="disableRemount")
    def disable_remount(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If set, opts out of mount migration on path updates.
        See here for more info on [Mount Migration](https://www.vaultproject.io/docs/concepts/mount-migration)
        """
        return pulumi.get(self, "disable_remount")

    @disable_remount.setter
    def disable_remount(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disable_remount", value)

    @_builtins.property
    @pulumi.getter(name="externalEntropyAccess")
    def external_entropy_access(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable the secrets engine to access Vault's external entropy source
        """
        return pulumi.get(self, "external_entropy_access")

    @external_entropy_access.setter
    def external_entropy_access(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "external_entropy_access", value)

    @_builtins.property
    @pulumi.getter(name="forceNoCache")
    def force_no_cache(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If set to true, disables caching.
        """
        return pulumi.get(self, "force_no_cache")

    @force_no_cache.setter
    def force_no_cache(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "force_no_cache", value)

    @_builtins.property
    @pulumi.getter(name="identityTokenKey")
    def identity_token_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The key to use for signing plugin workload identity tokens
        """
        return pulumi.get(self, "identity_token_key")

    @identity_token_key.setter
    def identity_token_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "identity_token_key", value)

    @_builtins.property
    @pulumi.getter(name="listenAddrs")
    def listen_addrs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Addresses the KMIP server should listen on (`host:port`).
        """
        return pulumi.get(self, "listen_addrs")

    @listen_addrs.setter
    def listen_addrs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "listen_addrs", value)

    @_builtins.property
    @pulumi.getter(name="listingVisibility")
    def listing_visibility(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies whether to show this mount in the UI-specific listing endpoint
        """
        return pulumi.get(self, "listing_visibility")

    @listing_visibility.setter
    def listing_visibility(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "listing_visibility", value)

    @_builtins.property
    @pulumi.getter
    def local(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Local mount flag that can be explicitly set to true to enforce local mount in HA environment
        """
        return pulumi.get(self, "local")

    @local.setter
    def local(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "local", value)

    @_builtins.property
    @pulumi.getter(name="maxLeaseTtlSeconds")
    def max_lease_ttl_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Maximum possible lease duration for tokens and secrets in seconds
        """
        return pulumi.get(self, "max_lease_ttl_seconds")

    @max_lease_ttl_seconds.setter
    def max_lease_ttl_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_lease_ttl_seconds", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter
    def options(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Specifies mount type specific options that are passed to the backend
        """
        return pulumi.get(self, "options")

    @options.setter
    def options(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "options", value)

    @_builtins.property
    @pulumi.getter(name="passthroughRequestHeaders")
    def passthrough_request_headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of headers to allow and pass from the request to the plugin
        """
        return pulumi.get(self, "passthrough_request_headers")

    @passthrough_request_headers.setter
    def passthrough_request_headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "passthrough_request_headers", value)

    @_builtins.property
    @pulumi.getter(name="pluginVersion")
    def plugin_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the semantic version of the plugin to use, e.g. 'v1.0.0'
        """
        return pulumi.get(self, "plugin_version")

    @plugin_version.setter
    def plugin_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "plugin_version", value)

    @_builtins.property
    @pulumi.getter(name="sealWrap")
    def seal_wrap(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable seal wrapping for the mount, causing values stored by the mount to be wrapped by the seal's encryption capability
        """
        return pulumi.get(self, "seal_wrap")

    @seal_wrap.setter
    def seal_wrap(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "seal_wrap", value)

    @_builtins.property
    @pulumi.getter(name="serverHostnames")
    def server_hostnames(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Hostnames to include in the server's TLS certificate as SAN DNS names. The first will be used as the common name (CN).
        """
        return pulumi.get(self, "server_hostnames")

    @server_hostnames.setter
    def server_hostnames(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "server_hostnames", value)

    @_builtins.property
    @pulumi.getter(name="serverIps")
    def server_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        IPs to include in the server's TLS certificate as SAN IP addresses.
        """
        return pulumi.get(self, "server_ips")

    @server_ips.setter
    def server_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "server_ips", value)

    @_builtins.property
    @pulumi.getter(name="tlsCaKeyBits")
    def tls_ca_key_bits(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        CA key bits, valid values depend on key type.
        """
        return pulumi.get(self, "tls_ca_key_bits")

    @tls_ca_key_bits.setter
    def tls_ca_key_bits(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "tls_ca_key_bits", value)

    @_builtins.property
    @pulumi.getter(name="tlsCaKeyType")
    def tls_ca_key_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        CA key type, rsa or ec.
        """
        return pulumi.get(self, "tls_ca_key_type")

    @tls_ca_key_type.setter
    def tls_ca_key_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tls_ca_key_type", value)

    @_builtins.property
    @pulumi.getter(name="tlsMinVersion")
    def tls_min_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Minimum TLS version to accept.
        """
        return pulumi.get(self, "tls_min_version")

    @tls_min_version.setter
    def tls_min_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tls_min_version", value)


@pulumi.input_type
class _SecretBackendState:
    def __init__(__self__, *,
                 accessor: Optional[pulumi.Input[_builtins.str]] = None,
                 allowed_managed_keys: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 allowed_response_headers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 audit_non_hmac_request_keys: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 audit_non_hmac_response_keys: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 default_lease_ttl_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 default_tls_client_key_bits: Optional[pulumi.Input[_builtins.int]] = None,
                 default_tls_client_key_type: Optional[pulumi.Input[_builtins.str]] = None,
                 default_tls_client_ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 delegated_auth_accessors: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disable_remount: Optional[pulumi.Input[_builtins.bool]] = None,
                 external_entropy_access: Optional[pulumi.Input[_builtins.bool]] = None,
                 force_no_cache: Optional[pulumi.Input[_builtins.bool]] = None,
                 identity_token_key: Optional[pulumi.Input[_builtins.str]] = None,
                 listen_addrs: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 listing_visibility: Optional[pulumi.Input[_builtins.str]] = None,
                 local: Optional[pulumi.Input[_builtins.bool]] = None,
                 max_lease_ttl_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 options: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 passthrough_request_headers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 path: Optional[pulumi.Input[_builtins.str]] = None,
                 plugin_version: Optional[pulumi.Input[_builtins.str]] = None,
                 seal_wrap: Optional[pulumi.Input[_builtins.bool]] = None,
                 server_hostnames: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 server_ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tls_ca_key_bits: Optional[pulumi.Input[_builtins.int]] = None,
                 tls_ca_key_type: Optional[pulumi.Input[_builtins.str]] = None,
                 tls_min_version: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering SecretBackend resources.
        :param pulumi.Input[_builtins.str] accessor: Accessor of the mount
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_managed_keys: List of managed key registry entry names that the mount in question is allowed to access
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_response_headers: List of headers to allow and pass from the request to the plugin
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] audit_non_hmac_request_keys: Specifies the list of keys that will not be HMAC'd by audit devices in the request data object.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] audit_non_hmac_response_keys: Specifies the list of keys that will not be HMAC'd by audit devices in the response data object.
        :param pulumi.Input[_builtins.int] default_lease_ttl_seconds: Default lease duration for tokens and secrets in seconds
        :param pulumi.Input[_builtins.int] default_tls_client_key_bits: Client certificate key bits, valid values depend on key type.
        :param pulumi.Input[_builtins.str] default_tls_client_key_type: Client certificate key type, `rsa` or `ec`.
        :param pulumi.Input[_builtins.int] default_tls_client_ttl: Client certificate TTL in seconds
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] delegated_auth_accessors: List of headers to allow and pass from the request to the plugin
        :param pulumi.Input[_builtins.str] description: Human-friendly description of the mount for the backend
        :param pulumi.Input[_builtins.bool] disable_remount: If set, opts out of mount migration on path updates.
               See here for more info on [Mount Migration](https://www.vaultproject.io/docs/concepts/mount-migration)
        :param pulumi.Input[_builtins.bool] external_entropy_access: Enable the secrets engine to access Vault's external entropy source
        :param pulumi.Input[_builtins.bool] force_no_cache: If set to true, disables caching.
        :param pulumi.Input[_builtins.str] identity_token_key: The key to use for signing plugin workload identity tokens
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] listen_addrs: Addresses the KMIP server should listen on (`host:port`).
        :param pulumi.Input[_builtins.str] listing_visibility: Specifies whether to show this mount in the UI-specific listing endpoint
        :param pulumi.Input[_builtins.bool] local: Local mount flag that can be explicitly set to true to enforce local mount in HA environment
        :param pulumi.Input[_builtins.int] max_lease_ttl_seconds: Maximum possible lease duration for tokens and secrets in seconds
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] options: Specifies mount type specific options that are passed to the backend
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] passthrough_request_headers: List of headers to allow and pass from the request to the plugin
        :param pulumi.Input[_builtins.str] path: The unique path this backend should be mounted at. Must
               not begin or end with a `/`. Defaults to `kmip`.
        :param pulumi.Input[_builtins.str] plugin_version: Specifies the semantic version of the plugin to use, e.g. 'v1.0.0'
        :param pulumi.Input[_builtins.bool] seal_wrap: Enable seal wrapping for the mount, causing values stored by the mount to be wrapped by the seal's encryption capability
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] server_hostnames: Hostnames to include in the server's TLS certificate as SAN DNS names. The first will be used as the common name (CN).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] server_ips: IPs to include in the server's TLS certificate as SAN IP addresses.
        :param pulumi.Input[_builtins.int] tls_ca_key_bits: CA key bits, valid values depend on key type.
        :param pulumi.Input[_builtins.str] tls_ca_key_type: CA key type, rsa or ec.
        :param pulumi.Input[_builtins.str] tls_min_version: Minimum TLS version to accept.
        """
        if accessor is not None:
            pulumi.set(__self__, "accessor", accessor)
        if allowed_managed_keys is not None:
            pulumi.set(__self__, "allowed_managed_keys", allowed_managed_keys)
        if allowed_response_headers is not None:
            pulumi.set(__self__, "allowed_response_headers", allowed_response_headers)
        if audit_non_hmac_request_keys is not None:
            pulumi.set(__self__, "audit_non_hmac_request_keys", audit_non_hmac_request_keys)
        if audit_non_hmac_response_keys is not None:
            pulumi.set(__self__, "audit_non_hmac_response_keys", audit_non_hmac_response_keys)
        if default_lease_ttl_seconds is not None:
            pulumi.set(__self__, "default_lease_ttl_seconds", default_lease_ttl_seconds)
        if default_tls_client_key_bits is not None:
            pulumi.set(__self__, "default_tls_client_key_bits", default_tls_client_key_bits)
        if default_tls_client_key_type is not None:
            pulumi.set(__self__, "default_tls_client_key_type", default_tls_client_key_type)
        if default_tls_client_ttl is not None:
            pulumi.set(__self__, "default_tls_client_ttl", default_tls_client_ttl)
        if delegated_auth_accessors is not None:
            pulumi.set(__self__, "delegated_auth_accessors", delegated_auth_accessors)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disable_remount is not None:
            pulumi.set(__self__, "disable_remount", disable_remount)
        if external_entropy_access is not None:
            pulumi.set(__self__, "external_entropy_access", external_entropy_access)
        if force_no_cache is not None:
            pulumi.set(__self__, "force_no_cache", force_no_cache)
        if identity_token_key is not None:
            pulumi.set(__self__, "identity_token_key", identity_token_key)
        if listen_addrs is not None:
            pulumi.set(__self__, "listen_addrs", listen_addrs)
        if listing_visibility is not None:
            pulumi.set(__self__, "listing_visibility", listing_visibility)
        if local is not None:
            pulumi.set(__self__, "local", local)
        if max_lease_ttl_seconds is not None:
            pulumi.set(__self__, "max_lease_ttl_seconds", max_lease_ttl_seconds)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if options is not None:
            pulumi.set(__self__, "options", options)
        if passthrough_request_headers is not None:
            pulumi.set(__self__, "passthrough_request_headers", passthrough_request_headers)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if plugin_version is not None:
            pulumi.set(__self__, "plugin_version", plugin_version)
        if seal_wrap is not None:
            pulumi.set(__self__, "seal_wrap", seal_wrap)
        if server_hostnames is not None:
            pulumi.set(__self__, "server_hostnames", server_hostnames)
        if server_ips is not None:
            pulumi.set(__self__, "server_ips", server_ips)
        if tls_ca_key_bits is not None:
            pulumi.set(__self__, "tls_ca_key_bits", tls_ca_key_bits)
        if tls_ca_key_type is not None:
            pulumi.set(__self__, "tls_ca_key_type", tls_ca_key_type)
        if tls_min_version is not None:
            pulumi.set(__self__, "tls_min_version", tls_min_version)

    @_builtins.property
    @pulumi.getter
    def accessor(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Accessor of the mount
        """
        return pulumi.get(self, "accessor")

    @accessor.setter
    def accessor(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "accessor", value)

    @_builtins.property
    @pulumi.getter(name="allowedManagedKeys")
    def allowed_managed_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of managed key registry entry names that the mount in question is allowed to access
        """
        return pulumi.get(self, "allowed_managed_keys")

    @allowed_managed_keys.setter
    def allowed_managed_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "allowed_managed_keys", value)

    @_builtins.property
    @pulumi.getter(name="allowedResponseHeaders")
    def allowed_response_headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of headers to allow and pass from the request to the plugin
        """
        return pulumi.get(self, "allowed_response_headers")

    @allowed_response_headers.setter
    def allowed_response_headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "allowed_response_headers", value)

    @_builtins.property
    @pulumi.getter(name="auditNonHmacRequestKeys")
    def audit_non_hmac_request_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies the list of keys that will not be HMAC'd by audit devices in the request data object.
        """
        return pulumi.get(self, "audit_non_hmac_request_keys")

    @audit_non_hmac_request_keys.setter
    def audit_non_hmac_request_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "audit_non_hmac_request_keys", value)

    @_builtins.property
    @pulumi.getter(name="auditNonHmacResponseKeys")
    def audit_non_hmac_response_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies the list of keys that will not be HMAC'd by audit devices in the response data object.
        """
        return pulumi.get(self, "audit_non_hmac_response_keys")

    @audit_non_hmac_response_keys.setter
    def audit_non_hmac_response_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "audit_non_hmac_response_keys", value)

    @_builtins.property
    @pulumi.getter(name="defaultLeaseTtlSeconds")
    def default_lease_ttl_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Default lease duration for tokens and secrets in seconds
        """
        return pulumi.get(self, "default_lease_ttl_seconds")

    @default_lease_ttl_seconds.setter
    def default_lease_ttl_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "default_lease_ttl_seconds", value)

    @_builtins.property
    @pulumi.getter(name="defaultTlsClientKeyBits")
    def default_tls_client_key_bits(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Client certificate key bits, valid values depend on key type.
        """
        return pulumi.get(self, "default_tls_client_key_bits")

    @default_tls_client_key_bits.setter
    def default_tls_client_key_bits(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "default_tls_client_key_bits", value)

    @_builtins.property
    @pulumi.getter(name="defaultTlsClientKeyType")
    def default_tls_client_key_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Client certificate key type, `rsa` or `ec`.
        """
        return pulumi.get(self, "default_tls_client_key_type")

    @default_tls_client_key_type.setter
    def default_tls_client_key_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_tls_client_key_type", value)

    @_builtins.property
    @pulumi.getter(name="defaultTlsClientTtl")
    def default_tls_client_ttl(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Client certificate TTL in seconds
        """
        return pulumi.get(self, "default_tls_client_ttl")

    @default_tls_client_ttl.setter
    def default_tls_client_ttl(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "default_tls_client_ttl", value)

    @_builtins.property
    @pulumi.getter(name="delegatedAuthAccessors")
    def delegated_auth_accessors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of headers to allow and pass from the request to the plugin
        """
        return pulumi.get(self, "delegated_auth_accessors")

    @delegated_auth_accessors.setter
    def delegated_auth_accessors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "delegated_auth_accessors", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Human-friendly description of the mount for the backend
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="disableRemount")
    def disable_remount(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If set, opts out of mount migration on path updates.
        See here for more info on [Mount Migration](https://www.vaultproject.io/docs/concepts/mount-migration)
        """
        return pulumi.get(self, "disable_remount")

    @disable_remount.setter
    def disable_remount(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disable_remount", value)

    @_builtins.property
    @pulumi.getter(name="externalEntropyAccess")
    def external_entropy_access(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable the secrets engine to access Vault's external entropy source
        """
        return pulumi.get(self, "external_entropy_access")

    @external_entropy_access.setter
    def external_entropy_access(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "external_entropy_access", value)

    @_builtins.property
    @pulumi.getter(name="forceNoCache")
    def force_no_cache(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If set to true, disables caching.
        """
        return pulumi.get(self, "force_no_cache")

    @force_no_cache.setter
    def force_no_cache(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "force_no_cache", value)

    @_builtins.property
    @pulumi.getter(name="identityTokenKey")
    def identity_token_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The key to use for signing plugin workload identity tokens
        """
        return pulumi.get(self, "identity_token_key")

    @identity_token_key.setter
    def identity_token_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "identity_token_key", value)

    @_builtins.property
    @pulumi.getter(name="listenAddrs")
    def listen_addrs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Addresses the KMIP server should listen on (`host:port`).
        """
        return pulumi.get(self, "listen_addrs")

    @listen_addrs.setter
    def listen_addrs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "listen_addrs", value)

    @_builtins.property
    @pulumi.getter(name="listingVisibility")
    def listing_visibility(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies whether to show this mount in the UI-specific listing endpoint
        """
        return pulumi.get(self, "listing_visibility")

    @listing_visibility.setter
    def listing_visibility(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "listing_visibility", value)

    @_builtins.property
    @pulumi.getter
    def local(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Local mount flag that can be explicitly set to true to enforce local mount in HA environment
        """
        return pulumi.get(self, "local")

    @local.setter
    def local(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "local", value)

    @_builtins.property
    @pulumi.getter(name="maxLeaseTtlSeconds")
    def max_lease_ttl_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Maximum possible lease duration for tokens and secrets in seconds
        """
        return pulumi.get(self, "max_lease_ttl_seconds")

    @max_lease_ttl_seconds.setter
    def max_lease_ttl_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_lease_ttl_seconds", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter
    def options(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Specifies mount type specific options that are passed to the backend
        """
        return pulumi.get(self, "options")

    @options.setter
    def options(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "options", value)

    @_builtins.property
    @pulumi.getter(name="passthroughRequestHeaders")
    def passthrough_request_headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of headers to allow and pass from the request to the plugin
        """
        return pulumi.get(self, "passthrough_request_headers")

    @passthrough_request_headers.setter
    def passthrough_request_headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "passthrough_request_headers", value)

    @_builtins.property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique path this backend should be mounted at. Must
        not begin or end with a `/`. Defaults to `kmip`.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "path", value)

    @_builtins.property
    @pulumi.getter(name="pluginVersion")
    def plugin_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the semantic version of the plugin to use, e.g. 'v1.0.0'
        """
        return pulumi.get(self, "plugin_version")

    @plugin_version.setter
    def plugin_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "plugin_version", value)

    @_builtins.property
    @pulumi.getter(name="sealWrap")
    def seal_wrap(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable seal wrapping for the mount, causing values stored by the mount to be wrapped by the seal's encryption capability
        """
        return pulumi.get(self, "seal_wrap")

    @seal_wrap.setter
    def seal_wrap(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "seal_wrap", value)

    @_builtins.property
    @pulumi.getter(name="serverHostnames")
    def server_hostnames(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Hostnames to include in the server's TLS certificate as SAN DNS names. The first will be used as the common name (CN).
        """
        return pulumi.get(self, "server_hostnames")

    @server_hostnames.setter
    def server_hostnames(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "server_hostnames", value)

    @_builtins.property
    @pulumi.getter(name="serverIps")
    def server_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        IPs to include in the server's TLS certificate as SAN IP addresses.
        """
        return pulumi.get(self, "server_ips")

    @server_ips.setter
    def server_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "server_ips", value)

    @_builtins.property
    @pulumi.getter(name="tlsCaKeyBits")
    def tls_ca_key_bits(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        CA key bits, valid values depend on key type.
        """
        return pulumi.get(self, "tls_ca_key_bits")

    @tls_ca_key_bits.setter
    def tls_ca_key_bits(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "tls_ca_key_bits", value)

    @_builtins.property
    @pulumi.getter(name="tlsCaKeyType")
    def tls_ca_key_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        CA key type, rsa or ec.
        """
        return pulumi.get(self, "tls_ca_key_type")

    @tls_ca_key_type.setter
    def tls_ca_key_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tls_ca_key_type", value)

    @_builtins.property
    @pulumi.getter(name="tlsMinVersion")
    def tls_min_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Minimum TLS version to accept.
        """
        return pulumi.get(self, "tls_min_version")

    @tls_min_version.setter
    def tls_min_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tls_min_version", value)


@pulumi.type_token("vault:kmip/secretBackend:SecretBackend")
class SecretBackend(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allowed_managed_keys: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 allowed_response_headers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 audit_non_hmac_request_keys: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 audit_non_hmac_response_keys: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 default_lease_ttl_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 default_tls_client_key_bits: Optional[pulumi.Input[_builtins.int]] = None,
                 default_tls_client_key_type: Optional[pulumi.Input[_builtins.str]] = None,
                 default_tls_client_ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 delegated_auth_accessors: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disable_remount: Optional[pulumi.Input[_builtins.bool]] = None,
                 external_entropy_access: Optional[pulumi.Input[_builtins.bool]] = None,
                 force_no_cache: Optional[pulumi.Input[_builtins.bool]] = None,
                 identity_token_key: Optional[pulumi.Input[_builtins.str]] = None,
                 listen_addrs: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 listing_visibility: Optional[pulumi.Input[_builtins.str]] = None,
                 local: Optional[pulumi.Input[_builtins.bool]] = None,
                 max_lease_ttl_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 options: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 passthrough_request_headers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 path: Optional[pulumi.Input[_builtins.str]] = None,
                 plugin_version: Optional[pulumi.Input[_builtins.str]] = None,
                 seal_wrap: Optional[pulumi.Input[_builtins.bool]] = None,
                 server_hostnames: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 server_ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tls_ca_key_bits: Optional[pulumi.Input[_builtins.int]] = None,
                 tls_ca_key_type: Optional[pulumi.Input[_builtins.str]] = None,
                 tls_min_version: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages KMIP Secret backends in a Vault server. This feature requires
        Vault Enterprise. See the [Vault documentation](https://www.vaultproject.io/docs/secrets/kmip)
        for more information.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_vault as vault

        default = vault.kmip.SecretBackend("default",
            path="kmip",
            description="Vault KMIP backend",
            listen_addrs=[
                "127.0.0.1:5696",
                "127.0.0.1:8080",
            ],
            tls_ca_key_type="rsa",
            tls_ca_key_bits=4096,
            default_tls_client_key_type="rsa",
            default_tls_client_key_bits=4096,
            default_tls_client_ttl=86400)
        ```

        ## Import

        KMIP Secret backend can be imported using the `path`, e.g.

        ```sh
        $ pulumi import vault:kmip/secretBackend:SecretBackend default kmip
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_managed_keys: List of managed key registry entry names that the mount in question is allowed to access
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_response_headers: List of headers to allow and pass from the request to the plugin
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] audit_non_hmac_request_keys: Specifies the list of keys that will not be HMAC'd by audit devices in the request data object.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] audit_non_hmac_response_keys: Specifies the list of keys that will not be HMAC'd by audit devices in the response data object.
        :param pulumi.Input[_builtins.int] default_lease_ttl_seconds: Default lease duration for tokens and secrets in seconds
        :param pulumi.Input[_builtins.int] default_tls_client_key_bits: Client certificate key bits, valid values depend on key type.
        :param pulumi.Input[_builtins.str] default_tls_client_key_type: Client certificate key type, `rsa` or `ec`.
        :param pulumi.Input[_builtins.int] default_tls_client_ttl: Client certificate TTL in seconds
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] delegated_auth_accessors: List of headers to allow and pass from the request to the plugin
        :param pulumi.Input[_builtins.str] description: Human-friendly description of the mount for the backend
        :param pulumi.Input[_builtins.bool] disable_remount: If set, opts out of mount migration on path updates.
               See here for more info on [Mount Migration](https://www.vaultproject.io/docs/concepts/mount-migration)
        :param pulumi.Input[_builtins.bool] external_entropy_access: Enable the secrets engine to access Vault's external entropy source
        :param pulumi.Input[_builtins.bool] force_no_cache: If set to true, disables caching.
        :param pulumi.Input[_builtins.str] identity_token_key: The key to use for signing plugin workload identity tokens
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] listen_addrs: Addresses the KMIP server should listen on (`host:port`).
        :param pulumi.Input[_builtins.str] listing_visibility: Specifies whether to show this mount in the UI-specific listing endpoint
        :param pulumi.Input[_builtins.bool] local: Local mount flag that can be explicitly set to true to enforce local mount in HA environment
        :param pulumi.Input[_builtins.int] max_lease_ttl_seconds: Maximum possible lease duration for tokens and secrets in seconds
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] options: Specifies mount type specific options that are passed to the backend
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] passthrough_request_headers: List of headers to allow and pass from the request to the plugin
        :param pulumi.Input[_builtins.str] path: The unique path this backend should be mounted at. Must
               not begin or end with a `/`. Defaults to `kmip`.
        :param pulumi.Input[_builtins.str] plugin_version: Specifies the semantic version of the plugin to use, e.g. 'v1.0.0'
        :param pulumi.Input[_builtins.bool] seal_wrap: Enable seal wrapping for the mount, causing values stored by the mount to be wrapped by the seal's encryption capability
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] server_hostnames: Hostnames to include in the server's TLS certificate as SAN DNS names. The first will be used as the common name (CN).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] server_ips: IPs to include in the server's TLS certificate as SAN IP addresses.
        :param pulumi.Input[_builtins.int] tls_ca_key_bits: CA key bits, valid values depend on key type.
        :param pulumi.Input[_builtins.str] tls_ca_key_type: CA key type, rsa or ec.
        :param pulumi.Input[_builtins.str] tls_min_version: Minimum TLS version to accept.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SecretBackendArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages KMIP Secret backends in a Vault server. This feature requires
        Vault Enterprise. See the [Vault documentation](https://www.vaultproject.io/docs/secrets/kmip)
        for more information.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_vault as vault

        default = vault.kmip.SecretBackend("default",
            path="kmip",
            description="Vault KMIP backend",
            listen_addrs=[
                "127.0.0.1:5696",
                "127.0.0.1:8080",
            ],
            tls_ca_key_type="rsa",
            tls_ca_key_bits=4096,
            default_tls_client_key_type="rsa",
            default_tls_client_key_bits=4096,
            default_tls_client_ttl=86400)
        ```

        ## Import

        KMIP Secret backend can be imported using the `path`, e.g.

        ```sh
        $ pulumi import vault:kmip/secretBackend:SecretBackend default kmip
        ```

        :param str resource_name: The name of the resource.
        :param SecretBackendArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SecretBackendArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allowed_managed_keys: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 allowed_response_headers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 audit_non_hmac_request_keys: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 audit_non_hmac_response_keys: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 default_lease_ttl_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 default_tls_client_key_bits: Optional[pulumi.Input[_builtins.int]] = None,
                 default_tls_client_key_type: Optional[pulumi.Input[_builtins.str]] = None,
                 default_tls_client_ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 delegated_auth_accessors: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disable_remount: Optional[pulumi.Input[_builtins.bool]] = None,
                 external_entropy_access: Optional[pulumi.Input[_builtins.bool]] = None,
                 force_no_cache: Optional[pulumi.Input[_builtins.bool]] = None,
                 identity_token_key: Optional[pulumi.Input[_builtins.str]] = None,
                 listen_addrs: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 listing_visibility: Optional[pulumi.Input[_builtins.str]] = None,
                 local: Optional[pulumi.Input[_builtins.bool]] = None,
                 max_lease_ttl_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 options: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 passthrough_request_headers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 path: Optional[pulumi.Input[_builtins.str]] = None,
                 plugin_version: Optional[pulumi.Input[_builtins.str]] = None,
                 seal_wrap: Optional[pulumi.Input[_builtins.bool]] = None,
                 server_hostnames: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 server_ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tls_ca_key_bits: Optional[pulumi.Input[_builtins.int]] = None,
                 tls_ca_key_type: Optional[pulumi.Input[_builtins.str]] = None,
                 tls_min_version: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SecretBackendArgs.__new__(SecretBackendArgs)

            __props__.__dict__["allowed_managed_keys"] = allowed_managed_keys
            __props__.__dict__["allowed_response_headers"] = allowed_response_headers
            __props__.__dict__["audit_non_hmac_request_keys"] = audit_non_hmac_request_keys
            __props__.__dict__["audit_non_hmac_response_keys"] = audit_non_hmac_response_keys
            __props__.__dict__["default_lease_ttl_seconds"] = default_lease_ttl_seconds
            __props__.__dict__["default_tls_client_key_bits"] = default_tls_client_key_bits
            __props__.__dict__["default_tls_client_key_type"] = default_tls_client_key_type
            __props__.__dict__["default_tls_client_ttl"] = default_tls_client_ttl
            __props__.__dict__["delegated_auth_accessors"] = delegated_auth_accessors
            __props__.__dict__["description"] = description
            __props__.__dict__["disable_remount"] = disable_remount
            __props__.__dict__["external_entropy_access"] = external_entropy_access
            __props__.__dict__["force_no_cache"] = force_no_cache
            __props__.__dict__["identity_token_key"] = identity_token_key
            __props__.__dict__["listen_addrs"] = listen_addrs
            __props__.__dict__["listing_visibility"] = listing_visibility
            __props__.__dict__["local"] = local
            __props__.__dict__["max_lease_ttl_seconds"] = max_lease_ttl_seconds
            __props__.__dict__["namespace"] = namespace
            __props__.__dict__["options"] = options
            __props__.__dict__["passthrough_request_headers"] = passthrough_request_headers
            if path is None and not opts.urn:
                raise TypeError("Missing required property 'path'")
            __props__.__dict__["path"] = path
            __props__.__dict__["plugin_version"] = plugin_version
            __props__.__dict__["seal_wrap"] = seal_wrap
            __props__.__dict__["server_hostnames"] = server_hostnames
            __props__.__dict__["server_ips"] = server_ips
            __props__.__dict__["tls_ca_key_bits"] = tls_ca_key_bits
            __props__.__dict__["tls_ca_key_type"] = tls_ca_key_type
            __props__.__dict__["tls_min_version"] = tls_min_version
            __props__.__dict__["accessor"] = None
        super(SecretBackend, __self__).__init__(
            'vault:kmip/secretBackend:SecretBackend',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            accessor: Optional[pulumi.Input[_builtins.str]] = None,
            allowed_managed_keys: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            allowed_response_headers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            audit_non_hmac_request_keys: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            audit_non_hmac_response_keys: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            default_lease_ttl_seconds: Optional[pulumi.Input[_builtins.int]] = None,
            default_tls_client_key_bits: Optional[pulumi.Input[_builtins.int]] = None,
            default_tls_client_key_type: Optional[pulumi.Input[_builtins.str]] = None,
            default_tls_client_ttl: Optional[pulumi.Input[_builtins.int]] = None,
            delegated_auth_accessors: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            disable_remount: Optional[pulumi.Input[_builtins.bool]] = None,
            external_entropy_access: Optional[pulumi.Input[_builtins.bool]] = None,
            force_no_cache: Optional[pulumi.Input[_builtins.bool]] = None,
            identity_token_key: Optional[pulumi.Input[_builtins.str]] = None,
            listen_addrs: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            listing_visibility: Optional[pulumi.Input[_builtins.str]] = None,
            local: Optional[pulumi.Input[_builtins.bool]] = None,
            max_lease_ttl_seconds: Optional[pulumi.Input[_builtins.int]] = None,
            namespace: Optional[pulumi.Input[_builtins.str]] = None,
            options: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            passthrough_request_headers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            path: Optional[pulumi.Input[_builtins.str]] = None,
            plugin_version: Optional[pulumi.Input[_builtins.str]] = None,
            seal_wrap: Optional[pulumi.Input[_builtins.bool]] = None,
            server_hostnames: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            server_ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            tls_ca_key_bits: Optional[pulumi.Input[_builtins.int]] = None,
            tls_ca_key_type: Optional[pulumi.Input[_builtins.str]] = None,
            tls_min_version: Optional[pulumi.Input[_builtins.str]] = None) -> 'SecretBackend':
        """
        Get an existing SecretBackend resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] accessor: Accessor of the mount
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_managed_keys: List of managed key registry entry names that the mount in question is allowed to access
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_response_headers: List of headers to allow and pass from the request to the plugin
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] audit_non_hmac_request_keys: Specifies the list of keys that will not be HMAC'd by audit devices in the request data object.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] audit_non_hmac_response_keys: Specifies the list of keys that will not be HMAC'd by audit devices in the response data object.
        :param pulumi.Input[_builtins.int] default_lease_ttl_seconds: Default lease duration for tokens and secrets in seconds
        :param pulumi.Input[_builtins.int] default_tls_client_key_bits: Client certificate key bits, valid values depend on key type.
        :param pulumi.Input[_builtins.str] default_tls_client_key_type: Client certificate key type, `rsa` or `ec`.
        :param pulumi.Input[_builtins.int] default_tls_client_ttl: Client certificate TTL in seconds
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] delegated_auth_accessors: List of headers to allow and pass from the request to the plugin
        :param pulumi.Input[_builtins.str] description: Human-friendly description of the mount for the backend
        :param pulumi.Input[_builtins.bool] disable_remount: If set, opts out of mount migration on path updates.
               See here for more info on [Mount Migration](https://www.vaultproject.io/docs/concepts/mount-migration)
        :param pulumi.Input[_builtins.bool] external_entropy_access: Enable the secrets engine to access Vault's external entropy source
        :param pulumi.Input[_builtins.bool] force_no_cache: If set to true, disables caching.
        :param pulumi.Input[_builtins.str] identity_token_key: The key to use for signing plugin workload identity tokens
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] listen_addrs: Addresses the KMIP server should listen on (`host:port`).
        :param pulumi.Input[_builtins.str] listing_visibility: Specifies whether to show this mount in the UI-specific listing endpoint
        :param pulumi.Input[_builtins.bool] local: Local mount flag that can be explicitly set to true to enforce local mount in HA environment
        :param pulumi.Input[_builtins.int] max_lease_ttl_seconds: Maximum possible lease duration for tokens and secrets in seconds
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] options: Specifies mount type specific options that are passed to the backend
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] passthrough_request_headers: List of headers to allow and pass from the request to the plugin
        :param pulumi.Input[_builtins.str] path: The unique path this backend should be mounted at. Must
               not begin or end with a `/`. Defaults to `kmip`.
        :param pulumi.Input[_builtins.str] plugin_version: Specifies the semantic version of the plugin to use, e.g. 'v1.0.0'
        :param pulumi.Input[_builtins.bool] seal_wrap: Enable seal wrapping for the mount, causing values stored by the mount to be wrapped by the seal's encryption capability
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] server_hostnames: Hostnames to include in the server's TLS certificate as SAN DNS names. The first will be used as the common name (CN).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] server_ips: IPs to include in the server's TLS certificate as SAN IP addresses.
        :param pulumi.Input[_builtins.int] tls_ca_key_bits: CA key bits, valid values depend on key type.
        :param pulumi.Input[_builtins.str] tls_ca_key_type: CA key type, rsa or ec.
        :param pulumi.Input[_builtins.str] tls_min_version: Minimum TLS version to accept.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SecretBackendState.__new__(_SecretBackendState)

        __props__.__dict__["accessor"] = accessor
        __props__.__dict__["allowed_managed_keys"] = allowed_managed_keys
        __props__.__dict__["allowed_response_headers"] = allowed_response_headers
        __props__.__dict__["audit_non_hmac_request_keys"] = audit_non_hmac_request_keys
        __props__.__dict__["audit_non_hmac_response_keys"] = audit_non_hmac_response_keys
        __props__.__dict__["default_lease_ttl_seconds"] = default_lease_ttl_seconds
        __props__.__dict__["default_tls_client_key_bits"] = default_tls_client_key_bits
        __props__.__dict__["default_tls_client_key_type"] = default_tls_client_key_type
        __props__.__dict__["default_tls_client_ttl"] = default_tls_client_ttl
        __props__.__dict__["delegated_auth_accessors"] = delegated_auth_accessors
        __props__.__dict__["description"] = description
        __props__.__dict__["disable_remount"] = disable_remount
        __props__.__dict__["external_entropy_access"] = external_entropy_access
        __props__.__dict__["force_no_cache"] = force_no_cache
        __props__.__dict__["identity_token_key"] = identity_token_key
        __props__.__dict__["listen_addrs"] = listen_addrs
        __props__.__dict__["listing_visibility"] = listing_visibility
        __props__.__dict__["local"] = local
        __props__.__dict__["max_lease_ttl_seconds"] = max_lease_ttl_seconds
        __props__.__dict__["namespace"] = namespace
        __props__.__dict__["options"] = options
        __props__.__dict__["passthrough_request_headers"] = passthrough_request_headers
        __props__.__dict__["path"] = path
        __props__.__dict__["plugin_version"] = plugin_version
        __props__.__dict__["seal_wrap"] = seal_wrap
        __props__.__dict__["server_hostnames"] = server_hostnames
        __props__.__dict__["server_ips"] = server_ips
        __props__.__dict__["tls_ca_key_bits"] = tls_ca_key_bits
        __props__.__dict__["tls_ca_key_type"] = tls_ca_key_type
        __props__.__dict__["tls_min_version"] = tls_min_version
        return SecretBackend(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def accessor(self) -> pulumi.Output[_builtins.str]:
        """
        Accessor of the mount
        """
        return pulumi.get(self, "accessor")

    @_builtins.property
    @pulumi.getter(name="allowedManagedKeys")
    def allowed_managed_keys(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of managed key registry entry names that the mount in question is allowed to access
        """
        return pulumi.get(self, "allowed_managed_keys")

    @_builtins.property
    @pulumi.getter(name="allowedResponseHeaders")
    def allowed_response_headers(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of headers to allow and pass from the request to the plugin
        """
        return pulumi.get(self, "allowed_response_headers")

    @_builtins.property
    @pulumi.getter(name="auditNonHmacRequestKeys")
    def audit_non_hmac_request_keys(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Specifies the list of keys that will not be HMAC'd by audit devices in the request data object.
        """
        return pulumi.get(self, "audit_non_hmac_request_keys")

    @_builtins.property
    @pulumi.getter(name="auditNonHmacResponseKeys")
    def audit_non_hmac_response_keys(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Specifies the list of keys that will not be HMAC'd by audit devices in the response data object.
        """
        return pulumi.get(self, "audit_non_hmac_response_keys")

    @_builtins.property
    @pulumi.getter(name="defaultLeaseTtlSeconds")
    def default_lease_ttl_seconds(self) -> pulumi.Output[_builtins.int]:
        """
        Default lease duration for tokens and secrets in seconds
        """
        return pulumi.get(self, "default_lease_ttl_seconds")

    @_builtins.property
    @pulumi.getter(name="defaultTlsClientKeyBits")
    def default_tls_client_key_bits(self) -> pulumi.Output[_builtins.int]:
        """
        Client certificate key bits, valid values depend on key type.
        """
        return pulumi.get(self, "default_tls_client_key_bits")

    @_builtins.property
    @pulumi.getter(name="defaultTlsClientKeyType")
    def default_tls_client_key_type(self) -> pulumi.Output[_builtins.str]:
        """
        Client certificate key type, `rsa` or `ec`.
        """
        return pulumi.get(self, "default_tls_client_key_type")

    @_builtins.property
    @pulumi.getter(name="defaultTlsClientTtl")
    def default_tls_client_ttl(self) -> pulumi.Output[_builtins.int]:
        """
        Client certificate TTL in seconds
        """
        return pulumi.get(self, "default_tls_client_ttl")

    @_builtins.property
    @pulumi.getter(name="delegatedAuthAccessors")
    def delegated_auth_accessors(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of headers to allow and pass from the request to the plugin
        """
        return pulumi.get(self, "delegated_auth_accessors")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Human-friendly description of the mount for the backend
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="disableRemount")
    def disable_remount(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        If set, opts out of mount migration on path updates.
        See here for more info on [Mount Migration](https://www.vaultproject.io/docs/concepts/mount-migration)
        """
        return pulumi.get(self, "disable_remount")

    @_builtins.property
    @pulumi.getter(name="externalEntropyAccess")
    def external_entropy_access(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Enable the secrets engine to access Vault's external entropy source
        """
        return pulumi.get(self, "external_entropy_access")

    @_builtins.property
    @pulumi.getter(name="forceNoCache")
    def force_no_cache(self) -> pulumi.Output[_builtins.bool]:
        """
        If set to true, disables caching.
        """
        return pulumi.get(self, "force_no_cache")

    @_builtins.property
    @pulumi.getter(name="identityTokenKey")
    def identity_token_key(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The key to use for signing plugin workload identity tokens
        """
        return pulumi.get(self, "identity_token_key")

    @_builtins.property
    @pulumi.getter(name="listenAddrs")
    def listen_addrs(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Addresses the KMIP server should listen on (`host:port`).
        """
        return pulumi.get(self, "listen_addrs")

    @_builtins.property
    @pulumi.getter(name="listingVisibility")
    def listing_visibility(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies whether to show this mount in the UI-specific listing endpoint
        """
        return pulumi.get(self, "listing_visibility")

    @_builtins.property
    @pulumi.getter
    def local(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Local mount flag that can be explicitly set to true to enforce local mount in HA environment
        """
        return pulumi.get(self, "local")

    @_builtins.property
    @pulumi.getter(name="maxLeaseTtlSeconds")
    def max_lease_ttl_seconds(self) -> pulumi.Output[_builtins.int]:
        """
        Maximum possible lease duration for tokens and secrets in seconds
        """
        return pulumi.get(self, "max_lease_ttl_seconds")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter
    def options(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Specifies mount type specific options that are passed to the backend
        """
        return pulumi.get(self, "options")

    @_builtins.property
    @pulumi.getter(name="passthroughRequestHeaders")
    def passthrough_request_headers(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of headers to allow and pass from the request to the plugin
        """
        return pulumi.get(self, "passthrough_request_headers")

    @_builtins.property
    @pulumi.getter
    def path(self) -> pulumi.Output[_builtins.str]:
        """
        The unique path this backend should be mounted at. Must
        not begin or end with a `/`. Defaults to `kmip`.
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter(name="pluginVersion")
    def plugin_version(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the semantic version of the plugin to use, e.g. 'v1.0.0'
        """
        return pulumi.get(self, "plugin_version")

    @_builtins.property
    @pulumi.getter(name="sealWrap")
    def seal_wrap(self) -> pulumi.Output[_builtins.bool]:
        """
        Enable seal wrapping for the mount, causing values stored by the mount to be wrapped by the seal's encryption capability
        """
        return pulumi.get(self, "seal_wrap")

    @_builtins.property
    @pulumi.getter(name="serverHostnames")
    def server_hostnames(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Hostnames to include in the server's TLS certificate as SAN DNS names. The first will be used as the common name (CN).
        """
        return pulumi.get(self, "server_hostnames")

    @_builtins.property
    @pulumi.getter(name="serverIps")
    def server_ips(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        IPs to include in the server's TLS certificate as SAN IP addresses.
        """
        return pulumi.get(self, "server_ips")

    @_builtins.property
    @pulumi.getter(name="tlsCaKeyBits")
    def tls_ca_key_bits(self) -> pulumi.Output[_builtins.int]:
        """
        CA key bits, valid values depend on key type.
        """
        return pulumi.get(self, "tls_ca_key_bits")

    @_builtins.property
    @pulumi.getter(name="tlsCaKeyType")
    def tls_ca_key_type(self) -> pulumi.Output[_builtins.str]:
        """
        CA key type, rsa or ec.
        """
        return pulumi.get(self, "tls_ca_key_type")

    @_builtins.property
    @pulumi.getter(name="tlsMinVersion")
    def tls_min_version(self) -> pulumi.Output[_builtins.str]:
        """
        Minimum TLS version to accept.
        """
        return pulumi.get(self, "tls_min_version")

