# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SecretV2Args', 'SecretV2']

@pulumi.input_type
class SecretV2Args:
    def __init__(__self__, *,
                 mount: pulumi.Input[_builtins.str],
                 cas: Optional[pulumi.Input[_builtins.int]] = None,
                 custom_metadata: Optional[pulumi.Input['SecretV2CustomMetadataArgs']] = None,
                 data_json: Optional[pulumi.Input[_builtins.str]] = None,
                 data_json_wo: Optional[pulumi.Input[_builtins.str]] = None,
                 data_json_wo_version: Optional[pulumi.Input[_builtins.int]] = None,
                 delete_all_versions: Optional[pulumi.Input[_builtins.bool]] = None,
                 disable_read: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 options: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a SecretV2 resource.
        :param pulumi.Input[_builtins.str] mount: Path where KV-V2 engine is mounted.
        :param pulumi.Input[_builtins.int] cas: This flag is required if `cas_required` is set to true
               on either the secret or the engine's config. In order for a
               write operation to be successful, cas must be set to the current version
               of the secret.
        :param pulumi.Input['SecretV2CustomMetadataArgs'] custom_metadata: A nested block that allows configuring metadata for the
               KV secret. Refer to the
               Configuration Options for more info.
        :param pulumi.Input[_builtins.str] data_json: JSON-encoded string that will be
               written as the secret data at the given path.
        :param pulumi.Input[_builtins.str] data_json_wo: **NOTE:** This field is write-only and its value will not be updated in state as part of read operations.
               Write-Only JSON-encoded secret data to write.
        :param pulumi.Input[_builtins.int] data_json_wo_version: The version of the `data_json_wo`. For more info see updating write-only attributes.
        :param pulumi.Input[_builtins.bool] delete_all_versions: If set to true, permanently deletes all
               versions for the specified key.
        :param pulumi.Input[_builtins.bool] disable_read: If set to true, disables reading secret from Vault;
               note: drift won't be detected.
        :param pulumi.Input[_builtins.str] name: Full name of the secret. For a nested secret
               the name is the nested path excluding the mount and data
               prefix. For example, for a secret at `kvv2/data/foo/bar/baz`
               the name is `foo/bar/baz`.
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] options: An object that holds option settings.
        """
        pulumi.set(__self__, "mount", mount)
        if cas is not None:
            pulumi.set(__self__, "cas", cas)
        if custom_metadata is not None:
            pulumi.set(__self__, "custom_metadata", custom_metadata)
        if data_json is not None:
            pulumi.set(__self__, "data_json", data_json)
        if data_json_wo is not None:
            pulumi.set(__self__, "data_json_wo", data_json_wo)
        if data_json_wo_version is not None:
            pulumi.set(__self__, "data_json_wo_version", data_json_wo_version)
        if delete_all_versions is not None:
            pulumi.set(__self__, "delete_all_versions", delete_all_versions)
        if disable_read is not None:
            pulumi.set(__self__, "disable_read", disable_read)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if options is not None:
            pulumi.set(__self__, "options", options)

    @_builtins.property
    @pulumi.getter
    def mount(self) -> pulumi.Input[_builtins.str]:
        """
        Path where KV-V2 engine is mounted.
        """
        return pulumi.get(self, "mount")

    @mount.setter
    def mount(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "mount", value)

    @_builtins.property
    @pulumi.getter
    def cas(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        This flag is required if `cas_required` is set to true
        on either the secret or the engine's config. In order for a
        write operation to be successful, cas must be set to the current version
        of the secret.
        """
        return pulumi.get(self, "cas")

    @cas.setter
    def cas(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "cas", value)

    @_builtins.property
    @pulumi.getter(name="customMetadata")
    def custom_metadata(self) -> Optional[pulumi.Input['SecretV2CustomMetadataArgs']]:
        """
        A nested block that allows configuring metadata for the
        KV secret. Refer to the
        Configuration Options for more info.
        """
        return pulumi.get(self, "custom_metadata")

    @custom_metadata.setter
    def custom_metadata(self, value: Optional[pulumi.Input['SecretV2CustomMetadataArgs']]):
        pulumi.set(self, "custom_metadata", value)

    @_builtins.property
    @pulumi.getter(name="dataJson")
    def data_json(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        JSON-encoded string that will be
        written as the secret data at the given path.
        """
        return pulumi.get(self, "data_json")

    @data_json.setter
    def data_json(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "data_json", value)

    @_builtins.property
    @pulumi.getter(name="dataJsonWo")
    def data_json_wo(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        **NOTE:** This field is write-only and its value will not be updated in state as part of read operations.
        Write-Only JSON-encoded secret data to write.
        """
        return pulumi.get(self, "data_json_wo")

    @data_json_wo.setter
    def data_json_wo(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "data_json_wo", value)

    @_builtins.property
    @pulumi.getter(name="dataJsonWoVersion")
    def data_json_wo_version(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The version of the `data_json_wo`. For more info see updating write-only attributes.
        """
        return pulumi.get(self, "data_json_wo_version")

    @data_json_wo_version.setter
    def data_json_wo_version(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "data_json_wo_version", value)

    @_builtins.property
    @pulumi.getter(name="deleteAllVersions")
    def delete_all_versions(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If set to true, permanently deletes all
        versions for the specified key.
        """
        return pulumi.get(self, "delete_all_versions")

    @delete_all_versions.setter
    def delete_all_versions(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "delete_all_versions", value)

    @_builtins.property
    @pulumi.getter(name="disableRead")
    def disable_read(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If set to true, disables reading secret from Vault;
        note: drift won't be detected.
        """
        return pulumi.get(self, "disable_read")

    @disable_read.setter
    def disable_read(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disable_read", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Full name of the secret. For a nested secret
        the name is the nested path excluding the mount and data
        prefix. For example, for a secret at `kvv2/data/foo/bar/baz`
        the name is `foo/bar/baz`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter
    def options(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        An object that holds option settings.
        """
        return pulumi.get(self, "options")

    @options.setter
    def options(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "options", value)


@pulumi.input_type
class _SecretV2State:
    def __init__(__self__, *,
                 cas: Optional[pulumi.Input[_builtins.int]] = None,
                 custom_metadata: Optional[pulumi.Input['SecretV2CustomMetadataArgs']] = None,
                 data: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 data_json: Optional[pulumi.Input[_builtins.str]] = None,
                 data_json_wo: Optional[pulumi.Input[_builtins.str]] = None,
                 data_json_wo_version: Optional[pulumi.Input[_builtins.int]] = None,
                 delete_all_versions: Optional[pulumi.Input[_builtins.bool]] = None,
                 disable_read: Optional[pulumi.Input[_builtins.bool]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 mount: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 options: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 path: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering SecretV2 resources.
        :param pulumi.Input[_builtins.int] cas: This flag is required if `cas_required` is set to true
               on either the secret or the engine's config. In order for a
               write operation to be successful, cas must be set to the current version
               of the secret.
        :param pulumi.Input['SecretV2CustomMetadataArgs'] custom_metadata: A nested block that allows configuring metadata for the
               KV secret. Refer to the
               Configuration Options for more info.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] data: **Deprecated. Please use new ephemeral resource `kv.SecretV2` to read back
               secret data from Vault**. A mapping whose keys are the top-level data keys returned from
               Vault and whose values are the corresponding values. This map can only represent string data,
               so any non-string values returned from Vault are serialized as JSON.
        :param pulumi.Input[_builtins.str] data_json: JSON-encoded string that will be
               written as the secret data at the given path.
        :param pulumi.Input[_builtins.str] data_json_wo: **NOTE:** This field is write-only and its value will not be updated in state as part of read operations.
               Write-Only JSON-encoded secret data to write.
        :param pulumi.Input[_builtins.int] data_json_wo_version: The version of the `data_json_wo`. For more info see updating write-only attributes.
        :param pulumi.Input[_builtins.bool] delete_all_versions: If set to true, permanently deletes all
               versions for the specified key.
        :param pulumi.Input[_builtins.bool] disable_read: If set to true, disables reading secret from Vault;
               note: drift won't be detected.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] metadata: Metadata associated with this secret read from Vault.
        :param pulumi.Input[_builtins.str] mount: Path where KV-V2 engine is mounted.
        :param pulumi.Input[_builtins.str] name: Full name of the secret. For a nested secret
               the name is the nested path excluding the mount and data
               prefix. For example, for a secret at `kvv2/data/foo/bar/baz`
               the name is `foo/bar/baz`.
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] options: An object that holds option settings.
        :param pulumi.Input[_builtins.str] path: Full path where the KV-V2 secret will be written.
        """
        if cas is not None:
            pulumi.set(__self__, "cas", cas)
        if custom_metadata is not None:
            pulumi.set(__self__, "custom_metadata", custom_metadata)
        if data is not None:
            warnings.warn("""Deprecated. Will no longer be set on a read.""", DeprecationWarning)
            pulumi.log.warn("""data is deprecated: Deprecated. Will no longer be set on a read.""")
        if data is not None:
            pulumi.set(__self__, "data", data)
        if data_json is not None:
            pulumi.set(__self__, "data_json", data_json)
        if data_json_wo is not None:
            pulumi.set(__self__, "data_json_wo", data_json_wo)
        if data_json_wo_version is not None:
            pulumi.set(__self__, "data_json_wo_version", data_json_wo_version)
        if delete_all_versions is not None:
            pulumi.set(__self__, "delete_all_versions", delete_all_versions)
        if disable_read is not None:
            pulumi.set(__self__, "disable_read", disable_read)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if mount is not None:
            pulumi.set(__self__, "mount", mount)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if options is not None:
            pulumi.set(__self__, "options", options)
        if path is not None:
            pulumi.set(__self__, "path", path)

    @_builtins.property
    @pulumi.getter
    def cas(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        This flag is required if `cas_required` is set to true
        on either the secret or the engine's config. In order for a
        write operation to be successful, cas must be set to the current version
        of the secret.
        """
        return pulumi.get(self, "cas")

    @cas.setter
    def cas(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "cas", value)

    @_builtins.property
    @pulumi.getter(name="customMetadata")
    def custom_metadata(self) -> Optional[pulumi.Input['SecretV2CustomMetadataArgs']]:
        """
        A nested block that allows configuring metadata for the
        KV secret. Refer to the
        Configuration Options for more info.
        """
        return pulumi.get(self, "custom_metadata")

    @custom_metadata.setter
    def custom_metadata(self, value: Optional[pulumi.Input['SecretV2CustomMetadataArgs']]):
        pulumi.set(self, "custom_metadata", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Deprecated. Will no longer be set on a read.""")
    def data(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        **Deprecated. Please use new ephemeral resource `kv.SecretV2` to read back
        secret data from Vault**. A mapping whose keys are the top-level data keys returned from
        Vault and whose values are the corresponding values. This map can only represent string data,
        so any non-string values returned from Vault are serialized as JSON.
        """
        return pulumi.get(self, "data")

    @data.setter
    def data(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "data", value)

    @_builtins.property
    @pulumi.getter(name="dataJson")
    def data_json(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        JSON-encoded string that will be
        written as the secret data at the given path.
        """
        return pulumi.get(self, "data_json")

    @data_json.setter
    def data_json(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "data_json", value)

    @_builtins.property
    @pulumi.getter(name="dataJsonWo")
    def data_json_wo(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        **NOTE:** This field is write-only and its value will not be updated in state as part of read operations.
        Write-Only JSON-encoded secret data to write.
        """
        return pulumi.get(self, "data_json_wo")

    @data_json_wo.setter
    def data_json_wo(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "data_json_wo", value)

    @_builtins.property
    @pulumi.getter(name="dataJsonWoVersion")
    def data_json_wo_version(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The version of the `data_json_wo`. For more info see updating write-only attributes.
        """
        return pulumi.get(self, "data_json_wo_version")

    @data_json_wo_version.setter
    def data_json_wo_version(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "data_json_wo_version", value)

    @_builtins.property
    @pulumi.getter(name="deleteAllVersions")
    def delete_all_versions(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If set to true, permanently deletes all
        versions for the specified key.
        """
        return pulumi.get(self, "delete_all_versions")

    @delete_all_versions.setter
    def delete_all_versions(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "delete_all_versions", value)

    @_builtins.property
    @pulumi.getter(name="disableRead")
    def disable_read(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If set to true, disables reading secret from Vault;
        note: drift won't be detected.
        """
        return pulumi.get(self, "disable_read")

    @disable_read.setter
    def disable_read(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disable_read", value)

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Metadata associated with this secret read from Vault.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "metadata", value)

    @_builtins.property
    @pulumi.getter
    def mount(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Path where KV-V2 engine is mounted.
        """
        return pulumi.get(self, "mount")

    @mount.setter
    def mount(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mount", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Full name of the secret. For a nested secret
        the name is the nested path excluding the mount and data
        prefix. For example, for a secret at `kvv2/data/foo/bar/baz`
        the name is `foo/bar/baz`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter
    def options(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        An object that holds option settings.
        """
        return pulumi.get(self, "options")

    @options.setter
    def options(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "options", value)

    @_builtins.property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Full path where the KV-V2 secret will be written.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "path", value)


@pulumi.type_token("vault:kv/secretV2:SecretV2")
class SecretV2(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cas: Optional[pulumi.Input[_builtins.int]] = None,
                 custom_metadata: Optional[pulumi.Input[Union['SecretV2CustomMetadataArgs', 'SecretV2CustomMetadataArgsDict']]] = None,
                 data_json: Optional[pulumi.Input[_builtins.str]] = None,
                 data_json_wo: Optional[pulumi.Input[_builtins.str]] = None,
                 data_json_wo_version: Optional[pulumi.Input[_builtins.int]] = None,
                 delete_all_versions: Optional[pulumi.Input[_builtins.bool]] = None,
                 disable_read: Optional[pulumi.Input[_builtins.bool]] = None,
                 mount: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 options: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Writes a KV-V2 secret to a given path in Vault.

        For more information on Vault's KV-V2 secret backend
        [see here](https://www.vaultproject.io/docs/secrets/kv/kv-v2).

        ## Example Usage

        ```python
        import pulumi
        import json
        import pulumi_vault as vault

        kvv2 = vault.Mount("kvv2",
            path="kvv2",
            type="kv",
            options={
                "version": "2",
            },
            description="KV Version 2 secret engine mount")
        example = vault.kv.SecretV2("example",
            mount=kvv2.path,
            name="secret",
            cas=1,
            delete_all_versions=True,
            data_json=json.dumps({
                "zip": "zap",
                "foo": "bar",
            }),
            custom_metadata={
                "max_versions": 5,
                "data": {
                    "foo": "vault@example.com",
                    "bar": "12345",
                },
            })
        ```

        ## Required Vault Capabilities

        Use of this resource requires the `create` or `update` capability
        (depending on whether the resource already exists) on the given path,
        the `delete` capability if the resource is removed from configuration,
        and the `read` capability for drift detection (by default).

        ### Custom Metadata Configuration Options

        * `max_versions` - (Optional) The number of versions to keep per key.

        * `cas_required` - (Optional) If true, all keys will require the cas
        parameter to be set on all write requests.

        * `delete_version_after` - (Optional) If set, specifies the length of time before
        a version is deleted. Accepts duration in integer seconds.

        * `data` - (Optional) A string to string map describing the secret.

        ## Ephemeral Attributes Reference

        The following write-only attributes are supported:

        * `data_json_wo` - (Optional) JSON-encoded secret data to write to Vault. Can be updated.
          **Note**: This property is write-only and will not be read from the API.

        ## Import

        KV-V2 secrets can be imported using the `path`, e.g.

        ```sh
        $ pulumi import vault:kv/secretV2:SecretV2 example kvv2/data/secret
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] cas: This flag is required if `cas_required` is set to true
               on either the secret or the engine's config. In order for a
               write operation to be successful, cas must be set to the current version
               of the secret.
        :param pulumi.Input[Union['SecretV2CustomMetadataArgs', 'SecretV2CustomMetadataArgsDict']] custom_metadata: A nested block that allows configuring metadata for the
               KV secret. Refer to the
               Configuration Options for more info.
        :param pulumi.Input[_builtins.str] data_json: JSON-encoded string that will be
               written as the secret data at the given path.
        :param pulumi.Input[_builtins.str] data_json_wo: **NOTE:** This field is write-only and its value will not be updated in state as part of read operations.
               Write-Only JSON-encoded secret data to write.
        :param pulumi.Input[_builtins.int] data_json_wo_version: The version of the `data_json_wo`. For more info see updating write-only attributes.
        :param pulumi.Input[_builtins.bool] delete_all_versions: If set to true, permanently deletes all
               versions for the specified key.
        :param pulumi.Input[_builtins.bool] disable_read: If set to true, disables reading secret from Vault;
               note: drift won't be detected.
        :param pulumi.Input[_builtins.str] mount: Path where KV-V2 engine is mounted.
        :param pulumi.Input[_builtins.str] name: Full name of the secret. For a nested secret
               the name is the nested path excluding the mount and data
               prefix. For example, for a secret at `kvv2/data/foo/bar/baz`
               the name is `foo/bar/baz`.
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] options: An object that holds option settings.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SecretV2Args,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Writes a KV-V2 secret to a given path in Vault.

        For more information on Vault's KV-V2 secret backend
        [see here](https://www.vaultproject.io/docs/secrets/kv/kv-v2).

        ## Example Usage

        ```python
        import pulumi
        import json
        import pulumi_vault as vault

        kvv2 = vault.Mount("kvv2",
            path="kvv2",
            type="kv",
            options={
                "version": "2",
            },
            description="KV Version 2 secret engine mount")
        example = vault.kv.SecretV2("example",
            mount=kvv2.path,
            name="secret",
            cas=1,
            delete_all_versions=True,
            data_json=json.dumps({
                "zip": "zap",
                "foo": "bar",
            }),
            custom_metadata={
                "max_versions": 5,
                "data": {
                    "foo": "vault@example.com",
                    "bar": "12345",
                },
            })
        ```

        ## Required Vault Capabilities

        Use of this resource requires the `create` or `update` capability
        (depending on whether the resource already exists) on the given path,
        the `delete` capability if the resource is removed from configuration,
        and the `read` capability for drift detection (by default).

        ### Custom Metadata Configuration Options

        * `max_versions` - (Optional) The number of versions to keep per key.

        * `cas_required` - (Optional) If true, all keys will require the cas
        parameter to be set on all write requests.

        * `delete_version_after` - (Optional) If set, specifies the length of time before
        a version is deleted. Accepts duration in integer seconds.

        * `data` - (Optional) A string to string map describing the secret.

        ## Ephemeral Attributes Reference

        The following write-only attributes are supported:

        * `data_json_wo` - (Optional) JSON-encoded secret data to write to Vault. Can be updated.
          **Note**: This property is write-only and will not be read from the API.

        ## Import

        KV-V2 secrets can be imported using the `path`, e.g.

        ```sh
        $ pulumi import vault:kv/secretV2:SecretV2 example kvv2/data/secret
        ```

        :param str resource_name: The name of the resource.
        :param SecretV2Args args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SecretV2Args, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cas: Optional[pulumi.Input[_builtins.int]] = None,
                 custom_metadata: Optional[pulumi.Input[Union['SecretV2CustomMetadataArgs', 'SecretV2CustomMetadataArgsDict']]] = None,
                 data_json: Optional[pulumi.Input[_builtins.str]] = None,
                 data_json_wo: Optional[pulumi.Input[_builtins.str]] = None,
                 data_json_wo_version: Optional[pulumi.Input[_builtins.int]] = None,
                 delete_all_versions: Optional[pulumi.Input[_builtins.bool]] = None,
                 disable_read: Optional[pulumi.Input[_builtins.bool]] = None,
                 mount: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 options: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SecretV2Args.__new__(SecretV2Args)

            __props__.__dict__["cas"] = cas
            __props__.__dict__["custom_metadata"] = custom_metadata
            __props__.__dict__["data_json"] = None if data_json is None else pulumi.Output.secret(data_json)
            __props__.__dict__["data_json_wo"] = None if data_json_wo is None else pulumi.Output.secret(data_json_wo)
            __props__.__dict__["data_json_wo_version"] = data_json_wo_version
            __props__.__dict__["delete_all_versions"] = delete_all_versions
            __props__.__dict__["disable_read"] = disable_read
            if mount is None and not opts.urn:
                raise TypeError("Missing required property 'mount'")
            __props__.__dict__["mount"] = mount
            __props__.__dict__["name"] = name
            __props__.__dict__["namespace"] = namespace
            __props__.__dict__["options"] = options
            __props__.__dict__["data"] = None
            __props__.__dict__["metadata"] = None
            __props__.__dict__["path"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["data", "dataJson", "dataJsonWo"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(SecretV2, __self__).__init__(
            'vault:kv/secretV2:SecretV2',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cas: Optional[pulumi.Input[_builtins.int]] = None,
            custom_metadata: Optional[pulumi.Input[Union['SecretV2CustomMetadataArgs', 'SecretV2CustomMetadataArgsDict']]] = None,
            data: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            data_json: Optional[pulumi.Input[_builtins.str]] = None,
            data_json_wo: Optional[pulumi.Input[_builtins.str]] = None,
            data_json_wo_version: Optional[pulumi.Input[_builtins.int]] = None,
            delete_all_versions: Optional[pulumi.Input[_builtins.bool]] = None,
            disable_read: Optional[pulumi.Input[_builtins.bool]] = None,
            metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            mount: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            namespace: Optional[pulumi.Input[_builtins.str]] = None,
            options: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            path: Optional[pulumi.Input[_builtins.str]] = None) -> 'SecretV2':
        """
        Get an existing SecretV2 resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] cas: This flag is required if `cas_required` is set to true
               on either the secret or the engine's config. In order for a
               write operation to be successful, cas must be set to the current version
               of the secret.
        :param pulumi.Input[Union['SecretV2CustomMetadataArgs', 'SecretV2CustomMetadataArgsDict']] custom_metadata: A nested block that allows configuring metadata for the
               KV secret. Refer to the
               Configuration Options for more info.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] data: **Deprecated. Please use new ephemeral resource `kv.SecretV2` to read back
               secret data from Vault**. A mapping whose keys are the top-level data keys returned from
               Vault and whose values are the corresponding values. This map can only represent string data,
               so any non-string values returned from Vault are serialized as JSON.
        :param pulumi.Input[_builtins.str] data_json: JSON-encoded string that will be
               written as the secret data at the given path.
        :param pulumi.Input[_builtins.str] data_json_wo: **NOTE:** This field is write-only and its value will not be updated in state as part of read operations.
               Write-Only JSON-encoded secret data to write.
        :param pulumi.Input[_builtins.int] data_json_wo_version: The version of the `data_json_wo`. For more info see updating write-only attributes.
        :param pulumi.Input[_builtins.bool] delete_all_versions: If set to true, permanently deletes all
               versions for the specified key.
        :param pulumi.Input[_builtins.bool] disable_read: If set to true, disables reading secret from Vault;
               note: drift won't be detected.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] metadata: Metadata associated with this secret read from Vault.
        :param pulumi.Input[_builtins.str] mount: Path where KV-V2 engine is mounted.
        :param pulumi.Input[_builtins.str] name: Full name of the secret. For a nested secret
               the name is the nested path excluding the mount and data
               prefix. For example, for a secret at `kvv2/data/foo/bar/baz`
               the name is `foo/bar/baz`.
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] options: An object that holds option settings.
        :param pulumi.Input[_builtins.str] path: Full path where the KV-V2 secret will be written.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SecretV2State.__new__(_SecretV2State)

        __props__.__dict__["cas"] = cas
        __props__.__dict__["custom_metadata"] = custom_metadata
        __props__.__dict__["data"] = data
        __props__.__dict__["data_json"] = data_json
        __props__.__dict__["data_json_wo"] = data_json_wo
        __props__.__dict__["data_json_wo_version"] = data_json_wo_version
        __props__.__dict__["delete_all_versions"] = delete_all_versions
        __props__.__dict__["disable_read"] = disable_read
        __props__.__dict__["metadata"] = metadata
        __props__.__dict__["mount"] = mount
        __props__.__dict__["name"] = name
        __props__.__dict__["namespace"] = namespace
        __props__.__dict__["options"] = options
        __props__.__dict__["path"] = path
        return SecretV2(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def cas(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        This flag is required if `cas_required` is set to true
        on either the secret or the engine's config. In order for a
        write operation to be successful, cas must be set to the current version
        of the secret.
        """
        return pulumi.get(self, "cas")

    @_builtins.property
    @pulumi.getter(name="customMetadata")
    def custom_metadata(self) -> pulumi.Output['outputs.SecretV2CustomMetadata']:
        """
        A nested block that allows configuring metadata for the
        KV secret. Refer to the
        Configuration Options for more info.
        """
        return pulumi.get(self, "custom_metadata")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Deprecated. Will no longer be set on a read.""")
    def data(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        **Deprecated. Please use new ephemeral resource `kv.SecretV2` to read back
        secret data from Vault**. A mapping whose keys are the top-level data keys returned from
        Vault and whose values are the corresponding values. This map can only represent string data,
        so any non-string values returned from Vault are serialized as JSON.
        """
        return pulumi.get(self, "data")

    @_builtins.property
    @pulumi.getter(name="dataJson")
    def data_json(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        JSON-encoded string that will be
        written as the secret data at the given path.
        """
        return pulumi.get(self, "data_json")

    @_builtins.property
    @pulumi.getter(name="dataJsonWo")
    def data_json_wo(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        **NOTE:** This field is write-only and its value will not be updated in state as part of read operations.
        Write-Only JSON-encoded secret data to write.
        """
        return pulumi.get(self, "data_json_wo")

    @_builtins.property
    @pulumi.getter(name="dataJsonWoVersion")
    def data_json_wo_version(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The version of the `data_json_wo`. For more info see updating write-only attributes.
        """
        return pulumi.get(self, "data_json_wo_version")

    @_builtins.property
    @pulumi.getter(name="deleteAllVersions")
    def delete_all_versions(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        If set to true, permanently deletes all
        versions for the specified key.
        """
        return pulumi.get(self, "delete_all_versions")

    @_builtins.property
    @pulumi.getter(name="disableRead")
    def disable_read(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        If set to true, disables reading secret from Vault;
        note: drift won't be detected.
        """
        return pulumi.get(self, "disable_read")

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        Metadata associated with this secret read from Vault.
        """
        return pulumi.get(self, "metadata")

    @_builtins.property
    @pulumi.getter
    def mount(self) -> pulumi.Output[_builtins.str]:
        """
        Path where KV-V2 engine is mounted.
        """
        return pulumi.get(self, "mount")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Full name of the secret. For a nested secret
        the name is the nested path excluding the mount and data
        prefix. For example, for a secret at `kvv2/data/foo/bar/baz`
        the name is `foo/bar/baz`.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter
    def options(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        An object that holds option settings.
        """
        return pulumi.get(self, "options")

    @_builtins.property
    @pulumi.getter
    def path(self) -> pulumi.Output[_builtins.str]:
        """
        Full path where the KV-V2 secret will be written.
        """
        return pulumi.get(self, "path")

