# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AuthBackendArgs', 'AuthBackend']

@pulumi.input_type
class AuthBackendArgs:
    def __init__(__self__, *,
                 url: pulumi.Input[_builtins.str],
                 anonymous_group_search: Optional[pulumi.Input[_builtins.bool]] = None,
                 binddn: Optional[pulumi.Input[_builtins.str]] = None,
                 bindpass: Optional[pulumi.Input[_builtins.str]] = None,
                 case_sensitive_names: Optional[pulumi.Input[_builtins.bool]] = None,
                 certificate: Optional[pulumi.Input[_builtins.str]] = None,
                 client_tls_cert: Optional[pulumi.Input[_builtins.str]] = None,
                 client_tls_key: Optional[pulumi.Input[_builtins.str]] = None,
                 connection_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 deny_null_bind: Optional[pulumi.Input[_builtins.bool]] = None,
                 dereference_aliases: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disable_automated_rotation: Optional[pulumi.Input[_builtins.bool]] = None,
                 disable_remount: Optional[pulumi.Input[_builtins.bool]] = None,
                 discoverdn: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_samaccountname_login: Optional[pulumi.Input[_builtins.bool]] = None,
                 groupattr: Optional[pulumi.Input[_builtins.str]] = None,
                 groupdn: Optional[pulumi.Input[_builtins.str]] = None,
                 groupfilter: Optional[pulumi.Input[_builtins.str]] = None,
                 insecure_tls: Optional[pulumi.Input[_builtins.bool]] = None,
                 local: Optional[pulumi.Input[_builtins.bool]] = None,
                 max_page_size: Optional[pulumi.Input[_builtins.int]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 path: Optional[pulumi.Input[_builtins.str]] = None,
                 request_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 rotation_period: Optional[pulumi.Input[_builtins.int]] = None,
                 rotation_schedule: Optional[pulumi.Input[_builtins.str]] = None,
                 rotation_window: Optional[pulumi.Input[_builtins.int]] = None,
                 starttls: Optional[pulumi.Input[_builtins.bool]] = None,
                 tls_max_version: Optional[pulumi.Input[_builtins.str]] = None,
                 tls_min_version: Optional[pulumi.Input[_builtins.str]] = None,
                 token_bound_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 token_explicit_max_ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 token_max_ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 token_no_default_policy: Optional[pulumi.Input[_builtins.bool]] = None,
                 token_num_uses: Optional[pulumi.Input[_builtins.int]] = None,
                 token_period: Optional[pulumi.Input[_builtins.int]] = None,
                 token_policies: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 token_ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 token_type: Optional[pulumi.Input[_builtins.str]] = None,
                 tune: Optional[pulumi.Input['AuthBackendTuneArgs']] = None,
                 upndomain: Optional[pulumi.Input[_builtins.str]] = None,
                 use_token_groups: Optional[pulumi.Input[_builtins.bool]] = None,
                 userattr: Optional[pulumi.Input[_builtins.str]] = None,
                 userdn: Optional[pulumi.Input[_builtins.str]] = None,
                 userfilter: Optional[pulumi.Input[_builtins.str]] = None,
                 username_as_alias: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a AuthBackend resource.
        :param pulumi.Input[_builtins.str] url: The URL of the LDAP server
        :param pulumi.Input[_builtins.bool] anonymous_group_search: Allows anonymous group searches.
        :param pulumi.Input[_builtins.str] binddn: DN of object to bind when performing user search
        :param pulumi.Input[_builtins.str] bindpass: Password to use with `binddn` when performing user search
        :param pulumi.Input[_builtins.bool] case_sensitive_names: Control case senstivity of objects fetched from LDAP, this is used for object matching in vault
        :param pulumi.Input[_builtins.str] certificate: Trusted CA to validate TLS certificate
        :param pulumi.Input[_builtins.int] connection_timeout: Timeout in seconds when connecting to LDAP before attempting to connect to the next server in the URL provided in `url` (integer: 30)
        :param pulumi.Input[_builtins.bool] deny_null_bind: Prevents users from bypassing authentication when providing an empty password.
        :param pulumi.Input[_builtins.str] dereference_aliases: Specifies how aliases are dereferenced during LDAP searches. Valid values are 'never','searching','finding', and 'always'.
        :param pulumi.Input[_builtins.str] description: Description for the LDAP auth backend mount
        :param pulumi.Input[_builtins.bool] disable_automated_rotation: Cancels all upcoming rotations of the root credential until unset. Requires Vault Enterprise 1.19+.
        :param pulumi.Input[_builtins.bool] disable_remount: If set, opts out of mount migration on path updates.
               See here for more info on [Mount Migration](https://www.vaultproject.io/docs/concepts/mount-migration)
        :param pulumi.Input[_builtins.bool] discoverdn: Use anonymous bind to discover the bind DN of a user.
        :param pulumi.Input[_builtins.bool] enable_samaccountname_login: Enables login using the sAMAccountName attribute.
        :param pulumi.Input[_builtins.str] groupattr: LDAP attribute to follow on objects returned by groupfilter
        :param pulumi.Input[_builtins.str] groupdn: Base DN under which to perform group search
        :param pulumi.Input[_builtins.str] groupfilter: Go template used to construct group membership query
        :param pulumi.Input[_builtins.bool] insecure_tls: Control whether or TLS certificates must be validated
        :param pulumi.Input[_builtins.bool] local: Specifies if the auth method is local only.
        :param pulumi.Input[_builtins.int] max_page_size: Sets the max page size for LDAP lookups, by default it's set to -1.
               *Available only for Vault 1.11.11+, 1.12.7+, and 1.13.3+*.
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.str] path: Path to mount the LDAP auth backend under
        :param pulumi.Input[_builtins.int] request_timeout: The timeout(in sec) for requests to the LDAP server.
        :param pulumi.Input[_builtins.int] rotation_period: The amount of time in seconds Vault should wait before rotating the root credential.
               A zero value tells Vault not to rotate the root credential. The minimum rotation period is 10 seconds. Requires Vault Enterprise 1.19+.
        :param pulumi.Input[_builtins.str] rotation_schedule: The schedule, in [cron-style time format](https://en.wikipedia.org/wiki/Cron),
               defining the schedule on which Vault should rotate the root token. Requires Vault Enterprise 1.19+.
        :param pulumi.Input[_builtins.int] rotation_window: The maximum amount of time in seconds allowed to complete
               a rotation when a scheduled token rotation occurs. The default rotation window is
               unbound and the minimum allowable window is `3600`. Requires Vault Enterprise 1.19+.
        :param pulumi.Input[_builtins.bool] starttls: Control use of TLS when conecting to LDAP
        :param pulumi.Input[_builtins.str] tls_max_version: Maximum acceptable version of TLS
        :param pulumi.Input[_builtins.str] tls_min_version: Minimum acceptable version of TLS
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] token_bound_cidrs: Specifies the blocks of IP addresses which are allowed to use the generated token
        :param pulumi.Input[_builtins.int] token_explicit_max_ttl: Generated Token's Explicit Maximum TTL in seconds
        :param pulumi.Input[_builtins.int] token_max_ttl: The maximum lifetime of the generated token
        :param pulumi.Input[_builtins.bool] token_no_default_policy: If true, the 'default' policy will not automatically be added to generated tokens
        :param pulumi.Input[_builtins.int] token_num_uses: The maximum number of times a token may be used, a value of zero means unlimited
        :param pulumi.Input[_builtins.int] token_period: Generated Token's Period
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] token_policies: Generated Token's Policies
        :param pulumi.Input[_builtins.int] token_ttl: The initial ttl of the token to generate in seconds
        :param pulumi.Input[_builtins.str] token_type: Specifies the type of tokens that should be returned by
               the mount. Valid values are "default-service", "default-batch", "service", "batch".
        :param pulumi.Input['AuthBackendTuneArgs'] tune: Extra configuration block. Structure is documented below.
               
               The `tune` block is used to tune the auth backend:
        :param pulumi.Input[_builtins.str] upndomain: The `userPrincipalDomain` used to construct the UPN string for the authenticating user.
        :param pulumi.Input[_builtins.bool] use_token_groups: Use the Active Directory tokenGroups constructed attribute of the user to find the group memberships
        :param pulumi.Input[_builtins.str] userattr: Attribute on user object matching username passed in
        :param pulumi.Input[_builtins.str] userdn: Base DN under which to perform user search
        :param pulumi.Input[_builtins.str] userfilter: LDAP user search filter
        :param pulumi.Input[_builtins.bool] username_as_alias: Force the auth method to use the username passed by the user as the alias name.
        """
        pulumi.set(__self__, "url", url)
        if anonymous_group_search is not None:
            pulumi.set(__self__, "anonymous_group_search", anonymous_group_search)
        if binddn is not None:
            pulumi.set(__self__, "binddn", binddn)
        if bindpass is not None:
            pulumi.set(__self__, "bindpass", bindpass)
        if case_sensitive_names is not None:
            pulumi.set(__self__, "case_sensitive_names", case_sensitive_names)
        if certificate is not None:
            pulumi.set(__self__, "certificate", certificate)
        if client_tls_cert is not None:
            pulumi.set(__self__, "client_tls_cert", client_tls_cert)
        if client_tls_key is not None:
            pulumi.set(__self__, "client_tls_key", client_tls_key)
        if connection_timeout is not None:
            pulumi.set(__self__, "connection_timeout", connection_timeout)
        if deny_null_bind is not None:
            pulumi.set(__self__, "deny_null_bind", deny_null_bind)
        if dereference_aliases is not None:
            pulumi.set(__self__, "dereference_aliases", dereference_aliases)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disable_automated_rotation is not None:
            pulumi.set(__self__, "disable_automated_rotation", disable_automated_rotation)
        if disable_remount is not None:
            pulumi.set(__self__, "disable_remount", disable_remount)
        if discoverdn is not None:
            pulumi.set(__self__, "discoverdn", discoverdn)
        if enable_samaccountname_login is not None:
            pulumi.set(__self__, "enable_samaccountname_login", enable_samaccountname_login)
        if groupattr is not None:
            pulumi.set(__self__, "groupattr", groupattr)
        if groupdn is not None:
            pulumi.set(__self__, "groupdn", groupdn)
        if groupfilter is not None:
            pulumi.set(__self__, "groupfilter", groupfilter)
        if insecure_tls is not None:
            pulumi.set(__self__, "insecure_tls", insecure_tls)
        if local is not None:
            pulumi.set(__self__, "local", local)
        if max_page_size is not None:
            pulumi.set(__self__, "max_page_size", max_page_size)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if request_timeout is not None:
            pulumi.set(__self__, "request_timeout", request_timeout)
        if rotation_period is not None:
            pulumi.set(__self__, "rotation_period", rotation_period)
        if rotation_schedule is not None:
            pulumi.set(__self__, "rotation_schedule", rotation_schedule)
        if rotation_window is not None:
            pulumi.set(__self__, "rotation_window", rotation_window)
        if starttls is not None:
            pulumi.set(__self__, "starttls", starttls)
        if tls_max_version is not None:
            pulumi.set(__self__, "tls_max_version", tls_max_version)
        if tls_min_version is not None:
            pulumi.set(__self__, "tls_min_version", tls_min_version)
        if token_bound_cidrs is not None:
            pulumi.set(__self__, "token_bound_cidrs", token_bound_cidrs)
        if token_explicit_max_ttl is not None:
            pulumi.set(__self__, "token_explicit_max_ttl", token_explicit_max_ttl)
        if token_max_ttl is not None:
            pulumi.set(__self__, "token_max_ttl", token_max_ttl)
        if token_no_default_policy is not None:
            pulumi.set(__self__, "token_no_default_policy", token_no_default_policy)
        if token_num_uses is not None:
            pulumi.set(__self__, "token_num_uses", token_num_uses)
        if token_period is not None:
            pulumi.set(__self__, "token_period", token_period)
        if token_policies is not None:
            pulumi.set(__self__, "token_policies", token_policies)
        if token_ttl is not None:
            pulumi.set(__self__, "token_ttl", token_ttl)
        if token_type is not None:
            pulumi.set(__self__, "token_type", token_type)
        if tune is not None:
            pulumi.set(__self__, "tune", tune)
        if upndomain is not None:
            pulumi.set(__self__, "upndomain", upndomain)
        if use_token_groups is not None:
            pulumi.set(__self__, "use_token_groups", use_token_groups)
        if userattr is not None:
            pulumi.set(__self__, "userattr", userattr)
        if userdn is not None:
            pulumi.set(__self__, "userdn", userdn)
        if userfilter is not None:
            pulumi.set(__self__, "userfilter", userfilter)
        if username_as_alias is not None:
            pulumi.set(__self__, "username_as_alias", username_as_alias)

    @_builtins.property
    @pulumi.getter
    def url(self) -> pulumi.Input[_builtins.str]:
        """
        The URL of the LDAP server
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "url", value)

    @_builtins.property
    @pulumi.getter(name="anonymousGroupSearch")
    def anonymous_group_search(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Allows anonymous group searches.
        """
        return pulumi.get(self, "anonymous_group_search")

    @anonymous_group_search.setter
    def anonymous_group_search(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "anonymous_group_search", value)

    @_builtins.property
    @pulumi.getter
    def binddn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        DN of object to bind when performing user search
        """
        return pulumi.get(self, "binddn")

    @binddn.setter
    def binddn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "binddn", value)

    @_builtins.property
    @pulumi.getter
    def bindpass(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Password to use with `binddn` when performing user search
        """
        return pulumi.get(self, "bindpass")

    @bindpass.setter
    def bindpass(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bindpass", value)

    @_builtins.property
    @pulumi.getter(name="caseSensitiveNames")
    def case_sensitive_names(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Control case senstivity of objects fetched from LDAP, this is used for object matching in vault
        """
        return pulumi.get(self, "case_sensitive_names")

    @case_sensitive_names.setter
    def case_sensitive_names(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "case_sensitive_names", value)

    @_builtins.property
    @pulumi.getter
    def certificate(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Trusted CA to validate TLS certificate
        """
        return pulumi.get(self, "certificate")

    @certificate.setter
    def certificate(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "certificate", value)

    @_builtins.property
    @pulumi.getter(name="clientTlsCert")
    def client_tls_cert(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "client_tls_cert")

    @client_tls_cert.setter
    def client_tls_cert(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_tls_cert", value)

    @_builtins.property
    @pulumi.getter(name="clientTlsKey")
    def client_tls_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "client_tls_key")

    @client_tls_key.setter
    def client_tls_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_tls_key", value)

    @_builtins.property
    @pulumi.getter(name="connectionTimeout")
    def connection_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Timeout in seconds when connecting to LDAP before attempting to connect to the next server in the URL provided in `url` (integer: 30)
        """
        return pulumi.get(self, "connection_timeout")

    @connection_timeout.setter
    def connection_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "connection_timeout", value)

    @_builtins.property
    @pulumi.getter(name="denyNullBind")
    def deny_null_bind(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Prevents users from bypassing authentication when providing an empty password.
        """
        return pulumi.get(self, "deny_null_bind")

    @deny_null_bind.setter
    def deny_null_bind(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "deny_null_bind", value)

    @_builtins.property
    @pulumi.getter(name="dereferenceAliases")
    def dereference_aliases(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies how aliases are dereferenced during LDAP searches. Valid values are 'never','searching','finding', and 'always'.
        """
        return pulumi.get(self, "dereference_aliases")

    @dereference_aliases.setter
    def dereference_aliases(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dereference_aliases", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description for the LDAP auth backend mount
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="disableAutomatedRotation")
    def disable_automated_rotation(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Cancels all upcoming rotations of the root credential until unset. Requires Vault Enterprise 1.19+.
        """
        return pulumi.get(self, "disable_automated_rotation")

    @disable_automated_rotation.setter
    def disable_automated_rotation(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disable_automated_rotation", value)

    @_builtins.property
    @pulumi.getter(name="disableRemount")
    def disable_remount(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If set, opts out of mount migration on path updates.
        See here for more info on [Mount Migration](https://www.vaultproject.io/docs/concepts/mount-migration)
        """
        return pulumi.get(self, "disable_remount")

    @disable_remount.setter
    def disable_remount(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disable_remount", value)

    @_builtins.property
    @pulumi.getter
    def discoverdn(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Use anonymous bind to discover the bind DN of a user.
        """
        return pulumi.get(self, "discoverdn")

    @discoverdn.setter
    def discoverdn(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "discoverdn", value)

    @_builtins.property
    @pulumi.getter(name="enableSamaccountnameLogin")
    def enable_samaccountname_login(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enables login using the sAMAccountName attribute.
        """
        return pulumi.get(self, "enable_samaccountname_login")

    @enable_samaccountname_login.setter
    def enable_samaccountname_login(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_samaccountname_login", value)

    @_builtins.property
    @pulumi.getter
    def groupattr(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        LDAP attribute to follow on objects returned by groupfilter
        """
        return pulumi.get(self, "groupattr")

    @groupattr.setter
    def groupattr(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "groupattr", value)

    @_builtins.property
    @pulumi.getter
    def groupdn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Base DN under which to perform group search
        """
        return pulumi.get(self, "groupdn")

    @groupdn.setter
    def groupdn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "groupdn", value)

    @_builtins.property
    @pulumi.getter
    def groupfilter(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Go template used to construct group membership query
        """
        return pulumi.get(self, "groupfilter")

    @groupfilter.setter
    def groupfilter(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "groupfilter", value)

    @_builtins.property
    @pulumi.getter(name="insecureTls")
    def insecure_tls(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Control whether or TLS certificates must be validated
        """
        return pulumi.get(self, "insecure_tls")

    @insecure_tls.setter
    def insecure_tls(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "insecure_tls", value)

    @_builtins.property
    @pulumi.getter
    def local(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies if the auth method is local only.
        """
        return pulumi.get(self, "local")

    @local.setter
    def local(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "local", value)

    @_builtins.property
    @pulumi.getter(name="maxPageSize")
    def max_page_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Sets the max page size for LDAP lookups, by default it's set to -1.
        *Available only for Vault 1.11.11+, 1.12.7+, and 1.13.3+*.
        """
        return pulumi.get(self, "max_page_size")

    @max_page_size.setter
    def max_page_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_page_size", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Path to mount the LDAP auth backend under
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "path", value)

    @_builtins.property
    @pulumi.getter(name="requestTimeout")
    def request_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The timeout(in sec) for requests to the LDAP server.
        """
        return pulumi.get(self, "request_timeout")

    @request_timeout.setter
    def request_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "request_timeout", value)

    @_builtins.property
    @pulumi.getter(name="rotationPeriod")
    def rotation_period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The amount of time in seconds Vault should wait before rotating the root credential.
        A zero value tells Vault not to rotate the root credential. The minimum rotation period is 10 seconds. Requires Vault Enterprise 1.19+.
        """
        return pulumi.get(self, "rotation_period")

    @rotation_period.setter
    def rotation_period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "rotation_period", value)

    @_builtins.property
    @pulumi.getter(name="rotationSchedule")
    def rotation_schedule(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The schedule, in [cron-style time format](https://en.wikipedia.org/wiki/Cron),
        defining the schedule on which Vault should rotate the root token. Requires Vault Enterprise 1.19+.
        """
        return pulumi.get(self, "rotation_schedule")

    @rotation_schedule.setter
    def rotation_schedule(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rotation_schedule", value)

    @_builtins.property
    @pulumi.getter(name="rotationWindow")
    def rotation_window(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum amount of time in seconds allowed to complete
        a rotation when a scheduled token rotation occurs. The default rotation window is
        unbound and the minimum allowable window is `3600`. Requires Vault Enterprise 1.19+.
        """
        return pulumi.get(self, "rotation_window")

    @rotation_window.setter
    def rotation_window(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "rotation_window", value)

    @_builtins.property
    @pulumi.getter
    def starttls(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Control use of TLS when conecting to LDAP
        """
        return pulumi.get(self, "starttls")

    @starttls.setter
    def starttls(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "starttls", value)

    @_builtins.property
    @pulumi.getter(name="tlsMaxVersion")
    def tls_max_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Maximum acceptable version of TLS
        """
        return pulumi.get(self, "tls_max_version")

    @tls_max_version.setter
    def tls_max_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tls_max_version", value)

    @_builtins.property
    @pulumi.getter(name="tlsMinVersion")
    def tls_min_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Minimum acceptable version of TLS
        """
        return pulumi.get(self, "tls_min_version")

    @tls_min_version.setter
    def tls_min_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tls_min_version", value)

    @_builtins.property
    @pulumi.getter(name="tokenBoundCidrs")
    def token_bound_cidrs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies the blocks of IP addresses which are allowed to use the generated token
        """
        return pulumi.get(self, "token_bound_cidrs")

    @token_bound_cidrs.setter
    def token_bound_cidrs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "token_bound_cidrs", value)

    @_builtins.property
    @pulumi.getter(name="tokenExplicitMaxTtl")
    def token_explicit_max_ttl(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Generated Token's Explicit Maximum TTL in seconds
        """
        return pulumi.get(self, "token_explicit_max_ttl")

    @token_explicit_max_ttl.setter
    def token_explicit_max_ttl(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "token_explicit_max_ttl", value)

    @_builtins.property
    @pulumi.getter(name="tokenMaxTtl")
    def token_max_ttl(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum lifetime of the generated token
        """
        return pulumi.get(self, "token_max_ttl")

    @token_max_ttl.setter
    def token_max_ttl(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "token_max_ttl", value)

    @_builtins.property
    @pulumi.getter(name="tokenNoDefaultPolicy")
    def token_no_default_policy(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If true, the 'default' policy will not automatically be added to generated tokens
        """
        return pulumi.get(self, "token_no_default_policy")

    @token_no_default_policy.setter
    def token_no_default_policy(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "token_no_default_policy", value)

    @_builtins.property
    @pulumi.getter(name="tokenNumUses")
    def token_num_uses(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum number of times a token may be used, a value of zero means unlimited
        """
        return pulumi.get(self, "token_num_uses")

    @token_num_uses.setter
    def token_num_uses(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "token_num_uses", value)

    @_builtins.property
    @pulumi.getter(name="tokenPeriod")
    def token_period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Generated Token's Period
        """
        return pulumi.get(self, "token_period")

    @token_period.setter
    def token_period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "token_period", value)

    @_builtins.property
    @pulumi.getter(name="tokenPolicies")
    def token_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Generated Token's Policies
        """
        return pulumi.get(self, "token_policies")

    @token_policies.setter
    def token_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "token_policies", value)

    @_builtins.property
    @pulumi.getter(name="tokenTtl")
    def token_ttl(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The initial ttl of the token to generate in seconds
        """
        return pulumi.get(self, "token_ttl")

    @token_ttl.setter
    def token_ttl(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "token_ttl", value)

    @_builtins.property
    @pulumi.getter(name="tokenType")
    def token_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the type of tokens that should be returned by
        the mount. Valid values are "default-service", "default-batch", "service", "batch".
        """
        return pulumi.get(self, "token_type")

    @token_type.setter
    def token_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "token_type", value)

    @_builtins.property
    @pulumi.getter
    def tune(self) -> Optional[pulumi.Input['AuthBackendTuneArgs']]:
        """
        Extra configuration block. Structure is documented below.

        The `tune` block is used to tune the auth backend:
        """
        return pulumi.get(self, "tune")

    @tune.setter
    def tune(self, value: Optional[pulumi.Input['AuthBackendTuneArgs']]):
        pulumi.set(self, "tune", value)

    @_builtins.property
    @pulumi.getter
    def upndomain(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The `userPrincipalDomain` used to construct the UPN string for the authenticating user.
        """
        return pulumi.get(self, "upndomain")

    @upndomain.setter
    def upndomain(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "upndomain", value)

    @_builtins.property
    @pulumi.getter(name="useTokenGroups")
    def use_token_groups(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Use the Active Directory tokenGroups constructed attribute of the user to find the group memberships
        """
        return pulumi.get(self, "use_token_groups")

    @use_token_groups.setter
    def use_token_groups(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "use_token_groups", value)

    @_builtins.property
    @pulumi.getter
    def userattr(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Attribute on user object matching username passed in
        """
        return pulumi.get(self, "userattr")

    @userattr.setter
    def userattr(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "userattr", value)

    @_builtins.property
    @pulumi.getter
    def userdn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Base DN under which to perform user search
        """
        return pulumi.get(self, "userdn")

    @userdn.setter
    def userdn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "userdn", value)

    @_builtins.property
    @pulumi.getter
    def userfilter(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        LDAP user search filter
        """
        return pulumi.get(self, "userfilter")

    @userfilter.setter
    def userfilter(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "userfilter", value)

    @_builtins.property
    @pulumi.getter(name="usernameAsAlias")
    def username_as_alias(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Force the auth method to use the username passed by the user as the alias name.
        """
        return pulumi.get(self, "username_as_alias")

    @username_as_alias.setter
    def username_as_alias(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "username_as_alias", value)


@pulumi.input_type
class _AuthBackendState:
    def __init__(__self__, *,
                 accessor: Optional[pulumi.Input[_builtins.str]] = None,
                 anonymous_group_search: Optional[pulumi.Input[_builtins.bool]] = None,
                 binddn: Optional[pulumi.Input[_builtins.str]] = None,
                 bindpass: Optional[pulumi.Input[_builtins.str]] = None,
                 case_sensitive_names: Optional[pulumi.Input[_builtins.bool]] = None,
                 certificate: Optional[pulumi.Input[_builtins.str]] = None,
                 client_tls_cert: Optional[pulumi.Input[_builtins.str]] = None,
                 client_tls_key: Optional[pulumi.Input[_builtins.str]] = None,
                 connection_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 deny_null_bind: Optional[pulumi.Input[_builtins.bool]] = None,
                 dereference_aliases: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disable_automated_rotation: Optional[pulumi.Input[_builtins.bool]] = None,
                 disable_remount: Optional[pulumi.Input[_builtins.bool]] = None,
                 discoverdn: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_samaccountname_login: Optional[pulumi.Input[_builtins.bool]] = None,
                 groupattr: Optional[pulumi.Input[_builtins.str]] = None,
                 groupdn: Optional[pulumi.Input[_builtins.str]] = None,
                 groupfilter: Optional[pulumi.Input[_builtins.str]] = None,
                 insecure_tls: Optional[pulumi.Input[_builtins.bool]] = None,
                 local: Optional[pulumi.Input[_builtins.bool]] = None,
                 max_page_size: Optional[pulumi.Input[_builtins.int]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 path: Optional[pulumi.Input[_builtins.str]] = None,
                 request_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 rotation_period: Optional[pulumi.Input[_builtins.int]] = None,
                 rotation_schedule: Optional[pulumi.Input[_builtins.str]] = None,
                 rotation_window: Optional[pulumi.Input[_builtins.int]] = None,
                 starttls: Optional[pulumi.Input[_builtins.bool]] = None,
                 tls_max_version: Optional[pulumi.Input[_builtins.str]] = None,
                 tls_min_version: Optional[pulumi.Input[_builtins.str]] = None,
                 token_bound_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 token_explicit_max_ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 token_max_ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 token_no_default_policy: Optional[pulumi.Input[_builtins.bool]] = None,
                 token_num_uses: Optional[pulumi.Input[_builtins.int]] = None,
                 token_period: Optional[pulumi.Input[_builtins.int]] = None,
                 token_policies: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 token_ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 token_type: Optional[pulumi.Input[_builtins.str]] = None,
                 tune: Optional[pulumi.Input['AuthBackendTuneArgs']] = None,
                 upndomain: Optional[pulumi.Input[_builtins.str]] = None,
                 url: Optional[pulumi.Input[_builtins.str]] = None,
                 use_token_groups: Optional[pulumi.Input[_builtins.bool]] = None,
                 userattr: Optional[pulumi.Input[_builtins.str]] = None,
                 userdn: Optional[pulumi.Input[_builtins.str]] = None,
                 userfilter: Optional[pulumi.Input[_builtins.str]] = None,
                 username_as_alias: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        Input properties used for looking up and filtering AuthBackend resources.
        :param pulumi.Input[_builtins.str] accessor: The accessor for this auth mount.
        :param pulumi.Input[_builtins.bool] anonymous_group_search: Allows anonymous group searches.
        :param pulumi.Input[_builtins.str] binddn: DN of object to bind when performing user search
        :param pulumi.Input[_builtins.str] bindpass: Password to use with `binddn` when performing user search
        :param pulumi.Input[_builtins.bool] case_sensitive_names: Control case senstivity of objects fetched from LDAP, this is used for object matching in vault
        :param pulumi.Input[_builtins.str] certificate: Trusted CA to validate TLS certificate
        :param pulumi.Input[_builtins.int] connection_timeout: Timeout in seconds when connecting to LDAP before attempting to connect to the next server in the URL provided in `url` (integer: 30)
        :param pulumi.Input[_builtins.bool] deny_null_bind: Prevents users from bypassing authentication when providing an empty password.
        :param pulumi.Input[_builtins.str] dereference_aliases: Specifies how aliases are dereferenced during LDAP searches. Valid values are 'never','searching','finding', and 'always'.
        :param pulumi.Input[_builtins.str] description: Description for the LDAP auth backend mount
        :param pulumi.Input[_builtins.bool] disable_automated_rotation: Cancels all upcoming rotations of the root credential until unset. Requires Vault Enterprise 1.19+.
        :param pulumi.Input[_builtins.bool] disable_remount: If set, opts out of mount migration on path updates.
               See here for more info on [Mount Migration](https://www.vaultproject.io/docs/concepts/mount-migration)
        :param pulumi.Input[_builtins.bool] discoverdn: Use anonymous bind to discover the bind DN of a user.
        :param pulumi.Input[_builtins.bool] enable_samaccountname_login: Enables login using the sAMAccountName attribute.
        :param pulumi.Input[_builtins.str] groupattr: LDAP attribute to follow on objects returned by groupfilter
        :param pulumi.Input[_builtins.str] groupdn: Base DN under which to perform group search
        :param pulumi.Input[_builtins.str] groupfilter: Go template used to construct group membership query
        :param pulumi.Input[_builtins.bool] insecure_tls: Control whether or TLS certificates must be validated
        :param pulumi.Input[_builtins.bool] local: Specifies if the auth method is local only.
        :param pulumi.Input[_builtins.int] max_page_size: Sets the max page size for LDAP lookups, by default it's set to -1.
               *Available only for Vault 1.11.11+, 1.12.7+, and 1.13.3+*.
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.str] path: Path to mount the LDAP auth backend under
        :param pulumi.Input[_builtins.int] request_timeout: The timeout(in sec) for requests to the LDAP server.
        :param pulumi.Input[_builtins.int] rotation_period: The amount of time in seconds Vault should wait before rotating the root credential.
               A zero value tells Vault not to rotate the root credential. The minimum rotation period is 10 seconds. Requires Vault Enterprise 1.19+.
        :param pulumi.Input[_builtins.str] rotation_schedule: The schedule, in [cron-style time format](https://en.wikipedia.org/wiki/Cron),
               defining the schedule on which Vault should rotate the root token. Requires Vault Enterprise 1.19+.
        :param pulumi.Input[_builtins.int] rotation_window: The maximum amount of time in seconds allowed to complete
               a rotation when a scheduled token rotation occurs. The default rotation window is
               unbound and the minimum allowable window is `3600`. Requires Vault Enterprise 1.19+.
        :param pulumi.Input[_builtins.bool] starttls: Control use of TLS when conecting to LDAP
        :param pulumi.Input[_builtins.str] tls_max_version: Maximum acceptable version of TLS
        :param pulumi.Input[_builtins.str] tls_min_version: Minimum acceptable version of TLS
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] token_bound_cidrs: Specifies the blocks of IP addresses which are allowed to use the generated token
        :param pulumi.Input[_builtins.int] token_explicit_max_ttl: Generated Token's Explicit Maximum TTL in seconds
        :param pulumi.Input[_builtins.int] token_max_ttl: The maximum lifetime of the generated token
        :param pulumi.Input[_builtins.bool] token_no_default_policy: If true, the 'default' policy will not automatically be added to generated tokens
        :param pulumi.Input[_builtins.int] token_num_uses: The maximum number of times a token may be used, a value of zero means unlimited
        :param pulumi.Input[_builtins.int] token_period: Generated Token's Period
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] token_policies: Generated Token's Policies
        :param pulumi.Input[_builtins.int] token_ttl: The initial ttl of the token to generate in seconds
        :param pulumi.Input[_builtins.str] token_type: Specifies the type of tokens that should be returned by
               the mount. Valid values are "default-service", "default-batch", "service", "batch".
        :param pulumi.Input['AuthBackendTuneArgs'] tune: Extra configuration block. Structure is documented below.
               
               The `tune` block is used to tune the auth backend:
        :param pulumi.Input[_builtins.str] upndomain: The `userPrincipalDomain` used to construct the UPN string for the authenticating user.
        :param pulumi.Input[_builtins.str] url: The URL of the LDAP server
        :param pulumi.Input[_builtins.bool] use_token_groups: Use the Active Directory tokenGroups constructed attribute of the user to find the group memberships
        :param pulumi.Input[_builtins.str] userattr: Attribute on user object matching username passed in
        :param pulumi.Input[_builtins.str] userdn: Base DN under which to perform user search
        :param pulumi.Input[_builtins.str] userfilter: LDAP user search filter
        :param pulumi.Input[_builtins.bool] username_as_alias: Force the auth method to use the username passed by the user as the alias name.
        """
        if accessor is not None:
            pulumi.set(__self__, "accessor", accessor)
        if anonymous_group_search is not None:
            pulumi.set(__self__, "anonymous_group_search", anonymous_group_search)
        if binddn is not None:
            pulumi.set(__self__, "binddn", binddn)
        if bindpass is not None:
            pulumi.set(__self__, "bindpass", bindpass)
        if case_sensitive_names is not None:
            pulumi.set(__self__, "case_sensitive_names", case_sensitive_names)
        if certificate is not None:
            pulumi.set(__self__, "certificate", certificate)
        if client_tls_cert is not None:
            pulumi.set(__self__, "client_tls_cert", client_tls_cert)
        if client_tls_key is not None:
            pulumi.set(__self__, "client_tls_key", client_tls_key)
        if connection_timeout is not None:
            pulumi.set(__self__, "connection_timeout", connection_timeout)
        if deny_null_bind is not None:
            pulumi.set(__self__, "deny_null_bind", deny_null_bind)
        if dereference_aliases is not None:
            pulumi.set(__self__, "dereference_aliases", dereference_aliases)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disable_automated_rotation is not None:
            pulumi.set(__self__, "disable_automated_rotation", disable_automated_rotation)
        if disable_remount is not None:
            pulumi.set(__self__, "disable_remount", disable_remount)
        if discoverdn is not None:
            pulumi.set(__self__, "discoverdn", discoverdn)
        if enable_samaccountname_login is not None:
            pulumi.set(__self__, "enable_samaccountname_login", enable_samaccountname_login)
        if groupattr is not None:
            pulumi.set(__self__, "groupattr", groupattr)
        if groupdn is not None:
            pulumi.set(__self__, "groupdn", groupdn)
        if groupfilter is not None:
            pulumi.set(__self__, "groupfilter", groupfilter)
        if insecure_tls is not None:
            pulumi.set(__self__, "insecure_tls", insecure_tls)
        if local is not None:
            pulumi.set(__self__, "local", local)
        if max_page_size is not None:
            pulumi.set(__self__, "max_page_size", max_page_size)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if request_timeout is not None:
            pulumi.set(__self__, "request_timeout", request_timeout)
        if rotation_period is not None:
            pulumi.set(__self__, "rotation_period", rotation_period)
        if rotation_schedule is not None:
            pulumi.set(__self__, "rotation_schedule", rotation_schedule)
        if rotation_window is not None:
            pulumi.set(__self__, "rotation_window", rotation_window)
        if starttls is not None:
            pulumi.set(__self__, "starttls", starttls)
        if tls_max_version is not None:
            pulumi.set(__self__, "tls_max_version", tls_max_version)
        if tls_min_version is not None:
            pulumi.set(__self__, "tls_min_version", tls_min_version)
        if token_bound_cidrs is not None:
            pulumi.set(__self__, "token_bound_cidrs", token_bound_cidrs)
        if token_explicit_max_ttl is not None:
            pulumi.set(__self__, "token_explicit_max_ttl", token_explicit_max_ttl)
        if token_max_ttl is not None:
            pulumi.set(__self__, "token_max_ttl", token_max_ttl)
        if token_no_default_policy is not None:
            pulumi.set(__self__, "token_no_default_policy", token_no_default_policy)
        if token_num_uses is not None:
            pulumi.set(__self__, "token_num_uses", token_num_uses)
        if token_period is not None:
            pulumi.set(__self__, "token_period", token_period)
        if token_policies is not None:
            pulumi.set(__self__, "token_policies", token_policies)
        if token_ttl is not None:
            pulumi.set(__self__, "token_ttl", token_ttl)
        if token_type is not None:
            pulumi.set(__self__, "token_type", token_type)
        if tune is not None:
            pulumi.set(__self__, "tune", tune)
        if upndomain is not None:
            pulumi.set(__self__, "upndomain", upndomain)
        if url is not None:
            pulumi.set(__self__, "url", url)
        if use_token_groups is not None:
            pulumi.set(__self__, "use_token_groups", use_token_groups)
        if userattr is not None:
            pulumi.set(__self__, "userattr", userattr)
        if userdn is not None:
            pulumi.set(__self__, "userdn", userdn)
        if userfilter is not None:
            pulumi.set(__self__, "userfilter", userfilter)
        if username_as_alias is not None:
            pulumi.set(__self__, "username_as_alias", username_as_alias)

    @_builtins.property
    @pulumi.getter
    def accessor(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The accessor for this auth mount.
        """
        return pulumi.get(self, "accessor")

    @accessor.setter
    def accessor(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "accessor", value)

    @_builtins.property
    @pulumi.getter(name="anonymousGroupSearch")
    def anonymous_group_search(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Allows anonymous group searches.
        """
        return pulumi.get(self, "anonymous_group_search")

    @anonymous_group_search.setter
    def anonymous_group_search(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "anonymous_group_search", value)

    @_builtins.property
    @pulumi.getter
    def binddn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        DN of object to bind when performing user search
        """
        return pulumi.get(self, "binddn")

    @binddn.setter
    def binddn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "binddn", value)

    @_builtins.property
    @pulumi.getter
    def bindpass(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Password to use with `binddn` when performing user search
        """
        return pulumi.get(self, "bindpass")

    @bindpass.setter
    def bindpass(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bindpass", value)

    @_builtins.property
    @pulumi.getter(name="caseSensitiveNames")
    def case_sensitive_names(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Control case senstivity of objects fetched from LDAP, this is used for object matching in vault
        """
        return pulumi.get(self, "case_sensitive_names")

    @case_sensitive_names.setter
    def case_sensitive_names(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "case_sensitive_names", value)

    @_builtins.property
    @pulumi.getter
    def certificate(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Trusted CA to validate TLS certificate
        """
        return pulumi.get(self, "certificate")

    @certificate.setter
    def certificate(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "certificate", value)

    @_builtins.property
    @pulumi.getter(name="clientTlsCert")
    def client_tls_cert(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "client_tls_cert")

    @client_tls_cert.setter
    def client_tls_cert(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_tls_cert", value)

    @_builtins.property
    @pulumi.getter(name="clientTlsKey")
    def client_tls_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "client_tls_key")

    @client_tls_key.setter
    def client_tls_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_tls_key", value)

    @_builtins.property
    @pulumi.getter(name="connectionTimeout")
    def connection_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Timeout in seconds when connecting to LDAP before attempting to connect to the next server in the URL provided in `url` (integer: 30)
        """
        return pulumi.get(self, "connection_timeout")

    @connection_timeout.setter
    def connection_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "connection_timeout", value)

    @_builtins.property
    @pulumi.getter(name="denyNullBind")
    def deny_null_bind(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Prevents users from bypassing authentication when providing an empty password.
        """
        return pulumi.get(self, "deny_null_bind")

    @deny_null_bind.setter
    def deny_null_bind(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "deny_null_bind", value)

    @_builtins.property
    @pulumi.getter(name="dereferenceAliases")
    def dereference_aliases(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies how aliases are dereferenced during LDAP searches. Valid values are 'never','searching','finding', and 'always'.
        """
        return pulumi.get(self, "dereference_aliases")

    @dereference_aliases.setter
    def dereference_aliases(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dereference_aliases", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description for the LDAP auth backend mount
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="disableAutomatedRotation")
    def disable_automated_rotation(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Cancels all upcoming rotations of the root credential until unset. Requires Vault Enterprise 1.19+.
        """
        return pulumi.get(self, "disable_automated_rotation")

    @disable_automated_rotation.setter
    def disable_automated_rotation(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disable_automated_rotation", value)

    @_builtins.property
    @pulumi.getter(name="disableRemount")
    def disable_remount(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If set, opts out of mount migration on path updates.
        See here for more info on [Mount Migration](https://www.vaultproject.io/docs/concepts/mount-migration)
        """
        return pulumi.get(self, "disable_remount")

    @disable_remount.setter
    def disable_remount(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disable_remount", value)

    @_builtins.property
    @pulumi.getter
    def discoverdn(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Use anonymous bind to discover the bind DN of a user.
        """
        return pulumi.get(self, "discoverdn")

    @discoverdn.setter
    def discoverdn(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "discoverdn", value)

    @_builtins.property
    @pulumi.getter(name="enableSamaccountnameLogin")
    def enable_samaccountname_login(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enables login using the sAMAccountName attribute.
        """
        return pulumi.get(self, "enable_samaccountname_login")

    @enable_samaccountname_login.setter
    def enable_samaccountname_login(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_samaccountname_login", value)

    @_builtins.property
    @pulumi.getter
    def groupattr(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        LDAP attribute to follow on objects returned by groupfilter
        """
        return pulumi.get(self, "groupattr")

    @groupattr.setter
    def groupattr(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "groupattr", value)

    @_builtins.property
    @pulumi.getter
    def groupdn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Base DN under which to perform group search
        """
        return pulumi.get(self, "groupdn")

    @groupdn.setter
    def groupdn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "groupdn", value)

    @_builtins.property
    @pulumi.getter
    def groupfilter(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Go template used to construct group membership query
        """
        return pulumi.get(self, "groupfilter")

    @groupfilter.setter
    def groupfilter(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "groupfilter", value)

    @_builtins.property
    @pulumi.getter(name="insecureTls")
    def insecure_tls(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Control whether or TLS certificates must be validated
        """
        return pulumi.get(self, "insecure_tls")

    @insecure_tls.setter
    def insecure_tls(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "insecure_tls", value)

    @_builtins.property
    @pulumi.getter
    def local(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies if the auth method is local only.
        """
        return pulumi.get(self, "local")

    @local.setter
    def local(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "local", value)

    @_builtins.property
    @pulumi.getter(name="maxPageSize")
    def max_page_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Sets the max page size for LDAP lookups, by default it's set to -1.
        *Available only for Vault 1.11.11+, 1.12.7+, and 1.13.3+*.
        """
        return pulumi.get(self, "max_page_size")

    @max_page_size.setter
    def max_page_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_page_size", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Path to mount the LDAP auth backend under
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "path", value)

    @_builtins.property
    @pulumi.getter(name="requestTimeout")
    def request_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The timeout(in sec) for requests to the LDAP server.
        """
        return pulumi.get(self, "request_timeout")

    @request_timeout.setter
    def request_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "request_timeout", value)

    @_builtins.property
    @pulumi.getter(name="rotationPeriod")
    def rotation_period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The amount of time in seconds Vault should wait before rotating the root credential.
        A zero value tells Vault not to rotate the root credential. The minimum rotation period is 10 seconds. Requires Vault Enterprise 1.19+.
        """
        return pulumi.get(self, "rotation_period")

    @rotation_period.setter
    def rotation_period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "rotation_period", value)

    @_builtins.property
    @pulumi.getter(name="rotationSchedule")
    def rotation_schedule(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The schedule, in [cron-style time format](https://en.wikipedia.org/wiki/Cron),
        defining the schedule on which Vault should rotate the root token. Requires Vault Enterprise 1.19+.
        """
        return pulumi.get(self, "rotation_schedule")

    @rotation_schedule.setter
    def rotation_schedule(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rotation_schedule", value)

    @_builtins.property
    @pulumi.getter(name="rotationWindow")
    def rotation_window(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum amount of time in seconds allowed to complete
        a rotation when a scheduled token rotation occurs. The default rotation window is
        unbound and the minimum allowable window is `3600`. Requires Vault Enterprise 1.19+.
        """
        return pulumi.get(self, "rotation_window")

    @rotation_window.setter
    def rotation_window(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "rotation_window", value)

    @_builtins.property
    @pulumi.getter
    def starttls(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Control use of TLS when conecting to LDAP
        """
        return pulumi.get(self, "starttls")

    @starttls.setter
    def starttls(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "starttls", value)

    @_builtins.property
    @pulumi.getter(name="tlsMaxVersion")
    def tls_max_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Maximum acceptable version of TLS
        """
        return pulumi.get(self, "tls_max_version")

    @tls_max_version.setter
    def tls_max_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tls_max_version", value)

    @_builtins.property
    @pulumi.getter(name="tlsMinVersion")
    def tls_min_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Minimum acceptable version of TLS
        """
        return pulumi.get(self, "tls_min_version")

    @tls_min_version.setter
    def tls_min_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tls_min_version", value)

    @_builtins.property
    @pulumi.getter(name="tokenBoundCidrs")
    def token_bound_cidrs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies the blocks of IP addresses which are allowed to use the generated token
        """
        return pulumi.get(self, "token_bound_cidrs")

    @token_bound_cidrs.setter
    def token_bound_cidrs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "token_bound_cidrs", value)

    @_builtins.property
    @pulumi.getter(name="tokenExplicitMaxTtl")
    def token_explicit_max_ttl(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Generated Token's Explicit Maximum TTL in seconds
        """
        return pulumi.get(self, "token_explicit_max_ttl")

    @token_explicit_max_ttl.setter
    def token_explicit_max_ttl(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "token_explicit_max_ttl", value)

    @_builtins.property
    @pulumi.getter(name="tokenMaxTtl")
    def token_max_ttl(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum lifetime of the generated token
        """
        return pulumi.get(self, "token_max_ttl")

    @token_max_ttl.setter
    def token_max_ttl(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "token_max_ttl", value)

    @_builtins.property
    @pulumi.getter(name="tokenNoDefaultPolicy")
    def token_no_default_policy(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If true, the 'default' policy will not automatically be added to generated tokens
        """
        return pulumi.get(self, "token_no_default_policy")

    @token_no_default_policy.setter
    def token_no_default_policy(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "token_no_default_policy", value)

    @_builtins.property
    @pulumi.getter(name="tokenNumUses")
    def token_num_uses(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum number of times a token may be used, a value of zero means unlimited
        """
        return pulumi.get(self, "token_num_uses")

    @token_num_uses.setter
    def token_num_uses(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "token_num_uses", value)

    @_builtins.property
    @pulumi.getter(name="tokenPeriod")
    def token_period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Generated Token's Period
        """
        return pulumi.get(self, "token_period")

    @token_period.setter
    def token_period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "token_period", value)

    @_builtins.property
    @pulumi.getter(name="tokenPolicies")
    def token_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Generated Token's Policies
        """
        return pulumi.get(self, "token_policies")

    @token_policies.setter
    def token_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "token_policies", value)

    @_builtins.property
    @pulumi.getter(name="tokenTtl")
    def token_ttl(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The initial ttl of the token to generate in seconds
        """
        return pulumi.get(self, "token_ttl")

    @token_ttl.setter
    def token_ttl(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "token_ttl", value)

    @_builtins.property
    @pulumi.getter(name="tokenType")
    def token_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the type of tokens that should be returned by
        the mount. Valid values are "default-service", "default-batch", "service", "batch".
        """
        return pulumi.get(self, "token_type")

    @token_type.setter
    def token_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "token_type", value)

    @_builtins.property
    @pulumi.getter
    def tune(self) -> Optional[pulumi.Input['AuthBackendTuneArgs']]:
        """
        Extra configuration block. Structure is documented below.

        The `tune` block is used to tune the auth backend:
        """
        return pulumi.get(self, "tune")

    @tune.setter
    def tune(self, value: Optional[pulumi.Input['AuthBackendTuneArgs']]):
        pulumi.set(self, "tune", value)

    @_builtins.property
    @pulumi.getter
    def upndomain(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The `userPrincipalDomain` used to construct the UPN string for the authenticating user.
        """
        return pulumi.get(self, "upndomain")

    @upndomain.setter
    def upndomain(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "upndomain", value)

    @_builtins.property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The URL of the LDAP server
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "url", value)

    @_builtins.property
    @pulumi.getter(name="useTokenGroups")
    def use_token_groups(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Use the Active Directory tokenGroups constructed attribute of the user to find the group memberships
        """
        return pulumi.get(self, "use_token_groups")

    @use_token_groups.setter
    def use_token_groups(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "use_token_groups", value)

    @_builtins.property
    @pulumi.getter
    def userattr(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Attribute on user object matching username passed in
        """
        return pulumi.get(self, "userattr")

    @userattr.setter
    def userattr(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "userattr", value)

    @_builtins.property
    @pulumi.getter
    def userdn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Base DN under which to perform user search
        """
        return pulumi.get(self, "userdn")

    @userdn.setter
    def userdn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "userdn", value)

    @_builtins.property
    @pulumi.getter
    def userfilter(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        LDAP user search filter
        """
        return pulumi.get(self, "userfilter")

    @userfilter.setter
    def userfilter(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "userfilter", value)

    @_builtins.property
    @pulumi.getter(name="usernameAsAlias")
    def username_as_alias(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Force the auth method to use the username passed by the user as the alias name.
        """
        return pulumi.get(self, "username_as_alias")

    @username_as_alias.setter
    def username_as_alias(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "username_as_alias", value)


@pulumi.type_token("vault:ldap/authBackend:AuthBackend")
class AuthBackend(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 anonymous_group_search: Optional[pulumi.Input[_builtins.bool]] = None,
                 binddn: Optional[pulumi.Input[_builtins.str]] = None,
                 bindpass: Optional[pulumi.Input[_builtins.str]] = None,
                 case_sensitive_names: Optional[pulumi.Input[_builtins.bool]] = None,
                 certificate: Optional[pulumi.Input[_builtins.str]] = None,
                 client_tls_cert: Optional[pulumi.Input[_builtins.str]] = None,
                 client_tls_key: Optional[pulumi.Input[_builtins.str]] = None,
                 connection_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 deny_null_bind: Optional[pulumi.Input[_builtins.bool]] = None,
                 dereference_aliases: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disable_automated_rotation: Optional[pulumi.Input[_builtins.bool]] = None,
                 disable_remount: Optional[pulumi.Input[_builtins.bool]] = None,
                 discoverdn: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_samaccountname_login: Optional[pulumi.Input[_builtins.bool]] = None,
                 groupattr: Optional[pulumi.Input[_builtins.str]] = None,
                 groupdn: Optional[pulumi.Input[_builtins.str]] = None,
                 groupfilter: Optional[pulumi.Input[_builtins.str]] = None,
                 insecure_tls: Optional[pulumi.Input[_builtins.bool]] = None,
                 local: Optional[pulumi.Input[_builtins.bool]] = None,
                 max_page_size: Optional[pulumi.Input[_builtins.int]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 path: Optional[pulumi.Input[_builtins.str]] = None,
                 request_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 rotation_period: Optional[pulumi.Input[_builtins.int]] = None,
                 rotation_schedule: Optional[pulumi.Input[_builtins.str]] = None,
                 rotation_window: Optional[pulumi.Input[_builtins.int]] = None,
                 starttls: Optional[pulumi.Input[_builtins.bool]] = None,
                 tls_max_version: Optional[pulumi.Input[_builtins.str]] = None,
                 tls_min_version: Optional[pulumi.Input[_builtins.str]] = None,
                 token_bound_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 token_explicit_max_ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 token_max_ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 token_no_default_policy: Optional[pulumi.Input[_builtins.bool]] = None,
                 token_num_uses: Optional[pulumi.Input[_builtins.int]] = None,
                 token_period: Optional[pulumi.Input[_builtins.int]] = None,
                 token_policies: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 token_ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 token_type: Optional[pulumi.Input[_builtins.str]] = None,
                 tune: Optional[pulumi.Input[Union['AuthBackendTuneArgs', 'AuthBackendTuneArgsDict']]] = None,
                 upndomain: Optional[pulumi.Input[_builtins.str]] = None,
                 url: Optional[pulumi.Input[_builtins.str]] = None,
                 use_token_groups: Optional[pulumi.Input[_builtins.bool]] = None,
                 userattr: Optional[pulumi.Input[_builtins.str]] = None,
                 userdn: Optional[pulumi.Input[_builtins.str]] = None,
                 userfilter: Optional[pulumi.Input[_builtins.str]] = None,
                 username_as_alias: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        Provides a resource for managing an [LDAP auth backend within Vault](https://www.vaultproject.io/docs/auth/ldap.html).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_vault as vault

        ldap = vault.ldap.AuthBackend("ldap",
            path="ldap",
            url="ldaps://dc-01.example.org",
            userdn="OU=Users,OU=Accounts,DC=example,DC=org",
            userattr="sAMAccountName",
            upndomain="EXAMPLE.ORG",
            discoverdn=False,
            groupdn="OU=Groups,DC=example,DC=org",
            groupfilter="(&(objectClass=group)(member:1.2.840.113556.1.4.1941:={{.UserDN}}))",
            rotation_schedule="0 * * * SAT",
            rotation_window=3600,
            request_timeout=30,
            dereference_aliases="always",
            enable_samaccountname_login=False,
            anonymous_group_search=False)
        ```

        ## Import

        LDAP authentication backends can be imported using the `path`, e.g.

        ```sh
        $ pulumi import vault:ldap/authBackend:AuthBackend ldap ldap
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] anonymous_group_search: Allows anonymous group searches.
        :param pulumi.Input[_builtins.str] binddn: DN of object to bind when performing user search
        :param pulumi.Input[_builtins.str] bindpass: Password to use with `binddn` when performing user search
        :param pulumi.Input[_builtins.bool] case_sensitive_names: Control case senstivity of objects fetched from LDAP, this is used for object matching in vault
        :param pulumi.Input[_builtins.str] certificate: Trusted CA to validate TLS certificate
        :param pulumi.Input[_builtins.int] connection_timeout: Timeout in seconds when connecting to LDAP before attempting to connect to the next server in the URL provided in `url` (integer: 30)
        :param pulumi.Input[_builtins.bool] deny_null_bind: Prevents users from bypassing authentication when providing an empty password.
        :param pulumi.Input[_builtins.str] dereference_aliases: Specifies how aliases are dereferenced during LDAP searches. Valid values are 'never','searching','finding', and 'always'.
        :param pulumi.Input[_builtins.str] description: Description for the LDAP auth backend mount
        :param pulumi.Input[_builtins.bool] disable_automated_rotation: Cancels all upcoming rotations of the root credential until unset. Requires Vault Enterprise 1.19+.
        :param pulumi.Input[_builtins.bool] disable_remount: If set, opts out of mount migration on path updates.
               See here for more info on [Mount Migration](https://www.vaultproject.io/docs/concepts/mount-migration)
        :param pulumi.Input[_builtins.bool] discoverdn: Use anonymous bind to discover the bind DN of a user.
        :param pulumi.Input[_builtins.bool] enable_samaccountname_login: Enables login using the sAMAccountName attribute.
        :param pulumi.Input[_builtins.str] groupattr: LDAP attribute to follow on objects returned by groupfilter
        :param pulumi.Input[_builtins.str] groupdn: Base DN under which to perform group search
        :param pulumi.Input[_builtins.str] groupfilter: Go template used to construct group membership query
        :param pulumi.Input[_builtins.bool] insecure_tls: Control whether or TLS certificates must be validated
        :param pulumi.Input[_builtins.bool] local: Specifies if the auth method is local only.
        :param pulumi.Input[_builtins.int] max_page_size: Sets the max page size for LDAP lookups, by default it's set to -1.
               *Available only for Vault 1.11.11+, 1.12.7+, and 1.13.3+*.
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.str] path: Path to mount the LDAP auth backend under
        :param pulumi.Input[_builtins.int] request_timeout: The timeout(in sec) for requests to the LDAP server.
        :param pulumi.Input[_builtins.int] rotation_period: The amount of time in seconds Vault should wait before rotating the root credential.
               A zero value tells Vault not to rotate the root credential. The minimum rotation period is 10 seconds. Requires Vault Enterprise 1.19+.
        :param pulumi.Input[_builtins.str] rotation_schedule: The schedule, in [cron-style time format](https://en.wikipedia.org/wiki/Cron),
               defining the schedule on which Vault should rotate the root token. Requires Vault Enterprise 1.19+.
        :param pulumi.Input[_builtins.int] rotation_window: The maximum amount of time in seconds allowed to complete
               a rotation when a scheduled token rotation occurs. The default rotation window is
               unbound and the minimum allowable window is `3600`. Requires Vault Enterprise 1.19+.
        :param pulumi.Input[_builtins.bool] starttls: Control use of TLS when conecting to LDAP
        :param pulumi.Input[_builtins.str] tls_max_version: Maximum acceptable version of TLS
        :param pulumi.Input[_builtins.str] tls_min_version: Minimum acceptable version of TLS
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] token_bound_cidrs: Specifies the blocks of IP addresses which are allowed to use the generated token
        :param pulumi.Input[_builtins.int] token_explicit_max_ttl: Generated Token's Explicit Maximum TTL in seconds
        :param pulumi.Input[_builtins.int] token_max_ttl: The maximum lifetime of the generated token
        :param pulumi.Input[_builtins.bool] token_no_default_policy: If true, the 'default' policy will not automatically be added to generated tokens
        :param pulumi.Input[_builtins.int] token_num_uses: The maximum number of times a token may be used, a value of zero means unlimited
        :param pulumi.Input[_builtins.int] token_period: Generated Token's Period
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] token_policies: Generated Token's Policies
        :param pulumi.Input[_builtins.int] token_ttl: The initial ttl of the token to generate in seconds
        :param pulumi.Input[_builtins.str] token_type: Specifies the type of tokens that should be returned by
               the mount. Valid values are "default-service", "default-batch", "service", "batch".
        :param pulumi.Input[Union['AuthBackendTuneArgs', 'AuthBackendTuneArgsDict']] tune: Extra configuration block. Structure is documented below.
               
               The `tune` block is used to tune the auth backend:
        :param pulumi.Input[_builtins.str] upndomain: The `userPrincipalDomain` used to construct the UPN string for the authenticating user.
        :param pulumi.Input[_builtins.str] url: The URL of the LDAP server
        :param pulumi.Input[_builtins.bool] use_token_groups: Use the Active Directory tokenGroups constructed attribute of the user to find the group memberships
        :param pulumi.Input[_builtins.str] userattr: Attribute on user object matching username passed in
        :param pulumi.Input[_builtins.str] userdn: Base DN under which to perform user search
        :param pulumi.Input[_builtins.str] userfilter: LDAP user search filter
        :param pulumi.Input[_builtins.bool] username_as_alias: Force the auth method to use the username passed by the user as the alias name.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AuthBackendArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource for managing an [LDAP auth backend within Vault](https://www.vaultproject.io/docs/auth/ldap.html).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_vault as vault

        ldap = vault.ldap.AuthBackend("ldap",
            path="ldap",
            url="ldaps://dc-01.example.org",
            userdn="OU=Users,OU=Accounts,DC=example,DC=org",
            userattr="sAMAccountName",
            upndomain="EXAMPLE.ORG",
            discoverdn=False,
            groupdn="OU=Groups,DC=example,DC=org",
            groupfilter="(&(objectClass=group)(member:1.2.840.113556.1.4.1941:={{.UserDN}}))",
            rotation_schedule="0 * * * SAT",
            rotation_window=3600,
            request_timeout=30,
            dereference_aliases="always",
            enable_samaccountname_login=False,
            anonymous_group_search=False)
        ```

        ## Import

        LDAP authentication backends can be imported using the `path`, e.g.

        ```sh
        $ pulumi import vault:ldap/authBackend:AuthBackend ldap ldap
        ```

        :param str resource_name: The name of the resource.
        :param AuthBackendArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AuthBackendArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 anonymous_group_search: Optional[pulumi.Input[_builtins.bool]] = None,
                 binddn: Optional[pulumi.Input[_builtins.str]] = None,
                 bindpass: Optional[pulumi.Input[_builtins.str]] = None,
                 case_sensitive_names: Optional[pulumi.Input[_builtins.bool]] = None,
                 certificate: Optional[pulumi.Input[_builtins.str]] = None,
                 client_tls_cert: Optional[pulumi.Input[_builtins.str]] = None,
                 client_tls_key: Optional[pulumi.Input[_builtins.str]] = None,
                 connection_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 deny_null_bind: Optional[pulumi.Input[_builtins.bool]] = None,
                 dereference_aliases: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disable_automated_rotation: Optional[pulumi.Input[_builtins.bool]] = None,
                 disable_remount: Optional[pulumi.Input[_builtins.bool]] = None,
                 discoverdn: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_samaccountname_login: Optional[pulumi.Input[_builtins.bool]] = None,
                 groupattr: Optional[pulumi.Input[_builtins.str]] = None,
                 groupdn: Optional[pulumi.Input[_builtins.str]] = None,
                 groupfilter: Optional[pulumi.Input[_builtins.str]] = None,
                 insecure_tls: Optional[pulumi.Input[_builtins.bool]] = None,
                 local: Optional[pulumi.Input[_builtins.bool]] = None,
                 max_page_size: Optional[pulumi.Input[_builtins.int]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 path: Optional[pulumi.Input[_builtins.str]] = None,
                 request_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 rotation_period: Optional[pulumi.Input[_builtins.int]] = None,
                 rotation_schedule: Optional[pulumi.Input[_builtins.str]] = None,
                 rotation_window: Optional[pulumi.Input[_builtins.int]] = None,
                 starttls: Optional[pulumi.Input[_builtins.bool]] = None,
                 tls_max_version: Optional[pulumi.Input[_builtins.str]] = None,
                 tls_min_version: Optional[pulumi.Input[_builtins.str]] = None,
                 token_bound_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 token_explicit_max_ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 token_max_ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 token_no_default_policy: Optional[pulumi.Input[_builtins.bool]] = None,
                 token_num_uses: Optional[pulumi.Input[_builtins.int]] = None,
                 token_period: Optional[pulumi.Input[_builtins.int]] = None,
                 token_policies: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 token_ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 token_type: Optional[pulumi.Input[_builtins.str]] = None,
                 tune: Optional[pulumi.Input[Union['AuthBackendTuneArgs', 'AuthBackendTuneArgsDict']]] = None,
                 upndomain: Optional[pulumi.Input[_builtins.str]] = None,
                 url: Optional[pulumi.Input[_builtins.str]] = None,
                 use_token_groups: Optional[pulumi.Input[_builtins.bool]] = None,
                 userattr: Optional[pulumi.Input[_builtins.str]] = None,
                 userdn: Optional[pulumi.Input[_builtins.str]] = None,
                 userfilter: Optional[pulumi.Input[_builtins.str]] = None,
                 username_as_alias: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AuthBackendArgs.__new__(AuthBackendArgs)

            __props__.__dict__["anonymous_group_search"] = anonymous_group_search
            __props__.__dict__["binddn"] = binddn
            __props__.__dict__["bindpass"] = None if bindpass is None else pulumi.Output.secret(bindpass)
            __props__.__dict__["case_sensitive_names"] = case_sensitive_names
            __props__.__dict__["certificate"] = certificate
            __props__.__dict__["client_tls_cert"] = client_tls_cert
            __props__.__dict__["client_tls_key"] = None if client_tls_key is None else pulumi.Output.secret(client_tls_key)
            __props__.__dict__["connection_timeout"] = connection_timeout
            __props__.__dict__["deny_null_bind"] = deny_null_bind
            __props__.__dict__["dereference_aliases"] = dereference_aliases
            __props__.__dict__["description"] = description
            __props__.__dict__["disable_automated_rotation"] = disable_automated_rotation
            __props__.__dict__["disable_remount"] = disable_remount
            __props__.__dict__["discoverdn"] = discoverdn
            __props__.__dict__["enable_samaccountname_login"] = enable_samaccountname_login
            __props__.__dict__["groupattr"] = groupattr
            __props__.__dict__["groupdn"] = groupdn
            __props__.__dict__["groupfilter"] = groupfilter
            __props__.__dict__["insecure_tls"] = insecure_tls
            __props__.__dict__["local"] = local
            __props__.__dict__["max_page_size"] = max_page_size
            __props__.__dict__["namespace"] = namespace
            __props__.__dict__["path"] = path
            __props__.__dict__["request_timeout"] = request_timeout
            __props__.__dict__["rotation_period"] = rotation_period
            __props__.__dict__["rotation_schedule"] = rotation_schedule
            __props__.__dict__["rotation_window"] = rotation_window
            __props__.__dict__["starttls"] = starttls
            __props__.__dict__["tls_max_version"] = tls_max_version
            __props__.__dict__["tls_min_version"] = tls_min_version
            __props__.__dict__["token_bound_cidrs"] = token_bound_cidrs
            __props__.__dict__["token_explicit_max_ttl"] = token_explicit_max_ttl
            __props__.__dict__["token_max_ttl"] = token_max_ttl
            __props__.__dict__["token_no_default_policy"] = token_no_default_policy
            __props__.__dict__["token_num_uses"] = token_num_uses
            __props__.__dict__["token_period"] = token_period
            __props__.__dict__["token_policies"] = token_policies
            __props__.__dict__["token_ttl"] = token_ttl
            __props__.__dict__["token_type"] = token_type
            __props__.__dict__["tune"] = tune
            __props__.__dict__["upndomain"] = upndomain
            if url is None and not opts.urn:
                raise TypeError("Missing required property 'url'")
            __props__.__dict__["url"] = url
            __props__.__dict__["use_token_groups"] = use_token_groups
            __props__.__dict__["userattr"] = userattr
            __props__.__dict__["userdn"] = userdn
            __props__.__dict__["userfilter"] = userfilter
            __props__.__dict__["username_as_alias"] = username_as_alias
            __props__.__dict__["accessor"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["bindpass", "clientTlsKey"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(AuthBackend, __self__).__init__(
            'vault:ldap/authBackend:AuthBackend',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            accessor: Optional[pulumi.Input[_builtins.str]] = None,
            anonymous_group_search: Optional[pulumi.Input[_builtins.bool]] = None,
            binddn: Optional[pulumi.Input[_builtins.str]] = None,
            bindpass: Optional[pulumi.Input[_builtins.str]] = None,
            case_sensitive_names: Optional[pulumi.Input[_builtins.bool]] = None,
            certificate: Optional[pulumi.Input[_builtins.str]] = None,
            client_tls_cert: Optional[pulumi.Input[_builtins.str]] = None,
            client_tls_key: Optional[pulumi.Input[_builtins.str]] = None,
            connection_timeout: Optional[pulumi.Input[_builtins.int]] = None,
            deny_null_bind: Optional[pulumi.Input[_builtins.bool]] = None,
            dereference_aliases: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            disable_automated_rotation: Optional[pulumi.Input[_builtins.bool]] = None,
            disable_remount: Optional[pulumi.Input[_builtins.bool]] = None,
            discoverdn: Optional[pulumi.Input[_builtins.bool]] = None,
            enable_samaccountname_login: Optional[pulumi.Input[_builtins.bool]] = None,
            groupattr: Optional[pulumi.Input[_builtins.str]] = None,
            groupdn: Optional[pulumi.Input[_builtins.str]] = None,
            groupfilter: Optional[pulumi.Input[_builtins.str]] = None,
            insecure_tls: Optional[pulumi.Input[_builtins.bool]] = None,
            local: Optional[pulumi.Input[_builtins.bool]] = None,
            max_page_size: Optional[pulumi.Input[_builtins.int]] = None,
            namespace: Optional[pulumi.Input[_builtins.str]] = None,
            path: Optional[pulumi.Input[_builtins.str]] = None,
            request_timeout: Optional[pulumi.Input[_builtins.int]] = None,
            rotation_period: Optional[pulumi.Input[_builtins.int]] = None,
            rotation_schedule: Optional[pulumi.Input[_builtins.str]] = None,
            rotation_window: Optional[pulumi.Input[_builtins.int]] = None,
            starttls: Optional[pulumi.Input[_builtins.bool]] = None,
            tls_max_version: Optional[pulumi.Input[_builtins.str]] = None,
            tls_min_version: Optional[pulumi.Input[_builtins.str]] = None,
            token_bound_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            token_explicit_max_ttl: Optional[pulumi.Input[_builtins.int]] = None,
            token_max_ttl: Optional[pulumi.Input[_builtins.int]] = None,
            token_no_default_policy: Optional[pulumi.Input[_builtins.bool]] = None,
            token_num_uses: Optional[pulumi.Input[_builtins.int]] = None,
            token_period: Optional[pulumi.Input[_builtins.int]] = None,
            token_policies: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            token_ttl: Optional[pulumi.Input[_builtins.int]] = None,
            token_type: Optional[pulumi.Input[_builtins.str]] = None,
            tune: Optional[pulumi.Input[Union['AuthBackendTuneArgs', 'AuthBackendTuneArgsDict']]] = None,
            upndomain: Optional[pulumi.Input[_builtins.str]] = None,
            url: Optional[pulumi.Input[_builtins.str]] = None,
            use_token_groups: Optional[pulumi.Input[_builtins.bool]] = None,
            userattr: Optional[pulumi.Input[_builtins.str]] = None,
            userdn: Optional[pulumi.Input[_builtins.str]] = None,
            userfilter: Optional[pulumi.Input[_builtins.str]] = None,
            username_as_alias: Optional[pulumi.Input[_builtins.bool]] = None) -> 'AuthBackend':
        """
        Get an existing AuthBackend resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] accessor: The accessor for this auth mount.
        :param pulumi.Input[_builtins.bool] anonymous_group_search: Allows anonymous group searches.
        :param pulumi.Input[_builtins.str] binddn: DN of object to bind when performing user search
        :param pulumi.Input[_builtins.str] bindpass: Password to use with `binddn` when performing user search
        :param pulumi.Input[_builtins.bool] case_sensitive_names: Control case senstivity of objects fetched from LDAP, this is used for object matching in vault
        :param pulumi.Input[_builtins.str] certificate: Trusted CA to validate TLS certificate
        :param pulumi.Input[_builtins.int] connection_timeout: Timeout in seconds when connecting to LDAP before attempting to connect to the next server in the URL provided in `url` (integer: 30)
        :param pulumi.Input[_builtins.bool] deny_null_bind: Prevents users from bypassing authentication when providing an empty password.
        :param pulumi.Input[_builtins.str] dereference_aliases: Specifies how aliases are dereferenced during LDAP searches. Valid values are 'never','searching','finding', and 'always'.
        :param pulumi.Input[_builtins.str] description: Description for the LDAP auth backend mount
        :param pulumi.Input[_builtins.bool] disable_automated_rotation: Cancels all upcoming rotations of the root credential until unset. Requires Vault Enterprise 1.19+.
        :param pulumi.Input[_builtins.bool] disable_remount: If set, opts out of mount migration on path updates.
               See here for more info on [Mount Migration](https://www.vaultproject.io/docs/concepts/mount-migration)
        :param pulumi.Input[_builtins.bool] discoverdn: Use anonymous bind to discover the bind DN of a user.
        :param pulumi.Input[_builtins.bool] enable_samaccountname_login: Enables login using the sAMAccountName attribute.
        :param pulumi.Input[_builtins.str] groupattr: LDAP attribute to follow on objects returned by groupfilter
        :param pulumi.Input[_builtins.str] groupdn: Base DN under which to perform group search
        :param pulumi.Input[_builtins.str] groupfilter: Go template used to construct group membership query
        :param pulumi.Input[_builtins.bool] insecure_tls: Control whether or TLS certificates must be validated
        :param pulumi.Input[_builtins.bool] local: Specifies if the auth method is local only.
        :param pulumi.Input[_builtins.int] max_page_size: Sets the max page size for LDAP lookups, by default it's set to -1.
               *Available only for Vault 1.11.11+, 1.12.7+, and 1.13.3+*.
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.str] path: Path to mount the LDAP auth backend under
        :param pulumi.Input[_builtins.int] request_timeout: The timeout(in sec) for requests to the LDAP server.
        :param pulumi.Input[_builtins.int] rotation_period: The amount of time in seconds Vault should wait before rotating the root credential.
               A zero value tells Vault not to rotate the root credential. The minimum rotation period is 10 seconds. Requires Vault Enterprise 1.19+.
        :param pulumi.Input[_builtins.str] rotation_schedule: The schedule, in [cron-style time format](https://en.wikipedia.org/wiki/Cron),
               defining the schedule on which Vault should rotate the root token. Requires Vault Enterprise 1.19+.
        :param pulumi.Input[_builtins.int] rotation_window: The maximum amount of time in seconds allowed to complete
               a rotation when a scheduled token rotation occurs. The default rotation window is
               unbound and the minimum allowable window is `3600`. Requires Vault Enterprise 1.19+.
        :param pulumi.Input[_builtins.bool] starttls: Control use of TLS when conecting to LDAP
        :param pulumi.Input[_builtins.str] tls_max_version: Maximum acceptable version of TLS
        :param pulumi.Input[_builtins.str] tls_min_version: Minimum acceptable version of TLS
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] token_bound_cidrs: Specifies the blocks of IP addresses which are allowed to use the generated token
        :param pulumi.Input[_builtins.int] token_explicit_max_ttl: Generated Token's Explicit Maximum TTL in seconds
        :param pulumi.Input[_builtins.int] token_max_ttl: The maximum lifetime of the generated token
        :param pulumi.Input[_builtins.bool] token_no_default_policy: If true, the 'default' policy will not automatically be added to generated tokens
        :param pulumi.Input[_builtins.int] token_num_uses: The maximum number of times a token may be used, a value of zero means unlimited
        :param pulumi.Input[_builtins.int] token_period: Generated Token's Period
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] token_policies: Generated Token's Policies
        :param pulumi.Input[_builtins.int] token_ttl: The initial ttl of the token to generate in seconds
        :param pulumi.Input[_builtins.str] token_type: Specifies the type of tokens that should be returned by
               the mount. Valid values are "default-service", "default-batch", "service", "batch".
        :param pulumi.Input[Union['AuthBackendTuneArgs', 'AuthBackendTuneArgsDict']] tune: Extra configuration block. Structure is documented below.
               
               The `tune` block is used to tune the auth backend:
        :param pulumi.Input[_builtins.str] upndomain: The `userPrincipalDomain` used to construct the UPN string for the authenticating user.
        :param pulumi.Input[_builtins.str] url: The URL of the LDAP server
        :param pulumi.Input[_builtins.bool] use_token_groups: Use the Active Directory tokenGroups constructed attribute of the user to find the group memberships
        :param pulumi.Input[_builtins.str] userattr: Attribute on user object matching username passed in
        :param pulumi.Input[_builtins.str] userdn: Base DN under which to perform user search
        :param pulumi.Input[_builtins.str] userfilter: LDAP user search filter
        :param pulumi.Input[_builtins.bool] username_as_alias: Force the auth method to use the username passed by the user as the alias name.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AuthBackendState.__new__(_AuthBackendState)

        __props__.__dict__["accessor"] = accessor
        __props__.__dict__["anonymous_group_search"] = anonymous_group_search
        __props__.__dict__["binddn"] = binddn
        __props__.__dict__["bindpass"] = bindpass
        __props__.__dict__["case_sensitive_names"] = case_sensitive_names
        __props__.__dict__["certificate"] = certificate
        __props__.__dict__["client_tls_cert"] = client_tls_cert
        __props__.__dict__["client_tls_key"] = client_tls_key
        __props__.__dict__["connection_timeout"] = connection_timeout
        __props__.__dict__["deny_null_bind"] = deny_null_bind
        __props__.__dict__["dereference_aliases"] = dereference_aliases
        __props__.__dict__["description"] = description
        __props__.__dict__["disable_automated_rotation"] = disable_automated_rotation
        __props__.__dict__["disable_remount"] = disable_remount
        __props__.__dict__["discoverdn"] = discoverdn
        __props__.__dict__["enable_samaccountname_login"] = enable_samaccountname_login
        __props__.__dict__["groupattr"] = groupattr
        __props__.__dict__["groupdn"] = groupdn
        __props__.__dict__["groupfilter"] = groupfilter
        __props__.__dict__["insecure_tls"] = insecure_tls
        __props__.__dict__["local"] = local
        __props__.__dict__["max_page_size"] = max_page_size
        __props__.__dict__["namespace"] = namespace
        __props__.__dict__["path"] = path
        __props__.__dict__["request_timeout"] = request_timeout
        __props__.__dict__["rotation_period"] = rotation_period
        __props__.__dict__["rotation_schedule"] = rotation_schedule
        __props__.__dict__["rotation_window"] = rotation_window
        __props__.__dict__["starttls"] = starttls
        __props__.__dict__["tls_max_version"] = tls_max_version
        __props__.__dict__["tls_min_version"] = tls_min_version
        __props__.__dict__["token_bound_cidrs"] = token_bound_cidrs
        __props__.__dict__["token_explicit_max_ttl"] = token_explicit_max_ttl
        __props__.__dict__["token_max_ttl"] = token_max_ttl
        __props__.__dict__["token_no_default_policy"] = token_no_default_policy
        __props__.__dict__["token_num_uses"] = token_num_uses
        __props__.__dict__["token_period"] = token_period
        __props__.__dict__["token_policies"] = token_policies
        __props__.__dict__["token_ttl"] = token_ttl
        __props__.__dict__["token_type"] = token_type
        __props__.__dict__["tune"] = tune
        __props__.__dict__["upndomain"] = upndomain
        __props__.__dict__["url"] = url
        __props__.__dict__["use_token_groups"] = use_token_groups
        __props__.__dict__["userattr"] = userattr
        __props__.__dict__["userdn"] = userdn
        __props__.__dict__["userfilter"] = userfilter
        __props__.__dict__["username_as_alias"] = username_as_alias
        return AuthBackend(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def accessor(self) -> pulumi.Output[_builtins.str]:
        """
        The accessor for this auth mount.
        """
        return pulumi.get(self, "accessor")

    @_builtins.property
    @pulumi.getter(name="anonymousGroupSearch")
    def anonymous_group_search(self) -> pulumi.Output[_builtins.bool]:
        """
        Allows anonymous group searches.
        """
        return pulumi.get(self, "anonymous_group_search")

    @_builtins.property
    @pulumi.getter
    def binddn(self) -> pulumi.Output[_builtins.str]:
        """
        DN of object to bind when performing user search
        """
        return pulumi.get(self, "binddn")

    @_builtins.property
    @pulumi.getter
    def bindpass(self) -> pulumi.Output[_builtins.str]:
        """
        Password to use with `binddn` when performing user search
        """
        return pulumi.get(self, "bindpass")

    @_builtins.property
    @pulumi.getter(name="caseSensitiveNames")
    def case_sensitive_names(self) -> pulumi.Output[_builtins.bool]:
        """
        Control case senstivity of objects fetched from LDAP, this is used for object matching in vault
        """
        return pulumi.get(self, "case_sensitive_names")

    @_builtins.property
    @pulumi.getter
    def certificate(self) -> pulumi.Output[_builtins.str]:
        """
        Trusted CA to validate TLS certificate
        """
        return pulumi.get(self, "certificate")

    @_builtins.property
    @pulumi.getter(name="clientTlsCert")
    def client_tls_cert(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "client_tls_cert")

    @_builtins.property
    @pulumi.getter(name="clientTlsKey")
    def client_tls_key(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "client_tls_key")

    @_builtins.property
    @pulumi.getter(name="connectionTimeout")
    def connection_timeout(self) -> pulumi.Output[_builtins.int]:
        """
        Timeout in seconds when connecting to LDAP before attempting to connect to the next server in the URL provided in `url` (integer: 30)
        """
        return pulumi.get(self, "connection_timeout")

    @_builtins.property
    @pulumi.getter(name="denyNullBind")
    def deny_null_bind(self) -> pulumi.Output[_builtins.bool]:
        """
        Prevents users from bypassing authentication when providing an empty password.
        """
        return pulumi.get(self, "deny_null_bind")

    @_builtins.property
    @pulumi.getter(name="dereferenceAliases")
    def dereference_aliases(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies how aliases are dereferenced during LDAP searches. Valid values are 'never','searching','finding', and 'always'.
        """
        return pulumi.get(self, "dereference_aliases")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        Description for the LDAP auth backend mount
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="disableAutomatedRotation")
    def disable_automated_rotation(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Cancels all upcoming rotations of the root credential until unset. Requires Vault Enterprise 1.19+.
        """
        return pulumi.get(self, "disable_automated_rotation")

    @_builtins.property
    @pulumi.getter(name="disableRemount")
    def disable_remount(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        If set, opts out of mount migration on path updates.
        See here for more info on [Mount Migration](https://www.vaultproject.io/docs/concepts/mount-migration)
        """
        return pulumi.get(self, "disable_remount")

    @_builtins.property
    @pulumi.getter
    def discoverdn(self) -> pulumi.Output[_builtins.bool]:
        """
        Use anonymous bind to discover the bind DN of a user.
        """
        return pulumi.get(self, "discoverdn")

    @_builtins.property
    @pulumi.getter(name="enableSamaccountnameLogin")
    def enable_samaccountname_login(self) -> pulumi.Output[_builtins.bool]:
        """
        Enables login using the sAMAccountName attribute.
        """
        return pulumi.get(self, "enable_samaccountname_login")

    @_builtins.property
    @pulumi.getter
    def groupattr(self) -> pulumi.Output[_builtins.str]:
        """
        LDAP attribute to follow on objects returned by groupfilter
        """
        return pulumi.get(self, "groupattr")

    @_builtins.property
    @pulumi.getter
    def groupdn(self) -> pulumi.Output[_builtins.str]:
        """
        Base DN under which to perform group search
        """
        return pulumi.get(self, "groupdn")

    @_builtins.property
    @pulumi.getter
    def groupfilter(self) -> pulumi.Output[_builtins.str]:
        """
        Go template used to construct group membership query
        """
        return pulumi.get(self, "groupfilter")

    @_builtins.property
    @pulumi.getter(name="insecureTls")
    def insecure_tls(self) -> pulumi.Output[_builtins.bool]:
        """
        Control whether or TLS certificates must be validated
        """
        return pulumi.get(self, "insecure_tls")

    @_builtins.property
    @pulumi.getter
    def local(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies if the auth method is local only.
        """
        return pulumi.get(self, "local")

    @_builtins.property
    @pulumi.getter(name="maxPageSize")
    def max_page_size(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Sets the max page size for LDAP lookups, by default it's set to -1.
        *Available only for Vault 1.11.11+, 1.12.7+, and 1.13.3+*.
        """
        return pulumi.get(self, "max_page_size")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter
    def path(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Path to mount the LDAP auth backend under
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter(name="requestTimeout")
    def request_timeout(self) -> pulumi.Output[_builtins.int]:
        """
        The timeout(in sec) for requests to the LDAP server.
        """
        return pulumi.get(self, "request_timeout")

    @_builtins.property
    @pulumi.getter(name="rotationPeriod")
    def rotation_period(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The amount of time in seconds Vault should wait before rotating the root credential.
        A zero value tells Vault not to rotate the root credential. The minimum rotation period is 10 seconds. Requires Vault Enterprise 1.19+.
        """
        return pulumi.get(self, "rotation_period")

    @_builtins.property
    @pulumi.getter(name="rotationSchedule")
    def rotation_schedule(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The schedule, in [cron-style time format](https://en.wikipedia.org/wiki/Cron),
        defining the schedule on which Vault should rotate the root token. Requires Vault Enterprise 1.19+.
        """
        return pulumi.get(self, "rotation_schedule")

    @_builtins.property
    @pulumi.getter(name="rotationWindow")
    def rotation_window(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The maximum amount of time in seconds allowed to complete
        a rotation when a scheduled token rotation occurs. The default rotation window is
        unbound and the minimum allowable window is `3600`. Requires Vault Enterprise 1.19+.
        """
        return pulumi.get(self, "rotation_window")

    @_builtins.property
    @pulumi.getter
    def starttls(self) -> pulumi.Output[_builtins.bool]:
        """
        Control use of TLS when conecting to LDAP
        """
        return pulumi.get(self, "starttls")

    @_builtins.property
    @pulumi.getter(name="tlsMaxVersion")
    def tls_max_version(self) -> pulumi.Output[_builtins.str]:
        """
        Maximum acceptable version of TLS
        """
        return pulumi.get(self, "tls_max_version")

    @_builtins.property
    @pulumi.getter(name="tlsMinVersion")
    def tls_min_version(self) -> pulumi.Output[_builtins.str]:
        """
        Minimum acceptable version of TLS
        """
        return pulumi.get(self, "tls_min_version")

    @_builtins.property
    @pulumi.getter(name="tokenBoundCidrs")
    def token_bound_cidrs(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Specifies the blocks of IP addresses which are allowed to use the generated token
        """
        return pulumi.get(self, "token_bound_cidrs")

    @_builtins.property
    @pulumi.getter(name="tokenExplicitMaxTtl")
    def token_explicit_max_ttl(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Generated Token's Explicit Maximum TTL in seconds
        """
        return pulumi.get(self, "token_explicit_max_ttl")

    @_builtins.property
    @pulumi.getter(name="tokenMaxTtl")
    def token_max_ttl(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The maximum lifetime of the generated token
        """
        return pulumi.get(self, "token_max_ttl")

    @_builtins.property
    @pulumi.getter(name="tokenNoDefaultPolicy")
    def token_no_default_policy(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        If true, the 'default' policy will not automatically be added to generated tokens
        """
        return pulumi.get(self, "token_no_default_policy")

    @_builtins.property
    @pulumi.getter(name="tokenNumUses")
    def token_num_uses(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The maximum number of times a token may be used, a value of zero means unlimited
        """
        return pulumi.get(self, "token_num_uses")

    @_builtins.property
    @pulumi.getter(name="tokenPeriod")
    def token_period(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Generated Token's Period
        """
        return pulumi.get(self, "token_period")

    @_builtins.property
    @pulumi.getter(name="tokenPolicies")
    def token_policies(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Generated Token's Policies
        """
        return pulumi.get(self, "token_policies")

    @_builtins.property
    @pulumi.getter(name="tokenTtl")
    def token_ttl(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The initial ttl of the token to generate in seconds
        """
        return pulumi.get(self, "token_ttl")

    @_builtins.property
    @pulumi.getter(name="tokenType")
    def token_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the type of tokens that should be returned by
        the mount. Valid values are "default-service", "default-batch", "service", "batch".
        """
        return pulumi.get(self, "token_type")

    @_builtins.property
    @pulumi.getter
    def tune(self) -> pulumi.Output['outputs.AuthBackendTune']:
        """
        Extra configuration block. Structure is documented below.

        The `tune` block is used to tune the auth backend:
        """
        return pulumi.get(self, "tune")

    @_builtins.property
    @pulumi.getter
    def upndomain(self) -> pulumi.Output[_builtins.str]:
        """
        The `userPrincipalDomain` used to construct the UPN string for the authenticating user.
        """
        return pulumi.get(self, "upndomain")

    @_builtins.property
    @pulumi.getter
    def url(self) -> pulumi.Output[_builtins.str]:
        """
        The URL of the LDAP server
        """
        return pulumi.get(self, "url")

    @_builtins.property
    @pulumi.getter(name="useTokenGroups")
    def use_token_groups(self) -> pulumi.Output[_builtins.bool]:
        """
        Use the Active Directory tokenGroups constructed attribute of the user to find the group memberships
        """
        return pulumi.get(self, "use_token_groups")

    @_builtins.property
    @pulumi.getter
    def userattr(self) -> pulumi.Output[_builtins.str]:
        """
        Attribute on user object matching username passed in
        """
        return pulumi.get(self, "userattr")

    @_builtins.property
    @pulumi.getter
    def userdn(self) -> pulumi.Output[_builtins.str]:
        """
        Base DN under which to perform user search
        """
        return pulumi.get(self, "userdn")

    @_builtins.property
    @pulumi.getter
    def userfilter(self) -> pulumi.Output[_builtins.str]:
        """
        LDAP user search filter
        """
        return pulumi.get(self, "userfilter")

    @_builtins.property
    @pulumi.getter(name="usernameAsAlias")
    def username_as_alias(self) -> pulumi.Output[_builtins.bool]:
        """
        Force the auth method to use the username passed by the user as the alias name.
        """
        return pulumi.get(self, "username_as_alias")

