# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'KeysAwArgs',
    'KeysAwArgsDict',
    'KeysAzureArgs',
    'KeysAzureArgsDict',
    'KeysPkcArgs',
    'KeysPkcArgsDict',
]

MYPY = False

if not MYPY:
    class KeysAwArgsDict(TypedDict):
        access_key: pulumi.Input[_builtins.str]
        """
        The AWS access key to use
        """
        key_bits: pulumi.Input[_builtins.str]
        """
        The size in bits for an RSA key. This field is required when 'key_type' is 'RSA'
        """
        key_type: pulumi.Input[_builtins.str]
        """
        The type of key to use
        """
        kms_key: pulumi.Input[_builtins.str]
        """
        An identifier for the key
        """
        name: pulumi.Input[_builtins.str]
        """
        A unique lowercase name that serves as identifying the key
        """
        secret_key: pulumi.Input[_builtins.str]
        """
        The AWS secret key to use
        """
        allow_generate_key: NotRequired[pulumi.Input[_builtins.bool]]
        """
        If no existing key can be found in the referenced backend, instructs Vault to generate a key within the backend
        """
        allow_replace_key: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Controls the ability for Vault to replace through generation or importing a key into the configured backend even if a key is present, if set to false those operations are forbidden if a key exists.
        """
        allow_store_key: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Controls the ability for Vault to import a key to the configured backend, if 'false', those operations will be forbidden
        """
        any_mount: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Allow usage from any mount point within the namespace if 'true'
        """
        curve: NotRequired[pulumi.Input[_builtins.str]]
        """
        The curve to use for an ECDSA key. Used when key_type is 'ECDSA'. Required if 'allow_generate_key' is true
        """
        endpoint: NotRequired[pulumi.Input[_builtins.str]]
        """
        Used to specify a custom AWS endpoint
        """
        region: NotRequired[pulumi.Input[_builtins.str]]
        """
        The AWS region where the keys are stored (or will be stored)
        """
        uuid: NotRequired[pulumi.Input[_builtins.str]]
        """
        ID of the managed key read from Vault
        """
elif False:
    KeysAwArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class KeysAwArgs:
    def __init__(__self__, *,
                 access_key: pulumi.Input[_builtins.str],
                 key_bits: pulumi.Input[_builtins.str],
                 key_type: pulumi.Input[_builtins.str],
                 kms_key: pulumi.Input[_builtins.str],
                 name: pulumi.Input[_builtins.str],
                 secret_key: pulumi.Input[_builtins.str],
                 allow_generate_key: Optional[pulumi.Input[_builtins.bool]] = None,
                 allow_replace_key: Optional[pulumi.Input[_builtins.bool]] = None,
                 allow_store_key: Optional[pulumi.Input[_builtins.bool]] = None,
                 any_mount: Optional[pulumi.Input[_builtins.bool]] = None,
                 curve: Optional[pulumi.Input[_builtins.str]] = None,
                 endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 uuid: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] access_key: The AWS access key to use
        :param pulumi.Input[_builtins.str] key_bits: The size in bits for an RSA key. This field is required when 'key_type' is 'RSA'
        :param pulumi.Input[_builtins.str] key_type: The type of key to use
        :param pulumi.Input[_builtins.str] kms_key: An identifier for the key
        :param pulumi.Input[_builtins.str] name: A unique lowercase name that serves as identifying the key
        :param pulumi.Input[_builtins.str] secret_key: The AWS secret key to use
        :param pulumi.Input[_builtins.bool] allow_generate_key: If no existing key can be found in the referenced backend, instructs Vault to generate a key within the backend
        :param pulumi.Input[_builtins.bool] allow_replace_key: Controls the ability for Vault to replace through generation or importing a key into the configured backend even if a key is present, if set to false those operations are forbidden if a key exists.
        :param pulumi.Input[_builtins.bool] allow_store_key: Controls the ability for Vault to import a key to the configured backend, if 'false', those operations will be forbidden
        :param pulumi.Input[_builtins.bool] any_mount: Allow usage from any mount point within the namespace if 'true'
        :param pulumi.Input[_builtins.str] curve: The curve to use for an ECDSA key. Used when key_type is 'ECDSA'. Required if 'allow_generate_key' is true
        :param pulumi.Input[_builtins.str] endpoint: Used to specify a custom AWS endpoint
        :param pulumi.Input[_builtins.str] region: The AWS region where the keys are stored (or will be stored)
        :param pulumi.Input[_builtins.str] uuid: ID of the managed key read from Vault
        """
        pulumi.set(__self__, "access_key", access_key)
        pulumi.set(__self__, "key_bits", key_bits)
        pulumi.set(__self__, "key_type", key_type)
        pulumi.set(__self__, "kms_key", kms_key)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "secret_key", secret_key)
        if allow_generate_key is not None:
            pulumi.set(__self__, "allow_generate_key", allow_generate_key)
        if allow_replace_key is not None:
            pulumi.set(__self__, "allow_replace_key", allow_replace_key)
        if allow_store_key is not None:
            pulumi.set(__self__, "allow_store_key", allow_store_key)
        if any_mount is not None:
            pulumi.set(__self__, "any_mount", any_mount)
        if curve is not None:
            pulumi.set(__self__, "curve", curve)
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if uuid is not None:
            pulumi.set(__self__, "uuid", uuid)

    @_builtins.property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> pulumi.Input[_builtins.str]:
        """
        The AWS access key to use
        """
        return pulumi.get(self, "access_key")

    @access_key.setter
    def access_key(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "access_key", value)

    @_builtins.property
    @pulumi.getter(name="keyBits")
    def key_bits(self) -> pulumi.Input[_builtins.str]:
        """
        The size in bits for an RSA key. This field is required when 'key_type' is 'RSA'
        """
        return pulumi.get(self, "key_bits")

    @key_bits.setter
    def key_bits(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "key_bits", value)

    @_builtins.property
    @pulumi.getter(name="keyType")
    def key_type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of key to use
        """
        return pulumi.get(self, "key_type")

    @key_type.setter
    def key_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "key_type", value)

    @_builtins.property
    @pulumi.getter(name="kmsKey")
    def kms_key(self) -> pulumi.Input[_builtins.str]:
        """
        An identifier for the key
        """
        return pulumi.get(self, "kms_key")

    @kms_key.setter
    def kms_key(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "kms_key", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        A unique lowercase name that serves as identifying the key
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> pulumi.Input[_builtins.str]:
        """
        The AWS secret key to use
        """
        return pulumi.get(self, "secret_key")

    @secret_key.setter
    def secret_key(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "secret_key", value)

    @_builtins.property
    @pulumi.getter(name="allowGenerateKey")
    def allow_generate_key(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If no existing key can be found in the referenced backend, instructs Vault to generate a key within the backend
        """
        return pulumi.get(self, "allow_generate_key")

    @allow_generate_key.setter
    def allow_generate_key(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "allow_generate_key", value)

    @_builtins.property
    @pulumi.getter(name="allowReplaceKey")
    def allow_replace_key(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Controls the ability for Vault to replace through generation or importing a key into the configured backend even if a key is present, if set to false those operations are forbidden if a key exists.
        """
        return pulumi.get(self, "allow_replace_key")

    @allow_replace_key.setter
    def allow_replace_key(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "allow_replace_key", value)

    @_builtins.property
    @pulumi.getter(name="allowStoreKey")
    def allow_store_key(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Controls the ability for Vault to import a key to the configured backend, if 'false', those operations will be forbidden
        """
        return pulumi.get(self, "allow_store_key")

    @allow_store_key.setter
    def allow_store_key(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "allow_store_key", value)

    @_builtins.property
    @pulumi.getter(name="anyMount")
    def any_mount(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Allow usage from any mount point within the namespace if 'true'
        """
        return pulumi.get(self, "any_mount")

    @any_mount.setter
    def any_mount(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "any_mount", value)

    @_builtins.property
    @pulumi.getter
    def curve(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The curve to use for an ECDSA key. Used when key_type is 'ECDSA'. Required if 'allow_generate_key' is true
        """
        return pulumi.get(self, "curve")

    @curve.setter
    def curve(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "curve", value)

    @_builtins.property
    @pulumi.getter
    def endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Used to specify a custom AWS endpoint
        """
        return pulumi.get(self, "endpoint")

    @endpoint.setter
    def endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "endpoint", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The AWS region where the keys are stored (or will be stored)
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def uuid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the managed key read from Vault
        """
        return pulumi.get(self, "uuid")

    @uuid.setter
    def uuid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "uuid", value)


if not MYPY:
    class KeysAzureArgsDict(TypedDict):
        client_id: pulumi.Input[_builtins.str]
        """
        The client id for credentials to query the Azure APIs
        """
        client_secret: pulumi.Input[_builtins.str]
        """
        The client secret for credentials to query the Azure APIs
        """
        key_name: pulumi.Input[_builtins.str]
        """
        The Key Vault key to use for encryption and decryption
        """
        key_type: pulumi.Input[_builtins.str]
        """
        The type of key to use
        """
        name: pulumi.Input[_builtins.str]
        """
        A unique lowercase name that serves as identifying the key
        """
        tenant_id: pulumi.Input[_builtins.str]
        """
        The tenant id for the Azure Active Directory organization
        """
        vault_name: pulumi.Input[_builtins.str]
        """
        The Key Vault vault to use the encryption keys for encryption and decryption
        """
        allow_generate_key: NotRequired[pulumi.Input[_builtins.bool]]
        """
        If no existing key can be found in the referenced backend, instructs Vault to generate a key within the backend
        """
        allow_replace_key: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Controls the ability for Vault to replace through generation or importing a key into the configured backend even if a key is present, if set to false those operations are forbidden if a key exists.
        """
        allow_store_key: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Controls the ability for Vault to import a key to the configured backend, if 'false', those operations will be forbidden
        """
        any_mount: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Allow usage from any mount point within the namespace if 'true'
        """
        environment: NotRequired[pulumi.Input[_builtins.str]]
        """
        The Azure Cloud environment API endpoints to use
        """
        key_bits: NotRequired[pulumi.Input[_builtins.str]]
        """
        The size in bits for an RSA key. This field is required when 'key_type' is 'RSA' or when 'allow_generate_key' is true
        """
        resource: NotRequired[pulumi.Input[_builtins.str]]
        """
        The Azure Key Vault resource's DNS Suffix to connect to
        """
        uuid: NotRequired[pulumi.Input[_builtins.str]]
        """
        ID of the managed key read from Vault
        """
elif False:
    KeysAzureArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class KeysAzureArgs:
    def __init__(__self__, *,
                 client_id: pulumi.Input[_builtins.str],
                 client_secret: pulumi.Input[_builtins.str],
                 key_name: pulumi.Input[_builtins.str],
                 key_type: pulumi.Input[_builtins.str],
                 name: pulumi.Input[_builtins.str],
                 tenant_id: pulumi.Input[_builtins.str],
                 vault_name: pulumi.Input[_builtins.str],
                 allow_generate_key: Optional[pulumi.Input[_builtins.bool]] = None,
                 allow_replace_key: Optional[pulumi.Input[_builtins.bool]] = None,
                 allow_store_key: Optional[pulumi.Input[_builtins.bool]] = None,
                 any_mount: Optional[pulumi.Input[_builtins.bool]] = None,
                 environment: Optional[pulumi.Input[_builtins.str]] = None,
                 key_bits: Optional[pulumi.Input[_builtins.str]] = None,
                 resource: Optional[pulumi.Input[_builtins.str]] = None,
                 uuid: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] client_id: The client id for credentials to query the Azure APIs
        :param pulumi.Input[_builtins.str] client_secret: The client secret for credentials to query the Azure APIs
        :param pulumi.Input[_builtins.str] key_name: The Key Vault key to use for encryption and decryption
        :param pulumi.Input[_builtins.str] key_type: The type of key to use
        :param pulumi.Input[_builtins.str] name: A unique lowercase name that serves as identifying the key
        :param pulumi.Input[_builtins.str] tenant_id: The tenant id for the Azure Active Directory organization
        :param pulumi.Input[_builtins.str] vault_name: The Key Vault vault to use the encryption keys for encryption and decryption
        :param pulumi.Input[_builtins.bool] allow_generate_key: If no existing key can be found in the referenced backend, instructs Vault to generate a key within the backend
        :param pulumi.Input[_builtins.bool] allow_replace_key: Controls the ability for Vault to replace through generation or importing a key into the configured backend even if a key is present, if set to false those operations are forbidden if a key exists.
        :param pulumi.Input[_builtins.bool] allow_store_key: Controls the ability for Vault to import a key to the configured backend, if 'false', those operations will be forbidden
        :param pulumi.Input[_builtins.bool] any_mount: Allow usage from any mount point within the namespace if 'true'
        :param pulumi.Input[_builtins.str] environment: The Azure Cloud environment API endpoints to use
        :param pulumi.Input[_builtins.str] key_bits: The size in bits for an RSA key. This field is required when 'key_type' is 'RSA' or when 'allow_generate_key' is true
        :param pulumi.Input[_builtins.str] resource: The Azure Key Vault resource's DNS Suffix to connect to
        :param pulumi.Input[_builtins.str] uuid: ID of the managed key read from Vault
        """
        pulumi.set(__self__, "client_id", client_id)
        pulumi.set(__self__, "client_secret", client_secret)
        pulumi.set(__self__, "key_name", key_name)
        pulumi.set(__self__, "key_type", key_type)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "tenant_id", tenant_id)
        pulumi.set(__self__, "vault_name", vault_name)
        if allow_generate_key is not None:
            pulumi.set(__self__, "allow_generate_key", allow_generate_key)
        if allow_replace_key is not None:
            pulumi.set(__self__, "allow_replace_key", allow_replace_key)
        if allow_store_key is not None:
            pulumi.set(__self__, "allow_store_key", allow_store_key)
        if any_mount is not None:
            pulumi.set(__self__, "any_mount", any_mount)
        if environment is not None:
            pulumi.set(__self__, "environment", environment)
        if key_bits is not None:
            pulumi.set(__self__, "key_bits", key_bits)
        if resource is not None:
            pulumi.set(__self__, "resource", resource)
        if uuid is not None:
            pulumi.set(__self__, "uuid", uuid)

    @_builtins.property
    @pulumi.getter(name="clientId")
    def client_id(self) -> pulumi.Input[_builtins.str]:
        """
        The client id for credentials to query the Azure APIs
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "client_id", value)

    @_builtins.property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> pulumi.Input[_builtins.str]:
        """
        The client secret for credentials to query the Azure APIs
        """
        return pulumi.get(self, "client_secret")

    @client_secret.setter
    def client_secret(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "client_secret", value)

    @_builtins.property
    @pulumi.getter(name="keyName")
    def key_name(self) -> pulumi.Input[_builtins.str]:
        """
        The Key Vault key to use for encryption and decryption
        """
        return pulumi.get(self, "key_name")

    @key_name.setter
    def key_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "key_name", value)

    @_builtins.property
    @pulumi.getter(name="keyType")
    def key_type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of key to use
        """
        return pulumi.get(self, "key_type")

    @key_type.setter
    def key_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "key_type", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        A unique lowercase name that serves as identifying the key
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Input[_builtins.str]:
        """
        The tenant id for the Azure Active Directory organization
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "tenant_id", value)

    @_builtins.property
    @pulumi.getter(name="vaultName")
    def vault_name(self) -> pulumi.Input[_builtins.str]:
        """
        The Key Vault vault to use the encryption keys for encryption and decryption
        """
        return pulumi.get(self, "vault_name")

    @vault_name.setter
    def vault_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "vault_name", value)

    @_builtins.property
    @pulumi.getter(name="allowGenerateKey")
    def allow_generate_key(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If no existing key can be found in the referenced backend, instructs Vault to generate a key within the backend
        """
        return pulumi.get(self, "allow_generate_key")

    @allow_generate_key.setter
    def allow_generate_key(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "allow_generate_key", value)

    @_builtins.property
    @pulumi.getter(name="allowReplaceKey")
    def allow_replace_key(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Controls the ability for Vault to replace through generation or importing a key into the configured backend even if a key is present, if set to false those operations are forbidden if a key exists.
        """
        return pulumi.get(self, "allow_replace_key")

    @allow_replace_key.setter
    def allow_replace_key(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "allow_replace_key", value)

    @_builtins.property
    @pulumi.getter(name="allowStoreKey")
    def allow_store_key(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Controls the ability for Vault to import a key to the configured backend, if 'false', those operations will be forbidden
        """
        return pulumi.get(self, "allow_store_key")

    @allow_store_key.setter
    def allow_store_key(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "allow_store_key", value)

    @_builtins.property
    @pulumi.getter(name="anyMount")
    def any_mount(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Allow usage from any mount point within the namespace if 'true'
        """
        return pulumi.get(self, "any_mount")

    @any_mount.setter
    def any_mount(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "any_mount", value)

    @_builtins.property
    @pulumi.getter
    def environment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Azure Cloud environment API endpoints to use
        """
        return pulumi.get(self, "environment")

    @environment.setter
    def environment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "environment", value)

    @_builtins.property
    @pulumi.getter(name="keyBits")
    def key_bits(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The size in bits for an RSA key. This field is required when 'key_type' is 'RSA' or when 'allow_generate_key' is true
        """
        return pulumi.get(self, "key_bits")

    @key_bits.setter
    def key_bits(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_bits", value)

    @_builtins.property
    @pulumi.getter
    def resource(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Azure Key Vault resource's DNS Suffix to connect to
        """
        return pulumi.get(self, "resource")

    @resource.setter
    def resource(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource", value)

    @_builtins.property
    @pulumi.getter
    def uuid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the managed key read from Vault
        """
        return pulumi.get(self, "uuid")

    @uuid.setter
    def uuid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "uuid", value)


if not MYPY:
    class KeysPkcArgsDict(TypedDict):
        key_id: pulumi.Input[_builtins.str]
        """
        The id of a PKCS#11 key to use
        """
        key_label: pulumi.Input[_builtins.str]
        """
        The label of the key to use
        """
        library: pulumi.Input[_builtins.str]
        """
        The name of the kms_library stanza to use from Vault's config to lookup the local library path
        """
        mechanism: pulumi.Input[_builtins.str]
        """
        The encryption/decryption mechanism to use, specified as a hexadecimal (prefixed by 0x) string.
        """
        name: pulumi.Input[_builtins.str]
        """
        A unique lowercase name that serves as identifying the key
        """
        pin: pulumi.Input[_builtins.str]
        """
        The PIN for login
        """
        allow_generate_key: NotRequired[pulumi.Input[_builtins.bool]]
        """
        If no existing key can be found in the referenced backend, instructs Vault to generate a key within the backend
        """
        allow_replace_key: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Controls the ability for Vault to replace through generation or importing a key into the configured backend even if a key is present, if set to false those operations are forbidden if a key exists.
        """
        allow_store_key: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Controls the ability for Vault to import a key to the configured backend, if 'false', those operations will be forbidden
        """
        any_mount: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Allow usage from any mount point within the namespace if 'true'
        """
        curve: NotRequired[pulumi.Input[_builtins.str]]
        """
        Supplies the curve value when using the 'CKM_ECDSA' mechanism. Required if 'allow_generate_key' is true
        """
        force_rw_session: NotRequired[pulumi.Input[_builtins.str]]
        """
        Force all operations to open up a read-write session to the HSM
        """
        key_bits: NotRequired[pulumi.Input[_builtins.str]]
        """
        Supplies the size in bits of the key when using 'CKM_RSA_PKCS_PSS', 'CKM_RSA_PKCS_OAEP' or 'CKM_RSA_PKCS' as a value for 'mechanism'. Required if 'allow_generate_key' is true
        """
        slot: NotRequired[pulumi.Input[_builtins.str]]
        """
        The slot number to use, specified as a string in a decimal format (e.g. '2305843009213693953')
        """
        token_label: NotRequired[pulumi.Input[_builtins.str]]
        """
        The slot token label to use
        """
        uuid: NotRequired[pulumi.Input[_builtins.str]]
        """
        ID of the managed key read from Vault
        """
elif False:
    KeysPkcArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class KeysPkcArgs:
    def __init__(__self__, *,
                 key_id: pulumi.Input[_builtins.str],
                 key_label: pulumi.Input[_builtins.str],
                 library: pulumi.Input[_builtins.str],
                 mechanism: pulumi.Input[_builtins.str],
                 name: pulumi.Input[_builtins.str],
                 pin: pulumi.Input[_builtins.str],
                 allow_generate_key: Optional[pulumi.Input[_builtins.bool]] = None,
                 allow_replace_key: Optional[pulumi.Input[_builtins.bool]] = None,
                 allow_store_key: Optional[pulumi.Input[_builtins.bool]] = None,
                 any_mount: Optional[pulumi.Input[_builtins.bool]] = None,
                 curve: Optional[pulumi.Input[_builtins.str]] = None,
                 force_rw_session: Optional[pulumi.Input[_builtins.str]] = None,
                 key_bits: Optional[pulumi.Input[_builtins.str]] = None,
                 slot: Optional[pulumi.Input[_builtins.str]] = None,
                 token_label: Optional[pulumi.Input[_builtins.str]] = None,
                 uuid: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] key_id: The id of a PKCS#11 key to use
        :param pulumi.Input[_builtins.str] key_label: The label of the key to use
        :param pulumi.Input[_builtins.str] library: The name of the kms_library stanza to use from Vault's config to lookup the local library path
        :param pulumi.Input[_builtins.str] mechanism: The encryption/decryption mechanism to use, specified as a hexadecimal (prefixed by 0x) string.
        :param pulumi.Input[_builtins.str] name: A unique lowercase name that serves as identifying the key
        :param pulumi.Input[_builtins.str] pin: The PIN for login
        :param pulumi.Input[_builtins.bool] allow_generate_key: If no existing key can be found in the referenced backend, instructs Vault to generate a key within the backend
        :param pulumi.Input[_builtins.bool] allow_replace_key: Controls the ability for Vault to replace through generation or importing a key into the configured backend even if a key is present, if set to false those operations are forbidden if a key exists.
        :param pulumi.Input[_builtins.bool] allow_store_key: Controls the ability for Vault to import a key to the configured backend, if 'false', those operations will be forbidden
        :param pulumi.Input[_builtins.bool] any_mount: Allow usage from any mount point within the namespace if 'true'
        :param pulumi.Input[_builtins.str] curve: Supplies the curve value when using the 'CKM_ECDSA' mechanism. Required if 'allow_generate_key' is true
        :param pulumi.Input[_builtins.str] force_rw_session: Force all operations to open up a read-write session to the HSM
        :param pulumi.Input[_builtins.str] key_bits: Supplies the size in bits of the key when using 'CKM_RSA_PKCS_PSS', 'CKM_RSA_PKCS_OAEP' or 'CKM_RSA_PKCS' as a value for 'mechanism'. Required if 'allow_generate_key' is true
        :param pulumi.Input[_builtins.str] slot: The slot number to use, specified as a string in a decimal format (e.g. '2305843009213693953')
        :param pulumi.Input[_builtins.str] token_label: The slot token label to use
        :param pulumi.Input[_builtins.str] uuid: ID of the managed key read from Vault
        """
        pulumi.set(__self__, "key_id", key_id)
        pulumi.set(__self__, "key_label", key_label)
        pulumi.set(__self__, "library", library)
        pulumi.set(__self__, "mechanism", mechanism)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "pin", pin)
        if allow_generate_key is not None:
            pulumi.set(__self__, "allow_generate_key", allow_generate_key)
        if allow_replace_key is not None:
            pulumi.set(__self__, "allow_replace_key", allow_replace_key)
        if allow_store_key is not None:
            pulumi.set(__self__, "allow_store_key", allow_store_key)
        if any_mount is not None:
            pulumi.set(__self__, "any_mount", any_mount)
        if curve is not None:
            pulumi.set(__self__, "curve", curve)
        if force_rw_session is not None:
            pulumi.set(__self__, "force_rw_session", force_rw_session)
        if key_bits is not None:
            pulumi.set(__self__, "key_bits", key_bits)
        if slot is not None:
            pulumi.set(__self__, "slot", slot)
        if token_label is not None:
            pulumi.set(__self__, "token_label", token_label)
        if uuid is not None:
            pulumi.set(__self__, "uuid", uuid)

    @_builtins.property
    @pulumi.getter(name="keyId")
    def key_id(self) -> pulumi.Input[_builtins.str]:
        """
        The id of a PKCS#11 key to use
        """
        return pulumi.get(self, "key_id")

    @key_id.setter
    def key_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "key_id", value)

    @_builtins.property
    @pulumi.getter(name="keyLabel")
    def key_label(self) -> pulumi.Input[_builtins.str]:
        """
        The label of the key to use
        """
        return pulumi.get(self, "key_label")

    @key_label.setter
    def key_label(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "key_label", value)

    @_builtins.property
    @pulumi.getter
    def library(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the kms_library stanza to use from Vault's config to lookup the local library path
        """
        return pulumi.get(self, "library")

    @library.setter
    def library(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "library", value)

    @_builtins.property
    @pulumi.getter
    def mechanism(self) -> pulumi.Input[_builtins.str]:
        """
        The encryption/decryption mechanism to use, specified as a hexadecimal (prefixed by 0x) string.
        """
        return pulumi.get(self, "mechanism")

    @mechanism.setter
    def mechanism(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "mechanism", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        A unique lowercase name that serves as identifying the key
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def pin(self) -> pulumi.Input[_builtins.str]:
        """
        The PIN for login
        """
        return pulumi.get(self, "pin")

    @pin.setter
    def pin(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "pin", value)

    @_builtins.property
    @pulumi.getter(name="allowGenerateKey")
    def allow_generate_key(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If no existing key can be found in the referenced backend, instructs Vault to generate a key within the backend
        """
        return pulumi.get(self, "allow_generate_key")

    @allow_generate_key.setter
    def allow_generate_key(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "allow_generate_key", value)

    @_builtins.property
    @pulumi.getter(name="allowReplaceKey")
    def allow_replace_key(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Controls the ability for Vault to replace through generation or importing a key into the configured backend even if a key is present, if set to false those operations are forbidden if a key exists.
        """
        return pulumi.get(self, "allow_replace_key")

    @allow_replace_key.setter
    def allow_replace_key(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "allow_replace_key", value)

    @_builtins.property
    @pulumi.getter(name="allowStoreKey")
    def allow_store_key(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Controls the ability for Vault to import a key to the configured backend, if 'false', those operations will be forbidden
        """
        return pulumi.get(self, "allow_store_key")

    @allow_store_key.setter
    def allow_store_key(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "allow_store_key", value)

    @_builtins.property
    @pulumi.getter(name="anyMount")
    def any_mount(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Allow usage from any mount point within the namespace if 'true'
        """
        return pulumi.get(self, "any_mount")

    @any_mount.setter
    def any_mount(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "any_mount", value)

    @_builtins.property
    @pulumi.getter
    def curve(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Supplies the curve value when using the 'CKM_ECDSA' mechanism. Required if 'allow_generate_key' is true
        """
        return pulumi.get(self, "curve")

    @curve.setter
    def curve(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "curve", value)

    @_builtins.property
    @pulumi.getter(name="forceRwSession")
    def force_rw_session(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Force all operations to open up a read-write session to the HSM
        """
        return pulumi.get(self, "force_rw_session")

    @force_rw_session.setter
    def force_rw_session(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "force_rw_session", value)

    @_builtins.property
    @pulumi.getter(name="keyBits")
    def key_bits(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Supplies the size in bits of the key when using 'CKM_RSA_PKCS_PSS', 'CKM_RSA_PKCS_OAEP' or 'CKM_RSA_PKCS' as a value for 'mechanism'. Required if 'allow_generate_key' is true
        """
        return pulumi.get(self, "key_bits")

    @key_bits.setter
    def key_bits(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_bits", value)

    @_builtins.property
    @pulumi.getter
    def slot(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The slot number to use, specified as a string in a decimal format (e.g. '2305843009213693953')
        """
        return pulumi.get(self, "slot")

    @slot.setter
    def slot(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "slot", value)

    @_builtins.property
    @pulumi.getter(name="tokenLabel")
    def token_label(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The slot token label to use
        """
        return pulumi.get(self, "token_label")

    @token_label.setter
    def token_label(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "token_label", value)

    @_builtins.property
    @pulumi.getter
    def uuid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the managed key read from Vault
        """
        return pulumi.get(self, "uuid")

    @uuid.setter
    def uuid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "uuid", value)


