# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['BackendConfigScepArgs', 'BackendConfigScep']

@pulumi.input_type
class BackendConfigScepArgs:
    def __init__(__self__, *,
                 backend: pulumi.Input[_builtins.str],
                 allowed_digest_algorithms: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 allowed_encryption_algorithms: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 authenticators: Optional[pulumi.Input['BackendConfigScepAuthenticatorsArgs']] = None,
                 default_path_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 external_validations: Optional[pulumi.Input[Sequence[pulumi.Input['BackendConfigScepExternalValidationArgs']]]] = None,
                 log_level: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 restrict_ca_chain_to_issuer: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a BackendConfigScep resource.
        :param pulumi.Input[_builtins.str] backend: The path to the PKI secret backend to
               read the SCEP configuration from, with no leading or trailing `/`s.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_digest_algorithms: List of allowed digest algorithms for SCEP requests.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_encryption_algorithms: List of allowed encryption algorithms for SCEP requests.
        :param pulumi.Input['BackendConfigScepAuthenticatorsArgs'] authenticators: Lists the mount accessors SCEP should delegate authentication requests towards (see below for nested schema).
        :param pulumi.Input[_builtins.str] default_path_policy: Specifies the policy to be used for non-role-qualified SCEP requests; valid values are 'sign-verbatim', or "role:<role_name>" to specify a role to use as this policy.
        :param pulumi.Input[_builtins.bool] enabled: Specifies whether SCEP is enabled.
        :param pulumi.Input[Sequence[pulumi.Input['BackendConfigScepExternalValidationArgs']]] external_validations: Lists the 3rd party validation of SCEP requests (see below for nested schema).
        :param pulumi.Input[_builtins.str] log_level: The level of logging verbosity, affects only SCEP logs on this mount.
               
               
               <a id="nestedatt--authenticators"></a>
        :param pulumi.Input[_builtins.str] namespace: The namespace of the target resource.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.bool] restrict_ca_chain_to_issuer: If true, only return the issuer CA, otherwise the entire CA certificate chain will be returned if available from the PKI mount.
        """
        pulumi.set(__self__, "backend", backend)
        if allowed_digest_algorithms is not None:
            pulumi.set(__self__, "allowed_digest_algorithms", allowed_digest_algorithms)
        if allowed_encryption_algorithms is not None:
            pulumi.set(__self__, "allowed_encryption_algorithms", allowed_encryption_algorithms)
        if authenticators is not None:
            pulumi.set(__self__, "authenticators", authenticators)
        if default_path_policy is not None:
            pulumi.set(__self__, "default_path_policy", default_path_policy)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if external_validations is not None:
            pulumi.set(__self__, "external_validations", external_validations)
        if log_level is not None:
            pulumi.set(__self__, "log_level", log_level)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if restrict_ca_chain_to_issuer is not None:
            pulumi.set(__self__, "restrict_ca_chain_to_issuer", restrict_ca_chain_to_issuer)

    @_builtins.property
    @pulumi.getter
    def backend(self) -> pulumi.Input[_builtins.str]:
        """
        The path to the PKI secret backend to
        read the SCEP configuration from, with no leading or trailing `/`s.
        """
        return pulumi.get(self, "backend")

    @backend.setter
    def backend(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "backend", value)

    @_builtins.property
    @pulumi.getter(name="allowedDigestAlgorithms")
    def allowed_digest_algorithms(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of allowed digest algorithms for SCEP requests.
        """
        return pulumi.get(self, "allowed_digest_algorithms")

    @allowed_digest_algorithms.setter
    def allowed_digest_algorithms(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "allowed_digest_algorithms", value)

    @_builtins.property
    @pulumi.getter(name="allowedEncryptionAlgorithms")
    def allowed_encryption_algorithms(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of allowed encryption algorithms for SCEP requests.
        """
        return pulumi.get(self, "allowed_encryption_algorithms")

    @allowed_encryption_algorithms.setter
    def allowed_encryption_algorithms(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "allowed_encryption_algorithms", value)

    @_builtins.property
    @pulumi.getter
    def authenticators(self) -> Optional[pulumi.Input['BackendConfigScepAuthenticatorsArgs']]:
        """
        Lists the mount accessors SCEP should delegate authentication requests towards (see below for nested schema).
        """
        return pulumi.get(self, "authenticators")

    @authenticators.setter
    def authenticators(self, value: Optional[pulumi.Input['BackendConfigScepAuthenticatorsArgs']]):
        pulumi.set(self, "authenticators", value)

    @_builtins.property
    @pulumi.getter(name="defaultPathPolicy")
    def default_path_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the policy to be used for non-role-qualified SCEP requests; valid values are 'sign-verbatim', or "role:<role_name>" to specify a role to use as this policy.
        """
        return pulumi.get(self, "default_path_policy")

    @default_path_policy.setter
    def default_path_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_path_policy", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether SCEP is enabled.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="externalValidations")
    def external_validations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BackendConfigScepExternalValidationArgs']]]]:
        """
        Lists the 3rd party validation of SCEP requests (see below for nested schema).
        """
        return pulumi.get(self, "external_validations")

    @external_validations.setter
    def external_validations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BackendConfigScepExternalValidationArgs']]]]):
        pulumi.set(self, "external_validations", value)

    @_builtins.property
    @pulumi.getter(name="logLevel")
    def log_level(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The level of logging verbosity, affects only SCEP logs on this mount.


        <a id="nestedatt--authenticators"></a>
        """
        return pulumi.get(self, "log_level")

    @log_level.setter
    def log_level(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "log_level", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The namespace of the target resource.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter(name="restrictCaChainToIssuer")
    def restrict_ca_chain_to_issuer(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If true, only return the issuer CA, otherwise the entire CA certificate chain will be returned if available from the PKI mount.
        """
        return pulumi.get(self, "restrict_ca_chain_to_issuer")

    @restrict_ca_chain_to_issuer.setter
    def restrict_ca_chain_to_issuer(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "restrict_ca_chain_to_issuer", value)


@pulumi.input_type
class _BackendConfigScepState:
    def __init__(__self__, *,
                 allowed_digest_algorithms: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 allowed_encryption_algorithms: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 authenticators: Optional[pulumi.Input['BackendConfigScepAuthenticatorsArgs']] = None,
                 backend: Optional[pulumi.Input[_builtins.str]] = None,
                 default_path_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 external_validations: Optional[pulumi.Input[Sequence[pulumi.Input['BackendConfigScepExternalValidationArgs']]]] = None,
                 last_updated: Optional[pulumi.Input[_builtins.str]] = None,
                 log_level: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 restrict_ca_chain_to_issuer: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        Input properties used for looking up and filtering BackendConfigScep resources.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_digest_algorithms: List of allowed digest algorithms for SCEP requests.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_encryption_algorithms: List of allowed encryption algorithms for SCEP requests.
        :param pulumi.Input['BackendConfigScepAuthenticatorsArgs'] authenticators: Lists the mount accessors SCEP should delegate authentication requests towards (see below for nested schema).
        :param pulumi.Input[_builtins.str] backend: The path to the PKI secret backend to
               read the SCEP configuration from, with no leading or trailing `/`s.
        :param pulumi.Input[_builtins.str] default_path_policy: Specifies the policy to be used for non-role-qualified SCEP requests; valid values are 'sign-verbatim', or "role:<role_name>" to specify a role to use as this policy.
        :param pulumi.Input[_builtins.bool] enabled: Specifies whether SCEP is enabled.
        :param pulumi.Input[Sequence[pulumi.Input['BackendConfigScepExternalValidationArgs']]] external_validations: Lists the 3rd party validation of SCEP requests (see below for nested schema).
        :param pulumi.Input[_builtins.str] last_updated: A read-only timestamp representing the last time the configuration was updated.
        :param pulumi.Input[_builtins.str] log_level: The level of logging verbosity, affects only SCEP logs on this mount.
               
               
               <a id="nestedatt--authenticators"></a>
        :param pulumi.Input[_builtins.str] namespace: The namespace of the target resource.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.bool] restrict_ca_chain_to_issuer: If true, only return the issuer CA, otherwise the entire CA certificate chain will be returned if available from the PKI mount.
        """
        if allowed_digest_algorithms is not None:
            pulumi.set(__self__, "allowed_digest_algorithms", allowed_digest_algorithms)
        if allowed_encryption_algorithms is not None:
            pulumi.set(__self__, "allowed_encryption_algorithms", allowed_encryption_algorithms)
        if authenticators is not None:
            pulumi.set(__self__, "authenticators", authenticators)
        if backend is not None:
            pulumi.set(__self__, "backend", backend)
        if default_path_policy is not None:
            pulumi.set(__self__, "default_path_policy", default_path_policy)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if external_validations is not None:
            pulumi.set(__self__, "external_validations", external_validations)
        if last_updated is not None:
            pulumi.set(__self__, "last_updated", last_updated)
        if log_level is not None:
            pulumi.set(__self__, "log_level", log_level)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if restrict_ca_chain_to_issuer is not None:
            pulumi.set(__self__, "restrict_ca_chain_to_issuer", restrict_ca_chain_to_issuer)

    @_builtins.property
    @pulumi.getter(name="allowedDigestAlgorithms")
    def allowed_digest_algorithms(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of allowed digest algorithms for SCEP requests.
        """
        return pulumi.get(self, "allowed_digest_algorithms")

    @allowed_digest_algorithms.setter
    def allowed_digest_algorithms(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "allowed_digest_algorithms", value)

    @_builtins.property
    @pulumi.getter(name="allowedEncryptionAlgorithms")
    def allowed_encryption_algorithms(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of allowed encryption algorithms for SCEP requests.
        """
        return pulumi.get(self, "allowed_encryption_algorithms")

    @allowed_encryption_algorithms.setter
    def allowed_encryption_algorithms(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "allowed_encryption_algorithms", value)

    @_builtins.property
    @pulumi.getter
    def authenticators(self) -> Optional[pulumi.Input['BackendConfigScepAuthenticatorsArgs']]:
        """
        Lists the mount accessors SCEP should delegate authentication requests towards (see below for nested schema).
        """
        return pulumi.get(self, "authenticators")

    @authenticators.setter
    def authenticators(self, value: Optional[pulumi.Input['BackendConfigScepAuthenticatorsArgs']]):
        pulumi.set(self, "authenticators", value)

    @_builtins.property
    @pulumi.getter
    def backend(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The path to the PKI secret backend to
        read the SCEP configuration from, with no leading or trailing `/`s.
        """
        return pulumi.get(self, "backend")

    @backend.setter
    def backend(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backend", value)

    @_builtins.property
    @pulumi.getter(name="defaultPathPolicy")
    def default_path_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the policy to be used for non-role-qualified SCEP requests; valid values are 'sign-verbatim', or "role:<role_name>" to specify a role to use as this policy.
        """
        return pulumi.get(self, "default_path_policy")

    @default_path_policy.setter
    def default_path_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_path_policy", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether SCEP is enabled.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="externalValidations")
    def external_validations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BackendConfigScepExternalValidationArgs']]]]:
        """
        Lists the 3rd party validation of SCEP requests (see below for nested schema).
        """
        return pulumi.get(self, "external_validations")

    @external_validations.setter
    def external_validations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BackendConfigScepExternalValidationArgs']]]]):
        pulumi.set(self, "external_validations", value)

    @_builtins.property
    @pulumi.getter(name="lastUpdated")
    def last_updated(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A read-only timestamp representing the last time the configuration was updated.
        """
        return pulumi.get(self, "last_updated")

    @last_updated.setter
    def last_updated(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "last_updated", value)

    @_builtins.property
    @pulumi.getter(name="logLevel")
    def log_level(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The level of logging verbosity, affects only SCEP logs on this mount.


        <a id="nestedatt--authenticators"></a>
        """
        return pulumi.get(self, "log_level")

    @log_level.setter
    def log_level(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "log_level", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The namespace of the target resource.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter(name="restrictCaChainToIssuer")
    def restrict_ca_chain_to_issuer(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If true, only return the issuer CA, otherwise the entire CA certificate chain will be returned if available from the PKI mount.
        """
        return pulumi.get(self, "restrict_ca_chain_to_issuer")

    @restrict_ca_chain_to_issuer.setter
    def restrict_ca_chain_to_issuer(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "restrict_ca_chain_to_issuer", value)


@pulumi.type_token("vault:pkiSecret/backendConfigScep:BackendConfigScep")
class BackendConfigScep(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allowed_digest_algorithms: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 allowed_encryption_algorithms: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 authenticators: Optional[pulumi.Input[Union['BackendConfigScepAuthenticatorsArgs', 'BackendConfigScepAuthenticatorsArgsDict']]] = None,
                 backend: Optional[pulumi.Input[_builtins.str]] = None,
                 default_path_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 external_validations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['BackendConfigScepExternalValidationArgs', 'BackendConfigScepExternalValidationArgsDict']]]]] = None,
                 log_level: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 restrict_ca_chain_to_issuer: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        Allows setting the SCEP configuration on a PKI Secret Backend.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_vault as vault

        scep = vault.AuthBackend("scep",
            path="scep-auth",
            type="scep")
        scep_challenge = vault.ScepAuthBackendRole("scep_challenge",
            backend=scep.id,
            name="scep-auth",
            display_name="Static challenge for SCEP clients",
            auth_type="static-challenge",
            challenge="ac7e4ada-c8ef-4393-9098-d69d08736833")
        pki = vault.Mount("pki",
            path="pki_scep",
            type="pki",
            description="PKI secret engine mount")
        test = vault.pkisecret.BackendConfigScep("test",
            backend=pki.path,
            enabled=True,
            default_path_policy="sign-verbatim",
            restrict_ca_chain_to_issuer=True,
            authenticators={
                "scep": {
                    "accessor": scep.accessor,
                    "scep_role": scep_challenge.name,
                },
            })
        ```

        ## Import

        The PKI config cluster can be imported using the resource's `id`.
        In the case of the example above the `id` would be `pki-root/config/scep`,
        where the `pki-root` component is the resource's `backend`, e.g.

        ```sh
        $ pulumi import vault:pkiSecret/backendConfigScep:BackendConfigScep example pki-root/config/scep
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_digest_algorithms: List of allowed digest algorithms for SCEP requests.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_encryption_algorithms: List of allowed encryption algorithms for SCEP requests.
        :param pulumi.Input[Union['BackendConfigScepAuthenticatorsArgs', 'BackendConfigScepAuthenticatorsArgsDict']] authenticators: Lists the mount accessors SCEP should delegate authentication requests towards (see below for nested schema).
        :param pulumi.Input[_builtins.str] backend: The path to the PKI secret backend to
               read the SCEP configuration from, with no leading or trailing `/`s.
        :param pulumi.Input[_builtins.str] default_path_policy: Specifies the policy to be used for non-role-qualified SCEP requests; valid values are 'sign-verbatim', or "role:<role_name>" to specify a role to use as this policy.
        :param pulumi.Input[_builtins.bool] enabled: Specifies whether SCEP is enabled.
        :param pulumi.Input[Sequence[pulumi.Input[Union['BackendConfigScepExternalValidationArgs', 'BackendConfigScepExternalValidationArgsDict']]]] external_validations: Lists the 3rd party validation of SCEP requests (see below for nested schema).
        :param pulumi.Input[_builtins.str] log_level: The level of logging verbosity, affects only SCEP logs on this mount.
               
               
               <a id="nestedatt--authenticators"></a>
        :param pulumi.Input[_builtins.str] namespace: The namespace of the target resource.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.bool] restrict_ca_chain_to_issuer: If true, only return the issuer CA, otherwise the entire CA certificate chain will be returned if available from the PKI mount.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: BackendConfigScepArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Allows setting the SCEP configuration on a PKI Secret Backend.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_vault as vault

        scep = vault.AuthBackend("scep",
            path="scep-auth",
            type="scep")
        scep_challenge = vault.ScepAuthBackendRole("scep_challenge",
            backend=scep.id,
            name="scep-auth",
            display_name="Static challenge for SCEP clients",
            auth_type="static-challenge",
            challenge="ac7e4ada-c8ef-4393-9098-d69d08736833")
        pki = vault.Mount("pki",
            path="pki_scep",
            type="pki",
            description="PKI secret engine mount")
        test = vault.pkisecret.BackendConfigScep("test",
            backend=pki.path,
            enabled=True,
            default_path_policy="sign-verbatim",
            restrict_ca_chain_to_issuer=True,
            authenticators={
                "scep": {
                    "accessor": scep.accessor,
                    "scep_role": scep_challenge.name,
                },
            })
        ```

        ## Import

        The PKI config cluster can be imported using the resource's `id`.
        In the case of the example above the `id` would be `pki-root/config/scep`,
        where the `pki-root` component is the resource's `backend`, e.g.

        ```sh
        $ pulumi import vault:pkiSecret/backendConfigScep:BackendConfigScep example pki-root/config/scep
        ```

        :param str resource_name: The name of the resource.
        :param BackendConfigScepArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BackendConfigScepArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allowed_digest_algorithms: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 allowed_encryption_algorithms: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 authenticators: Optional[pulumi.Input[Union['BackendConfigScepAuthenticatorsArgs', 'BackendConfigScepAuthenticatorsArgsDict']]] = None,
                 backend: Optional[pulumi.Input[_builtins.str]] = None,
                 default_path_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 external_validations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['BackendConfigScepExternalValidationArgs', 'BackendConfigScepExternalValidationArgsDict']]]]] = None,
                 log_level: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 restrict_ca_chain_to_issuer: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BackendConfigScepArgs.__new__(BackendConfigScepArgs)

            __props__.__dict__["allowed_digest_algorithms"] = allowed_digest_algorithms
            __props__.__dict__["allowed_encryption_algorithms"] = allowed_encryption_algorithms
            __props__.__dict__["authenticators"] = authenticators
            if backend is None and not opts.urn:
                raise TypeError("Missing required property 'backend'")
            __props__.__dict__["backend"] = backend
            __props__.__dict__["default_path_policy"] = default_path_policy
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["external_validations"] = external_validations
            __props__.__dict__["log_level"] = log_level
            __props__.__dict__["namespace"] = namespace
            __props__.__dict__["restrict_ca_chain_to_issuer"] = restrict_ca_chain_to_issuer
            __props__.__dict__["last_updated"] = None
        super(BackendConfigScep, __self__).__init__(
            'vault:pkiSecret/backendConfigScep:BackendConfigScep',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            allowed_digest_algorithms: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            allowed_encryption_algorithms: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            authenticators: Optional[pulumi.Input[Union['BackendConfigScepAuthenticatorsArgs', 'BackendConfigScepAuthenticatorsArgsDict']]] = None,
            backend: Optional[pulumi.Input[_builtins.str]] = None,
            default_path_policy: Optional[pulumi.Input[_builtins.str]] = None,
            enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            external_validations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['BackendConfigScepExternalValidationArgs', 'BackendConfigScepExternalValidationArgsDict']]]]] = None,
            last_updated: Optional[pulumi.Input[_builtins.str]] = None,
            log_level: Optional[pulumi.Input[_builtins.str]] = None,
            namespace: Optional[pulumi.Input[_builtins.str]] = None,
            restrict_ca_chain_to_issuer: Optional[pulumi.Input[_builtins.bool]] = None) -> 'BackendConfigScep':
        """
        Get an existing BackendConfigScep resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_digest_algorithms: List of allowed digest algorithms for SCEP requests.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_encryption_algorithms: List of allowed encryption algorithms for SCEP requests.
        :param pulumi.Input[Union['BackendConfigScepAuthenticatorsArgs', 'BackendConfigScepAuthenticatorsArgsDict']] authenticators: Lists the mount accessors SCEP should delegate authentication requests towards (see below for nested schema).
        :param pulumi.Input[_builtins.str] backend: The path to the PKI secret backend to
               read the SCEP configuration from, with no leading or trailing `/`s.
        :param pulumi.Input[_builtins.str] default_path_policy: Specifies the policy to be used for non-role-qualified SCEP requests; valid values are 'sign-verbatim', or "role:<role_name>" to specify a role to use as this policy.
        :param pulumi.Input[_builtins.bool] enabled: Specifies whether SCEP is enabled.
        :param pulumi.Input[Sequence[pulumi.Input[Union['BackendConfigScepExternalValidationArgs', 'BackendConfigScepExternalValidationArgsDict']]]] external_validations: Lists the 3rd party validation of SCEP requests (see below for nested schema).
        :param pulumi.Input[_builtins.str] last_updated: A read-only timestamp representing the last time the configuration was updated.
        :param pulumi.Input[_builtins.str] log_level: The level of logging verbosity, affects only SCEP logs on this mount.
               
               
               <a id="nestedatt--authenticators"></a>
        :param pulumi.Input[_builtins.str] namespace: The namespace of the target resource.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.bool] restrict_ca_chain_to_issuer: If true, only return the issuer CA, otherwise the entire CA certificate chain will be returned if available from the PKI mount.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _BackendConfigScepState.__new__(_BackendConfigScepState)

        __props__.__dict__["allowed_digest_algorithms"] = allowed_digest_algorithms
        __props__.__dict__["allowed_encryption_algorithms"] = allowed_encryption_algorithms
        __props__.__dict__["authenticators"] = authenticators
        __props__.__dict__["backend"] = backend
        __props__.__dict__["default_path_policy"] = default_path_policy
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["external_validations"] = external_validations
        __props__.__dict__["last_updated"] = last_updated
        __props__.__dict__["log_level"] = log_level
        __props__.__dict__["namespace"] = namespace
        __props__.__dict__["restrict_ca_chain_to_issuer"] = restrict_ca_chain_to_issuer
        return BackendConfigScep(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="allowedDigestAlgorithms")
    def allowed_digest_algorithms(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        List of allowed digest algorithms for SCEP requests.
        """
        return pulumi.get(self, "allowed_digest_algorithms")

    @_builtins.property
    @pulumi.getter(name="allowedEncryptionAlgorithms")
    def allowed_encryption_algorithms(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        List of allowed encryption algorithms for SCEP requests.
        """
        return pulumi.get(self, "allowed_encryption_algorithms")

    @_builtins.property
    @pulumi.getter
    def authenticators(self) -> pulumi.Output['outputs.BackendConfigScepAuthenticators']:
        """
        Lists the mount accessors SCEP should delegate authentication requests towards (see below for nested schema).
        """
        return pulumi.get(self, "authenticators")

    @_builtins.property
    @pulumi.getter
    def backend(self) -> pulumi.Output[_builtins.str]:
        """
        The path to the PKI secret backend to
        read the SCEP configuration from, with no leading or trailing `/`s.
        """
        return pulumi.get(self, "backend")

    @_builtins.property
    @pulumi.getter(name="defaultPathPolicy")
    def default_path_policy(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the policy to be used for non-role-qualified SCEP requests; valid values are 'sign-verbatim', or "role:<role_name>" to specify a role to use as this policy.
        """
        return pulumi.get(self, "default_path_policy")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether SCEP is enabled.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="externalValidations")
    def external_validations(self) -> pulumi.Output[Sequence['outputs.BackendConfigScepExternalValidation']]:
        """
        Lists the 3rd party validation of SCEP requests (see below for nested schema).
        """
        return pulumi.get(self, "external_validations")

    @_builtins.property
    @pulumi.getter(name="lastUpdated")
    def last_updated(self) -> pulumi.Output[_builtins.str]:
        """
        A read-only timestamp representing the last time the configuration was updated.
        """
        return pulumi.get(self, "last_updated")

    @_builtins.property
    @pulumi.getter(name="logLevel")
    def log_level(self) -> pulumi.Output[_builtins.str]:
        """
        The level of logging verbosity, affects only SCEP logs on this mount.


        <a id="nestedatt--authenticators"></a>
        """
        return pulumi.get(self, "log_level")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The namespace of the target resource.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter(name="restrictCaChainToIssuer")
    def restrict_ca_chain_to_issuer(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        If true, only return the issuer CA, otherwise the entire CA certificate chain will be returned if available from the PKI mount.
        """
        return pulumi.get(self, "restrict_ca_chain_to_issuer")

