# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['QuotaRateLimitArgs', 'QuotaRateLimit']

@pulumi.input_type
class QuotaRateLimitArgs:
    def __init__(__self__, *,
                 rate: pulumi.Input[_builtins.float],
                 block_interval: Optional[pulumi.Input[_builtins.int]] = None,
                 group_by: Optional[pulumi.Input[_builtins.str]] = None,
                 inheritable: Optional[pulumi.Input[_builtins.bool]] = None,
                 interval: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 path: Optional[pulumi.Input[_builtins.str]] = None,
                 role: Optional[pulumi.Input[_builtins.str]] = None,
                 secondary_rate: Optional[pulumi.Input[_builtins.float]] = None):
        """
        The set of arguments for constructing a QuotaRateLimit resource.
        :param pulumi.Input[_builtins.float] rate: The maximum number of requests at any given second to be allowed by the quota
               rule. The `rate` must be positive.
        :param pulumi.Input[_builtins.int] block_interval: If set, when a client reaches a rate limit threshold, the client will
               be prohibited from any further requests until after the 'block_interval' in seconds has elapsed.
        :param pulumi.Input[_builtins.str] group_by: Attribute used to group requests for rate limiting. Limits are enforced independently for each
               group. Valid `group_by` modes are: 1) `ip` that groups requests by their source IP address (**`group_by` defaults to
               `ip` if unset, which is the only supported mode in community edition**); 2) `none` that groups together all requests
               that match the rate limit quota rule; 3) `entity_then_ip` that groups requests by their entity ID for authenticated
               requests that carry one, or by their IP for unauthenticated requests (or requests whose authentication is not
               connected to an entity); and 4) `entity_then_none` which also groups requests by their entity ID when available, but
               the rest is all grouped together (i.e. unauthenticated or with authentication not connected to an entity).
        :param pulumi.Input[_builtins.bool] inheritable: If set to `true` on a quota where path is set to a namespace, the same quota will be cumulatively applied to all child namespace. The inheritable parameter cannot be set to `true` if the path does not specify a namespace. Only the quotas associated with the root namespace are inheritable by default. Requires Vault 1.15+.
        :param pulumi.Input[_builtins.int] interval: The duration in seconds to enforce rate limiting for.
        :param pulumi.Input[_builtins.str] name: Name of the rate limit quota
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured namespace.
               *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.str] path: Path of the mount or namespace to apply the quota. A blank path configures a
               global rate limit quota. For example `namespace1/` adds a quota to a full namespace,
               `namespace1/auth/userpass` adds a `quota` to `userpass` in `namespace1`.
               Updating this field on an existing quota can have "moving" effects. For example, updating
               `auth/userpass` to `namespace1/auth/userpass` moves this quota from being a global mount quota to
               a namespace specific mount quota. **Note, namespaces are supported in Enterprise only.**
        :param pulumi.Input[_builtins.str] role: If set on a quota where `path` is set to an auth mount with a concept of roles (such as /auth/approle/), this will make the quota restrict login requests to that mount that are made with the specified role.
        :param pulumi.Input[_builtins.float] secondary_rate: Can only be set for the `group_by` modes `entity_then_ip` or `entity_then_none`. This is
               the rate limit applied to the requests that fall under the "ip" or "none" groupings, while the authenticated requests
               that contain an entity ID are subject to the `rate` field instead. Defaults to the same value as `rate`.
        """
        pulumi.set(__self__, "rate", rate)
        if block_interval is not None:
            pulumi.set(__self__, "block_interval", block_interval)
        if group_by is not None:
            pulumi.set(__self__, "group_by", group_by)
        if inheritable is not None:
            pulumi.set(__self__, "inheritable", inheritable)
        if interval is not None:
            pulumi.set(__self__, "interval", interval)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if role is not None:
            pulumi.set(__self__, "role", role)
        if secondary_rate is not None:
            pulumi.set(__self__, "secondary_rate", secondary_rate)

    @_builtins.property
    @pulumi.getter
    def rate(self) -> pulumi.Input[_builtins.float]:
        """
        The maximum number of requests at any given second to be allowed by the quota
        rule. The `rate` must be positive.
        """
        return pulumi.get(self, "rate")

    @rate.setter
    def rate(self, value: pulumi.Input[_builtins.float]):
        pulumi.set(self, "rate", value)

    @_builtins.property
    @pulumi.getter(name="blockInterval")
    def block_interval(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        If set, when a client reaches a rate limit threshold, the client will
        be prohibited from any further requests until after the 'block_interval' in seconds has elapsed.
        """
        return pulumi.get(self, "block_interval")

    @block_interval.setter
    def block_interval(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "block_interval", value)

    @_builtins.property
    @pulumi.getter(name="groupBy")
    def group_by(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Attribute used to group requests for rate limiting. Limits are enforced independently for each
        group. Valid `group_by` modes are: 1) `ip` that groups requests by their source IP address (**`group_by` defaults to
        `ip` if unset, which is the only supported mode in community edition**); 2) `none` that groups together all requests
        that match the rate limit quota rule; 3) `entity_then_ip` that groups requests by their entity ID for authenticated
        requests that carry one, or by their IP for unauthenticated requests (or requests whose authentication is not
        connected to an entity); and 4) `entity_then_none` which also groups requests by their entity ID when available, but
        the rest is all grouped together (i.e. unauthenticated or with authentication not connected to an entity).
        """
        return pulumi.get(self, "group_by")

    @group_by.setter
    def group_by(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "group_by", value)

    @_builtins.property
    @pulumi.getter
    def inheritable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If set to `true` on a quota where path is set to a namespace, the same quota will be cumulatively applied to all child namespace. The inheritable parameter cannot be set to `true` if the path does not specify a namespace. Only the quotas associated with the root namespace are inheritable by default. Requires Vault 1.15+.
        """
        return pulumi.get(self, "inheritable")

    @inheritable.setter
    def inheritable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "inheritable", value)

    @_builtins.property
    @pulumi.getter
    def interval(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The duration in seconds to enforce rate limiting for.
        """
        return pulumi.get(self, "interval")

    @interval.setter
    def interval(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "interval", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the rate limit quota
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured namespace.
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Path of the mount or namespace to apply the quota. A blank path configures a
        global rate limit quota. For example `namespace1/` adds a quota to a full namespace,
        `namespace1/auth/userpass` adds a `quota` to `userpass` in `namespace1`.
        Updating this field on an existing quota can have "moving" effects. For example, updating
        `auth/userpass` to `namespace1/auth/userpass` moves this quota from being a global mount quota to
        a namespace specific mount quota. **Note, namespaces are supported in Enterprise only.**
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "path", value)

    @_builtins.property
    @pulumi.getter
    def role(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        If set on a quota where `path` is set to an auth mount with a concept of roles (such as /auth/approle/), this will make the quota restrict login requests to that mount that are made with the specified role.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "role", value)

    @_builtins.property
    @pulumi.getter(name="secondaryRate")
    def secondary_rate(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        Can only be set for the `group_by` modes `entity_then_ip` or `entity_then_none`. This is
        the rate limit applied to the requests that fall under the "ip" or "none" groupings, while the authenticated requests
        that contain an entity ID are subject to the `rate` field instead. Defaults to the same value as `rate`.
        """
        return pulumi.get(self, "secondary_rate")

    @secondary_rate.setter
    def secondary_rate(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "secondary_rate", value)


@pulumi.input_type
class _QuotaRateLimitState:
    def __init__(__self__, *,
                 block_interval: Optional[pulumi.Input[_builtins.int]] = None,
                 group_by: Optional[pulumi.Input[_builtins.str]] = None,
                 inheritable: Optional[pulumi.Input[_builtins.bool]] = None,
                 interval: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 path: Optional[pulumi.Input[_builtins.str]] = None,
                 rate: Optional[pulumi.Input[_builtins.float]] = None,
                 role: Optional[pulumi.Input[_builtins.str]] = None,
                 secondary_rate: Optional[pulumi.Input[_builtins.float]] = None):
        """
        Input properties used for looking up and filtering QuotaRateLimit resources.
        :param pulumi.Input[_builtins.int] block_interval: If set, when a client reaches a rate limit threshold, the client will
               be prohibited from any further requests until after the 'block_interval' in seconds has elapsed.
        :param pulumi.Input[_builtins.str] group_by: Attribute used to group requests for rate limiting. Limits are enforced independently for each
               group. Valid `group_by` modes are: 1) `ip` that groups requests by their source IP address (**`group_by` defaults to
               `ip` if unset, which is the only supported mode in community edition**); 2) `none` that groups together all requests
               that match the rate limit quota rule; 3) `entity_then_ip` that groups requests by their entity ID for authenticated
               requests that carry one, or by their IP for unauthenticated requests (or requests whose authentication is not
               connected to an entity); and 4) `entity_then_none` which also groups requests by their entity ID when available, but
               the rest is all grouped together (i.e. unauthenticated or with authentication not connected to an entity).
        :param pulumi.Input[_builtins.bool] inheritable: If set to `true` on a quota where path is set to a namespace, the same quota will be cumulatively applied to all child namespace. The inheritable parameter cannot be set to `true` if the path does not specify a namespace. Only the quotas associated with the root namespace are inheritable by default. Requires Vault 1.15+.
        :param pulumi.Input[_builtins.int] interval: The duration in seconds to enforce rate limiting for.
        :param pulumi.Input[_builtins.str] name: Name of the rate limit quota
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured namespace.
               *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.str] path: Path of the mount or namespace to apply the quota. A blank path configures a
               global rate limit quota. For example `namespace1/` adds a quota to a full namespace,
               `namespace1/auth/userpass` adds a `quota` to `userpass` in `namespace1`.
               Updating this field on an existing quota can have "moving" effects. For example, updating
               `auth/userpass` to `namespace1/auth/userpass` moves this quota from being a global mount quota to
               a namespace specific mount quota. **Note, namespaces are supported in Enterprise only.**
        :param pulumi.Input[_builtins.float] rate: The maximum number of requests at any given second to be allowed by the quota
               rule. The `rate` must be positive.
        :param pulumi.Input[_builtins.str] role: If set on a quota where `path` is set to an auth mount with a concept of roles (such as /auth/approle/), this will make the quota restrict login requests to that mount that are made with the specified role.
        :param pulumi.Input[_builtins.float] secondary_rate: Can only be set for the `group_by` modes `entity_then_ip` or `entity_then_none`. This is
               the rate limit applied to the requests that fall under the "ip" or "none" groupings, while the authenticated requests
               that contain an entity ID are subject to the `rate` field instead. Defaults to the same value as `rate`.
        """
        if block_interval is not None:
            pulumi.set(__self__, "block_interval", block_interval)
        if group_by is not None:
            pulumi.set(__self__, "group_by", group_by)
        if inheritable is not None:
            pulumi.set(__self__, "inheritable", inheritable)
        if interval is not None:
            pulumi.set(__self__, "interval", interval)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if rate is not None:
            pulumi.set(__self__, "rate", rate)
        if role is not None:
            pulumi.set(__self__, "role", role)
        if secondary_rate is not None:
            pulumi.set(__self__, "secondary_rate", secondary_rate)

    @_builtins.property
    @pulumi.getter(name="blockInterval")
    def block_interval(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        If set, when a client reaches a rate limit threshold, the client will
        be prohibited from any further requests until after the 'block_interval' in seconds has elapsed.
        """
        return pulumi.get(self, "block_interval")

    @block_interval.setter
    def block_interval(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "block_interval", value)

    @_builtins.property
    @pulumi.getter(name="groupBy")
    def group_by(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Attribute used to group requests for rate limiting. Limits are enforced independently for each
        group. Valid `group_by` modes are: 1) `ip` that groups requests by their source IP address (**`group_by` defaults to
        `ip` if unset, which is the only supported mode in community edition**); 2) `none` that groups together all requests
        that match the rate limit quota rule; 3) `entity_then_ip` that groups requests by their entity ID for authenticated
        requests that carry one, or by their IP for unauthenticated requests (or requests whose authentication is not
        connected to an entity); and 4) `entity_then_none` which also groups requests by their entity ID when available, but
        the rest is all grouped together (i.e. unauthenticated or with authentication not connected to an entity).
        """
        return pulumi.get(self, "group_by")

    @group_by.setter
    def group_by(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "group_by", value)

    @_builtins.property
    @pulumi.getter
    def inheritable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If set to `true` on a quota where path is set to a namespace, the same quota will be cumulatively applied to all child namespace. The inheritable parameter cannot be set to `true` if the path does not specify a namespace. Only the quotas associated with the root namespace are inheritable by default. Requires Vault 1.15+.
        """
        return pulumi.get(self, "inheritable")

    @inheritable.setter
    def inheritable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "inheritable", value)

    @_builtins.property
    @pulumi.getter
    def interval(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The duration in seconds to enforce rate limiting for.
        """
        return pulumi.get(self, "interval")

    @interval.setter
    def interval(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "interval", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the rate limit quota
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured namespace.
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Path of the mount or namespace to apply the quota. A blank path configures a
        global rate limit quota. For example `namespace1/` adds a quota to a full namespace,
        `namespace1/auth/userpass` adds a `quota` to `userpass` in `namespace1`.
        Updating this field on an existing quota can have "moving" effects. For example, updating
        `auth/userpass` to `namespace1/auth/userpass` moves this quota from being a global mount quota to
        a namespace specific mount quota. **Note, namespaces are supported in Enterprise only.**
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "path", value)

    @_builtins.property
    @pulumi.getter
    def rate(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        The maximum number of requests at any given second to be allowed by the quota
        rule. The `rate` must be positive.
        """
        return pulumi.get(self, "rate")

    @rate.setter
    def rate(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "rate", value)

    @_builtins.property
    @pulumi.getter
    def role(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        If set on a quota where `path` is set to an auth mount with a concept of roles (such as /auth/approle/), this will make the quota restrict login requests to that mount that are made with the specified role.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "role", value)

    @_builtins.property
    @pulumi.getter(name="secondaryRate")
    def secondary_rate(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        Can only be set for the `group_by` modes `entity_then_ip` or `entity_then_none`. This is
        the rate limit applied to the requests that fall under the "ip" or "none" groupings, while the authenticated requests
        that contain an entity ID are subject to the `rate` field instead. Defaults to the same value as `rate`.
        """
        return pulumi.get(self, "secondary_rate")

    @secondary_rate.setter
    def secondary_rate(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "secondary_rate", value)


@pulumi.type_token("vault:index/quotaRateLimit:QuotaRateLimit")
class QuotaRateLimit(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 block_interval: Optional[pulumi.Input[_builtins.int]] = None,
                 group_by: Optional[pulumi.Input[_builtins.str]] = None,
                 inheritable: Optional[pulumi.Input[_builtins.bool]] = None,
                 interval: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 path: Optional[pulumi.Input[_builtins.str]] = None,
                 rate: Optional[pulumi.Input[_builtins.float]] = None,
                 role: Optional[pulumi.Input[_builtins.str]] = None,
                 secondary_rate: Optional[pulumi.Input[_builtins.float]] = None,
                 __props__=None):
        """
        Manage rate limit quotas which enforce API rate limiting using a token bucket algorithm.
        A rate limit quota can be created at the root level or defined on a namespace or mount by
        specifying a path when creating the quota.

        See [Vault's Documentation](https://www.vaultproject.io/docs/concepts/resource-quotas) for more
        information.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_vault as vault

        global_ = vault.QuotaRateLimit("global",
            name="global",
            path="",
            rate=100)
        ```

        ## Import

        Rate limit quotas can be imported using their names

        ```sh
        $ pulumi import vault:index/quotaRateLimit:QuotaRateLimit global global
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] block_interval: If set, when a client reaches a rate limit threshold, the client will
               be prohibited from any further requests until after the 'block_interval' in seconds has elapsed.
        :param pulumi.Input[_builtins.str] group_by: Attribute used to group requests for rate limiting. Limits are enforced independently for each
               group. Valid `group_by` modes are: 1) `ip` that groups requests by their source IP address (**`group_by` defaults to
               `ip` if unset, which is the only supported mode in community edition**); 2) `none` that groups together all requests
               that match the rate limit quota rule; 3) `entity_then_ip` that groups requests by their entity ID for authenticated
               requests that carry one, or by their IP for unauthenticated requests (or requests whose authentication is not
               connected to an entity); and 4) `entity_then_none` which also groups requests by their entity ID when available, but
               the rest is all grouped together (i.e. unauthenticated or with authentication not connected to an entity).
        :param pulumi.Input[_builtins.bool] inheritable: If set to `true` on a quota where path is set to a namespace, the same quota will be cumulatively applied to all child namespace. The inheritable parameter cannot be set to `true` if the path does not specify a namespace. Only the quotas associated with the root namespace are inheritable by default. Requires Vault 1.15+.
        :param pulumi.Input[_builtins.int] interval: The duration in seconds to enforce rate limiting for.
        :param pulumi.Input[_builtins.str] name: Name of the rate limit quota
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured namespace.
               *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.str] path: Path of the mount or namespace to apply the quota. A blank path configures a
               global rate limit quota. For example `namespace1/` adds a quota to a full namespace,
               `namespace1/auth/userpass` adds a `quota` to `userpass` in `namespace1`.
               Updating this field on an existing quota can have "moving" effects. For example, updating
               `auth/userpass` to `namespace1/auth/userpass` moves this quota from being a global mount quota to
               a namespace specific mount quota. **Note, namespaces are supported in Enterprise only.**
        :param pulumi.Input[_builtins.float] rate: The maximum number of requests at any given second to be allowed by the quota
               rule. The `rate` must be positive.
        :param pulumi.Input[_builtins.str] role: If set on a quota where `path` is set to an auth mount with a concept of roles (such as /auth/approle/), this will make the quota restrict login requests to that mount that are made with the specified role.
        :param pulumi.Input[_builtins.float] secondary_rate: Can only be set for the `group_by` modes `entity_then_ip` or `entity_then_none`. This is
               the rate limit applied to the requests that fall under the "ip" or "none" groupings, while the authenticated requests
               that contain an entity ID are subject to the `rate` field instead. Defaults to the same value as `rate`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: QuotaRateLimitArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manage rate limit quotas which enforce API rate limiting using a token bucket algorithm.
        A rate limit quota can be created at the root level or defined on a namespace or mount by
        specifying a path when creating the quota.

        See [Vault's Documentation](https://www.vaultproject.io/docs/concepts/resource-quotas) for more
        information.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_vault as vault

        global_ = vault.QuotaRateLimit("global",
            name="global",
            path="",
            rate=100)
        ```

        ## Import

        Rate limit quotas can be imported using their names

        ```sh
        $ pulumi import vault:index/quotaRateLimit:QuotaRateLimit global global
        ```

        :param str resource_name: The name of the resource.
        :param QuotaRateLimitArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(QuotaRateLimitArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 block_interval: Optional[pulumi.Input[_builtins.int]] = None,
                 group_by: Optional[pulumi.Input[_builtins.str]] = None,
                 inheritable: Optional[pulumi.Input[_builtins.bool]] = None,
                 interval: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 path: Optional[pulumi.Input[_builtins.str]] = None,
                 rate: Optional[pulumi.Input[_builtins.float]] = None,
                 role: Optional[pulumi.Input[_builtins.str]] = None,
                 secondary_rate: Optional[pulumi.Input[_builtins.float]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = QuotaRateLimitArgs.__new__(QuotaRateLimitArgs)

            __props__.__dict__["block_interval"] = block_interval
            __props__.__dict__["group_by"] = group_by
            __props__.__dict__["inheritable"] = inheritable
            __props__.__dict__["interval"] = interval
            __props__.__dict__["name"] = name
            __props__.__dict__["namespace"] = namespace
            __props__.__dict__["path"] = path
            if rate is None and not opts.urn:
                raise TypeError("Missing required property 'rate'")
            __props__.__dict__["rate"] = rate
            __props__.__dict__["role"] = role
            __props__.__dict__["secondary_rate"] = secondary_rate
        super(QuotaRateLimit, __self__).__init__(
            'vault:index/quotaRateLimit:QuotaRateLimit',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            block_interval: Optional[pulumi.Input[_builtins.int]] = None,
            group_by: Optional[pulumi.Input[_builtins.str]] = None,
            inheritable: Optional[pulumi.Input[_builtins.bool]] = None,
            interval: Optional[pulumi.Input[_builtins.int]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            namespace: Optional[pulumi.Input[_builtins.str]] = None,
            path: Optional[pulumi.Input[_builtins.str]] = None,
            rate: Optional[pulumi.Input[_builtins.float]] = None,
            role: Optional[pulumi.Input[_builtins.str]] = None,
            secondary_rate: Optional[pulumi.Input[_builtins.float]] = None) -> 'QuotaRateLimit':
        """
        Get an existing QuotaRateLimit resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] block_interval: If set, when a client reaches a rate limit threshold, the client will
               be prohibited from any further requests until after the 'block_interval' in seconds has elapsed.
        :param pulumi.Input[_builtins.str] group_by: Attribute used to group requests for rate limiting. Limits are enforced independently for each
               group. Valid `group_by` modes are: 1) `ip` that groups requests by their source IP address (**`group_by` defaults to
               `ip` if unset, which is the only supported mode in community edition**); 2) `none` that groups together all requests
               that match the rate limit quota rule; 3) `entity_then_ip` that groups requests by their entity ID for authenticated
               requests that carry one, or by their IP for unauthenticated requests (or requests whose authentication is not
               connected to an entity); and 4) `entity_then_none` which also groups requests by their entity ID when available, but
               the rest is all grouped together (i.e. unauthenticated or with authentication not connected to an entity).
        :param pulumi.Input[_builtins.bool] inheritable: If set to `true` on a quota where path is set to a namespace, the same quota will be cumulatively applied to all child namespace. The inheritable parameter cannot be set to `true` if the path does not specify a namespace. Only the quotas associated with the root namespace are inheritable by default. Requires Vault 1.15+.
        :param pulumi.Input[_builtins.int] interval: The duration in seconds to enforce rate limiting for.
        :param pulumi.Input[_builtins.str] name: Name of the rate limit quota
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured namespace.
               *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.str] path: Path of the mount or namespace to apply the quota. A blank path configures a
               global rate limit quota. For example `namespace1/` adds a quota to a full namespace,
               `namespace1/auth/userpass` adds a `quota` to `userpass` in `namespace1`.
               Updating this field on an existing quota can have "moving" effects. For example, updating
               `auth/userpass` to `namespace1/auth/userpass` moves this quota from being a global mount quota to
               a namespace specific mount quota. **Note, namespaces are supported in Enterprise only.**
        :param pulumi.Input[_builtins.float] rate: The maximum number of requests at any given second to be allowed by the quota
               rule. The `rate` must be positive.
        :param pulumi.Input[_builtins.str] role: If set on a quota where `path` is set to an auth mount with a concept of roles (such as /auth/approle/), this will make the quota restrict login requests to that mount that are made with the specified role.
        :param pulumi.Input[_builtins.float] secondary_rate: Can only be set for the `group_by` modes `entity_then_ip` or `entity_then_none`. This is
               the rate limit applied to the requests that fall under the "ip" or "none" groupings, while the authenticated requests
               that contain an entity ID are subject to the `rate` field instead. Defaults to the same value as `rate`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _QuotaRateLimitState.__new__(_QuotaRateLimitState)

        __props__.__dict__["block_interval"] = block_interval
        __props__.__dict__["group_by"] = group_by
        __props__.__dict__["inheritable"] = inheritable
        __props__.__dict__["interval"] = interval
        __props__.__dict__["name"] = name
        __props__.__dict__["namespace"] = namespace
        __props__.__dict__["path"] = path
        __props__.__dict__["rate"] = rate
        __props__.__dict__["role"] = role
        __props__.__dict__["secondary_rate"] = secondary_rate
        return QuotaRateLimit(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="blockInterval")
    def block_interval(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        If set, when a client reaches a rate limit threshold, the client will
        be prohibited from any further requests until after the 'block_interval' in seconds has elapsed.
        """
        return pulumi.get(self, "block_interval")

    @_builtins.property
    @pulumi.getter(name="groupBy")
    def group_by(self) -> pulumi.Output[_builtins.str]:
        """
        Attribute used to group requests for rate limiting. Limits are enforced independently for each
        group. Valid `group_by` modes are: 1) `ip` that groups requests by their source IP address (**`group_by` defaults to
        `ip` if unset, which is the only supported mode in community edition**); 2) `none` that groups together all requests
        that match the rate limit quota rule; 3) `entity_then_ip` that groups requests by their entity ID for authenticated
        requests that carry one, or by their IP for unauthenticated requests (or requests whose authentication is not
        connected to an entity); and 4) `entity_then_none` which also groups requests by their entity ID when available, but
        the rest is all grouped together (i.e. unauthenticated or with authentication not connected to an entity).
        """
        return pulumi.get(self, "group_by")

    @_builtins.property
    @pulumi.getter
    def inheritable(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        If set to `true` on a quota where path is set to a namespace, the same quota will be cumulatively applied to all child namespace. The inheritable parameter cannot be set to `true` if the path does not specify a namespace. Only the quotas associated with the root namespace are inheritable by default. Requires Vault 1.15+.
        """
        return pulumi.get(self, "inheritable")

    @_builtins.property
    @pulumi.getter
    def interval(self) -> pulumi.Output[_builtins.int]:
        """
        The duration in seconds to enforce rate limiting for.
        """
        return pulumi.get(self, "interval")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the rate limit quota
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured namespace.
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter
    def path(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Path of the mount or namespace to apply the quota. A blank path configures a
        global rate limit quota. For example `namespace1/` adds a quota to a full namespace,
        `namespace1/auth/userpass` adds a `quota` to `userpass` in `namespace1`.
        Updating this field on an existing quota can have "moving" effects. For example, updating
        `auth/userpass` to `namespace1/auth/userpass` moves this quota from being a global mount quota to
        a namespace specific mount quota. **Note, namespaces are supported in Enterprise only.**
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter
    def rate(self) -> pulumi.Output[_builtins.float]:
        """
        The maximum number of requests at any given second to be allowed by the quota
        rule. The `rate` must be positive.
        """
        return pulumi.get(self, "rate")

    @_builtins.property
    @pulumi.getter
    def role(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        If set on a quota where `path` is set to an auth mount with a concept of roles (such as /auth/approle/), this will make the quota restrict login requests to that mount that are made with the specified role.
        """
        return pulumi.get(self, "role")

    @_builtins.property
    @pulumi.getter(name="secondaryRate")
    def secondary_rate(self) -> pulumi.Output[_builtins.float]:
        """
        Can only be set for the `group_by` modes `entity_then_ip` or `entity_then_none`. This is
        the rate limit applied to the requests that fall under the "ip" or "none" groupings, while the authenticated requests
        that contain an entity ID are subject to the `rate` field instead. Defaults to the same value as `rate`.
        """
        return pulumi.get(self, "secondary_rate")

