# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SyncAssociationArgs', 'SyncAssociation']

@pulumi.input_type
class SyncAssociationArgs:
    def __init__(__self__, *,
                 mount: pulumi.Input[_builtins.str],
                 secret_name: pulumi.Input[_builtins.str],
                 type: pulumi.Input[_builtins.str],
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a SyncAssociation resource.
        :param pulumi.Input[_builtins.str] mount: Specifies the mount where the secret is located.
        :param pulumi.Input[_builtins.str] secret_name: Specifies the name of the secret to synchronize.
        :param pulumi.Input[_builtins.str] type: Specifies the destination type.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the destination.
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        """
        pulumi.set(__self__, "mount", mount)
        pulumi.set(__self__, "secret_name", secret_name)
        pulumi.set(__self__, "type", type)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)

    @_builtins.property
    @pulumi.getter
    def mount(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the mount where the secret is located.
        """
        return pulumi.get(self, "mount")

    @mount.setter
    def mount(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "mount", value)

    @_builtins.property
    @pulumi.getter(name="secretName")
    def secret_name(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the name of the secret to synchronize.
        """
        return pulumi.get(self, "secret_name")

    @secret_name.setter
    def secret_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "secret_name", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the destination type.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the destination.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)


@pulumi.input_type
class _SyncAssociationState:
    def __init__(__self__, *,
                 metadatas: Optional[pulumi.Input[Sequence[pulumi.Input['SyncAssociationMetadataArgs']]]] = None,
                 mount: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_name: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering SyncAssociation resources.
        :param pulumi.Input[Sequence[pulumi.Input['SyncAssociationMetadataArgs']]] metadatas: Metadata for each subkey of the associated secret.
        :param pulumi.Input[_builtins.str] mount: Specifies the mount where the secret is located.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the destination.
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        :param pulumi.Input[_builtins.str] secret_name: Specifies the name of the secret to synchronize.
        :param pulumi.Input[_builtins.str] type: Specifies the destination type.
        """
        if metadatas is not None:
            pulumi.set(__self__, "metadatas", metadatas)
        if mount is not None:
            pulumi.set(__self__, "mount", mount)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if secret_name is not None:
            pulumi.set(__self__, "secret_name", secret_name)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def metadatas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SyncAssociationMetadataArgs']]]]:
        """
        Metadata for each subkey of the associated secret.
        """
        return pulumi.get(self, "metadatas")

    @metadatas.setter
    def metadatas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SyncAssociationMetadataArgs']]]]):
        pulumi.set(self, "metadatas", value)

    @_builtins.property
    @pulumi.getter
    def mount(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the mount where the secret is located.
        """
        return pulumi.get(self, "mount")

    @mount.setter
    def mount(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mount", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the destination.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter(name="secretName")
    def secret_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the secret to synchronize.
        """
        return pulumi.get(self, "secret_name")

    @secret_name.setter
    def secret_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secret_name", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the destination type.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.type_token("vault:secrets/syncAssociation:SyncAssociation")
class SyncAssociation(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 mount: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_name: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import json
        import pulumi_vault as vault

        kvv2 = vault.Mount("kvv2",
            path="kvv2",
            type="kv",
            options={
                "version": "2",
            },
            description="KV Version 2 secret engine mount")
        token = vault.kv.SecretV2("token",
            mount=kvv2.path,
            name="token",
            data_json=json.dumps({
                "dev": "B!gS3cr3t",
                "prod": "S3cureP4$$",
            }))
        gh = vault.secrets.SyncGhDestination("gh",
            name="gh-dest",
            access_token=access_token,
            repository_owner=repo_owner,
            repository_name="repo-name-example",
            secret_name_template="vault_{{ .MountAccessor | lowercase }}_{{ .SecretPath | lowercase }}")
        gh_token = vault.secrets.SyncAssociation("gh_token",
            name=gh.name,
            type=gh.type,
            mount=kvv2.path,
            secret_name=token.name)
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] mount: Specifies the mount where the secret is located.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the destination.
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        :param pulumi.Input[_builtins.str] secret_name: Specifies the name of the secret to synchronize.
        :param pulumi.Input[_builtins.str] type: Specifies the destination type.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SyncAssociationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import json
        import pulumi_vault as vault

        kvv2 = vault.Mount("kvv2",
            path="kvv2",
            type="kv",
            options={
                "version": "2",
            },
            description="KV Version 2 secret engine mount")
        token = vault.kv.SecretV2("token",
            mount=kvv2.path,
            name="token",
            data_json=json.dumps({
                "dev": "B!gS3cr3t",
                "prod": "S3cureP4$$",
            }))
        gh = vault.secrets.SyncGhDestination("gh",
            name="gh-dest",
            access_token=access_token,
            repository_owner=repo_owner,
            repository_name="repo-name-example",
            secret_name_template="vault_{{ .MountAccessor | lowercase }}_{{ .SecretPath | lowercase }}")
        gh_token = vault.secrets.SyncAssociation("gh_token",
            name=gh.name,
            type=gh.type,
            mount=kvv2.path,
            secret_name=token.name)
        ```

        :param str resource_name: The name of the resource.
        :param SyncAssociationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SyncAssociationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 mount: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_name: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SyncAssociationArgs.__new__(SyncAssociationArgs)

            if mount is None and not opts.urn:
                raise TypeError("Missing required property 'mount'")
            __props__.__dict__["mount"] = mount
            __props__.__dict__["name"] = name
            __props__.__dict__["namespace"] = namespace
            if secret_name is None and not opts.urn:
                raise TypeError("Missing required property 'secret_name'")
            __props__.__dict__["secret_name"] = secret_name
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["metadatas"] = None
        super(SyncAssociation, __self__).__init__(
            'vault:secrets/syncAssociation:SyncAssociation',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            metadatas: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SyncAssociationMetadataArgs', 'SyncAssociationMetadataArgsDict']]]]] = None,
            mount: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            namespace: Optional[pulumi.Input[_builtins.str]] = None,
            secret_name: Optional[pulumi.Input[_builtins.str]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None) -> 'SyncAssociation':
        """
        Get an existing SyncAssociation resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SyncAssociationMetadataArgs', 'SyncAssociationMetadataArgsDict']]]] metadatas: Metadata for each subkey of the associated secret.
        :param pulumi.Input[_builtins.str] mount: Specifies the mount where the secret is located.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the destination.
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        :param pulumi.Input[_builtins.str] secret_name: Specifies the name of the secret to synchronize.
        :param pulumi.Input[_builtins.str] type: Specifies the destination type.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SyncAssociationState.__new__(_SyncAssociationState)

        __props__.__dict__["metadatas"] = metadatas
        __props__.__dict__["mount"] = mount
        __props__.__dict__["name"] = name
        __props__.__dict__["namespace"] = namespace
        __props__.__dict__["secret_name"] = secret_name
        __props__.__dict__["type"] = type
        return SyncAssociation(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def metadatas(self) -> pulumi.Output[Sequence['outputs.SyncAssociationMetadata']]:
        """
        Metadata for each subkey of the associated secret.
        """
        return pulumi.get(self, "metadatas")

    @_builtins.property
    @pulumi.getter
    def mount(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the mount where the secret is located.
        """
        return pulumi.get(self, "mount")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the destination.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter(name="secretName")
    def secret_name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the secret to synchronize.
        """
        return pulumi.get(self, "secret_name")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the destination type.
        """
        return pulumi.get(self, "type")

