# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['SyncVercelDestinationArgs', 'SyncVercelDestination']

@pulumi.input_type
class SyncVercelDestinationArgs:
    def __init__(__self__, *,
                 access_token: pulumi.Input[_builtins.str],
                 deployment_environments: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 project_id: pulumi.Input[_builtins.str],
                 granularity: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_name_template: Optional[pulumi.Input[_builtins.str]] = None,
                 team_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a SyncVercelDestination resource.
        :param pulumi.Input[_builtins.str] access_token: Vercel API access token with the permissions to manage environment
               variables.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] deployment_environments: Deployment environments where the environment variables
               are available. Accepts `development`, `preview` and `production`.
        :param pulumi.Input[_builtins.str] project_id: Project ID where to manage environment variables.
        :param pulumi.Input[_builtins.str] granularity: Determines what level of information is synced as a distinct resource
               at the destination. Supports `secret-path` and `secret-key`.
        :param pulumi.Input[_builtins.str] name: Unique name of the GitHub destination.
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        :param pulumi.Input[_builtins.str] secret_name_template: Template describing how to generate external secret names.
               Supports a subset of the Go Template syntax.
        :param pulumi.Input[_builtins.str] team_id: Team ID where to manage environment variables.
        """
        pulumi.set(__self__, "access_token", access_token)
        pulumi.set(__self__, "deployment_environments", deployment_environments)
        pulumi.set(__self__, "project_id", project_id)
        if granularity is not None:
            pulumi.set(__self__, "granularity", granularity)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if secret_name_template is not None:
            pulumi.set(__self__, "secret_name_template", secret_name_template)
        if team_id is not None:
            pulumi.set(__self__, "team_id", team_id)

    @_builtins.property
    @pulumi.getter(name="accessToken")
    def access_token(self) -> pulumi.Input[_builtins.str]:
        """
        Vercel API access token with the permissions to manage environment
        variables.
        """
        return pulumi.get(self, "access_token")

    @access_token.setter
    def access_token(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "access_token", value)

    @_builtins.property
    @pulumi.getter(name="deploymentEnvironments")
    def deployment_environments(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        Deployment environments where the environment variables
        are available. Accepts `development`, `preview` and `production`.
        """
        return pulumi.get(self, "deployment_environments")

    @deployment_environments.setter
    def deployment_environments(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "deployment_environments", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[_builtins.str]:
        """
        Project ID where to manage environment variables.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter
    def granularity(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Determines what level of information is synced as a distinct resource
        at the destination. Supports `secret-path` and `secret-key`.
        """
        return pulumi.get(self, "granularity")

    @granularity.setter
    def granularity(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "granularity", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique name of the GitHub destination.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter(name="secretNameTemplate")
    def secret_name_template(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Template describing how to generate external secret names.
        Supports a subset of the Go Template syntax.
        """
        return pulumi.get(self, "secret_name_template")

    @secret_name_template.setter
    def secret_name_template(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secret_name_template", value)

    @_builtins.property
    @pulumi.getter(name="teamId")
    def team_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Team ID where to manage environment variables.
        """
        return pulumi.get(self, "team_id")

    @team_id.setter
    def team_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "team_id", value)


@pulumi.input_type
class _SyncVercelDestinationState:
    def __init__(__self__, *,
                 access_token: Optional[pulumi.Input[_builtins.str]] = None,
                 deployment_environments: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 granularity: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_name_template: Optional[pulumi.Input[_builtins.str]] = None,
                 team_id: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering SyncVercelDestination resources.
        :param pulumi.Input[_builtins.str] access_token: Vercel API access token with the permissions to manage environment
               variables.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] deployment_environments: Deployment environments where the environment variables
               are available. Accepts `development`, `preview` and `production`.
        :param pulumi.Input[_builtins.str] granularity: Determines what level of information is synced as a distinct resource
               at the destination. Supports `secret-path` and `secret-key`.
        :param pulumi.Input[_builtins.str] name: Unique name of the GitHub destination.
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        :param pulumi.Input[_builtins.str] project_id: Project ID where to manage environment variables.
        :param pulumi.Input[_builtins.str] secret_name_template: Template describing how to generate external secret names.
               Supports a subset of the Go Template syntax.
        :param pulumi.Input[_builtins.str] team_id: Team ID where to manage environment variables.
        :param pulumi.Input[_builtins.str] type: The type of the secrets destination (`vercel-project`).
        """
        if access_token is not None:
            pulumi.set(__self__, "access_token", access_token)
        if deployment_environments is not None:
            pulumi.set(__self__, "deployment_environments", deployment_environments)
        if granularity is not None:
            pulumi.set(__self__, "granularity", granularity)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if secret_name_template is not None:
            pulumi.set(__self__, "secret_name_template", secret_name_template)
        if team_id is not None:
            pulumi.set(__self__, "team_id", team_id)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="accessToken")
    def access_token(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Vercel API access token with the permissions to manage environment
        variables.
        """
        return pulumi.get(self, "access_token")

    @access_token.setter
    def access_token(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "access_token", value)

    @_builtins.property
    @pulumi.getter(name="deploymentEnvironments")
    def deployment_environments(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Deployment environments where the environment variables
        are available. Accepts `development`, `preview` and `production`.
        """
        return pulumi.get(self, "deployment_environments")

    @deployment_environments.setter
    def deployment_environments(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "deployment_environments", value)

    @_builtins.property
    @pulumi.getter
    def granularity(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Determines what level of information is synced as a distinct resource
        at the destination. Supports `secret-path` and `secret-key`.
        """
        return pulumi.get(self, "granularity")

    @granularity.setter
    def granularity(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "granularity", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique name of the GitHub destination.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Project ID where to manage environment variables.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter(name="secretNameTemplate")
    def secret_name_template(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Template describing how to generate external secret names.
        Supports a subset of the Go Template syntax.
        """
        return pulumi.get(self, "secret_name_template")

    @secret_name_template.setter
    def secret_name_template(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secret_name_template", value)

    @_builtins.property
    @pulumi.getter(name="teamId")
    def team_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Team ID where to manage environment variables.
        """
        return pulumi.get(self, "team_id")

    @team_id.setter
    def team_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "team_id", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the secrets destination (`vercel-project`).
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.type_token("vault:secrets/syncVercelDestination:SyncVercelDestination")
class SyncVercelDestination(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_token: Optional[pulumi.Input[_builtins.str]] = None,
                 deployment_environments: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 granularity: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_name_template: Optional[pulumi.Input[_builtins.str]] = None,
                 team_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_vault as vault

        vercel = vault.secrets.SyncVercelDestination("vercel",
            name="vercel-dest",
            access_token=access_token,
            project_id=project_id,
            deployment_environments=[
                "development",
                "preview",
                "production",
            ],
            secret_name_template="vault_{{ .MountAccessor | lowercase }}_{{ .SecretPath | lowercase }}")
        ```

        ## Import

        GitHub Secrets sync destinations can be imported using the `name`, e.g.

        ```sh
        $ pulumi import vault:secrets/syncVercelDestination:SyncVercelDestination vercel vercel-dest
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] access_token: Vercel API access token with the permissions to manage environment
               variables.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] deployment_environments: Deployment environments where the environment variables
               are available. Accepts `development`, `preview` and `production`.
        :param pulumi.Input[_builtins.str] granularity: Determines what level of information is synced as a distinct resource
               at the destination. Supports `secret-path` and `secret-key`.
        :param pulumi.Input[_builtins.str] name: Unique name of the GitHub destination.
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        :param pulumi.Input[_builtins.str] project_id: Project ID where to manage environment variables.
        :param pulumi.Input[_builtins.str] secret_name_template: Template describing how to generate external secret names.
               Supports a subset of the Go Template syntax.
        :param pulumi.Input[_builtins.str] team_id: Team ID where to manage environment variables.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SyncVercelDestinationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_vault as vault

        vercel = vault.secrets.SyncVercelDestination("vercel",
            name="vercel-dest",
            access_token=access_token,
            project_id=project_id,
            deployment_environments=[
                "development",
                "preview",
                "production",
            ],
            secret_name_template="vault_{{ .MountAccessor | lowercase }}_{{ .SecretPath | lowercase }}")
        ```

        ## Import

        GitHub Secrets sync destinations can be imported using the `name`, e.g.

        ```sh
        $ pulumi import vault:secrets/syncVercelDestination:SyncVercelDestination vercel vercel-dest
        ```

        :param str resource_name: The name of the resource.
        :param SyncVercelDestinationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SyncVercelDestinationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_token: Optional[pulumi.Input[_builtins.str]] = None,
                 deployment_environments: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 granularity: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_name_template: Optional[pulumi.Input[_builtins.str]] = None,
                 team_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SyncVercelDestinationArgs.__new__(SyncVercelDestinationArgs)

            if access_token is None and not opts.urn:
                raise TypeError("Missing required property 'access_token'")
            __props__.__dict__["access_token"] = None if access_token is None else pulumi.Output.secret(access_token)
            if deployment_environments is None and not opts.urn:
                raise TypeError("Missing required property 'deployment_environments'")
            __props__.__dict__["deployment_environments"] = deployment_environments
            __props__.__dict__["granularity"] = granularity
            __props__.__dict__["name"] = name
            __props__.__dict__["namespace"] = namespace
            if project_id is None and not opts.urn:
                raise TypeError("Missing required property 'project_id'")
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["secret_name_template"] = secret_name_template
            __props__.__dict__["team_id"] = team_id
            __props__.__dict__["type"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["accessToken"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(SyncVercelDestination, __self__).__init__(
            'vault:secrets/syncVercelDestination:SyncVercelDestination',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_token: Optional[pulumi.Input[_builtins.str]] = None,
            deployment_environments: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            granularity: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            namespace: Optional[pulumi.Input[_builtins.str]] = None,
            project_id: Optional[pulumi.Input[_builtins.str]] = None,
            secret_name_template: Optional[pulumi.Input[_builtins.str]] = None,
            team_id: Optional[pulumi.Input[_builtins.str]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None) -> 'SyncVercelDestination':
        """
        Get an existing SyncVercelDestination resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] access_token: Vercel API access token with the permissions to manage environment
               variables.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] deployment_environments: Deployment environments where the environment variables
               are available. Accepts `development`, `preview` and `production`.
        :param pulumi.Input[_builtins.str] granularity: Determines what level of information is synced as a distinct resource
               at the destination. Supports `secret-path` and `secret-key`.
        :param pulumi.Input[_builtins.str] name: Unique name of the GitHub destination.
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        :param pulumi.Input[_builtins.str] project_id: Project ID where to manage environment variables.
        :param pulumi.Input[_builtins.str] secret_name_template: Template describing how to generate external secret names.
               Supports a subset of the Go Template syntax.
        :param pulumi.Input[_builtins.str] team_id: Team ID where to manage environment variables.
        :param pulumi.Input[_builtins.str] type: The type of the secrets destination (`vercel-project`).
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SyncVercelDestinationState.__new__(_SyncVercelDestinationState)

        __props__.__dict__["access_token"] = access_token
        __props__.__dict__["deployment_environments"] = deployment_environments
        __props__.__dict__["granularity"] = granularity
        __props__.__dict__["name"] = name
        __props__.__dict__["namespace"] = namespace
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["secret_name_template"] = secret_name_template
        __props__.__dict__["team_id"] = team_id
        __props__.__dict__["type"] = type
        return SyncVercelDestination(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accessToken")
    def access_token(self) -> pulumi.Output[_builtins.str]:
        """
        Vercel API access token with the permissions to manage environment
        variables.
        """
        return pulumi.get(self, "access_token")

    @_builtins.property
    @pulumi.getter(name="deploymentEnvironments")
    def deployment_environments(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Deployment environments where the environment variables
        are available. Accepts `development`, `preview` and `production`.
        """
        return pulumi.get(self, "deployment_environments")

    @_builtins.property
    @pulumi.getter
    def granularity(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Determines what level of information is synced as a distinct resource
        at the destination. Supports `secret-path` and `secret-key`.
        """
        return pulumi.get(self, "granularity")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Unique name of the GitHub destination.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[_builtins.str]:
        """
        Project ID where to manage environment variables.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter(name="secretNameTemplate")
    def secret_name_template(self) -> pulumi.Output[_builtins.str]:
        """
        Template describing how to generate external secret names.
        Supports a subset of the Go Template syntax.
        """
        return pulumi.get(self, "secret_name_template")

    @_builtins.property
    @pulumi.getter(name="teamId")
    def team_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Team ID where to manage environment variables.
        """
        return pulumi.get(self, "team_id")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of the secrets destination (`vercel-project`).
        """
        return pulumi.get(self, "type")

