"""
German translations.

Contains German translations for all LaTeX/SymPy strings used in keecas.
"""

TRANSLATIONS = {
    # SymPy LaTeX words
    "for": "für",
    "otherwise": "andernfalls",
    # Domain/Range labels from SymPy LaTeX output
    "Domain: ": "Definitionsbereich: ",
    "Domain on ": "Definitionsbereich auf ",
    "Range": "Bereich",
    # Boolean verification states
    "VERIFIED": "BESTÄTIGT",
    "NOT_VERIFIED": "NICHT BESTÄTIGT",
    # Common mathematical terms
    "True": "Wahr",
    "False": "Falsch",
    # Additional terms that might be useful
    "if": "wenn",
    "then": "dann",
    "else": "sonst",
    "and": "und",
    "or": "oder",
    "not": "nicht",
}

# Export for easier access
__all__ = ["TRANSLATIONS"]
