"""
Italian translations.

Contains Italian translations for all LaTeX/SymPy strings used in keecas.
"""

TRANSLATIONS = {
    # SymPy LaTeX words
    "for": "per",
    "otherwise": "altrimenti",
    # Domain/Range labels from SymPy LaTeX output
    "Domain: ": "Dominio: ",
    "Domain on ": "Dominio su ",
    "Range": "Intervallo",
    # Boolean verification states
    "VERIFIED": "VERIFICATO",
    "NOT_VERIFIED": "NON VERIFICATO",
    # Common mathematical terms
    "True": "Vero",
    "False": "Falso",
    # Additional terms that might be useful
    "if": "se",
    "then": "allora",
    "else": "altrimenti",
    "and": "e",
    "or": "o",
    "not": "non",
}

# Export for easier access
__all__ = ["TRANSLATIONS"]
