"""
Dutch translations.

Contains Dutch translations for all LaTeX/SymPy strings used in keecas.
"""

TRANSLATIONS = {
    # SymPy LaTeX words
    "for": "voor",
    "otherwise": "anders",
    # Domain/Range labels from SymPy LaTeX output
    "Domain: ": "Domein: ",
    "Domain on ": "Domein op ",
    "Range": "Bereik",
    # Boolean verification states
    "VERIFIED": "GEVERIFIEERD",
    "NOT_VERIFIED": "NIET GEVERIFIEERD",
    # Common mathematical terms
    "True": "Waar",
    "False": "Onwaar",
    # Additional terms that might be useful
    "if": "als",
    "then": "dan",
    "else": "anders",
    "and": "en",
    "or": "of",
    "not": "niet",
}

# Export for easier access
__all__ = ["TRANSLATIONS"]
