# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/00_core.ipynb.

# %% auto 0
__all__ = ['FileContent', 'DEFAULT_FILTER_PATTERN', 'ONLY_HTML', 'DownloadStorage', 'Downloader']

# %% ../nbs/00_core.ipynb 3
import tempfile
import shutil
from pathlib import Path
from glob import glob
from typing import Optional
from collections import namedtuple
from sec_edgar_downloader import Downloader as SecEdgarDownloader

# %% ../nbs/00_core.ipynb 4
FileContent = namedtuple("FileContent", ["path", "content"])
DEFAULT_FILTER_PATTERN = "**/*.*"


class DownloadStorage:
    def __init__(self, *, filter_pattern: Optional[str] = None):
        self.glob_pattern = filter_pattern or DEFAULT_FILTER_PATTERN
        self.temp_dir = None
        self.file_contents = None

    def __enter__(self):
        self.temp_dir = tempfile.mkdtemp()
        return self.temp_dir

    def __exit__(self, exc_type, exc_val, exc_tb):
        self._read_files()
        if self.temp_dir:
            shutil.rmtree(self.temp_dir)

    def _read_files(self):
        self.file_contents = []
        glob_path = Path(self.temp_dir) / self.glob_pattern
        for filepath in glob(str(glob_path), recursive=True):
            path = Path(filepath)
            relative_path = path.relative_to(self.temp_dir)
            with open(filepath, "r", encoding="utf-8", errors="ignore") as f:
                content = f.read()
            self.file_contents.append(FileContent(relative_path, content))

    def get_file_contents(self):
        if self.file_contents is None:
            raise RuntimeError(
                "File contents are not available until the context is exited."
            )
        return self.file_contents

# %% ../nbs/00_core.ipynb 5
ONLY_HTML = "**/*.htm*"


class Downloader:
    def __init__(
        self,
        company_name: str,
        email_address: str,
    ):
        self.company_name = company_name
        self.email_address = email_address

    def get_latest_html(self, doc_type: str, ticker: str):
        storage = DownloadStorage(filter_pattern=ONLY_HTML)
        with storage as path:
            dl = SecEdgarDownloader(self.company_name, self.email_address, path)
            dl.get("10-Q", "AAPL", limit=1, download_details=True)
        return storage.get_file_contents()[0].content
