# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['LoadBalancerArgs', 'LoadBalancer']

@pulumi.input_type
class LoadBalancerArgs:
    def __init__(__self__, *,
                 address_type: pulumi.Input[_builtins.str],
                 load_balancer_billing_config: pulumi.Input['LoadBalancerLoadBalancerBillingConfigArgs'],
                 load_balancer_edition: pulumi.Input[_builtins.str],
                 vpc_id: pulumi.Input[_builtins.str],
                 zone_mappings: pulumi.Input[Sequence[pulumi.Input['LoadBalancerZoneMappingArgs']]],
                 access_log_config: Optional[pulumi.Input['LoadBalancerAccessLogConfigArgs']] = None,
                 address_allocated_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 address_ip_version: Optional[pulumi.Input[_builtins.str]] = None,
                 bandwidth_package_id: Optional[pulumi.Input[_builtins.str]] = None,
                 deletion_protection_config: Optional[pulumi.Input['LoadBalancerDeletionProtectionConfigArgs']] = None,
                 deletion_protection_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 dry_run: Optional[pulumi.Input[_builtins.bool]] = None,
                 ipv6_address_type: Optional[pulumi.Input[_builtins.str]] = None,
                 load_balancer_name: Optional[pulumi.Input[_builtins.str]] = None,
                 modification_protection_config: Optional[pulumi.Input['LoadBalancerModificationProtectionConfigArgs']] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a LoadBalancer resource.
        :param pulumi.Input[_builtins.str] address_type: The type of IP address that the SLB instance uses to provide services.
        :param pulumi.Input['LoadBalancerLoadBalancerBillingConfigArgs'] load_balancer_billing_config: The configuration of the billing method. See `load_balancer_billing_config` below.
        :param pulumi.Input[_builtins.str] load_balancer_edition: The edition of the ALB instance.
        :param pulumi.Input[_builtins.str] vpc_id: The ID of the virtual private cloud (VPC) where the SLB instance is deployed.
        :param pulumi.Input[Sequence[pulumi.Input['LoadBalancerZoneMappingArgs']]] zone_mappings: The zones and vSwitches. You must specify at least two zones. See `zone_mappings` below.
        :param pulumi.Input['LoadBalancerAccessLogConfigArgs'] access_log_config: The configuration of the access log. See `access_log_config` below.
        :param pulumi.Input[_builtins.str] address_allocated_mode: The method in which IP addresses are assigned. Valid values:  Fixed: The ALB instance uses a fixed IP address. Dynamic (default): An IP address is dynamically assigned to each zone of the ALB instance.
        :param pulumi.Input[_builtins.str] address_ip_version: The protocol version. Value:
               - `IPv4`:IPv4 type.
               - `DualStack`: the dual-stack type.
        :param pulumi.Input[_builtins.str] bandwidth_package_id: The ID of the EIP bandwidth plan which is associated with an ALB instance that uses a public IP address.
        :param pulumi.Input['LoadBalancerDeletionProtectionConfigArgs'] deletion_protection_config: The Protection Configuration See `deletion_protection_config` below.
        :param pulumi.Input[_builtins.bool] deletion_protection_enabled: Specifies whether to enable deletion protection. Default value: `false`. Valid values:
        :param pulumi.Input[_builtins.bool] dry_run: Whether to PreCheck only this request, value:
        :param pulumi.Input[_builtins.str] ipv6_address_type: The address type of Ipv6
        :param pulumi.Input[_builtins.str] load_balancer_name: The name of the resource
        :param pulumi.Input['LoadBalancerModificationProtectionConfigArgs'] modification_protection_config: Modify the Protection Configuration See `modification_protection_config` below.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tag of the resource
        """
        pulumi.set(__self__, "address_type", address_type)
        pulumi.set(__self__, "load_balancer_billing_config", load_balancer_billing_config)
        pulumi.set(__self__, "load_balancer_edition", load_balancer_edition)
        pulumi.set(__self__, "vpc_id", vpc_id)
        pulumi.set(__self__, "zone_mappings", zone_mappings)
        if access_log_config is not None:
            pulumi.set(__self__, "access_log_config", access_log_config)
        if address_allocated_mode is not None:
            pulumi.set(__self__, "address_allocated_mode", address_allocated_mode)
        if address_ip_version is not None:
            pulumi.set(__self__, "address_ip_version", address_ip_version)
        if bandwidth_package_id is not None:
            pulumi.set(__self__, "bandwidth_package_id", bandwidth_package_id)
        if deletion_protection_config is not None:
            pulumi.set(__self__, "deletion_protection_config", deletion_protection_config)
        if deletion_protection_enabled is not None:
            pulumi.set(__self__, "deletion_protection_enabled", deletion_protection_enabled)
        if dry_run is not None:
            pulumi.set(__self__, "dry_run", dry_run)
        if ipv6_address_type is not None:
            pulumi.set(__self__, "ipv6_address_type", ipv6_address_type)
        if load_balancer_name is not None:
            pulumi.set(__self__, "load_balancer_name", load_balancer_name)
        if modification_protection_config is not None:
            pulumi.set(__self__, "modification_protection_config", modification_protection_config)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="addressType")
    def address_type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of IP address that the SLB instance uses to provide services.
        """
        return pulumi.get(self, "address_type")

    @address_type.setter
    def address_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "address_type", value)

    @_builtins.property
    @pulumi.getter(name="loadBalancerBillingConfig")
    def load_balancer_billing_config(self) -> pulumi.Input['LoadBalancerLoadBalancerBillingConfigArgs']:
        """
        The configuration of the billing method. See `load_balancer_billing_config` below.
        """
        return pulumi.get(self, "load_balancer_billing_config")

    @load_balancer_billing_config.setter
    def load_balancer_billing_config(self, value: pulumi.Input['LoadBalancerLoadBalancerBillingConfigArgs']):
        pulumi.set(self, "load_balancer_billing_config", value)

    @_builtins.property
    @pulumi.getter(name="loadBalancerEdition")
    def load_balancer_edition(self) -> pulumi.Input[_builtins.str]:
        """
        The edition of the ALB instance.
        """
        return pulumi.get(self, "load_balancer_edition")

    @load_balancer_edition.setter
    def load_balancer_edition(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "load_balancer_edition", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the virtual private cloud (VPC) where the SLB instance is deployed.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "vpc_id", value)

    @_builtins.property
    @pulumi.getter(name="zoneMappings")
    def zone_mappings(self) -> pulumi.Input[Sequence[pulumi.Input['LoadBalancerZoneMappingArgs']]]:
        """
        The zones and vSwitches. You must specify at least two zones. See `zone_mappings` below.
        """
        return pulumi.get(self, "zone_mappings")

    @zone_mappings.setter
    def zone_mappings(self, value: pulumi.Input[Sequence[pulumi.Input['LoadBalancerZoneMappingArgs']]]):
        pulumi.set(self, "zone_mappings", value)

    @_builtins.property
    @pulumi.getter(name="accessLogConfig")
    def access_log_config(self) -> Optional[pulumi.Input['LoadBalancerAccessLogConfigArgs']]:
        """
        The configuration of the access log. See `access_log_config` below.
        """
        return pulumi.get(self, "access_log_config")

    @access_log_config.setter
    def access_log_config(self, value: Optional[pulumi.Input['LoadBalancerAccessLogConfigArgs']]):
        pulumi.set(self, "access_log_config", value)

    @_builtins.property
    @pulumi.getter(name="addressAllocatedMode")
    def address_allocated_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The method in which IP addresses are assigned. Valid values:  Fixed: The ALB instance uses a fixed IP address. Dynamic (default): An IP address is dynamically assigned to each zone of the ALB instance.
        """
        return pulumi.get(self, "address_allocated_mode")

    @address_allocated_mode.setter
    def address_allocated_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "address_allocated_mode", value)

    @_builtins.property
    @pulumi.getter(name="addressIpVersion")
    def address_ip_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The protocol version. Value:
        - `IPv4`:IPv4 type.
        - `DualStack`: the dual-stack type.
        """
        return pulumi.get(self, "address_ip_version")

    @address_ip_version.setter
    def address_ip_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "address_ip_version", value)

    @_builtins.property
    @pulumi.getter(name="bandwidthPackageId")
    def bandwidth_package_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the EIP bandwidth plan which is associated with an ALB instance that uses a public IP address.
        """
        return pulumi.get(self, "bandwidth_package_id")

    @bandwidth_package_id.setter
    def bandwidth_package_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bandwidth_package_id", value)

    @_builtins.property
    @pulumi.getter(name="deletionProtectionConfig")
    def deletion_protection_config(self) -> Optional[pulumi.Input['LoadBalancerDeletionProtectionConfigArgs']]:
        """
        The Protection Configuration See `deletion_protection_config` below.
        """
        return pulumi.get(self, "deletion_protection_config")

    @deletion_protection_config.setter
    def deletion_protection_config(self, value: Optional[pulumi.Input['LoadBalancerDeletionProtectionConfigArgs']]):
        pulumi.set(self, "deletion_protection_config", value)

    @_builtins.property
    @pulumi.getter(name="deletionProtectionEnabled")
    def deletion_protection_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to enable deletion protection. Default value: `false`. Valid values:
        """
        return pulumi.get(self, "deletion_protection_enabled")

    @deletion_protection_enabled.setter
    def deletion_protection_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "deletion_protection_enabled", value)

    @_builtins.property
    @pulumi.getter(name="dryRun")
    def dry_run(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to PreCheck only this request, value:
        """
        return pulumi.get(self, "dry_run")

    @dry_run.setter
    def dry_run(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "dry_run", value)

    @_builtins.property
    @pulumi.getter(name="ipv6AddressType")
    def ipv6_address_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The address type of Ipv6
        """
        return pulumi.get(self, "ipv6_address_type")

    @ipv6_address_type.setter
    def ipv6_address_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipv6_address_type", value)

    @_builtins.property
    @pulumi.getter(name="loadBalancerName")
    def load_balancer_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the resource
        """
        return pulumi.get(self, "load_balancer_name")

    @load_balancer_name.setter
    def load_balancer_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "load_balancer_name", value)

    @_builtins.property
    @pulumi.getter(name="modificationProtectionConfig")
    def modification_protection_config(self) -> Optional[pulumi.Input['LoadBalancerModificationProtectionConfigArgs']]:
        """
        Modify the Protection Configuration See `modification_protection_config` below.
        """
        return pulumi.get(self, "modification_protection_config")

    @modification_protection_config.setter
    def modification_protection_config(self, value: Optional[pulumi.Input['LoadBalancerModificationProtectionConfigArgs']]):
        pulumi.set(self, "modification_protection_config", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the resource group
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The tag of the resource
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _LoadBalancerState:
    def __init__(__self__, *,
                 access_log_config: Optional[pulumi.Input['LoadBalancerAccessLogConfigArgs']] = None,
                 address_allocated_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 address_ip_version: Optional[pulumi.Input[_builtins.str]] = None,
                 address_type: Optional[pulumi.Input[_builtins.str]] = None,
                 bandwidth_package_id: Optional[pulumi.Input[_builtins.str]] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 deletion_protection_config: Optional[pulumi.Input['LoadBalancerDeletionProtectionConfigArgs']] = None,
                 deletion_protection_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 dns_name: Optional[pulumi.Input[_builtins.str]] = None,
                 dry_run: Optional[pulumi.Input[_builtins.bool]] = None,
                 ipv6_address_type: Optional[pulumi.Input[_builtins.str]] = None,
                 load_balancer_billing_config: Optional[pulumi.Input['LoadBalancerLoadBalancerBillingConfigArgs']] = None,
                 load_balancer_edition: Optional[pulumi.Input[_builtins.str]] = None,
                 load_balancer_name: Optional[pulumi.Input[_builtins.str]] = None,
                 modification_protection_config: Optional[pulumi.Input['LoadBalancerModificationProtectionConfigArgs']] = None,
                 region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_mappings: Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerZoneMappingArgs']]]] = None):
        """
        Input properties used for looking up and filtering LoadBalancer resources.
        :param pulumi.Input['LoadBalancerAccessLogConfigArgs'] access_log_config: The configuration of the access log. See `access_log_config` below.
        :param pulumi.Input[_builtins.str] address_allocated_mode: The method in which IP addresses are assigned. Valid values:  Fixed: The ALB instance uses a fixed IP address. Dynamic (default): An IP address is dynamically assigned to each zone of the ALB instance.
        :param pulumi.Input[_builtins.str] address_ip_version: The protocol version. Value:
               - `IPv4`:IPv4 type.
               - `DualStack`: the dual-stack type.
        :param pulumi.Input[_builtins.str] address_type: The type of IP address that the SLB instance uses to provide services.
        :param pulumi.Input[_builtins.str] bandwidth_package_id: The ID of the EIP bandwidth plan which is associated with an ALB instance that uses a public IP address.
        :param pulumi.Input[_builtins.str] create_time: The creation time of the resource
        :param pulumi.Input['LoadBalancerDeletionProtectionConfigArgs'] deletion_protection_config: The Protection Configuration See `deletion_protection_config` below.
        :param pulumi.Input[_builtins.bool] deletion_protection_enabled: Specifies whether to enable deletion protection. Default value: `false`. Valid values:
        :param pulumi.Input[_builtins.str] dns_name: DNS Domain Name
        :param pulumi.Input[_builtins.bool] dry_run: Whether to PreCheck only this request, value:
        :param pulumi.Input[_builtins.str] ipv6_address_type: The address type of Ipv6
        :param pulumi.Input['LoadBalancerLoadBalancerBillingConfigArgs'] load_balancer_billing_config: The configuration of the billing method. See `load_balancer_billing_config` below.
        :param pulumi.Input[_builtins.str] load_balancer_edition: The edition of the ALB instance.
        :param pulumi.Input[_builtins.str] load_balancer_name: The name of the resource
        :param pulumi.Input['LoadBalancerModificationProtectionConfigArgs'] modification_protection_config: Modify the Protection Configuration See `modification_protection_config` below.
        :param pulumi.Input[_builtins.str] region_id: The region ID of the resource
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group
        :param pulumi.Input[_builtins.str] status: Server Load Balancer Instance Status:, indicating that the instance listener will no longer forward traffic.(default).
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tag of the resource
        :param pulumi.Input[_builtins.str] vpc_id: The ID of the virtual private cloud (VPC) where the SLB instance is deployed.
        :param pulumi.Input[Sequence[pulumi.Input['LoadBalancerZoneMappingArgs']]] zone_mappings: The zones and vSwitches. You must specify at least two zones. See `zone_mappings` below.
        """
        if access_log_config is not None:
            pulumi.set(__self__, "access_log_config", access_log_config)
        if address_allocated_mode is not None:
            pulumi.set(__self__, "address_allocated_mode", address_allocated_mode)
        if address_ip_version is not None:
            pulumi.set(__self__, "address_ip_version", address_ip_version)
        if address_type is not None:
            pulumi.set(__self__, "address_type", address_type)
        if bandwidth_package_id is not None:
            pulumi.set(__self__, "bandwidth_package_id", bandwidth_package_id)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if deletion_protection_config is not None:
            pulumi.set(__self__, "deletion_protection_config", deletion_protection_config)
        if deletion_protection_enabled is not None:
            pulumi.set(__self__, "deletion_protection_enabled", deletion_protection_enabled)
        if dns_name is not None:
            pulumi.set(__self__, "dns_name", dns_name)
        if dry_run is not None:
            pulumi.set(__self__, "dry_run", dry_run)
        if ipv6_address_type is not None:
            pulumi.set(__self__, "ipv6_address_type", ipv6_address_type)
        if load_balancer_billing_config is not None:
            pulumi.set(__self__, "load_balancer_billing_config", load_balancer_billing_config)
        if load_balancer_edition is not None:
            pulumi.set(__self__, "load_balancer_edition", load_balancer_edition)
        if load_balancer_name is not None:
            pulumi.set(__self__, "load_balancer_name", load_balancer_name)
        if modification_protection_config is not None:
            pulumi.set(__self__, "modification_protection_config", modification_protection_config)
        if region_id is not None:
            pulumi.set(__self__, "region_id", region_id)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)
        if zone_mappings is not None:
            pulumi.set(__self__, "zone_mappings", zone_mappings)

    @_builtins.property
    @pulumi.getter(name="accessLogConfig")
    def access_log_config(self) -> Optional[pulumi.Input['LoadBalancerAccessLogConfigArgs']]:
        """
        The configuration of the access log. See `access_log_config` below.
        """
        return pulumi.get(self, "access_log_config")

    @access_log_config.setter
    def access_log_config(self, value: Optional[pulumi.Input['LoadBalancerAccessLogConfigArgs']]):
        pulumi.set(self, "access_log_config", value)

    @_builtins.property
    @pulumi.getter(name="addressAllocatedMode")
    def address_allocated_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The method in which IP addresses are assigned. Valid values:  Fixed: The ALB instance uses a fixed IP address. Dynamic (default): An IP address is dynamically assigned to each zone of the ALB instance.
        """
        return pulumi.get(self, "address_allocated_mode")

    @address_allocated_mode.setter
    def address_allocated_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "address_allocated_mode", value)

    @_builtins.property
    @pulumi.getter(name="addressIpVersion")
    def address_ip_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The protocol version. Value:
        - `IPv4`:IPv4 type.
        - `DualStack`: the dual-stack type.
        """
        return pulumi.get(self, "address_ip_version")

    @address_ip_version.setter
    def address_ip_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "address_ip_version", value)

    @_builtins.property
    @pulumi.getter(name="addressType")
    def address_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of IP address that the SLB instance uses to provide services.
        """
        return pulumi.get(self, "address_type")

    @address_type.setter
    def address_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "address_type", value)

    @_builtins.property
    @pulumi.getter(name="bandwidthPackageId")
    def bandwidth_package_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the EIP bandwidth plan which is associated with an ALB instance that uses a public IP address.
        """
        return pulumi.get(self, "bandwidth_package_id")

    @bandwidth_package_id.setter
    def bandwidth_package_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bandwidth_package_id", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The creation time of the resource
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="deletionProtectionConfig")
    def deletion_protection_config(self) -> Optional[pulumi.Input['LoadBalancerDeletionProtectionConfigArgs']]:
        """
        The Protection Configuration See `deletion_protection_config` below.
        """
        return pulumi.get(self, "deletion_protection_config")

    @deletion_protection_config.setter
    def deletion_protection_config(self, value: Optional[pulumi.Input['LoadBalancerDeletionProtectionConfigArgs']]):
        pulumi.set(self, "deletion_protection_config", value)

    @_builtins.property
    @pulumi.getter(name="deletionProtectionEnabled")
    def deletion_protection_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to enable deletion protection. Default value: `false`. Valid values:
        """
        return pulumi.get(self, "deletion_protection_enabled")

    @deletion_protection_enabled.setter
    def deletion_protection_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "deletion_protection_enabled", value)

    @_builtins.property
    @pulumi.getter(name="dnsName")
    def dns_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        DNS Domain Name
        """
        return pulumi.get(self, "dns_name")

    @dns_name.setter
    def dns_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dns_name", value)

    @_builtins.property
    @pulumi.getter(name="dryRun")
    def dry_run(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to PreCheck only this request, value:
        """
        return pulumi.get(self, "dry_run")

    @dry_run.setter
    def dry_run(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "dry_run", value)

    @_builtins.property
    @pulumi.getter(name="ipv6AddressType")
    def ipv6_address_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The address type of Ipv6
        """
        return pulumi.get(self, "ipv6_address_type")

    @ipv6_address_type.setter
    def ipv6_address_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipv6_address_type", value)

    @_builtins.property
    @pulumi.getter(name="loadBalancerBillingConfig")
    def load_balancer_billing_config(self) -> Optional[pulumi.Input['LoadBalancerLoadBalancerBillingConfigArgs']]:
        """
        The configuration of the billing method. See `load_balancer_billing_config` below.
        """
        return pulumi.get(self, "load_balancer_billing_config")

    @load_balancer_billing_config.setter
    def load_balancer_billing_config(self, value: Optional[pulumi.Input['LoadBalancerLoadBalancerBillingConfigArgs']]):
        pulumi.set(self, "load_balancer_billing_config", value)

    @_builtins.property
    @pulumi.getter(name="loadBalancerEdition")
    def load_balancer_edition(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The edition of the ALB instance.
        """
        return pulumi.get(self, "load_balancer_edition")

    @load_balancer_edition.setter
    def load_balancer_edition(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "load_balancer_edition", value)

    @_builtins.property
    @pulumi.getter(name="loadBalancerName")
    def load_balancer_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the resource
        """
        return pulumi.get(self, "load_balancer_name")

    @load_balancer_name.setter
    def load_balancer_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "load_balancer_name", value)

    @_builtins.property
    @pulumi.getter(name="modificationProtectionConfig")
    def modification_protection_config(self) -> Optional[pulumi.Input['LoadBalancerModificationProtectionConfigArgs']]:
        """
        Modify the Protection Configuration See `modification_protection_config` below.
        """
        return pulumi.get(self, "modification_protection_config")

    @modification_protection_config.setter
    def modification_protection_config(self, value: Optional[pulumi.Input['LoadBalancerModificationProtectionConfigArgs']]):
        pulumi.set(self, "modification_protection_config", value)

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region ID of the resource
        """
        return pulumi.get(self, "region_id")

    @region_id.setter
    def region_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region_id", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the resource group
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Server Load Balancer Instance Status:, indicating that the instance listener will no longer forward traffic.(default).
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The tag of the resource
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the virtual private cloud (VPC) where the SLB instance is deployed.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_id", value)

    @_builtins.property
    @pulumi.getter(name="zoneMappings")
    def zone_mappings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerZoneMappingArgs']]]]:
        """
        The zones and vSwitches. You must specify at least two zones. See `zone_mappings` below.
        """
        return pulumi.get(self, "zone_mappings")

    @zone_mappings.setter
    def zone_mappings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerZoneMappingArgs']]]]):
        pulumi.set(self, "zone_mappings", value)


@pulumi.type_token("alicloud:alb/loadBalancer:LoadBalancer")
class LoadBalancer(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_log_config: Optional[pulumi.Input[Union['LoadBalancerAccessLogConfigArgs', 'LoadBalancerAccessLogConfigArgsDict']]] = None,
                 address_allocated_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 address_ip_version: Optional[pulumi.Input[_builtins.str]] = None,
                 address_type: Optional[pulumi.Input[_builtins.str]] = None,
                 bandwidth_package_id: Optional[pulumi.Input[_builtins.str]] = None,
                 deletion_protection_config: Optional[pulumi.Input[Union['LoadBalancerDeletionProtectionConfigArgs', 'LoadBalancerDeletionProtectionConfigArgsDict']]] = None,
                 deletion_protection_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 dry_run: Optional[pulumi.Input[_builtins.bool]] = None,
                 ipv6_address_type: Optional[pulumi.Input[_builtins.str]] = None,
                 load_balancer_billing_config: Optional[pulumi.Input[Union['LoadBalancerLoadBalancerBillingConfigArgs', 'LoadBalancerLoadBalancerBillingConfigArgsDict']]] = None,
                 load_balancer_edition: Optional[pulumi.Input[_builtins.str]] = None,
                 load_balancer_name: Optional[pulumi.Input[_builtins.str]] = None,
                 modification_protection_config: Optional[pulumi.Input[Union['LoadBalancerModificationProtectionConfigArgs', 'LoadBalancerModificationProtectionConfigArgsDict']]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_mappings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LoadBalancerZoneMappingArgs', 'LoadBalancerZoneMappingArgsDict']]]]] = None,
                 __props__=None):
        """
        Provides a Application Load Balancer (ALB) Load Balancer resource.

        Load Balancer Instance.

        For information about Application Load Balancer (ALB) Load Balancer and how to use it, see [What is Load Balancer](https://www.alibabacloud.com/help/en/slb/application-load-balancer/developer-reference/api-alb-2020-06-16-createloadbalancer).

        > **NOTE:** Available since v1.132.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.resourcemanager.get_resource_groups()
        default_get_zones = alicloud.alb.get_zones()
        default_network = alicloud.vpc.Network("default",
            vpc_name=name,
            cidr_block="10.4.0.0/16")
        default1 = alicloud.vpc.Switch("default1",
            vpc_id=default_network.id,
            cidr_block="10.4.1.0/24",
            zone_id=default_get_zones.zones[0].id,
            vswitch_name=f"{name}_1")
        default2 = alicloud.vpc.Switch("default2",
            vpc_id=default_network.id,
            cidr_block="10.4.2.0/24",
            zone_id=default_get_zones.zones[1].id,
            vswitch_name=f"{name}_2")
        default_load_balancer = alicloud.alb.LoadBalancer("default",
            load_balancer_edition="Basic",
            address_type="Internet",
            vpc_id=default_network.id,
            address_allocated_mode="Fixed",
            resource_group_id=default.groups[0].id,
            load_balancer_name=name,
            load_balancer_billing_config={
                "pay_type": "PayAsYouGo",
            },
            modification_protection_config={
                "status": "NonProtection",
            },
            zone_mappings=[
                {
                    "vswitch_id": default1.id,
                    "zone_id": default_get_zones.zones[0].id,
                },
                {
                    "vswitch_id": default2.id,
                    "zone_id": default_get_zones.zones[1].id,
                },
            ],
            tags={
                "Created": "TF",
            })
        ```

        ## Import

        Application Load Balancer (ALB) Load Balancer can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:alb/loadBalancer:LoadBalancer example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['LoadBalancerAccessLogConfigArgs', 'LoadBalancerAccessLogConfigArgsDict']] access_log_config: The configuration of the access log. See `access_log_config` below.
        :param pulumi.Input[_builtins.str] address_allocated_mode: The method in which IP addresses are assigned. Valid values:  Fixed: The ALB instance uses a fixed IP address. Dynamic (default): An IP address is dynamically assigned to each zone of the ALB instance.
        :param pulumi.Input[_builtins.str] address_ip_version: The protocol version. Value:
               - `IPv4`:IPv4 type.
               - `DualStack`: the dual-stack type.
        :param pulumi.Input[_builtins.str] address_type: The type of IP address that the SLB instance uses to provide services.
        :param pulumi.Input[_builtins.str] bandwidth_package_id: The ID of the EIP bandwidth plan which is associated with an ALB instance that uses a public IP address.
        :param pulumi.Input[Union['LoadBalancerDeletionProtectionConfigArgs', 'LoadBalancerDeletionProtectionConfigArgsDict']] deletion_protection_config: The Protection Configuration See `deletion_protection_config` below.
        :param pulumi.Input[_builtins.bool] deletion_protection_enabled: Specifies whether to enable deletion protection. Default value: `false`. Valid values:
        :param pulumi.Input[_builtins.bool] dry_run: Whether to PreCheck only this request, value:
        :param pulumi.Input[_builtins.str] ipv6_address_type: The address type of Ipv6
        :param pulumi.Input[Union['LoadBalancerLoadBalancerBillingConfigArgs', 'LoadBalancerLoadBalancerBillingConfigArgsDict']] load_balancer_billing_config: The configuration of the billing method. See `load_balancer_billing_config` below.
        :param pulumi.Input[_builtins.str] load_balancer_edition: The edition of the ALB instance.
        :param pulumi.Input[_builtins.str] load_balancer_name: The name of the resource
        :param pulumi.Input[Union['LoadBalancerModificationProtectionConfigArgs', 'LoadBalancerModificationProtectionConfigArgsDict']] modification_protection_config: Modify the Protection Configuration See `modification_protection_config` below.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tag of the resource
        :param pulumi.Input[_builtins.str] vpc_id: The ID of the virtual private cloud (VPC) where the SLB instance is deployed.
        :param pulumi.Input[Sequence[pulumi.Input[Union['LoadBalancerZoneMappingArgs', 'LoadBalancerZoneMappingArgsDict']]]] zone_mappings: The zones and vSwitches. You must specify at least two zones. See `zone_mappings` below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LoadBalancerArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Application Load Balancer (ALB) Load Balancer resource.

        Load Balancer Instance.

        For information about Application Load Balancer (ALB) Load Balancer and how to use it, see [What is Load Balancer](https://www.alibabacloud.com/help/en/slb/application-load-balancer/developer-reference/api-alb-2020-06-16-createloadbalancer).

        > **NOTE:** Available since v1.132.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.resourcemanager.get_resource_groups()
        default_get_zones = alicloud.alb.get_zones()
        default_network = alicloud.vpc.Network("default",
            vpc_name=name,
            cidr_block="10.4.0.0/16")
        default1 = alicloud.vpc.Switch("default1",
            vpc_id=default_network.id,
            cidr_block="10.4.1.0/24",
            zone_id=default_get_zones.zones[0].id,
            vswitch_name=f"{name}_1")
        default2 = alicloud.vpc.Switch("default2",
            vpc_id=default_network.id,
            cidr_block="10.4.2.0/24",
            zone_id=default_get_zones.zones[1].id,
            vswitch_name=f"{name}_2")
        default_load_balancer = alicloud.alb.LoadBalancer("default",
            load_balancer_edition="Basic",
            address_type="Internet",
            vpc_id=default_network.id,
            address_allocated_mode="Fixed",
            resource_group_id=default.groups[0].id,
            load_balancer_name=name,
            load_balancer_billing_config={
                "pay_type": "PayAsYouGo",
            },
            modification_protection_config={
                "status": "NonProtection",
            },
            zone_mappings=[
                {
                    "vswitch_id": default1.id,
                    "zone_id": default_get_zones.zones[0].id,
                },
                {
                    "vswitch_id": default2.id,
                    "zone_id": default_get_zones.zones[1].id,
                },
            ],
            tags={
                "Created": "TF",
            })
        ```

        ## Import

        Application Load Balancer (ALB) Load Balancer can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:alb/loadBalancer:LoadBalancer example <id>
        ```

        :param str resource_name: The name of the resource.
        :param LoadBalancerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LoadBalancerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_log_config: Optional[pulumi.Input[Union['LoadBalancerAccessLogConfigArgs', 'LoadBalancerAccessLogConfigArgsDict']]] = None,
                 address_allocated_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 address_ip_version: Optional[pulumi.Input[_builtins.str]] = None,
                 address_type: Optional[pulumi.Input[_builtins.str]] = None,
                 bandwidth_package_id: Optional[pulumi.Input[_builtins.str]] = None,
                 deletion_protection_config: Optional[pulumi.Input[Union['LoadBalancerDeletionProtectionConfigArgs', 'LoadBalancerDeletionProtectionConfigArgsDict']]] = None,
                 deletion_protection_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 dry_run: Optional[pulumi.Input[_builtins.bool]] = None,
                 ipv6_address_type: Optional[pulumi.Input[_builtins.str]] = None,
                 load_balancer_billing_config: Optional[pulumi.Input[Union['LoadBalancerLoadBalancerBillingConfigArgs', 'LoadBalancerLoadBalancerBillingConfigArgsDict']]] = None,
                 load_balancer_edition: Optional[pulumi.Input[_builtins.str]] = None,
                 load_balancer_name: Optional[pulumi.Input[_builtins.str]] = None,
                 modification_protection_config: Optional[pulumi.Input[Union['LoadBalancerModificationProtectionConfigArgs', 'LoadBalancerModificationProtectionConfigArgsDict']]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_mappings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LoadBalancerZoneMappingArgs', 'LoadBalancerZoneMappingArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LoadBalancerArgs.__new__(LoadBalancerArgs)

            __props__.__dict__["access_log_config"] = access_log_config
            __props__.__dict__["address_allocated_mode"] = address_allocated_mode
            __props__.__dict__["address_ip_version"] = address_ip_version
            if address_type is None and not opts.urn:
                raise TypeError("Missing required property 'address_type'")
            __props__.__dict__["address_type"] = address_type
            __props__.__dict__["bandwidth_package_id"] = bandwidth_package_id
            __props__.__dict__["deletion_protection_config"] = deletion_protection_config
            __props__.__dict__["deletion_protection_enabled"] = deletion_protection_enabled
            __props__.__dict__["dry_run"] = dry_run
            __props__.__dict__["ipv6_address_type"] = ipv6_address_type
            if load_balancer_billing_config is None and not opts.urn:
                raise TypeError("Missing required property 'load_balancer_billing_config'")
            __props__.__dict__["load_balancer_billing_config"] = load_balancer_billing_config
            if load_balancer_edition is None and not opts.urn:
                raise TypeError("Missing required property 'load_balancer_edition'")
            __props__.__dict__["load_balancer_edition"] = load_balancer_edition
            __props__.__dict__["load_balancer_name"] = load_balancer_name
            __props__.__dict__["modification_protection_config"] = modification_protection_config
            __props__.__dict__["resource_group_id"] = resource_group_id
            __props__.__dict__["tags"] = tags
            if vpc_id is None and not opts.urn:
                raise TypeError("Missing required property 'vpc_id'")
            __props__.__dict__["vpc_id"] = vpc_id
            if zone_mappings is None and not opts.urn:
                raise TypeError("Missing required property 'zone_mappings'")
            __props__.__dict__["zone_mappings"] = zone_mappings
            __props__.__dict__["create_time"] = None
            __props__.__dict__["dns_name"] = None
            __props__.__dict__["region_id"] = None
            __props__.__dict__["status"] = None
        super(LoadBalancer, __self__).__init__(
            'alicloud:alb/loadBalancer:LoadBalancer',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_log_config: Optional[pulumi.Input[Union['LoadBalancerAccessLogConfigArgs', 'LoadBalancerAccessLogConfigArgsDict']]] = None,
            address_allocated_mode: Optional[pulumi.Input[_builtins.str]] = None,
            address_ip_version: Optional[pulumi.Input[_builtins.str]] = None,
            address_type: Optional[pulumi.Input[_builtins.str]] = None,
            bandwidth_package_id: Optional[pulumi.Input[_builtins.str]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            deletion_protection_config: Optional[pulumi.Input[Union['LoadBalancerDeletionProtectionConfigArgs', 'LoadBalancerDeletionProtectionConfigArgsDict']]] = None,
            deletion_protection_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            dns_name: Optional[pulumi.Input[_builtins.str]] = None,
            dry_run: Optional[pulumi.Input[_builtins.bool]] = None,
            ipv6_address_type: Optional[pulumi.Input[_builtins.str]] = None,
            load_balancer_billing_config: Optional[pulumi.Input[Union['LoadBalancerLoadBalancerBillingConfigArgs', 'LoadBalancerLoadBalancerBillingConfigArgsDict']]] = None,
            load_balancer_edition: Optional[pulumi.Input[_builtins.str]] = None,
            load_balancer_name: Optional[pulumi.Input[_builtins.str]] = None,
            modification_protection_config: Optional[pulumi.Input[Union['LoadBalancerModificationProtectionConfigArgs', 'LoadBalancerModificationProtectionConfigArgsDict']]] = None,
            region_id: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
            zone_mappings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LoadBalancerZoneMappingArgs', 'LoadBalancerZoneMappingArgsDict']]]]] = None) -> 'LoadBalancer':
        """
        Get an existing LoadBalancer resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['LoadBalancerAccessLogConfigArgs', 'LoadBalancerAccessLogConfigArgsDict']] access_log_config: The configuration of the access log. See `access_log_config` below.
        :param pulumi.Input[_builtins.str] address_allocated_mode: The method in which IP addresses are assigned. Valid values:  Fixed: The ALB instance uses a fixed IP address. Dynamic (default): An IP address is dynamically assigned to each zone of the ALB instance.
        :param pulumi.Input[_builtins.str] address_ip_version: The protocol version. Value:
               - `IPv4`:IPv4 type.
               - `DualStack`: the dual-stack type.
        :param pulumi.Input[_builtins.str] address_type: The type of IP address that the SLB instance uses to provide services.
        :param pulumi.Input[_builtins.str] bandwidth_package_id: The ID of the EIP bandwidth plan which is associated with an ALB instance that uses a public IP address.
        :param pulumi.Input[_builtins.str] create_time: The creation time of the resource
        :param pulumi.Input[Union['LoadBalancerDeletionProtectionConfigArgs', 'LoadBalancerDeletionProtectionConfigArgsDict']] deletion_protection_config: The Protection Configuration See `deletion_protection_config` below.
        :param pulumi.Input[_builtins.bool] deletion_protection_enabled: Specifies whether to enable deletion protection. Default value: `false`. Valid values:
        :param pulumi.Input[_builtins.str] dns_name: DNS Domain Name
        :param pulumi.Input[_builtins.bool] dry_run: Whether to PreCheck only this request, value:
        :param pulumi.Input[_builtins.str] ipv6_address_type: The address type of Ipv6
        :param pulumi.Input[Union['LoadBalancerLoadBalancerBillingConfigArgs', 'LoadBalancerLoadBalancerBillingConfigArgsDict']] load_balancer_billing_config: The configuration of the billing method. See `load_balancer_billing_config` below.
        :param pulumi.Input[_builtins.str] load_balancer_edition: The edition of the ALB instance.
        :param pulumi.Input[_builtins.str] load_balancer_name: The name of the resource
        :param pulumi.Input[Union['LoadBalancerModificationProtectionConfigArgs', 'LoadBalancerModificationProtectionConfigArgsDict']] modification_protection_config: Modify the Protection Configuration See `modification_protection_config` below.
        :param pulumi.Input[_builtins.str] region_id: The region ID of the resource
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group
        :param pulumi.Input[_builtins.str] status: Server Load Balancer Instance Status:, indicating that the instance listener will no longer forward traffic.(default).
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tag of the resource
        :param pulumi.Input[_builtins.str] vpc_id: The ID of the virtual private cloud (VPC) where the SLB instance is deployed.
        :param pulumi.Input[Sequence[pulumi.Input[Union['LoadBalancerZoneMappingArgs', 'LoadBalancerZoneMappingArgsDict']]]] zone_mappings: The zones and vSwitches. You must specify at least two zones. See `zone_mappings` below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LoadBalancerState.__new__(_LoadBalancerState)

        __props__.__dict__["access_log_config"] = access_log_config
        __props__.__dict__["address_allocated_mode"] = address_allocated_mode
        __props__.__dict__["address_ip_version"] = address_ip_version
        __props__.__dict__["address_type"] = address_type
        __props__.__dict__["bandwidth_package_id"] = bandwidth_package_id
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["deletion_protection_config"] = deletion_protection_config
        __props__.__dict__["deletion_protection_enabled"] = deletion_protection_enabled
        __props__.__dict__["dns_name"] = dns_name
        __props__.__dict__["dry_run"] = dry_run
        __props__.__dict__["ipv6_address_type"] = ipv6_address_type
        __props__.__dict__["load_balancer_billing_config"] = load_balancer_billing_config
        __props__.__dict__["load_balancer_edition"] = load_balancer_edition
        __props__.__dict__["load_balancer_name"] = load_balancer_name
        __props__.__dict__["modification_protection_config"] = modification_protection_config
        __props__.__dict__["region_id"] = region_id
        __props__.__dict__["resource_group_id"] = resource_group_id
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        __props__.__dict__["vpc_id"] = vpc_id
        __props__.__dict__["zone_mappings"] = zone_mappings
        return LoadBalancer(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accessLogConfig")
    def access_log_config(self) -> pulumi.Output[Optional['outputs.LoadBalancerAccessLogConfig']]:
        """
        The configuration of the access log. See `access_log_config` below.
        """
        return pulumi.get(self, "access_log_config")

    @_builtins.property
    @pulumi.getter(name="addressAllocatedMode")
    def address_allocated_mode(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The method in which IP addresses are assigned. Valid values:  Fixed: The ALB instance uses a fixed IP address. Dynamic (default): An IP address is dynamically assigned to each zone of the ALB instance.
        """
        return pulumi.get(self, "address_allocated_mode")

    @_builtins.property
    @pulumi.getter(name="addressIpVersion")
    def address_ip_version(self) -> pulumi.Output[_builtins.str]:
        """
        The protocol version. Value:
        - `IPv4`:IPv4 type.
        - `DualStack`: the dual-stack type.
        """
        return pulumi.get(self, "address_ip_version")

    @_builtins.property
    @pulumi.getter(name="addressType")
    def address_type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of IP address that the SLB instance uses to provide services.
        """
        return pulumi.get(self, "address_type")

    @_builtins.property
    @pulumi.getter(name="bandwidthPackageId")
    def bandwidth_package_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the EIP bandwidth plan which is associated with an ALB instance that uses a public IP address.
        """
        return pulumi.get(self, "bandwidth_package_id")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        The creation time of the resource
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="deletionProtectionConfig")
    def deletion_protection_config(self) -> pulumi.Output['outputs.LoadBalancerDeletionProtectionConfig']:
        """
        The Protection Configuration See `deletion_protection_config` below.
        """
        return pulumi.get(self, "deletion_protection_config")

    @_builtins.property
    @pulumi.getter(name="deletionProtectionEnabled")
    def deletion_protection_enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Specifies whether to enable deletion protection. Default value: `false`. Valid values:
        """
        return pulumi.get(self, "deletion_protection_enabled")

    @_builtins.property
    @pulumi.getter(name="dnsName")
    def dns_name(self) -> pulumi.Output[_builtins.str]:
        """
        DNS Domain Name
        """
        return pulumi.get(self, "dns_name")

    @_builtins.property
    @pulumi.getter(name="dryRun")
    def dry_run(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to PreCheck only this request, value:
        """
        return pulumi.get(self, "dry_run")

    @_builtins.property
    @pulumi.getter(name="ipv6AddressType")
    def ipv6_address_type(self) -> pulumi.Output[_builtins.str]:
        """
        The address type of Ipv6
        """
        return pulumi.get(self, "ipv6_address_type")

    @_builtins.property
    @pulumi.getter(name="loadBalancerBillingConfig")
    def load_balancer_billing_config(self) -> pulumi.Output['outputs.LoadBalancerLoadBalancerBillingConfig']:
        """
        The configuration of the billing method. See `load_balancer_billing_config` below.
        """
        return pulumi.get(self, "load_balancer_billing_config")

    @_builtins.property
    @pulumi.getter(name="loadBalancerEdition")
    def load_balancer_edition(self) -> pulumi.Output[_builtins.str]:
        """
        The edition of the ALB instance.
        """
        return pulumi.get(self, "load_balancer_edition")

    @_builtins.property
    @pulumi.getter(name="loadBalancerName")
    def load_balancer_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The name of the resource
        """
        return pulumi.get(self, "load_balancer_name")

    @_builtins.property
    @pulumi.getter(name="modificationProtectionConfig")
    def modification_protection_config(self) -> pulumi.Output['outputs.LoadBalancerModificationProtectionConfig']:
        """
        Modify the Protection Configuration See `modification_protection_config` below.
        """
        return pulumi.get(self, "modification_protection_config")

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> pulumi.Output[_builtins.str]:
        """
        The region ID of the resource
        """
        return pulumi.get(self, "region_id")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the resource group
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        Server Load Balancer Instance Status:, indicating that the instance listener will no longer forward traffic.(default).
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        The tag of the resource
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the virtual private cloud (VPC) where the SLB instance is deployed.
        """
        return pulumi.get(self, "vpc_id")

    @_builtins.property
    @pulumi.getter(name="zoneMappings")
    def zone_mappings(self) -> pulumi.Output[Sequence['outputs.LoadBalancerZoneMapping']]:
        """
        The zones and vSwitches. You must specify at least two zones. See `zone_mappings` below.
        """
        return pulumi.get(self, "zone_mappings")

