# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['QueueArgs', 'Queue']

@pulumi.input_type
class QueueArgs:
    def __init__(__self__, *,
                 instance_id: pulumi.Input[_builtins.str],
                 queue_name: pulumi.Input[_builtins.str],
                 virtual_host_name: pulumi.Input[_builtins.str],
                 auto_delete_state: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_expire_state: Optional[pulumi.Input[_builtins.str]] = None,
                 dead_letter_exchange: Optional[pulumi.Input[_builtins.str]] = None,
                 dead_letter_routing_key: Optional[pulumi.Input[_builtins.str]] = None,
                 exclusive_state: Optional[pulumi.Input[_builtins.bool]] = None,
                 max_length: Optional[pulumi.Input[_builtins.str]] = None,
                 maximum_priority: Optional[pulumi.Input[_builtins.int]] = None,
                 message_ttl: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Queue resource.
        :param pulumi.Input[_builtins.str] instance_id: The ID of the instance.
        :param pulumi.Input[_builtins.str] queue_name: The name of the queue.
               The queue name must be 1 to 255 characters in length, and can contain only letters, digits, hyphens (-), underscores (_), periods (.), and at signs (@).
        :param pulumi.Input[_builtins.str] virtual_host_name: The name of the virtual host.
        :param pulumi.Input[_builtins.bool] auto_delete_state: Specifies whether the Auto Delete attribute is configured. Valid values:
               * true: The Auto Delete attribute is configured. The queue is automatically deleted after the last subscription from consumers to this queue is canceled.
               * false: The Auto Delete attribute is not configured.
        :param pulumi.Input[_builtins.str] auto_expire_state: The validity period after which the queue is automatically deleted.
               If the queue is not accessed within a specified period of time, it is automatically deleted.
        :param pulumi.Input[_builtins.str] dead_letter_exchange: The dead-letter exchange. A dead-letter exchange is used to receive rejected messages. 
               If a consumer rejects a message that cannot be retried, this message is routed to a specified dead-letter exchange.
               Then, the dead-letter exchange routes the message to the queue that is bound to the dead-letter exchange.
        :param pulumi.Input[_builtins.str] dead_letter_routing_key: The dead letter routing key.
        :param pulumi.Input[_builtins.bool] exclusive_state: Specifies whether the queue is an exclusive queue. Valid values:
               * true: The queue is an exclusive queue. It can be used only for the connection that declares the exclusive queue. After the connection is closed, the exclusive queue is automatically deleted.
               * false: The queue is not an exclusive queue.
        :param pulumi.Input[_builtins.str] max_length: The maximum number of messages that can be stored in the queue.
               If this threshold is exceeded, the earliest messages that are routed to the queue are discarded.
        :param pulumi.Input[_builtins.int] maximum_priority: The highest priority supported by the queue. This parameter is set to a positive integer.
               Valid values: 0 to 255. Recommended values: 1 to 10
        :param pulumi.Input[_builtins.str] message_ttl: The message TTL of the queue.
               If the retention period of a message in the queue exceeds the message TTL of the queue, the message expires.
               Message TTL must be set to a non-negative integer, in milliseconds.
               For example, if the message TTL of the queue is 1000, messages survive for at most 1 second in the queue.
        """
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "queue_name", queue_name)
        pulumi.set(__self__, "virtual_host_name", virtual_host_name)
        if auto_delete_state is not None:
            pulumi.set(__self__, "auto_delete_state", auto_delete_state)
        if auto_expire_state is not None:
            pulumi.set(__self__, "auto_expire_state", auto_expire_state)
        if dead_letter_exchange is not None:
            pulumi.set(__self__, "dead_letter_exchange", dead_letter_exchange)
        if dead_letter_routing_key is not None:
            pulumi.set(__self__, "dead_letter_routing_key", dead_letter_routing_key)
        if exclusive_state is not None:
            pulumi.set(__self__, "exclusive_state", exclusive_state)
        if max_length is not None:
            pulumi.set(__self__, "max_length", max_length)
        if maximum_priority is not None:
            pulumi.set(__self__, "maximum_priority", maximum_priority)
        if message_ttl is not None:
            pulumi.set(__self__, "message_ttl", message_ttl)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the instance.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter(name="queueName")
    def queue_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the queue.
        The queue name must be 1 to 255 characters in length, and can contain only letters, digits, hyphens (-), underscores (_), periods (.), and at signs (@).
        """
        return pulumi.get(self, "queue_name")

    @queue_name.setter
    def queue_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "queue_name", value)

    @_builtins.property
    @pulumi.getter(name="virtualHostName")
    def virtual_host_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the virtual host.
        """
        return pulumi.get(self, "virtual_host_name")

    @virtual_host_name.setter
    def virtual_host_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "virtual_host_name", value)

    @_builtins.property
    @pulumi.getter(name="autoDeleteState")
    def auto_delete_state(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether the Auto Delete attribute is configured. Valid values:
        * true: The Auto Delete attribute is configured. The queue is automatically deleted after the last subscription from consumers to this queue is canceled.
        * false: The Auto Delete attribute is not configured.
        """
        return pulumi.get(self, "auto_delete_state")

    @auto_delete_state.setter
    def auto_delete_state(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_delete_state", value)

    @_builtins.property
    @pulumi.getter(name="autoExpireState")
    def auto_expire_state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The validity period after which the queue is automatically deleted.
        If the queue is not accessed within a specified period of time, it is automatically deleted.
        """
        return pulumi.get(self, "auto_expire_state")

    @auto_expire_state.setter
    def auto_expire_state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auto_expire_state", value)

    @_builtins.property
    @pulumi.getter(name="deadLetterExchange")
    def dead_letter_exchange(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The dead-letter exchange. A dead-letter exchange is used to receive rejected messages. 
        If a consumer rejects a message that cannot be retried, this message is routed to a specified dead-letter exchange.
        Then, the dead-letter exchange routes the message to the queue that is bound to the dead-letter exchange.
        """
        return pulumi.get(self, "dead_letter_exchange")

    @dead_letter_exchange.setter
    def dead_letter_exchange(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dead_letter_exchange", value)

    @_builtins.property
    @pulumi.getter(name="deadLetterRoutingKey")
    def dead_letter_routing_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The dead letter routing key.
        """
        return pulumi.get(self, "dead_letter_routing_key")

    @dead_letter_routing_key.setter
    def dead_letter_routing_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dead_letter_routing_key", value)

    @_builtins.property
    @pulumi.getter(name="exclusiveState")
    def exclusive_state(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether the queue is an exclusive queue. Valid values:
        * true: The queue is an exclusive queue. It can be used only for the connection that declares the exclusive queue. After the connection is closed, the exclusive queue is automatically deleted.
        * false: The queue is not an exclusive queue.
        """
        return pulumi.get(self, "exclusive_state")

    @exclusive_state.setter
    def exclusive_state(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "exclusive_state", value)

    @_builtins.property
    @pulumi.getter(name="maxLength")
    def max_length(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The maximum number of messages that can be stored in the queue.
        If this threshold is exceeded, the earliest messages that are routed to the queue are discarded.
        """
        return pulumi.get(self, "max_length")

    @max_length.setter
    def max_length(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "max_length", value)

    @_builtins.property
    @pulumi.getter(name="maximumPriority")
    def maximum_priority(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The highest priority supported by the queue. This parameter is set to a positive integer.
        Valid values: 0 to 255. Recommended values: 1 to 10
        """
        return pulumi.get(self, "maximum_priority")

    @maximum_priority.setter
    def maximum_priority(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "maximum_priority", value)

    @_builtins.property
    @pulumi.getter(name="messageTtl")
    def message_ttl(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The message TTL of the queue.
        If the retention period of a message in the queue exceeds the message TTL of the queue, the message expires.
        Message TTL must be set to a non-negative integer, in milliseconds.
        For example, if the message TTL of the queue is 1000, messages survive for at most 1 second in the queue.
        """
        return pulumi.get(self, "message_ttl")

    @message_ttl.setter
    def message_ttl(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "message_ttl", value)


@pulumi.input_type
class _QueueState:
    def __init__(__self__, *,
                 auto_delete_state: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_expire_state: Optional[pulumi.Input[_builtins.str]] = None,
                 dead_letter_exchange: Optional[pulumi.Input[_builtins.str]] = None,
                 dead_letter_routing_key: Optional[pulumi.Input[_builtins.str]] = None,
                 exclusive_state: Optional[pulumi.Input[_builtins.bool]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 max_length: Optional[pulumi.Input[_builtins.str]] = None,
                 maximum_priority: Optional[pulumi.Input[_builtins.int]] = None,
                 message_ttl: Optional[pulumi.Input[_builtins.str]] = None,
                 queue_name: Optional[pulumi.Input[_builtins.str]] = None,
                 virtual_host_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Queue resources.
        :param pulumi.Input[_builtins.bool] auto_delete_state: Specifies whether the Auto Delete attribute is configured. Valid values:
               * true: The Auto Delete attribute is configured. The queue is automatically deleted after the last subscription from consumers to this queue is canceled.
               * false: The Auto Delete attribute is not configured.
        :param pulumi.Input[_builtins.str] auto_expire_state: The validity period after which the queue is automatically deleted.
               If the queue is not accessed within a specified period of time, it is automatically deleted.
        :param pulumi.Input[_builtins.str] dead_letter_exchange: The dead-letter exchange. A dead-letter exchange is used to receive rejected messages. 
               If a consumer rejects a message that cannot be retried, this message is routed to a specified dead-letter exchange.
               Then, the dead-letter exchange routes the message to the queue that is bound to the dead-letter exchange.
        :param pulumi.Input[_builtins.str] dead_letter_routing_key: The dead letter routing key.
        :param pulumi.Input[_builtins.bool] exclusive_state: Specifies whether the queue is an exclusive queue. Valid values:
               * true: The queue is an exclusive queue. It can be used only for the connection that declares the exclusive queue. After the connection is closed, the exclusive queue is automatically deleted.
               * false: The queue is not an exclusive queue.
        :param pulumi.Input[_builtins.str] instance_id: The ID of the instance.
        :param pulumi.Input[_builtins.str] max_length: The maximum number of messages that can be stored in the queue.
               If this threshold is exceeded, the earliest messages that are routed to the queue are discarded.
        :param pulumi.Input[_builtins.int] maximum_priority: The highest priority supported by the queue. This parameter is set to a positive integer.
               Valid values: 0 to 255. Recommended values: 1 to 10
        :param pulumi.Input[_builtins.str] message_ttl: The message TTL of the queue.
               If the retention period of a message in the queue exceeds the message TTL of the queue, the message expires.
               Message TTL must be set to a non-negative integer, in milliseconds.
               For example, if the message TTL of the queue is 1000, messages survive for at most 1 second in the queue.
        :param pulumi.Input[_builtins.str] queue_name: The name of the queue.
               The queue name must be 1 to 255 characters in length, and can contain only letters, digits, hyphens (-), underscores (_), periods (.), and at signs (@).
        :param pulumi.Input[_builtins.str] virtual_host_name: The name of the virtual host.
        """
        if auto_delete_state is not None:
            pulumi.set(__self__, "auto_delete_state", auto_delete_state)
        if auto_expire_state is not None:
            pulumi.set(__self__, "auto_expire_state", auto_expire_state)
        if dead_letter_exchange is not None:
            pulumi.set(__self__, "dead_letter_exchange", dead_letter_exchange)
        if dead_letter_routing_key is not None:
            pulumi.set(__self__, "dead_letter_routing_key", dead_letter_routing_key)
        if exclusive_state is not None:
            pulumi.set(__self__, "exclusive_state", exclusive_state)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if max_length is not None:
            pulumi.set(__self__, "max_length", max_length)
        if maximum_priority is not None:
            pulumi.set(__self__, "maximum_priority", maximum_priority)
        if message_ttl is not None:
            pulumi.set(__self__, "message_ttl", message_ttl)
        if queue_name is not None:
            pulumi.set(__self__, "queue_name", queue_name)
        if virtual_host_name is not None:
            pulumi.set(__self__, "virtual_host_name", virtual_host_name)

    @_builtins.property
    @pulumi.getter(name="autoDeleteState")
    def auto_delete_state(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether the Auto Delete attribute is configured. Valid values:
        * true: The Auto Delete attribute is configured. The queue is automatically deleted after the last subscription from consumers to this queue is canceled.
        * false: The Auto Delete attribute is not configured.
        """
        return pulumi.get(self, "auto_delete_state")

    @auto_delete_state.setter
    def auto_delete_state(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_delete_state", value)

    @_builtins.property
    @pulumi.getter(name="autoExpireState")
    def auto_expire_state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The validity period after which the queue is automatically deleted.
        If the queue is not accessed within a specified period of time, it is automatically deleted.
        """
        return pulumi.get(self, "auto_expire_state")

    @auto_expire_state.setter
    def auto_expire_state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auto_expire_state", value)

    @_builtins.property
    @pulumi.getter(name="deadLetterExchange")
    def dead_letter_exchange(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The dead-letter exchange. A dead-letter exchange is used to receive rejected messages. 
        If a consumer rejects a message that cannot be retried, this message is routed to a specified dead-letter exchange.
        Then, the dead-letter exchange routes the message to the queue that is bound to the dead-letter exchange.
        """
        return pulumi.get(self, "dead_letter_exchange")

    @dead_letter_exchange.setter
    def dead_letter_exchange(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dead_letter_exchange", value)

    @_builtins.property
    @pulumi.getter(name="deadLetterRoutingKey")
    def dead_letter_routing_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The dead letter routing key.
        """
        return pulumi.get(self, "dead_letter_routing_key")

    @dead_letter_routing_key.setter
    def dead_letter_routing_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dead_letter_routing_key", value)

    @_builtins.property
    @pulumi.getter(name="exclusiveState")
    def exclusive_state(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether the queue is an exclusive queue. Valid values:
        * true: The queue is an exclusive queue. It can be used only for the connection that declares the exclusive queue. After the connection is closed, the exclusive queue is automatically deleted.
        * false: The queue is not an exclusive queue.
        """
        return pulumi.get(self, "exclusive_state")

    @exclusive_state.setter
    def exclusive_state(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "exclusive_state", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the instance.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter(name="maxLength")
    def max_length(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The maximum number of messages that can be stored in the queue.
        If this threshold is exceeded, the earliest messages that are routed to the queue are discarded.
        """
        return pulumi.get(self, "max_length")

    @max_length.setter
    def max_length(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "max_length", value)

    @_builtins.property
    @pulumi.getter(name="maximumPriority")
    def maximum_priority(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The highest priority supported by the queue. This parameter is set to a positive integer.
        Valid values: 0 to 255. Recommended values: 1 to 10
        """
        return pulumi.get(self, "maximum_priority")

    @maximum_priority.setter
    def maximum_priority(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "maximum_priority", value)

    @_builtins.property
    @pulumi.getter(name="messageTtl")
    def message_ttl(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The message TTL of the queue.
        If the retention period of a message in the queue exceeds the message TTL of the queue, the message expires.
        Message TTL must be set to a non-negative integer, in milliseconds.
        For example, if the message TTL of the queue is 1000, messages survive for at most 1 second in the queue.
        """
        return pulumi.get(self, "message_ttl")

    @message_ttl.setter
    def message_ttl(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "message_ttl", value)

    @_builtins.property
    @pulumi.getter(name="queueName")
    def queue_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the queue.
        The queue name must be 1 to 255 characters in length, and can contain only letters, digits, hyphens (-), underscores (_), periods (.), and at signs (@).
        """
        return pulumi.get(self, "queue_name")

    @queue_name.setter
    def queue_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "queue_name", value)

    @_builtins.property
    @pulumi.getter(name="virtualHostName")
    def virtual_host_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the virtual host.
        """
        return pulumi.get(self, "virtual_host_name")

    @virtual_host_name.setter
    def virtual_host_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "virtual_host_name", value)


@pulumi.type_token("alicloud:amqp/queue:Queue")
class Queue(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_delete_state: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_expire_state: Optional[pulumi.Input[_builtins.str]] = None,
                 dead_letter_exchange: Optional[pulumi.Input[_builtins.str]] = None,
                 dead_letter_routing_key: Optional[pulumi.Input[_builtins.str]] = None,
                 exclusive_state: Optional[pulumi.Input[_builtins.bool]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 max_length: Optional[pulumi.Input[_builtins.str]] = None,
                 maximum_priority: Optional[pulumi.Input[_builtins.int]] = None,
                 message_ttl: Optional[pulumi.Input[_builtins.str]] = None,
                 queue_name: Optional[pulumi.Input[_builtins.str]] = None,
                 virtual_host_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a RabbitMQ (AMQP) Queue resource.

        For information about RabbitMQ (AMQP) Queue and how to use it, see [What is Queue](https://www.alibabacloud.com/help/en/message-queue-for-rabbitmq/latest/createqueue).

        > **NOTE:** Available since v1.127.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        default = alicloud.amqp.Instance("default",
            instance_type="enterprise",
            max_tps="3000",
            queue_capacity="200",
            storage_size="700",
            support_eip=False,
            max_eip_tps="128",
            payment_type="Subscription",
            period=1)
        default_virtual_host = alicloud.amqp.VirtualHost("default",
            instance_id=default.id,
            virtual_host_name="tf-example")
        default_exchange = alicloud.amqp.Exchange("default",
            auto_delete_state=False,
            exchange_name="tf-example",
            exchange_type="DIRECT",
            instance_id=default.id,
            internal=False,
            virtual_host_name=default_virtual_host.virtual_host_name)
        example = alicloud.amqp.Queue("example",
            instance_id=default.id,
            queue_name="tf-example",
            virtual_host_name=default_virtual_host.virtual_host_name)
        ```

        ## Import

        RabbitMQ (AMQP) Queue can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:amqp/queue:Queue example <instance_id>:<virtual_host_name>:<queue_name>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] auto_delete_state: Specifies whether the Auto Delete attribute is configured. Valid values:
               * true: The Auto Delete attribute is configured. The queue is automatically deleted after the last subscription from consumers to this queue is canceled.
               * false: The Auto Delete attribute is not configured.
        :param pulumi.Input[_builtins.str] auto_expire_state: The validity period after which the queue is automatically deleted.
               If the queue is not accessed within a specified period of time, it is automatically deleted.
        :param pulumi.Input[_builtins.str] dead_letter_exchange: The dead-letter exchange. A dead-letter exchange is used to receive rejected messages. 
               If a consumer rejects a message that cannot be retried, this message is routed to a specified dead-letter exchange.
               Then, the dead-letter exchange routes the message to the queue that is bound to the dead-letter exchange.
        :param pulumi.Input[_builtins.str] dead_letter_routing_key: The dead letter routing key.
        :param pulumi.Input[_builtins.bool] exclusive_state: Specifies whether the queue is an exclusive queue. Valid values:
               * true: The queue is an exclusive queue. It can be used only for the connection that declares the exclusive queue. After the connection is closed, the exclusive queue is automatically deleted.
               * false: The queue is not an exclusive queue.
        :param pulumi.Input[_builtins.str] instance_id: The ID of the instance.
        :param pulumi.Input[_builtins.str] max_length: The maximum number of messages that can be stored in the queue.
               If this threshold is exceeded, the earliest messages that are routed to the queue are discarded.
        :param pulumi.Input[_builtins.int] maximum_priority: The highest priority supported by the queue. This parameter is set to a positive integer.
               Valid values: 0 to 255. Recommended values: 1 to 10
        :param pulumi.Input[_builtins.str] message_ttl: The message TTL of the queue.
               If the retention period of a message in the queue exceeds the message TTL of the queue, the message expires.
               Message TTL must be set to a non-negative integer, in milliseconds.
               For example, if the message TTL of the queue is 1000, messages survive for at most 1 second in the queue.
        :param pulumi.Input[_builtins.str] queue_name: The name of the queue.
               The queue name must be 1 to 255 characters in length, and can contain only letters, digits, hyphens (-), underscores (_), periods (.), and at signs (@).
        :param pulumi.Input[_builtins.str] virtual_host_name: The name of the virtual host.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: QueueArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a RabbitMQ (AMQP) Queue resource.

        For information about RabbitMQ (AMQP) Queue and how to use it, see [What is Queue](https://www.alibabacloud.com/help/en/message-queue-for-rabbitmq/latest/createqueue).

        > **NOTE:** Available since v1.127.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        default = alicloud.amqp.Instance("default",
            instance_type="enterprise",
            max_tps="3000",
            queue_capacity="200",
            storage_size="700",
            support_eip=False,
            max_eip_tps="128",
            payment_type="Subscription",
            period=1)
        default_virtual_host = alicloud.amqp.VirtualHost("default",
            instance_id=default.id,
            virtual_host_name="tf-example")
        default_exchange = alicloud.amqp.Exchange("default",
            auto_delete_state=False,
            exchange_name="tf-example",
            exchange_type="DIRECT",
            instance_id=default.id,
            internal=False,
            virtual_host_name=default_virtual_host.virtual_host_name)
        example = alicloud.amqp.Queue("example",
            instance_id=default.id,
            queue_name="tf-example",
            virtual_host_name=default_virtual_host.virtual_host_name)
        ```

        ## Import

        RabbitMQ (AMQP) Queue can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:amqp/queue:Queue example <instance_id>:<virtual_host_name>:<queue_name>
        ```

        :param str resource_name: The name of the resource.
        :param QueueArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(QueueArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_delete_state: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_expire_state: Optional[pulumi.Input[_builtins.str]] = None,
                 dead_letter_exchange: Optional[pulumi.Input[_builtins.str]] = None,
                 dead_letter_routing_key: Optional[pulumi.Input[_builtins.str]] = None,
                 exclusive_state: Optional[pulumi.Input[_builtins.bool]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 max_length: Optional[pulumi.Input[_builtins.str]] = None,
                 maximum_priority: Optional[pulumi.Input[_builtins.int]] = None,
                 message_ttl: Optional[pulumi.Input[_builtins.str]] = None,
                 queue_name: Optional[pulumi.Input[_builtins.str]] = None,
                 virtual_host_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = QueueArgs.__new__(QueueArgs)

            __props__.__dict__["auto_delete_state"] = auto_delete_state
            __props__.__dict__["auto_expire_state"] = auto_expire_state
            __props__.__dict__["dead_letter_exchange"] = dead_letter_exchange
            __props__.__dict__["dead_letter_routing_key"] = dead_letter_routing_key
            __props__.__dict__["exclusive_state"] = exclusive_state
            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
            __props__.__dict__["max_length"] = max_length
            __props__.__dict__["maximum_priority"] = maximum_priority
            __props__.__dict__["message_ttl"] = message_ttl
            if queue_name is None and not opts.urn:
                raise TypeError("Missing required property 'queue_name'")
            __props__.__dict__["queue_name"] = queue_name
            if virtual_host_name is None and not opts.urn:
                raise TypeError("Missing required property 'virtual_host_name'")
            __props__.__dict__["virtual_host_name"] = virtual_host_name
        super(Queue, __self__).__init__(
            'alicloud:amqp/queue:Queue',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auto_delete_state: Optional[pulumi.Input[_builtins.bool]] = None,
            auto_expire_state: Optional[pulumi.Input[_builtins.str]] = None,
            dead_letter_exchange: Optional[pulumi.Input[_builtins.str]] = None,
            dead_letter_routing_key: Optional[pulumi.Input[_builtins.str]] = None,
            exclusive_state: Optional[pulumi.Input[_builtins.bool]] = None,
            instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            max_length: Optional[pulumi.Input[_builtins.str]] = None,
            maximum_priority: Optional[pulumi.Input[_builtins.int]] = None,
            message_ttl: Optional[pulumi.Input[_builtins.str]] = None,
            queue_name: Optional[pulumi.Input[_builtins.str]] = None,
            virtual_host_name: Optional[pulumi.Input[_builtins.str]] = None) -> 'Queue':
        """
        Get an existing Queue resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] auto_delete_state: Specifies whether the Auto Delete attribute is configured. Valid values:
               * true: The Auto Delete attribute is configured. The queue is automatically deleted after the last subscription from consumers to this queue is canceled.
               * false: The Auto Delete attribute is not configured.
        :param pulumi.Input[_builtins.str] auto_expire_state: The validity period after which the queue is automatically deleted.
               If the queue is not accessed within a specified period of time, it is automatically deleted.
        :param pulumi.Input[_builtins.str] dead_letter_exchange: The dead-letter exchange. A dead-letter exchange is used to receive rejected messages. 
               If a consumer rejects a message that cannot be retried, this message is routed to a specified dead-letter exchange.
               Then, the dead-letter exchange routes the message to the queue that is bound to the dead-letter exchange.
        :param pulumi.Input[_builtins.str] dead_letter_routing_key: The dead letter routing key.
        :param pulumi.Input[_builtins.bool] exclusive_state: Specifies whether the queue is an exclusive queue. Valid values:
               * true: The queue is an exclusive queue. It can be used only for the connection that declares the exclusive queue. After the connection is closed, the exclusive queue is automatically deleted.
               * false: The queue is not an exclusive queue.
        :param pulumi.Input[_builtins.str] instance_id: The ID of the instance.
        :param pulumi.Input[_builtins.str] max_length: The maximum number of messages that can be stored in the queue.
               If this threshold is exceeded, the earliest messages that are routed to the queue are discarded.
        :param pulumi.Input[_builtins.int] maximum_priority: The highest priority supported by the queue. This parameter is set to a positive integer.
               Valid values: 0 to 255. Recommended values: 1 to 10
        :param pulumi.Input[_builtins.str] message_ttl: The message TTL of the queue.
               If the retention period of a message in the queue exceeds the message TTL of the queue, the message expires.
               Message TTL must be set to a non-negative integer, in milliseconds.
               For example, if the message TTL of the queue is 1000, messages survive for at most 1 second in the queue.
        :param pulumi.Input[_builtins.str] queue_name: The name of the queue.
               The queue name must be 1 to 255 characters in length, and can contain only letters, digits, hyphens (-), underscores (_), periods (.), and at signs (@).
        :param pulumi.Input[_builtins.str] virtual_host_name: The name of the virtual host.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _QueueState.__new__(_QueueState)

        __props__.__dict__["auto_delete_state"] = auto_delete_state
        __props__.__dict__["auto_expire_state"] = auto_expire_state
        __props__.__dict__["dead_letter_exchange"] = dead_letter_exchange
        __props__.__dict__["dead_letter_routing_key"] = dead_letter_routing_key
        __props__.__dict__["exclusive_state"] = exclusive_state
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["max_length"] = max_length
        __props__.__dict__["maximum_priority"] = maximum_priority
        __props__.__dict__["message_ttl"] = message_ttl
        __props__.__dict__["queue_name"] = queue_name
        __props__.__dict__["virtual_host_name"] = virtual_host_name
        return Queue(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="autoDeleteState")
    def auto_delete_state(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether the Auto Delete attribute is configured. Valid values:
        * true: The Auto Delete attribute is configured. The queue is automatically deleted after the last subscription from consumers to this queue is canceled.
        * false: The Auto Delete attribute is not configured.
        """
        return pulumi.get(self, "auto_delete_state")

    @_builtins.property
    @pulumi.getter(name="autoExpireState")
    def auto_expire_state(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The validity period after which the queue is automatically deleted.
        If the queue is not accessed within a specified period of time, it is automatically deleted.
        """
        return pulumi.get(self, "auto_expire_state")

    @_builtins.property
    @pulumi.getter(name="deadLetterExchange")
    def dead_letter_exchange(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The dead-letter exchange. A dead-letter exchange is used to receive rejected messages. 
        If a consumer rejects a message that cannot be retried, this message is routed to a specified dead-letter exchange.
        Then, the dead-letter exchange routes the message to the queue that is bound to the dead-letter exchange.
        """
        return pulumi.get(self, "dead_letter_exchange")

    @_builtins.property
    @pulumi.getter(name="deadLetterRoutingKey")
    def dead_letter_routing_key(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The dead letter routing key.
        """
        return pulumi.get(self, "dead_letter_routing_key")

    @_builtins.property
    @pulumi.getter(name="exclusiveState")
    def exclusive_state(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether the queue is an exclusive queue. Valid values:
        * true: The queue is an exclusive queue. It can be used only for the connection that declares the exclusive queue. After the connection is closed, the exclusive queue is automatically deleted.
        * false: The queue is not an exclusive queue.
        """
        return pulumi.get(self, "exclusive_state")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the instance.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter(name="maxLength")
    def max_length(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The maximum number of messages that can be stored in the queue.
        If this threshold is exceeded, the earliest messages that are routed to the queue are discarded.
        """
        return pulumi.get(self, "max_length")

    @_builtins.property
    @pulumi.getter(name="maximumPriority")
    def maximum_priority(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The highest priority supported by the queue. This parameter is set to a positive integer.
        Valid values: 0 to 255. Recommended values: 1 to 10
        """
        return pulumi.get(self, "maximum_priority")

    @_builtins.property
    @pulumi.getter(name="messageTtl")
    def message_ttl(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The message TTL of the queue.
        If the retention period of a message in the queue exceeds the message TTL of the queue, the message expires.
        Message TTL must be set to a non-negative integer, in milliseconds.
        For example, if the message TTL of the queue is 1000, messages survive for at most 1 second in the queue.
        """
        return pulumi.get(self, "message_ttl")

    @_builtins.property
    @pulumi.getter(name="queueName")
    def queue_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the queue.
        The queue name must be 1 to 255 characters in length, and can contain only letters, digits, hyphens (-), underscores (_), periods (.), and at signs (@).
        """
        return pulumi.get(self, "queue_name")

    @_builtins.property
    @pulumi.getter(name="virtualHostName")
    def virtual_host_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the virtual host.
        """
        return pulumi.get(self, "virtual_host_name")

