# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['PluginArgs', 'Plugin']

@pulumi.input_type
class PluginArgs:
    def __init__(__self__, *,
                 plugin_data: pulumi.Input[_builtins.str],
                 plugin_name: pulumi.Input[_builtins.str],
                 plugin_type: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a Plugin resource.
        :param pulumi.Input[_builtins.str] plugin_data: The definition statement of the plug-in. Plug-in definition statements in the JSON and YAML formats are supported.
        :param pulumi.Input[_builtins.str] plugin_name: The name of the plug-in that you want to create. It can contain uppercase English letters, lowercase English letters, Chinese characters, numbers, and underscores (_). It must be 4 to 50 characters in length and cannot start with an underscore (_).
        :param pulumi.Input[_builtins.str] plugin_type: The type of the plug-in. Valid values:
               - "trafficControl"
               - "ipControl"
               - "backendSignature"
               - "jwtAuth"
               - "basicAuth"
               - "cors"
               - "caching"
               - "routing"
               - "accessControl"
               - "errorMapping"
               - "circuitBreaker"
               - "remoteAuth"
               - "logMask"
               - "transformer".
        :param pulumi.Input[_builtins.str] description: The description of the plug-in, which cannot exceed 200 characters.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tag of the resource.
        """
        pulumi.set(__self__, "plugin_data", plugin_data)
        pulumi.set(__self__, "plugin_name", plugin_name)
        pulumi.set(__self__, "plugin_type", plugin_type)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="pluginData")
    def plugin_data(self) -> pulumi.Input[_builtins.str]:
        """
        The definition statement of the plug-in. Plug-in definition statements in the JSON and YAML formats are supported.
        """
        return pulumi.get(self, "plugin_data")

    @plugin_data.setter
    def plugin_data(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "plugin_data", value)

    @_builtins.property
    @pulumi.getter(name="pluginName")
    def plugin_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the plug-in that you want to create. It can contain uppercase English letters, lowercase English letters, Chinese characters, numbers, and underscores (_). It must be 4 to 50 characters in length and cannot start with an underscore (_).
        """
        return pulumi.get(self, "plugin_name")

    @plugin_name.setter
    def plugin_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "plugin_name", value)

    @_builtins.property
    @pulumi.getter(name="pluginType")
    def plugin_type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of the plug-in. Valid values:
        - "trafficControl"
        - "ipControl"
        - "backendSignature"
        - "jwtAuth"
        - "basicAuth"
        - "cors"
        - "caching"
        - "routing"
        - "accessControl"
        - "errorMapping"
        - "circuitBreaker"
        - "remoteAuth"
        - "logMask"
        - "transformer".
        """
        return pulumi.get(self, "plugin_type")

    @plugin_type.setter
    def plugin_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "plugin_type", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the plug-in, which cannot exceed 200 characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The tag of the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _PluginState:
    def __init__(__self__, *,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 plugin_data: Optional[pulumi.Input[_builtins.str]] = None,
                 plugin_name: Optional[pulumi.Input[_builtins.str]] = None,
                 plugin_type: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering Plugin resources.
        :param pulumi.Input[_builtins.str] create_time: Create time.
        :param pulumi.Input[_builtins.str] description: The description of the plug-in, which cannot exceed 200 characters.
        :param pulumi.Input[_builtins.str] plugin_data: The definition statement of the plug-in. Plug-in definition statements in the JSON and YAML formats are supported.
        :param pulumi.Input[_builtins.str] plugin_name: The name of the plug-in that you want to create. It can contain uppercase English letters, lowercase English letters, Chinese characters, numbers, and underscores (_). It must be 4 to 50 characters in length and cannot start with an underscore (_).
        :param pulumi.Input[_builtins.str] plugin_type: The type of the plug-in. Valid values:
               - "trafficControl"
               - "ipControl"
               - "backendSignature"
               - "jwtAuth"
               - "basicAuth"
               - "cors"
               - "caching"
               - "routing"
               - "accessControl"
               - "errorMapping"
               - "circuitBreaker"
               - "remoteAuth"
               - "logMask"
               - "transformer".
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tag of the resource.
        """
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if plugin_data is not None:
            pulumi.set(__self__, "plugin_data", plugin_data)
        if plugin_name is not None:
            pulumi.set(__self__, "plugin_name", plugin_name)
        if plugin_type is not None:
            pulumi.set(__self__, "plugin_type", plugin_type)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Create time.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the plug-in, which cannot exceed 200 characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="pluginData")
    def plugin_data(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The definition statement of the plug-in. Plug-in definition statements in the JSON and YAML formats are supported.
        """
        return pulumi.get(self, "plugin_data")

    @plugin_data.setter
    def plugin_data(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "plugin_data", value)

    @_builtins.property
    @pulumi.getter(name="pluginName")
    def plugin_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the plug-in that you want to create. It can contain uppercase English letters, lowercase English letters, Chinese characters, numbers, and underscores (_). It must be 4 to 50 characters in length and cannot start with an underscore (_).
        """
        return pulumi.get(self, "plugin_name")

    @plugin_name.setter
    def plugin_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "plugin_name", value)

    @_builtins.property
    @pulumi.getter(name="pluginType")
    def plugin_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the plug-in. Valid values:
        - "trafficControl"
        - "ipControl"
        - "backendSignature"
        - "jwtAuth"
        - "basicAuth"
        - "cors"
        - "caching"
        - "routing"
        - "accessControl"
        - "errorMapping"
        - "circuitBreaker"
        - "remoteAuth"
        - "logMask"
        - "transformer".
        """
        return pulumi.get(self, "plugin_type")

    @plugin_type.setter
    def plugin_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "plugin_type", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The tag of the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("alicloud:apigateway/plugin:Plugin")
class Plugin(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 plugin_data: Optional[pulumi.Input[_builtins.str]] = None,
                 plugin_name: Optional[pulumi.Input[_builtins.str]] = None,
                 plugin_type: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Provides a Api Gateway Plugin resource.

        For information about Api Gateway Plugin and how to use it, see [What is Plugin](https://www.alibabacloud.com/help/en/api-gateway/developer-reference/api-cloudapi-2016-07-14-createplugin).

        > **NOTE:** Available since v1.187.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import json
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform_example"
        default = alicloud.apigateway.Plugin("default",
            description=name,
            plugin_name=name,
            plugin_data=json.dumps({
                "routes": [
                    {
                        "name": "Vip",
                        "condition": "$CaAppId = 123456",
                        "backend": {
                            "type": "HTTP-VPC",
                            "vpcAccessName": "slbAccessForVip",
                        },
                    },
                    {
                        "name": "MockForOldClient",
                        "condition": "$ClientVersion < '2.0.5'",
                        "backend": {
                            "type": "MOCK",
                            "statusCode": 400,
                            "mockBody": "This version is not supported!!!",
                        },
                    },
                    {
                        "name": "BlueGreenPercent05",
                        "condition": "1 = 1",
                        "backend": {
                            "type": "HTTP",
                            "address": "https://beta-version.api.foo.com",
                        },
                        "constant-parameters": [{
                            "name": "x-route-blue-green",
                            "location": "header",
                            "value": "route-blue-green",
                        }],
                    },
                ],
            }),
            plugin_type="routing")
        ```

        ## Import

        Api Gateway Plugin can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:apigateway/plugin:Plugin example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: The description of the plug-in, which cannot exceed 200 characters.
        :param pulumi.Input[_builtins.str] plugin_data: The definition statement of the plug-in. Plug-in definition statements in the JSON and YAML formats are supported.
        :param pulumi.Input[_builtins.str] plugin_name: The name of the plug-in that you want to create. It can contain uppercase English letters, lowercase English letters, Chinese characters, numbers, and underscores (_). It must be 4 to 50 characters in length and cannot start with an underscore (_).
        :param pulumi.Input[_builtins.str] plugin_type: The type of the plug-in. Valid values:
               - "trafficControl"
               - "ipControl"
               - "backendSignature"
               - "jwtAuth"
               - "basicAuth"
               - "cors"
               - "caching"
               - "routing"
               - "accessControl"
               - "errorMapping"
               - "circuitBreaker"
               - "remoteAuth"
               - "logMask"
               - "transformer".
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tag of the resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PluginArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Api Gateway Plugin resource.

        For information about Api Gateway Plugin and how to use it, see [What is Plugin](https://www.alibabacloud.com/help/en/api-gateway/developer-reference/api-cloudapi-2016-07-14-createplugin).

        > **NOTE:** Available since v1.187.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import json
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform_example"
        default = alicloud.apigateway.Plugin("default",
            description=name,
            plugin_name=name,
            plugin_data=json.dumps({
                "routes": [
                    {
                        "name": "Vip",
                        "condition": "$CaAppId = 123456",
                        "backend": {
                            "type": "HTTP-VPC",
                            "vpcAccessName": "slbAccessForVip",
                        },
                    },
                    {
                        "name": "MockForOldClient",
                        "condition": "$ClientVersion < '2.0.5'",
                        "backend": {
                            "type": "MOCK",
                            "statusCode": 400,
                            "mockBody": "This version is not supported!!!",
                        },
                    },
                    {
                        "name": "BlueGreenPercent05",
                        "condition": "1 = 1",
                        "backend": {
                            "type": "HTTP",
                            "address": "https://beta-version.api.foo.com",
                        },
                        "constant-parameters": [{
                            "name": "x-route-blue-green",
                            "location": "header",
                            "value": "route-blue-green",
                        }],
                    },
                ],
            }),
            plugin_type="routing")
        ```

        ## Import

        Api Gateway Plugin can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:apigateway/plugin:Plugin example <id>
        ```

        :param str resource_name: The name of the resource.
        :param PluginArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PluginArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 plugin_data: Optional[pulumi.Input[_builtins.str]] = None,
                 plugin_name: Optional[pulumi.Input[_builtins.str]] = None,
                 plugin_type: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PluginArgs.__new__(PluginArgs)

            __props__.__dict__["description"] = description
            if plugin_data is None and not opts.urn:
                raise TypeError("Missing required property 'plugin_data'")
            __props__.__dict__["plugin_data"] = plugin_data
            if plugin_name is None and not opts.urn:
                raise TypeError("Missing required property 'plugin_name'")
            __props__.__dict__["plugin_name"] = plugin_name
            if plugin_type is None and not opts.urn:
                raise TypeError("Missing required property 'plugin_type'")
            __props__.__dict__["plugin_type"] = plugin_type
            __props__.__dict__["tags"] = tags
            __props__.__dict__["create_time"] = None
        super(Plugin, __self__).__init__(
            'alicloud:apigateway/plugin:Plugin',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            plugin_data: Optional[pulumi.Input[_builtins.str]] = None,
            plugin_name: Optional[pulumi.Input[_builtins.str]] = None,
            plugin_type: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None) -> 'Plugin':
        """
        Get an existing Plugin resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] create_time: Create time.
        :param pulumi.Input[_builtins.str] description: The description of the plug-in, which cannot exceed 200 characters.
        :param pulumi.Input[_builtins.str] plugin_data: The definition statement of the plug-in. Plug-in definition statements in the JSON and YAML formats are supported.
        :param pulumi.Input[_builtins.str] plugin_name: The name of the plug-in that you want to create. It can contain uppercase English letters, lowercase English letters, Chinese characters, numbers, and underscores (_). It must be 4 to 50 characters in length and cannot start with an underscore (_).
        :param pulumi.Input[_builtins.str] plugin_type: The type of the plug-in. Valid values:
               - "trafficControl"
               - "ipControl"
               - "backendSignature"
               - "jwtAuth"
               - "basicAuth"
               - "cors"
               - "caching"
               - "routing"
               - "accessControl"
               - "errorMapping"
               - "circuitBreaker"
               - "remoteAuth"
               - "logMask"
               - "transformer".
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tag of the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PluginState.__new__(_PluginState)

        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["description"] = description
        __props__.__dict__["plugin_data"] = plugin_data
        __props__.__dict__["plugin_name"] = plugin_name
        __props__.__dict__["plugin_type"] = plugin_type
        __props__.__dict__["tags"] = tags
        return Plugin(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        Create time.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of the plug-in, which cannot exceed 200 characters.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="pluginData")
    def plugin_data(self) -> pulumi.Output[_builtins.str]:
        """
        The definition statement of the plug-in. Plug-in definition statements in the JSON and YAML formats are supported.
        """
        return pulumi.get(self, "plugin_data")

    @_builtins.property
    @pulumi.getter(name="pluginName")
    def plugin_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the plug-in that you want to create. It can contain uppercase English letters, lowercase English letters, Chinese characters, numbers, and underscores (_). It must be 4 to 50 characters in length and cannot start with an underscore (_).
        """
        return pulumi.get(self, "plugin_name")

    @_builtins.property
    @pulumi.getter(name="pluginType")
    def plugin_type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of the plug-in. Valid values:
        - "trafficControl"
        - "ipControl"
        - "backendSignature"
        - "jwtAuth"
        - "basicAuth"
        - "cors"
        - "caching"
        - "routing"
        - "accessControl"
        - "errorMapping"
        - "circuitBreaker"
        - "remoteAuth"
        - "logMask"
        - "transformer".
        """
        return pulumi.get(self, "plugin_type")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        The tag of the resource.
        """
        return pulumi.get(self, "tags")

