# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetPrometheusMonitoringsResult',
    'AwaitableGetPrometheusMonitoringsResult',
    'get_prometheus_monitorings',
    'get_prometheus_monitorings_output',
]

@pulumi.output_type
class GetPrometheusMonitoringsResult:
    """
    A collection of values returned by getPrometheusMonitorings.
    """
    def __init__(__self__, cluster_id=None, id=None, ids=None, name_regex=None, names=None, output_file=None, prometheus_monitorings=None, status=None, type=None):
        if cluster_id and not isinstance(cluster_id, str):
            raise TypeError("Expected argument 'cluster_id' to be a str")
        pulumi.set(__self__, "cluster_id", cluster_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if name_regex and not isinstance(name_regex, str):
            raise TypeError("Expected argument 'name_regex' to be a str")
        pulumi.set(__self__, "name_regex", name_regex)
        if names and not isinstance(names, list):
            raise TypeError("Expected argument 'names' to be a list")
        pulumi.set(__self__, "names", names)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if prometheus_monitorings and not isinstance(prometheus_monitorings, list):
            raise TypeError("Expected argument 'prometheus_monitorings' to be a list")
        pulumi.set(__self__, "prometheus_monitorings", prometheus_monitorings)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> _builtins.str:
        """
        The ID of the Prometheus instance.
        """
        return pulumi.get(self, "cluster_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ids(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "ids")

    @_builtins.property
    @pulumi.getter(name="nameRegex")
    def name_regex(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "name_regex")

    @_builtins.property
    @pulumi.getter
    def names(self) -> Sequence[_builtins.str]:
        """
        A list of Prometheus Monitoring names.
        """
        return pulumi.get(self, "names")

    @_builtins.property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "output_file")

    @_builtins.property
    @pulumi.getter(name="prometheusMonitorings")
    def prometheus_monitorings(self) -> Sequence['outputs.GetPrometheusMonitoringsPrometheusMonitoringResult']:
        """
        A list of Prometheus Monitorings. Each element contains the following attributes:
        """
        return pulumi.get(self, "prometheus_monitorings")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        """
        The status of the monitoring configuration.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        The type of the monitoring configuration.
        """
        return pulumi.get(self, "type")


class AwaitableGetPrometheusMonitoringsResult(GetPrometheusMonitoringsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPrometheusMonitoringsResult(
            cluster_id=self.cluster_id,
            id=self.id,
            ids=self.ids,
            name_regex=self.name_regex,
            names=self.names,
            output_file=self.output_file,
            prometheus_monitorings=self.prometheus_monitorings,
            status=self.status,
            type=self.type)


def get_prometheus_monitorings(cluster_id: Optional[_builtins.str] = None,
                               ids: Optional[Sequence[_builtins.str]] = None,
                               name_regex: Optional[_builtins.str] = None,
                               output_file: Optional[_builtins.str] = None,
                               status: Optional[_builtins.str] = None,
                               type: Optional[_builtins.str] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPrometheusMonitoringsResult:
    """
    This data source provides the Arms Prometheus Monitorings of the current Alibaba Cloud user.

    > **NOTE:** Available since v1.210.0.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    ids = alicloud.arms.get_prometheus_monitorings(cluster_id="your_cluster_id",
        ids=["example_id"])
    pulumi.export("armsPrometheusMonitoringsId1", ids.prometheus_monitorings[0].id)
    name_regex = alicloud.arms.get_prometheus_monitorings(cluster_id="your_cluster_id",
        name_regex="tf-example")
    pulumi.export("armsPrometheusMonitoringsId2", name_regex.prometheus_monitorings[0].id)
    ```


    :param _builtins.str cluster_id: The ID of the Prometheus instance.
    :param Sequence[_builtins.str] ids: A list of Prometheus Monitoring IDs.
    :param _builtins.str name_regex: A regex string to filter results by Prometheus Monitoring name.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str status: The status of the monitoring configuration. Valid values: `run`, `stop`.
    :param _builtins.str type: The type of the monitoring configuration. Valid values: `serviceMonitor`, `podMonitor`, `customJob`, `probe`.
    """
    __args__ = dict()
    __args__['clusterId'] = cluster_id
    __args__['ids'] = ids
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    __args__['status'] = status
    __args__['type'] = type
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:arms/getPrometheusMonitorings:getPrometheusMonitorings', __args__, opts=opts, typ=GetPrometheusMonitoringsResult).value

    return AwaitableGetPrometheusMonitoringsResult(
        cluster_id=pulumi.get(__ret__, 'cluster_id'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        name_regex=pulumi.get(__ret__, 'name_regex'),
        names=pulumi.get(__ret__, 'names'),
        output_file=pulumi.get(__ret__, 'output_file'),
        prometheus_monitorings=pulumi.get(__ret__, 'prometheus_monitorings'),
        status=pulumi.get(__ret__, 'status'),
        type=pulumi.get(__ret__, 'type'))
def get_prometheus_monitorings_output(cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                                      ids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                                      name_regex: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                      output_file: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                      status: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                      type: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetPrometheusMonitoringsResult]:
    """
    This data source provides the Arms Prometheus Monitorings of the current Alibaba Cloud user.

    > **NOTE:** Available since v1.210.0.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    ids = alicloud.arms.get_prometheus_monitorings(cluster_id="your_cluster_id",
        ids=["example_id"])
    pulumi.export("armsPrometheusMonitoringsId1", ids.prometheus_monitorings[0].id)
    name_regex = alicloud.arms.get_prometheus_monitorings(cluster_id="your_cluster_id",
        name_regex="tf-example")
    pulumi.export("armsPrometheusMonitoringsId2", name_regex.prometheus_monitorings[0].id)
    ```


    :param _builtins.str cluster_id: The ID of the Prometheus instance.
    :param Sequence[_builtins.str] ids: A list of Prometheus Monitoring IDs.
    :param _builtins.str name_regex: A regex string to filter results by Prometheus Monitoring name.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str status: The status of the monitoring configuration. Valid values: `run`, `stop`.
    :param _builtins.str type: The type of the monitoring configuration. Valid values: `serviceMonitor`, `podMonitor`, `customJob`, `probe`.
    """
    __args__ = dict()
    __args__['clusterId'] = cluster_id
    __args__['ids'] = ids
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    __args__['status'] = status
    __args__['type'] = type
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('alicloud:arms/getPrometheusMonitorings:getPrometheusMonitorings', __args__, opts=opts, typ=GetPrometheusMonitoringsResult)
    return __ret__.apply(lambda __response__: GetPrometheusMonitoringsResult(
        cluster_id=pulumi.get(__response__, 'cluster_id'),
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids'),
        name_regex=pulumi.get(__response__, 'name_regex'),
        names=pulumi.get(__response__, 'names'),
        output_file=pulumi.get(__response__, 'output_file'),
        prometheus_monitorings=pulumi.get(__response__, 'prometheus_monitorings'),
        status=pulumi.get(__response__, 'status'),
        type=pulumi.get(__response__, 'type')))
