# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetBackupPlansPlanResult',
    'GetClustersClusterResult',
    'GetDataCentersCenterResult',
    'GetZonesZoneResult',
]

@pulumi.output_type
class GetBackupPlansPlanResult(dict):
    def __init__(__self__, *,
                 active: _builtins.bool,
                 backup_period: _builtins.str,
                 backup_time: _builtins.str,
                 cluster_id: _builtins.str,
                 create_time: _builtins.str,
                 data_center_id: _builtins.str,
                 id: _builtins.str,
                 retention_period: _builtins.int):
        """
        :param _builtins.bool active: Specifies whether to activate the backup plan.
        :param _builtins.str backup_period: The backup cycle. Valid values: Monday, Tuesday, Wednesday, Thursday, Friday, Saturday, and Sunday.
        :param _builtins.str backup_time: The start time of the backup task each day. The time is displayed in UTC and denoted by Z.
        :param _builtins.str cluster_id: The ID of the cluster for the backup.
        :param _builtins.str create_time: The time when the backup plan was created.
        :param _builtins.str data_center_id: The ID of the data center for the backup in the cluster.
        :param _builtins.str id: The ID of the Backup Plan.
        :param _builtins.int retention_period: The duration for which you want to retain the backup. Valid values: 1 to 30. Unit: days.
        """
        pulumi.set(__self__, "active", active)
        pulumi.set(__self__, "backup_period", backup_period)
        pulumi.set(__self__, "backup_time", backup_time)
        pulumi.set(__self__, "cluster_id", cluster_id)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "data_center_id", data_center_id)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "retention_period", retention_period)

    @_builtins.property
    @pulumi.getter
    def active(self) -> _builtins.bool:
        """
        Specifies whether to activate the backup plan.
        """
        return pulumi.get(self, "active")

    @_builtins.property
    @pulumi.getter(name="backupPeriod")
    def backup_period(self) -> _builtins.str:
        """
        The backup cycle. Valid values: Monday, Tuesday, Wednesday, Thursday, Friday, Saturday, and Sunday.
        """
        return pulumi.get(self, "backup_period")

    @_builtins.property
    @pulumi.getter(name="backupTime")
    def backup_time(self) -> _builtins.str:
        """
        The start time of the backup task each day. The time is displayed in UTC and denoted by Z.
        """
        return pulumi.get(self, "backup_time")

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> _builtins.str:
        """
        The ID of the cluster for the backup.
        """
        return pulumi.get(self, "cluster_id")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> _builtins.str:
        """
        The time when the backup plan was created.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="dataCenterId")
    def data_center_id(self) -> _builtins.str:
        """
        The ID of the data center for the backup in the cluster.
        """
        return pulumi.get(self, "data_center_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Backup Plan.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="retentionPeriod")
    def retention_period(self) -> _builtins.int:
        """
        The duration for which you want to retain the backup. Valid values: 1 to 30. Unit: days.
        """
        return pulumi.get(self, "retention_period")


@pulumi.output_type
class GetClustersClusterResult(dict):
    def __init__(__self__, *,
                 cluster_id: _builtins.str,
                 cluster_name: _builtins.str,
                 created_time: _builtins.str,
                 data_center_count: _builtins.int,
                 expire_time: _builtins.str,
                 id: _builtins.str,
                 lock_mode: _builtins.str,
                 major_version: _builtins.str,
                 minor_version: _builtins.str,
                 pay_type: _builtins.str,
                 status: _builtins.str,
                 tags: Optional[Mapping[str, _builtins.str]] = None):
        """
        :param _builtins.str cluster_id: The ID of the Cassandra cluster.
        :param _builtins.str cluster_name: The name of the Cassandra cluster.
        :param _builtins.int data_center_count: The count of data centers
        :param _builtins.str expire_time: The expire time of the cluster.
        :param _builtins.str id: The ID of the Cassandra cluster.
        :param _builtins.str lock_mode: The lock mode of the cluster.
        :param _builtins.str major_version: The major version of the cluster.
        :param _builtins.str minor_version: The minor version of the cluster.
        :param _builtins.str pay_type: Billing method. Value options are `Subscription` for Pay-As-You-Go and `PayAsYouGo` for yearly or monthly subscription.
        :param _builtins.str status: Status of the cluster.
        :param Mapping[str, _builtins.str] tags: A mapping of tags to assign to the resource.
        """
        pulumi.set(__self__, "cluster_id", cluster_id)
        pulumi.set(__self__, "cluster_name", cluster_name)
        pulumi.set(__self__, "created_time", created_time)
        pulumi.set(__self__, "data_center_count", data_center_count)
        pulumi.set(__self__, "expire_time", expire_time)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "lock_mode", lock_mode)
        pulumi.set(__self__, "major_version", major_version)
        pulumi.set(__self__, "minor_version", minor_version)
        pulumi.set(__self__, "pay_type", pay_type)
        pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> _builtins.str:
        """
        The ID of the Cassandra cluster.
        """
        return pulumi.get(self, "cluster_id")

    @_builtins.property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> _builtins.str:
        """
        The name of the Cassandra cluster.
        """
        return pulumi.get(self, "cluster_name")

    @_builtins.property
    @pulumi.getter(name="createdTime")
    def created_time(self) -> _builtins.str:
        return pulumi.get(self, "created_time")

    @_builtins.property
    @pulumi.getter(name="dataCenterCount")
    def data_center_count(self) -> _builtins.int:
        """
        The count of data centers
        """
        return pulumi.get(self, "data_center_count")

    @_builtins.property
    @pulumi.getter(name="expireTime")
    def expire_time(self) -> _builtins.str:
        """
        The expire time of the cluster.
        """
        return pulumi.get(self, "expire_time")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Cassandra cluster.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="lockMode")
    def lock_mode(self) -> _builtins.str:
        """
        The lock mode of the cluster.
        """
        return pulumi.get(self, "lock_mode")

    @_builtins.property
    @pulumi.getter(name="majorVersion")
    def major_version(self) -> _builtins.str:
        """
        The major version of the cluster.
        """
        return pulumi.get(self, "major_version")

    @_builtins.property
    @pulumi.getter(name="minorVersion")
    def minor_version(self) -> _builtins.str:
        """
        The minor version of the cluster.
        """
        return pulumi.get(self, "minor_version")

    @_builtins.property
    @pulumi.getter(name="payType")
    def pay_type(self) -> _builtins.str:
        """
        Billing method. Value options are `Subscription` for Pay-As-You-Go and `PayAsYouGo` for yearly or monthly subscription.
        """
        return pulumi.get(self, "pay_type")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        Status of the cluster.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class GetDataCentersCenterResult(dict):
    def __init__(__self__, *,
                 cluster_id: _builtins.str,
                 commodity_instance: _builtins.str,
                 created_time: _builtins.str,
                 data_center_id: _builtins.str,
                 data_center_name: _builtins.str,
                 disk_size: _builtins.int,
                 disk_type: _builtins.str,
                 expire_time: _builtins.str,
                 instance_type: _builtins.str,
                 lock_mode: _builtins.str,
                 node_count: _builtins.int,
                 pay_type: _builtins.str,
                 status: _builtins.str,
                 vpc_id: _builtins.str,
                 vswitch_id: _builtins.str,
                 zone_id: _builtins.str):
        """
        :param _builtins.str cluster_id: The cluster id of dataCenters belongs to.
        :param _builtins.str commodity_instance: The commodity ID of the Cassandra dataCenter.
        :param _builtins.str data_center_id: The id of the Cassandra dataCenter.
        :param _builtins.str data_center_name: The name of the Cassandra dataCenter.
        :param _builtins.int disk_size: One node disk size, unit:GB.
        :param _builtins.str disk_type: Cloud_ssd or cloud_efficiency.
        :param _builtins.str expire_time: The expire time of the dataCenter.
        :param _builtins.str instance_type: The instance type of the Cassandra dataCenter, eg: cassandra.c.large.
        :param _builtins.str lock_mode: The lock mode of the dataCenter.
        :param _builtins.int node_count: The node count of dataCenter.
        :param _builtins.str pay_type: Billing method. Value options are `Subscription` for Pay-As-You-Go and `PayAsYouGo` for yearly or monthly subscription.
        :param _builtins.str status: Status of the dataCenter.
        :param _builtins.str vpc_id: VPC ID the dataCenter belongs to.
        :param _builtins.str vswitch_id: VSwitch ID the dataCenter belongs to.
        :param _builtins.str zone_id: Zone ID the dataCenter belongs to.
        """
        pulumi.set(__self__, "cluster_id", cluster_id)
        pulumi.set(__self__, "commodity_instance", commodity_instance)
        pulumi.set(__self__, "created_time", created_time)
        pulumi.set(__self__, "data_center_id", data_center_id)
        pulumi.set(__self__, "data_center_name", data_center_name)
        pulumi.set(__self__, "disk_size", disk_size)
        pulumi.set(__self__, "disk_type", disk_type)
        pulumi.set(__self__, "expire_time", expire_time)
        pulumi.set(__self__, "instance_type", instance_type)
        pulumi.set(__self__, "lock_mode", lock_mode)
        pulumi.set(__self__, "node_count", node_count)
        pulumi.set(__self__, "pay_type", pay_type)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "vpc_id", vpc_id)
        pulumi.set(__self__, "vswitch_id", vswitch_id)
        pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> _builtins.str:
        """
        The cluster id of dataCenters belongs to.
        """
        return pulumi.get(self, "cluster_id")

    @_builtins.property
    @pulumi.getter(name="commodityInstance")
    def commodity_instance(self) -> _builtins.str:
        """
        The commodity ID of the Cassandra dataCenter.
        """
        return pulumi.get(self, "commodity_instance")

    @_builtins.property
    @pulumi.getter(name="createdTime")
    def created_time(self) -> _builtins.str:
        return pulumi.get(self, "created_time")

    @_builtins.property
    @pulumi.getter(name="dataCenterId")
    def data_center_id(self) -> _builtins.str:
        """
        The id of the Cassandra dataCenter.
        """
        return pulumi.get(self, "data_center_id")

    @_builtins.property
    @pulumi.getter(name="dataCenterName")
    def data_center_name(self) -> _builtins.str:
        """
        The name of the Cassandra dataCenter.
        """
        return pulumi.get(self, "data_center_name")

    @_builtins.property
    @pulumi.getter(name="diskSize")
    def disk_size(self) -> _builtins.int:
        """
        One node disk size, unit:GB.
        """
        return pulumi.get(self, "disk_size")

    @_builtins.property
    @pulumi.getter(name="diskType")
    def disk_type(self) -> _builtins.str:
        """
        Cloud_ssd or cloud_efficiency.
        """
        return pulumi.get(self, "disk_type")

    @_builtins.property
    @pulumi.getter(name="expireTime")
    def expire_time(self) -> _builtins.str:
        """
        The expire time of the dataCenter.
        """
        return pulumi.get(self, "expire_time")

    @_builtins.property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> _builtins.str:
        """
        The instance type of the Cassandra dataCenter, eg: cassandra.c.large.
        """
        return pulumi.get(self, "instance_type")

    @_builtins.property
    @pulumi.getter(name="lockMode")
    def lock_mode(self) -> _builtins.str:
        """
        The lock mode of the dataCenter.
        """
        return pulumi.get(self, "lock_mode")

    @_builtins.property
    @pulumi.getter(name="nodeCount")
    def node_count(self) -> _builtins.int:
        """
        The node count of dataCenter.
        """
        return pulumi.get(self, "node_count")

    @_builtins.property
    @pulumi.getter(name="payType")
    def pay_type(self) -> _builtins.str:
        """
        Billing method. Value options are `Subscription` for Pay-As-You-Go and `PayAsYouGo` for yearly or monthly subscription.
        """
        return pulumi.get(self, "pay_type")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        Status of the dataCenter.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> _builtins.str:
        """
        VPC ID the dataCenter belongs to.
        """
        return pulumi.get(self, "vpc_id")

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> _builtins.str:
        """
        VSwitch ID the dataCenter belongs to.
        """
        return pulumi.get(self, "vswitch_id")

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> _builtins.str:
        """
        Zone ID the dataCenter belongs to.
        """
        return pulumi.get(self, "zone_id")


@pulumi.output_type
class GetZonesZoneResult(dict):
    def __init__(__self__, *,
                 id: _builtins.str,
                 multi_zone_ids: Sequence[_builtins.str]):
        """
        :param _builtins.str id: ID of the zone.
        :param Sequence[_builtins.str] multi_zone_ids: A list of zone ids in which the multi zone.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "multi_zone_ids", multi_zone_ids)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        ID of the zone.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="multiZoneIds")
    def multi_zone_ids(self) -> Sequence[_builtins.str]:
        """
        A list of zone ids in which the multi zone.
        """
        return pulumi.get(self, "multi_zone_ids")


