# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'DedicatedPropreHostEcsClassList',
    'GetDedicatedHostAccountsAccountResult',
    'GetDedicatedHostGroupsGroupResult',
    'GetDedicatedHostGroupsGroupDedicatedHostCountGroupByHostTypeResult',
    'GetDedicatedHostGroupsGroupZoneIdListResult',
    'GetDedicatedHostsHostResult',
    'GetHostEcsLevelInfosInfoResult',
    'GetZonesZoneResult',
]

@pulumi.output_type
class DedicatedPropreHostEcsClassList(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceType":
            suggest = "instance_type"
        elif key == "sysDiskCapacity":
            suggest = "sys_disk_capacity"
        elif key == "sysDiskType":
            suggest = "sys_disk_type"
        elif key == "dataDiskPerformanceLevel":
            suggest = "data_disk_performance_level"
        elif key == "diskCapacity":
            suggest = "disk_capacity"
        elif key == "diskCount":
            suggest = "disk_count"
        elif key == "diskType":
            suggest = "disk_type"
        elif key == "systemDiskPerformanceLevel":
            suggest = "system_disk_performance_level"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DedicatedPropreHostEcsClassList. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DedicatedPropreHostEcsClassList.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DedicatedPropreHostEcsClassList.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 instance_type: _builtins.str,
                 sys_disk_capacity: _builtins.int,
                 sys_disk_type: _builtins.str,
                 data_disk_performance_level: Optional[_builtins.str] = None,
                 disk_capacity: Optional[_builtins.int] = None,
                 disk_count: Optional[_builtins.int] = None,
                 disk_type: Optional[_builtins.str] = None,
                 system_disk_performance_level: Optional[_builtins.str] = None):
        """
        :param _builtins.str instance_type: ECS specifications.
        :param _builtins.int sys_disk_capacity: System disk capacity.
        :param _builtins.str sys_disk_type: System disk type, value:
               - **cloud_essd**: the ESSD cloud disk.
               - **cloud_ssd**: SSD cloud disk.
               - **cloud_efficiency**: The ultra cloud disk.
               - **cloud_auto**: ESSD AutoPL cloud disk.
        :param _builtins.str data_disk_performance_level: Data disk PL level.
        :param _builtins.int disk_capacity: The capacity of the data disk.
        :param _builtins.int disk_count: Number of mounted data disks.
        :param _builtins.str disk_type: Data disk type, value range:
               - **cloud_essd**: the ESSD cloud disk.
               - **cloud_ssd**: SSD cloud disk.
               - **cloud_efficiency**: The ultra cloud disk.
               - **cloud_auto**: ESSD AutoPL cloud disk.
        :param _builtins.str system_disk_performance_level: System disk PL level.
        """
        pulumi.set(__self__, "instance_type", instance_type)
        pulumi.set(__self__, "sys_disk_capacity", sys_disk_capacity)
        pulumi.set(__self__, "sys_disk_type", sys_disk_type)
        if data_disk_performance_level is not None:
            pulumi.set(__self__, "data_disk_performance_level", data_disk_performance_level)
        if disk_capacity is not None:
            pulumi.set(__self__, "disk_capacity", disk_capacity)
        if disk_count is not None:
            pulumi.set(__self__, "disk_count", disk_count)
        if disk_type is not None:
            pulumi.set(__self__, "disk_type", disk_type)
        if system_disk_performance_level is not None:
            pulumi.set(__self__, "system_disk_performance_level", system_disk_performance_level)

    @_builtins.property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> _builtins.str:
        """
        ECS specifications.
        """
        return pulumi.get(self, "instance_type")

    @_builtins.property
    @pulumi.getter(name="sysDiskCapacity")
    def sys_disk_capacity(self) -> _builtins.int:
        """
        System disk capacity.
        """
        return pulumi.get(self, "sys_disk_capacity")

    @_builtins.property
    @pulumi.getter(name="sysDiskType")
    def sys_disk_type(self) -> _builtins.str:
        """
        System disk type, value:
        - **cloud_essd**: the ESSD cloud disk.
        - **cloud_ssd**: SSD cloud disk.
        - **cloud_efficiency**: The ultra cloud disk.
        - **cloud_auto**: ESSD AutoPL cloud disk.
        """
        return pulumi.get(self, "sys_disk_type")

    @_builtins.property
    @pulumi.getter(name="dataDiskPerformanceLevel")
    def data_disk_performance_level(self) -> Optional[_builtins.str]:
        """
        Data disk PL level.
        """
        return pulumi.get(self, "data_disk_performance_level")

    @_builtins.property
    @pulumi.getter(name="diskCapacity")
    def disk_capacity(self) -> Optional[_builtins.int]:
        """
        The capacity of the data disk.
        """
        return pulumi.get(self, "disk_capacity")

    @_builtins.property
    @pulumi.getter(name="diskCount")
    def disk_count(self) -> Optional[_builtins.int]:
        """
        Number of mounted data disks.
        """
        return pulumi.get(self, "disk_count")

    @_builtins.property
    @pulumi.getter(name="diskType")
    def disk_type(self) -> Optional[_builtins.str]:
        """
        Data disk type, value range:
        - **cloud_essd**: the ESSD cloud disk.
        - **cloud_ssd**: SSD cloud disk.
        - **cloud_efficiency**: The ultra cloud disk.
        - **cloud_auto**: ESSD AutoPL cloud disk.
        """
        return pulumi.get(self, "disk_type")

    @_builtins.property
    @pulumi.getter(name="systemDiskPerformanceLevel")
    def system_disk_performance_level(self) -> Optional[_builtins.str]:
        """
        System disk PL level.
        """
        return pulumi.get(self, "system_disk_performance_level")


@pulumi.output_type
class GetDedicatedHostAccountsAccountResult(dict):
    def __init__(__self__, *,
                 account_name: _builtins.str,
                 dedicated_host_id: _builtins.str,
                 id: _builtins.str):
        """
        :param _builtins.str account_name: The name of the Dedicated host account.
        :param _builtins.str dedicated_host_id: The ID of the Dedicated host.
        :param _builtins.str id: The ID of the Dedicated Host Account. The value formats as `<dedicated_host_id>:<account_name>`.
        """
        pulumi.set(__self__, "account_name", account_name)
        pulumi.set(__self__, "dedicated_host_id", dedicated_host_id)
        pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter(name="accountName")
    def account_name(self) -> _builtins.str:
        """
        The name of the Dedicated host account.
        """
        return pulumi.get(self, "account_name")

    @_builtins.property
    @pulumi.getter(name="dedicatedHostId")
    def dedicated_host_id(self) -> _builtins.str:
        """
        The ID of the Dedicated host.
        """
        return pulumi.get(self, "dedicated_host_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Dedicated Host Account. The value formats as `<dedicated_host_id>:<account_name>`.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class GetDedicatedHostGroupsGroupResult(dict):
    def __init__(__self__, *,
                 allocation_policy: _builtins.str,
                 bastion_instance_id: _builtins.str,
                 cpu_allocate_ration: _builtins.float,
                 cpu_allocated_amount: _builtins.float,
                 cpu_allocation_ratio: _builtins.int,
                 create_time: _builtins.str,
                 dedicated_host_count_group_by_host_types: Sequence['outputs.GetDedicatedHostGroupsGroupDedicatedHostCountGroupByHostTypeResult'],
                 dedicated_host_group_desc: _builtins.str,
                 dedicated_host_group_id: _builtins.str,
                 deploy_type: _builtins.str,
                 disk_allocate_ration: _builtins.float,
                 disk_allocated_amount: _builtins.float,
                 disk_allocation_ratio: _builtins.int,
                 disk_used_amount: _builtins.float,
                 disk_utility: _builtins.float,
                 engine: _builtins.str,
                 host_number: _builtins.int,
                 host_replace_policy: _builtins.str,
                 id: _builtins.str,
                 instance_number: _builtins.int,
                 mem_allocate_ration: _builtins.float,
                 mem_allocated_amount: _builtins.float,
                 mem_allocation_ratio: _builtins.int,
                 mem_used_amount: _builtins.float,
                 mem_utility: _builtins.float,
                 text: _builtins.str,
                 vpc_id: _builtins.str,
                 zone_id_lists: Sequence['outputs.GetDedicatedHostGroupsGroupZoneIdListResult']):
        """
        :param _builtins.str allocation_policy: The policy that is used to allocate resources in the dedicated cluster. Valid values:`Evenly`,`Intensively`
        :param _builtins.str bastion_instance_id: The Bastion Instance id of the Dedicated Host Group.
        :param _builtins.float cpu_allocate_ration: The CPU overcommitment ratio of the dedicated cluster. If you set this parameter to 200, the CPU resources that can be allocated are twice as many as the CPU resources that are provided. This maximizes the CPU utilization. Valid values: 100 to 300. Default value: 200.
        :param _builtins.float cpu_allocated_amount: The CPU Allocated Amount of the Dedicated Host Group.
        :param _builtins.int cpu_allocation_ratio: The CPU overcommitment ratio of the dedicated cluster.Valid values: 100 to 300. Default value: 200.
        :param _builtins.str create_time: The Created Time of the Dedicated Host Group.
        :param Sequence['GetDedicatedHostGroupsGroupDedicatedHostCountGroupByHostTypeArgs'] dedicated_host_count_group_by_host_types: The Dedicated Host Count Group by Host Type of the Dedicated Host Group.
        :param _builtins.str dedicated_host_group_desc: The name of the dedicated cluster. The name must be 1 to 64 characters in length and can contain letters, digits, underscores (_), and hyphens (-). It must start with a letter.
        :param _builtins.str dedicated_host_group_id: Dedicated Host Group ID.
        :param _builtins.str deploy_type: The Deployment Type of the Dedicated Host Group.
        :param _builtins.float disk_allocate_ration: The storage overcommitment ratio of the dedicated cluster.Valid values: 100 to 300. Default value: 200.
        :param _builtins.float disk_allocated_amount: The Disk Allocated Amount of the Dedicated Host Group.
        :param _builtins.int disk_allocation_ratio: The Disk Allocation Ratio of the Dedicated Host Group.
        :param _builtins.float disk_used_amount: The DiskUsedAmount of the Dedicated Host Group.
        :param _builtins.float disk_utility: The DiskUtility of the Dedicated Host Group.
        :param _builtins.str engine: Database Engine Type.The database engine of the dedicated cluster. Valid values:`Redis`, `SQLServer`, `MySQL`, `PostgreSQL`, `MongoDB`
        :param _builtins.int host_number: The Total Host Number  of the Dedicated Host Group.
        :param _builtins.str host_replace_policy: The policy based on which the system handles host failures. Valid values:`Auto`,`Manual`
        :param _builtins.str id: The ID of the Dedicated Host Group.
        :param _builtins.int instance_number: The Total Instance Number of the Dedicated Host Group.
        :param _builtins.float mem_allocate_ration: The maximum memory usage of each host in the dedicated cluster.Valid values: 0 to 90. Default value: 90.
        :param _builtins.float mem_allocated_amount: The MemAllocatedAmount of the Dedicated Host Group.
        :param _builtins.int mem_allocation_ratio: The Memory Allocation Ratio of the Dedicated Host Group.
        :param _builtins.float mem_used_amount: The MemUsedAmount of the Dedicated Host Group.
        :param _builtins.float mem_utility: The Mem Utility of the Dedicated Host Group.
        :param _builtins.str text: The Text of the Dedicated Host Group.
        :param _builtins.str vpc_id: The virtual private cloud (VPC) ID of the dedicated cluster.
        :param Sequence['GetDedicatedHostGroupsGroupZoneIdListArgs'] zone_id_lists: The ZoneIDList of the Dedicated Host Group.
        """
        pulumi.set(__self__, "allocation_policy", allocation_policy)
        pulumi.set(__self__, "bastion_instance_id", bastion_instance_id)
        pulumi.set(__self__, "cpu_allocate_ration", cpu_allocate_ration)
        pulumi.set(__self__, "cpu_allocated_amount", cpu_allocated_amount)
        pulumi.set(__self__, "cpu_allocation_ratio", cpu_allocation_ratio)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "dedicated_host_count_group_by_host_types", dedicated_host_count_group_by_host_types)
        pulumi.set(__self__, "dedicated_host_group_desc", dedicated_host_group_desc)
        pulumi.set(__self__, "dedicated_host_group_id", dedicated_host_group_id)
        pulumi.set(__self__, "deploy_type", deploy_type)
        pulumi.set(__self__, "disk_allocate_ration", disk_allocate_ration)
        pulumi.set(__self__, "disk_allocated_amount", disk_allocated_amount)
        pulumi.set(__self__, "disk_allocation_ratio", disk_allocation_ratio)
        pulumi.set(__self__, "disk_used_amount", disk_used_amount)
        pulumi.set(__self__, "disk_utility", disk_utility)
        pulumi.set(__self__, "engine", engine)
        pulumi.set(__self__, "host_number", host_number)
        pulumi.set(__self__, "host_replace_policy", host_replace_policy)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "instance_number", instance_number)
        pulumi.set(__self__, "mem_allocate_ration", mem_allocate_ration)
        pulumi.set(__self__, "mem_allocated_amount", mem_allocated_amount)
        pulumi.set(__self__, "mem_allocation_ratio", mem_allocation_ratio)
        pulumi.set(__self__, "mem_used_amount", mem_used_amount)
        pulumi.set(__self__, "mem_utility", mem_utility)
        pulumi.set(__self__, "text", text)
        pulumi.set(__self__, "vpc_id", vpc_id)
        pulumi.set(__self__, "zone_id_lists", zone_id_lists)

    @_builtins.property
    @pulumi.getter(name="allocationPolicy")
    def allocation_policy(self) -> _builtins.str:
        """
        The policy that is used to allocate resources in the dedicated cluster. Valid values:`Evenly`,`Intensively`
        """
        return pulumi.get(self, "allocation_policy")

    @_builtins.property
    @pulumi.getter(name="bastionInstanceId")
    def bastion_instance_id(self) -> _builtins.str:
        """
        The Bastion Instance id of the Dedicated Host Group.
        """
        return pulumi.get(self, "bastion_instance_id")

    @_builtins.property
    @pulumi.getter(name="cpuAllocateRation")
    def cpu_allocate_ration(self) -> _builtins.float:
        """
        The CPU overcommitment ratio of the dedicated cluster. If you set this parameter to 200, the CPU resources that can be allocated are twice as many as the CPU resources that are provided. This maximizes the CPU utilization. Valid values: 100 to 300. Default value: 200.
        """
        return pulumi.get(self, "cpu_allocate_ration")

    @_builtins.property
    @pulumi.getter(name="cpuAllocatedAmount")
    def cpu_allocated_amount(self) -> _builtins.float:
        """
        The CPU Allocated Amount of the Dedicated Host Group.
        """
        return pulumi.get(self, "cpu_allocated_amount")

    @_builtins.property
    @pulumi.getter(name="cpuAllocationRatio")
    def cpu_allocation_ratio(self) -> _builtins.int:
        """
        The CPU overcommitment ratio of the dedicated cluster.Valid values: 100 to 300. Default value: 200.
        """
        return pulumi.get(self, "cpu_allocation_ratio")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> _builtins.str:
        """
        The Created Time of the Dedicated Host Group.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="dedicatedHostCountGroupByHostTypes")
    def dedicated_host_count_group_by_host_types(self) -> Sequence['outputs.GetDedicatedHostGroupsGroupDedicatedHostCountGroupByHostTypeResult']:
        """
        The Dedicated Host Count Group by Host Type of the Dedicated Host Group.
        """
        return pulumi.get(self, "dedicated_host_count_group_by_host_types")

    @_builtins.property
    @pulumi.getter(name="dedicatedHostGroupDesc")
    def dedicated_host_group_desc(self) -> _builtins.str:
        """
        The name of the dedicated cluster. The name must be 1 to 64 characters in length and can contain letters, digits, underscores (_), and hyphens (-). It must start with a letter.
        """
        return pulumi.get(self, "dedicated_host_group_desc")

    @_builtins.property
    @pulumi.getter(name="dedicatedHostGroupId")
    def dedicated_host_group_id(self) -> _builtins.str:
        """
        Dedicated Host Group ID.
        """
        return pulumi.get(self, "dedicated_host_group_id")

    @_builtins.property
    @pulumi.getter(name="deployType")
    def deploy_type(self) -> _builtins.str:
        """
        The Deployment Type of the Dedicated Host Group.
        """
        return pulumi.get(self, "deploy_type")

    @_builtins.property
    @pulumi.getter(name="diskAllocateRation")
    def disk_allocate_ration(self) -> _builtins.float:
        """
        The storage overcommitment ratio of the dedicated cluster.Valid values: 100 to 300. Default value: 200.
        """
        return pulumi.get(self, "disk_allocate_ration")

    @_builtins.property
    @pulumi.getter(name="diskAllocatedAmount")
    def disk_allocated_amount(self) -> _builtins.float:
        """
        The Disk Allocated Amount of the Dedicated Host Group.
        """
        return pulumi.get(self, "disk_allocated_amount")

    @_builtins.property
    @pulumi.getter(name="diskAllocationRatio")
    def disk_allocation_ratio(self) -> _builtins.int:
        """
        The Disk Allocation Ratio of the Dedicated Host Group.
        """
        return pulumi.get(self, "disk_allocation_ratio")

    @_builtins.property
    @pulumi.getter(name="diskUsedAmount")
    def disk_used_amount(self) -> _builtins.float:
        """
        The DiskUsedAmount of the Dedicated Host Group.
        """
        return pulumi.get(self, "disk_used_amount")

    @_builtins.property
    @pulumi.getter(name="diskUtility")
    def disk_utility(self) -> _builtins.float:
        """
        The DiskUtility of the Dedicated Host Group.
        """
        return pulumi.get(self, "disk_utility")

    @_builtins.property
    @pulumi.getter
    def engine(self) -> _builtins.str:
        """
        Database Engine Type.The database engine of the dedicated cluster. Valid values:`Redis`, `SQLServer`, `MySQL`, `PostgreSQL`, `MongoDB`
        """
        return pulumi.get(self, "engine")

    @_builtins.property
    @pulumi.getter(name="hostNumber")
    def host_number(self) -> _builtins.int:
        """
        The Total Host Number  of the Dedicated Host Group.
        """
        return pulumi.get(self, "host_number")

    @_builtins.property
    @pulumi.getter(name="hostReplacePolicy")
    def host_replace_policy(self) -> _builtins.str:
        """
        The policy based on which the system handles host failures. Valid values:`Auto`,`Manual`
        """
        return pulumi.get(self, "host_replace_policy")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Dedicated Host Group.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="instanceNumber")
    def instance_number(self) -> _builtins.int:
        """
        The Total Instance Number of the Dedicated Host Group.
        """
        return pulumi.get(self, "instance_number")

    @_builtins.property
    @pulumi.getter(name="memAllocateRation")
    def mem_allocate_ration(self) -> _builtins.float:
        """
        The maximum memory usage of each host in the dedicated cluster.Valid values: 0 to 90. Default value: 90.
        """
        return pulumi.get(self, "mem_allocate_ration")

    @_builtins.property
    @pulumi.getter(name="memAllocatedAmount")
    def mem_allocated_amount(self) -> _builtins.float:
        """
        The MemAllocatedAmount of the Dedicated Host Group.
        """
        return pulumi.get(self, "mem_allocated_amount")

    @_builtins.property
    @pulumi.getter(name="memAllocationRatio")
    def mem_allocation_ratio(self) -> _builtins.int:
        """
        The Memory Allocation Ratio of the Dedicated Host Group.
        """
        return pulumi.get(self, "mem_allocation_ratio")

    @_builtins.property
    @pulumi.getter(name="memUsedAmount")
    def mem_used_amount(self) -> _builtins.float:
        """
        The MemUsedAmount of the Dedicated Host Group.
        """
        return pulumi.get(self, "mem_used_amount")

    @_builtins.property
    @pulumi.getter(name="memUtility")
    def mem_utility(self) -> _builtins.float:
        """
        The Mem Utility of the Dedicated Host Group.
        """
        return pulumi.get(self, "mem_utility")

    @_builtins.property
    @pulumi.getter
    def text(self) -> _builtins.str:
        """
        The Text of the Dedicated Host Group.
        """
        return pulumi.get(self, "text")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> _builtins.str:
        """
        The virtual private cloud (VPC) ID of the dedicated cluster.
        """
        return pulumi.get(self, "vpc_id")

    @_builtins.property
    @pulumi.getter(name="zoneIdLists")
    def zone_id_lists(self) -> Sequence['outputs.GetDedicatedHostGroupsGroupZoneIdListResult']:
        """
        The ZoneIDList of the Dedicated Host Group.
        """
        return pulumi.get(self, "zone_id_lists")


@pulumi.output_type
class GetDedicatedHostGroupsGroupDedicatedHostCountGroupByHostTypeResult(dict):
    def __init__(__self__, *,
                 place_holder: _builtins.str):
        pulumi.set(__self__, "place_holder", place_holder)

    @_builtins.property
    @pulumi.getter(name="placeHolder")
    def place_holder(self) -> _builtins.str:
        return pulumi.get(self, "place_holder")


@pulumi.output_type
class GetDedicatedHostGroupsGroupZoneIdListResult(dict):
    def __init__(__self__, *,
                 zone_id_lists: Sequence[_builtins.str]):
        """
        :param Sequence[_builtins.str] zone_id_lists: The ZoneIDList of the Dedicated Host Group.
        """
        pulumi.set(__self__, "zone_id_lists", zone_id_lists)

    @_builtins.property
    @pulumi.getter(name="zoneIdLists")
    def zone_id_lists(self) -> Sequence[_builtins.str]:
        """
        The ZoneIDList of the Dedicated Host Group.
        """
        return pulumi.get(self, "zone_id_lists")


@pulumi.output_type
class GetDedicatedHostsHostResult(dict):
    def __init__(__self__, *,
                 allocation_status: _builtins.str,
                 bastion_instance_id: _builtins.str,
                 cpu_allocation_ratio: _builtins.str,
                 cpu_used: _builtins.str,
                 create_time: _builtins.str,
                 dedicated_host_group_id: _builtins.str,
                 dedicated_host_id: _builtins.str,
                 disk_allocation_ratio: _builtins.str,
                 ecs_class_code: _builtins.str,
                 end_time: _builtins.str,
                 engine: _builtins.str,
                 expired_time: _builtins.str,
                 host_class: _builtins.str,
                 host_cpu: _builtins.str,
                 host_mem: _builtins.str,
                 host_name: _builtins.str,
                 host_storage: _builtins.str,
                 host_type: _builtins.str,
                 id: _builtins.str,
                 image_category: _builtins.str,
                 ip_address: _builtins.str,
                 mem_allocation_ratio: _builtins.str,
                 memory_used: _builtins.str,
                 open_permission: _builtins.str,
                 status: _builtins.str,
                 storage_used: _builtins.str,
                 tags: Mapping[str, _builtins.str],
                 vpc_id: _builtins.str,
                 vswitch_id: _builtins.str,
                 zone_id: _builtins.str):
        """
        :param _builtins.str allocation_status: Specifies whether instances can be created on the host. Valid values: `1` or `0`. `1`: Instances can be created on the host. `0`: Instances cannot be created on the host.
        :param _builtins.str bastion_instance_id: The ID of the bastion host with which the host is associated.
        :param _builtins.str cpu_allocation_ratio: The numeric value of the CPU over commit ratio of the dedicated cluster.
        :param _builtins.str cpu_used: The number of CPU cores used by the host.
        :param _builtins.str create_time: The time when the host was created. The time follows the ISO 8601 standard in the `yyyy-MM-ddTHH:mm:ssZ` format. The time is displayed in UTC.
        :param _builtins.str dedicated_host_group_id: The ID of the dedicated cluster in which the host is created.
        :param _builtins.str dedicated_host_id: The ID of the host.
        :param _builtins.str disk_allocation_ratio: The disk usage in percentage.
        :param _builtins.str ecs_class_code: The Elastic Compute Service (ECS) instance type.
        :param _builtins.str end_time: The time when the host expires. The time follows the ISO 8601 standard in the `yyyy-MM-ddTHH:mm:ssZ` format. The time is displayed in UTC.
        :param _builtins.str engine: The type of the database engine that is used by the host.
        :param _builtins.str expired_time: The time when the host expires. The time follows the ISO 8601 standard in the `yyyy-MM-ddTHH:mm:ssZ` format. The time is displayed in UTC.
        :param _builtins.str host_class: The instance type of the host.
        :param _builtins.str host_cpu: The number of CPU cores specified for the host. Unit: `core`.
        :param _builtins.str host_mem: The memory of the host. Unit: `GB`.
        :param _builtins.str host_name: The name of the host.
        :param _builtins.str host_storage: The total storage capacity of the host. Unit: `GB`.
        :param _builtins.str host_type: The storage type of the host.
        :param _builtins.str id: The ID of the Dedicated Host. The value formats as `<dedicated_host_group_id>:<dedicated_host_id>`.
        :param _builtins.str image_category: The image type of the host.
        :param _builtins.str ip_address: The IP address of the host.
        :param _builtins.str mem_allocation_ratio: The memory usage in percentage.
        :param _builtins.str memory_used: The amount of memory used by the host. Unit: `GB`.
        :param _builtins.str open_permission: Indicates whether you have the OS permissions on the host. Valid values: `0`: You do not have the OS permissions on the host. `1`: You have the OS permissions on the host.
        :param _builtins.str status: The state of the host.
        :param _builtins.str storage_used: The storage usage of the host. Unit: `GB`.
        :param Mapping[str, _builtins.str] tags: The tag of the resource.
        :param _builtins.str vpc_id: The ID of the virtual private cloud (VPC) to which the host is connected.
        :param _builtins.str vswitch_id: The ID of the vSwitch.
        :param _builtins.str zone_id: The zone ID of the host.
        """
        pulumi.set(__self__, "allocation_status", allocation_status)
        pulumi.set(__self__, "bastion_instance_id", bastion_instance_id)
        pulumi.set(__self__, "cpu_allocation_ratio", cpu_allocation_ratio)
        pulumi.set(__self__, "cpu_used", cpu_used)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "dedicated_host_group_id", dedicated_host_group_id)
        pulumi.set(__self__, "dedicated_host_id", dedicated_host_id)
        pulumi.set(__self__, "disk_allocation_ratio", disk_allocation_ratio)
        pulumi.set(__self__, "ecs_class_code", ecs_class_code)
        pulumi.set(__self__, "end_time", end_time)
        pulumi.set(__self__, "engine", engine)
        pulumi.set(__self__, "expired_time", expired_time)
        pulumi.set(__self__, "host_class", host_class)
        pulumi.set(__self__, "host_cpu", host_cpu)
        pulumi.set(__self__, "host_mem", host_mem)
        pulumi.set(__self__, "host_name", host_name)
        pulumi.set(__self__, "host_storage", host_storage)
        pulumi.set(__self__, "host_type", host_type)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "image_category", image_category)
        pulumi.set(__self__, "ip_address", ip_address)
        pulumi.set(__self__, "mem_allocation_ratio", mem_allocation_ratio)
        pulumi.set(__self__, "memory_used", memory_used)
        pulumi.set(__self__, "open_permission", open_permission)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "storage_used", storage_used)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "vpc_id", vpc_id)
        pulumi.set(__self__, "vswitch_id", vswitch_id)
        pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter(name="allocationStatus")
    def allocation_status(self) -> _builtins.str:
        """
        Specifies whether instances can be created on the host. Valid values: `1` or `0`. `1`: Instances can be created on the host. `0`: Instances cannot be created on the host.
        """
        return pulumi.get(self, "allocation_status")

    @_builtins.property
    @pulumi.getter(name="bastionInstanceId")
    def bastion_instance_id(self) -> _builtins.str:
        """
        The ID of the bastion host with which the host is associated.
        """
        return pulumi.get(self, "bastion_instance_id")

    @_builtins.property
    @pulumi.getter(name="cpuAllocationRatio")
    def cpu_allocation_ratio(self) -> _builtins.str:
        """
        The numeric value of the CPU over commit ratio of the dedicated cluster.
        """
        return pulumi.get(self, "cpu_allocation_ratio")

    @_builtins.property
    @pulumi.getter(name="cpuUsed")
    def cpu_used(self) -> _builtins.str:
        """
        The number of CPU cores used by the host.
        """
        return pulumi.get(self, "cpu_used")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> _builtins.str:
        """
        The time when the host was created. The time follows the ISO 8601 standard in the `yyyy-MM-ddTHH:mm:ssZ` format. The time is displayed in UTC.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="dedicatedHostGroupId")
    def dedicated_host_group_id(self) -> _builtins.str:
        """
        The ID of the dedicated cluster in which the host is created.
        """
        return pulumi.get(self, "dedicated_host_group_id")

    @_builtins.property
    @pulumi.getter(name="dedicatedHostId")
    def dedicated_host_id(self) -> _builtins.str:
        """
        The ID of the host.
        """
        return pulumi.get(self, "dedicated_host_id")

    @_builtins.property
    @pulumi.getter(name="diskAllocationRatio")
    def disk_allocation_ratio(self) -> _builtins.str:
        """
        The disk usage in percentage.
        """
        return pulumi.get(self, "disk_allocation_ratio")

    @_builtins.property
    @pulumi.getter(name="ecsClassCode")
    def ecs_class_code(self) -> _builtins.str:
        """
        The Elastic Compute Service (ECS) instance type.
        """
        return pulumi.get(self, "ecs_class_code")

    @_builtins.property
    @pulumi.getter(name="endTime")
    def end_time(self) -> _builtins.str:
        """
        The time when the host expires. The time follows the ISO 8601 standard in the `yyyy-MM-ddTHH:mm:ssZ` format. The time is displayed in UTC.
        """
        return pulumi.get(self, "end_time")

    @_builtins.property
    @pulumi.getter
    def engine(self) -> _builtins.str:
        """
        The type of the database engine that is used by the host.
        """
        return pulumi.get(self, "engine")

    @_builtins.property
    @pulumi.getter(name="expiredTime")
    def expired_time(self) -> _builtins.str:
        """
        The time when the host expires. The time follows the ISO 8601 standard in the `yyyy-MM-ddTHH:mm:ssZ` format. The time is displayed in UTC.
        """
        return pulumi.get(self, "expired_time")

    @_builtins.property
    @pulumi.getter(name="hostClass")
    def host_class(self) -> _builtins.str:
        """
        The instance type of the host.
        """
        return pulumi.get(self, "host_class")

    @_builtins.property
    @pulumi.getter(name="hostCpu")
    def host_cpu(self) -> _builtins.str:
        """
        The number of CPU cores specified for the host. Unit: `core`.
        """
        return pulumi.get(self, "host_cpu")

    @_builtins.property
    @pulumi.getter(name="hostMem")
    def host_mem(self) -> _builtins.str:
        """
        The memory of the host. Unit: `GB`.
        """
        return pulumi.get(self, "host_mem")

    @_builtins.property
    @pulumi.getter(name="hostName")
    def host_name(self) -> _builtins.str:
        """
        The name of the host.
        """
        return pulumi.get(self, "host_name")

    @_builtins.property
    @pulumi.getter(name="hostStorage")
    def host_storage(self) -> _builtins.str:
        """
        The total storage capacity of the host. Unit: `GB`.
        """
        return pulumi.get(self, "host_storage")

    @_builtins.property
    @pulumi.getter(name="hostType")
    def host_type(self) -> _builtins.str:
        """
        The storage type of the host.
        """
        return pulumi.get(self, "host_type")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Dedicated Host. The value formats as `<dedicated_host_group_id>:<dedicated_host_id>`.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="imageCategory")
    def image_category(self) -> _builtins.str:
        """
        The image type of the host.
        """
        return pulumi.get(self, "image_category")

    @_builtins.property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> _builtins.str:
        """
        The IP address of the host.
        """
        return pulumi.get(self, "ip_address")

    @_builtins.property
    @pulumi.getter(name="memAllocationRatio")
    def mem_allocation_ratio(self) -> _builtins.str:
        """
        The memory usage in percentage.
        """
        return pulumi.get(self, "mem_allocation_ratio")

    @_builtins.property
    @pulumi.getter(name="memoryUsed")
    def memory_used(self) -> _builtins.str:
        """
        The amount of memory used by the host. Unit: `GB`.
        """
        return pulumi.get(self, "memory_used")

    @_builtins.property
    @pulumi.getter(name="openPermission")
    def open_permission(self) -> _builtins.str:
        """
        Indicates whether you have the OS permissions on the host. Valid values: `0`: You do not have the OS permissions on the host. `1`: You have the OS permissions on the host.
        """
        return pulumi.get(self, "open_permission")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The state of the host.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="storageUsed")
    def storage_used(self) -> _builtins.str:
        """
        The storage usage of the host. Unit: `GB`.
        """
        return pulumi.get(self, "storage_used")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        The tag of the resource.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> _builtins.str:
        """
        The ID of the virtual private cloud (VPC) to which the host is connected.
        """
        return pulumi.get(self, "vpc_id")

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> _builtins.str:
        """
        The ID of the vSwitch.
        """
        return pulumi.get(self, "vswitch_id")

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> _builtins.str:
        """
        The zone ID of the host.
        """
        return pulumi.get(self, "zone_id")


@pulumi.output_type
class GetHostEcsLevelInfosInfoResult(dict):
    def __init__(__self__, *,
                 description: _builtins.str,
                 ecs_class: _builtins.str,
                 ecs_class_code: _builtins.str,
                 res_class_code: _builtins.str):
        """
        :param _builtins.str description: The description of the host ecs level info.
        :param _builtins.str ecs_class: The instance family of the host ecs level info.
        :param _builtins.str ecs_class_code: The Elastic Compute Service (ECS) instance type.
        :param _builtins.str res_class_code: The ApsaraDB RDS instance type of the host ecs level info.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "ecs_class", ecs_class)
        pulumi.set(__self__, "ecs_class_code", ecs_class_code)
        pulumi.set(__self__, "res_class_code", res_class_code)

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of the host ecs level info.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="ecsClass")
    def ecs_class(self) -> _builtins.str:
        """
        The instance family of the host ecs level info.
        """
        return pulumi.get(self, "ecs_class")

    @_builtins.property
    @pulumi.getter(name="ecsClassCode")
    def ecs_class_code(self) -> _builtins.str:
        """
        The Elastic Compute Service (ECS) instance type.
        """
        return pulumi.get(self, "ecs_class_code")

    @_builtins.property
    @pulumi.getter(name="resClassCode")
    def res_class_code(self) -> _builtins.str:
        """
        The ApsaraDB RDS instance type of the host ecs level info.
        """
        return pulumi.get(self, "res_class_code")


@pulumi.output_type
class GetZonesZoneResult(dict):
    def __init__(__self__, *,
                 id: _builtins.str,
                 region_id: _builtins.str,
                 zone_id: _builtins.str):
        """
        :param _builtins.str id: The ID of the zone.
        :param _builtins.str region_id: The ID of the region.
        :param _builtins.str zone_id: The ID of the zone.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "region_id", region_id)
        pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the zone.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> _builtins.str:
        """
        The ID of the region.
        """
        return pulumi.get(self, "region_id")

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> _builtins.str:
        """
        The ID of the zone.
        """
        return pulumi.get(self, "zone_id")


