# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetTransitRouterMulticastDomainMembersResult',
    'AwaitableGetTransitRouterMulticastDomainMembersResult',
    'get_transit_router_multicast_domain_members',
    'get_transit_router_multicast_domain_members_output',
]

@pulumi.output_type
class GetTransitRouterMulticastDomainMembersResult:
    """
    A collection of values returned by getTransitRouterMulticastDomainMembers.
    """
    def __init__(__self__, id=None, ids=None, members=None, network_interface_id=None, output_file=None, transit_router_multicast_domain_id=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if members and not isinstance(members, list):
            raise TypeError("Expected argument 'members' to be a list")
        pulumi.set(__self__, "members", members)
        if network_interface_id and not isinstance(network_interface_id, str):
            raise TypeError("Expected argument 'network_interface_id' to be a str")
        pulumi.set(__self__, "network_interface_id", network_interface_id)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if transit_router_multicast_domain_id and not isinstance(transit_router_multicast_domain_id, str):
            raise TypeError("Expected argument 'transit_router_multicast_domain_id' to be a str")
        pulumi.set(__self__, "transit_router_multicast_domain_id", transit_router_multicast_domain_id)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ids(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "ids")

    @_builtins.property
    @pulumi.getter
    def members(self) -> Sequence['outputs.GetTransitRouterMulticastDomainMembersMemberResult']:
        """
        A list of Transit Router Multicast Domain Member Entries. Each element contains the following attributes:
        """
        return pulumi.get(self, "members")

    @_builtins.property
    @pulumi.getter(name="networkInterfaceId")
    def network_interface_id(self) -> Optional[_builtins.str]:
        """
        ENI ID of multicast member.
        """
        return pulumi.get(self, "network_interface_id")

    @_builtins.property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "output_file")

    @_builtins.property
    @pulumi.getter(name="transitRouterMulticastDomainId")
    def transit_router_multicast_domain_id(self) -> _builtins.str:
        """
        The ID of the multicast domain to which the multicast member belongs.
        """
        return pulumi.get(self, "transit_router_multicast_domain_id")


class AwaitableGetTransitRouterMulticastDomainMembersResult(GetTransitRouterMulticastDomainMembersResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetTransitRouterMulticastDomainMembersResult(
            id=self.id,
            ids=self.ids,
            members=self.members,
            network_interface_id=self.network_interface_id,
            output_file=self.output_file,
            transit_router_multicast_domain_id=self.transit_router_multicast_domain_id)


def get_transit_router_multicast_domain_members(ids: Optional[Sequence[_builtins.str]] = None,
                                                network_interface_id: Optional[_builtins.str] = None,
                                                output_file: Optional[_builtins.str] = None,
                                                transit_router_multicast_domain_id: Optional[_builtins.str] = None,
                                                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetTransitRouterMulticastDomainMembersResult:
    """
    This data source provides Cen Transit Router Multicast Domain Member available to the user. [What is Transit Router Multicast Domain Member](https://www.alibabacloud.com/help/en/cen/developer-reference/api-cbn-2017-09-12-registertransitroutermulticastgroupmembers)

    > **NOTE:** Available since v1.195.0.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    default = alicloud.cen.get_transit_router_multicast_domain_members(transit_router_multicast_domain_id="tr-mcast-domain-2d9oq455uk533zfr29")
    pulumi.export("alicloudCenTransitRouterMulticastDomainMemberExampleId", default.members[0].id)
    ```


    :param Sequence[_builtins.str] ids: A list of Transit Router Multicast Domain Member IDs.
    :param _builtins.str network_interface_id: The ID of the ENI.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str transit_router_multicast_domain_id: The ID of the multicast domain to which the multicast member belongs.
    """
    __args__ = dict()
    __args__['ids'] = ids
    __args__['networkInterfaceId'] = network_interface_id
    __args__['outputFile'] = output_file
    __args__['transitRouterMulticastDomainId'] = transit_router_multicast_domain_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:cen/getTransitRouterMulticastDomainMembers:getTransitRouterMulticastDomainMembers', __args__, opts=opts, typ=GetTransitRouterMulticastDomainMembersResult).value

    return AwaitableGetTransitRouterMulticastDomainMembersResult(
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        members=pulumi.get(__ret__, 'members'),
        network_interface_id=pulumi.get(__ret__, 'network_interface_id'),
        output_file=pulumi.get(__ret__, 'output_file'),
        transit_router_multicast_domain_id=pulumi.get(__ret__, 'transit_router_multicast_domain_id'))
def get_transit_router_multicast_domain_members_output(ids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                                                       network_interface_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                                       output_file: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                                       transit_router_multicast_domain_id: Optional[pulumi.Input[_builtins.str]] = None,
                                                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetTransitRouterMulticastDomainMembersResult]:
    """
    This data source provides Cen Transit Router Multicast Domain Member available to the user. [What is Transit Router Multicast Domain Member](https://www.alibabacloud.com/help/en/cen/developer-reference/api-cbn-2017-09-12-registertransitroutermulticastgroupmembers)

    > **NOTE:** Available since v1.195.0.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    default = alicloud.cen.get_transit_router_multicast_domain_members(transit_router_multicast_domain_id="tr-mcast-domain-2d9oq455uk533zfr29")
    pulumi.export("alicloudCenTransitRouterMulticastDomainMemberExampleId", default.members[0].id)
    ```


    :param Sequence[_builtins.str] ids: A list of Transit Router Multicast Domain Member IDs.
    :param _builtins.str network_interface_id: The ID of the ENI.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str transit_router_multicast_domain_id: The ID of the multicast domain to which the multicast member belongs.
    """
    __args__ = dict()
    __args__['ids'] = ids
    __args__['networkInterfaceId'] = network_interface_id
    __args__['outputFile'] = output_file
    __args__['transitRouterMulticastDomainId'] = transit_router_multicast_domain_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('alicloud:cen/getTransitRouterMulticastDomainMembers:getTransitRouterMulticastDomainMembers', __args__, opts=opts, typ=GetTransitRouterMulticastDomainMembersResult)
    return __ret__.apply(lambda __response__: GetTransitRouterMulticastDomainMembersResult(
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids'),
        members=pulumi.get(__response__, 'members'),
        network_interface_id=pulumi.get(__response__, 'network_interface_id'),
        output_file=pulumi.get(__response__, 'output_file'),
        transit_router_multicast_domain_id=pulumi.get(__response__, 'transit_router_multicast_domain_id')))
