# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DbClusterArgs', 'DbCluster']

@pulumi.input_type
class DbClusterArgs:
    def __init__(__self__, *,
                 category: pulumi.Input[_builtins.str],
                 db_cluster_class: pulumi.Input[_builtins.str],
                 db_cluster_network_type: pulumi.Input[_builtins.str],
                 db_cluster_version: pulumi.Input[_builtins.str],
                 db_node_group_count: pulumi.Input[_builtins.int],
                 db_node_storage: pulumi.Input[_builtins.str],
                 payment_type: pulumi.Input[_builtins.str],
                 storage_type: pulumi.Input[_builtins.str],
                 allocate_public_connection: Optional[pulumi.Input[_builtins.bool]] = None,
                 cold_storage: Optional[pulumi.Input[_builtins.str]] = None,
                 db_cluster_access_white_lists: Optional[pulumi.Input[Sequence[pulumi.Input['DbClusterDbClusterAccessWhiteListArgs']]]] = None,
                 db_cluster_description: Optional[pulumi.Input[_builtins.str]] = None,
                 encryption_key: Optional[pulumi.Input[_builtins.str]] = None,
                 encryption_type: Optional[pulumi.Input[_builtins.str]] = None,
                 maintain_time: Optional[pulumi.Input[_builtins.str]] = None,
                 multi_zone_vswitch_lists: Optional[pulumi.Input[Sequence[pulumi.Input['DbClusterMultiZoneVswitchListArgs']]]] = None,
                 period: Optional[pulumi.Input[_builtins.str]] = None,
                 renewal_status: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 used_time: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a DbCluster resource.
        :param pulumi.Input[_builtins.str] category: The Category of DBCluster. Valid values: `Basic`,`HighAvailability`.
        :param pulumi.Input[_builtins.str] db_cluster_class: The DBCluster class. According to the category, db_cluster_class has two value ranges:
               * Under the condition that the category is the `Basic`, Valid values: `LS20`, `LS40`, `LS80`,`S8`, `S16`, `S32`, `S64`,`S80`, `S104`.
               * Under the condition that the category is the `HighAvailability`, Valid values: `LC20`, `LC40`, `LC80`,`C8`, `C16`, `C32`, `C64`, `C80`, `C104`.
        :param pulumi.Input[_builtins.str] db_cluster_network_type: The DBCluster network type. Valid values: `vpc`.
        :param pulumi.Input[_builtins.str] db_cluster_version: The DBCluster version. Valid values: `20.3.10.75`, `20.8.7.15`, `21.8.10.19`, `22.8.5.29`, `23.8`. **NOTE:** `19.15.2.2` is no longer supported. From version 1.191.0, `db_cluster_version` can be set to `22.8.5.29`.
        :param pulumi.Input[_builtins.int] db_node_group_count: The db node group count. The number should between 1 and 48.
        :param pulumi.Input[_builtins.str] db_node_storage: The db node storage.
        :param pulumi.Input[_builtins.str] payment_type: The payment type of the resource. Valid values: `PayAsYouGo`,`Subscription`.
        :param pulumi.Input[_builtins.str] storage_type: Storage type of DBCluster. Valid values: `cloud_essd`, `cloud_efficiency`, `cloud_essd_pl2`, `cloud_essd_pl3`.
        :param pulumi.Input[_builtins.bool] allocate_public_connection: Whether to enable public connection. Value options: `true`, `false`.
        :param pulumi.Input[_builtins.str] cold_storage: Whether to use cold storage. Valid values: `ENABLE`, `DISABLE`, default to `DISABLE`. When it's set to `ENABLE`, cold storage will be used, and `cold_storage` cannot be set to `DISABLE` again.
        :param pulumi.Input[Sequence[pulumi.Input['DbClusterDbClusterAccessWhiteListArgs']]] db_cluster_access_white_lists: The db cluster access white list. See `db_cluster_access_white_list` below.
        :param pulumi.Input[_builtins.str] db_cluster_description: The DBCluster description.
        :param pulumi.Input[_builtins.str] encryption_key: Key management service KMS key ID. It is valid and required when encryption_type is `CloudDisk`.
        :param pulumi.Input[_builtins.str] encryption_type: Currently only supports ECS disk encryption, with a value of CloudDisk, not encrypted when empty.
        :param pulumi.Input[_builtins.str] maintain_time: The maintenance window of DBCluster. Valid format: `hh:mmZ-hh:mm Z`.
        :param pulumi.Input[Sequence[pulumi.Input['DbClusterMultiZoneVswitchListArgs']]] multi_zone_vswitch_lists: The zone IDs and 
               corresponding vswitch IDs and zone IDs of multi-zone setup. if set, a multi-zone DBCluster will be created. Currently only support 2 available zones, primary zone not included. See `multi_zone_vswitch_list` below.
        :param pulumi.Input[_builtins.str] period: Pre-paid cluster of the pay-as-you-go cycle. It is valid and required when payment_type is `Subscription`. Valid values: `Month`, `Year`.
        :param pulumi.Input[_builtins.str] renewal_status: The renewal status of the resource. Valid values: `AutoRenewal`,`Normal`. It is valid and required when payment_type is `Subscription`. When `renewal_status` is set to `AutoRenewal`, the resource is renewed automatically.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group.
        :param pulumi.Input[_builtins.str] status: The status of the resource. Valid values: `Running`,`Creating`,`Deleting`,`Restarting`,`Preparing`.
        :param pulumi.Input[_builtins.str] used_time: The used time of DBCluster. It is valid and required when payment_type is `Subscription`. item choices: [1-9] when period is `Month`, [1-3] when period is `Year`.
        :param pulumi.Input[_builtins.str] vpc_id: The id of the VPC.
        :param pulumi.Input[_builtins.str] vswitch_id: The vswitch id of DBCluster.
        :param pulumi.Input[_builtins.str] zone_id: The zone ID of the instance.
        """
        pulumi.set(__self__, "category", category)
        pulumi.set(__self__, "db_cluster_class", db_cluster_class)
        pulumi.set(__self__, "db_cluster_network_type", db_cluster_network_type)
        pulumi.set(__self__, "db_cluster_version", db_cluster_version)
        pulumi.set(__self__, "db_node_group_count", db_node_group_count)
        pulumi.set(__self__, "db_node_storage", db_node_storage)
        pulumi.set(__self__, "payment_type", payment_type)
        pulumi.set(__self__, "storage_type", storage_type)
        if allocate_public_connection is not None:
            pulumi.set(__self__, "allocate_public_connection", allocate_public_connection)
        if cold_storage is not None:
            pulumi.set(__self__, "cold_storage", cold_storage)
        if db_cluster_access_white_lists is not None:
            pulumi.set(__self__, "db_cluster_access_white_lists", db_cluster_access_white_lists)
        if db_cluster_description is not None:
            pulumi.set(__self__, "db_cluster_description", db_cluster_description)
        if encryption_key is not None:
            pulumi.set(__self__, "encryption_key", encryption_key)
        if encryption_type is not None:
            pulumi.set(__self__, "encryption_type", encryption_type)
        if maintain_time is not None:
            pulumi.set(__self__, "maintain_time", maintain_time)
        if multi_zone_vswitch_lists is not None:
            pulumi.set(__self__, "multi_zone_vswitch_lists", multi_zone_vswitch_lists)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if renewal_status is not None:
            pulumi.set(__self__, "renewal_status", renewal_status)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if used_time is not None:
            pulumi.set(__self__, "used_time", used_time)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)
        if vswitch_id is not None:
            pulumi.set(__self__, "vswitch_id", vswitch_id)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter
    def category(self) -> pulumi.Input[_builtins.str]:
        """
        The Category of DBCluster. Valid values: `Basic`,`HighAvailability`.
        """
        return pulumi.get(self, "category")

    @category.setter
    def category(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "category", value)

    @_builtins.property
    @pulumi.getter(name="dbClusterClass")
    def db_cluster_class(self) -> pulumi.Input[_builtins.str]:
        """
        The DBCluster class. According to the category, db_cluster_class has two value ranges:
        * Under the condition that the category is the `Basic`, Valid values: `LS20`, `LS40`, `LS80`,`S8`, `S16`, `S32`, `S64`,`S80`, `S104`.
        * Under the condition that the category is the `HighAvailability`, Valid values: `LC20`, `LC40`, `LC80`,`C8`, `C16`, `C32`, `C64`, `C80`, `C104`.
        """
        return pulumi.get(self, "db_cluster_class")

    @db_cluster_class.setter
    def db_cluster_class(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "db_cluster_class", value)

    @_builtins.property
    @pulumi.getter(name="dbClusterNetworkType")
    def db_cluster_network_type(self) -> pulumi.Input[_builtins.str]:
        """
        The DBCluster network type. Valid values: `vpc`.
        """
        return pulumi.get(self, "db_cluster_network_type")

    @db_cluster_network_type.setter
    def db_cluster_network_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "db_cluster_network_type", value)

    @_builtins.property
    @pulumi.getter(name="dbClusterVersion")
    def db_cluster_version(self) -> pulumi.Input[_builtins.str]:
        """
        The DBCluster version. Valid values: `20.3.10.75`, `20.8.7.15`, `21.8.10.19`, `22.8.5.29`, `23.8`. **NOTE:** `19.15.2.2` is no longer supported. From version 1.191.0, `db_cluster_version` can be set to `22.8.5.29`.
        """
        return pulumi.get(self, "db_cluster_version")

    @db_cluster_version.setter
    def db_cluster_version(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "db_cluster_version", value)

    @_builtins.property
    @pulumi.getter(name="dbNodeGroupCount")
    def db_node_group_count(self) -> pulumi.Input[_builtins.int]:
        """
        The db node group count. The number should between 1 and 48.
        """
        return pulumi.get(self, "db_node_group_count")

    @db_node_group_count.setter
    def db_node_group_count(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "db_node_group_count", value)

    @_builtins.property
    @pulumi.getter(name="dbNodeStorage")
    def db_node_storage(self) -> pulumi.Input[_builtins.str]:
        """
        The db node storage.
        """
        return pulumi.get(self, "db_node_storage")

    @db_node_storage.setter
    def db_node_storage(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "db_node_storage", value)

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> pulumi.Input[_builtins.str]:
        """
        The payment type of the resource. Valid values: `PayAsYouGo`,`Subscription`.
        """
        return pulumi.get(self, "payment_type")

    @payment_type.setter
    def payment_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "payment_type", value)

    @_builtins.property
    @pulumi.getter(name="storageType")
    def storage_type(self) -> pulumi.Input[_builtins.str]:
        """
        Storage type of DBCluster. Valid values: `cloud_essd`, `cloud_efficiency`, `cloud_essd_pl2`, `cloud_essd_pl3`.
        """
        return pulumi.get(self, "storage_type")

    @storage_type.setter
    def storage_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "storage_type", value)

    @_builtins.property
    @pulumi.getter(name="allocatePublicConnection")
    def allocate_public_connection(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable public connection. Value options: `true`, `false`.
        """
        return pulumi.get(self, "allocate_public_connection")

    @allocate_public_connection.setter
    def allocate_public_connection(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "allocate_public_connection", value)

    @_builtins.property
    @pulumi.getter(name="coldStorage")
    def cold_storage(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether to use cold storage. Valid values: `ENABLE`, `DISABLE`, default to `DISABLE`. When it's set to `ENABLE`, cold storage will be used, and `cold_storage` cannot be set to `DISABLE` again.
        """
        return pulumi.get(self, "cold_storage")

    @cold_storage.setter
    def cold_storage(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cold_storage", value)

    @_builtins.property
    @pulumi.getter(name="dbClusterAccessWhiteLists")
    def db_cluster_access_white_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DbClusterDbClusterAccessWhiteListArgs']]]]:
        """
        The db cluster access white list. See `db_cluster_access_white_list` below.
        """
        return pulumi.get(self, "db_cluster_access_white_lists")

    @db_cluster_access_white_lists.setter
    def db_cluster_access_white_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DbClusterDbClusterAccessWhiteListArgs']]]]):
        pulumi.set(self, "db_cluster_access_white_lists", value)

    @_builtins.property
    @pulumi.getter(name="dbClusterDescription")
    def db_cluster_description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The DBCluster description.
        """
        return pulumi.get(self, "db_cluster_description")

    @db_cluster_description.setter
    def db_cluster_description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "db_cluster_description", value)

    @_builtins.property
    @pulumi.getter(name="encryptionKey")
    def encryption_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Key management service KMS key ID. It is valid and required when encryption_type is `CloudDisk`.
        """
        return pulumi.get(self, "encryption_key")

    @encryption_key.setter
    def encryption_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "encryption_key", value)

    @_builtins.property
    @pulumi.getter(name="encryptionType")
    def encryption_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Currently only supports ECS disk encryption, with a value of CloudDisk, not encrypted when empty.
        """
        return pulumi.get(self, "encryption_type")

    @encryption_type.setter
    def encryption_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "encryption_type", value)

    @_builtins.property
    @pulumi.getter(name="maintainTime")
    def maintain_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The maintenance window of DBCluster. Valid format: `hh:mmZ-hh:mm Z`.
        """
        return pulumi.get(self, "maintain_time")

    @maintain_time.setter
    def maintain_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "maintain_time", value)

    @_builtins.property
    @pulumi.getter(name="multiZoneVswitchLists")
    def multi_zone_vswitch_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DbClusterMultiZoneVswitchListArgs']]]]:
        """
        The zone IDs and 
        corresponding vswitch IDs and zone IDs of multi-zone setup. if set, a multi-zone DBCluster will be created. Currently only support 2 available zones, primary zone not included. See `multi_zone_vswitch_list` below.
        """
        return pulumi.get(self, "multi_zone_vswitch_lists")

    @multi_zone_vswitch_lists.setter
    def multi_zone_vswitch_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DbClusterMultiZoneVswitchListArgs']]]]):
        pulumi.set(self, "multi_zone_vswitch_lists", value)

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Pre-paid cluster of the pay-as-you-go cycle. It is valid and required when payment_type is `Subscription`. Valid values: `Month`, `Year`.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "period", value)

    @_builtins.property
    @pulumi.getter(name="renewalStatus")
    def renewal_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The renewal status of the resource. Valid values: `AutoRenewal`,`Normal`. It is valid and required when payment_type is `Subscription`. When `renewal_status` is set to `AutoRenewal`, the resource is renewed automatically.
        """
        return pulumi.get(self, "renewal_status")

    @renewal_status.setter
    def renewal_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "renewal_status", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the resource. Valid values: `Running`,`Creating`,`Deleting`,`Restarting`,`Preparing`.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="usedTime")
    def used_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The used time of DBCluster. It is valid and required when payment_type is `Subscription`. item choices: [1-9] when period is `Month`, [1-3] when period is `Year`.
        """
        return pulumi.get(self, "used_time")

    @used_time.setter
    def used_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "used_time", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The id of the VPC.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_id", value)

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The vswitch id of DBCluster.
        """
        return pulumi.get(self, "vswitch_id")

    @vswitch_id.setter
    def vswitch_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vswitch_id", value)

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The zone ID of the instance.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone_id", value)


@pulumi.input_type
class _DbClusterState:
    def __init__(__self__, *,
                 allocate_public_connection: Optional[pulumi.Input[_builtins.bool]] = None,
                 category: Optional[pulumi.Input[_builtins.str]] = None,
                 cold_storage: Optional[pulumi.Input[_builtins.str]] = None,
                 connection_string: Optional[pulumi.Input[_builtins.str]] = None,
                 db_cluster_access_white_lists: Optional[pulumi.Input[Sequence[pulumi.Input['DbClusterDbClusterAccessWhiteListArgs']]]] = None,
                 db_cluster_class: Optional[pulumi.Input[_builtins.str]] = None,
                 db_cluster_description: Optional[pulumi.Input[_builtins.str]] = None,
                 db_cluster_network_type: Optional[pulumi.Input[_builtins.str]] = None,
                 db_cluster_version: Optional[pulumi.Input[_builtins.str]] = None,
                 db_node_group_count: Optional[pulumi.Input[_builtins.int]] = None,
                 db_node_storage: Optional[pulumi.Input[_builtins.str]] = None,
                 encryption_key: Optional[pulumi.Input[_builtins.str]] = None,
                 encryption_type: Optional[pulumi.Input[_builtins.str]] = None,
                 maintain_time: Optional[pulumi.Input[_builtins.str]] = None,
                 multi_zone_vswitch_lists: Optional[pulumi.Input[Sequence[pulumi.Input['DbClusterMultiZoneVswitchListArgs']]]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.str]] = None,
                 port: Optional[pulumi.Input[_builtins.str]] = None,
                 public_connection_string: Optional[pulumi.Input[_builtins.str]] = None,
                 renewal_status: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_type: Optional[pulumi.Input[_builtins.str]] = None,
                 used_time: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering DbCluster resources.
        :param pulumi.Input[_builtins.bool] allocate_public_connection: Whether to enable public connection. Value options: `true`, `false`.
        :param pulumi.Input[_builtins.str] category: The Category of DBCluster. Valid values: `Basic`,`HighAvailability`.
        :param pulumi.Input[_builtins.str] cold_storage: Whether to use cold storage. Valid values: `ENABLE`, `DISABLE`, default to `DISABLE`. When it's set to `ENABLE`, cold storage will be used, and `cold_storage` cannot be set to `DISABLE` again.
        :param pulumi.Input[_builtins.str] connection_string: (Available since v1.196.0) - The connection string of the cluster.
        :param pulumi.Input[Sequence[pulumi.Input['DbClusterDbClusterAccessWhiteListArgs']]] db_cluster_access_white_lists: The db cluster access white list. See `db_cluster_access_white_list` below.
        :param pulumi.Input[_builtins.str] db_cluster_class: The DBCluster class. According to the category, db_cluster_class has two value ranges:
               * Under the condition that the category is the `Basic`, Valid values: `LS20`, `LS40`, `LS80`,`S8`, `S16`, `S32`, `S64`,`S80`, `S104`.
               * Under the condition that the category is the `HighAvailability`, Valid values: `LC20`, `LC40`, `LC80`,`C8`, `C16`, `C32`, `C64`, `C80`, `C104`.
        :param pulumi.Input[_builtins.str] db_cluster_description: The DBCluster description.
        :param pulumi.Input[_builtins.str] db_cluster_network_type: The DBCluster network type. Valid values: `vpc`.
        :param pulumi.Input[_builtins.str] db_cluster_version: The DBCluster version. Valid values: `20.3.10.75`, `20.8.7.15`, `21.8.10.19`, `22.8.5.29`, `23.8`. **NOTE:** `19.15.2.2` is no longer supported. From version 1.191.0, `db_cluster_version` can be set to `22.8.5.29`.
        :param pulumi.Input[_builtins.int] db_node_group_count: The db node group count. The number should between 1 and 48.
        :param pulumi.Input[_builtins.str] db_node_storage: The db node storage.
        :param pulumi.Input[_builtins.str] encryption_key: Key management service KMS key ID. It is valid and required when encryption_type is `CloudDisk`.
        :param pulumi.Input[_builtins.str] encryption_type: Currently only supports ECS disk encryption, with a value of CloudDisk, not encrypted when empty.
        :param pulumi.Input[_builtins.str] maintain_time: The maintenance window of DBCluster. Valid format: `hh:mmZ-hh:mm Z`.
        :param pulumi.Input[Sequence[pulumi.Input['DbClusterMultiZoneVswitchListArgs']]] multi_zone_vswitch_lists: The zone IDs and 
               corresponding vswitch IDs and zone IDs of multi-zone setup. if set, a multi-zone DBCluster will be created. Currently only support 2 available zones, primary zone not included. See `multi_zone_vswitch_list` below.
        :param pulumi.Input[_builtins.str] payment_type: The payment type of the resource. Valid values: `PayAsYouGo`,`Subscription`.
        :param pulumi.Input[_builtins.str] period: Pre-paid cluster of the pay-as-you-go cycle. It is valid and required when payment_type is `Subscription`. Valid values: `Month`, `Year`.
        :param pulumi.Input[_builtins.str] port: (Available since v1.196.0) The connection port of the cluster.
        :param pulumi.Input[_builtins.str] public_connection_string: (Available since v1.245.0) The public connection string of the cluster. Only valid when `allocate_public_connection` is `true`.
        :param pulumi.Input[_builtins.str] renewal_status: The renewal status of the resource. Valid values: `AutoRenewal`,`Normal`. It is valid and required when payment_type is `Subscription`. When `renewal_status` is set to `AutoRenewal`, the resource is renewed automatically.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group.
        :param pulumi.Input[_builtins.str] status: The status of the resource. Valid values: `Running`,`Creating`,`Deleting`,`Restarting`,`Preparing`.
        :param pulumi.Input[_builtins.str] storage_type: Storage type of DBCluster. Valid values: `cloud_essd`, `cloud_efficiency`, `cloud_essd_pl2`, `cloud_essd_pl3`.
        :param pulumi.Input[_builtins.str] used_time: The used time of DBCluster. It is valid and required when payment_type is `Subscription`. item choices: [1-9] when period is `Month`, [1-3] when period is `Year`.
        :param pulumi.Input[_builtins.str] vpc_id: The id of the VPC.
        :param pulumi.Input[_builtins.str] vswitch_id: The vswitch id of DBCluster.
        :param pulumi.Input[_builtins.str] zone_id: The zone ID of the instance.
        """
        if allocate_public_connection is not None:
            pulumi.set(__self__, "allocate_public_connection", allocate_public_connection)
        if category is not None:
            pulumi.set(__self__, "category", category)
        if cold_storage is not None:
            pulumi.set(__self__, "cold_storage", cold_storage)
        if connection_string is not None:
            pulumi.set(__self__, "connection_string", connection_string)
        if db_cluster_access_white_lists is not None:
            pulumi.set(__self__, "db_cluster_access_white_lists", db_cluster_access_white_lists)
        if db_cluster_class is not None:
            pulumi.set(__self__, "db_cluster_class", db_cluster_class)
        if db_cluster_description is not None:
            pulumi.set(__self__, "db_cluster_description", db_cluster_description)
        if db_cluster_network_type is not None:
            pulumi.set(__self__, "db_cluster_network_type", db_cluster_network_type)
        if db_cluster_version is not None:
            pulumi.set(__self__, "db_cluster_version", db_cluster_version)
        if db_node_group_count is not None:
            pulumi.set(__self__, "db_node_group_count", db_node_group_count)
        if db_node_storage is not None:
            pulumi.set(__self__, "db_node_storage", db_node_storage)
        if encryption_key is not None:
            pulumi.set(__self__, "encryption_key", encryption_key)
        if encryption_type is not None:
            pulumi.set(__self__, "encryption_type", encryption_type)
        if maintain_time is not None:
            pulumi.set(__self__, "maintain_time", maintain_time)
        if multi_zone_vswitch_lists is not None:
            pulumi.set(__self__, "multi_zone_vswitch_lists", multi_zone_vswitch_lists)
        if payment_type is not None:
            pulumi.set(__self__, "payment_type", payment_type)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if public_connection_string is not None:
            pulumi.set(__self__, "public_connection_string", public_connection_string)
        if renewal_status is not None:
            pulumi.set(__self__, "renewal_status", renewal_status)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if storage_type is not None:
            pulumi.set(__self__, "storage_type", storage_type)
        if used_time is not None:
            pulumi.set(__self__, "used_time", used_time)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)
        if vswitch_id is not None:
            pulumi.set(__self__, "vswitch_id", vswitch_id)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter(name="allocatePublicConnection")
    def allocate_public_connection(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable public connection. Value options: `true`, `false`.
        """
        return pulumi.get(self, "allocate_public_connection")

    @allocate_public_connection.setter
    def allocate_public_connection(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "allocate_public_connection", value)

    @_builtins.property
    @pulumi.getter
    def category(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Category of DBCluster. Valid values: `Basic`,`HighAvailability`.
        """
        return pulumi.get(self, "category")

    @category.setter
    def category(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "category", value)

    @_builtins.property
    @pulumi.getter(name="coldStorage")
    def cold_storage(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether to use cold storage. Valid values: `ENABLE`, `DISABLE`, default to `DISABLE`. When it's set to `ENABLE`, cold storage will be used, and `cold_storage` cannot be set to `DISABLE` again.
        """
        return pulumi.get(self, "cold_storage")

    @cold_storage.setter
    def cold_storage(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cold_storage", value)

    @_builtins.property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Available since v1.196.0) - The connection string of the cluster.
        """
        return pulumi.get(self, "connection_string")

    @connection_string.setter
    def connection_string(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "connection_string", value)

    @_builtins.property
    @pulumi.getter(name="dbClusterAccessWhiteLists")
    def db_cluster_access_white_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DbClusterDbClusterAccessWhiteListArgs']]]]:
        """
        The db cluster access white list. See `db_cluster_access_white_list` below.
        """
        return pulumi.get(self, "db_cluster_access_white_lists")

    @db_cluster_access_white_lists.setter
    def db_cluster_access_white_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DbClusterDbClusterAccessWhiteListArgs']]]]):
        pulumi.set(self, "db_cluster_access_white_lists", value)

    @_builtins.property
    @pulumi.getter(name="dbClusterClass")
    def db_cluster_class(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The DBCluster class. According to the category, db_cluster_class has two value ranges:
        * Under the condition that the category is the `Basic`, Valid values: `LS20`, `LS40`, `LS80`,`S8`, `S16`, `S32`, `S64`,`S80`, `S104`.
        * Under the condition that the category is the `HighAvailability`, Valid values: `LC20`, `LC40`, `LC80`,`C8`, `C16`, `C32`, `C64`, `C80`, `C104`.
        """
        return pulumi.get(self, "db_cluster_class")

    @db_cluster_class.setter
    def db_cluster_class(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "db_cluster_class", value)

    @_builtins.property
    @pulumi.getter(name="dbClusterDescription")
    def db_cluster_description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The DBCluster description.
        """
        return pulumi.get(self, "db_cluster_description")

    @db_cluster_description.setter
    def db_cluster_description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "db_cluster_description", value)

    @_builtins.property
    @pulumi.getter(name="dbClusterNetworkType")
    def db_cluster_network_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The DBCluster network type. Valid values: `vpc`.
        """
        return pulumi.get(self, "db_cluster_network_type")

    @db_cluster_network_type.setter
    def db_cluster_network_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "db_cluster_network_type", value)

    @_builtins.property
    @pulumi.getter(name="dbClusterVersion")
    def db_cluster_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The DBCluster version. Valid values: `20.3.10.75`, `20.8.7.15`, `21.8.10.19`, `22.8.5.29`, `23.8`. **NOTE:** `19.15.2.2` is no longer supported. From version 1.191.0, `db_cluster_version` can be set to `22.8.5.29`.
        """
        return pulumi.get(self, "db_cluster_version")

    @db_cluster_version.setter
    def db_cluster_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "db_cluster_version", value)

    @_builtins.property
    @pulumi.getter(name="dbNodeGroupCount")
    def db_node_group_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The db node group count. The number should between 1 and 48.
        """
        return pulumi.get(self, "db_node_group_count")

    @db_node_group_count.setter
    def db_node_group_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "db_node_group_count", value)

    @_builtins.property
    @pulumi.getter(name="dbNodeStorage")
    def db_node_storage(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The db node storage.
        """
        return pulumi.get(self, "db_node_storage")

    @db_node_storage.setter
    def db_node_storage(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "db_node_storage", value)

    @_builtins.property
    @pulumi.getter(name="encryptionKey")
    def encryption_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Key management service KMS key ID. It is valid and required when encryption_type is `CloudDisk`.
        """
        return pulumi.get(self, "encryption_key")

    @encryption_key.setter
    def encryption_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "encryption_key", value)

    @_builtins.property
    @pulumi.getter(name="encryptionType")
    def encryption_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Currently only supports ECS disk encryption, with a value of CloudDisk, not encrypted when empty.
        """
        return pulumi.get(self, "encryption_type")

    @encryption_type.setter
    def encryption_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "encryption_type", value)

    @_builtins.property
    @pulumi.getter(name="maintainTime")
    def maintain_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The maintenance window of DBCluster. Valid format: `hh:mmZ-hh:mm Z`.
        """
        return pulumi.get(self, "maintain_time")

    @maintain_time.setter
    def maintain_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "maintain_time", value)

    @_builtins.property
    @pulumi.getter(name="multiZoneVswitchLists")
    def multi_zone_vswitch_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DbClusterMultiZoneVswitchListArgs']]]]:
        """
        The zone IDs and 
        corresponding vswitch IDs and zone IDs of multi-zone setup. if set, a multi-zone DBCluster will be created. Currently only support 2 available zones, primary zone not included. See `multi_zone_vswitch_list` below.
        """
        return pulumi.get(self, "multi_zone_vswitch_lists")

    @multi_zone_vswitch_lists.setter
    def multi_zone_vswitch_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DbClusterMultiZoneVswitchListArgs']]]]):
        pulumi.set(self, "multi_zone_vswitch_lists", value)

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The payment type of the resource. Valid values: `PayAsYouGo`,`Subscription`.
        """
        return pulumi.get(self, "payment_type")

    @payment_type.setter
    def payment_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "payment_type", value)

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Pre-paid cluster of the pay-as-you-go cycle. It is valid and required when payment_type is `Subscription`. Valid values: `Month`, `Year`.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "period", value)

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Available since v1.196.0) The connection port of the cluster.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "port", value)

    @_builtins.property
    @pulumi.getter(name="publicConnectionString")
    def public_connection_string(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Available since v1.245.0) The public connection string of the cluster. Only valid when `allocate_public_connection` is `true`.
        """
        return pulumi.get(self, "public_connection_string")

    @public_connection_string.setter
    def public_connection_string(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "public_connection_string", value)

    @_builtins.property
    @pulumi.getter(name="renewalStatus")
    def renewal_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The renewal status of the resource. Valid values: `AutoRenewal`,`Normal`. It is valid and required when payment_type is `Subscription`. When `renewal_status` is set to `AutoRenewal`, the resource is renewed automatically.
        """
        return pulumi.get(self, "renewal_status")

    @renewal_status.setter
    def renewal_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "renewal_status", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the resource. Valid values: `Running`,`Creating`,`Deleting`,`Restarting`,`Preparing`.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="storageType")
    def storage_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Storage type of DBCluster. Valid values: `cloud_essd`, `cloud_efficiency`, `cloud_essd_pl2`, `cloud_essd_pl3`.
        """
        return pulumi.get(self, "storage_type")

    @storage_type.setter
    def storage_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_type", value)

    @_builtins.property
    @pulumi.getter(name="usedTime")
    def used_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The used time of DBCluster. It is valid and required when payment_type is `Subscription`. item choices: [1-9] when period is `Month`, [1-3] when period is `Year`.
        """
        return pulumi.get(self, "used_time")

    @used_time.setter
    def used_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "used_time", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The id of the VPC.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_id", value)

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The vswitch id of DBCluster.
        """
        return pulumi.get(self, "vswitch_id")

    @vswitch_id.setter
    def vswitch_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vswitch_id", value)

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The zone ID of the instance.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone_id", value)


@pulumi.type_token("alicloud:clickhouse/dbCluster:DbCluster")
class DbCluster(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allocate_public_connection: Optional[pulumi.Input[_builtins.bool]] = None,
                 category: Optional[pulumi.Input[_builtins.str]] = None,
                 cold_storage: Optional[pulumi.Input[_builtins.str]] = None,
                 db_cluster_access_white_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DbClusterDbClusterAccessWhiteListArgs', 'DbClusterDbClusterAccessWhiteListArgsDict']]]]] = None,
                 db_cluster_class: Optional[pulumi.Input[_builtins.str]] = None,
                 db_cluster_description: Optional[pulumi.Input[_builtins.str]] = None,
                 db_cluster_network_type: Optional[pulumi.Input[_builtins.str]] = None,
                 db_cluster_version: Optional[pulumi.Input[_builtins.str]] = None,
                 db_node_group_count: Optional[pulumi.Input[_builtins.int]] = None,
                 db_node_storage: Optional[pulumi.Input[_builtins.str]] = None,
                 encryption_key: Optional[pulumi.Input[_builtins.str]] = None,
                 encryption_type: Optional[pulumi.Input[_builtins.str]] = None,
                 maintain_time: Optional[pulumi.Input[_builtins.str]] = None,
                 multi_zone_vswitch_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DbClusterMultiZoneVswitchListArgs', 'DbClusterMultiZoneVswitchListArgsDict']]]]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.str]] = None,
                 renewal_status: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_type: Optional[pulumi.Input[_builtins.str]] = None,
                 used_time: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Click House DBCluster resource.

        For information about Click House DBCluster and how to use it, see [What is DBCluster](https://www.alibabacloud.com/help/zh/clickhouse/latest/api-clickhouse-2019-11-11-createdbinstance).

        > **NOTE:** Available since v1.134.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        region = config.get("region")
        if region is None:
            region = "cn-hangzhou"
        name = config.get("name")
        if name is None:
            name = "tf-example"
        default = alicloud.resourcemanager.get_resource_groups()
        default_get_regions = alicloud.clickhouse.get_regions(region_id=region)
        default_network = alicloud.vpc.Network("default",
            vpc_name=name,
            cidr_block="10.4.0.0/16")
        default_switch = alicloud.vpc.Switch("default",
            vswitch_name=name,
            cidr_block="10.4.0.0/24",
            vpc_id=default_network.id,
            zone_id=default_get_regions.regions[0].zone_ids[0].zone_id)
        default_db_cluster = alicloud.clickhouse.DbCluster("default",
            db_cluster_version="23.8",
            category="Basic",
            db_cluster_class="S8",
            db_cluster_network_type="vpc",
            db_node_group_count=1,
            payment_type="PayAsYouGo",
            db_node_storage="100",
            storage_type="cloud_essd",
            vswitch_id=default_switch.id,
            vpc_id=default_network.id,
            resource_group_id=default.groups[0].id)
        ```

        ## Import

        Click House DBCluster can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:clickhouse/dbCluster:DbCluster example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] allocate_public_connection: Whether to enable public connection. Value options: `true`, `false`.
        :param pulumi.Input[_builtins.str] category: The Category of DBCluster. Valid values: `Basic`,`HighAvailability`.
        :param pulumi.Input[_builtins.str] cold_storage: Whether to use cold storage. Valid values: `ENABLE`, `DISABLE`, default to `DISABLE`. When it's set to `ENABLE`, cold storage will be used, and `cold_storage` cannot be set to `DISABLE` again.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DbClusterDbClusterAccessWhiteListArgs', 'DbClusterDbClusterAccessWhiteListArgsDict']]]] db_cluster_access_white_lists: The db cluster access white list. See `db_cluster_access_white_list` below.
        :param pulumi.Input[_builtins.str] db_cluster_class: The DBCluster class. According to the category, db_cluster_class has two value ranges:
               * Under the condition that the category is the `Basic`, Valid values: `LS20`, `LS40`, `LS80`,`S8`, `S16`, `S32`, `S64`,`S80`, `S104`.
               * Under the condition that the category is the `HighAvailability`, Valid values: `LC20`, `LC40`, `LC80`,`C8`, `C16`, `C32`, `C64`, `C80`, `C104`.
        :param pulumi.Input[_builtins.str] db_cluster_description: The DBCluster description.
        :param pulumi.Input[_builtins.str] db_cluster_network_type: The DBCluster network type. Valid values: `vpc`.
        :param pulumi.Input[_builtins.str] db_cluster_version: The DBCluster version. Valid values: `20.3.10.75`, `20.8.7.15`, `21.8.10.19`, `22.8.5.29`, `23.8`. **NOTE:** `19.15.2.2` is no longer supported. From version 1.191.0, `db_cluster_version` can be set to `22.8.5.29`.
        :param pulumi.Input[_builtins.int] db_node_group_count: The db node group count. The number should between 1 and 48.
        :param pulumi.Input[_builtins.str] db_node_storage: The db node storage.
        :param pulumi.Input[_builtins.str] encryption_key: Key management service KMS key ID. It is valid and required when encryption_type is `CloudDisk`.
        :param pulumi.Input[_builtins.str] encryption_type: Currently only supports ECS disk encryption, with a value of CloudDisk, not encrypted when empty.
        :param pulumi.Input[_builtins.str] maintain_time: The maintenance window of DBCluster. Valid format: `hh:mmZ-hh:mm Z`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DbClusterMultiZoneVswitchListArgs', 'DbClusterMultiZoneVswitchListArgsDict']]]] multi_zone_vswitch_lists: The zone IDs and 
               corresponding vswitch IDs and zone IDs of multi-zone setup. if set, a multi-zone DBCluster will be created. Currently only support 2 available zones, primary zone not included. See `multi_zone_vswitch_list` below.
        :param pulumi.Input[_builtins.str] payment_type: The payment type of the resource. Valid values: `PayAsYouGo`,`Subscription`.
        :param pulumi.Input[_builtins.str] period: Pre-paid cluster of the pay-as-you-go cycle. It is valid and required when payment_type is `Subscription`. Valid values: `Month`, `Year`.
        :param pulumi.Input[_builtins.str] renewal_status: The renewal status of the resource. Valid values: `AutoRenewal`,`Normal`. It is valid and required when payment_type is `Subscription`. When `renewal_status` is set to `AutoRenewal`, the resource is renewed automatically.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group.
        :param pulumi.Input[_builtins.str] status: The status of the resource. Valid values: `Running`,`Creating`,`Deleting`,`Restarting`,`Preparing`.
        :param pulumi.Input[_builtins.str] storage_type: Storage type of DBCluster. Valid values: `cloud_essd`, `cloud_efficiency`, `cloud_essd_pl2`, `cloud_essd_pl3`.
        :param pulumi.Input[_builtins.str] used_time: The used time of DBCluster. It is valid and required when payment_type is `Subscription`. item choices: [1-9] when period is `Month`, [1-3] when period is `Year`.
        :param pulumi.Input[_builtins.str] vpc_id: The id of the VPC.
        :param pulumi.Input[_builtins.str] vswitch_id: The vswitch id of DBCluster.
        :param pulumi.Input[_builtins.str] zone_id: The zone ID of the instance.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DbClusterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Click House DBCluster resource.

        For information about Click House DBCluster and how to use it, see [What is DBCluster](https://www.alibabacloud.com/help/zh/clickhouse/latest/api-clickhouse-2019-11-11-createdbinstance).

        > **NOTE:** Available since v1.134.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        region = config.get("region")
        if region is None:
            region = "cn-hangzhou"
        name = config.get("name")
        if name is None:
            name = "tf-example"
        default = alicloud.resourcemanager.get_resource_groups()
        default_get_regions = alicloud.clickhouse.get_regions(region_id=region)
        default_network = alicloud.vpc.Network("default",
            vpc_name=name,
            cidr_block="10.4.0.0/16")
        default_switch = alicloud.vpc.Switch("default",
            vswitch_name=name,
            cidr_block="10.4.0.0/24",
            vpc_id=default_network.id,
            zone_id=default_get_regions.regions[0].zone_ids[0].zone_id)
        default_db_cluster = alicloud.clickhouse.DbCluster("default",
            db_cluster_version="23.8",
            category="Basic",
            db_cluster_class="S8",
            db_cluster_network_type="vpc",
            db_node_group_count=1,
            payment_type="PayAsYouGo",
            db_node_storage="100",
            storage_type="cloud_essd",
            vswitch_id=default_switch.id,
            vpc_id=default_network.id,
            resource_group_id=default.groups[0].id)
        ```

        ## Import

        Click House DBCluster can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:clickhouse/dbCluster:DbCluster example <id>
        ```

        :param str resource_name: The name of the resource.
        :param DbClusterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DbClusterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allocate_public_connection: Optional[pulumi.Input[_builtins.bool]] = None,
                 category: Optional[pulumi.Input[_builtins.str]] = None,
                 cold_storage: Optional[pulumi.Input[_builtins.str]] = None,
                 db_cluster_access_white_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DbClusterDbClusterAccessWhiteListArgs', 'DbClusterDbClusterAccessWhiteListArgsDict']]]]] = None,
                 db_cluster_class: Optional[pulumi.Input[_builtins.str]] = None,
                 db_cluster_description: Optional[pulumi.Input[_builtins.str]] = None,
                 db_cluster_network_type: Optional[pulumi.Input[_builtins.str]] = None,
                 db_cluster_version: Optional[pulumi.Input[_builtins.str]] = None,
                 db_node_group_count: Optional[pulumi.Input[_builtins.int]] = None,
                 db_node_storage: Optional[pulumi.Input[_builtins.str]] = None,
                 encryption_key: Optional[pulumi.Input[_builtins.str]] = None,
                 encryption_type: Optional[pulumi.Input[_builtins.str]] = None,
                 maintain_time: Optional[pulumi.Input[_builtins.str]] = None,
                 multi_zone_vswitch_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DbClusterMultiZoneVswitchListArgs', 'DbClusterMultiZoneVswitchListArgsDict']]]]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.str]] = None,
                 renewal_status: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_type: Optional[pulumi.Input[_builtins.str]] = None,
                 used_time: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DbClusterArgs.__new__(DbClusterArgs)

            __props__.__dict__["allocate_public_connection"] = allocate_public_connection
            if category is None and not opts.urn:
                raise TypeError("Missing required property 'category'")
            __props__.__dict__["category"] = category
            __props__.__dict__["cold_storage"] = cold_storage
            __props__.__dict__["db_cluster_access_white_lists"] = db_cluster_access_white_lists
            if db_cluster_class is None and not opts.urn:
                raise TypeError("Missing required property 'db_cluster_class'")
            __props__.__dict__["db_cluster_class"] = db_cluster_class
            __props__.__dict__["db_cluster_description"] = db_cluster_description
            if db_cluster_network_type is None and not opts.urn:
                raise TypeError("Missing required property 'db_cluster_network_type'")
            __props__.__dict__["db_cluster_network_type"] = db_cluster_network_type
            if db_cluster_version is None and not opts.urn:
                raise TypeError("Missing required property 'db_cluster_version'")
            __props__.__dict__["db_cluster_version"] = db_cluster_version
            if db_node_group_count is None and not opts.urn:
                raise TypeError("Missing required property 'db_node_group_count'")
            __props__.__dict__["db_node_group_count"] = db_node_group_count
            if db_node_storage is None and not opts.urn:
                raise TypeError("Missing required property 'db_node_storage'")
            __props__.__dict__["db_node_storage"] = db_node_storage
            __props__.__dict__["encryption_key"] = encryption_key
            __props__.__dict__["encryption_type"] = encryption_type
            __props__.__dict__["maintain_time"] = maintain_time
            __props__.__dict__["multi_zone_vswitch_lists"] = multi_zone_vswitch_lists
            if payment_type is None and not opts.urn:
                raise TypeError("Missing required property 'payment_type'")
            __props__.__dict__["payment_type"] = payment_type
            __props__.__dict__["period"] = period
            __props__.__dict__["renewal_status"] = renewal_status
            __props__.__dict__["resource_group_id"] = resource_group_id
            __props__.__dict__["status"] = status
            if storage_type is None and not opts.urn:
                raise TypeError("Missing required property 'storage_type'")
            __props__.__dict__["storage_type"] = storage_type
            __props__.__dict__["used_time"] = used_time
            __props__.__dict__["vpc_id"] = vpc_id
            __props__.__dict__["vswitch_id"] = vswitch_id
            __props__.__dict__["zone_id"] = zone_id
            __props__.__dict__["connection_string"] = None
            __props__.__dict__["port"] = None
            __props__.__dict__["public_connection_string"] = None
        super(DbCluster, __self__).__init__(
            'alicloud:clickhouse/dbCluster:DbCluster',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            allocate_public_connection: Optional[pulumi.Input[_builtins.bool]] = None,
            category: Optional[pulumi.Input[_builtins.str]] = None,
            cold_storage: Optional[pulumi.Input[_builtins.str]] = None,
            connection_string: Optional[pulumi.Input[_builtins.str]] = None,
            db_cluster_access_white_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DbClusterDbClusterAccessWhiteListArgs', 'DbClusterDbClusterAccessWhiteListArgsDict']]]]] = None,
            db_cluster_class: Optional[pulumi.Input[_builtins.str]] = None,
            db_cluster_description: Optional[pulumi.Input[_builtins.str]] = None,
            db_cluster_network_type: Optional[pulumi.Input[_builtins.str]] = None,
            db_cluster_version: Optional[pulumi.Input[_builtins.str]] = None,
            db_node_group_count: Optional[pulumi.Input[_builtins.int]] = None,
            db_node_storage: Optional[pulumi.Input[_builtins.str]] = None,
            encryption_key: Optional[pulumi.Input[_builtins.str]] = None,
            encryption_type: Optional[pulumi.Input[_builtins.str]] = None,
            maintain_time: Optional[pulumi.Input[_builtins.str]] = None,
            multi_zone_vswitch_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DbClusterMultiZoneVswitchListArgs', 'DbClusterMultiZoneVswitchListArgsDict']]]]] = None,
            payment_type: Optional[pulumi.Input[_builtins.str]] = None,
            period: Optional[pulumi.Input[_builtins.str]] = None,
            port: Optional[pulumi.Input[_builtins.str]] = None,
            public_connection_string: Optional[pulumi.Input[_builtins.str]] = None,
            renewal_status: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            storage_type: Optional[pulumi.Input[_builtins.str]] = None,
            used_time: Optional[pulumi.Input[_builtins.str]] = None,
            vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
            vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
            zone_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'DbCluster':
        """
        Get an existing DbCluster resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] allocate_public_connection: Whether to enable public connection. Value options: `true`, `false`.
        :param pulumi.Input[_builtins.str] category: The Category of DBCluster. Valid values: `Basic`,`HighAvailability`.
        :param pulumi.Input[_builtins.str] cold_storage: Whether to use cold storage. Valid values: `ENABLE`, `DISABLE`, default to `DISABLE`. When it's set to `ENABLE`, cold storage will be used, and `cold_storage` cannot be set to `DISABLE` again.
        :param pulumi.Input[_builtins.str] connection_string: (Available since v1.196.0) - The connection string of the cluster.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DbClusterDbClusterAccessWhiteListArgs', 'DbClusterDbClusterAccessWhiteListArgsDict']]]] db_cluster_access_white_lists: The db cluster access white list. See `db_cluster_access_white_list` below.
        :param pulumi.Input[_builtins.str] db_cluster_class: The DBCluster class. According to the category, db_cluster_class has two value ranges:
               * Under the condition that the category is the `Basic`, Valid values: `LS20`, `LS40`, `LS80`,`S8`, `S16`, `S32`, `S64`,`S80`, `S104`.
               * Under the condition that the category is the `HighAvailability`, Valid values: `LC20`, `LC40`, `LC80`,`C8`, `C16`, `C32`, `C64`, `C80`, `C104`.
        :param pulumi.Input[_builtins.str] db_cluster_description: The DBCluster description.
        :param pulumi.Input[_builtins.str] db_cluster_network_type: The DBCluster network type. Valid values: `vpc`.
        :param pulumi.Input[_builtins.str] db_cluster_version: The DBCluster version. Valid values: `20.3.10.75`, `20.8.7.15`, `21.8.10.19`, `22.8.5.29`, `23.8`. **NOTE:** `19.15.2.2` is no longer supported. From version 1.191.0, `db_cluster_version` can be set to `22.8.5.29`.
        :param pulumi.Input[_builtins.int] db_node_group_count: The db node group count. The number should between 1 and 48.
        :param pulumi.Input[_builtins.str] db_node_storage: The db node storage.
        :param pulumi.Input[_builtins.str] encryption_key: Key management service KMS key ID. It is valid and required when encryption_type is `CloudDisk`.
        :param pulumi.Input[_builtins.str] encryption_type: Currently only supports ECS disk encryption, with a value of CloudDisk, not encrypted when empty.
        :param pulumi.Input[_builtins.str] maintain_time: The maintenance window of DBCluster. Valid format: `hh:mmZ-hh:mm Z`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DbClusterMultiZoneVswitchListArgs', 'DbClusterMultiZoneVswitchListArgsDict']]]] multi_zone_vswitch_lists: The zone IDs and 
               corresponding vswitch IDs and zone IDs of multi-zone setup. if set, a multi-zone DBCluster will be created. Currently only support 2 available zones, primary zone not included. See `multi_zone_vswitch_list` below.
        :param pulumi.Input[_builtins.str] payment_type: The payment type of the resource. Valid values: `PayAsYouGo`,`Subscription`.
        :param pulumi.Input[_builtins.str] period: Pre-paid cluster of the pay-as-you-go cycle. It is valid and required when payment_type is `Subscription`. Valid values: `Month`, `Year`.
        :param pulumi.Input[_builtins.str] port: (Available since v1.196.0) The connection port of the cluster.
        :param pulumi.Input[_builtins.str] public_connection_string: (Available since v1.245.0) The public connection string of the cluster. Only valid when `allocate_public_connection` is `true`.
        :param pulumi.Input[_builtins.str] renewal_status: The renewal status of the resource. Valid values: `AutoRenewal`,`Normal`. It is valid and required when payment_type is `Subscription`. When `renewal_status` is set to `AutoRenewal`, the resource is renewed automatically.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group.
        :param pulumi.Input[_builtins.str] status: The status of the resource. Valid values: `Running`,`Creating`,`Deleting`,`Restarting`,`Preparing`.
        :param pulumi.Input[_builtins.str] storage_type: Storage type of DBCluster. Valid values: `cloud_essd`, `cloud_efficiency`, `cloud_essd_pl2`, `cloud_essd_pl3`.
        :param pulumi.Input[_builtins.str] used_time: The used time of DBCluster. It is valid and required when payment_type is `Subscription`. item choices: [1-9] when period is `Month`, [1-3] when period is `Year`.
        :param pulumi.Input[_builtins.str] vpc_id: The id of the VPC.
        :param pulumi.Input[_builtins.str] vswitch_id: The vswitch id of DBCluster.
        :param pulumi.Input[_builtins.str] zone_id: The zone ID of the instance.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DbClusterState.__new__(_DbClusterState)

        __props__.__dict__["allocate_public_connection"] = allocate_public_connection
        __props__.__dict__["category"] = category
        __props__.__dict__["cold_storage"] = cold_storage
        __props__.__dict__["connection_string"] = connection_string
        __props__.__dict__["db_cluster_access_white_lists"] = db_cluster_access_white_lists
        __props__.__dict__["db_cluster_class"] = db_cluster_class
        __props__.__dict__["db_cluster_description"] = db_cluster_description
        __props__.__dict__["db_cluster_network_type"] = db_cluster_network_type
        __props__.__dict__["db_cluster_version"] = db_cluster_version
        __props__.__dict__["db_node_group_count"] = db_node_group_count
        __props__.__dict__["db_node_storage"] = db_node_storage
        __props__.__dict__["encryption_key"] = encryption_key
        __props__.__dict__["encryption_type"] = encryption_type
        __props__.__dict__["maintain_time"] = maintain_time
        __props__.__dict__["multi_zone_vswitch_lists"] = multi_zone_vswitch_lists
        __props__.__dict__["payment_type"] = payment_type
        __props__.__dict__["period"] = period
        __props__.__dict__["port"] = port
        __props__.__dict__["public_connection_string"] = public_connection_string
        __props__.__dict__["renewal_status"] = renewal_status
        __props__.__dict__["resource_group_id"] = resource_group_id
        __props__.__dict__["status"] = status
        __props__.__dict__["storage_type"] = storage_type
        __props__.__dict__["used_time"] = used_time
        __props__.__dict__["vpc_id"] = vpc_id
        __props__.__dict__["vswitch_id"] = vswitch_id
        __props__.__dict__["zone_id"] = zone_id
        return DbCluster(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="allocatePublicConnection")
    def allocate_public_connection(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to enable public connection. Value options: `true`, `false`.
        """
        return pulumi.get(self, "allocate_public_connection")

    @_builtins.property
    @pulumi.getter
    def category(self) -> pulumi.Output[_builtins.str]:
        """
        The Category of DBCluster. Valid values: `Basic`,`HighAvailability`.
        """
        return pulumi.get(self, "category")

    @_builtins.property
    @pulumi.getter(name="coldStorage")
    def cold_storage(self) -> pulumi.Output[_builtins.str]:
        """
        Whether to use cold storage. Valid values: `ENABLE`, `DISABLE`, default to `DISABLE`. When it's set to `ENABLE`, cold storage will be used, and `cold_storage` cannot be set to `DISABLE` again.
        """
        return pulumi.get(self, "cold_storage")

    @_builtins.property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> pulumi.Output[_builtins.str]:
        """
        (Available since v1.196.0) - The connection string of the cluster.
        """
        return pulumi.get(self, "connection_string")

    @_builtins.property
    @pulumi.getter(name="dbClusterAccessWhiteLists")
    def db_cluster_access_white_lists(self) -> pulumi.Output[Optional[Sequence['outputs.DbClusterDbClusterAccessWhiteList']]]:
        """
        The db cluster access white list. See `db_cluster_access_white_list` below.
        """
        return pulumi.get(self, "db_cluster_access_white_lists")

    @_builtins.property
    @pulumi.getter(name="dbClusterClass")
    def db_cluster_class(self) -> pulumi.Output[_builtins.str]:
        """
        The DBCluster class. According to the category, db_cluster_class has two value ranges:
        * Under the condition that the category is the `Basic`, Valid values: `LS20`, `LS40`, `LS80`,`S8`, `S16`, `S32`, `S64`,`S80`, `S104`.
        * Under the condition that the category is the `HighAvailability`, Valid values: `LC20`, `LC40`, `LC80`,`C8`, `C16`, `C32`, `C64`, `C80`, `C104`.
        """
        return pulumi.get(self, "db_cluster_class")

    @_builtins.property
    @pulumi.getter(name="dbClusterDescription")
    def db_cluster_description(self) -> pulumi.Output[_builtins.str]:
        """
        The DBCluster description.
        """
        return pulumi.get(self, "db_cluster_description")

    @_builtins.property
    @pulumi.getter(name="dbClusterNetworkType")
    def db_cluster_network_type(self) -> pulumi.Output[_builtins.str]:
        """
        The DBCluster network type. Valid values: `vpc`.
        """
        return pulumi.get(self, "db_cluster_network_type")

    @_builtins.property
    @pulumi.getter(name="dbClusterVersion")
    def db_cluster_version(self) -> pulumi.Output[_builtins.str]:
        """
        The DBCluster version. Valid values: `20.3.10.75`, `20.8.7.15`, `21.8.10.19`, `22.8.5.29`, `23.8`. **NOTE:** `19.15.2.2` is no longer supported. From version 1.191.0, `db_cluster_version` can be set to `22.8.5.29`.
        """
        return pulumi.get(self, "db_cluster_version")

    @_builtins.property
    @pulumi.getter(name="dbNodeGroupCount")
    def db_node_group_count(self) -> pulumi.Output[_builtins.int]:
        """
        The db node group count. The number should between 1 and 48.
        """
        return pulumi.get(self, "db_node_group_count")

    @_builtins.property
    @pulumi.getter(name="dbNodeStorage")
    def db_node_storage(self) -> pulumi.Output[_builtins.str]:
        """
        The db node storage.
        """
        return pulumi.get(self, "db_node_storage")

    @_builtins.property
    @pulumi.getter(name="encryptionKey")
    def encryption_key(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Key management service KMS key ID. It is valid and required when encryption_type is `CloudDisk`.
        """
        return pulumi.get(self, "encryption_key")

    @_builtins.property
    @pulumi.getter(name="encryptionType")
    def encryption_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Currently only supports ECS disk encryption, with a value of CloudDisk, not encrypted when empty.
        """
        return pulumi.get(self, "encryption_type")

    @_builtins.property
    @pulumi.getter(name="maintainTime")
    def maintain_time(self) -> pulumi.Output[_builtins.str]:
        """
        The maintenance window of DBCluster. Valid format: `hh:mmZ-hh:mm Z`.
        """
        return pulumi.get(self, "maintain_time")

    @_builtins.property
    @pulumi.getter(name="multiZoneVswitchLists")
    def multi_zone_vswitch_lists(self) -> pulumi.Output[Optional[Sequence['outputs.DbClusterMultiZoneVswitchList']]]:
        """
        The zone IDs and 
        corresponding vswitch IDs and zone IDs of multi-zone setup. if set, a multi-zone DBCluster will be created. Currently only support 2 available zones, primary zone not included. See `multi_zone_vswitch_list` below.
        """
        return pulumi.get(self, "multi_zone_vswitch_lists")

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> pulumi.Output[_builtins.str]:
        """
        The payment type of the resource. Valid values: `PayAsYouGo`,`Subscription`.
        """
        return pulumi.get(self, "payment_type")

    @_builtins.property
    @pulumi.getter
    def period(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Pre-paid cluster of the pay-as-you-go cycle. It is valid and required when payment_type is `Subscription`. Valid values: `Month`, `Year`.
        """
        return pulumi.get(self, "period")

    @_builtins.property
    @pulumi.getter
    def port(self) -> pulumi.Output[_builtins.str]:
        """
        (Available since v1.196.0) The connection port of the cluster.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="publicConnectionString")
    def public_connection_string(self) -> pulumi.Output[_builtins.str]:
        """
        (Available since v1.245.0) The public connection string of the cluster. Only valid when `allocate_public_connection` is `true`.
        """
        return pulumi.get(self, "public_connection_string")

    @_builtins.property
    @pulumi.getter(name="renewalStatus")
    def renewal_status(self) -> pulumi.Output[_builtins.str]:
        """
        The renewal status of the resource. Valid values: `AutoRenewal`,`Normal`. It is valid and required when payment_type is `Subscription`. When `renewal_status` is set to `AutoRenewal`, the resource is renewed automatically.
        """
        return pulumi.get(self, "renewal_status")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the resource. Valid values: `Running`,`Creating`,`Deleting`,`Restarting`,`Preparing`.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="storageType")
    def storage_type(self) -> pulumi.Output[_builtins.str]:
        """
        Storage type of DBCluster. Valid values: `cloud_essd`, `cloud_efficiency`, `cloud_essd_pl2`, `cloud_essd_pl3`.
        """
        return pulumi.get(self, "storage_type")

    @_builtins.property
    @pulumi.getter(name="usedTime")
    def used_time(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The used time of DBCluster. It is valid and required when payment_type is `Subscription`. item choices: [1-9] when period is `Month`, [1-3] when period is `Year`.
        """
        return pulumi.get(self, "used_time")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[_builtins.str]:
        """
        The id of the VPC.
        """
        return pulumi.get(self, "vpc_id")

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The vswitch id of DBCluster.
        """
        return pulumi.get(self, "vswitch_id")

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Output[_builtins.str]:
        """
        The zone ID of the instance.
        """
        return pulumi.get(self, "zone_id")

