# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ClickHouseEnterpriseDbClusterArgs', 'ClickHouseEnterpriseDbCluster']

@pulumi.input_type
class ClickHouseEnterpriseDbClusterArgs:
    def __init__(__self__, *,
                 multi_zones: Optional[pulumi.Input[Sequence[pulumi.Input['ClickHouseEnterpriseDbClusterMultiZoneArgs']]]] = None,
                 scale_max: Optional[pulumi.Input[_builtins.str]] = None,
                 scale_min: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ClickHouseEnterpriseDbCluster resource.
        :param pulumi.Input[Sequence[pulumi.Input['ClickHouseEnterpriseDbClusterMultiZoneArgs']]] multi_zones: The list of multi-zone information. See `multi_zones` below.
        :param pulumi.Input[_builtins.str] scale_max: The maximum value of serverless auto scaling.
        :param pulumi.Input[_builtins.str] scale_min: The minimum value of serverless auto scaling.
        :param pulumi.Input[_builtins.str] vpc_id: The VPC ID.
        :param pulumi.Input[_builtins.str] vswitch_id: The vSwitch ID.
        :param pulumi.Input[_builtins.str] zone_id: The zone ID.
        """
        if multi_zones is not None:
            pulumi.set(__self__, "multi_zones", multi_zones)
        if scale_max is not None:
            pulumi.set(__self__, "scale_max", scale_max)
        if scale_min is not None:
            pulumi.set(__self__, "scale_min", scale_min)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)
        if vswitch_id is not None:
            pulumi.set(__self__, "vswitch_id", vswitch_id)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter(name="multiZones")
    def multi_zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClickHouseEnterpriseDbClusterMultiZoneArgs']]]]:
        """
        The list of multi-zone information. See `multi_zones` below.
        """
        return pulumi.get(self, "multi_zones")

    @multi_zones.setter
    def multi_zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClickHouseEnterpriseDbClusterMultiZoneArgs']]]]):
        pulumi.set(self, "multi_zones", value)

    @_builtins.property
    @pulumi.getter(name="scaleMax")
    def scale_max(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The maximum value of serverless auto scaling.
        """
        return pulumi.get(self, "scale_max")

    @scale_max.setter
    def scale_max(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scale_max", value)

    @_builtins.property
    @pulumi.getter(name="scaleMin")
    def scale_min(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The minimum value of serverless auto scaling.
        """
        return pulumi.get(self, "scale_min")

    @scale_min.setter
    def scale_min(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scale_min", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The VPC ID.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_id", value)

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The vSwitch ID.
        """
        return pulumi.get(self, "vswitch_id")

    @vswitch_id.setter
    def vswitch_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vswitch_id", value)

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The zone ID.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone_id", value)


@pulumi.input_type
class _ClickHouseEnterpriseDbClusterState:
    def __init__(__self__, *,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 multi_zones: Optional[pulumi.Input[Sequence[pulumi.Input['ClickHouseEnterpriseDbClusterMultiZoneArgs']]]] = None,
                 region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 scale_max: Optional[pulumi.Input[_builtins.str]] = None,
                 scale_min: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ClickHouseEnterpriseDbCluster resources.
        :param pulumi.Input[_builtins.str] create_time: The creation time of the resource
        :param pulumi.Input[Sequence[pulumi.Input['ClickHouseEnterpriseDbClusterMultiZoneArgs']]] multi_zones: The list of multi-zone information. See `multi_zones` below.
        :param pulumi.Input[_builtins.str] region_id: The region ID of the resource
        :param pulumi.Input[_builtins.str] scale_max: The maximum value of serverless auto scaling.
        :param pulumi.Input[_builtins.str] scale_min: The minimum value of serverless auto scaling.
        :param pulumi.Input[_builtins.str] status: The status of the resource
        :param pulumi.Input[_builtins.str] vpc_id: The VPC ID.
        :param pulumi.Input[_builtins.str] vswitch_id: The vSwitch ID.
        :param pulumi.Input[_builtins.str] zone_id: The zone ID.
        """
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if multi_zones is not None:
            pulumi.set(__self__, "multi_zones", multi_zones)
        if region_id is not None:
            pulumi.set(__self__, "region_id", region_id)
        if scale_max is not None:
            pulumi.set(__self__, "scale_max", scale_max)
        if scale_min is not None:
            pulumi.set(__self__, "scale_min", scale_min)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)
        if vswitch_id is not None:
            pulumi.set(__self__, "vswitch_id", vswitch_id)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The creation time of the resource
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="multiZones")
    def multi_zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClickHouseEnterpriseDbClusterMultiZoneArgs']]]]:
        """
        The list of multi-zone information. See `multi_zones` below.
        """
        return pulumi.get(self, "multi_zones")

    @multi_zones.setter
    def multi_zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClickHouseEnterpriseDbClusterMultiZoneArgs']]]]):
        pulumi.set(self, "multi_zones", value)

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region ID of the resource
        """
        return pulumi.get(self, "region_id")

    @region_id.setter
    def region_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region_id", value)

    @_builtins.property
    @pulumi.getter(name="scaleMax")
    def scale_max(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The maximum value of serverless auto scaling.
        """
        return pulumi.get(self, "scale_max")

    @scale_max.setter
    def scale_max(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scale_max", value)

    @_builtins.property
    @pulumi.getter(name="scaleMin")
    def scale_min(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The minimum value of serverless auto scaling.
        """
        return pulumi.get(self, "scale_min")

    @scale_min.setter
    def scale_min(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scale_min", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the resource
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The VPC ID.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_id", value)

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The vSwitch ID.
        """
        return pulumi.get(self, "vswitch_id")

    @vswitch_id.setter
    def vswitch_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vswitch_id", value)

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The zone ID.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone_id", value)


@pulumi.type_token("alicloud:clickhouseenterprisedbcluster/clickHouseEnterpriseDbCluster:ClickHouseEnterpriseDbCluster")
class ClickHouseEnterpriseDbCluster(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 multi_zones: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClickHouseEnterpriseDbClusterMultiZoneArgs', 'ClickHouseEnterpriseDbClusterMultiZoneArgsDict']]]]] = None,
                 scale_max: Optional[pulumi.Input[_builtins.str]] = None,
                 scale_min: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Click House Enterprise D B Cluster resource.

        Enterprise Edition Cluster Resources.

        For information about Click House Enterprise D B Cluster and how to use it, see [What is Enterprise D B Cluster](https://next.api.alibabacloud.com/document/clickhouse/2023-05-22/CreateDBInstance).

        > **NOTE:** Available since v1.247.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        vsw_ip_range_i = config.get("vswIpRangeI")
        if vsw_ip_range_i is None:
            vsw_ip_range_i = "172.16.1.0/24"
        region_id = config.get("regionId")
        if region_id is None:
            region_id = "cn-beijing"
        vpc_ip_range = config.get("vpcIpRange")
        if vpc_ip_range is None:
            vpc_ip_range = "172.16.0.0/12"
        vsw_ip_range_k = config.get("vswIpRangeK")
        if vsw_ip_range_k is None:
            vsw_ip_range_k = "172.16.3.0/24"
        vsw_ip_range_l = config.get("vswIpRangeL")
        if vsw_ip_range_l is None:
            vsw_ip_range_l = "172.16.2.0/24"
        zone_id_i = config.get("zoneIdI")
        if zone_id_i is None:
            zone_id_i = "cn-beijing-i"
        zone_id_l = config.get("zoneIdL")
        if zone_id_l is None:
            zone_id_l = "cn-beijing-l"
        zone_id_k = config.get("zoneIdK")
        if zone_id_k is None:
            zone_id_k = "cn-beijing-k"
        defaultkt_k_lu_m = alicloud.vpc.Network("defaultktKLuM", cidr_block=vpc_ip_range)
        default_tqwn3k = alicloud.vpc.Switch("defaultTQWN3k",
            vpc_id=defaultkt_k_lu_m.id,
            zone_id=zone_id_i,
            cidr_block=vsw_ip_range_i)
        defaultyly_lu8 = alicloud.vpc.Switch("defaultylyLu8",
            vpc_id=defaultkt_k_lu_m.id,
            zone_id=zone_id_l,
            cidr_block=vsw_ip_range_l)
        default_r_nb_ph8 = alicloud.vpc.Switch("defaultRNbPh8",
            vpc_id=defaultkt_k_lu_m.id,
            zone_id=zone_id_k,
            cidr_block=vsw_ip_range_k)
        default = alicloud.clickhouseenterprisedbcluster.ClickHouseEnterpriseDbCluster("default",
            zone_id=zone_id_i,
            vpc_id=defaultkt_k_lu_m.id,
            scale_min="8",
            scale_max="16",
            vswitch_id=default_tqwn3k.id,
            multi_zones=[
                {
                    "vswitch_ids": [default_tqwn3k.id],
                    "zone_id": zone_id_i,
                },
                {
                    "vswitch_ids": [defaultyly_lu8.id],
                    "zone_id": zone_id_l,
                },
                {
                    "vswitch_ids": [default_r_nb_ph8.id],
                    "zone_id": zone_id_k,
                },
            ])
        ```

        ## Import

        Click House Enterprise D B Cluster can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:clickhouseenterprisedbcluster/clickHouseEnterpriseDbCluster:ClickHouseEnterpriseDbCluster example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ClickHouseEnterpriseDbClusterMultiZoneArgs', 'ClickHouseEnterpriseDbClusterMultiZoneArgsDict']]]] multi_zones: The list of multi-zone information. See `multi_zones` below.
        :param pulumi.Input[_builtins.str] scale_max: The maximum value of serverless auto scaling.
        :param pulumi.Input[_builtins.str] scale_min: The minimum value of serverless auto scaling.
        :param pulumi.Input[_builtins.str] vpc_id: The VPC ID.
        :param pulumi.Input[_builtins.str] vswitch_id: The vSwitch ID.
        :param pulumi.Input[_builtins.str] zone_id: The zone ID.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ClickHouseEnterpriseDbClusterArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Click House Enterprise D B Cluster resource.

        Enterprise Edition Cluster Resources.

        For information about Click House Enterprise D B Cluster and how to use it, see [What is Enterprise D B Cluster](https://next.api.alibabacloud.com/document/clickhouse/2023-05-22/CreateDBInstance).

        > **NOTE:** Available since v1.247.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        vsw_ip_range_i = config.get("vswIpRangeI")
        if vsw_ip_range_i is None:
            vsw_ip_range_i = "172.16.1.0/24"
        region_id = config.get("regionId")
        if region_id is None:
            region_id = "cn-beijing"
        vpc_ip_range = config.get("vpcIpRange")
        if vpc_ip_range is None:
            vpc_ip_range = "172.16.0.0/12"
        vsw_ip_range_k = config.get("vswIpRangeK")
        if vsw_ip_range_k is None:
            vsw_ip_range_k = "172.16.3.0/24"
        vsw_ip_range_l = config.get("vswIpRangeL")
        if vsw_ip_range_l is None:
            vsw_ip_range_l = "172.16.2.0/24"
        zone_id_i = config.get("zoneIdI")
        if zone_id_i is None:
            zone_id_i = "cn-beijing-i"
        zone_id_l = config.get("zoneIdL")
        if zone_id_l is None:
            zone_id_l = "cn-beijing-l"
        zone_id_k = config.get("zoneIdK")
        if zone_id_k is None:
            zone_id_k = "cn-beijing-k"
        defaultkt_k_lu_m = alicloud.vpc.Network("defaultktKLuM", cidr_block=vpc_ip_range)
        default_tqwn3k = alicloud.vpc.Switch("defaultTQWN3k",
            vpc_id=defaultkt_k_lu_m.id,
            zone_id=zone_id_i,
            cidr_block=vsw_ip_range_i)
        defaultyly_lu8 = alicloud.vpc.Switch("defaultylyLu8",
            vpc_id=defaultkt_k_lu_m.id,
            zone_id=zone_id_l,
            cidr_block=vsw_ip_range_l)
        default_r_nb_ph8 = alicloud.vpc.Switch("defaultRNbPh8",
            vpc_id=defaultkt_k_lu_m.id,
            zone_id=zone_id_k,
            cidr_block=vsw_ip_range_k)
        default = alicloud.clickhouseenterprisedbcluster.ClickHouseEnterpriseDbCluster("default",
            zone_id=zone_id_i,
            vpc_id=defaultkt_k_lu_m.id,
            scale_min="8",
            scale_max="16",
            vswitch_id=default_tqwn3k.id,
            multi_zones=[
                {
                    "vswitch_ids": [default_tqwn3k.id],
                    "zone_id": zone_id_i,
                },
                {
                    "vswitch_ids": [defaultyly_lu8.id],
                    "zone_id": zone_id_l,
                },
                {
                    "vswitch_ids": [default_r_nb_ph8.id],
                    "zone_id": zone_id_k,
                },
            ])
        ```

        ## Import

        Click House Enterprise D B Cluster can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:clickhouseenterprisedbcluster/clickHouseEnterpriseDbCluster:ClickHouseEnterpriseDbCluster example <id>
        ```

        :param str resource_name: The name of the resource.
        :param ClickHouseEnterpriseDbClusterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ClickHouseEnterpriseDbClusterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 multi_zones: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClickHouseEnterpriseDbClusterMultiZoneArgs', 'ClickHouseEnterpriseDbClusterMultiZoneArgsDict']]]]] = None,
                 scale_max: Optional[pulumi.Input[_builtins.str]] = None,
                 scale_min: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ClickHouseEnterpriseDbClusterArgs.__new__(ClickHouseEnterpriseDbClusterArgs)

            __props__.__dict__["multi_zones"] = multi_zones
            __props__.__dict__["scale_max"] = scale_max
            __props__.__dict__["scale_min"] = scale_min
            __props__.__dict__["vpc_id"] = vpc_id
            __props__.__dict__["vswitch_id"] = vswitch_id
            __props__.__dict__["zone_id"] = zone_id
            __props__.__dict__["create_time"] = None
            __props__.__dict__["region_id"] = None
            __props__.__dict__["status"] = None
        super(ClickHouseEnterpriseDbCluster, __self__).__init__(
            'alicloud:clickhouseenterprisedbcluster/clickHouseEnterpriseDbCluster:ClickHouseEnterpriseDbCluster',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            multi_zones: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClickHouseEnterpriseDbClusterMultiZoneArgs', 'ClickHouseEnterpriseDbClusterMultiZoneArgsDict']]]]] = None,
            region_id: Optional[pulumi.Input[_builtins.str]] = None,
            scale_max: Optional[pulumi.Input[_builtins.str]] = None,
            scale_min: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
            vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
            zone_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'ClickHouseEnterpriseDbCluster':
        """
        Get an existing ClickHouseEnterpriseDbCluster resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] create_time: The creation time of the resource
        :param pulumi.Input[Sequence[pulumi.Input[Union['ClickHouseEnterpriseDbClusterMultiZoneArgs', 'ClickHouseEnterpriseDbClusterMultiZoneArgsDict']]]] multi_zones: The list of multi-zone information. See `multi_zones` below.
        :param pulumi.Input[_builtins.str] region_id: The region ID of the resource
        :param pulumi.Input[_builtins.str] scale_max: The maximum value of serverless auto scaling.
        :param pulumi.Input[_builtins.str] scale_min: The minimum value of serverless auto scaling.
        :param pulumi.Input[_builtins.str] status: The status of the resource
        :param pulumi.Input[_builtins.str] vpc_id: The VPC ID.
        :param pulumi.Input[_builtins.str] vswitch_id: The vSwitch ID.
        :param pulumi.Input[_builtins.str] zone_id: The zone ID.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ClickHouseEnterpriseDbClusterState.__new__(_ClickHouseEnterpriseDbClusterState)

        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["multi_zones"] = multi_zones
        __props__.__dict__["region_id"] = region_id
        __props__.__dict__["scale_max"] = scale_max
        __props__.__dict__["scale_min"] = scale_min
        __props__.__dict__["status"] = status
        __props__.__dict__["vpc_id"] = vpc_id
        __props__.__dict__["vswitch_id"] = vswitch_id
        __props__.__dict__["zone_id"] = zone_id
        return ClickHouseEnterpriseDbCluster(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        The creation time of the resource
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="multiZones")
    def multi_zones(self) -> pulumi.Output[Sequence['outputs.ClickHouseEnterpriseDbClusterMultiZone']]:
        """
        The list of multi-zone information. See `multi_zones` below.
        """
        return pulumi.get(self, "multi_zones")

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> pulumi.Output[_builtins.str]:
        """
        The region ID of the resource
        """
        return pulumi.get(self, "region_id")

    @_builtins.property
    @pulumi.getter(name="scaleMax")
    def scale_max(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The maximum value of serverless auto scaling.
        """
        return pulumi.get(self, "scale_max")

    @_builtins.property
    @pulumi.getter(name="scaleMin")
    def scale_min(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The minimum value of serverless auto scaling.
        """
        return pulumi.get(self, "scale_min")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the resource
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The VPC ID.
        """
        return pulumi.get(self, "vpc_id")

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The vSwitch ID.
        """
        return pulumi.get(self, "vswitch_id")

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The zone ID.
        """
        return pulumi.get(self, "zone_id")

