# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetVpcFirewallControlPoliciesResult',
    'AwaitableGetVpcFirewallControlPoliciesResult',
    'get_vpc_firewall_control_policies',
    'get_vpc_firewall_control_policies_output',
]

@pulumi.output_type
class GetVpcFirewallControlPoliciesResult:
    """
    A collection of values returned by getVpcFirewallControlPolicies.
    """
    def __init__(__self__, acl_action=None, acl_uuid=None, description=None, destination=None, id=None, ids=None, lang=None, member_uid=None, output_file=None, page_number=None, page_size=None, policies=None, proto=None, release=None, source=None, vpc_firewall_id=None):
        if acl_action and not isinstance(acl_action, str):
            raise TypeError("Expected argument 'acl_action' to be a str")
        pulumi.set(__self__, "acl_action", acl_action)
        if acl_uuid and not isinstance(acl_uuid, str):
            raise TypeError("Expected argument 'acl_uuid' to be a str")
        pulumi.set(__self__, "acl_uuid", acl_uuid)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if destination and not isinstance(destination, str):
            raise TypeError("Expected argument 'destination' to be a str")
        pulumi.set(__self__, "destination", destination)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if lang and not isinstance(lang, str):
            raise TypeError("Expected argument 'lang' to be a str")
        pulumi.set(__self__, "lang", lang)
        if member_uid and not isinstance(member_uid, str):
            raise TypeError("Expected argument 'member_uid' to be a str")
        pulumi.set(__self__, "member_uid", member_uid)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if page_number and not isinstance(page_number, int):
            raise TypeError("Expected argument 'page_number' to be a int")
        pulumi.set(__self__, "page_number", page_number)
        if page_size and not isinstance(page_size, int):
            raise TypeError("Expected argument 'page_size' to be a int")
        pulumi.set(__self__, "page_size", page_size)
        if policies and not isinstance(policies, list):
            raise TypeError("Expected argument 'policies' to be a list")
        pulumi.set(__self__, "policies", policies)
        if proto and not isinstance(proto, str):
            raise TypeError("Expected argument 'proto' to be a str")
        pulumi.set(__self__, "proto", proto)
        if release and not isinstance(release, bool):
            raise TypeError("Expected argument 'release' to be a bool")
        pulumi.set(__self__, "release", release)
        if source and not isinstance(source, str):
            raise TypeError("Expected argument 'source' to be a str")
        pulumi.set(__self__, "source", source)
        if vpc_firewall_id and not isinstance(vpc_firewall_id, str):
            raise TypeError("Expected argument 'vpc_firewall_id' to be a str")
        pulumi.set(__self__, "vpc_firewall_id", vpc_firewall_id)

    @_builtins.property
    @pulumi.getter(name="aclAction")
    def acl_action(self) -> Optional[_builtins.str]:
        """
        Access control over VPC firewalls are set in the access traffic via Alibaba cloud firewall way (ACT).
        """
        return pulumi.get(self, "acl_action")

    @_builtins.property
    @pulumi.getter(name="aclUuid")
    def acl_uuid(self) -> Optional[_builtins.str]:
        """
        Access control over VPC firewalls strategy unique identifier.
        """
        return pulumi.get(self, "acl_uuid")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        """
        Access control over VPC firewalls description of the strategy information.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def destination(self) -> Optional[_builtins.str]:
        """
        Access control over VPC firewalls strategy the destination address in.
        """
        return pulumi.get(self, "destination")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ids(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "ids")

    @_builtins.property
    @pulumi.getter
    def lang(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "lang")

    @_builtins.property
    @pulumi.getter(name="memberUid")
    def member_uid(self) -> Optional[_builtins.str]:
        """
        The UID of the member account of the current Alibaba cloud account.
        """
        return pulumi.get(self, "member_uid")

    @_builtins.property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "output_file")

    @_builtins.property
    @pulumi.getter(name="pageNumber")
    def page_number(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "page_number")

    @_builtins.property
    @pulumi.getter(name="pageSize")
    def page_size(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "page_size")

    @_builtins.property
    @pulumi.getter
    def policies(self) -> Sequence['outputs.GetVpcFirewallControlPoliciesPolicyResult']:
        """
        A list of Cloud Firewall Vpc Firewall Control Policies. Each element contains the following attributes:
        """
        return pulumi.get(self, "policies")

    @_builtins.property
    @pulumi.getter
    def proto(self) -> Optional[_builtins.str]:
        """
        Access control over VPC firewalls strategy access traffic of the protocol type.
        """
        return pulumi.get(self, "proto")

    @_builtins.property
    @pulumi.getter
    def release(self) -> Optional[_builtins.bool]:
        """
        The enabled status of the access control policy. The policy is enabled by default after it is created. Value:
        """
        return pulumi.get(self, "release")

    @_builtins.property
    @pulumi.getter
    def source(self) -> Optional[_builtins.str]:
        """
        Access control over VPC firewalls strategy in the source address.
        """
        return pulumi.get(self, "source")

    @_builtins.property
    @pulumi.getter(name="vpcFirewallId")
    def vpc_firewall_id(self) -> _builtins.str:
        """
        The ID of the VPC firewall instance.
        """
        return pulumi.get(self, "vpc_firewall_id")


class AwaitableGetVpcFirewallControlPoliciesResult(GetVpcFirewallControlPoliciesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetVpcFirewallControlPoliciesResult(
            acl_action=self.acl_action,
            acl_uuid=self.acl_uuid,
            description=self.description,
            destination=self.destination,
            id=self.id,
            ids=self.ids,
            lang=self.lang,
            member_uid=self.member_uid,
            output_file=self.output_file,
            page_number=self.page_number,
            page_size=self.page_size,
            policies=self.policies,
            proto=self.proto,
            release=self.release,
            source=self.source,
            vpc_firewall_id=self.vpc_firewall_id)


def get_vpc_firewall_control_policies(acl_action: Optional[_builtins.str] = None,
                                      acl_uuid: Optional[_builtins.str] = None,
                                      description: Optional[_builtins.str] = None,
                                      destination: Optional[_builtins.str] = None,
                                      ids: Optional[Sequence[_builtins.str]] = None,
                                      lang: Optional[_builtins.str] = None,
                                      member_uid: Optional[_builtins.str] = None,
                                      output_file: Optional[_builtins.str] = None,
                                      page_number: Optional[_builtins.int] = None,
                                      page_size: Optional[_builtins.int] = None,
                                      proto: Optional[_builtins.str] = None,
                                      release: Optional[_builtins.bool] = None,
                                      source: Optional[_builtins.str] = None,
                                      vpc_firewall_id: Optional[_builtins.str] = None,
                                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetVpcFirewallControlPoliciesResult:
    """
    This data source provides the Cloud Firewall Vpc Firewall Control Policies of the current Alibaba Cloud user.

    > **NOTE:** Available since v1.194.0.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    ids = alicloud.cloudfirewall.get_vpc_firewall_control_policies(vpc_firewall_id="example_value",
        ids=[
            "example_value-1",
            "example_value-2",
        ])
    pulumi.export("alicloudCloudFirewallVpcFirewallControlPoliciesId1", ids.policies[0].id)
    ```


    :param _builtins.str acl_action: The action that Cloud Firewall performs on the traffic. Valid values: `accept`, `drop`, `log`.
    :param _builtins.str acl_uuid: Access control over VPC firewalls strategy unique identifier.
    :param _builtins.str description: Access control over VPC firewalls description of the strategy information.
    :param _builtins.str destination: Access control over VPC firewalls strategy the destination address in.
    :param Sequence[_builtins.str] ids: A list of Vpc Firewall Control Policy IDs.
    :param _builtins.str lang: The language of the content within the request and response. Valid values: `zh`, `en`.
    :param _builtins.str member_uid: The UID of the member account of the current Alibaba cloud account.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str proto: Access control over VPC firewalls strategy access traffic of the protocol type.
    :param _builtins.bool release: The enabled status of the access control policy. The policy is enabled by default after it is created. Value:
           - **true**: Enable access control policies
           - **false**: does not enable access control policies.
    :param _builtins.str source: Access control over VPC firewalls strategy in the source address.
    :param _builtins.str vpc_firewall_id: The ID of the VPC firewall instance. Value:
           - When the VPC firewall protects traffic between two VPCs connected through the cloud enterprise network, the policy group ID uses the cloud enterprise network instance ID.
           - When the VPC firewall protects traffic between two VPCs connected through the express connection, the policy group ID uses the ID of the VPC firewall instance.
    """
    __args__ = dict()
    __args__['aclAction'] = acl_action
    __args__['aclUuid'] = acl_uuid
    __args__['description'] = description
    __args__['destination'] = destination
    __args__['ids'] = ids
    __args__['lang'] = lang
    __args__['memberUid'] = member_uid
    __args__['outputFile'] = output_file
    __args__['pageNumber'] = page_number
    __args__['pageSize'] = page_size
    __args__['proto'] = proto
    __args__['release'] = release
    __args__['source'] = source
    __args__['vpcFirewallId'] = vpc_firewall_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:cloudfirewall/getVpcFirewallControlPolicies:getVpcFirewallControlPolicies', __args__, opts=opts, typ=GetVpcFirewallControlPoliciesResult).value

    return AwaitableGetVpcFirewallControlPoliciesResult(
        acl_action=pulumi.get(__ret__, 'acl_action'),
        acl_uuid=pulumi.get(__ret__, 'acl_uuid'),
        description=pulumi.get(__ret__, 'description'),
        destination=pulumi.get(__ret__, 'destination'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        lang=pulumi.get(__ret__, 'lang'),
        member_uid=pulumi.get(__ret__, 'member_uid'),
        output_file=pulumi.get(__ret__, 'output_file'),
        page_number=pulumi.get(__ret__, 'page_number'),
        page_size=pulumi.get(__ret__, 'page_size'),
        policies=pulumi.get(__ret__, 'policies'),
        proto=pulumi.get(__ret__, 'proto'),
        release=pulumi.get(__ret__, 'release'),
        source=pulumi.get(__ret__, 'source'),
        vpc_firewall_id=pulumi.get(__ret__, 'vpc_firewall_id'))
def get_vpc_firewall_control_policies_output(acl_action: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                             acl_uuid: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                             description: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                             destination: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                             ids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                                             lang: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                             member_uid: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                             output_file: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                             page_number: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                                             page_size: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                                             proto: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                             release: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                                             source: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                             vpc_firewall_id: Optional[pulumi.Input[_builtins.str]] = None,
                                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetVpcFirewallControlPoliciesResult]:
    """
    This data source provides the Cloud Firewall Vpc Firewall Control Policies of the current Alibaba Cloud user.

    > **NOTE:** Available since v1.194.0.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    ids = alicloud.cloudfirewall.get_vpc_firewall_control_policies(vpc_firewall_id="example_value",
        ids=[
            "example_value-1",
            "example_value-2",
        ])
    pulumi.export("alicloudCloudFirewallVpcFirewallControlPoliciesId1", ids.policies[0].id)
    ```


    :param _builtins.str acl_action: The action that Cloud Firewall performs on the traffic. Valid values: `accept`, `drop`, `log`.
    :param _builtins.str acl_uuid: Access control over VPC firewalls strategy unique identifier.
    :param _builtins.str description: Access control over VPC firewalls description of the strategy information.
    :param _builtins.str destination: Access control over VPC firewalls strategy the destination address in.
    :param Sequence[_builtins.str] ids: A list of Vpc Firewall Control Policy IDs.
    :param _builtins.str lang: The language of the content within the request and response. Valid values: `zh`, `en`.
    :param _builtins.str member_uid: The UID of the member account of the current Alibaba cloud account.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str proto: Access control over VPC firewalls strategy access traffic of the protocol type.
    :param _builtins.bool release: The enabled status of the access control policy. The policy is enabled by default after it is created. Value:
           - **true**: Enable access control policies
           - **false**: does not enable access control policies.
    :param _builtins.str source: Access control over VPC firewalls strategy in the source address.
    :param _builtins.str vpc_firewall_id: The ID of the VPC firewall instance. Value:
           - When the VPC firewall protects traffic between two VPCs connected through the cloud enterprise network, the policy group ID uses the cloud enterprise network instance ID.
           - When the VPC firewall protects traffic between two VPCs connected through the express connection, the policy group ID uses the ID of the VPC firewall instance.
    """
    __args__ = dict()
    __args__['aclAction'] = acl_action
    __args__['aclUuid'] = acl_uuid
    __args__['description'] = description
    __args__['destination'] = destination
    __args__['ids'] = ids
    __args__['lang'] = lang
    __args__['memberUid'] = member_uid
    __args__['outputFile'] = output_file
    __args__['pageNumber'] = page_number
    __args__['pageSize'] = page_size
    __args__['proto'] = proto
    __args__['release'] = release
    __args__['source'] = source
    __args__['vpcFirewallId'] = vpc_firewall_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('alicloud:cloudfirewall/getVpcFirewallControlPolicies:getVpcFirewallControlPolicies', __args__, opts=opts, typ=GetVpcFirewallControlPoliciesResult)
    return __ret__.apply(lambda __response__: GetVpcFirewallControlPoliciesResult(
        acl_action=pulumi.get(__response__, 'acl_action'),
        acl_uuid=pulumi.get(__response__, 'acl_uuid'),
        description=pulumi.get(__response__, 'description'),
        destination=pulumi.get(__response__, 'destination'),
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids'),
        lang=pulumi.get(__response__, 'lang'),
        member_uid=pulumi.get(__response__, 'member_uid'),
        output_file=pulumi.get(__response__, 'output_file'),
        page_number=pulumi.get(__response__, 'page_number'),
        page_size=pulumi.get(__response__, 'page_size'),
        policies=pulumi.get(__response__, 'policies'),
        proto=pulumi.get(__response__, 'proto'),
        release=pulumi.get(__response__, 'release'),
        source=pulumi.get(__response__, 'source'),
        vpc_firewall_id=pulumi.get(__response__, 'vpc_firewall_id')))
