# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['AlarmContactArgs', 'AlarmContact']

@pulumi.input_type
class AlarmContactArgs:
    def __init__(__self__, *,
                 alarm_contact_name: pulumi.Input[_builtins.str],
                 describe: pulumi.Input[_builtins.str],
                 channels_aliim: Optional[pulumi.Input[_builtins.str]] = None,
                 channels_ding_web_hook: Optional[pulumi.Input[_builtins.str]] = None,
                 channels_mail: Optional[pulumi.Input[_builtins.str]] = None,
                 channels_sms: Optional[pulumi.Input[_builtins.str]] = None,
                 lang: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a AlarmContact resource.
        :param pulumi.Input[_builtins.str] alarm_contact_name: The name of the alarm contact. The length should between 2 and 40 characters.
        :param pulumi.Input[_builtins.str] describe: The description of the alarm contact.
        :param pulumi.Input[_builtins.str] channels_aliim: The TradeManager ID of the alarm contact.
        :param pulumi.Input[_builtins.str] channels_ding_web_hook: The webhook URL of the DingTalk chatbot.
        :param pulumi.Input[_builtins.str] channels_mail: The email address of the alarm contact. After you add or modify an email address, the recipient receives an email that contains an activation link. The system adds the recipient to the list of alarm contacts only after the recipient activates the email address.
        :param pulumi.Input[_builtins.str] channels_sms: The phone number of the alarm contact. After you add or modify an email address, the recipient receives an email that contains an activation link. The system adds the recipient to the list of alarm contacts only after the recipient activates the email address.
        :param pulumi.Input[_builtins.str] lang: The language type of the alarm. Valid values: `en`, `zh-cn`.
               
               > **NOTE:** Specify at least one of the following alarm notification targets: `channels_aliim`, `channels_ding_web_hook`, `channels_mail`, `channels_sms`.
        """
        pulumi.set(__self__, "alarm_contact_name", alarm_contact_name)
        pulumi.set(__self__, "describe", describe)
        if channels_aliim is not None:
            pulumi.set(__self__, "channels_aliim", channels_aliim)
        if channels_ding_web_hook is not None:
            pulumi.set(__self__, "channels_ding_web_hook", channels_ding_web_hook)
        if channels_mail is not None:
            pulumi.set(__self__, "channels_mail", channels_mail)
        if channels_sms is not None:
            pulumi.set(__self__, "channels_sms", channels_sms)
        if lang is not None:
            pulumi.set(__self__, "lang", lang)

    @_builtins.property
    @pulumi.getter(name="alarmContactName")
    def alarm_contact_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the alarm contact. The length should between 2 and 40 characters.
        """
        return pulumi.get(self, "alarm_contact_name")

    @alarm_contact_name.setter
    def alarm_contact_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "alarm_contact_name", value)

    @_builtins.property
    @pulumi.getter
    def describe(self) -> pulumi.Input[_builtins.str]:
        """
        The description of the alarm contact.
        """
        return pulumi.get(self, "describe")

    @describe.setter
    def describe(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "describe", value)

    @_builtins.property
    @pulumi.getter(name="channelsAliim")
    def channels_aliim(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The TradeManager ID of the alarm contact.
        """
        return pulumi.get(self, "channels_aliim")

    @channels_aliim.setter
    def channels_aliim(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "channels_aliim", value)

    @_builtins.property
    @pulumi.getter(name="channelsDingWebHook")
    def channels_ding_web_hook(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The webhook URL of the DingTalk chatbot.
        """
        return pulumi.get(self, "channels_ding_web_hook")

    @channels_ding_web_hook.setter
    def channels_ding_web_hook(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "channels_ding_web_hook", value)

    @_builtins.property
    @pulumi.getter(name="channelsMail")
    def channels_mail(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The email address of the alarm contact. After you add or modify an email address, the recipient receives an email that contains an activation link. The system adds the recipient to the list of alarm contacts only after the recipient activates the email address.
        """
        return pulumi.get(self, "channels_mail")

    @channels_mail.setter
    def channels_mail(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "channels_mail", value)

    @_builtins.property
    @pulumi.getter(name="channelsSms")
    def channels_sms(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The phone number of the alarm contact. After you add or modify an email address, the recipient receives an email that contains an activation link. The system adds the recipient to the list of alarm contacts only after the recipient activates the email address.
        """
        return pulumi.get(self, "channels_sms")

    @channels_sms.setter
    def channels_sms(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "channels_sms", value)

    @_builtins.property
    @pulumi.getter
    def lang(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The language type of the alarm. Valid values: `en`, `zh-cn`.

        > **NOTE:** Specify at least one of the following alarm notification targets: `channels_aliim`, `channels_ding_web_hook`, `channels_mail`, `channels_sms`.
        """
        return pulumi.get(self, "lang")

    @lang.setter
    def lang(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lang", value)


@pulumi.input_type
class _AlarmContactState:
    def __init__(__self__, *,
                 alarm_contact_name: Optional[pulumi.Input[_builtins.str]] = None,
                 channels_aliim: Optional[pulumi.Input[_builtins.str]] = None,
                 channels_ding_web_hook: Optional[pulumi.Input[_builtins.str]] = None,
                 channels_mail: Optional[pulumi.Input[_builtins.str]] = None,
                 channels_sms: Optional[pulumi.Input[_builtins.str]] = None,
                 describe: Optional[pulumi.Input[_builtins.str]] = None,
                 lang: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering AlarmContact resources.
        :param pulumi.Input[_builtins.str] alarm_contact_name: The name of the alarm contact. The length should between 2 and 40 characters.
        :param pulumi.Input[_builtins.str] channels_aliim: The TradeManager ID of the alarm contact.
        :param pulumi.Input[_builtins.str] channels_ding_web_hook: The webhook URL of the DingTalk chatbot.
        :param pulumi.Input[_builtins.str] channels_mail: The email address of the alarm contact. After you add or modify an email address, the recipient receives an email that contains an activation link. The system adds the recipient to the list of alarm contacts only after the recipient activates the email address.
        :param pulumi.Input[_builtins.str] channels_sms: The phone number of the alarm contact. After you add or modify an email address, the recipient receives an email that contains an activation link. The system adds the recipient to the list of alarm contacts only after the recipient activates the email address.
        :param pulumi.Input[_builtins.str] describe: The description of the alarm contact.
        :param pulumi.Input[_builtins.str] lang: The language type of the alarm. Valid values: `en`, `zh-cn`.
               
               > **NOTE:** Specify at least one of the following alarm notification targets: `channels_aliim`, `channels_ding_web_hook`, `channels_mail`, `channels_sms`.
        """
        if alarm_contact_name is not None:
            pulumi.set(__self__, "alarm_contact_name", alarm_contact_name)
        if channels_aliim is not None:
            pulumi.set(__self__, "channels_aliim", channels_aliim)
        if channels_ding_web_hook is not None:
            pulumi.set(__self__, "channels_ding_web_hook", channels_ding_web_hook)
        if channels_mail is not None:
            pulumi.set(__self__, "channels_mail", channels_mail)
        if channels_sms is not None:
            pulumi.set(__self__, "channels_sms", channels_sms)
        if describe is not None:
            pulumi.set(__self__, "describe", describe)
        if lang is not None:
            pulumi.set(__self__, "lang", lang)

    @_builtins.property
    @pulumi.getter(name="alarmContactName")
    def alarm_contact_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the alarm contact. The length should between 2 and 40 characters.
        """
        return pulumi.get(self, "alarm_contact_name")

    @alarm_contact_name.setter
    def alarm_contact_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "alarm_contact_name", value)

    @_builtins.property
    @pulumi.getter(name="channelsAliim")
    def channels_aliim(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The TradeManager ID of the alarm contact.
        """
        return pulumi.get(self, "channels_aliim")

    @channels_aliim.setter
    def channels_aliim(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "channels_aliim", value)

    @_builtins.property
    @pulumi.getter(name="channelsDingWebHook")
    def channels_ding_web_hook(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The webhook URL of the DingTalk chatbot.
        """
        return pulumi.get(self, "channels_ding_web_hook")

    @channels_ding_web_hook.setter
    def channels_ding_web_hook(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "channels_ding_web_hook", value)

    @_builtins.property
    @pulumi.getter(name="channelsMail")
    def channels_mail(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The email address of the alarm contact. After you add or modify an email address, the recipient receives an email that contains an activation link. The system adds the recipient to the list of alarm contacts only after the recipient activates the email address.
        """
        return pulumi.get(self, "channels_mail")

    @channels_mail.setter
    def channels_mail(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "channels_mail", value)

    @_builtins.property
    @pulumi.getter(name="channelsSms")
    def channels_sms(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The phone number of the alarm contact. After you add or modify an email address, the recipient receives an email that contains an activation link. The system adds the recipient to the list of alarm contacts only after the recipient activates the email address.
        """
        return pulumi.get(self, "channels_sms")

    @channels_sms.setter
    def channels_sms(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "channels_sms", value)

    @_builtins.property
    @pulumi.getter
    def describe(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the alarm contact.
        """
        return pulumi.get(self, "describe")

    @describe.setter
    def describe(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "describe", value)

    @_builtins.property
    @pulumi.getter
    def lang(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The language type of the alarm. Valid values: `en`, `zh-cn`.

        > **NOTE:** Specify at least one of the following alarm notification targets: `channels_aliim`, `channels_ding_web_hook`, `channels_mail`, `channels_sms`.
        """
        return pulumi.get(self, "lang")

    @lang.setter
    def lang(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lang", value)


@pulumi.type_token("alicloud:cms/alarmContact:AlarmContact")
class AlarmContact(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alarm_contact_name: Optional[pulumi.Input[_builtins.str]] = None,
                 channels_aliim: Optional[pulumi.Input[_builtins.str]] = None,
                 channels_ding_web_hook: Optional[pulumi.Input[_builtins.str]] = None,
                 channels_mail: Optional[pulumi.Input[_builtins.str]] = None,
                 channels_sms: Optional[pulumi.Input[_builtins.str]] = None,
                 describe: Optional[pulumi.Input[_builtins.str]] = None,
                 lang: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Creates or modifies an alarm contact. For information about alarm contact and how to use it, see [What is alarm contact](https://www.alibabacloud.com/help/en/cloudmonitor/latest/putcontact).

        > **NOTE:** Available since v1.99.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        # You need to activate the link before you can return to the alarm contact information, otherwise diff will appear in terraform. So please confirm the activation link as soon as possible. Besides, you can ignore the diff of the alarm contact information by `lifestyle`. 
        example = alicloud.cms.AlarmContact("example",
            alarm_contact_name="tf-example",
            describe="For example",
            channels_mail="terraform@test.com")
        ```

        ## Import

        Alarm contact can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:cms/alarmContact:AlarmContact example abc12345
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] alarm_contact_name: The name of the alarm contact. The length should between 2 and 40 characters.
        :param pulumi.Input[_builtins.str] channels_aliim: The TradeManager ID of the alarm contact.
        :param pulumi.Input[_builtins.str] channels_ding_web_hook: The webhook URL of the DingTalk chatbot.
        :param pulumi.Input[_builtins.str] channels_mail: The email address of the alarm contact. After you add or modify an email address, the recipient receives an email that contains an activation link. The system adds the recipient to the list of alarm contacts only after the recipient activates the email address.
        :param pulumi.Input[_builtins.str] channels_sms: The phone number of the alarm contact. After you add or modify an email address, the recipient receives an email that contains an activation link. The system adds the recipient to the list of alarm contacts only after the recipient activates the email address.
        :param pulumi.Input[_builtins.str] describe: The description of the alarm contact.
        :param pulumi.Input[_builtins.str] lang: The language type of the alarm. Valid values: `en`, `zh-cn`.
               
               > **NOTE:** Specify at least one of the following alarm notification targets: `channels_aliim`, `channels_ding_web_hook`, `channels_mail`, `channels_sms`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AlarmContactArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates or modifies an alarm contact. For information about alarm contact and how to use it, see [What is alarm contact](https://www.alibabacloud.com/help/en/cloudmonitor/latest/putcontact).

        > **NOTE:** Available since v1.99.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        # You need to activate the link before you can return to the alarm contact information, otherwise diff will appear in terraform. So please confirm the activation link as soon as possible. Besides, you can ignore the diff of the alarm contact information by `lifestyle`. 
        example = alicloud.cms.AlarmContact("example",
            alarm_contact_name="tf-example",
            describe="For example",
            channels_mail="terraform@test.com")
        ```

        ## Import

        Alarm contact can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:cms/alarmContact:AlarmContact example abc12345
        ```

        :param str resource_name: The name of the resource.
        :param AlarmContactArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AlarmContactArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alarm_contact_name: Optional[pulumi.Input[_builtins.str]] = None,
                 channels_aliim: Optional[pulumi.Input[_builtins.str]] = None,
                 channels_ding_web_hook: Optional[pulumi.Input[_builtins.str]] = None,
                 channels_mail: Optional[pulumi.Input[_builtins.str]] = None,
                 channels_sms: Optional[pulumi.Input[_builtins.str]] = None,
                 describe: Optional[pulumi.Input[_builtins.str]] = None,
                 lang: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AlarmContactArgs.__new__(AlarmContactArgs)

            if alarm_contact_name is None and not opts.urn:
                raise TypeError("Missing required property 'alarm_contact_name'")
            __props__.__dict__["alarm_contact_name"] = alarm_contact_name
            __props__.__dict__["channels_aliim"] = channels_aliim
            __props__.__dict__["channels_ding_web_hook"] = channels_ding_web_hook
            __props__.__dict__["channels_mail"] = channels_mail
            __props__.__dict__["channels_sms"] = channels_sms
            if describe is None and not opts.urn:
                raise TypeError("Missing required property 'describe'")
            __props__.__dict__["describe"] = describe
            __props__.__dict__["lang"] = lang
        super(AlarmContact, __self__).__init__(
            'alicloud:cms/alarmContact:AlarmContact',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            alarm_contact_name: Optional[pulumi.Input[_builtins.str]] = None,
            channels_aliim: Optional[pulumi.Input[_builtins.str]] = None,
            channels_ding_web_hook: Optional[pulumi.Input[_builtins.str]] = None,
            channels_mail: Optional[pulumi.Input[_builtins.str]] = None,
            channels_sms: Optional[pulumi.Input[_builtins.str]] = None,
            describe: Optional[pulumi.Input[_builtins.str]] = None,
            lang: Optional[pulumi.Input[_builtins.str]] = None) -> 'AlarmContact':
        """
        Get an existing AlarmContact resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] alarm_contact_name: The name of the alarm contact. The length should between 2 and 40 characters.
        :param pulumi.Input[_builtins.str] channels_aliim: The TradeManager ID of the alarm contact.
        :param pulumi.Input[_builtins.str] channels_ding_web_hook: The webhook URL of the DingTalk chatbot.
        :param pulumi.Input[_builtins.str] channels_mail: The email address of the alarm contact. After you add or modify an email address, the recipient receives an email that contains an activation link. The system adds the recipient to the list of alarm contacts only after the recipient activates the email address.
        :param pulumi.Input[_builtins.str] channels_sms: The phone number of the alarm contact. After you add or modify an email address, the recipient receives an email that contains an activation link. The system adds the recipient to the list of alarm contacts only after the recipient activates the email address.
        :param pulumi.Input[_builtins.str] describe: The description of the alarm contact.
        :param pulumi.Input[_builtins.str] lang: The language type of the alarm. Valid values: `en`, `zh-cn`.
               
               > **NOTE:** Specify at least one of the following alarm notification targets: `channels_aliim`, `channels_ding_web_hook`, `channels_mail`, `channels_sms`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AlarmContactState.__new__(_AlarmContactState)

        __props__.__dict__["alarm_contact_name"] = alarm_contact_name
        __props__.__dict__["channels_aliim"] = channels_aliim
        __props__.__dict__["channels_ding_web_hook"] = channels_ding_web_hook
        __props__.__dict__["channels_mail"] = channels_mail
        __props__.__dict__["channels_sms"] = channels_sms
        __props__.__dict__["describe"] = describe
        __props__.__dict__["lang"] = lang
        return AlarmContact(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="alarmContactName")
    def alarm_contact_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the alarm contact. The length should between 2 and 40 characters.
        """
        return pulumi.get(self, "alarm_contact_name")

    @_builtins.property
    @pulumi.getter(name="channelsAliim")
    def channels_aliim(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The TradeManager ID of the alarm contact.
        """
        return pulumi.get(self, "channels_aliim")

    @_builtins.property
    @pulumi.getter(name="channelsDingWebHook")
    def channels_ding_web_hook(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The webhook URL of the DingTalk chatbot.
        """
        return pulumi.get(self, "channels_ding_web_hook")

    @_builtins.property
    @pulumi.getter(name="channelsMail")
    def channels_mail(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The email address of the alarm contact. After you add or modify an email address, the recipient receives an email that contains an activation link. The system adds the recipient to the list of alarm contacts only after the recipient activates the email address.
        """
        return pulumi.get(self, "channels_mail")

    @_builtins.property
    @pulumi.getter(name="channelsSms")
    def channels_sms(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The phone number of the alarm contact. After you add or modify an email address, the recipient receives an email that contains an activation link. The system adds the recipient to the list of alarm contacts only after the recipient activates the email address.
        """
        return pulumi.get(self, "channels_sms")

    @_builtins.property
    @pulumi.getter
    def describe(self) -> pulumi.Output[_builtins.str]:
        """
        The description of the alarm contact.
        """
        return pulumi.get(self, "describe")

    @_builtins.property
    @pulumi.getter
    def lang(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The language type of the alarm. Valid values: `en`, `zh-cn`.

        > **NOTE:** Specify at least one of the following alarm notification targets: `channels_aliim`, `channels_ding_web_hook`, `channels_mail`, `channels_sms`.
        """
        return pulumi.get(self, "lang")

