# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['NamespaceArgs', 'Namespace']

@pulumi.input_type
class NamespaceArgs:
    def __init__(__self__, *,
                 auto_create: pulumi.Input[_builtins.bool],
                 default_visibility: pulumi.Input[_builtins.str],
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Namespace resource.
        :param pulumi.Input[_builtins.bool] auto_create: Boolean, when it set to true, repositories are automatically created when pushing new images. If it set to false, you create repository for images before pushing.
        :param pulumi.Input[_builtins.str] default_visibility: `PUBLIC` or `PRIVATE`, default repository visibility in this namespace.
        :param pulumi.Input[_builtins.str] name: Name of Container Registry namespace.
        """
        pulumi.set(__self__, "auto_create", auto_create)
        pulumi.set(__self__, "default_visibility", default_visibility)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="autoCreate")
    def auto_create(self) -> pulumi.Input[_builtins.bool]:
        """
        Boolean, when it set to true, repositories are automatically created when pushing new images. If it set to false, you create repository for images before pushing.
        """
        return pulumi.get(self, "auto_create")

    @auto_create.setter
    def auto_create(self, value: pulumi.Input[_builtins.bool]):
        pulumi.set(self, "auto_create", value)

    @_builtins.property
    @pulumi.getter(name="defaultVisibility")
    def default_visibility(self) -> pulumi.Input[_builtins.str]:
        """
        `PUBLIC` or `PRIVATE`, default repository visibility in this namespace.
        """
        return pulumi.get(self, "default_visibility")

    @default_visibility.setter
    def default_visibility(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "default_visibility", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of Container Registry namespace.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _NamespaceState:
    def __init__(__self__, *,
                 auto_create: Optional[pulumi.Input[_builtins.bool]] = None,
                 default_visibility: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Namespace resources.
        :param pulumi.Input[_builtins.bool] auto_create: Boolean, when it set to true, repositories are automatically created when pushing new images. If it set to false, you create repository for images before pushing.
        :param pulumi.Input[_builtins.str] default_visibility: `PUBLIC` or `PRIVATE`, default repository visibility in this namespace.
        :param pulumi.Input[_builtins.str] name: Name of Container Registry namespace.
        """
        if auto_create is not None:
            pulumi.set(__self__, "auto_create", auto_create)
        if default_visibility is not None:
            pulumi.set(__self__, "default_visibility", default_visibility)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="autoCreate")
    def auto_create(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean, when it set to true, repositories are automatically created when pushing new images. If it set to false, you create repository for images before pushing.
        """
        return pulumi.get(self, "auto_create")

    @auto_create.setter
    def auto_create(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_create", value)

    @_builtins.property
    @pulumi.getter(name="defaultVisibility")
    def default_visibility(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        `PUBLIC` or `PRIVATE`, default repository visibility in this namespace.
        """
        return pulumi.get(self, "default_visibility")

    @default_visibility.setter
    def default_visibility(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_visibility", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of Container Registry namespace.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.type_token("alicloud:cr/namespace:Namespace")
class Namespace(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_create: Optional[pulumi.Input[_builtins.bool]] = None,
                 default_visibility: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        This resource will help you to manager Container Registry namespaces, see [What is Namespace](https://www.alibabacloud.com/help/en/acr/developer-reference/api-cr-2018-12-01-createnamespace).

        > **NOTE:** Available since v1.34.0.

        > **NOTE:** You need to set your registry password in Container Registry console before use this resource.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = random.index.Integer("default",
            min=10000000,
            max=99999999)
        example = alicloud.cr.Namespace("example",
            name=f"{name}-{default['result']}",
            auto_create=False,
            default_visibility="PUBLIC")
        ```

        ## Import

        Container Registry namespace can be imported using the namespace, e.g.

        ```sh
        $ pulumi import alicloud:cr/namespace:Namespace default my-namespace
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] auto_create: Boolean, when it set to true, repositories are automatically created when pushing new images. If it set to false, you create repository for images before pushing.
        :param pulumi.Input[_builtins.str] default_visibility: `PUBLIC` or `PRIVATE`, default repository visibility in this namespace.
        :param pulumi.Input[_builtins.str] name: Name of Container Registry namespace.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NamespaceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource will help you to manager Container Registry namespaces, see [What is Namespace](https://www.alibabacloud.com/help/en/acr/developer-reference/api-cr-2018-12-01-createnamespace).

        > **NOTE:** Available since v1.34.0.

        > **NOTE:** You need to set your registry password in Container Registry console before use this resource.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = random.index.Integer("default",
            min=10000000,
            max=99999999)
        example = alicloud.cr.Namespace("example",
            name=f"{name}-{default['result']}",
            auto_create=False,
            default_visibility="PUBLIC")
        ```

        ## Import

        Container Registry namespace can be imported using the namespace, e.g.

        ```sh
        $ pulumi import alicloud:cr/namespace:Namespace default my-namespace
        ```

        :param str resource_name: The name of the resource.
        :param NamespaceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NamespaceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_create: Optional[pulumi.Input[_builtins.bool]] = None,
                 default_visibility: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NamespaceArgs.__new__(NamespaceArgs)

            if auto_create is None and not opts.urn:
                raise TypeError("Missing required property 'auto_create'")
            __props__.__dict__["auto_create"] = auto_create
            if default_visibility is None and not opts.urn:
                raise TypeError("Missing required property 'default_visibility'")
            __props__.__dict__["default_visibility"] = default_visibility
            __props__.__dict__["name"] = name
        super(Namespace, __self__).__init__(
            'alicloud:cr/namespace:Namespace',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auto_create: Optional[pulumi.Input[_builtins.bool]] = None,
            default_visibility: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None) -> 'Namespace':
        """
        Get an existing Namespace resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] auto_create: Boolean, when it set to true, repositories are automatically created when pushing new images. If it set to false, you create repository for images before pushing.
        :param pulumi.Input[_builtins.str] default_visibility: `PUBLIC` or `PRIVATE`, default repository visibility in this namespace.
        :param pulumi.Input[_builtins.str] name: Name of Container Registry namespace.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NamespaceState.__new__(_NamespaceState)

        __props__.__dict__["auto_create"] = auto_create
        __props__.__dict__["default_visibility"] = default_visibility
        __props__.__dict__["name"] = name
        return Namespace(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="autoCreate")
    def auto_create(self) -> pulumi.Output[_builtins.bool]:
        """
        Boolean, when it set to true, repositories are automatically created when pushing new images. If it set to false, you create repository for images before pushing.
        """
        return pulumi.get(self, "auto_create")

    @_builtins.property
    @pulumi.getter(name="defaultVisibility")
    def default_visibility(self) -> pulumi.Output[_builtins.str]:
        """
        `PUBLIC` or `PRIVATE`, default repository visibility in this namespace.
        """
        return pulumi.get(self, "default_visibility")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of Container Registry namespace.
        """
        return pulumi.get(self, "name")

