# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['KubernetesAutoscalerArgs', 'KubernetesAutoscaler']

@pulumi.input_type
class KubernetesAutoscalerArgs:
    def __init__(__self__, *,
                 cluster_id: pulumi.Input[_builtins.str],
                 cool_down_duration: pulumi.Input[_builtins.str],
                 defer_scale_in_duration: pulumi.Input[_builtins.str],
                 utilization: pulumi.Input[_builtins.str],
                 nodepools: Optional[pulumi.Input[Sequence[pulumi.Input['KubernetesAutoscalerNodepoolArgs']]]] = None,
                 use_ecs_ram_role_token: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a KubernetesAutoscaler resource.
        :param pulumi.Input[_builtins.str] cluster_id: The id of kubernetes cluster.
        :param pulumi.Input[_builtins.str] cool_down_duration: The cool_down_duration option of cluster-autoscaler.
        :param pulumi.Input[_builtins.str] defer_scale_in_duration: The defer_scale_in_duration option of cluster-autoscaler.
        :param pulumi.Input[_builtins.str] utilization: The utilization option of cluster-autoscaler.
        :param pulumi.Input[Sequence[pulumi.Input['KubernetesAutoscalerNodepoolArgs']]] nodepools: The list of the node pools. See `nodepools` below.
        :param pulumi.Input[_builtins.bool] use_ecs_ram_role_token: Enable autoscaler access to alibabacloud service by ecs ramrole token. default: false
        """
        pulumi.set(__self__, "cluster_id", cluster_id)
        pulumi.set(__self__, "cool_down_duration", cool_down_duration)
        pulumi.set(__self__, "defer_scale_in_duration", defer_scale_in_duration)
        pulumi.set(__self__, "utilization", utilization)
        if nodepools is not None:
            pulumi.set(__self__, "nodepools", nodepools)
        if use_ecs_ram_role_token is not None:
            pulumi.set(__self__, "use_ecs_ram_role_token", use_ecs_ram_role_token)

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Input[_builtins.str]:
        """
        The id of kubernetes cluster.
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "cluster_id", value)

    @_builtins.property
    @pulumi.getter(name="coolDownDuration")
    def cool_down_duration(self) -> pulumi.Input[_builtins.str]:
        """
        The cool_down_duration option of cluster-autoscaler.
        """
        return pulumi.get(self, "cool_down_duration")

    @cool_down_duration.setter
    def cool_down_duration(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "cool_down_duration", value)

    @_builtins.property
    @pulumi.getter(name="deferScaleInDuration")
    def defer_scale_in_duration(self) -> pulumi.Input[_builtins.str]:
        """
        The defer_scale_in_duration option of cluster-autoscaler.
        """
        return pulumi.get(self, "defer_scale_in_duration")

    @defer_scale_in_duration.setter
    def defer_scale_in_duration(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "defer_scale_in_duration", value)

    @_builtins.property
    @pulumi.getter
    def utilization(self) -> pulumi.Input[_builtins.str]:
        """
        The utilization option of cluster-autoscaler.
        """
        return pulumi.get(self, "utilization")

    @utilization.setter
    def utilization(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "utilization", value)

    @_builtins.property
    @pulumi.getter
    def nodepools(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['KubernetesAutoscalerNodepoolArgs']]]]:
        """
        The list of the node pools. See `nodepools` below.
        """
        return pulumi.get(self, "nodepools")

    @nodepools.setter
    def nodepools(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['KubernetesAutoscalerNodepoolArgs']]]]):
        pulumi.set(self, "nodepools", value)

    @_builtins.property
    @pulumi.getter(name="useEcsRamRoleToken")
    def use_ecs_ram_role_token(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable autoscaler access to alibabacloud service by ecs ramrole token. default: false
        """
        return pulumi.get(self, "use_ecs_ram_role_token")

    @use_ecs_ram_role_token.setter
    def use_ecs_ram_role_token(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "use_ecs_ram_role_token", value)


@pulumi.input_type
class _KubernetesAutoscalerState:
    def __init__(__self__, *,
                 cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cool_down_duration: Optional[pulumi.Input[_builtins.str]] = None,
                 defer_scale_in_duration: Optional[pulumi.Input[_builtins.str]] = None,
                 nodepools: Optional[pulumi.Input[Sequence[pulumi.Input['KubernetesAutoscalerNodepoolArgs']]]] = None,
                 use_ecs_ram_role_token: Optional[pulumi.Input[_builtins.bool]] = None,
                 utilization: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering KubernetesAutoscaler resources.
        :param pulumi.Input[_builtins.str] cluster_id: The id of kubernetes cluster.
        :param pulumi.Input[_builtins.str] cool_down_duration: The cool_down_duration option of cluster-autoscaler.
        :param pulumi.Input[_builtins.str] defer_scale_in_duration: The defer_scale_in_duration option of cluster-autoscaler.
        :param pulumi.Input[Sequence[pulumi.Input['KubernetesAutoscalerNodepoolArgs']]] nodepools: The list of the node pools. See `nodepools` below.
        :param pulumi.Input[_builtins.bool] use_ecs_ram_role_token: Enable autoscaler access to alibabacloud service by ecs ramrole token. default: false
        :param pulumi.Input[_builtins.str] utilization: The utilization option of cluster-autoscaler.
        """
        if cluster_id is not None:
            pulumi.set(__self__, "cluster_id", cluster_id)
        if cool_down_duration is not None:
            pulumi.set(__self__, "cool_down_duration", cool_down_duration)
        if defer_scale_in_duration is not None:
            pulumi.set(__self__, "defer_scale_in_duration", defer_scale_in_duration)
        if nodepools is not None:
            pulumi.set(__self__, "nodepools", nodepools)
        if use_ecs_ram_role_token is not None:
            pulumi.set(__self__, "use_ecs_ram_role_token", use_ecs_ram_role_token)
        if utilization is not None:
            pulumi.set(__self__, "utilization", utilization)

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The id of kubernetes cluster.
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_id", value)

    @_builtins.property
    @pulumi.getter(name="coolDownDuration")
    def cool_down_duration(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The cool_down_duration option of cluster-autoscaler.
        """
        return pulumi.get(self, "cool_down_duration")

    @cool_down_duration.setter
    def cool_down_duration(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cool_down_duration", value)

    @_builtins.property
    @pulumi.getter(name="deferScaleInDuration")
    def defer_scale_in_duration(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The defer_scale_in_duration option of cluster-autoscaler.
        """
        return pulumi.get(self, "defer_scale_in_duration")

    @defer_scale_in_duration.setter
    def defer_scale_in_duration(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "defer_scale_in_duration", value)

    @_builtins.property
    @pulumi.getter
    def nodepools(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['KubernetesAutoscalerNodepoolArgs']]]]:
        """
        The list of the node pools. See `nodepools` below.
        """
        return pulumi.get(self, "nodepools")

    @nodepools.setter
    def nodepools(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['KubernetesAutoscalerNodepoolArgs']]]]):
        pulumi.set(self, "nodepools", value)

    @_builtins.property
    @pulumi.getter(name="useEcsRamRoleToken")
    def use_ecs_ram_role_token(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable autoscaler access to alibabacloud service by ecs ramrole token. default: false
        """
        return pulumi.get(self, "use_ecs_ram_role_token")

    @use_ecs_ram_role_token.setter
    def use_ecs_ram_role_token(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "use_ecs_ram_role_token", value)

    @_builtins.property
    @pulumi.getter
    def utilization(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The utilization option of cluster-autoscaler.
        """
        return pulumi.get(self, "utilization")

    @utilization.setter
    def utilization(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "utilization", value)


@pulumi.type_token("alicloud:cs/kubernetesAutoscaler:KubernetesAutoscaler")
class KubernetesAutoscaler(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cool_down_duration: Optional[pulumi.Input[_builtins.str]] = None,
                 defer_scale_in_duration: Optional[pulumi.Input[_builtins.str]] = None,
                 nodepools: Optional[pulumi.Input[Sequence[pulumi.Input[Union['KubernetesAutoscalerNodepoolArgs', 'KubernetesAutoscalerNodepoolArgsDict']]]]] = None,
                 use_ecs_ram_role_token: Optional[pulumi.Input[_builtins.bool]] = None,
                 utilization: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Create a KubernetesAutoscaler resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cluster_id: The id of kubernetes cluster.
        :param pulumi.Input[_builtins.str] cool_down_duration: The cool_down_duration option of cluster-autoscaler.
        :param pulumi.Input[_builtins.str] defer_scale_in_duration: The defer_scale_in_duration option of cluster-autoscaler.
        :param pulumi.Input[Sequence[pulumi.Input[Union['KubernetesAutoscalerNodepoolArgs', 'KubernetesAutoscalerNodepoolArgsDict']]]] nodepools: The list of the node pools. See `nodepools` below.
        :param pulumi.Input[_builtins.bool] use_ecs_ram_role_token: Enable autoscaler access to alibabacloud service by ecs ramrole token. default: false
        :param pulumi.Input[_builtins.str] utilization: The utilization option of cluster-autoscaler.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: KubernetesAutoscalerArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a KubernetesAutoscaler resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param KubernetesAutoscalerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(KubernetesAutoscalerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cool_down_duration: Optional[pulumi.Input[_builtins.str]] = None,
                 defer_scale_in_duration: Optional[pulumi.Input[_builtins.str]] = None,
                 nodepools: Optional[pulumi.Input[Sequence[pulumi.Input[Union['KubernetesAutoscalerNodepoolArgs', 'KubernetesAutoscalerNodepoolArgsDict']]]]] = None,
                 use_ecs_ram_role_token: Optional[pulumi.Input[_builtins.bool]] = None,
                 utilization: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = KubernetesAutoscalerArgs.__new__(KubernetesAutoscalerArgs)

            if cluster_id is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_id'")
            __props__.__dict__["cluster_id"] = cluster_id
            if cool_down_duration is None and not opts.urn:
                raise TypeError("Missing required property 'cool_down_duration'")
            __props__.__dict__["cool_down_duration"] = cool_down_duration
            if defer_scale_in_duration is None and not opts.urn:
                raise TypeError("Missing required property 'defer_scale_in_duration'")
            __props__.__dict__["defer_scale_in_duration"] = defer_scale_in_duration
            __props__.__dict__["nodepools"] = nodepools
            __props__.__dict__["use_ecs_ram_role_token"] = use_ecs_ram_role_token
            if utilization is None and not opts.urn:
                raise TypeError("Missing required property 'utilization'")
            __props__.__dict__["utilization"] = utilization
        super(KubernetesAutoscaler, __self__).__init__(
            'alicloud:cs/kubernetesAutoscaler:KubernetesAutoscaler',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
            cool_down_duration: Optional[pulumi.Input[_builtins.str]] = None,
            defer_scale_in_duration: Optional[pulumi.Input[_builtins.str]] = None,
            nodepools: Optional[pulumi.Input[Sequence[pulumi.Input[Union['KubernetesAutoscalerNodepoolArgs', 'KubernetesAutoscalerNodepoolArgsDict']]]]] = None,
            use_ecs_ram_role_token: Optional[pulumi.Input[_builtins.bool]] = None,
            utilization: Optional[pulumi.Input[_builtins.str]] = None) -> 'KubernetesAutoscaler':
        """
        Get an existing KubernetesAutoscaler resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cluster_id: The id of kubernetes cluster.
        :param pulumi.Input[_builtins.str] cool_down_duration: The cool_down_duration option of cluster-autoscaler.
        :param pulumi.Input[_builtins.str] defer_scale_in_duration: The defer_scale_in_duration option of cluster-autoscaler.
        :param pulumi.Input[Sequence[pulumi.Input[Union['KubernetesAutoscalerNodepoolArgs', 'KubernetesAutoscalerNodepoolArgsDict']]]] nodepools: The list of the node pools. See `nodepools` below.
        :param pulumi.Input[_builtins.bool] use_ecs_ram_role_token: Enable autoscaler access to alibabacloud service by ecs ramrole token. default: false
        :param pulumi.Input[_builtins.str] utilization: The utilization option of cluster-autoscaler.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _KubernetesAutoscalerState.__new__(_KubernetesAutoscalerState)

        __props__.__dict__["cluster_id"] = cluster_id
        __props__.__dict__["cool_down_duration"] = cool_down_duration
        __props__.__dict__["defer_scale_in_duration"] = defer_scale_in_duration
        __props__.__dict__["nodepools"] = nodepools
        __props__.__dict__["use_ecs_ram_role_token"] = use_ecs_ram_role_token
        __props__.__dict__["utilization"] = utilization
        return KubernetesAutoscaler(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Output[_builtins.str]:
        """
        The id of kubernetes cluster.
        """
        return pulumi.get(self, "cluster_id")

    @_builtins.property
    @pulumi.getter(name="coolDownDuration")
    def cool_down_duration(self) -> pulumi.Output[_builtins.str]:
        """
        The cool_down_duration option of cluster-autoscaler.
        """
        return pulumi.get(self, "cool_down_duration")

    @_builtins.property
    @pulumi.getter(name="deferScaleInDuration")
    def defer_scale_in_duration(self) -> pulumi.Output[_builtins.str]:
        """
        The defer_scale_in_duration option of cluster-autoscaler.
        """
        return pulumi.get(self, "defer_scale_in_duration")

    @_builtins.property
    @pulumi.getter
    def nodepools(self) -> pulumi.Output[Optional[Sequence['outputs.KubernetesAutoscalerNodepool']]]:
        """
        The list of the node pools. See `nodepools` below.
        """
        return pulumi.get(self, "nodepools")

    @_builtins.property
    @pulumi.getter(name="useEcsRamRoleToken")
    def use_ecs_ram_role_token(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Enable autoscaler access to alibabacloud service by ecs ramrole token. default: false
        """
        return pulumi.get(self, "use_ecs_ram_role_token")

    @_builtins.property
    @pulumi.getter
    def utilization(self) -> pulumi.Output[_builtins.str]:
        """
        The utilization option of cluster-autoscaler.
        """
        return pulumi.get(self, "utilization")

