# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['GatewayArgs', 'Gateway']

@pulumi.input_type
class GatewayArgs:
    def __init__(__self__, *,
                 gateway_name: pulumi.Input[_builtins.str],
                 gateway_desc: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Gateway resource.
        :param pulumi.Input[_builtins.str] gateway_name: The name of the Gateway.
        :param pulumi.Input[_builtins.str] gateway_desc: The description of Gateway.
        """
        pulumi.set(__self__, "gateway_name", gateway_name)
        if gateway_desc is not None:
            pulumi.set(__self__, "gateway_desc", gateway_desc)

    @_builtins.property
    @pulumi.getter(name="gatewayName")
    def gateway_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the Gateway.
        """
        return pulumi.get(self, "gateway_name")

    @gateway_name.setter
    def gateway_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "gateway_name", value)

    @_builtins.property
    @pulumi.getter(name="gatewayDesc")
    def gateway_desc(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of Gateway.
        """
        return pulumi.get(self, "gateway_desc")

    @gateway_desc.setter
    def gateway_desc(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "gateway_desc", value)


@pulumi.input_type
class _GatewayState:
    def __init__(__self__, *,
                 gateway_desc: Optional[pulumi.Input[_builtins.str]] = None,
                 gateway_name: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Gateway resources.
        :param pulumi.Input[_builtins.str] gateway_desc: The description of Gateway.
        :param pulumi.Input[_builtins.str] gateway_name: The name of the Gateway.
        :param pulumi.Input[_builtins.str] status: The status of gateway. Valid values: `EXCEPTION`, `NEW`, `RUNNING`, `STOPPED`.
        """
        if gateway_desc is not None:
            pulumi.set(__self__, "gateway_desc", gateway_desc)
        if gateway_name is not None:
            pulumi.set(__self__, "gateway_name", gateway_name)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="gatewayDesc")
    def gateway_desc(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of Gateway.
        """
        return pulumi.get(self, "gateway_desc")

    @gateway_desc.setter
    def gateway_desc(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "gateway_desc", value)

    @_builtins.property
    @pulumi.getter(name="gatewayName")
    def gateway_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Gateway.
        """
        return pulumi.get(self, "gateway_name")

    @gateway_name.setter
    def gateway_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "gateway_name", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of gateway. Valid values: `EXCEPTION`, `NEW`, `RUNNING`, `STOPPED`.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)


@pulumi.type_token("alicloud:databasegateway/gateway:Gateway")
class Gateway(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 gateway_desc: Optional[pulumi.Input[_builtins.str]] = None,
                 gateway_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Database Gateway Gateway resource.

        For information about Database Gateway Gateway and how to use it, see [What is Gateway](https://www.alibabacloud.com/help/doc-detail/123415.htm).

        > **NOTE:** Available in v1.135.0+.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        example = alicloud.databasegateway.Gateway("example", gateway_name="example_value")
        ```

        ## Import

        Database Gateway Gateway can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:databasegateway/gateway:Gateway example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] gateway_desc: The description of Gateway.
        :param pulumi.Input[_builtins.str] gateway_name: The name of the Gateway.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: GatewayArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Database Gateway Gateway resource.

        For information about Database Gateway Gateway and how to use it, see [What is Gateway](https://www.alibabacloud.com/help/doc-detail/123415.htm).

        > **NOTE:** Available in v1.135.0+.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        example = alicloud.databasegateway.Gateway("example", gateway_name="example_value")
        ```

        ## Import

        Database Gateway Gateway can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:databasegateway/gateway:Gateway example <id>
        ```

        :param str resource_name: The name of the resource.
        :param GatewayArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GatewayArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 gateway_desc: Optional[pulumi.Input[_builtins.str]] = None,
                 gateway_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GatewayArgs.__new__(GatewayArgs)

            __props__.__dict__["gateway_desc"] = gateway_desc
            if gateway_name is None and not opts.urn:
                raise TypeError("Missing required property 'gateway_name'")
            __props__.__dict__["gateway_name"] = gateway_name
            __props__.__dict__["status"] = None
        super(Gateway, __self__).__init__(
            'alicloud:databasegateway/gateway:Gateway',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            gateway_desc: Optional[pulumi.Input[_builtins.str]] = None,
            gateway_name: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None) -> 'Gateway':
        """
        Get an existing Gateway resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] gateway_desc: The description of Gateway.
        :param pulumi.Input[_builtins.str] gateway_name: The name of the Gateway.
        :param pulumi.Input[_builtins.str] status: The status of gateway. Valid values: `EXCEPTION`, `NEW`, `RUNNING`, `STOPPED`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _GatewayState.__new__(_GatewayState)

        __props__.__dict__["gateway_desc"] = gateway_desc
        __props__.__dict__["gateway_name"] = gateway_name
        __props__.__dict__["status"] = status
        return Gateway(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="gatewayDesc")
    def gateway_desc(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of Gateway.
        """
        return pulumi.get(self, "gateway_desc")

    @_builtins.property
    @pulumi.getter(name="gatewayName")
    def gateway_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Gateway.
        """
        return pulumi.get(self, "gateway_name")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of gateway. Valid values: `EXCEPTION`, `NEW`, `RUNNING`, `STOPPED`.
        """
        return pulumi.get(self, "status")

