# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DiAlarmRuleArgs', 'DiAlarmRule']

@pulumi.input_type
class DiAlarmRuleArgs:
    def __init__(__self__, *,
                 di_alarm_rule_name: pulumi.Input[_builtins.str],
                 di_job_id: pulumi.Input[_builtins.int],
                 metric_type: pulumi.Input[_builtins.str],
                 notification_settings: pulumi.Input['DiAlarmRuleNotificationSettingsArgs'],
                 trigger_conditions: pulumi.Input[Sequence[pulumi.Input['DiAlarmRuleTriggerConditionArgs']]],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a DiAlarmRule resource.
        :param pulumi.Input[_builtins.str] di_alarm_rule_name: Data Integration alarm rule name
        :param pulumi.Input[_builtins.int] di_job_id: Task ID: the ID of the task associated with the alert rule.
        :param pulumi.Input[_builtins.str] metric_type: Alarm indicator type. Optional enumerated values:
               - Heartbeat (task status alarm)
               - FailoverCount(failover times alarm)
               - Delay (task Delay alarm)
        :param pulumi.Input['DiAlarmRuleNotificationSettingsArgs'] notification_settings: Alarm notification settings See `notification_settings` below.
        :param pulumi.Input[Sequence[pulumi.Input['DiAlarmRuleTriggerConditionArgs']]] trigger_conditions: Alarm trigger condition list, supporting multiple conditions See `trigger_conditions` below.
        """
        pulumi.set(__self__, "di_alarm_rule_name", di_alarm_rule_name)
        pulumi.set(__self__, "di_job_id", di_job_id)
        pulumi.set(__self__, "metric_type", metric_type)
        pulumi.set(__self__, "notification_settings", notification_settings)
        pulumi.set(__self__, "trigger_conditions", trigger_conditions)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @_builtins.property
    @pulumi.getter(name="diAlarmRuleName")
    def di_alarm_rule_name(self) -> pulumi.Input[_builtins.str]:
        """
        Data Integration alarm rule name
        """
        return pulumi.get(self, "di_alarm_rule_name")

    @di_alarm_rule_name.setter
    def di_alarm_rule_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "di_alarm_rule_name", value)

    @_builtins.property
    @pulumi.getter(name="diJobId")
    def di_job_id(self) -> pulumi.Input[_builtins.int]:
        """
        Task ID: the ID of the task associated with the alert rule.
        """
        return pulumi.get(self, "di_job_id")

    @di_job_id.setter
    def di_job_id(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "di_job_id", value)

    @_builtins.property
    @pulumi.getter(name="metricType")
    def metric_type(self) -> pulumi.Input[_builtins.str]:
        """
        Alarm indicator type. Optional enumerated values:
        - Heartbeat (task status alarm)
        - FailoverCount(failover times alarm)
        - Delay (task Delay alarm)
        """
        return pulumi.get(self, "metric_type")

    @metric_type.setter
    def metric_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "metric_type", value)

    @_builtins.property
    @pulumi.getter(name="notificationSettings")
    def notification_settings(self) -> pulumi.Input['DiAlarmRuleNotificationSettingsArgs']:
        """
        Alarm notification settings See `notification_settings` below.
        """
        return pulumi.get(self, "notification_settings")

    @notification_settings.setter
    def notification_settings(self, value: pulumi.Input['DiAlarmRuleNotificationSettingsArgs']):
        pulumi.set(self, "notification_settings", value)

    @_builtins.property
    @pulumi.getter(name="triggerConditions")
    def trigger_conditions(self) -> pulumi.Input[Sequence[pulumi.Input['DiAlarmRuleTriggerConditionArgs']]]:
        """
        Alarm trigger condition list, supporting multiple conditions See `trigger_conditions` below.
        """
        return pulumi.get(self, "trigger_conditions")

    @trigger_conditions.setter
    def trigger_conditions(self, value: pulumi.Input[Sequence[pulumi.Input['DiAlarmRuleTriggerConditionArgs']]]):
        pulumi.set(self, "trigger_conditions", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)


@pulumi.input_type
class _DiAlarmRuleState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 di_alarm_rule_id: Optional[pulumi.Input[_builtins.int]] = None,
                 di_alarm_rule_name: Optional[pulumi.Input[_builtins.str]] = None,
                 di_job_id: Optional[pulumi.Input[_builtins.int]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 metric_type: Optional[pulumi.Input[_builtins.str]] = None,
                 notification_settings: Optional[pulumi.Input['DiAlarmRuleNotificationSettingsArgs']] = None,
                 trigger_conditions: Optional[pulumi.Input[Sequence[pulumi.Input['DiAlarmRuleTriggerConditionArgs']]]] = None):
        """
        Input properties used for looking up and filtering DiAlarmRule resources.
        :param pulumi.Input[_builtins.int] di_alarm_rule_id: Resource attribute field representing resource level ID
        :param pulumi.Input[_builtins.str] di_alarm_rule_name: Data Integration alarm rule name
        :param pulumi.Input[_builtins.int] di_job_id: Task ID: the ID of the task associated with the alert rule.
        :param pulumi.Input[_builtins.str] metric_type: Alarm indicator type. Optional enumerated values:
               - Heartbeat (task status alarm)
               - FailoverCount(failover times alarm)
               - Delay (task Delay alarm)
        :param pulumi.Input['DiAlarmRuleNotificationSettingsArgs'] notification_settings: Alarm notification settings See `notification_settings` below.
        :param pulumi.Input[Sequence[pulumi.Input['DiAlarmRuleTriggerConditionArgs']]] trigger_conditions: Alarm trigger condition list, supporting multiple conditions See `trigger_conditions` below.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if di_alarm_rule_id is not None:
            pulumi.set(__self__, "di_alarm_rule_id", di_alarm_rule_id)
        if di_alarm_rule_name is not None:
            pulumi.set(__self__, "di_alarm_rule_name", di_alarm_rule_name)
        if di_job_id is not None:
            pulumi.set(__self__, "di_job_id", di_job_id)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if metric_type is not None:
            pulumi.set(__self__, "metric_type", metric_type)
        if notification_settings is not None:
            pulumi.set(__self__, "notification_settings", notification_settings)
        if trigger_conditions is not None:
            pulumi.set(__self__, "trigger_conditions", trigger_conditions)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="diAlarmRuleId")
    def di_alarm_rule_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Resource attribute field representing resource level ID
        """
        return pulumi.get(self, "di_alarm_rule_id")

    @di_alarm_rule_id.setter
    def di_alarm_rule_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "di_alarm_rule_id", value)

    @_builtins.property
    @pulumi.getter(name="diAlarmRuleName")
    def di_alarm_rule_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Data Integration alarm rule name
        """
        return pulumi.get(self, "di_alarm_rule_name")

    @di_alarm_rule_name.setter
    def di_alarm_rule_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "di_alarm_rule_name", value)

    @_builtins.property
    @pulumi.getter(name="diJobId")
    def di_job_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Task ID: the ID of the task associated with the alert rule.
        """
        return pulumi.get(self, "di_job_id")

    @di_job_id.setter
    def di_job_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "di_job_id", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="metricType")
    def metric_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Alarm indicator type. Optional enumerated values:
        - Heartbeat (task status alarm)
        - FailoverCount(failover times alarm)
        - Delay (task Delay alarm)
        """
        return pulumi.get(self, "metric_type")

    @metric_type.setter
    def metric_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "metric_type", value)

    @_builtins.property
    @pulumi.getter(name="notificationSettings")
    def notification_settings(self) -> Optional[pulumi.Input['DiAlarmRuleNotificationSettingsArgs']]:
        """
        Alarm notification settings See `notification_settings` below.
        """
        return pulumi.get(self, "notification_settings")

    @notification_settings.setter
    def notification_settings(self, value: Optional[pulumi.Input['DiAlarmRuleNotificationSettingsArgs']]):
        pulumi.set(self, "notification_settings", value)

    @_builtins.property
    @pulumi.getter(name="triggerConditions")
    def trigger_conditions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DiAlarmRuleTriggerConditionArgs']]]]:
        """
        Alarm trigger condition list, supporting multiple conditions See `trigger_conditions` below.
        """
        return pulumi.get(self, "trigger_conditions")

    @trigger_conditions.setter
    def trigger_conditions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DiAlarmRuleTriggerConditionArgs']]]]):
        pulumi.set(self, "trigger_conditions", value)


@pulumi.type_token("alicloud:dataworks/diAlarmRule:DiAlarmRule")
class DiAlarmRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 di_alarm_rule_name: Optional[pulumi.Input[_builtins.str]] = None,
                 di_job_id: Optional[pulumi.Input[_builtins.int]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 metric_type: Optional[pulumi.Input[_builtins.str]] = None,
                 notification_settings: Optional[pulumi.Input[Union['DiAlarmRuleNotificationSettingsArgs', 'DiAlarmRuleNotificationSettingsArgsDict']]] = None,
                 trigger_conditions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DiAlarmRuleTriggerConditionArgs', 'DiAlarmRuleTriggerConditionArgsDict']]]]] = None,
                 __props__=None):
        """
        Provides a Data Works Di Alarm Rule resource.

        Data Integration alarm rules.

        For information about Data Works Di Alarm Rule and how to use it, see [What is Di Alarm Rule](https://www.alibabacloud.com/help/en/dataworks/developer-reference/api-dataworks-public-2024-05-18-createdialarmrule).

        > **NOTE:** Available since v1.241.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform_example"
        defaulte_nv8bu = alicloud.dataworks.Project("defaulteNv8bu",
            project_name=name,
            display_name=name,
            description=name,
            pai_task_enabled=True)
        default_uw8inp = alicloud.dataworks.DiJob("defaultUW8inp",
            description="xxxx",
            project_id=defaulte_nv8bu.id,
            job_name="xxx",
            migration_type="api_xxx",
            source_data_source_type="xxx",
            resource_settings={
                "offline_resource_settings": {
                    "requested_cu": 2,
                    "resource_group_identifier": "xx",
                },
                "realtime_resource_settings": {
                    "requested_cu": 2,
                    "resource_group_identifier": "xx",
                },
                "schedule_resource_settings": {
                    "requested_cu": 2,
                    "resource_group_identifier": "xx",
                },
            },
            job_settings={
                "channel_settings": "xxxx",
                "column_data_type_settings": [{
                    "destination_data_type": "xxxx",
                    "source_data_type": "xxxx",
                }],
                "cycle_schedule_settings": {
                    "cycle_migration_type": "xxxx",
                    "schedule_parameters": "xxxx",
                },
            },
            source_data_source_settings=[{
                "data_source_name": "xxxx",
                "data_source_properties": {
                    "encoding": "xxxx",
                    "timezone": "xxxx",
                },
            }],
            destination_data_source_type="xxxx",
            table_mappings=[{
                "source_object_selection_rules": [
                    {
                        "action": "Include",
                        "expression": "xxxx",
                        "expression_type": "Exact",
                        "object_type": "xxxx",
                    },
                    {
                        "action": "Include",
                        "expression": "xxxx",
                        "expression_type": "Exact",
                        "object_type": "xxxx",
                    },
                ],
                "transformation_rules": [{
                    "rule_name": "xxxx",
                    "rule_action_type": "xxxx",
                    "rule_target_type": "xxxx",
                }],
            }],
            transformation_rules=[{
                "rule_action_type": "xxxx",
                "rule_expression": "xxxx",
                "rule_name": "xxxx",
                "rule_target_type": "xxxx",
            }],
            destination_data_source_settings=[{
                "data_source_name": "xxx",
            }])
        default = alicloud.dataworks.DiAlarmRule("default",
            description="Description",
            trigger_conditions=[{
                "ddl_report_tags": ["ALTERADDCOLUMN"],
                "threshold": 20,
                "duration": 10,
                "severity": "Warning",
            }],
            metric_type="DdlReport",
            notification_settings={
                "notification_channels": [{
                    "severity": "Warning",
                    "channels": ["Ding"],
                }],
                "notification_receivers": [{
                    "receiver_type": "DingToken",
                    "receiver_values": ["1107550004253538"],
                }],
                "inhibition_interval": 10,
            },
            di_job_id=default_uw8inp.di_job_id,
            di_alarm_rule_name=name)
        ```

        ## Import

        Data Works Di Alarm Rule can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:dataworks/diAlarmRule:DiAlarmRule example <di_job_id>:<di_alarm_rule_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] di_alarm_rule_name: Data Integration alarm rule name
        :param pulumi.Input[_builtins.int] di_job_id: Task ID: the ID of the task associated with the alert rule.
        :param pulumi.Input[_builtins.str] metric_type: Alarm indicator type. Optional enumerated values:
               - Heartbeat (task status alarm)
               - FailoverCount(failover times alarm)
               - Delay (task Delay alarm)
        :param pulumi.Input[Union['DiAlarmRuleNotificationSettingsArgs', 'DiAlarmRuleNotificationSettingsArgsDict']] notification_settings: Alarm notification settings See `notification_settings` below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DiAlarmRuleTriggerConditionArgs', 'DiAlarmRuleTriggerConditionArgsDict']]]] trigger_conditions: Alarm trigger condition list, supporting multiple conditions See `trigger_conditions` below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DiAlarmRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Data Works Di Alarm Rule resource.

        Data Integration alarm rules.

        For information about Data Works Di Alarm Rule and how to use it, see [What is Di Alarm Rule](https://www.alibabacloud.com/help/en/dataworks/developer-reference/api-dataworks-public-2024-05-18-createdialarmrule).

        > **NOTE:** Available since v1.241.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform_example"
        defaulte_nv8bu = alicloud.dataworks.Project("defaulteNv8bu",
            project_name=name,
            display_name=name,
            description=name,
            pai_task_enabled=True)
        default_uw8inp = alicloud.dataworks.DiJob("defaultUW8inp",
            description="xxxx",
            project_id=defaulte_nv8bu.id,
            job_name="xxx",
            migration_type="api_xxx",
            source_data_source_type="xxx",
            resource_settings={
                "offline_resource_settings": {
                    "requested_cu": 2,
                    "resource_group_identifier": "xx",
                },
                "realtime_resource_settings": {
                    "requested_cu": 2,
                    "resource_group_identifier": "xx",
                },
                "schedule_resource_settings": {
                    "requested_cu": 2,
                    "resource_group_identifier": "xx",
                },
            },
            job_settings={
                "channel_settings": "xxxx",
                "column_data_type_settings": [{
                    "destination_data_type": "xxxx",
                    "source_data_type": "xxxx",
                }],
                "cycle_schedule_settings": {
                    "cycle_migration_type": "xxxx",
                    "schedule_parameters": "xxxx",
                },
            },
            source_data_source_settings=[{
                "data_source_name": "xxxx",
                "data_source_properties": {
                    "encoding": "xxxx",
                    "timezone": "xxxx",
                },
            }],
            destination_data_source_type="xxxx",
            table_mappings=[{
                "source_object_selection_rules": [
                    {
                        "action": "Include",
                        "expression": "xxxx",
                        "expression_type": "Exact",
                        "object_type": "xxxx",
                    },
                    {
                        "action": "Include",
                        "expression": "xxxx",
                        "expression_type": "Exact",
                        "object_type": "xxxx",
                    },
                ],
                "transformation_rules": [{
                    "rule_name": "xxxx",
                    "rule_action_type": "xxxx",
                    "rule_target_type": "xxxx",
                }],
            }],
            transformation_rules=[{
                "rule_action_type": "xxxx",
                "rule_expression": "xxxx",
                "rule_name": "xxxx",
                "rule_target_type": "xxxx",
            }],
            destination_data_source_settings=[{
                "data_source_name": "xxx",
            }])
        default = alicloud.dataworks.DiAlarmRule("default",
            description="Description",
            trigger_conditions=[{
                "ddl_report_tags": ["ALTERADDCOLUMN"],
                "threshold": 20,
                "duration": 10,
                "severity": "Warning",
            }],
            metric_type="DdlReport",
            notification_settings={
                "notification_channels": [{
                    "severity": "Warning",
                    "channels": ["Ding"],
                }],
                "notification_receivers": [{
                    "receiver_type": "DingToken",
                    "receiver_values": ["1107550004253538"],
                }],
                "inhibition_interval": 10,
            },
            di_job_id=default_uw8inp.di_job_id,
            di_alarm_rule_name=name)
        ```

        ## Import

        Data Works Di Alarm Rule can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:dataworks/diAlarmRule:DiAlarmRule example <di_job_id>:<di_alarm_rule_id>
        ```

        :param str resource_name: The name of the resource.
        :param DiAlarmRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DiAlarmRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 di_alarm_rule_name: Optional[pulumi.Input[_builtins.str]] = None,
                 di_job_id: Optional[pulumi.Input[_builtins.int]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 metric_type: Optional[pulumi.Input[_builtins.str]] = None,
                 notification_settings: Optional[pulumi.Input[Union['DiAlarmRuleNotificationSettingsArgs', 'DiAlarmRuleNotificationSettingsArgsDict']]] = None,
                 trigger_conditions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DiAlarmRuleTriggerConditionArgs', 'DiAlarmRuleTriggerConditionArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DiAlarmRuleArgs.__new__(DiAlarmRuleArgs)

            __props__.__dict__["description"] = description
            if di_alarm_rule_name is None and not opts.urn:
                raise TypeError("Missing required property 'di_alarm_rule_name'")
            __props__.__dict__["di_alarm_rule_name"] = di_alarm_rule_name
            if di_job_id is None and not opts.urn:
                raise TypeError("Missing required property 'di_job_id'")
            __props__.__dict__["di_job_id"] = di_job_id
            __props__.__dict__["enabled"] = enabled
            if metric_type is None and not opts.urn:
                raise TypeError("Missing required property 'metric_type'")
            __props__.__dict__["metric_type"] = metric_type
            if notification_settings is None and not opts.urn:
                raise TypeError("Missing required property 'notification_settings'")
            __props__.__dict__["notification_settings"] = notification_settings
            if trigger_conditions is None and not opts.urn:
                raise TypeError("Missing required property 'trigger_conditions'")
            __props__.__dict__["trigger_conditions"] = trigger_conditions
            __props__.__dict__["di_alarm_rule_id"] = None
        super(DiAlarmRule, __self__).__init__(
            'alicloud:dataworks/diAlarmRule:DiAlarmRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            di_alarm_rule_id: Optional[pulumi.Input[_builtins.int]] = None,
            di_alarm_rule_name: Optional[pulumi.Input[_builtins.str]] = None,
            di_job_id: Optional[pulumi.Input[_builtins.int]] = None,
            enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            metric_type: Optional[pulumi.Input[_builtins.str]] = None,
            notification_settings: Optional[pulumi.Input[Union['DiAlarmRuleNotificationSettingsArgs', 'DiAlarmRuleNotificationSettingsArgsDict']]] = None,
            trigger_conditions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DiAlarmRuleTriggerConditionArgs', 'DiAlarmRuleTriggerConditionArgsDict']]]]] = None) -> 'DiAlarmRule':
        """
        Get an existing DiAlarmRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] di_alarm_rule_id: Resource attribute field representing resource level ID
        :param pulumi.Input[_builtins.str] di_alarm_rule_name: Data Integration alarm rule name
        :param pulumi.Input[_builtins.int] di_job_id: Task ID: the ID of the task associated with the alert rule.
        :param pulumi.Input[_builtins.str] metric_type: Alarm indicator type. Optional enumerated values:
               - Heartbeat (task status alarm)
               - FailoverCount(failover times alarm)
               - Delay (task Delay alarm)
        :param pulumi.Input[Union['DiAlarmRuleNotificationSettingsArgs', 'DiAlarmRuleNotificationSettingsArgsDict']] notification_settings: Alarm notification settings See `notification_settings` below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DiAlarmRuleTriggerConditionArgs', 'DiAlarmRuleTriggerConditionArgsDict']]]] trigger_conditions: Alarm trigger condition list, supporting multiple conditions See `trigger_conditions` below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DiAlarmRuleState.__new__(_DiAlarmRuleState)

        __props__.__dict__["description"] = description
        __props__.__dict__["di_alarm_rule_id"] = di_alarm_rule_id
        __props__.__dict__["di_alarm_rule_name"] = di_alarm_rule_name
        __props__.__dict__["di_job_id"] = di_job_id
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["metric_type"] = metric_type
        __props__.__dict__["notification_settings"] = notification_settings
        __props__.__dict__["trigger_conditions"] = trigger_conditions
        return DiAlarmRule(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="diAlarmRuleId")
    def di_alarm_rule_id(self) -> pulumi.Output[_builtins.int]:
        """
        Resource attribute field representing resource level ID
        """
        return pulumi.get(self, "di_alarm_rule_id")

    @_builtins.property
    @pulumi.getter(name="diAlarmRuleName")
    def di_alarm_rule_name(self) -> pulumi.Output[_builtins.str]:
        """
        Data Integration alarm rule name
        """
        return pulumi.get(self, "di_alarm_rule_name")

    @_builtins.property
    @pulumi.getter(name="diJobId")
    def di_job_id(self) -> pulumi.Output[_builtins.int]:
        """
        Task ID: the ID of the task associated with the alert rule.
        """
        return pulumi.get(self, "di_job_id")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="metricType")
    def metric_type(self) -> pulumi.Output[_builtins.str]:
        """
        Alarm indicator type. Optional enumerated values:
        - Heartbeat (task status alarm)
        - FailoverCount(failover times alarm)
        - Delay (task Delay alarm)
        """
        return pulumi.get(self, "metric_type")

    @_builtins.property
    @pulumi.getter(name="notificationSettings")
    def notification_settings(self) -> pulumi.Output['outputs.DiAlarmRuleNotificationSettings']:
        """
        Alarm notification settings See `notification_settings` below.
        """
        return pulumi.get(self, "notification_settings")

    @_builtins.property
    @pulumi.getter(name="triggerConditions")
    def trigger_conditions(self) -> pulumi.Output[Sequence['outputs.DiAlarmRuleTriggerCondition']]:
        """
        Alarm trigger condition list, supporting multiple conditions See `trigger_conditions` below.
        """
        return pulumi.get(self, "trigger_conditions")

