# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['DdosCooInstanceArgs', 'DdosCooInstance']

@pulumi.input_type
class DdosCooInstanceArgs:
    def __init__(__self__, *,
                 domain_count: pulumi.Input[_builtins.str],
                 port_count: pulumi.Input[_builtins.str],
                 address_type: Optional[pulumi.Input[_builtins.str]] = None,
                 bandwidth: Optional[pulumi.Input[_builtins.str]] = None,
                 bandwidth_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 base_bandwidth: Optional[pulumi.Input[_builtins.str]] = None,
                 edition_sale: Optional[pulumi.Input[_builtins.str]] = None,
                 function_version: Optional[pulumi.Input[_builtins.str]] = None,
                 modify_type: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 normal_bandwidth: Optional[pulumi.Input[_builtins.str]] = None,
                 normal_qps: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 product_plan: Optional[pulumi.Input[_builtins.str]] = None,
                 product_type: Optional[pulumi.Input[_builtins.str]] = None,
                 service_bandwidth: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a DdosCooInstance resource.
        :param pulumi.Input[_builtins.str] domain_count: Domain retransmission rule count of the instance. At least 50. Increase 5 per step, such as 55, 60, 65. Only support upgrade.
        :param pulumi.Input[_builtins.str] port_count: Port retransmission rule count of the instance. At least 50. Increase 5 per step, such as 55, 60, 65. Only support upgrade.
        :param pulumi.Input[_builtins.str] address_type: The IP version of the IP address. Default value: `Ipv4`. Valid values: `Ipv4`, `Ipv6`. **NOTE:** `address_type` is valid only when `product_type` is set to `ddoscoo` or `ddoscoo_intl`.
        :param pulumi.Input[_builtins.str] bandwidth: Elastic defend bandwidth of the instance. This value must be larger than the base defend bandwidth. Valid values: `30`, `60`, `100`, `300`, `400`, `500`, `600`. The unit is Gbps. Only support upgrade. **NOTE:** `bandwidth` is valid only when `product_type` is set to `ddoscoo` or `ddoscoo_intl`.
        :param pulumi.Input[_builtins.str] bandwidth_mode: The mitigation plan of the instance. Valid values:
        :param pulumi.Input[_builtins.str] base_bandwidth: Base defend bandwidth of the instance. Valid values: `30`, `60`, `100`, `300`, `400`, `500`, `600`. The unit is Gbps. Only support upgrade. **NOTE:** `base_bandwidth` is valid only when `product_type` is set to `ddoscoo` or `ddoscoo_intl`.
        :param pulumi.Input[_builtins.str] edition_sale: The mitigation plan of the instance. Default value: `coop`. Valid values:
        :param pulumi.Input[_builtins.str] function_version: The function plan of the instance. Valid values:
        :param pulumi.Input[_builtins.str] modify_type: The type of modification. Valid values: `UPGRADE`, `DOWNGRADE`.
        :param pulumi.Input[_builtins.str] name: Name of the instance. This name can have a string of `1` to `64` characters.
        :param pulumi.Input[_builtins.str] normal_bandwidth: The clean bandwidth provided by the instance. **NOTE:** `normal_bandwidth` is valid only when `product_type` is set to `ddosDip`. From version 1.248.0, `normal_bandwidth` can be modified.
        :param pulumi.Input[_builtins.str] normal_qps: The clean QPS provided by the instance. **NOTE:** `normal_qps` is valid only when `product_type` is set to `ddosDip`. From version 1.248.0, `normal_qps` can be modified.
        :param pulumi.Input[_builtins.int] period: The duration that you will buy DdosCoo instance (in month). Valid values: [1~9], `12`, `24`, `36`. Default value: `1`. At present, the provider does not support modify `period`.
        :param pulumi.Input[_builtins.str] product_plan: The mitigation plan of the instance. Valid values:
        :param pulumi.Input[_builtins.str] product_type: The product type for purchasing DDOSCOO instances used to differ different account type. Default value: `ddoscoo`. Valid values:
        :param pulumi.Input[_builtins.str] service_bandwidth: Business bandwidth of the instance. At leaset 100. Increased 100 per step, such as 100, 200, 300. The unit is Mbps. Only support upgrade. **NOTE:** `service_bandwidth` is valid only when `product_type` is set to `ddoscoo` or `ddoscoo_intl`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        """
        pulumi.set(__self__, "domain_count", domain_count)
        pulumi.set(__self__, "port_count", port_count)
        if address_type is not None:
            pulumi.set(__self__, "address_type", address_type)
        if bandwidth is not None:
            pulumi.set(__self__, "bandwidth", bandwidth)
        if bandwidth_mode is not None:
            pulumi.set(__self__, "bandwidth_mode", bandwidth_mode)
        if base_bandwidth is not None:
            pulumi.set(__self__, "base_bandwidth", base_bandwidth)
        if edition_sale is not None:
            pulumi.set(__self__, "edition_sale", edition_sale)
        if function_version is not None:
            pulumi.set(__self__, "function_version", function_version)
        if modify_type is not None:
            pulumi.set(__self__, "modify_type", modify_type)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if normal_bandwidth is not None:
            pulumi.set(__self__, "normal_bandwidth", normal_bandwidth)
        if normal_qps is not None:
            pulumi.set(__self__, "normal_qps", normal_qps)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if product_plan is not None:
            pulumi.set(__self__, "product_plan", product_plan)
        if product_type is not None:
            pulumi.set(__self__, "product_type", product_type)
        if service_bandwidth is not None:
            pulumi.set(__self__, "service_bandwidth", service_bandwidth)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="domainCount")
    def domain_count(self) -> pulumi.Input[_builtins.str]:
        """
        Domain retransmission rule count of the instance. At least 50. Increase 5 per step, such as 55, 60, 65. Only support upgrade.
        """
        return pulumi.get(self, "domain_count")

    @domain_count.setter
    def domain_count(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "domain_count", value)

    @_builtins.property
    @pulumi.getter(name="portCount")
    def port_count(self) -> pulumi.Input[_builtins.str]:
        """
        Port retransmission rule count of the instance. At least 50. Increase 5 per step, such as 55, 60, 65. Only support upgrade.
        """
        return pulumi.get(self, "port_count")

    @port_count.setter
    def port_count(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "port_count", value)

    @_builtins.property
    @pulumi.getter(name="addressType")
    def address_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IP version of the IP address. Default value: `Ipv4`. Valid values: `Ipv4`, `Ipv6`. **NOTE:** `address_type` is valid only when `product_type` is set to `ddoscoo` or `ddoscoo_intl`.
        """
        return pulumi.get(self, "address_type")

    @address_type.setter
    def address_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "address_type", value)

    @_builtins.property
    @pulumi.getter
    def bandwidth(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Elastic defend bandwidth of the instance. This value must be larger than the base defend bandwidth. Valid values: `30`, `60`, `100`, `300`, `400`, `500`, `600`. The unit is Gbps. Only support upgrade. **NOTE:** `bandwidth` is valid only when `product_type` is set to `ddoscoo` or `ddoscoo_intl`.
        """
        return pulumi.get(self, "bandwidth")

    @bandwidth.setter
    def bandwidth(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bandwidth", value)

    @_builtins.property
    @pulumi.getter(name="bandwidthMode")
    def bandwidth_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The mitigation plan of the instance. Valid values:
        """
        return pulumi.get(self, "bandwidth_mode")

    @bandwidth_mode.setter
    def bandwidth_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bandwidth_mode", value)

    @_builtins.property
    @pulumi.getter(name="baseBandwidth")
    def base_bandwidth(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Base defend bandwidth of the instance. Valid values: `30`, `60`, `100`, `300`, `400`, `500`, `600`. The unit is Gbps. Only support upgrade. **NOTE:** `base_bandwidth` is valid only when `product_type` is set to `ddoscoo` or `ddoscoo_intl`.
        """
        return pulumi.get(self, "base_bandwidth")

    @base_bandwidth.setter
    def base_bandwidth(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "base_bandwidth", value)

    @_builtins.property
    @pulumi.getter(name="editionSale")
    def edition_sale(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The mitigation plan of the instance. Default value: `coop`. Valid values:
        """
        return pulumi.get(self, "edition_sale")

    @edition_sale.setter
    def edition_sale(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "edition_sale", value)

    @_builtins.property
    @pulumi.getter(name="functionVersion")
    def function_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The function plan of the instance. Valid values:
        """
        return pulumi.get(self, "function_version")

    @function_version.setter
    def function_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "function_version", value)

    @_builtins.property
    @pulumi.getter(name="modifyType")
    def modify_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of modification. Valid values: `UPGRADE`, `DOWNGRADE`.
        """
        return pulumi.get(self, "modify_type")

    @modify_type.setter
    def modify_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "modify_type", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the instance. This name can have a string of `1` to `64` characters.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="normalBandwidth")
    def normal_bandwidth(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The clean bandwidth provided by the instance. **NOTE:** `normal_bandwidth` is valid only when `product_type` is set to `ddosDip`. From version 1.248.0, `normal_bandwidth` can be modified.
        """
        return pulumi.get(self, "normal_bandwidth")

    @normal_bandwidth.setter
    def normal_bandwidth(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "normal_bandwidth", value)

    @_builtins.property
    @pulumi.getter(name="normalQps")
    def normal_qps(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The clean QPS provided by the instance. **NOTE:** `normal_qps` is valid only when `product_type` is set to `ddosDip`. From version 1.248.0, `normal_qps` can be modified.
        """
        return pulumi.get(self, "normal_qps")

    @normal_qps.setter
    def normal_qps(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "normal_qps", value)

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The duration that you will buy DdosCoo instance (in month). Valid values: [1~9], `12`, `24`, `36`. Default value: `1`. At present, the provider does not support modify `period`.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "period", value)

    @_builtins.property
    @pulumi.getter(name="productPlan")
    def product_plan(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The mitigation plan of the instance. Valid values:
        """
        return pulumi.get(self, "product_plan")

    @product_plan.setter
    def product_plan(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "product_plan", value)

    @_builtins.property
    @pulumi.getter(name="productType")
    def product_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The product type for purchasing DDOSCOO instances used to differ different account type. Default value: `ddoscoo`. Valid values:
        """
        return pulumi.get(self, "product_type")

    @product_type.setter
    def product_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "product_type", value)

    @_builtins.property
    @pulumi.getter(name="serviceBandwidth")
    def service_bandwidth(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Business bandwidth of the instance. At leaset 100. Increased 100 per step, such as 100, 200, 300. The unit is Mbps. Only support upgrade. **NOTE:** `service_bandwidth` is valid only when `product_type` is set to `ddoscoo` or `ddoscoo_intl`.
        """
        return pulumi.get(self, "service_bandwidth")

    @service_bandwidth.setter
    def service_bandwidth(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_bandwidth", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _DdosCooInstanceState:
    def __init__(__self__, *,
                 address_type: Optional[pulumi.Input[_builtins.str]] = None,
                 bandwidth: Optional[pulumi.Input[_builtins.str]] = None,
                 bandwidth_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 base_bandwidth: Optional[pulumi.Input[_builtins.str]] = None,
                 create_time: Optional[pulumi.Input[_builtins.int]] = None,
                 domain_count: Optional[pulumi.Input[_builtins.str]] = None,
                 edition_sale: Optional[pulumi.Input[_builtins.str]] = None,
                 function_version: Optional[pulumi.Input[_builtins.str]] = None,
                 ip: Optional[pulumi.Input[_builtins.str]] = None,
                 modify_type: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 normal_bandwidth: Optional[pulumi.Input[_builtins.str]] = None,
                 normal_qps: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 port_count: Optional[pulumi.Input[_builtins.str]] = None,
                 product_plan: Optional[pulumi.Input[_builtins.str]] = None,
                 product_type: Optional[pulumi.Input[_builtins.str]] = None,
                 service_bandwidth: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering DdosCooInstance resources.
        :param pulumi.Input[_builtins.str] address_type: The IP version of the IP address. Default value: `Ipv4`. Valid values: `Ipv4`, `Ipv6`. **NOTE:** `address_type` is valid only when `product_type` is set to `ddoscoo` or `ddoscoo_intl`.
        :param pulumi.Input[_builtins.str] bandwidth: Elastic defend bandwidth of the instance. This value must be larger than the base defend bandwidth. Valid values: `30`, `60`, `100`, `300`, `400`, `500`, `600`. The unit is Gbps. Only support upgrade. **NOTE:** `bandwidth` is valid only when `product_type` is set to `ddoscoo` or `ddoscoo_intl`.
        :param pulumi.Input[_builtins.str] bandwidth_mode: The mitigation plan of the instance. Valid values:
        :param pulumi.Input[_builtins.str] base_bandwidth: Base defend bandwidth of the instance. Valid values: `30`, `60`, `100`, `300`, `400`, `500`, `600`. The unit is Gbps. Only support upgrade. **NOTE:** `base_bandwidth` is valid only when `product_type` is set to `ddoscoo` or `ddoscoo_intl`.
        :param pulumi.Input[_builtins.int] create_time: (Available since v1.248.0) The time when the instance was created.
        :param pulumi.Input[_builtins.str] domain_count: Domain retransmission rule count of the instance. At least 50. Increase 5 per step, such as 55, 60, 65. Only support upgrade.
        :param pulumi.Input[_builtins.str] edition_sale: The mitigation plan of the instance. Default value: `coop`. Valid values:
        :param pulumi.Input[_builtins.str] function_version: The function plan of the instance. Valid values:
        :param pulumi.Input[_builtins.str] ip: (Available since v1.212.0) The IP address of the Instance.
        :param pulumi.Input[_builtins.str] modify_type: The type of modification. Valid values: `UPGRADE`, `DOWNGRADE`.
        :param pulumi.Input[_builtins.str] name: Name of the instance. This name can have a string of `1` to `64` characters.
        :param pulumi.Input[_builtins.str] normal_bandwidth: The clean bandwidth provided by the instance. **NOTE:** `normal_bandwidth` is valid only when `product_type` is set to `ddosDip`. From version 1.248.0, `normal_bandwidth` can be modified.
        :param pulumi.Input[_builtins.str] normal_qps: The clean QPS provided by the instance. **NOTE:** `normal_qps` is valid only when `product_type` is set to `ddosDip`. From version 1.248.0, `normal_qps` can be modified.
        :param pulumi.Input[_builtins.int] period: The duration that you will buy DdosCoo instance (in month). Valid values: [1~9], `12`, `24`, `36`. Default value: `1`. At present, the provider does not support modify `period`.
        :param pulumi.Input[_builtins.str] port_count: Port retransmission rule count of the instance. At least 50. Increase 5 per step, such as 55, 60, 65. Only support upgrade.
        :param pulumi.Input[_builtins.str] product_plan: The mitigation plan of the instance. Valid values:
        :param pulumi.Input[_builtins.str] product_type: The product type for purchasing DDOSCOO instances used to differ different account type. Default value: `ddoscoo`. Valid values:
        :param pulumi.Input[_builtins.str] service_bandwidth: Business bandwidth of the instance. At leaset 100. Increased 100 per step, such as 100, 200, 300. The unit is Mbps. Only support upgrade. **NOTE:** `service_bandwidth` is valid only when `product_type` is set to `ddoscoo` or `ddoscoo_intl`.
        :param pulumi.Input[_builtins.int] status: (Available since v1.248.0) The status of the instance.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        """
        if address_type is not None:
            pulumi.set(__self__, "address_type", address_type)
        if bandwidth is not None:
            pulumi.set(__self__, "bandwidth", bandwidth)
        if bandwidth_mode is not None:
            pulumi.set(__self__, "bandwidth_mode", bandwidth_mode)
        if base_bandwidth is not None:
            pulumi.set(__self__, "base_bandwidth", base_bandwidth)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if domain_count is not None:
            pulumi.set(__self__, "domain_count", domain_count)
        if edition_sale is not None:
            pulumi.set(__self__, "edition_sale", edition_sale)
        if function_version is not None:
            pulumi.set(__self__, "function_version", function_version)
        if ip is not None:
            pulumi.set(__self__, "ip", ip)
        if modify_type is not None:
            pulumi.set(__self__, "modify_type", modify_type)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if normal_bandwidth is not None:
            pulumi.set(__self__, "normal_bandwidth", normal_bandwidth)
        if normal_qps is not None:
            pulumi.set(__self__, "normal_qps", normal_qps)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if port_count is not None:
            pulumi.set(__self__, "port_count", port_count)
        if product_plan is not None:
            pulumi.set(__self__, "product_plan", product_plan)
        if product_type is not None:
            pulumi.set(__self__, "product_type", product_type)
        if service_bandwidth is not None:
            pulumi.set(__self__, "service_bandwidth", service_bandwidth)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="addressType")
    def address_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IP version of the IP address. Default value: `Ipv4`. Valid values: `Ipv4`, `Ipv6`. **NOTE:** `address_type` is valid only when `product_type` is set to `ddoscoo` or `ddoscoo_intl`.
        """
        return pulumi.get(self, "address_type")

    @address_type.setter
    def address_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "address_type", value)

    @_builtins.property
    @pulumi.getter
    def bandwidth(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Elastic defend bandwidth of the instance. This value must be larger than the base defend bandwidth. Valid values: `30`, `60`, `100`, `300`, `400`, `500`, `600`. The unit is Gbps. Only support upgrade. **NOTE:** `bandwidth` is valid only when `product_type` is set to `ddoscoo` or `ddoscoo_intl`.
        """
        return pulumi.get(self, "bandwidth")

    @bandwidth.setter
    def bandwidth(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bandwidth", value)

    @_builtins.property
    @pulumi.getter(name="bandwidthMode")
    def bandwidth_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The mitigation plan of the instance. Valid values:
        """
        return pulumi.get(self, "bandwidth_mode")

    @bandwidth_mode.setter
    def bandwidth_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bandwidth_mode", value)

    @_builtins.property
    @pulumi.getter(name="baseBandwidth")
    def base_bandwidth(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Base defend bandwidth of the instance. Valid values: `30`, `60`, `100`, `300`, `400`, `500`, `600`. The unit is Gbps. Only support upgrade. **NOTE:** `base_bandwidth` is valid only when `product_type` is set to `ddoscoo` or `ddoscoo_intl`.
        """
        return pulumi.get(self, "base_bandwidth")

    @base_bandwidth.setter
    def base_bandwidth(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "base_bandwidth", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Available since v1.248.0) The time when the instance was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="domainCount")
    def domain_count(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Domain retransmission rule count of the instance. At least 50. Increase 5 per step, such as 55, 60, 65. Only support upgrade.
        """
        return pulumi.get(self, "domain_count")

    @domain_count.setter
    def domain_count(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "domain_count", value)

    @_builtins.property
    @pulumi.getter(name="editionSale")
    def edition_sale(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The mitigation plan of the instance. Default value: `coop`. Valid values:
        """
        return pulumi.get(self, "edition_sale")

    @edition_sale.setter
    def edition_sale(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "edition_sale", value)

    @_builtins.property
    @pulumi.getter(name="functionVersion")
    def function_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The function plan of the instance. Valid values:
        """
        return pulumi.get(self, "function_version")

    @function_version.setter
    def function_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "function_version", value)

    @_builtins.property
    @pulumi.getter
    def ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Available since v1.212.0) The IP address of the Instance.
        """
        return pulumi.get(self, "ip")

    @ip.setter
    def ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip", value)

    @_builtins.property
    @pulumi.getter(name="modifyType")
    def modify_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of modification. Valid values: `UPGRADE`, `DOWNGRADE`.
        """
        return pulumi.get(self, "modify_type")

    @modify_type.setter
    def modify_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "modify_type", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the instance. This name can have a string of `1` to `64` characters.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="normalBandwidth")
    def normal_bandwidth(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The clean bandwidth provided by the instance. **NOTE:** `normal_bandwidth` is valid only when `product_type` is set to `ddosDip`. From version 1.248.0, `normal_bandwidth` can be modified.
        """
        return pulumi.get(self, "normal_bandwidth")

    @normal_bandwidth.setter
    def normal_bandwidth(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "normal_bandwidth", value)

    @_builtins.property
    @pulumi.getter(name="normalQps")
    def normal_qps(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The clean QPS provided by the instance. **NOTE:** `normal_qps` is valid only when `product_type` is set to `ddosDip`. From version 1.248.0, `normal_qps` can be modified.
        """
        return pulumi.get(self, "normal_qps")

    @normal_qps.setter
    def normal_qps(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "normal_qps", value)

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The duration that you will buy DdosCoo instance (in month). Valid values: [1~9], `12`, `24`, `36`. Default value: `1`. At present, the provider does not support modify `period`.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "period", value)

    @_builtins.property
    @pulumi.getter(name="portCount")
    def port_count(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Port retransmission rule count of the instance. At least 50. Increase 5 per step, such as 55, 60, 65. Only support upgrade.
        """
        return pulumi.get(self, "port_count")

    @port_count.setter
    def port_count(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "port_count", value)

    @_builtins.property
    @pulumi.getter(name="productPlan")
    def product_plan(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The mitigation plan of the instance. Valid values:
        """
        return pulumi.get(self, "product_plan")

    @product_plan.setter
    def product_plan(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "product_plan", value)

    @_builtins.property
    @pulumi.getter(name="productType")
    def product_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The product type for purchasing DDOSCOO instances used to differ different account type. Default value: `ddoscoo`. Valid values:
        """
        return pulumi.get(self, "product_type")

    @product_type.setter
    def product_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "product_type", value)

    @_builtins.property
    @pulumi.getter(name="serviceBandwidth")
    def service_bandwidth(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Business bandwidth of the instance. At leaset 100. Increased 100 per step, such as 100, 200, 300. The unit is Mbps. Only support upgrade. **NOTE:** `service_bandwidth` is valid only when `product_type` is set to `ddoscoo` or `ddoscoo_intl`.
        """
        return pulumi.get(self, "service_bandwidth")

    @service_bandwidth.setter
    def service_bandwidth(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_bandwidth", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Available since v1.248.0) The status of the instance.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("alicloud:ddos/ddosCooInstance:DdosCooInstance")
class DdosCooInstance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 address_type: Optional[pulumi.Input[_builtins.str]] = None,
                 bandwidth: Optional[pulumi.Input[_builtins.str]] = None,
                 bandwidth_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 base_bandwidth: Optional[pulumi.Input[_builtins.str]] = None,
                 domain_count: Optional[pulumi.Input[_builtins.str]] = None,
                 edition_sale: Optional[pulumi.Input[_builtins.str]] = None,
                 function_version: Optional[pulumi.Input[_builtins.str]] = None,
                 modify_type: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 normal_bandwidth: Optional[pulumi.Input[_builtins.str]] = None,
                 normal_qps: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 port_count: Optional[pulumi.Input[_builtins.str]] = None,
                 product_plan: Optional[pulumi.Input[_builtins.str]] = None,
                 product_type: Optional[pulumi.Input[_builtins.str]] = None,
                 service_bandwidth: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Provides a BGP-line Anti-DDoS Pro(DdosCoo) Instance resource.

        For information about BGP-line Anti-DDoS Pro(DdosCoo) Instance and how to use it, see [What is Anti-DDoS Pro Instance](https://www.alibabacloud.com/help/en/ddos-protection/latest/create-an-anti-ddos-pro-or-anti-ddos-premium-instance-by-calling-an-api-operation).

        > **NOTE:** Available since v1.37.0.

        > **NOTE:** The endpoint of bssopenapi used only support "business.aliyuncs.com" at present.

        > **NOTE:** From version 1.214.0, if `product_type` is set to `ddoscoo` or `ddoscoo_intl`, the provider `region` should be set to `cn-hangzhou`, and if `product_type` is set to `ddosDip`, the provider `region` should be set to `ap-southeast-1`.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example"
        default = alicloud.ddos.DdosCooInstance("default",
            name=name,
            base_bandwidth="30",
            bandwidth="30",
            service_bandwidth="100",
            port_count="50",
            domain_count="50",
            product_type="ddoscoo",
            period=1)
        ```

        ## Import

        DdosCoo Instance can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:ddos/ddosCooInstance:DdosCooInstance example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] address_type: The IP version of the IP address. Default value: `Ipv4`. Valid values: `Ipv4`, `Ipv6`. **NOTE:** `address_type` is valid only when `product_type` is set to `ddoscoo` or `ddoscoo_intl`.
        :param pulumi.Input[_builtins.str] bandwidth: Elastic defend bandwidth of the instance. This value must be larger than the base defend bandwidth. Valid values: `30`, `60`, `100`, `300`, `400`, `500`, `600`. The unit is Gbps. Only support upgrade. **NOTE:** `bandwidth` is valid only when `product_type` is set to `ddoscoo` or `ddoscoo_intl`.
        :param pulumi.Input[_builtins.str] bandwidth_mode: The mitigation plan of the instance. Valid values:
        :param pulumi.Input[_builtins.str] base_bandwidth: Base defend bandwidth of the instance. Valid values: `30`, `60`, `100`, `300`, `400`, `500`, `600`. The unit is Gbps. Only support upgrade. **NOTE:** `base_bandwidth` is valid only when `product_type` is set to `ddoscoo` or `ddoscoo_intl`.
        :param pulumi.Input[_builtins.str] domain_count: Domain retransmission rule count of the instance. At least 50. Increase 5 per step, such as 55, 60, 65. Only support upgrade.
        :param pulumi.Input[_builtins.str] edition_sale: The mitigation plan of the instance. Default value: `coop`. Valid values:
        :param pulumi.Input[_builtins.str] function_version: The function plan of the instance. Valid values:
        :param pulumi.Input[_builtins.str] modify_type: The type of modification. Valid values: `UPGRADE`, `DOWNGRADE`.
        :param pulumi.Input[_builtins.str] name: Name of the instance. This name can have a string of `1` to `64` characters.
        :param pulumi.Input[_builtins.str] normal_bandwidth: The clean bandwidth provided by the instance. **NOTE:** `normal_bandwidth` is valid only when `product_type` is set to `ddosDip`. From version 1.248.0, `normal_bandwidth` can be modified.
        :param pulumi.Input[_builtins.str] normal_qps: The clean QPS provided by the instance. **NOTE:** `normal_qps` is valid only when `product_type` is set to `ddosDip`. From version 1.248.0, `normal_qps` can be modified.
        :param pulumi.Input[_builtins.int] period: The duration that you will buy DdosCoo instance (in month). Valid values: [1~9], `12`, `24`, `36`. Default value: `1`. At present, the provider does not support modify `period`.
        :param pulumi.Input[_builtins.str] port_count: Port retransmission rule count of the instance. At least 50. Increase 5 per step, such as 55, 60, 65. Only support upgrade.
        :param pulumi.Input[_builtins.str] product_plan: The mitigation plan of the instance. Valid values:
        :param pulumi.Input[_builtins.str] product_type: The product type for purchasing DDOSCOO instances used to differ different account type. Default value: `ddoscoo`. Valid values:
        :param pulumi.Input[_builtins.str] service_bandwidth: Business bandwidth of the instance. At leaset 100. Increased 100 per step, such as 100, 200, 300. The unit is Mbps. Only support upgrade. **NOTE:** `service_bandwidth` is valid only when `product_type` is set to `ddoscoo` or `ddoscoo_intl`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DdosCooInstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a BGP-line Anti-DDoS Pro(DdosCoo) Instance resource.

        For information about BGP-line Anti-DDoS Pro(DdosCoo) Instance and how to use it, see [What is Anti-DDoS Pro Instance](https://www.alibabacloud.com/help/en/ddos-protection/latest/create-an-anti-ddos-pro-or-anti-ddos-premium-instance-by-calling-an-api-operation).

        > **NOTE:** Available since v1.37.0.

        > **NOTE:** The endpoint of bssopenapi used only support "business.aliyuncs.com" at present.

        > **NOTE:** From version 1.214.0, if `product_type` is set to `ddoscoo` or `ddoscoo_intl`, the provider `region` should be set to `cn-hangzhou`, and if `product_type` is set to `ddosDip`, the provider `region` should be set to `ap-southeast-1`.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example"
        default = alicloud.ddos.DdosCooInstance("default",
            name=name,
            base_bandwidth="30",
            bandwidth="30",
            service_bandwidth="100",
            port_count="50",
            domain_count="50",
            product_type="ddoscoo",
            period=1)
        ```

        ## Import

        DdosCoo Instance can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:ddos/ddosCooInstance:DdosCooInstance example <id>
        ```

        :param str resource_name: The name of the resource.
        :param DdosCooInstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DdosCooInstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 address_type: Optional[pulumi.Input[_builtins.str]] = None,
                 bandwidth: Optional[pulumi.Input[_builtins.str]] = None,
                 bandwidth_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 base_bandwidth: Optional[pulumi.Input[_builtins.str]] = None,
                 domain_count: Optional[pulumi.Input[_builtins.str]] = None,
                 edition_sale: Optional[pulumi.Input[_builtins.str]] = None,
                 function_version: Optional[pulumi.Input[_builtins.str]] = None,
                 modify_type: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 normal_bandwidth: Optional[pulumi.Input[_builtins.str]] = None,
                 normal_qps: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 port_count: Optional[pulumi.Input[_builtins.str]] = None,
                 product_plan: Optional[pulumi.Input[_builtins.str]] = None,
                 product_type: Optional[pulumi.Input[_builtins.str]] = None,
                 service_bandwidth: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DdosCooInstanceArgs.__new__(DdosCooInstanceArgs)

            __props__.__dict__["address_type"] = address_type
            __props__.__dict__["bandwidth"] = bandwidth
            __props__.__dict__["bandwidth_mode"] = bandwidth_mode
            __props__.__dict__["base_bandwidth"] = base_bandwidth
            if domain_count is None and not opts.urn:
                raise TypeError("Missing required property 'domain_count'")
            __props__.__dict__["domain_count"] = domain_count
            __props__.__dict__["edition_sale"] = edition_sale
            __props__.__dict__["function_version"] = function_version
            __props__.__dict__["modify_type"] = modify_type
            __props__.__dict__["name"] = name
            __props__.__dict__["normal_bandwidth"] = normal_bandwidth
            __props__.__dict__["normal_qps"] = normal_qps
            __props__.__dict__["period"] = period
            if port_count is None and not opts.urn:
                raise TypeError("Missing required property 'port_count'")
            __props__.__dict__["port_count"] = port_count
            __props__.__dict__["product_plan"] = product_plan
            __props__.__dict__["product_type"] = product_type
            __props__.__dict__["service_bandwidth"] = service_bandwidth
            __props__.__dict__["tags"] = tags
            __props__.__dict__["create_time"] = None
            __props__.__dict__["ip"] = None
            __props__.__dict__["status"] = None
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="alicloud:dns/ddosCooInstance:DdosCooInstance")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        super(DdosCooInstance, __self__).__init__(
            'alicloud:ddos/ddosCooInstance:DdosCooInstance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            address_type: Optional[pulumi.Input[_builtins.str]] = None,
            bandwidth: Optional[pulumi.Input[_builtins.str]] = None,
            bandwidth_mode: Optional[pulumi.Input[_builtins.str]] = None,
            base_bandwidth: Optional[pulumi.Input[_builtins.str]] = None,
            create_time: Optional[pulumi.Input[_builtins.int]] = None,
            domain_count: Optional[pulumi.Input[_builtins.str]] = None,
            edition_sale: Optional[pulumi.Input[_builtins.str]] = None,
            function_version: Optional[pulumi.Input[_builtins.str]] = None,
            ip: Optional[pulumi.Input[_builtins.str]] = None,
            modify_type: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            normal_bandwidth: Optional[pulumi.Input[_builtins.str]] = None,
            normal_qps: Optional[pulumi.Input[_builtins.str]] = None,
            period: Optional[pulumi.Input[_builtins.int]] = None,
            port_count: Optional[pulumi.Input[_builtins.str]] = None,
            product_plan: Optional[pulumi.Input[_builtins.str]] = None,
            product_type: Optional[pulumi.Input[_builtins.str]] = None,
            service_bandwidth: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.int]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None) -> 'DdosCooInstance':
        """
        Get an existing DdosCooInstance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] address_type: The IP version of the IP address. Default value: `Ipv4`. Valid values: `Ipv4`, `Ipv6`. **NOTE:** `address_type` is valid only when `product_type` is set to `ddoscoo` or `ddoscoo_intl`.
        :param pulumi.Input[_builtins.str] bandwidth: Elastic defend bandwidth of the instance. This value must be larger than the base defend bandwidth. Valid values: `30`, `60`, `100`, `300`, `400`, `500`, `600`. The unit is Gbps. Only support upgrade. **NOTE:** `bandwidth` is valid only when `product_type` is set to `ddoscoo` or `ddoscoo_intl`.
        :param pulumi.Input[_builtins.str] bandwidth_mode: The mitigation plan of the instance. Valid values:
        :param pulumi.Input[_builtins.str] base_bandwidth: Base defend bandwidth of the instance. Valid values: `30`, `60`, `100`, `300`, `400`, `500`, `600`. The unit is Gbps. Only support upgrade. **NOTE:** `base_bandwidth` is valid only when `product_type` is set to `ddoscoo` or `ddoscoo_intl`.
        :param pulumi.Input[_builtins.int] create_time: (Available since v1.248.0) The time when the instance was created.
        :param pulumi.Input[_builtins.str] domain_count: Domain retransmission rule count of the instance. At least 50. Increase 5 per step, such as 55, 60, 65. Only support upgrade.
        :param pulumi.Input[_builtins.str] edition_sale: The mitigation plan of the instance. Default value: `coop`. Valid values:
        :param pulumi.Input[_builtins.str] function_version: The function plan of the instance. Valid values:
        :param pulumi.Input[_builtins.str] ip: (Available since v1.212.0) The IP address of the Instance.
        :param pulumi.Input[_builtins.str] modify_type: The type of modification. Valid values: `UPGRADE`, `DOWNGRADE`.
        :param pulumi.Input[_builtins.str] name: Name of the instance. This name can have a string of `1` to `64` characters.
        :param pulumi.Input[_builtins.str] normal_bandwidth: The clean bandwidth provided by the instance. **NOTE:** `normal_bandwidth` is valid only when `product_type` is set to `ddosDip`. From version 1.248.0, `normal_bandwidth` can be modified.
        :param pulumi.Input[_builtins.str] normal_qps: The clean QPS provided by the instance. **NOTE:** `normal_qps` is valid only when `product_type` is set to `ddosDip`. From version 1.248.0, `normal_qps` can be modified.
        :param pulumi.Input[_builtins.int] period: The duration that you will buy DdosCoo instance (in month). Valid values: [1~9], `12`, `24`, `36`. Default value: `1`. At present, the provider does not support modify `period`.
        :param pulumi.Input[_builtins.str] port_count: Port retransmission rule count of the instance. At least 50. Increase 5 per step, such as 55, 60, 65. Only support upgrade.
        :param pulumi.Input[_builtins.str] product_plan: The mitigation plan of the instance. Valid values:
        :param pulumi.Input[_builtins.str] product_type: The product type for purchasing DDOSCOO instances used to differ different account type. Default value: `ddoscoo`. Valid values:
        :param pulumi.Input[_builtins.str] service_bandwidth: Business bandwidth of the instance. At leaset 100. Increased 100 per step, such as 100, 200, 300. The unit is Mbps. Only support upgrade. **NOTE:** `service_bandwidth` is valid only when `product_type` is set to `ddoscoo` or `ddoscoo_intl`.
        :param pulumi.Input[_builtins.int] status: (Available since v1.248.0) The status of the instance.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DdosCooInstanceState.__new__(_DdosCooInstanceState)

        __props__.__dict__["address_type"] = address_type
        __props__.__dict__["bandwidth"] = bandwidth
        __props__.__dict__["bandwidth_mode"] = bandwidth_mode
        __props__.__dict__["base_bandwidth"] = base_bandwidth
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["domain_count"] = domain_count
        __props__.__dict__["edition_sale"] = edition_sale
        __props__.__dict__["function_version"] = function_version
        __props__.__dict__["ip"] = ip
        __props__.__dict__["modify_type"] = modify_type
        __props__.__dict__["name"] = name
        __props__.__dict__["normal_bandwidth"] = normal_bandwidth
        __props__.__dict__["normal_qps"] = normal_qps
        __props__.__dict__["period"] = period
        __props__.__dict__["port_count"] = port_count
        __props__.__dict__["product_plan"] = product_plan
        __props__.__dict__["product_type"] = product_type
        __props__.__dict__["service_bandwidth"] = service_bandwidth
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        return DdosCooInstance(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="addressType")
    def address_type(self) -> pulumi.Output[_builtins.str]:
        """
        The IP version of the IP address. Default value: `Ipv4`. Valid values: `Ipv4`, `Ipv6`. **NOTE:** `address_type` is valid only when `product_type` is set to `ddoscoo` or `ddoscoo_intl`.
        """
        return pulumi.get(self, "address_type")

    @_builtins.property
    @pulumi.getter
    def bandwidth(self) -> pulumi.Output[_builtins.str]:
        """
        Elastic defend bandwidth of the instance. This value must be larger than the base defend bandwidth. Valid values: `30`, `60`, `100`, `300`, `400`, `500`, `600`. The unit is Gbps. Only support upgrade. **NOTE:** `bandwidth` is valid only when `product_type` is set to `ddoscoo` or `ddoscoo_intl`.
        """
        return pulumi.get(self, "bandwidth")

    @_builtins.property
    @pulumi.getter(name="bandwidthMode")
    def bandwidth_mode(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The mitigation plan of the instance. Valid values:
        """
        return pulumi.get(self, "bandwidth_mode")

    @_builtins.property
    @pulumi.getter(name="baseBandwidth")
    def base_bandwidth(self) -> pulumi.Output[_builtins.str]:
        """
        Base defend bandwidth of the instance. Valid values: `30`, `60`, `100`, `300`, `400`, `500`, `600`. The unit is Gbps. Only support upgrade. **NOTE:** `base_bandwidth` is valid only when `product_type` is set to `ddoscoo` or `ddoscoo_intl`.
        """
        return pulumi.get(self, "base_bandwidth")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.int]:
        """
        (Available since v1.248.0) The time when the instance was created.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="domainCount")
    def domain_count(self) -> pulumi.Output[_builtins.str]:
        """
        Domain retransmission rule count of the instance. At least 50. Increase 5 per step, such as 55, 60, 65. Only support upgrade.
        """
        return pulumi.get(self, "domain_count")

    @_builtins.property
    @pulumi.getter(name="editionSale")
    def edition_sale(self) -> pulumi.Output[_builtins.str]:
        """
        The mitigation plan of the instance. Default value: `coop`. Valid values:
        """
        return pulumi.get(self, "edition_sale")

    @_builtins.property
    @pulumi.getter(name="functionVersion")
    def function_version(self) -> pulumi.Output[_builtins.str]:
        """
        The function plan of the instance. Valid values:
        """
        return pulumi.get(self, "function_version")

    @_builtins.property
    @pulumi.getter
    def ip(self) -> pulumi.Output[_builtins.str]:
        """
        (Available since v1.212.0) The IP address of the Instance.
        """
        return pulumi.get(self, "ip")

    @_builtins.property
    @pulumi.getter(name="modifyType")
    def modify_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The type of modification. Valid values: `UPGRADE`, `DOWNGRADE`.
        """
        return pulumi.get(self, "modify_type")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the instance. This name can have a string of `1` to `64` characters.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="normalBandwidth")
    def normal_bandwidth(self) -> pulumi.Output[_builtins.str]:
        """
        The clean bandwidth provided by the instance. **NOTE:** `normal_bandwidth` is valid only when `product_type` is set to `ddosDip`. From version 1.248.0, `normal_bandwidth` can be modified.
        """
        return pulumi.get(self, "normal_bandwidth")

    @_builtins.property
    @pulumi.getter(name="normalQps")
    def normal_qps(self) -> pulumi.Output[_builtins.str]:
        """
        The clean QPS provided by the instance. **NOTE:** `normal_qps` is valid only when `product_type` is set to `ddosDip`. From version 1.248.0, `normal_qps` can be modified.
        """
        return pulumi.get(self, "normal_qps")

    @_builtins.property
    @pulumi.getter
    def period(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The duration that you will buy DdosCoo instance (in month). Valid values: [1~9], `12`, `24`, `36`. Default value: `1`. At present, the provider does not support modify `period`.
        """
        return pulumi.get(self, "period")

    @_builtins.property
    @pulumi.getter(name="portCount")
    def port_count(self) -> pulumi.Output[_builtins.str]:
        """
        Port retransmission rule count of the instance. At least 50. Increase 5 per step, such as 55, 60, 65. Only support upgrade.
        """
        return pulumi.get(self, "port_count")

    @_builtins.property
    @pulumi.getter(name="productPlan")
    def product_plan(self) -> pulumi.Output[_builtins.str]:
        """
        The mitigation plan of the instance. Valid values:
        """
        return pulumi.get(self, "product_plan")

    @_builtins.property
    @pulumi.getter(name="productType")
    def product_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The product type for purchasing DDOSCOO instances used to differ different account type. Default value: `ddoscoo`. Valid values:
        """
        return pulumi.get(self, "product_type")

    @_builtins.property
    @pulumi.getter(name="serviceBandwidth")
    def service_bandwidth(self) -> pulumi.Output[_builtins.str]:
        """
        Business bandwidth of the instance. At leaset 100. Increased 100 per step, such as 100, 200, 300. The unit is Mbps. Only support upgrade. **NOTE:** `service_bandwidth` is valid only when `product_type` is set to `ddoscoo` or `ddoscoo_intl`.
        """
        return pulumi.get(self, "service_bandwidth")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.int]:
        """
        (Available since v1.248.0) The status of the instance.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

